/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TupleSketchThetaInteger$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns the theta value (sampling rate) from a Datasketches TupleSketch.\n    The theta value represents the effective sampling rate of the sketch, between 0.0 and 1.0.\n    The sketch's summary type must be an integer. ", examples="\n    Examples:\n      > SELECT _FUNC_(tuple_sketch_agg_integer(key, summary)) FROM VALUES (1, 1), (2, 2), (3, 3) tab(key, summary);\n       1.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")q\u000b\u0001C!1\")!\r\u0001C!G\")q\r\u0001C!Q\")\u0011\u000f\u0001C)e\")Q\u000f\u0001C!m\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\b\u0013\u0005u4$!A\t\u0002\u0005}d\u0001\u0003\u000e\u001c\u0003\u0003E\t!!!\t\r9#B\u0011AAM\u0011%\tY\nFA\u0001\n\u000b\ni\nC\u0005\u0002 R\t\t\u0011\"!\u0002\"\"I\u0011Q\u0015\u000b\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003g#\u0012\u0011!C\u0005\u0003k\u0013q\u0003V;qY\u0016\u001c6.\u001a;dQRCW\r^1J]R,w-\u001a:\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u0015.gYb\u0004C\u0001\u0016,\u001b\u0005Y\u0012B\u0001\u0017\u001c\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001c\u0003\u001d\u0019w\u000eZ3hK:L!AM\u0018\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"A\u000b\u001b\n\u0005UZ\"!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9\u0001K]8ek\u000e$\bCA\u001fF\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002BO\u00051AH]8pizJ\u0011!O\u0005\u0003\tb\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\na1+\u001a:jC2L'0\u00192mK*\u0011A\tO\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0015B\u0011!fS\u0005\u0003\u0019n\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"\u0001U)\u0011\u0005)\u0002\u0001\"\u0002%\u0004\u0001\u0004Q\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002)B\u0011q'V\u0005\u0003-b\u0012qAQ8pY\u0016\fg.\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0017\t\u0004{ic\u0016BA.H\u0005\r\u0019V-\u001d\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?~\tQ\u0001^=qKNL!!\u00190\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0011\u0004\"!X3\n\u0005\u0019t&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001j!\tQgN\u0004\u0002lYB\u0011q\bO\u0005\u0003[b\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q\u000eO\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0005A\u001b\b\"\u0002;\t\u0001\u0004Q\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0005]T\bCA\u001cy\u0013\tI\bHA\u0002B]fDQa_\u0005A\u0002]\fQ!\u001b8qkR\fAaY8qsR\u0011\u0001K \u0005\b\u0011*\u0001\n\u00111\u0001K\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0001+\u0007)\u000b)a\u000b\u0002\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011!C;oG\",7m[3e\u0015\r\t\t\u0002O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000b\u0003\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006L1a\\A\u0010\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0003E\u00028\u0003_I1!!\r9\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r9\u0018q\u0007\u0005\n\u0003sq\u0011\u0011!a\u0001\u0003[\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA !\u0015\t\t%a\u0012x\u001b\t\t\u0019EC\u0002\u0002Fa\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI%a\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004)\u0006=\u0003\u0002CA\u001d!\u0005\u0005\t\u0019A<\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00037\t)\u0006C\u0005\u0002:E\t\t\u00111\u0001\u0002.\u00051Q-];bYN$2\u0001VA.\u0011!\tIDEA\u0001\u0002\u00049\bf\u0005\u0001\u0002`\u0005\u0015\u0014qMA6\u0003[\n\t(a\u001d\u0002x\u0005e\u0004c\u0001\u0016\u0002b%\u0019\u00111M\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011N\u0001\u0002`*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015dQ&dG-\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011uQ\u0016$\u0018\r\t<bYV,\u0007\u0005K:b[Bd\u0017N\\4!e\u0006$X-\u000b\u0011ge>l\u0007%\u0019\u0011ECR\f7o[3uG\",7\u000f\t+va2,7k[3uG\"t#\u0002\t\u0011!AQCW\r\t;iKR\f\u0007E^1mk\u0016\u0004#/\u001a9sKN,g\u000e^:!i\",\u0007%\u001a4gK\u000e$\u0018N^3!g\u0006l\u0007\u000f\\5oO\u0002\u0012\u0018\r^3!_\u001a\u0004C\u000f[3!g.,Go\u00195-A\t,Go^3f]\u0002\u0002d\u0006\r\u0011b]\u0012\u0004\u0013G\f\u0019/\u0015\u0001\u0002\u0003\u0005\t+iK\u0002\u001a8.\u001a;dQ\u001e\u001a\be];n[\u0006\u0014\u0018\u0010\t;za\u0016\u0004S.^:uA\t,\u0007%\u00198!S:$XmZ3s]\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003_\n\u0011\u0011\u0005\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)iV\u0004H.Z0tW\u0016$8\r[0bO\u001e|\u0016N\u001c;fO\u0016\u0014\bf[3zY\u0001\u001aX/\\7befL\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&\r\u0017!c%b\u0003\u0005\u000b\u001a-AIJC\u0006\t\u00154Y\u0001\u001a\u0014\u0006\t;bE\"ZW-\u001f\u0017!gVlW.\u0019:zSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\f\u0019\u000bA\u0001\nQa\u001a:pkB\f#!!\u001e\u0002\u0019M\\W\r^2i?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005m\u0014!\u0002\u001b/e9\u0002\u0014a\u0006+va2,7k[3uG\"$\u0006.\u001a;b\u0013:$XmZ3s!\tQCcE\u0003\u0015\u0003\u0007\u000by\t\u0005\u0004\u0002\u0006\u0006-%\nU\u0007\u0003\u0003\u000fS1!!#9\u0003\u001d\u0011XO\u001c;j[\u0016LA!!$\u0002\b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002$\u0005\u0011\u0011n\\\u0005\u0004\r\u0006MECAA@\u0003!!xn\u0015;sS:<GCAA\u000e\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0001\u00161\u0015\u0005\u0006\u0011^\u0001\rAS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI+a,\u0011\t]\nYKS\u0005\u0004\u0003[C$AB(qi&|g\u000e\u0003\u0005\u00022b\t\t\u00111\u0001Q\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003o\u0003B!!\b\u0002:&!\u00111XA\u0010\u0005\u0019y%M[3di\u0002")
public class TupleSketchThetaInteger
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(TupleSketchThetaInteger x$0) {
        return TupleSketchThetaInteger$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<TupleSketchThetaInteger, A> g) {
        return TupleSketchThetaInteger$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, TupleSketchThetaInteger> compose(Function1<A$, Expression> g) {
        return TupleSketchThetaInteger$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "tuple_sketch_theta_integer";
    }

    @Override
    public TupleSketchThetaInteger withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public Object nullSafeEval(Object input) {
        byte[] buffer = (byte[])input;
        Sketch<IntegerSummary> sketch = TupleSketchUtils$.MODULE$.heapifyIntegerSketch(buffer, this.prettyName());
        return BoxesRunTime.boxToDouble((double)sketch.getTheta());
    }

    public TupleSketchThetaInteger copy(Expression child) {
        return new TupleSketchThetaInteger(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "TupleSketchThetaInteger";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleSketchThetaInteger;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleSketchThetaInteger)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleSketchThetaInteger tupleSketchThetaInteger = (TupleSketchThetaInteger)x$1;
        Expression expression = this.child();
        Expression expression2 = tupleSketchThetaInteger.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!tupleSketchThetaInteger.canEqual(this)) return false;
        return true;
    }

    public TupleSketchThetaInteger(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

