/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.http.HttpURI;
import org.sparkproject.jetty.http.pathmap.MatchedResource;
import org.sparkproject.jetty.http.pathmap.PathMappings;
import org.sparkproject.jetty.security.AuthenticationState;
import org.sparkproject.jetty.security.Authenticator;
import org.sparkproject.jetty.security.Constraint;
import org.sparkproject.jetty.security.IdentityService;
import org.sparkproject.jetty.security.ServerAuthException;
import org.sparkproject.jetty.security.UserIdentity;
import org.sparkproject.jetty.security.authentication.LoginAuthenticator;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.Session;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.URIUtil;

public class MultiAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(MultiAuthenticator.class);
    public static final String LOGIN_PATH_PARAM = "org.sparkproject.jetty.security.multi.login_path";
    public static final String AUTH_TYPE_ATTR = MultiAuthState.class.getName() + ".AuthType";
    private static final String AUTH_STATE_ATTR = MultiAuthState.class.getName() + ".AuthState";
    private final DefaultAuthenticator _defaultAuthenticator = new DefaultAuthenticator();
    private final PathMappings<Authenticator> _authenticatorsMappings = new PathMappings();
    private String _loginPath;
    private boolean _dispatch;

    public void addAuthenticator(String pathSpec, Authenticator authenticator) {
        this._authenticatorsMappings.put(pathSpec, authenticator);
    }

    @Override
    public void setConfiguration(Authenticator.Configuration configuration) {
        String loginPath = configuration.getParameter(LOGIN_PATH_PARAM);
        if (loginPath != null) {
            this.setLoginPath(loginPath);
        }
        for (Authenticator authenticator : this._authenticatorsMappings.values()) {
            authenticator.setConfiguration(configuration);
        }
    }

    public void setLoginPath(String loginPath) {
        if (loginPath != null) {
            if (!((String)loginPath).startsWith("/")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("login path must start with /");
                }
                loginPath = "/" + (String)loginPath;
            }
            this._loginPath = loginPath;
        }
    }

    public boolean isLoginPage(String uri) {
        return this.matchURI(uri, this._loginPath);
    }

    private boolean matchURI(String uri, String path) {
        int jsc = uri.indexOf(path);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + path.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public void setDispatch(boolean dispatch) {
        this._dispatch = dispatch;
    }

    @Override
    public String getAuthenticationType() {
        return "MULTI";
    }

    @Override
    public UserIdentity login(String username, Object password, Request request, Response response) {
        Authenticator authenticator = this.getAuthenticator(request.getSession(false));
        if (authenticator instanceof LoginAuthenticator) {
            LoginAuthenticator loginAuthenticator = (LoginAuthenticator)authenticator;
            MultiAuthenticator.doLogin(request);
            return loginAuthenticator.login(username, password, request, response);
        }
        return super.login(username, password, request, response);
    }

    @Override
    public void logout(Request request, Response response) {
        Authenticator authenticator = this.getAuthenticator(request.getSession(false));
        if (authenticator instanceof LoginAuthenticator) {
            LoginAuthenticator loginAuthenticator = (LoginAuthenticator)authenticator;
            loginAuthenticator.logout(request, response);
            MultiAuthenticator.doLogout(request);
        }
        super.logout(request, response);
    }

    @Override
    public Constraint.Authorization getConstraintAuthentication(String pathInContext, Constraint.Authorization existing, Function<Boolean, Session> getSession) {
        Session session = getSession.apply(true);
        if (MultiAuthenticator.isLoggedIn(session)) {
            Authenticator authenticator = this.getAuthenticator(session);
            return authenticator.getConstraintAuthentication(pathInContext, existing, getSession);
        }
        Authenticator authenticator = null;
        MatchedResource<Authenticator> matched = this._authenticatorsMappings.getMatched(pathInContext);
        if (matched != null) {
            authenticator = matched.getResource();
        }
        if (authenticator == null) {
            authenticator = this.getAuthenticator(session);
        }
        if (authenticator == null) {
            authenticator = this._defaultAuthenticator;
        }
        this.saveAuthenticator(session, authenticator);
        return authenticator.getConstraintAuthentication(pathInContext, existing, getSession);
    }

    @Override
    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        Session session = request.getSession(true);
        Authenticator authenticator = this.getAuthenticator(session);
        if (authenticator == null) {
            Response.writeError(request, response, callback, 403);
            return AuthenticationState.SEND_FAILURE;
        }
        AuthenticationState authenticationState = authenticator.validateRequest(request, response, callback);
        if (authenticationState instanceof AuthenticationState.ResponseSent) {
            if (authenticationState instanceof LoginAuthenticator.UserAuthenticationSent) {
                MultiAuthenticator.doLogin(request);
            }
            return authenticationState;
        }
        if (authenticationState instanceof AuthenticationState.Succeeded) {
            AuthenticationState.Succeeded succeededState = (AuthenticationState.Succeeded)authenticationState;
            return new MultiSucceededAuthenticationState(succeededState);
        }
        if (authenticationState instanceof AuthenticationState.Deferred) {
            AuthenticationState.Deferred deferredState = (AuthenticationState.Deferred)authenticationState;
            return new MultiDelegateAuthenticationState(deferredState);
        }
        return authenticationState;
    }

    @Override
    public Request prepareRequest(Request request, AuthenticationState authenticationState) {
        Session session = request.getSession(true);
        Authenticator authenticator = this.getAuthenticator(session);
        if (authenticator == null) {
            throw new IllegalStateException("No authenticator found");
        }
        return authenticator.prepareRequest(request, authenticationState);
    }

    private static MultiAuthState getAuthState(Session session) {
        if (session == null) {
            return null;
        }
        return (MultiAuthState)session.getAttribute(AUTH_STATE_ATTR);
    }

    private static MultiAuthState ensureAuthState(Session session) {
        if (session == null) {
            throw new IllegalArgumentException();
        }
        MultiAuthState authState = (MultiAuthState)session.getAttribute(AUTH_STATE_ATTR);
        if (authState == null) {
            authState = new MultiAuthState();
            session.setAttribute(AUTH_STATE_ATTR, authState);
        }
        return authState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoggedIn(Session session) {
        if (session == null) {
            return false;
        }
        Session session2 = session;
        synchronized (session2) {
            MultiAuthState authState = MultiAuthenticator.getAuthState(session);
            return authState != null && authState.isLoggedIn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLogin(Request request) {
        Session session = request.getSession(true);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                MultiAuthState authState = MultiAuthenticator.ensureAuthState(session);
                authState.setLogin(true);
                session.setAttribute(AUTH_TYPE_ATTR, authState.getAuthenticatorType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doLogout(Request request) {
        Session session = request.getSession(false);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                session.removeAttribute(AUTH_STATE_ATTR);
                session.removeAttribute(AUTH_TYPE_ATTR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAuthenticator(Session session, Authenticator authenticator) {
        if (session == null) {
            throw new IllegalArgumentException();
        }
        Session session2 = session;
        synchronized (session2) {
            MultiAuthState authState = MultiAuthenticator.ensureAuthState(session);
            authState.setAuthenticatorName(authenticator.getClass().getName());
            authState.setAuthenticatorType(authenticator.getAuthenticationType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authenticator getAuthenticator(Session session) {
        if (session == null) {
            return null;
        }
        Session session2 = session;
        synchronized (session2) {
            MultiAuthState state = MultiAuthenticator.getAuthState(session);
            if (state == null || state.getAuthenticatorName() == null) {
                return null;
            }
            String name = state.getAuthenticatorName();
            if (this._defaultAuthenticator.getClass().getName().equals(name)) {
                return this._defaultAuthenticator;
            }
            for (Authenticator authenticator : this._authenticatorsMappings.values()) {
                if (!name.equals(authenticator.getClass().getName())) continue;
                return authenticator;
            }
            return null;
        }
    }

    private class DefaultAuthenticator
    implements Authenticator {
        private DefaultAuthenticator() {
        }

        @Override
        public void setConfiguration(Authenticator.Configuration configuration) {
        }

        @Override
        public String getAuthenticationType() {
            return "DEFAULT";
        }

        @Override
        public Constraint.Authorization getConstraintAuthentication(String pathInContext, Constraint.Authorization existing, Function<Boolean, Session> getSession) {
            if (MultiAuthenticator.this.isLoginPage(pathInContext)) {
                return Constraint.Authorization.ALLOWED;
            }
            return existing;
        }

        @Override
        public AuthenticationState validateRequest(Request request, Response response, Callback callback) {
            if (MultiAuthenticator.this._loginPath != null && !response.isCommitted()) {
                String loginPath = URIUtil.addPaths(request.getContext().getContextPath(), MultiAuthenticator.this._loginPath);
                if (MultiAuthenticator.this._dispatch) {
                    HttpURI.Mutable newUri = HttpURI.build(request.getHttpURI()).pathQuery(loginPath);
                    return new AuthenticationState.ServeAs(newUri);
                }
                Session session = request.getSession(true);
                String redirectUri = session.encodeURI(request, loginPath, true);
                Response.sendRedirect(request, response, callback, redirectUri, true);
                return AuthenticationState.CHALLENGE;
            }
            return null;
        }
    }

    private static class MultiSucceededAuthenticationState
    implements AuthenticationState.Succeeded {
        private final AuthenticationState.Succeeded _delegate;

        public MultiSucceededAuthenticationState(AuthenticationState.Succeeded state) {
            this._delegate = state;
        }

        @Override
        public String getAuthenticationType() {
            return this._delegate.getAuthenticationType();
        }

        @Override
        public UserIdentity getUserIdentity() {
            return this._delegate.getUserIdentity();
        }

        @Override
        public Principal getUserPrincipal() {
            return this._delegate.getUserPrincipal();
        }

        @Override
        public boolean isUserInRole(String role) {
            return this._delegate.isUserInRole(role);
        }

        @Override
        public void logout(Request request, Response response) {
            this._delegate.logout(request, response);
            MultiAuthenticator.doLogout(request);
        }
    }

    private static class MultiDelegateAuthenticationState
    implements AuthenticationState.Deferred {
        private final AuthenticationState.Deferred _delegate;

        public MultiDelegateAuthenticationState(AuthenticationState.Deferred state) {
            this._delegate = state;
        }

        @Override
        public AuthenticationState.Succeeded authenticate(Request request) {
            return this._delegate.authenticate(request);
        }

        @Override
        public AuthenticationState authenticate(Request request, Response response, Callback callback) {
            return this._delegate.authenticate(request, response, callback);
        }

        @Override
        public AuthenticationState.Succeeded login(String username, Object password, Request request, Response response) {
            AuthenticationState.Succeeded succeeded = this._delegate.login(username, password, request, response);
            if (succeeded != null) {
                MultiAuthenticator.doLogin(request);
            }
            return succeeded;
        }

        @Override
        public void logout(Request request, Response response) {
            this._delegate.logout(request, response);
            MultiAuthenticator.doLogout(request);
        }

        @Override
        public IdentityService.Association getAssociation() {
            return this._delegate.getAssociation();
        }

        @Override
        public Principal getUserPrincipal() {
            return this._delegate.getUserPrincipal();
        }
    }

    private static class MultiAuthState
    implements Serializable {
        private static final long serialVersionUID = -4292431864385753482L;
        private String _authenticatorName;
        private String _authenticatorType;
        private boolean _isLoggedIn;

        public void setAuthenticatorName(String authenticatorName) {
            this._authenticatorName = authenticatorName;
        }

        public String getAuthenticatorName() {
            return this._authenticatorName;
        }

        public String getAuthenticatorType() {
            return this._authenticatorType;
        }

        public void setAuthenticatorType(String authenticatorType) {
            this._authenticatorType = authenticatorType;
        }

        public void setLogin(boolean isLoggedIn) {
            this._isLoggedIn = isLoggedIn;
        }

        private boolean isLoggedIn() {
            return this._isLoggedIn;
        }
    }
}

