/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.servlet.BaseDtoHandler;
import org.directwebremoting.util.LocalUtil;

public class DtoHandler
extends BaseDtoHandler {
    protected String dtoHandlerUrl;

    @Override
    protected String getBaseDtoPath() {
        return this.dtoHandlerUrl;
    }

    @Override
    public String generateDtoScript(String contextPath, String servletPath, String jsClassName) {
        String script = null;
        String dtojs = this.remoter.generateDtoJavaScript(jsClassName, "    ", "c");
        if (dtojs != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("(function() {\n").append("  var c;\n").append("  if (!dwr.engine._mappedClasses[\"" + jsClassName + "\"]) {\n");
            buffer.append(dtojs).append("    dwr.engine._setObject(\"" + jsClassName + "\", c);\n").append("    dwr.engine._mappedClasses[\"" + jsClassName + "\"] = c;\n");
            NamedConverter namedConv = this.converterManager.getNamedConverter(jsClassName);
            String jsSuperClassName = namedConv.getJavascriptSuperClass();
            if (LocalUtil.hasLength(jsSuperClassName)) {
                String classExpression = "dwr.engine._mappedClasses[\"" + jsClassName + "\"]";
                String superClassExpression = "dwr.engine._mappedClasses[\"" + jsSuperClassName + "\"]";
                buffer.append(this.remoter.generateDtoInheritanceJavaScript("    ", classExpression, superClassExpression, "dwr.engine._delegate"));
            }
            buffer.append("  }\n").append("})();\n");
            script = buffer.toString();
        }
        return script;
    }

    public void setDtoHandlerUrl(String dtoHandlerUrl) {
        this.dtoHandlerUrl = dtoHandlerUrl;
    }
}

