/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadContentTypeException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletDiskFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.apache.struts2.inject.Inject;

public abstract class AbstractMultiPartRequest
implements MultiPartRequest {
    protected static final String STRUTS_MESSAGES_UPLOAD_ERROR_PARAMETER_TOO_LONG_KEY = "struts.messages.upload.error.parameter.too.long";
    private static final Logger LOG = LogManager.getLogger(AbstractMultiPartRequest.class);
    public static final int BUFFER_SIZE = 10240;
    protected List<LocalizedMessage> errors = new ArrayList<LocalizedMessage>();
    protected Long maxSize;
    protected Long maxSizeOfFiles;
    protected Long maxFiles;
    protected Long maxStringLength;
    protected Long maxFileSize;
    protected int bufferSize = 10240;
    protected String defaultEncoding;
    protected Map<String, List<UploadedFile>> uploadedFiles = new HashMap<String, List<UploadedFile>>();
    protected Map<String, List<String>> parameters = new HashMap<String, List<String>>();

    @Inject(value="struts.multipart.bufferSize", required=false)
    public void setBufferSize(String bufferSize) {
        this.bufferSize = Integer.parseInt(bufferSize);
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String enc) {
        this.defaultEncoding = enc;
    }

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    @Inject(value="struts.multipart.maxSizeOfFiles", required=false)
    public void setMaxSizeOfFiles(String maxSizeOfFiles) {
        this.maxSizeOfFiles = Long.parseLong(maxSizeOfFiles);
    }

    @Inject(value="struts.multipart.maxFiles")
    public void setMaxFiles(String maxFiles) {
        this.maxFiles = Long.parseLong(maxFiles);
    }

    @Inject(value="struts.multipart.maxFileSize", required=false)
    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = Long.parseLong(maxFileSize);
    }

    @Inject(value="struts.multipart.maxStringLength")
    public void setMaxStringLength(String maxStringLength) {
        this.maxStringLength = Long.parseLong(maxStringLength);
    }

    protected abstract void processUpload(HttpServletRequest var1, String var2) throws IOException;

    protected Charset readCharsetEncoding(HttpServletRequest request) {
        String charsetStr = StringUtils.isBlank((CharSequence)request.getCharacterEncoding()) ? this.defaultEncoding : request.getCharacterEncoding();
        return Charset.forName(charsetStr);
    }

    protected abstract JakartaServletDiskFileUpload createJakartaFileUpload(Charset var1, Path var2);

    protected JakartaServletDiskFileUpload prepareServletFileUpload(Charset charset, Path saveDir) {
        JakartaServletDiskFileUpload servletFileUpload = this.createJakartaFileUpload(charset, saveDir);
        if (this.maxSize != null) {
            LOG.debug("Applies max size: {} to file upload request", (Object)this.maxSize);
            servletFileUpload.setSizeMax(this.maxSize.longValue());
        }
        if (this.maxFiles != null) {
            LOG.debug("Applies max files number: {} to file upload request", (Object)this.maxFiles);
            servletFileUpload.setFileCountMax(this.maxFiles.longValue());
        }
        if (this.maxFileSize != null) {
            LOG.debug("Applies max size of single file: {} to file upload request", (Object)this.maxFileSize);
            servletFileUpload.setFileSizeMax(this.maxFileSize.longValue());
        }
        return servletFileUpload;
    }

    protected boolean exceedsMaxStringLength(String fieldName, String fieldValue) {
        if (this.maxStringLength != null && (long)fieldValue.length() > this.maxStringLength) {
            LocalizedMessage localizedMessage;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Form field: {} of size: {} bytes exceeds limit of: {}.", (Object)this.sanitizeNewlines(fieldName), (Object)fieldValue.length(), (Object)this.maxStringLength);
            }
            if (!this.errors.contains(localizedMessage = new LocalizedMessage(this.getClass(), STRUTS_MESSAGES_UPLOAD_ERROR_PARAMETER_TOO_LONG_KEY, null, new Object[]{fieldName, this.maxStringLength, fieldValue.length()}))) {
                this.errors.add(localizedMessage);
            }
            return true;
        }
        return false;
    }

    @Override
    public void parse(HttpServletRequest request, String saveDir) throws IOException {
        block11: {
            try {
                this.processUpload(request, saveDir);
            }
            catch (FileUploadException e) {
                LOG.debug("Error parsing the multi-part request!", (Throwable)e);
                Class exClass = FileUploadException.class;
                Object[] args = new Object[]{};
                if (e instanceof FileUploadByteCountLimitException) {
                    FileUploadByteCountLimitException ex = (FileUploadByteCountLimitException)e;
                    exClass = ex.getClass();
                    args = new Object[]{ex.getFieldName(), ex.getFileName(), ex.getPermitted(), ex.getActualSize()};
                } else if (e instanceof FileUploadFileCountLimitException) {
                    FileUploadFileCountLimitException ex = (FileUploadFileCountLimitException)e;
                    exClass = ex.getClass();
                    args = new Object[]{ex.getPermitted(), ex.getActualSize()};
                } else if (e instanceof FileUploadSizeException) {
                    FileUploadSizeException ex = (FileUploadSizeException)e;
                    exClass = ex.getClass();
                    args = new Object[]{ex.getPermitted(), ex.getActualSize()};
                } else if (e instanceof FileUploadContentTypeException) {
                    FileUploadContentTypeException ex = (FileUploadContentTypeException)e;
                    exClass = ex.getClass();
                    args = new Object[]{ex.getContentType()};
                }
                LocalizedMessage errorMessage = this.buildErrorMessage(exClass, e.getMessage(), args);
                if (!this.errors.contains(errorMessage)) {
                    this.errors.add(errorMessage);
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to parse request", (Throwable)e);
                LocalizedMessage errorMessage = this.buildErrorMessage(e.getClass(), e.getMessage(), new Object[0]);
                if (this.errors.contains(errorMessage)) break block11;
                this.errors.add(errorMessage);
            }
        }
    }

    protected LocalizedMessage buildErrorMessage(Class<? extends Throwable> exceptionClass, String defaultMessage, Object[] args) {
        String errorKey = "struts.messages.upload.error." + exceptionClass.getSimpleName();
        LOG.debug("Preparing error message for key: [{}]", (Object)errorKey);
        return new LocalizedMessage(this.getClass(), errorKey, defaultMessage, args);
    }

    protected String getCanonicalName(String originalFileName) {
        return FilenameUtils.getName((String)originalFileName);
    }

    @Deprecated
    protected String sanitizeNewlines(String before) {
        return before.replaceAll("\\R", "_");
    }

    @Override
    public List<LocalizedMessage> getErrors() {
        return this.errors;
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return Collections.enumeration(this.uploadedFiles.keySet());
    }

    @Override
    public String[] getContentType(String fieldName) {
        return (String[])this.uploadedFiles.getOrDefault(fieldName, Collections.emptyList()).stream().map(UploadedFile::getContentType).toArray(String[]::new);
    }

    @Override
    public UploadedFile[] getFile(String fieldName) {
        return (UploadedFile[])this.uploadedFiles.getOrDefault(fieldName, Collections.emptyList()).toArray(UploadedFile[]::new);
    }

    @Override
    public String[] getFileNames(String fieldName) {
        return (String[])this.uploadedFiles.getOrDefault(fieldName, Collections.emptyList()).stream().map(file -> this.getCanonicalName(file.getOriginalName())).toArray(String[]::new);
    }

    @Override
    public String[] getFilesystemName(String fieldName) {
        return (String[])this.uploadedFiles.getOrDefault(fieldName, Collections.emptyList()).stream().map(UploadedFile::getAbsolutePath).toArray(String[]::new);
    }

    @Override
    public String getParameter(String name) {
        List paramValue = this.parameters.getOrDefault(name, Collections.emptyList());
        if (!paramValue.isEmpty()) {
            return (String)paramValue.get(0);
        }
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        try {
            LOG.debug("Performing File Upload temporary storage cleanup.");
            for (List<UploadedFile> uploadedFileList : this.uploadedFiles.values()) {
                for (UploadedFile uploadedFile : uploadedFileList) {
                    if (uploadedFile.isFile()) {
                        LOG.debug("Deleting file: {}", (Object)uploadedFile.getName());
                        if (uploadedFile.delete()) continue;
                        LOG.warn("There was a problem attempting to delete file: {}", (Object)uploadedFile.getName());
                        continue;
                    }
                    LOG.debug("File: {} already deleted", (Object)uploadedFile.getName());
                }
            }
        }
        finally {
            this.uploadedFiles = new HashMap<String, List<UploadedFile>>();
            this.parameters = new HashMap<String, List<String>>();
        }
    }
}

