--
-- Licensed to the Apache Software Foundation (ASF) under one
-- or more contributor license agreements.  See the NOTICE file
-- distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
-- to you under the Apache License, Version 2.0 (the
-- "License"); you may not use this file except in compliance
-- with the License.  You may obtain a copy of the License at
-- 
--   http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing,
-- software distributed under the License is distributed on an
-- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
-- KIND, either express or implied.  See the License for the
-- specific language governing permissions and limitations
-- under the License.
--

--
-- TOC entry 217 (class 1259 OID 16385)
-- Name: accesspolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE accesspolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    jsonconf text
);


--
-- TOC entry 218 (class 1259 OID 16390)
-- Name: accesstoken; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE accesstoken (
    id character varying(255) NOT NULL,
    authorities bytea,
    body text,
    expirationtime timestamp with time zone,
    owner character varying(255)
);


--
-- TOC entry 219 (class 1259 OID 16395)
-- Name: accountpolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE accountpolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    maxauthenticationattempts integer,
    propagatesuspension integer
);


--
-- TOC entry 220 (class 1259 OID 16398)
-- Name: accountpolicy_externalresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE accountpolicy_externalresource (
    accountpolicy_id character varying(36),
    resource_id character varying(255)
);


--
-- TOC entry 221 (class 1259 OID 16401)
-- Name: accountpolicyrule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE accountpolicyrule (
    policy_id character varying(36),
    implementation_id character varying(255)
);


--
-- TOC entry 222 (class 1259 OID 16404)
-- Name: adyngroupmembers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE adyngroupmembers (
    anytype_id character varying(255),
    any_id character(36),
    group_id character(36)
);


--
-- TOC entry 223 (class 1259 OID 16407)
-- Name: adyngroupmembership; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE adyngroupmembership (
    id character varying(36) NOT NULL,
    fiql character varying(255),
    group_id character varying(36),
    anytype_id character varying(255)
);


--
-- TOC entry 224 (class 1259 OID 16412)
-- Name: amembership; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE amembership (
    id character varying(36) NOT NULL,
    anyobject_id character varying(36),
    group_id character varying(36)
);


--
-- TOC entry 225 (class 1259 OID 16415)
-- Name: anyabout; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anyabout (
    id character varying(36) NOT NULL,
    anytype_filter text,
    anytype_id character varying(255),
    notification_id character varying(36)
);


--
-- TOC entry 226 (class 1259 OID 16420)
-- Name: anyobject; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anyobject (
    id character varying(36) NOT NULL,
    creationcontext character varying(255),
    creationdate timestamp with time zone,
    creator character varying(255),
    lastchangecontext character varying(255),
    lastchangedate timestamp with time zone,
    lastmodifier character varying(255),
    status character varying(255),
    name character varying(255),
    plainattrs jsonb,
    realm_id character varying(36),
    type_id character varying(255)
);


--
-- TOC entry 227 (class 1259 OID 16425)
-- Name: anyobject_anytypeclass; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anyobject_anytypeclass (
    anyobject_id character varying(36),
    anytypeclass_id character varying(255)
);


--
-- TOC entry 228 (class 1259 OID 16428)
-- Name: anyobject_externalresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anyobject_externalresource (
    anyobject_id character varying(36),
    resource_id character varying(255)
);


--
-- TOC entry 229 (class 1259 OID 16431)
-- Name: syncopegroup; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopegroup (
    id character varying(36) NOT NULL,
    creationcontext character varying(255),
    creationdate timestamp with time zone,
    creator character varying(255),
    lastchangecontext character varying(255),
    lastchangedate timestamp with time zone,
    lastmodifier character varying(255),
    status character varying(255),
    name character varying(255),
    plainattrs jsonb,
    realm_id character varying(36),
    groupowner_id character varying(36),
    userowner_id character varying(36)
);


--
-- TOC entry 230 (class 1259 OID 16436)
-- Name: anyobject_search_amembership; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW anyobject_search_amembership AS
 SELECT m.anyobject_id AS any_id,
    g.id AS group_id,
    g.name AS group_name
   FROM amembership m,
    syncopegroup g
  WHERE ((m.group_id)::text = (g.id)::text);


--
-- TOC entry 231 (class 1259 OID 16440)
-- Name: arelationship; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE arelationship (
    id character varying(36) NOT NULL,
    left_anyobject_id character varying(36),
    right_anyobject_id character varying(36),
    type_id character varying(255)
);


--
-- TOC entry 232 (class 1259 OID 16443)
-- Name: anyobject_search_arelationship; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW anyobject_search_arelationship AS
 SELECT left_anyobject_id AS any_id,
    right_anyobject_id AS right_any_id,
    type_id AS type
   FROM arelationship m;


--
-- TOC entry 233 (class 1259 OID 16447)
-- Name: anyobject_search_auxclass; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW anyobject_search_auxclass AS
 SELECT anyobject_id AS any_id,
    anytypeclass_id
   FROM anyobject_anytypeclass st;


--
-- TOC entry 234 (class 1259 OID 16451)
-- Name: syncopegroup_externalresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopegroup_externalresource (
    group_id character varying(36),
    resource_id character varying(255)
);


--
-- TOC entry 235 (class 1259 OID 16454)
-- Name: anyobject_search_group_res; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW anyobject_search_group_res AS
 SELECT m.anyobject_id AS any_id,
    st.resource_id
   FROM amembership m,
    syncopegroup r,
    syncopegroup_externalresource st
  WHERE (((m.group_id)::text = (r.id)::text) AND ((st.group_id)::text = (r.id)::text));


--
-- TOC entry 236 (class 1259 OID 16458)
-- Name: anyobject_search_resource; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW anyobject_search_resource AS
 SELECT anyobject_id AS any_id,
    resource_id
   FROM anyobject_externalresource st;


--
-- TOC entry 237 (class 1259 OID 16462)
-- Name: anytemplatepulltask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anytemplatepulltask (
    id character varying(36) NOT NULL,
    template text,
    anytype_id character varying(255),
    pulltask_id character varying(36)
);


--
-- TOC entry 238 (class 1259 OID 16467)
-- Name: anytemplaterealm; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anytemplaterealm (
    id character varying(36) NOT NULL,
    template text,
    realm_id character varying(36),
    anytype_id character varying(255)
);


--
-- TOC entry 239 (class 1259 OID 16472)
-- Name: anytype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anytype (
    id character varying(255) NOT NULL,
    kind character varying(20)
);


--
-- TOC entry 240 (class 1259 OID 16475)
-- Name: anytype_anytypeclass; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anytype_anytypeclass (
    anytype_id character varying(255),
    anytypeclass_id character varying(255)
);


--
-- TOC entry 241 (class 1259 OID 16480)
-- Name: anytypeclass; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE anytypeclass (
    id character varying(255) NOT NULL
);


--
-- TOC entry 242 (class 1259 OID 16483)
-- Name: aplainattr; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE aplainattr (
    id character varying(36) NOT NULL,
    owner_id character varying(36),
    schema_id character varying(255),
    membership_id character varying(36)
);


--
-- TOC entry 243 (class 1259 OID 16486)
-- Name: aplainattruniquevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE aplainattruniquevalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36),
    schema_id character varying(255)
);


--
-- TOC entry 244 (class 1259 OID 16491)
-- Name: aplainattrvalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE aplainattrvalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36)
);


--
-- TOC entry 245 (class 1259 OID 16496)
-- Name: application; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE application (
    id character varying(255) NOT NULL,
    description character varying(255)
);


--
-- TOC entry 246 (class 1259 OID 16501)
-- Name: attrreleasepolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE attrreleasepolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    arporder integer,
    jsonconf text,
    status integer
);


--
-- TOC entry 247 (class 1259 OID 16506)
-- Name: attrrepo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE attrrepo (
    id character varying(255) NOT NULL,
    attrrepoorder integer,
    attrrepostate character varying(20),
    description character varying(255),
    items text,
    jsonconf text
);


--
-- TOC entry 248 (class 1259 OID 16511)
-- Name: auditconf; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE auditconf (
    id character varying(255) NOT NULL,
    active integer
);


--
-- TOC entry 249 (class 1259 OID 16514)
-- Name: auditentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE auditentry (
    event_date timestamp without time zone,
    logger_level character varying(255) NOT NULL,
    logger character varying(255) NOT NULL,
    message jsonb NOT NULL,
    throwable text
);


--
-- TOC entry 250 (class 1259 OID 16519)
-- Name: authmodule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE authmodule (
    id character varying(255) NOT NULL,
    authmoduleorder integer,
    authmodulestate character varying(20),
    description character varying(255),
    items text,
    jsonconf text
);


--
-- TOC entry 251 (class 1259 OID 16524)
-- Name: authpolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE authpolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    jsonconf text
);


--
-- TOC entry 252 (class 1259 OID 16529)
-- Name: authprofile; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE authprofile (
    id character varying(36) NOT NULL,
    googlemfaauthaccounts text,
    googlemfaauthtokens text,
    impersonationaccounts text,
    mfatrusteddevices text,
    owner character varying(255) NOT NULL,
    u2fregistereddevices text,
    webauthndevicecredentials text
);


--
-- TOC entry 253 (class 1259 OID 16534)
-- Name: casspclientapp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE casspclientapp (
    id character varying(36) NOT NULL,
    clientappid bigint NOT NULL,
    description character varying(255),
    informationurl character varying(255),
    logo character varying(255),
    logouttype character varying(20),
    name character varying(255) NOT NULL,
    privacyurl character varying(255),
    properties text,
    theme character varying(255),
    usernameattributeproviderconf text,
    serviceid character varying(255) NOT NULL,
    accesspolicy_id character varying(36),
    attrreleasepolicy_id character varying(36),
    authpolicy_id character varying(36),
    realm_id character varying(36),
    ticketexpirationpolicy_id character varying(36)
);


--
-- TOC entry 254 (class 1259 OID 16539)
-- Name: confparam; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE confparam (
    id character varying(255) NOT NULL,
    jsonvalue text
);


--
-- TOC entry 255 (class 1259 OID 16544)
-- Name: conninstance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE conninstance (
    id character varying(36) NOT NULL,
    bundlename character varying(255),
    capabilities text,
    connrequesttimeout integer,
    connectorname character varying(255),
    displayname character varying(255),
    jsonconf text,
    location character varying(255),
    version character varying(255),
    adminrealm_id character varying(36),
    maxidle integer,
    maxobjects integer,
    maxwait bigint,
    minevictableidletimemillis bigint,
    minidle integer
);


--
-- TOC entry 256 (class 1259 OID 16549)
-- Name: delegation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE delegation (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    startdate timestamp with time zone NOT NULL,
    delegated_id character varying(36),
    delegating_id character varying(36)
);


--
-- TOC entry 257 (class 1259 OID 16552)
-- Name: delegation_syncoperole; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE delegation_syncoperole (
    jpadelegation_id character varying(36),
    roles_id character varying(255)
);


--
-- TOC entry 258 (class 1259 OID 16555)
-- Name: derschema; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE derschema (
    id character varying(255) NOT NULL,
    expression character varying(255),
    anytypeclass_id character varying(255)
);


--
-- TOC entry 259 (class 1259 OID 16560)
-- Name: dynrealm; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE dynrealm (
    id character varying(255) NOT NULL
);


--
-- TOC entry 260 (class 1259 OID 16563)
-- Name: dynrealmmembers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE dynrealmmembers (
    any_id character(36),
    dynrealm_id character varying(255)
);


--
-- TOC entry 261 (class 1259 OID 16566)
-- Name: dynrealmmembership; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE dynrealmmembership (
    id character varying(36) NOT NULL,
    fiql character varying(255),
    dynrealm_id character varying(255),
    anytype_id character varying(255)
);


--
-- TOC entry 262 (class 1259 OID 16571)
-- Name: dynrolemembers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE dynrolemembers (
    any_id character(36),
    role_id character varying(255)
);


--
-- TOC entry 263 (class 1259 OID 16574)
-- Name: dynrolemembership; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE dynrolemembership (
    id character varying(36) NOT NULL,
    fiql character varying(255),
    role_id character varying(255)
);


--
-- TOC entry 264 (class 1259 OID 16579)
-- Name: externalresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE externalresource (
    id character varying(255) NOT NULL,
    capabilitiesoverride text,
    createtracelevel character varying(20),
    deletetracelevel character varying(20),
    enforcemandatorycondition integer,
    jsonconf text,
    orgunit text,
    overridecapabilities integer,
    propagationpriority integer,
    provisioningtracelevel character varying(20),
    provisions text,
    updatetracelevel character varying(20),
    accountpolicy_id character varying(36),
    connector_id character varying(36),
    passwordpolicy_id character varying(36),
    propagationpolicy_id character varying(36),
    provisionsorter_id character varying(255),
    pullpolicy_id character varying(36),
    pushpolicy_id character varying(36)
);


--
-- TOC entry 265 (class 1259 OID 16584)
-- Name: externalresourcepropaction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE externalresourcepropaction (
    resource_id character varying(255),
    implementation_id character varying(255)
);


--
-- TOC entry 266 (class 1259 OID 16589)
-- Name: fiqlquery; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE fiqlquery (
    id character varying(36) NOT NULL,
    fiql character varying(255),
    name character varying(255),
    target character varying(255),
    owner_id character varying(36)
);


--
-- TOC entry 267 (class 1259 OID 16594)
-- Name: formpropertydef; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE formpropertydef (
    id character varying(36) NOT NULL,
    datepattern character varying(255),
    dropdownfreeform integer,
    dropdownsingleselection integer,
    enumvalues text,
    idx integer,
    labels text,
    name character varying(255),
    readable integer,
    required integer,
    stringregex character varying(255),
    type character varying(20),
    writable integer,
    macrotask_id character varying(36)
);


--
-- TOC entry 268 (class 1259 OID 16599)
-- Name: gplainattr; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE gplainattr (
    id character varying(36) NOT NULL,
    owner_id character varying(36),
    schema_id character varying(255)
);


--
-- TOC entry 269 (class 1259 OID 16602)
-- Name: gplainattruniquevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE gplainattruniquevalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36),
    schema_id character varying(255)
);


--
-- TOC entry 270 (class 1259 OID 16607)
-- Name: gplainattrvalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE gplainattrvalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36)
);


--
-- TOC entry 271 (class 1259 OID 16612)
-- Name: syncopegroup_anytypeclass; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopegroup_anytypeclass (
    group_id character varying(36),
    anytypeclass_id character varying(255)
);


--
-- TOC entry 272 (class 1259 OID 16615)
-- Name: group_search_auxclass; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW group_search_auxclass AS
 SELECT group_id AS any_id,
    anytypeclass_id
   FROM syncopegroup_anytypeclass st;


--
-- TOC entry 273 (class 1259 OID 16619)
-- Name: group_search_resource; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW group_search_resource AS
 SELECT group_id AS any_id,
    resource_id
   FROM syncopegroup_externalresource st;


--
-- TOC entry 274 (class 1259 OID 16623)
-- Name: implementation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE implementation (
    id character varying(255) NOT NULL,
    body text,
    engine character varying(20) NOT NULL,
    type character varying(255) NOT NULL
);


--
-- TOC entry 275 (class 1259 OID 16628)
-- Name: jobstatus; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE jobstatus (
    id character varying(255) NOT NULL,
    jobstatus character varying(255)
);


--
-- TOC entry 276 (class 1259 OID 16633)
-- Name: laplainattr; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE laplainattr (
    id character varying(36) NOT NULL,
    account_id character varying(36),
    schema_id character varying(255),
    owner_id character varying(36)
);


--
-- TOC entry 277 (class 1259 OID 16636)
-- Name: laplainattruniquevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE laplainattruniquevalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36),
    schema_id character varying(255)
);


--
-- TOC entry 278 (class 1259 OID 16641)
-- Name: laplainattrvalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE laplainattrvalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36)
);


--
-- TOC entry 279 (class 1259 OID 16646)
-- Name: linkedaccount; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE linkedaccount (
    id character varying(36) NOT NULL,
    cipheralgorithm character varying(20),
    connobjectkeyvalue character varying(255),
    password character varying(255),
    suspended integer,
    username character varying(255),
    plainattrs jsonb,
    owner_id character varying(36),
    resource_id character varying(255)
);


--
-- TOC entry 280 (class 1259 OID 16651)
-- Name: linkedaccount_privilege; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE linkedaccount_privilege (
    linked_account_id character varying(36),
    privilege_id character varying(255)
);


--
-- TOC entry 281 (class 1259 OID 16654)
-- Name: macrotask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE macrotask (
    id character varying(36) NOT NULL,
    active integer,
    cronexpression character varying(255),
    description character varying(255),
    name character varying(255) NOT NULL,
    startat timestamp with time zone,
    continueonerror integer,
    saveexecs integer,
    jobdelegate_id character varying(255),
    macroactions_id character varying(255),
    realm_id character varying(36)
);


--
-- TOC entry 282 (class 1259 OID 16659)
-- Name: macrotaskcommand; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE macrotaskcommand (
    id character varying(36) NOT NULL,
    args text,
    idx integer,
    macrotask_id character varying(36),
    command_id character varying(255)
);


--
-- TOC entry 283 (class 1259 OID 16664)
-- Name: macrotaskexec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE macrotaskexec (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    executor character varying(255),
    message text,
    startdate timestamp with time zone NOT NULL,
    status character varying(255),
    task_id character varying(36)
);


--
-- TOC entry 284 (class 1259 OID 16669)
-- Name: mailtemplate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE mailtemplate (
    id character varying(255) NOT NULL,
    htmltemplate text,
    texttemplate text
);


--
-- TOC entry 285 (class 1259 OID 16674)
-- Name: networkservice; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE networkservice (
    id character varying(36) NOT NULL,
    address character varying(255),
    type character varying(20)
);


--
-- TOC entry 286 (class 1259 OID 16677)
-- Name: notification; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE notification (
    id character varying(36) NOT NULL,
    active integer,
    events text,
    recipientattrname character varying(255),
    recipientsfiql character varying(255),
    selfasrecipient integer,
    sender character varying(255),
    staticrecipients text,
    subject character varying(255),
    tracelevel character varying(20),
    recipientsprovider_id character varying(255),
    template_id character varying(255)
);


--
-- TOC entry 287 (class 1259 OID 16682)
-- Name: notificationtask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE notificationtask (
    id character varying(36) NOT NULL,
    anytypekind character varying(20),
    entitykey character varying(255),
    executed integer,
    htmlbody text,
    recipients text,
    sender character varying(255),
    subject character varying(255),
    textbody text,
    tracelevel character varying(20),
    notification_id character varying(36)
);


--
-- TOC entry 288 (class 1259 OID 16687)
-- Name: notificationtaskexec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE notificationtaskexec (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    executor character varying(255),
    message text,
    startdate timestamp with time zone NOT NULL,
    status character varying(255),
    task_id character varying(36)
);


--
-- TOC entry 289 (class 1259 OID 16692)
-- Name: oidcjwks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE oidcjwks (
    id character varying(36) NOT NULL,
    "json" text NOT NULL
);


--
-- TOC entry 290 (class 1259 OID 16697)
-- Name: oidcrpclientapp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE oidcrpclientapp (
    id character varying(36) NOT NULL,
    clientappid bigint NOT NULL,
    description character varying(255),
    informationurl character varying(255),
    logo character varying(255),
    logouttype character varying(20),
    name character varying(255) NOT NULL,
    privacyurl character varying(255),
    properties text,
    theme character varying(255),
    usernameattributeproviderconf text,
    bypassapprovalprompt boolean,
    clientid character varying(255) NOT NULL,
    clientsecret character varying(255),
    generaterefreshtoken boolean,
    jwks text,
    jwksuri character varying(255),
    jwtaccesstoken boolean,
    logouturi character varying(255),
    redirecturis text,
    scopes text,
    signidtoken boolean,
    subjecttype character varying(20),
    supportedgranttypes text,
    supportedresponsetypes text,
    tokenendpointauthenticationmethod character varying(20),
    accesspolicy_id character varying(36),
    attrreleasepolicy_id character varying(36),
    authpolicy_id character varying(36),
    realm_id character varying(36),
    ticketexpirationpolicy_id character varying(36)
);


--
-- TOC entry 291 (class 1259 OID 16702)
-- Name: passwordpolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE passwordpolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    allownullpassword integer,
    historylength integer
);


--
-- TOC entry 292 (class 1259 OID 16705)
-- Name: passwordpolicyrule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE passwordpolicyrule (
    policy_id character varying(36),
    implementation_id character varying(255)
);


--
-- TOC entry 293 (class 1259 OID 16708)
-- Name: plainschema; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE plainschema (
    id character varying(255) NOT NULL,
    cipheralgorithm character varying(20),
    conversionpattern character varying(255),
    enumerationkeys text,
    enumerationvalues text,
    mandatorycondition character varying(255),
    mimetype character varying(255),
    multivalue integer,
    readonly integer,
    secretkey character varying(255),
    type character varying(20),
    uniqueconstraint integer,
    anytypeclass_id character varying(255),
    validator_id character varying(255)
);


--
-- TOC entry 294 (class 1259 OID 16713)
-- Name: privilege; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE privilege (
    id character varying(255) NOT NULL,
    description character varying(255),
    spec text,
    application_id character varying(255)
);


--
-- TOC entry 295 (class 1259 OID 16718)
-- Name: propagationpolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE propagationpolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    backoffparams character varying(255),
    backoffstrategy character varying(20),
    fetcharoundprovisioning integer,
    maxattempts integer,
    updatedelta integer
);


--
-- TOC entry 296 (class 1259 OID 16723)
-- Name: propagationtask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE propagationtask (
    id character varying(36) NOT NULL,
    anytype character varying(255),
    anytypekind character varying(20),
    connobjectkey character varying(255),
    entitykey character varying(255),
    objectclassname character varying(255),
    oldconnobjectkey character varying(255),
    operation character varying(20),
    propagationdata text,
    resource_id character varying(255)
);


--
-- TOC entry 297 (class 1259 OID 16728)
-- Name: propagationtaskexec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE propagationtaskexec (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    executor character varying(255),
    message text,
    startdate timestamp with time zone NOT NULL,
    status character varying(255),
    task_id character varying(36)
);


--
-- TOC entry 298 (class 1259 OID 16733)
-- Name: pullcorrelationruleentity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pullcorrelationruleentity (
    id character varying(36) NOT NULL,
    pullpolicy_id character varying(36),
    anytype_id character varying(255),
    implementation_id character varying(255)
);


--
-- TOC entry 299 (class 1259 OID 16738)
-- Name: pullpolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pullpolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    conflictresolutionaction character varying(20)
);


--
-- TOC entry 300 (class 1259 OID 16741)
-- Name: pulltask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pulltask (
    id character varying(36) NOT NULL,
    active integer,
    cronexpression character varying(255),
    description character varying(255),
    name character varying(255) NOT NULL,
    startat timestamp with time zone,
    concurrentsettings text,
    matchingrule character varying(20),
    performcreate integer,
    performdelete integer,
    performupdate integer,
    syncstatus integer,
    unmatchingrule character varying(20),
    pullmode character varying(23),
    remediation integer,
    jobdelegate_id character varying(255),
    resource_id character varying(255),
    destinationrealm_id character varying(36),
    reconfilterbuilder_id character varying(255)
);


--
-- TOC entry 301 (class 1259 OID 16746)
-- Name: pulltaskaction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pulltaskaction (
    task_id character varying(36),
    implementation_id character varying(255)
);


--
-- TOC entry 302 (class 1259 OID 16749)
-- Name: pulltaskexec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pulltaskexec (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    executor character varying(255),
    message text,
    startdate timestamp with time zone NOT NULL,
    status character varying(255),
    task_id character varying(36)
);


--
-- TOC entry 303 (class 1259 OID 16754)
-- Name: pushcorrelationruleentity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pushcorrelationruleentity (
    id character varying(36) NOT NULL,
    pushpolicy_id character varying(36),
    anytype_id character varying(255),
    implementation_id character varying(255)
);


--
-- TOC entry 304 (class 1259 OID 16759)
-- Name: pushpolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pushpolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    conflictresolutionaction character varying(20)
);


--
-- TOC entry 305 (class 1259 OID 16762)
-- Name: pushtask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pushtask (
    id character varying(36) NOT NULL,
    active integer,
    cronexpression character varying(255),
    description character varying(255),
    name character varying(255) NOT NULL,
    startat timestamp with time zone,
    concurrentsettings text,
    matchingrule character varying(20),
    performcreate integer,
    performdelete integer,
    performupdate integer,
    syncstatus integer,
    unmatchingrule character varying(20),
    filters text,
    jobdelegate_id character varying(255),
    resource_id character varying(255),
    sourcerealm_id character varying(36)
);


--
-- TOC entry 306 (class 1259 OID 16767)
-- Name: pushtaskaction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pushtaskaction (
    task_id character varying(36),
    implementation_id character varying(255)
);


--
-- TOC entry 307 (class 1259 OID 16770)
-- Name: pushtaskexec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE pushtaskexec (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    executor character varying(255),
    message text,
    startdate timestamp with time zone NOT NULL,
    status character varying(255),
    task_id character varying(36)
);


--
-- TOC entry 308 (class 1259 OID 16775)
-- Name: qrtz_blob_triggers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_blob_triggers (
    sched_name character varying(120) NOT NULL,
    trigger_name character varying(200) NOT NULL,
    trigger_group character varying(200) NOT NULL,
    blob_data bytea
);


--
-- TOC entry 309 (class 1259 OID 16780)
-- Name: qrtz_calendars; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_calendars (
    sched_name character varying(120) NOT NULL,
    calendar_name character varying(200) NOT NULL,
    calendar bytea NOT NULL
);


--
-- TOC entry 310 (class 1259 OID 16785)
-- Name: qrtz_cron_triggers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_cron_triggers (
    sched_name character varying(120) NOT NULL,
    trigger_name character varying(200) NOT NULL,
    trigger_group character varying(200) NOT NULL,
    cron_expression character varying(120) NOT NULL,
    time_zone_id character varying(80)
);


--
-- TOC entry 311 (class 1259 OID 16790)
-- Name: qrtz_fired_triggers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_fired_triggers (
    sched_name character varying(120) NOT NULL,
    entry_id character varying(95) NOT NULL,
    trigger_name character varying(200) NOT NULL,
    trigger_group character varying(200) NOT NULL,
    instance_name character varying(200) NOT NULL,
    fired_time bigint NOT NULL,
    sched_time bigint NOT NULL,
    priority integer NOT NULL,
    state character varying(16) NOT NULL,
    job_name character varying(200),
    job_group character varying(200),
    is_nonconcurrent boolean,
    requests_recovery boolean
);


--
-- TOC entry 312 (class 1259 OID 16795)
-- Name: qrtz_job_details; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_job_details (
    sched_name character varying(120) NOT NULL,
    job_name character varying(200) NOT NULL,
    job_group character varying(200) NOT NULL,
    description character varying(250),
    job_class_name character varying(250) NOT NULL,
    is_durable boolean NOT NULL,
    is_nonconcurrent boolean NOT NULL,
    is_update_data boolean NOT NULL,
    requests_recovery boolean NOT NULL,
    job_data bytea
);


--
-- TOC entry 313 (class 1259 OID 16800)
-- Name: qrtz_locks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_locks (
    sched_name character varying(120) NOT NULL,
    lock_name character varying(40) NOT NULL
);


--
-- TOC entry 314 (class 1259 OID 16803)
-- Name: qrtz_paused_trigger_grps; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_paused_trigger_grps (
    sched_name character varying(120) NOT NULL,
    trigger_group character varying(200) NOT NULL
);


--
-- TOC entry 315 (class 1259 OID 16806)
-- Name: qrtz_scheduler_state; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_scheduler_state (
    sched_name character varying(120) NOT NULL,
    instance_name character varying(200) NOT NULL,
    last_checkin_time bigint NOT NULL,
    checkin_interval bigint NOT NULL
);


--
-- TOC entry 316 (class 1259 OID 16809)
-- Name: qrtz_simple_triggers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_simple_triggers (
    sched_name character varying(120) NOT NULL,
    trigger_name character varying(200) NOT NULL,
    trigger_group character varying(200) NOT NULL,
    repeat_count bigint NOT NULL,
    repeat_interval bigint NOT NULL,
    times_triggered bigint NOT NULL
);


--
-- TOC entry 317 (class 1259 OID 16814)
-- Name: qrtz_simprop_triggers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_simprop_triggers (
    sched_name character varying(120) NOT NULL,
    trigger_name character varying(200) NOT NULL,
    trigger_group character varying(200) NOT NULL,
    str_prop_1 character varying(512),
    str_prop_2 character varying(512),
    str_prop_3 character varying(512),
    int_prop_1 integer,
    int_prop_2 integer,
    long_prop_1 bigint,
    long_prop_2 bigint,
    dec_prop_1 numeric(13,4),
    dec_prop_2 numeric(13,4),
    bool_prop_1 boolean,
    bool_prop_2 boolean
);


--
-- TOC entry 318 (class 1259 OID 16819)
-- Name: qrtz_triggers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE qrtz_triggers (
    sched_name character varying(120) NOT NULL,
    trigger_name character varying(200) NOT NULL,
    trigger_group character varying(200) NOT NULL,
    job_name character varying(200) NOT NULL,
    job_group character varying(200) NOT NULL,
    description character varying(250),
    next_fire_time bigint,
    prev_fire_time bigint,
    priority integer,
    trigger_state character varying(16) NOT NULL,
    trigger_type character varying(8) NOT NULL,
    start_time bigint NOT NULL,
    end_time bigint,
    calendar_name character varying(200),
    misfire_instr smallint,
    job_data bytea
);


--
-- TOC entry 319 (class 1259 OID 16824)
-- Name: realm; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE realm (
    id character varying(36) NOT NULL,
    fullpath character varying(255) NOT NULL,
    name character varying(255),
    accesspolicy_id character varying(36),
    accountpolicy_id character varying(36),
    attrreleasepolicy_id character varying(36),
    authpolicy_id character varying(36),
    parent_id character varying(36),
    passwordpolicy_id character varying(36),
    ticketexpirationpolicy_id character varying(36)
);


--
-- TOC entry 320 (class 1259 OID 16829)
-- Name: realm_externalresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE realm_externalresource (
    realm_id character varying(36),
    resource_id character varying(255)
);


--
-- TOC entry 321 (class 1259 OID 16832)
-- Name: realmaction; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE realmaction (
    realm_id character varying(36),
    implementation_id character varying(255)
);


--
-- TOC entry 322 (class 1259 OID 16835)
-- Name: relationshiptype; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE relationshiptype (
    id character varying(255) NOT NULL,
    description character varying(255)
);


--
-- TOC entry 323 (class 1259 OID 16840)
-- Name: remediation; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE remediation (
    id character varying(36) NOT NULL,
    error text,
    instant timestamp with time zone,
    operation character varying(20),
    payload text,
    remotename character varying(255),
    anytype_id character varying(255),
    pulltask_id character varying(36)
);


--
-- TOC entry 324 (class 1259 OID 16845)
-- Name: report; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE report (
    id character varying(36) NOT NULL,
    active integer,
    cronexpression character varying(255),
    fileext character varying(255),
    mimetype character varying(255),
    name character varying(255) NOT NULL,
    jobdelegate_id character varying(255)
);


--
-- TOC entry 325 (class 1259 OID 16850)
-- Name: reportexec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE reportexec (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    executor character varying(255),
    message text,
    startdate timestamp with time zone NOT NULL,
    status character varying(255),
    execresult bytea,
    report_id character varying(36)
);


--
-- TOC entry 326 (class 1259 OID 16855)
-- Name: saml2idpentity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE saml2idpentity (
    id character varying(255) NOT NULL,
    encryptioncertificate bytea,
    encryptionkey bytea,
    metadata bytea NOT NULL,
    signingcertificate bytea,
    signingkey bytea
);


--
-- TOC entry 327 (class 1259 OID 16860)
-- Name: saml2spclientapp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE saml2spclientapp (
    id character varying(36) NOT NULL,
    clientappid bigint NOT NULL,
    description character varying(255),
    informationurl character varying(255),
    logo character varying(255),
    logouttype character varying(20),
    name character varying(255) NOT NULL,
    privacyurl character varying(255),
    properties text,
    theme character varying(255),
    usernameattributeproviderconf text,
    assertionaudiences text,
    encryptassertions boolean,
    encblalg text,
    encdataalg text,
    enckeyalg text,
    encryptionoptional boolean,
    entityid character varying(255) NOT NULL,
    metadatalocation character varying(255) NOT NULL,
    metadatasignaturelocation character varying(255),
    nameidqualifier character varying(255),
    reqauthncontextclass character varying(255),
    requirednameidformat smallint,
    spnameidqualifier character varying(255),
    signassertions boolean,
    signresponses boolean,
    sigalgs text,
    sigblalg text,
    sigrefdigestmethod text,
    skewallowance integer,
    accesspolicy_id character varying(36),
    attrreleasepolicy_id character varying(36),
    authpolicy_id character varying(36),
    realm_id character varying(36),
    ticketexpirationpolicy_id character varying(36)
);


--
-- TOC entry 328 (class 1259 OID 16865)
-- Name: saml2spentity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE saml2spentity (
    id character varying(255) NOT NULL,
    keystore bytea,
    metadata bytea
);


--
-- TOC entry 329 (class 1259 OID 16870)
-- Name: schedtask; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE schedtask (
    id character varying(36) NOT NULL,
    active integer,
    cronexpression character varying(255),
    description character varying(255),
    name character varying(255) NOT NULL,
    startat timestamp with time zone,
    jobdelegate_id character varying(255)
);


--
-- TOC entry 330 (class 1259 OID 16875)
-- Name: schedtaskexec; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE schedtaskexec (
    id character varying(36) NOT NULL,
    enddate timestamp with time zone,
    executor character varying(255),
    message text,
    startdate timestamp with time zone NOT NULL,
    status character varying(255),
    task_id character varying(36)
);


--
-- TOC entry 331 (class 1259 OID 16880)
-- Name: securityquestion; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE securityquestion (
    id character varying(36) NOT NULL,
    content character varying(255)
);


--
-- TOC entry 332 (class 1259 OID 16883)
-- Name: sraroute; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE sraroute (
    id character varying(36) NOT NULL,
    csrf integer,
    error character varying(255),
    filters text,
    logout integer,
    name character varying(255) NOT NULL,
    postlogout character varying(255),
    predicates text,
    routeorder integer,
    routetype character varying(20),
    target character varying(255)
);


--
-- TOC entry 333 (class 1259 OID 16888)
-- Name: syncopebatch; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopebatch (
    id character varying(255) NOT NULL,
    expirytime timestamp with time zone,
    results text
);


--
-- TOC entry 334 (class 1259 OID 16893)
-- Name: syncopedomain; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopedomain (
    id character varying(255) NOT NULL,
    spec text
);


--
-- TOC entry 335 (class 1259 OID 16898)
-- Name: syncoperole; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncoperole (
    id character varying(255) NOT NULL,
    anylayout text,
    entitlements text
);


--
-- TOC entry 336 (class 1259 OID 16903)
-- Name: syncoperole_dynrealm; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncoperole_dynrealm (
    role_id character varying(255),
    dynamicrealm_id character varying(255)
);


--
-- TOC entry 337 (class 1259 OID 16908)
-- Name: syncoperole_privilege; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncoperole_privilege (
    role_id character varying(255),
    privilege_id character varying(255)
);


--
-- TOC entry 338 (class 1259 OID 16913)
-- Name: syncoperole_realm; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncoperole_realm (
    role_id character varying(255),
    realm_id character varying(36)
);


--
-- TOC entry 339 (class 1259 OID 16916)
-- Name: syncopeschema; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopeschema (
    id character varying(255) NOT NULL,
    labels text
);


--
-- TOC entry 340 (class 1259 OID 16921)
-- Name: syncopeuser; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopeuser (
    id character varying(36) NOT NULL,
    creationcontext character varying(255),
    creationdate timestamp with time zone,
    creator character varying(255),
    lastchangecontext character varying(255),
    lastchangedate timestamp with time zone,
    lastmodifier character varying(255),
    status character varying(255),
    changepwddate timestamp with time zone,
    cipheralgorithm character varying(20),
    failedlogins integer,
    lastlogindate timestamp with time zone,
    mustchangepassword integer,
    password character varying(255),
    passwordhistory text,
    securityanswer character varying(255),
    suspended integer,
    token text,
    tokenexpiretime timestamp with time zone,
    username character varying(255),
    plainattrs jsonb,
    realm_id character varying(36),
    securityquestion_id character varying(36)
);


--
-- TOC entry 341 (class 1259 OID 16926)
-- Name: syncopeuser_anytypeclass; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopeuser_anytypeclass (
    user_id character varying(36),
    anytypeclass_id character varying(255)
);


--
-- TOC entry 342 (class 1259 OID 16929)
-- Name: syncopeuser_externalresource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopeuser_externalresource (
    user_id character varying(36),
    resource_id character varying(255)
);


--
-- TOC entry 343 (class 1259 OID 16932)
-- Name: syncopeuser_syncoperole; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE syncopeuser_syncoperole (
    user_id character varying(36),
    role_id character varying(255)
);


--
-- TOC entry 344 (class 1259 OID 16935)
-- Name: ticketexpirationpolicy; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE ticketexpirationpolicy (
    id character varying(36) NOT NULL,
    name character varying(255),
    jsonconf text
);


--
-- TOC entry 345 (class 1259 OID 16940)
-- Name: typeextension; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE typeextension (
    id character varying(36) NOT NULL,
    group_id character varying(36),
    anytype_id character varying(255)
);


--
-- TOC entry 346 (class 1259 OID 16943)
-- Name: typeextension_anytypeclass; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE typeextension_anytypeclass (
    typeextension_id character varying(36),
    anytypeclass_id character varying(255)
);


--
-- TOC entry 347 (class 1259 OID 16946)
-- Name: udyngroupmembers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE udyngroupmembers (
    any_id character(36),
    group_id character(36)
);


--
-- TOC entry 348 (class 1259 OID 16949)
-- Name: udyngroupmembership; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE udyngroupmembership (
    id character varying(36) NOT NULL,
    fiql character varying(255),
    group_id character varying(36)
);


--
-- TOC entry 349 (class 1259 OID 16952)
-- Name: umembership; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE umembership (
    id character varying(36) NOT NULL,
    user_id character varying(36),
    group_id character varying(36)
);


--
-- TOC entry 350 (class 1259 OID 16955)
-- Name: uplainattr; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE uplainattr (
    id character varying(36) NOT NULL,
    owner_id character varying(36),
    schema_id character varying(255),
    membership_id character varying(36)
);


--
-- TOC entry 351 (class 1259 OID 16958)
-- Name: uplainattruniquevalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE uplainattruniquevalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36),
    schema_id character varying(255)
);


--
-- TOC entry 352 (class 1259 OID 16963)
-- Name: uplainattrvalue; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE uplainattrvalue (
    id character varying(36) NOT NULL,
    binaryvalue bytea,
    booleanvalue integer,
    datevalue timestamp with time zone,
    doublevalue double precision,
    longvalue bigint,
    stringvalue character varying(255),
    attribute_id character varying(36)
);


--
-- TOC entry 353 (class 1259 OID 16968)
-- Name: urelationship; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE urelationship (
    id character varying(36) NOT NULL,
    user_id character varying(36),
    anyobject_id character varying(36),
    type_id character varying(255)
);


--
-- TOC entry 354 (class 1259 OID 16971)
-- Name: user_search_auxclass; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_auxclass AS
 SELECT user_id AS any_id,
    anytypeclass_id
   FROM syncopeuser_anytypeclass st;


--
-- TOC entry 355 (class 1259 OID 16975)
-- Name: user_search_dynpriv; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_dynpriv AS
 SELECT drm.any_id,
    rp.privilege_id
   FROM dynrolemembers drm,
    syncoperole_privilege rp
  WHERE ((drm.role_id)::text = (rp.role_id)::text);


--
-- TOC entry 356 (class 1259 OID 16979)
-- Name: user_search_group_res; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_group_res AS
 SELECT m.user_id AS any_id,
    st.resource_id
   FROM umembership m,
    syncopegroup r,
    syncopegroup_externalresource st
  WHERE (((m.group_id)::text = (r.id)::text) AND ((st.group_id)::text = (r.id)::text));


--
-- TOC entry 357 (class 1259 OID 16983)
-- Name: user_search_priv; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_priv AS
 SELECT ss.user_id AS any_id,
    sp.privilege_id
   FROM syncopeuser_syncoperole ss,
    syncoperole_privilege sp
  WHERE ((ss.role_id)::text = (sp.role_id)::text);


--
-- TOC entry 358 (class 1259 OID 16987)
-- Name: user_search_resource; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_resource AS
 SELECT user_id AS any_id,
    resource_id
   FROM syncopeuser_externalresource st;


--
-- TOC entry 359 (class 1259 OID 16991)
-- Name: user_search_role; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_role AS
 SELECT user_id AS any_id,
    role_id
   FROM syncopeuser_syncoperole ss;


--
-- TOC entry 360 (class 1259 OID 16995)
-- Name: user_search_umembership; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_umembership AS
 SELECT m.user_id AS any_id,
    g.id AS group_id,
    g.name AS group_name
   FROM umembership m,
    syncopegroup g
  WHERE ((m.group_id)::text = (g.id)::text);


--
-- TOC entry 361 (class 1259 OID 16999)
-- Name: user_search_urelationship; Type: VIEW; Schema: public; Owner: -
--

CREATE VIEW user_search_urelationship AS
 SELECT user_id AS any_id,
    anyobject_id AS right_any_id,
    type_id AS type
   FROM urelationship m;


--
-- TOC entry 362 (class 1259 OID 17003)
-- Name: virschema; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE virschema (
    id character varying(255) NOT NULL,
    extattrname character varying(255),
    readonly integer,
    anytypeclass_id character varying(255),
    anytype_id character varying(255),
    resource_id character varying(255)
);


--
-- TOC entry 363 (class 1259 OID 17008)
-- Name: waconfigentry; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE waconfigentry (
    id character varying(255) NOT NULL,
    waconfigvalues text
);


--
-- TOC entry 4566 (class 0 OID 16385)
-- Dependencies: 217
-- Data for Name: accesspolicy; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accesspolicy VALUES ('419935c7-deb3-40b3-8a9a-683037e523a2', 'DefaultAccessPolicy', '{"_class":"org.apache.syncope.common.lib.policy.DefaultAccessPolicyConf","order":0,"ssoEnabled":true,"caseInsensitive":true,"enabled":true,"requireAllAttributes":true}');
INSERT INTO accesspolicy VALUES ('0194459d-5b9b-72c1-a276-a4598433d188', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5bf8-7888-9e1d-441eaaa3b0af', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5c36-7216-abfc-964951a5bd3a', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5c82-78c1-af8a-f5acc3c6743e', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5cbc-7246-8d68-bde07ecb4b6a', 'New Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5ce7-737d-9e27-a5953c71b107', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5d1d-7314-a53c-7cb8578edef2', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5d49-79ad-9a2d-59c30a997c03', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5d66-79fb-981b-0e6839c233a4', 'New Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5d94-70fc-b899-526635d214d3', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5dcb-73f0-a157-e54d8ea773da', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5df5-7345-b948-83308a119e8a', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459d-5e22-750d-95ab-8e14a22a1fce', 'Access policy', NULL);
INSERT INTO accesspolicy VALUES ('0194459e-29f6-7fc1-8efc-ccd6ce60532c', 'Test Access policy', '{"_class":"org.apache.syncope.common.lib.policy.DefaultAccessPolicyConf","order":0,"enabled":true,"ssoEnabled":true,"requireAllAttributes":true,"caseInsensitive":false,"unauthorizedRedirectUrl":null,"requiredAttrs":{"cn":"admin,Admin,TheAdmin"},"rejectedAttrs":{}}');
INSERT INTO accesspolicy VALUES ('0194459e-2bb7-7238-9ac9-daf01d939841', 'Test Access policy', '{"_class":"org.apache.syncope.common.lib.policy.DefaultAccessPolicyConf","order":0,"enabled":true,"ssoEnabled":true,"requireAllAttributes":true,"caseInsensitive":false,"unauthorizedRedirectUrl":null,"requiredAttrs":{"ou":"test","cn":"admin,Admin"},"rejectedAttrs":{}}');


--
-- TOC entry 4567 (class 0 OID 16390)
-- Dependencies: 218
-- Data for Name: accesstoken; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accesstoken VALUES ('0194459d-45d8-799a-a327-4a5631c9dd66', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJjZjJmZjlmMnN5bmNvcGUxNjRAc3luY29wZS5hcGFjaGUub3JnIiwibmJmIjoxNzM2MzM0NzIyLCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTIyLCJpYXQiOjE3MzYzMzQ3MjIsImp0aSI6IjAxOTQ0NTlkLTQ1ZDgtNzk5YS1hMzI3LTRhNTYzMWM5ZGQ2NiJ9.8EGJIGt6QotlFaYjxw7xAznoymroPgXvgotxdZGjY6I_7LZX8JeV740I_30WVERUM71KYSfLjQV4PHzMNxCCdQ', '2025-01-08 13:12:02.520304+00', 'cf2ff9f2syncope164@syncope.apache.org');
INSERT INTO accesstoken VALUES ('0194459d-477b-7efe-9d72-bcca3a889a0e', '\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', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiI1ZTRlNDNhZW93bmVyQHN5bmNvcGUub3JnIiwibmJmIjoxNzM2MzM0NzIyLCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTIyLCJpYXQiOjE3MzYzMzQ3MjIsImp0aSI6IjAxOTQ0NTlkLTQ3N2ItN2VmZS05ZDcyLWJjY2EzYTg4OWEwZSJ9.WJjbwMuZRKEze9LYseE8cBeBw4Kj1Wm74Ond5oWvLx2vjIu5FL-ECSEOWWLRiRvH7iz0T0LC6oh79zT1dvc9rw', '2025-01-08 13:12:02.93941+00', '5e4e43aeowner@syncope.org');
INSERT INTO accesstoken VALUES ('0194459d-4a02-7b24-ac81-f5dfbe5a41e7', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiI1OTFmNWU1ZGF1dGhAdGVzdC5vcmciLCJuYmYiOjE3MzYzMzQ3MjMsImlzcyI6IkFwYWNoZVN5bmNvcGUiLCJleHAiOjE3MzYzNDE5MjMsImlhdCI6MTczNjMzNDcyMywianRpIjoiMDE5NDQ1OWQtNGEwMi03YjI0LWFjODEtZjVkZmJlNWE0MWU3In0.Ugg-a0FVySEYYnzfK7_WqcNedmQbUiSjh3vl57TGTPvDt3IMB6teJMZiZOSUW1OVY6uWDQQ2GPmYg5yI9vUKxw', '2025-01-08 13:12:03.586891+00', '591f5e5dauth@test.org');
INSERT INTO accesstoken VALUES ('0194459d-4a7d-761f-b3bc-5b3f64c8290e', '\x59654e4d63734e6b61516f38706261664e4e2b796a314451327a4c79595846306c322f77327358373250384f2f6450454d327373317a562b4b4d677334575675584d66504d754554554c36434446505033526576612b5a503855785739466854442f6c6e6b747a56574b4e71624465773369705170664348555772374e79466d2b3253424f546d786f4873727271685739772b637631595755476c6a624d6f423077747235426859796b427a65486f7972463135323879414b494e5552796c302f4c2b64586f566f54365531724467702f46766a5562597355505041426b34497978347631585766545530344b6c4a4571516b72513155643969734e54646e6b2f595a713048414d2f316a6a3273434b494b626a6861444f6a44316e355976542f572b3364396537625573587973377237516a78334c7132376e4d4652736c5a366b394e4b4f35356c3648796e6d39714e59394c6a36714e776748696e744e6f4d5735466130514d6a57587a77525441746477733467792f366268416e2b673231652b585735317a694e7a65522f445636432f453850746b67546b35736142374b36366f567663506e4c3963687a70314c3968722f3250564679584867574d53706279365a4d6e622b3834444238656f43542f5770576b347a596d696b3342354c2f46304b774f4e666969616675636a2f7234736f375866426d78524d6e574d3767566c67386a455169554667566271506873493261444f6a44316e355976542f572b336439653762557438347269675839744b445a42474472326a754a7834366b394e4b4f35356c3648796e6d39714e59394c6a304e5a4e68496e314d48394735375538516767675130714c4461747371767648447a61747533513671677a74445272523353525366467a33624d664f714c734d44525139354251755078394a4b386c6a6e77526732513d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiIxZjE1NDFlN2NoZWNrRmFpbGVkTG9naW5Ac3luY29wZS5hcGFjaGUub3JnIiwibmJmIjoxNzM2MzM0NzIzLCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTIzLCJpYXQiOjE3MzYzMzQ3MjMsImp0aSI6IjAxOTQ0NTlkLTRhN2QtNzYxZi1iM2JjLTViM2Y2NGM4MjkwZSJ9.Y85Ugmmd2EAVhKTBVwpb-ddoXoe16oiur1bRG50HRA0l2oWKfhbqCSUI2Ay9ayDabc3oZBCegI2NzJxnW3zvow', '2025-01-08 13:12:03.709747+00', '1f1541e7checkFailedLogin@syncope.apache.org');
INSERT INTO accesstoken VALUES ('0194459d-4b22-77e3-9743-64a2db0b22a7', '\x59654e4d63734e6b61516f38706261664e4e2b796a314451327a4c79595846306c322f77327358373250384f2f6450454d327373317a562b4b4d677334575675584d66504d754554554c36434446505033526576612b5a503855785739466854442f6c6e6b747a56574b4e71624465773369705170664348555772374e79466d2b3253424f546d786f4873727271685739772b637631595755476c6a624d6f423077747235426859796b427a65486f7972463135323879414b494e5552796c302f4c2b64586f566f54365531724467702f46766a5562597355505041426b34497978347631585766545530344b6c4a4571516b72513155643969734e54646e6b2f595a713048414d2f316a6a3273434b494b626a6861444f6a44316e355976542f572b3364396537625573587973377237516a78334c7132376e4d4652736c5a366b394e4b4f35356c3648796e6d39714e59394c6a36714e776748696e744e6f4d5735466130514d6a57587a77525441746477733467792f366268416e2b673231652b585735317a694e7a65522f445636432f453850746b67546b35736142374b36366f567663506e4c3963687a70314c3968722f3250564679584867574d53706279365a4d6e622b3834444238656f43542f5770576b347a596d696b3342354c2f46304b774f4e666969616675636a2f7234736f375866426d78524d6e574d3767566c67386a455169554667566271506873493261444f6a44316e355976542f572b336439653762557438347269675839744b445a42474472326a754a7834366b394e4b4f35356c3648796e6d39714e59394c6a304e5a4e68496e314d48394735375538516767675130714c4461747371767648447a61747533513671677a74445272523353525366467a33624d664f714c734d44525139354251755078394a4b386c6a6e77526732513d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJlYzE4NjU0MXRlc3R1c2VycmVhZEB0ZXN0Lm9yZyIsIm5iZiI6MTczNjMzNDcyMywiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MTkyMywiaWF0IjoxNzM2MzM0NzIzLCJqdGkiOiIwMTk0NDU5ZC00YjIyLTc3ZTMtOTc0My02NGEyZGIwYjIyYTcifQ.phJapT-SGHt8kRVj8MtOoOyGxGI291gsS3W2fRYJkzrXvEmBPejqSq891EY1G6TFlzIuXfgEC7RBSKM9K8qZzg', '2025-01-08 13:12:03.874799+00', 'ec186541testuserread@test.org');
INSERT INTO accesstoken VALUES ('0194459d-4b95-7025-8953-7fb84c14b561', '\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', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJwdWNjaW5pIiwibmJmIjoxNzM2MzM0NzIzLCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTIzLCJpYXQiOjE3MzYzMzQ3MjMsImp0aSI6IjAxOTQ0NTlkLTRiOTUtNzAyNS04OTUzLTdmYjg0YzE0YjU2MSJ9.QxHEVrfHUmelhRZgXhttaEG6VwIK5kUIaHutPMy6TqTkaemk6WSynBxUTdzLr8CdCdCMwrZwsOnsEFNxv5JZVQ', '2025-01-08 13:12:03.989382+00', 'puccini');
INSERT INTO accesstoken VALUES ('0194459d-4c98-7711-bee0-ee36c54f6fa2', '\x59654e4d63734e6b61516f38706261664e4e2b796a314451327a4c79595846306c322f77327358373250384f2f6450454d327373317a562b4b4d677334575675584d66504d754554554c36434446505033526576612b5a503855785739466854442f6c6e6b747a56574b4e71624465773369705170664348555772374e79466d2b3253424f546d786f4873727271685739772b637631595755476c6a624d6f423077747235426859796b427a65486f7972463135323879414b494e5552796c302f4c2b64586f566f54365531724467702f46766a5562597355505041426b34497978347631585766545530344b6c4a4571516b72513155643969734e54646e6b2f595a713048414d2f316a6a3273434b494b626a6861444f6a44316e355976542f572b3364396537625573587973377237516a78334c7132376e4d4652736c5a366b394e4b4f35356c3648796e6d39714e59394c6a36714e776748696e744e6f4d5735466130514d6a57587a77525441746477733467792f366268416e2b673231652b585735317a694e7a65522f445636432f453850746b67546b35736142374b36366f567663506e4c3963687a70314c3968722f3250564679584867574d53706279365a4d6e622b3834444238656f43542f5770576b347a596d696b3342354c2f46304b774f4e666969616675636a2f7234736f375866426d78524d6e574d3767566c67386a455169554667566271506873493261444f6a44316e355976542f572b336439653762557438347269675839744b445a42474472326a754a7834366b394e4b4f35356c3648796e6d39714e59394c6a304e5a4e68496e314d48394735375538516767675130714c4461747371767648447a61747533513671677a74445272523353525366467a33624d664f714c734d44525139354251755078394a4b386c6a6e77526732513d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiIwZmU5MmVmYWNoZWNrU3VzcGVuc2lvbkBzeW5jb3BlLmFwYWNoZS5vcmciLCJuYmYiOjE3MzYzMzQ3MjQsImlzcyI6IkFwYWNoZVN5bmNvcGUiLCJleHAiOjE3MzYzNDE5MjQsImlhdCI6MTczNjMzNDcyNCwianRpIjoiMDE5NDQ1OWQtNGM5OC03NzExLWJlZTAtZWUzNmM1NGY2ZmEyIn0.ENoJ1IFcXRn2eJ-A9-D8Sgs3Dj9LXDGD2d97avS4C_zIRlhEyrcsd13LORxPYQmVcno_qHb-BqE38amWHvS6sA', '2025-01-08 13:12:04.248825+00', '0fe92efacheckSuspension@syncope.apache.org');
INSERT INTO accesstoken VALUES ('0194459d-4ddd-78e3-bf71-d199eecf34ed', '\x59654e4d63734e6b61516f38706261664e4e2b796a314451327a4c79595846306c322f77327358373250384f2f6450454d327373317a562b4b4d677334575675584d66504d754554554c36434446505033526576612b5a503855785739466854442f6c6e6b747a56574b4e71624465773369705170664348555772374e79466d2b3253424f546d786f4873727271685739772b637631595755476c6a624d6f423077747235426859796b427a65486f7972463135323879414b494e5552796c302f4c2b64586f566f54365531724467702f46766a5562597355505041426b34497978347631585766545530344b6c4a4571516b72513155643969734e54646e6b2f595a713048414d2f316a6a3273434b494b626a6861444f6a44316e355976542f572b3364396537625573587973377237516a78334c7132376e4d4652736c5a366b394e4b4f35356c3648796e6d39714e59394c6a376d58534e56353774506232347252584c31652f33474d794b335a45795139694f42435872346b303550515556516a3566754545653768372f36456d644b58587476554c354b3764704d54784e356e514d46767457764b4a4745566854494b4e2f3532756a664a4f6156347a586e6b4b39655939384148703948313232756f4565705054536a75655a656838703576616a575053343944575459534a3954422f527565315045494949454e7a78554f515a3654794b477a536350464857307a793832586e2b375755562b37796b5847752f4268386545493736616158467042636336446c544b316e51647971494344767364303379373032455948422f4f644f776e35662f6630316646724348477571492f3844696855556332614f766336524834504a36765547364c2b527448346c6873637576784d6e3073396c493167794e76554c354b3764704d54784e356e514d467674577473704c3234773955583673396f45566e74676d43416a3354544a413635384e72644a6b754856486230653832586e2b375755562b37796b5847752f4268386547707a4b6d6e716f4654537051354661454a394b556d6f744a514831477a6d6351727550595073476869387849434b71796479623764333844453867634c346c453d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJiZWxsaW5pIiwibmJmIjoxNzM2MzM0NzI0LCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTI0LCJpYXQiOjE3MzYzMzQ3MjQsImp0aSI6IjAxOTQ0NTlkLTRkZGQtNzhlMy1iZjcxLWQxOTllZWNmMzRlZCJ9.CtinaHBxF5-T8601wKIcKri26SdCclZOQhtQL00MRp5hsjd3IUtOB5fPjo4ki11bWgPRo-0VW3SWzKH7rZfr4w', '2025-01-08 13:12:04.573967+00', 'bellini');
INSERT INTO accesstoken VALUES ('0194459d-4fdb-7b24-8c28-6fd786124e7c', '\x59654e4d63734e6b61516f38706261664e4e2b796a35794a51395767354f65522f6a734b3367687761464a7176477165747a61572f5954424f5a385870504252615a314d42494c44534e6b4c53676a443467516746755a503855785739466854442f6c6e6b747a56574b4d7146456c34694463464a6431373733576b6b4331567837314e49436d49545a426f3344436561612b495171444f6a44316e355976542f572b33643965376255753944475171506f6a363856423951686a554959322f636d6c343839544b6a5a546f2f6b7a6e394b32512f324c6f783456564d43446c4d4f72464a6a543336347237514f5970704c71616f73456c4746525254655a686835324654706b576138484267506164325a414f5469777371395163674d4a3356497a726b646c632b53396e53554f536b6d41556c6a46723261416a384b54465646484e6d6a72334f6b522b44796572314275692f6b62522b4a5962484c7238544a394c505a534e594d68535271334549393073434e566e4d4744494d62726268677253646f305a787a4832703468397463572f4b384e41573969316e5a58586d70784648707a3376594c5937656e5965696b4c6653782f5333552f2b3642486277716b4a3670667961584163554c7257484e2b2b55704934652f522b4b574341554e3735636238614d5765414b6a6a306f444a526a7974592f574a4539514e7837314e49436d49545a426f3344436561612b4951724a4b354346787631495a4c617a4d786e536d6f36413d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiI3MjIyNDBhYXRlc3R1c2Vyc2VhcmNoQHRlc3Qub3JnIiwibmJmIjoxNzM2MzM0NzI1LCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTI1LCJpYXQiOjE3MzYzMzQ3MjUsImp0aSI6IjAxOTQ0NTlkLTRmZGItN2IyNC04YzI4LTZmZDc4NjEyNGU3YyJ9.-1v81WTxUqH-dJDfoAlOqen1TieAfE_5u92CP2DtYE9OU1qyO7C-t39ZvMIro56VQlSKOONKiL6ShKxCsD2VPQ', '2025-01-08 13:12:05.083398+00', '722240aatestusersearch@test.org');
INSERT INTO accesstoken VALUES ('0194459d-67ee-7984-9855-19a71a7927da', '\x59654e4d63734e6b61516f38706261664e4e2b796a2f5248775946567a6667583245776d5a48374661456d79424a644132476f674c68446643736f49346c5871746978513838414754676a4c48692f56645a394e545456386f4855494374544572562f343948514335557979424a644132476f674c68446643736f49346c5871746978513838414754676a4c48692f56645a394e5463445749427455574345534e422f566c4a5376515375656c7849653273543552434d6955374e785975304d5a5448464a6775334e6f336c5767456c356c363063773d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJyb3NzaW5pIiwibmJmIjoxNzM2MzM0NzMxLCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTMxLCJpYXQiOjE3MzYzMzQ3MzEsImp0aSI6IjAxOTQ0NTlkLTY3ZWUtNzk4NC05ODU1LTE5YTcxYTc5MjdkYSJ9.JO1BprKxg26lsrthJeE21OhkAzMbFg7uefy6LPpjjzhCJiZwS5Y_gt2RsroewcXxIxim9Uulai--XeJWsPCnBg', '2025-01-08 13:12:11.247113+00', 'rossini');
INSERT INTO accesstoken VALUES ('0194459d-6ccb-7f8c-b0ae-c3bffc066f22', '\x59654e4d63734e6b61516f38706261664e4e2b796a35794a51395767354f65522f6a734b3367687761464a7176477165747a61572f5954424f5a385870504252615a314d42494c44534e6b4c53676a443467516746755a503855785739466854442f6c6e6b747a56574b4d7146456c34694463464a6431373733576b6b4331567837314e49436d49545a426f3344436561612b495171444f6a44316e355976542f572b33643965376255753944475171506f6a363856423951686a554959322f636d6c343839544b6a5a546f2f6b7a6e394b32512f324c6f783456564d43446c4d4f72464a6a543336347237514f5970704c71616f73456c4746525254655a686835324654706b576138484267506164325a414f5469777371395163674d4a3356497a726b646c632b53396e53554f536b6d41556c6a46723261416a384b54465646484e6d6a72334f6b522b44796572314275692f6b62522b4a5962484c7238544a394c505a534e594d68535271334549393073434e566e4d4744494d62726268677253646f305a787a4832703468397463572f4b384e41573969316e5a58586d70784648707a3376594c5937656e5965696b4c6653782f5333552f2b3642486277716b4a3670667961584163554c7257484e2b2b55704934652f522b4b574341554e3735636238614d5765414b6a6a306f444a526a7974592f574a4539514e7837314e49436d49545a426f3344436561612b4951724a4b354346787631495a4c617a4d786e536d6f36413d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiI2OWIwYzlhN2RlbGVnYXRpbmdAc3luY29wZS5hcGFjaGUub3JnIiwibmJmIjoxNzM2MzM0NzMyLCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQxOTMyLCJpYXQiOjE3MzYzMzQ3MzIsImp0aSI6IjAxOTQ0NTlkLTZjY2ItN2Y4Yy1iMGFlLWMzYmZmYzA2NmYyMiJ9.1_t0x-h-c91E46DrTRS8pe610tm_2Nz2MRaml-fqEXvIrDfZdDnhX6llnrBdGJfkEc4Y3Uk-GZizWhFerg8zUw', '2025-01-08 13:12:12.491655+00', '69b0c9a7delegating@syncope.apache.org');
INSERT INTO accesstoken VALUES ('0194459d-70da-7b32-a218-90e1e672b0af', '\x59654e4d63734e6b61516f38706261664e4e2b796a2f5248775946567a6667583245776d5a48374661456e6768526131375135645277346d636e56686c454c73784865726e4b5764456853786658454a4a3466704761714e776748696e744e6f4d5735466130514d6a5755383264456e362b326359742f437769646a34584e376c61363562363371585155686843666639674e31707a786c5657437a2f584f7252367473554e4b36336d2f5644485a372f3771576334792f6e32765a6e5a35726663784157784e4267466b6b6e636c4a307757766a777359766933325a333569557238355443545454506c7557466e47754c79516f6d576a53697078302b3343393145775570396c5a634737784e6776343744364b494e2f795a3456534f4371344e4b5a426b32316347556a5650534a31393368437863673971597736753735774a694c794934544d3561674479335361567652782f41726a6638456658514a4974526247755773526b6c3330637534506d5a61692b2b54472b586552666d6948586b6f6d7a6c5948507a3945644e2f626a705a6157544836563946524e75536b584941437078597035553d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiI5MmZlZjFmNWR5blJlYWxtQWRtaW5AYXBhY2hlLm9yZyIsIm5iZiI6MTczNjMzNDczMywiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MTkzMywiaWF0IjoxNzM2MzM0NzMzLCJqdGkiOiIwMTk0NDU5ZC03MGRhLTdiMzItYTIxOC05MGUxZTY3MmIwYWYifQ.B0SR7Jys6_TdEltGXfOcJaU4I2TVabOiCabCvnj-wNP6r10zW3JWWrxCQZDcz1kHjHtjFmUiL8j7_RhRpWh4sg', '2025-01-08 13:12:13.530874+00', '92fef1f5dynRealmAdmin@apache.org');
INSERT INTO accesstoken VALUES ('0194459d-7ec3-73cf-8174-afd6db0c10d1', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJ2ZXJkaSIsIm5iZiI6MTczNjMzNDczNywiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MTkzNywiaWF0IjoxNzM2MzM0NzM3LCJqdGkiOiIwMTk0NDU5ZC03ZWMzLTczY2YtODE3NC1hZmQ2ZGIwYzEwZDEifQ.tjhAnpFhTNwtW2N9JXEh-XMSdVPHt0K1Ft4poMx2Zxr1rGiDvMNWBpHO87AGgiIH8hH6-oLvI879v6q6dFHeKw', '2025-01-08 13:12:17.091532+00', 'verdi');
INSERT INTO accesstoken VALUES ('019445a0-a67f-7922-828e-4de4010d2219', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJlMDI1OTViNmFub255bW91c0BzeW5jb3BlLmFwYWNoZS5vcmciLCJuYmYiOjE3MzYzMzQ5NDMsImlzcyI6IkFwYWNoZVN5bmNvcGUiLCJleHAiOjE3MzYzNDIxNDMsImlhdCI6MTczNjMzNDk0MywianRpIjoiMDE5NDQ1YTAtYTY3Zi03OTIyLTgyOGUtNGRlNDAxMGQyMjE5In0.pxDKVwZeUxL6MML0IY7TnBvSgQX-LKEG7joMqiWYpyN1XuChB-ZH0gbLrcSNd5PlL9_24pRfKdlYN2E9evWPqw', '2025-01-08 13:15:43.871451+00', 'e02595b6anonymous@syncope.apache.orgXX');
INSERT INTO accesstoken VALUES ('0194459d-8c3a-757c-b04e-b1124f06d427', NULL, 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJhZG1pbiIsIm5iZiI6MTczNjMzNDc0MCwiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MTk0MCwiaWF0IjoxNzM2MzM0NzQwLCJqdGkiOiIwMTk0NDU5ZC04YzNhLTc1N2MtYjA0ZS1iMTEyNGYwNmQ0MjcifQ.8zEq4AJJlnciy1DAQrtMioytIOmF9BdnlsFvx1Tk4A6xo16zOcAd_TZLazY4x7QGEppdm-SWKLvhCd2os8s5Bg', '2025-01-08 13:12:20.538126+00', 'admin');
INSERT INTO accesstoken VALUES ('0194459d-b574-7c89-a7ff-ef18044df9cb', '\x59654e4d63734e6b61516f38706261664e4e2b796a33584d734f41516f2b4f544473703858384e31566a687176477165747a61572f5954424f5a385870504252736b726b4958472f55686b74724d7a47644b616a6f413d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJmNGZhODkxMmNhbnRydW5uY29tbWFuZEB0ZXN0Lm9yZyIsIm5iZiI6MTczNjMzNDc1MSwiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MTk1MSwiaWF0IjoxNzM2MzM0NzUxLCJqdGkiOiIwMTk0NDU5ZC1iNTc0LTdjODktYTdmZi1lZjE4MDQ0ZGY5Y2IifQ.FJPnjhqgd-rZiEGqrLtuM_MdqG9rM1PS8iTAEU3nh7SkLi7jOwyHhQO4nSG6S1YQdemVOAkpl9DOLnP8McKZag', '2025-01-08 13:12:31.093037+00', 'f4fa8912cantrunncommand@test.org');
INSERT INTO accesstoken VALUES ('0194459f-e126-7423-862e-6d742805ce2f', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJjNjIzNDc2Y2EuYkBjLmNvbSIsIm5iZiI6MTczNjMzNDg5MywiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MjA5MywiaWF0IjoxNzM2MzM0ODkzLCJqdGkiOiIwMTk0NDU5Zi1lMTI2LTc0MjMtODYyZS02ZDc0MjgwNWNlMmYifQ.ojHMtrOzx56ZeAhjYpqtAwIPFVoYfMSL8ofBRdjIKFEucTlV_1dQb5yPkp7vSnaqwernXvyw8EYJV93SKYEUPA', '2025-01-08 13:14:53.350119+00', 'c623476ca.b@c.com');
INSERT INTO accesstoken VALUES ('019445a0-7b1d-798e-982f-52e1ef3a4e8d', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiIzOTg3NzMyM3N5bmNvcGUzOTFAc3luY29wZS5hcGFjaGUub3JnIiwibmJmIjoxNzM2MzM0OTMyLCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQyMTMyLCJpYXQiOjE3MzYzMzQ5MzIsImp0aSI6IjAxOTQ0NWEwLTdiMWQtNzk4ZS05ODJmLTUyZTFlZjNhNGU4ZCJ9.7NBJchwPb_isvCKx14x5d1x4j4A6s9RU9Lghz0QIXpZJkQgMi1y-rSIpdQRr8Z9pqXktwfEtgs51HfzO4uRFKQ', '2025-01-08 13:15:32.766026+00', '39877323syncope391@syncope.apache.org');
INSERT INTO accesstoken VALUES ('019445a0-8853-753a-9458-25b8aea89f58', '\x59654e4d63734e6b61516f38706261664e4e2b796a383376494d724e4336734f51347838364a4b53497352614b7a626545457531576e357542502f674f2f6649', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiI3YzI3NzJhM3N5bmNvcGUxNzkzQGFwYWNoZS5vcmciLCJuYmYiOjE3MzYzMzQ5MzYsImlzcyI6IkFwYWNoZVN5bmNvcGUiLCJleHAiOjE3MzYzNDIxMzYsImlhdCI6MTczNjMzNDkzNiwianRpIjoiMDE5NDQ1YTAtODg1My03NTNhLTk0NTgtMjViOGFlYTg5ZjU4In0.E9T_KSm1uXj1NPQocirciDPrA4_MKD8Njq0CC1T7weBL0f5x8gZqbFKyIUUlle9lzxH9Bvr3MqcQFC_KgC-lmg', '2025-01-08 13:15:36.14746+00', '7c2772a3syncope1793@apache.org');
INSERT INTO accesstoken VALUES ('019445a0-a912-722d-bb2b-e0757dbef77f', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiIzYjU2YWMwNnNlbGZyZWFkQHN5bmNvcGUuYXBhY2hlLm9yZyIsIm5iZiI6MTczNjMzNDk0NCwiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MjE0NCwiaWF0IjoxNzM2MzM0OTQ0LCJqdGkiOiIwMTk0NDVhMC1hOTEyLTcyMmQtYmIyYi1lMDc1N2RiZWY3N2YifQ.iw5FnAQmgoh3svZ7Igxn3luHrDtf5yH2xynzWsPYcRcTxNBY2dqDoh0IRCN66443hjwt6vocB9Ry2Rr5m52P5g', '2025-01-08 13:15:44.530227+00', '3b56ac06selfread@syncope.apache.org');
INSERT INTO accesstoken VALUES ('019445a0-a826-71f1-85b5-a189c511e45f', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJ2aXZhbGRpIiwibmJmIjoxNzM2MzM0OTQ0LCJpc3MiOiJBcGFjaGVTeW5jb3BlIiwiZXhwIjoxNzM2MzQyMTQ0LCJpYXQiOjE3MzYzMzQ5NDQsImp0aSI6IjAxOTQ0NWEwLWE4MjYtNzFmMS04NWI1LWExODljNTExZTQ1ZiJ9.XzatfFBn3d7Y3x7uaR8iXJfFv6oP2h3VsoejQduMg3PaLGStU0-EozjokZBSJ3AAPdysEJIMo-3s11bgcP-3tA', '2025-01-08 13:15:44.294516+00', 'vivaldi');
INSERT INTO accesstoken VALUES ('019445a0-ae3e-73c1-ae7d-2e1578f3b412', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJhZjUwMGM2Y3B3ZFJlc2V0QHN5bmNvcGUuYXBhY2hlLm9yZyIsIm5iZiI6MTczNjMzNDk0NSwiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MjE0NSwiaWF0IjoxNzM2MzM0OTQ1LCJqdGkiOiIwMTk0NDVhMC1hZTNlLTczYzEtYWU3ZC0yZTE1NzhmM2I0MTIifQ.3cpVDcPtYvcTCigchoNtbKqxDJbt6_6JOsjWEEKEYEPQS5VRpW11MXHlJrJJzReJChNLp1SonpSQ6XfysllIRA', '2025-01-08 13:15:45.854735+00', 'af500c6cpwdReset@syncope.apache.org');
INSERT INTO accesstoken VALUES ('019445a0-b76b-7473-8aca-14da5b8d0ba5', '\x655566515952684439386553336c496a446461596d673d3d', 'eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiI2NzNiNDQ5NXB3ZFJlc2V0Tm9TZWN1cml0eVF1ZXN0aW9uQHN5bmNvcGUuYXBhY2hlLm9yZyIsIm5iZiI6MTczNjMzNDk0OCwiaXNzIjoiQXBhY2hlU3luY29wZSIsImV4cCI6MTczNjM0MjE0OCwiaWF0IjoxNzM2MzM0OTQ4LCJqdGkiOiIwMTk0NDVhMC1iNzZiLTc0NzMtOGFjYS0xNGRhNWI4ZDBiYTUifQ.kfJ6W6qjRZRqHtjvjCc4mQZnpSRSXOYmRplTFmhX80ZZWMJwri8G1nPJsCLFQw5XO1UvEHmejCU7_sJazn3zaw', '2025-01-08 13:15:48.20351+00', '673b4495pwdResetNoSecurityQuestion@syncope.apache.org');


--
-- TOC entry 4568 (class 0 OID 16395)
-- Dependencies: 219
-- Data for Name: accountpolicy; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accountpolicy VALUES ('20ab5a8c-4b0c-432c-b957-f7fb9784d9f7', 'an account policy', 0, 0);
INSERT INTO accountpolicy VALUES ('06e2ed52-6966-44aa-a177-a0ca7434201f', 'sample account policy', 3, 0);
INSERT INTO accountpolicy VALUES ('0194459e-281c-7ca3-ad73-fc6767d81cc0', 'SYNCOPE553', 0, 0);
INSERT INTO accountpolicy VALUES ('0194459e-2857-7f29-8969-18eb19821a25', 'SYNCOPE682', 0, 0);


--
-- TOC entry 4569 (class 0 OID 16398)
-- Dependencies: 220
-- Data for Name: accountpolicy_externalresource; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accountpolicy_externalresource VALUES ('20ab5a8c-4b0c-432c-b957-f7fb9784d9f7', 'resource-testdb');
INSERT INTO accountpolicy_externalresource VALUES ('0194459e-2857-7f29-8969-18eb19821a25', 'resource-ldap');


--
-- TOC entry 4570 (class 0 OID 16401)
-- Dependencies: 221
-- Data for Name: accountpolicyrule; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO accountpolicyrule VALUES ('20ab5a8c-4b0c-432c-b957-f7fb9784d9f7', 'DefaultAccountRuleConf1');
INSERT INTO accountpolicyrule VALUES ('06e2ed52-6966-44aa-a177-a0ca7434201f', 'DefaultAccountRuleConf2');
INSERT INTO accountpolicyrule VALUES ('0194459e-281c-7ca3-ad73-fc6767d81cc0', 'DefaultAccountRuleConfabde3716');
INSERT INTO accountpolicyrule VALUES ('0194459e-2857-7f29-8969-18eb19821a25', 'DefaultAccountRuleConf8d758f2b');


--
-- TOC entry 4571 (class 0 OID 16404)
-- Dependencies: 222
-- Data for Name: adyngroupmembers; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459c-28de-7b87-b5eb-5bff076909a5', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '9e1d130c-d6a3-48b1-98b3-182477ed0688', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459d-7889-7a58-85f0-20372a39981e', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459c-1ad3-7c0a-a463-a3e2c0453c12', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459c-2192-7511-abcf-19c50963d57a', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459c-2295-73ca-8242-b175f4bc7e54', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459c-268e-7d01-86cf-d26c3472ba8c', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459c-4059-770f-bc3d-ae2bc229e653', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', 'fc6dbc3a-6c07-4965-8781-921e7401a4a5', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459d-143b-7e30-b11e-b1eaa3ddbfe4', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459d-b722-7330-b549-83b922283ef9', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459e-4b45-79ee-bde8-1a04b4195628', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459e-4c99-757f-91f8-e630c2b6f6fc', '0194459d-786b-7f8a-aad7-f05eb16eb585');
INSERT INTO adyngroupmembers VALUES ('PRINTER', '0194459f-cf4b-72e1-8da9-940c4049899d', '0194459d-786b-7f8a-aad7-f05eb16eb585');


--
-- TOC entry 4572 (class 0 OID 16407)
-- Dependencies: 223
-- Data for Name: adyngroupmembership; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO adyngroupmembership VALUES ('0194459d-78c2-7b03-888f-0471db19e1a3', 'location==$null;$type==PRINTER', '0194459d-786b-7f8a-aad7-f05eb16eb585', 'PRINTER');
INSERT INTO adyngroupmembership VALUES ('0194459d-7cf2-795b-908a-0d9e50124fbb', '(($groups==ece66293-8f31-4a84-8e8d-23da36e70846;cool==ss);$resources==ws-target-resource-2);$type==PRINTER', '0194459d-7caf-7d4f-acfe-69deec4506c7', 'PRINTER');


--
-- TOC entry 4573 (class 0 OID 16412)
-- Dependencies: 224
-- Data for Name: amembership; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO amembership VALUES ('0194459f-cd95-79ed-b12a-4e0c8afc2fba', 'fc6dbc3a-6c07-4965-8781-921e7401a4a5', '29f96485-729e-4d31-88a1-6fc60e4677f3');
INSERT INTO amembership VALUES ('0194459f-ce15-76ca-9a8d-ab9d5caf8a6c', '8559d14d-58c2-46eb-a2d4-a7d35161e8f8', 'f779c0d4-633b-4be5-8f57-32eb478a3ca5');
INSERT INTO amembership VALUES ('0194459f-cf4c-74fe-ad3d-94d8f564c1eb', '0194459f-cf4b-72e1-8da9-940c4049899d', '29f96485-729e-4d31-88a1-6fc60e4677f3');


--
-- TOC entry 4574 (class 0 OID 16415)
-- Dependencies: 225
-- Data for Name: anyabout; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO anyabout VALUES ('a328f2e6-25e9-4cc1-badf-7425d7be4b39', 'token!=$null', 'USER', 'e00945b5-1184-4d43-8e45-4318a8dcdfd4');
INSERT INTO anyabout VALUES ('2e2ee845-2abf-43c6-b543-49243a84e2f1', 'fullname==*o*;fullname==*i*', 'USER', '9e2b911c-25de-4c77-bcea-b86ed9451050');
INSERT INTO anyabout VALUES ('0194459d-c3d5-72e9-b6c8-abfee8363d05', 'fullname==*o*;fullname==*i*', 'USER', '0194459d-c3ce-7fdf-a3e9-636bf6e32ed0');
INSERT INTO anyabout VALUES ('0194459d-c3ee-77fd-9b38-e68b116d1de6', 'name==citizen', 'GROUP', '0194459d-c3ee-77fd-9b38-e68b116d1de5');
INSERT INTO anyabout VALUES ('0194459d-c3ee-77fd-9b38-e68b116d1de7', 'fullname==*o*;fullname==*i*', 'USER', '0194459d-c3ee-77fd-9b38-e68b116d1de5');
INSERT INTO anyabout VALUES ('0194459d-c400-7af9-9d2c-f0372c683080', 'fullname==*o*;fullname==*i*', 'USER', '0194459d-c400-7af9-9d2c-f0372c68307f');
INSERT INTO anyabout VALUES ('0194459d-c436-7027-b655-8003eac15a4e', 'fullname==*o*;fullname==*i*', 'USER', '0194459d-c435-7a63-bb33-9d6569e3995b');
INSERT INTO anyabout VALUES ('0194459d-c475-7507-a45d-dd4f64f1c15e', '$groups==bf825fe1-7320-4a54-bd64-143b5c18ab97', 'USER', '0194459d-c475-7507-a45d-dd4f64f1c15d');
INSERT INTO anyabout VALUES ('0194459d-cdbb-7af5-b2e5-fbfa69d3a1ef', '$groups==bf825fe1-7320-4a54-bd64-143b5c18ab97', 'USER', '0194459d-cdbb-7af5-b2e5-fbfa69d3a1ee');
INSERT INTO anyabout VALUES ('0194459d-db11-7a48-9dd4-58494da1f0e1', 'name==groupacf99b57', 'GROUP', '0194459d-db11-7a48-9dd4-58494da1f0e0');
INSERT INTO anyabout VALUES ('0194459d-e7f0-72de-babb-3fdf765c7ede', '$groups==bf825fe1-7320-4a54-bd64-143b5c18ab97', 'USER', '0194459d-e7f0-72de-babb-3fdf765c7edd');
INSERT INTO anyabout VALUES ('0194459d-e842-761f-9439-ff400cb063da', '$groups==bf825fe1-7320-4a54-bd64-143b5c18ab97', 'USER', '0194459d-e842-761f-9439-ff400cb063d9');
INSERT INTO anyabout VALUES ('0194459d-fd81-7461-83ee-9154dd4a84b2', '$groups==bf825fe1-7320-4a54-bd64-143b5c18ab97', 'USER', '0194459d-fd81-7461-83ee-9154dd4a84b1');
INSERT INTO anyabout VALUES ('0194459e-0a53-7851-bb17-ca129d74f5a5', '$groups==bf825fe1-7320-4a54-bd64-143b5c18ab97', 'USER', '0194459e-0a53-7851-bb17-ca129d74f5a4');
INSERT INTO anyabout VALUES ('0194459e-1339-7495-9b55-c6a5565b8ee1', '$groups==bf825fe1-7320-4a54-bd64-143b5c18ab97', 'USER', '0194459e-1339-7495-9b55-c6a5565b8ee0');


--
-- TOC entry 4575 (class 0 OID 16420)
-- Dependencies: 226
-- Data for Name: anyobject; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO anyobject VALUES ('9e1d130c-d6a3-48b1-98b3-182477ed0688', NULL, '2021-04-15 11:45:00+00', 'admin', NULL, '2010-10-20 10:00:00+00', 'admin', NULL, 'Epson Stylus Color', '[]', '0679e069-7355-4b20-bd11-a5a0a5453c7c', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-25ab-779c-b055-80c9cf1bd6b4', 'REST', '2025-01-08 11:10:48.750645+00', 'admin', 'REST', '2025-01-08 11:10:48.863447+00', 'admin', NULL, 'printer16c76119b', '[{"schema": "location", "values": [{"stringValue": "printer17ad43db7"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459f-961d-7169-b796-e69da213fe2a', 'REST', '2025-01-08 11:14:34.142639+00', 'admin', 'REST', '2025-01-08 11:14:34.142677+00', 'admin', NULL, 'reconciliation7be54c97', '[{"schema": "location", "values": [{"stringValue": "reconciliation16440d77"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-25cc-7531-abae-d7761976f350', 'REST', '2025-01-08 11:10:48.781902+00', 'admin', 'REST', '2025-01-08 11:10:48.905181+00', 'admin', NULL, 'printer21ce0a7d0', '[{"schema": "location", "values": [{"stringValue": "printer2c3470351"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-25e7-7b3a-888a-554d77120a55', 'REST', '2025-01-08 11:10:48.809133+00', 'admin', 'REST', '2025-01-08 11:10:48.809201+00', 'admin', NULL, 'printer365a1334f', '[{"schema": "location", "values": [{"stringValue": "printer3b2a21930"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-27d8-77ac-ac15-9db6c698f618', 'REST', '2025-01-08 11:10:49.307473+00', 'admin', 'REST', '2025-01-08 11:10:49.307592+00', 'admin', NULL, 'unlimited2126918f3', '[{"schema": "location", "values": [{"stringValue": "unlimited2494b12d8"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-27b0-7929-bf19-e53dec60260c', 'REST', '2025-01-08 11:10:49.268924+00', 'admin', 'REST', '2025-01-08 11:10:49.373048+00', 'admin', NULL, 'unlimited1cda2b259', '[{"schema": "location", "values": [{"stringValue": "unlimited14c4544cd"}]}]', '0679e069-7355-4b20-bd11-a5a0a5453c7c', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459d-7889-7a58-85f0-20372a39981e', 'REST', '2025-01-08 11:12:15.498598+00', 'admin', 'REST', '2025-01-08 11:12:15.597373+00', 'admin', NULL, 'aDynMembership694e7a16', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('8559d14d-58c2-46eb-a2d4-a7d35161e8f8', NULL, '2010-10-20 10:00:00+00', 'admin', 'REST', '2025-01-08 11:14:48.475742+00', 'admin', NULL, 'Canon MF 8030cn', '[{"schema": "model", "values": [{"stringValue": "HP Laserjet 1300n"}]}, {"schema": "location", "values": [{"stringValue": "2nd floor"}]}, {"schema": "ctype", "values": [{"stringValue": "otherchildctype"}], "membership": "0194459f-ce15-76ca-9a8d-ab9d5caf8a6c"}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459d-4de8-7a0f-aa6a-57b22aa73983', 'REST', '2025-01-08 11:12:04.586092+00', 'bellini', 'REST', '2025-01-08 11:12:04.586156+00', 'bellini', NULL, 'home', '[{"schema": "pathfee592ed", "values": [{"stringValue": "/home"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'FOLDER 458006bf');
INSERT INTO anyobject VALUES ('0194459d-b156-7061-b8b2-dfc77d00e17b', 'REST', '2025-01-08 11:12:30.048308+00', 'admin', 'REST', '2025-01-08 11:12:30.049097+00', 'admin', NULL, 'aprinter112', '[{"schema": "location", "values": [{"stringValue": "location"}]}]', '0194459d-b150-7322-a530-02a310e10867', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-1ad3-7c0a-a463-a3e2c0453c12', 'REST', '2025-01-08 11:10:45.976762+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:36.92095+00', 'admin', NULL, 'createb0b192d2', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459f-cf4b-72e1-8da9-940c4049899d', 'REST', '2025-01-08 11:14:48.780876+00', 'admin', 'REST', '2025-01-08 11:14:48.780962+00', 'admin', NULL, '64d8d529', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-2192-7511-abcf-19c50963d57a', 'REST', '2025-01-08 11:10:47.701384+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:36.959273+00', 'admin', NULL, 'readAttrs074003a0', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-2295-73ca-8242-b175f4bc7e54', 'REST', '2025-01-08 11:10:47.960323+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:36.993663+00', 'admin', NULL, 'updated3601851', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-268e-7d01-86cf-d26c3472ba8c', 'REST', '2025-01-08 11:10:48.977131+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.037347+00', 'admin', NULL, 'updateAttr7b51590e', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-28de-7b87-b5eb-5bff076909a5', 'REST', '2025-01-08 11:10:49.571101+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.070416+00', 'admin', NULL, 'deleteAttrec56c135', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459c-4059-770f-bc3d-ae2bc229e653', 'REST', '2025-01-08 11:10:55.580002+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.110404+00', 'admin', NULL, 'USAa770cd26', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459d-143b-7e30-b11e-b1eaa3ddbfe4', 'REST', '2025-01-08 11:11:49.822247+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.170552+00', 'admin', NULL, 'syncope-179114c5f420', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459d-b722-7330-b549-83b922283ef9', 'REST', '2025-01-08 11:12:31.527577+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.193426+00', 'admin', NULL, 'updatef2a7ad08', '[{}]', '0679e069-7355-4b20-bd11-a5a0a5453c7c', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459e-4b45-79ee-bde8-1a04b4195628', 'REST', '2025-01-08 11:13:09.448076+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.207815+00', 'admin', NULL, 'propagationJEXLTransformer0439acd2', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459e-4c99-757f-91f8-e630c2b6f6fc', 'REST', '2025-01-08 11:13:09.787747+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.217565+00', 'admin', NULL, 'propagationPolicy8099df47', '[{}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459e-b7c7-7dcc-94cf-bfca04b68324', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.225881+00', 'admin', 'PullTask 30cfd653-257b-495f-8665-281281dbcb3d ''Scripted SQL''', '2025-01-08 11:13:37.225917+00', 'admin', NULL, 'pull52899617', '[{"schema": "location", "values": [{"stringValue": "pulle8c57f8a"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459f-9513-78c2-8dac-49bdbdd3544a', 'PullTask 0194459f-94fd-7687-9728-124c323c2085 ''null''', '2025-01-08 11:14:33.876389+00', 'admin', 'PullTask 0194459f-94fd-7687-9728-124c323c2085 ''null''', '2025-01-08 11:14:33.876446+00', 'admin', NULL, 'printer39dff507', '[{"schema": "location", "values": [{"stringValue": "Nowhere"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('0194459f-95ae-732a-a833-401c519563f6', 'REST', '2025-01-08 11:14:34.031672+00', 'admin', 'PullTask 0194459f-95e5-7f9d-bebd-08b0438addd1 ''null''', '2025-01-08 11:14:34.123252+00', 'admin', NULL, 'reconciliation3ec02210', '[{"schema": "location", "values": [{"stringValue": "Nowhere"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');
INSERT INTO anyobject VALUES ('fc6dbc3a-6c07-4965-8781-921e7401a4a5', NULL, '2010-10-20 10:00:00+00', 'admin', 'REST', '2025-01-08 11:14:48.346065+00', 'admin', NULL, 'HP LJ 1300n', '[{"schema": "model", "values": [{"stringValue": "Canon MFC8030"}]}]', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER');


--
-- TOC entry 4576 (class 0 OID 16425)
-- Dependencies: 227
-- Data for Name: anyobject_anytypeclass; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 4577 (class 0 OID 16428)
-- Dependencies: 228
-- Data for Name: anyobject_externalresource; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO anyobject_externalresource VALUES ('0194459c-1ad3-7c0a-a463-a3e2c0453c12', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459c-2192-7511-abcf-19c50963d57a', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459c-2295-73ca-8242-b175f4bc7e54', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459c-268e-7d01-86cf-d26c3472ba8c', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459c-28de-7b87-b5eb-5bff076909a5', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459c-4059-770f-bc3d-ae2bc229e653', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459d-143b-7e30-b11e-b1eaa3ddbfe4', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459d-b722-7330-b549-83b922283ef9', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459e-4b45-79ee-bde8-1a04b4195628', 'resource-db-scripted');
INSERT INTO anyobject_externalresource VALUES ('0194459e-4c99-757f-91f8-e630c2b6f6fc', 'resource-db-scripted');


--
-- TOC entry 4581 (class 0 OID 16462)
-- Dependencies: 237
-- Data for Name: anytemplatepulltask; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO anytemplatepulltask VALUES ('6c3f578d-327b-4a7c-8037-6f5ba24eb770', '{"_class":"org.apache.syncope.common.lib.to.UserTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"USER","realm":null,"status":null,"password":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"relationships":[],"memberships":[],"dynMemberships":[],"roles":[],"dynRoles":[],"plainAttrs":[{"schema":"ctype","values":["''type a''"]},{"schema":"userId","values":["''reconciled@syncope.apache.org''"]},{"schema":"fullname","values":["''reconciled fullname''"]},{"schema":"surname","values":["''surname''"]}]}', 'USER', '83f7e85d-9774-43fe-adba-ccd856312994');
INSERT INTO anytemplatepulltask VALUES ('45b61137-c7c3-49ee-86e0-9efffa75ae68', '{"_class":"org.apache.syncope.common.lib.to.GroupTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"GROUP","realm":null,"status":null,"name":null,"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"plainAttrs":[]}', 'GROUP', '83f7e85d-9774-43fe-adba-ccd856312994');
INSERT INTO anytemplatepulltask VALUES ('df655a2a-40c0-43b1-a157-3f4988802f58', '{"_class":"org.apache.syncope.common.lib.to.UserTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"USER","realm":"''/'' + title","status":null,"password":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"auxClasses":["minimal group"],"derAttrs":[],"virAttrs":[{"schema":"virtualReadOnly","values":[""]}],"resources":["resource-ldap"],"roles":[],"dynRoles":[],"relationships":[],"memberships":[],"dynMemberships":[],"plainAttrs":[]}', 'USER', '1e419ca4-ea81-4493-a14f-28b90113686d');
INSERT INTO anytemplatepulltask VALUES ('fda22ff3-98f3-42e4-a2ae-cd9a28282d57', '{"_class":"org.apache.syncope.common.lib.to.GroupTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"GROUP","realm":null,"status":null,"name":null,"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"plainAttrs":[{"schema":"show","values":["true"]}]}', 'GROUP', '1e419ca4-ea81-4493-a14f-28b90113686d');
INSERT INTO anytemplatepulltask VALUES ('8bc41ba1-cc1d-4ee0-bb43-61cd148b414f', '{"_class":"org.apache.syncope.common.lib.to.UserTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"USER","realm":null,"status":null,"password":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":["resource-testdb"],"roles":[],"dynRoles":[],"relationships":[],"memberships":[],"dynMemberships":[],"plainAttrs":[{"schema":"firstname","values":[""]},{"schema":"userId","values":["''test''"]},{"schema":"fullname","values":["''test''"]},{"schema":"surname","values":["''test''"]}]}', 'USER', '986867e2-993b-430e-8feb-aa9abb4c1dcd');
INSERT INTO anytemplatepulltask VALUES ('9af0e343-8a37-42d2-9bc7-6e2e3b103219', '{"_class":"org.apache.syncope.common.lib.to.GroupTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"GROUP","realm":null,"status":null,"name":null,"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"plainAttrs":[]}', 'GROUP', '986867e2-993b-430e-8feb-aa9abb4c1dcd');
INSERT INTO anytemplatepulltask VALUES ('b3772d66-ec06-4133-bf38-b3273845ac5b', '{"_class":"org.apache.syncope.common.lib.to.GroupTO","key":null,"type":"GROUP","realm":null,"name":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":[],"plainAttrs":[],"derAttrs":[],"virAttrs":[],"resources":[],"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"staticUserMembershipCount":0,"dynamicUserMembershipCount":0,"staticAnyObjectMembershipCount":0,"dynamicAnyObjectMembershipCount":0,"adynMembershipConds":{},"typeExtensions":[]}', 'GROUP', 'c41b9b71-9bfa-4f90-89f2-84787def4c5c');
INSERT INTO anytemplatepulltask VALUES ('3a6173a9-8c34-4e37-b3b1-0c2ea385fac0', '{"_class":"org.apache.syncope.common.lib.to.UserTO","key":null,"type":"USER","realm":null,"username":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":["csv"],"plainAttrs":[{"schema":"ctype","values":["email == ''test8@syncope.apache.org''? ''TYPE_8'': ''TYPE_OTHER''"]}],"derAttrs":[{"schema":"cn","values":[""]}],"virAttrs":[],"resources":["resource-testdb"],"password":null,"token":null,"tokenExpireTime":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"suspended":false,"mustChangePassword":false,"relationships":[],"memberships":[{"groupKey":"f779c0d4-633b-4be5-8f57-32eb478a3ca5","groupName":null,"plainAttrs":[],"derAttrs":[],"virAttrs":[]}],"dynMemberships":[],"roles":[],"dynRoles":[],"privileges":[],"linkedAccounts":[],"delegatingDelegations":[],"delegatedDelegations":[]}', 'USER', 'c41b9b71-9bfa-4f90-89f2-84787def4c5c');
INSERT INTO anytemplatepulltask VALUES ('0194459e-8a10-7550-8574-f6e096eb55d1', '{"_class":"org.apache.syncope.common.lib.to.UserTO","key":null,"type":"USER","realm":null,"username":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":[],"plainAttrs":[],"derAttrs":[],"virAttrs":[{"schema":"virtualdata","values":["''virtualvalue''"]}],"resources":["resource-db-virattr"],"password":"''password123''","token":null,"tokenExpireTime":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"suspended":false,"mustChangePassword":false,"relationships":[],"memberships":[],"dynMemberships":[],"roles":[],"dynRoles":[],"privileges":[],"linkedAccounts":[],"delegatingDelegations":[],"delegatedDelegations":[]}', 'USER', '38abbf9e-a1a3-40a1-a15f-7d0ac02f47f1');
INSERT INTO anytemplatepulltask VALUES ('0194459e-9ad2-796f-9ac8-3fa1f8576e98', '{"_class":"org.apache.syncope.common.lib.to.UserTO","key":null,"type":"USER","realm":null,"username":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":[],"plainAttrs":[],"derAttrs":[],"virAttrs":[],"resources":["ws-target-resource-2"],"password":null,"token":null,"tokenExpireTime":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"suspended":false,"mustChangePassword":false,"relationships":[],"memberships":[{"groupKey":"f779c0d4-633b-4be5-8f57-32eb478a3ca5","groupName":null,"plainAttrs":[],"derAttrs":[],"virAttrs":[]}],"dynMemberships":[],"roles":[],"dynRoles":[],"privileges":[],"linkedAccounts":[],"delegatingDelegations":[],"delegatedDelegations":[]}', 'USER', '0194459e-9ad1-708f-9f5f-dc20be7be9f7');
INSERT INTO anytemplatepulltask VALUES ('0194459e-9ad2-796f-9ac8-3fa1f8576e97', '{"_class":"org.apache.syncope.common.lib.to.GroupTO","key":null,"type":"GROUP","realm":null,"name":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":[],"plainAttrs":[],"derAttrs":[],"virAttrs":[],"resources":["resource-ldap"],"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"staticUserMembershipCount":0,"dynamicUserMembershipCount":0,"staticAnyObjectMembershipCount":0,"dynamicAnyObjectMembershipCount":0,"adynMembershipConds":{},"typeExtensions":[]}', 'GROUP', '0194459e-9ad1-708f-9f5f-dc20be7be9f7');
INSERT INTO anytemplatepulltask VALUES ('0194459e-ed47-7000-b49a-d16c7ef39068', '{"_class":"org.apache.syncope.common.lib.to.UserTO","key":null,"type":"USER","realm":"''/'' + title","username":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":["minimal group"],"plainAttrs":[],"derAttrs":[],"virAttrs":[{"schema":"virtualReadOnly","values":[""]}],"resources":["resource-ldap"],"password":null,"token":null,"tokenExpireTime":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"suspended":false,"mustChangePassword":false,"relationships":[],"memberships":[],"dynMemberships":[],"roles":[],"dynRoles":[],"privileges":[],"linkedAccounts":[],"delegatingDelegations":[],"delegatedDelegations":[]}', 'USER', '0194459e-ed41-768f-9f99-55623e95366d');
INSERT INTO anytemplatepulltask VALUES ('0194459e-ed46-7670-9677-0d08d3ab5f70', '{"_class":"org.apache.syncope.common.lib.to.GroupTO","key":null,"type":"GROUP","realm":null,"name":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":[],"plainAttrs":[{"schema":"show","values":["true"]}],"derAttrs":[],"virAttrs":[],"resources":[],"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"staticUserMembershipCount":0,"dynamicUserMembershipCount":0,"staticAnyObjectMembershipCount":0,"dynamicAnyObjectMembershipCount":0,"adynMembershipConds":{},"typeExtensions":[]}', 'GROUP', '0194459e-ed41-768f-9f99-55623e95366d');
INSERT INTO anytemplatepulltask VALUES ('0194459f-0bf4-72e6-ae02-8546ee64ca31', '{"_class":"org.apache.syncope.common.lib.to.UserTO","key":null,"type":"USER","realm":null,"username":null,"creator":null,"creationDate":null,"creationContext":null,"lastModifier":null,"lastChangeDate":null,"lastChangeContext":null,"dynRealms":[],"status":null,"auxClasses":[],"plainAttrs":[],"derAttrs":[],"virAttrs":[],"resources":["ws-target-resource-nopropagation4"],"password":null,"token":null,"tokenExpireTime":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"suspended":false,"mustChangePassword":false,"relationships":[],"memberships":[{"groupKey":"b8d38784-57e7-4595-859a-076222644b55","groupName":null,"plainAttrs":[],"derAttrs":[],"virAttrs":[]}],"dynMemberships":[],"roles":[],"dynRoles":[],"privileges":[],"linkedAccounts":[],"delegatingDelegations":[],"delegatedDelegations":[]}', 'USER', '81d88f73-d474-4450-9031-605daa4e313f');


--
-- TOC entry 4582 (class 0 OID 16467)
-- Dependencies: 238
-- Data for Name: anytemplaterealm; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 4583 (class 0 OID 16472)
-- Dependencies: 239
-- Data for Name: anytype; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO anytype VALUES ('USER', 'USER');
INSERT INTO anytype VALUES ('GROUP', 'GROUP');
INSERT INTO anytype VALUES ('PRINTER', 'ANY_OBJECT');
INSERT INTO anytype VALUES ('FOLDER 458006bf', 'ANY_OBJECT');


--
-- TOC entry 4584 (class 0 OID 16475)
-- Dependencies: 240
-- Data for Name: anytype_anytypeclass; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO anytype_anytypeclass VALUES ('USER', 'minimal user');
INSERT INTO anytype_anytypeclass VALUES ('USER', 'other');
INSERT INTO anytype_anytypeclass VALUES ('GROUP', 'minimal group');
INSERT INTO anytype_anytypeclass VALUES ('PRINTER', 'minimal printer');
INSERT INTO anytype_anytypeclass VALUES ('FOLDER 458006bf', 'foldera049399e');


--
-- TOC entry 4585 (class 0 OID 16480)
-- Dependencies: 241
-- Data for Name: anytypeclass; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO anytypeclass VALUES ('generic membership');
INSERT INTO anytypeclass VALUES ('minimal user');
INSERT INTO anytypeclass VALUES ('other');
INSERT INTO anytypeclass VALUES ('minimal group');
INSERT INTO anytypeclass VALUES ('minimal printer');
INSERT INTO anytypeclass VALUES ('csv');
INSERT INTO anytypeclass VALUES ('new class271cd7dc');
INSERT INTO anytypeclass VALUES ('foldera049399e');
INSERT INTO anytypeclass VALUES ('uniqueAttribute453a07e2');
INSERT INTO anytypeclass VALUES ('issue258');
INSERT INTO anytypeclass VALUES ('issue259');
INSERT INTO anytypeclass VALUES ('issue260');
INSERT INTO anytypeclass VALUES ('SYNCOPE-598d1cf4b9c');
INSERT INTO anytypeclass VALUES ('syncope2605d9e9bdf');
INSERT INTO anytypeclass VALUES ('syncope3973e102aad');
INSERT INTO anytypeclass VALUES ('syncope69146623a79');


--
-- TOC entry 4586 (class 0 OID 16483)
-- Dependencies: 242
-- Data for Name: aplainattr; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 4587 (class 0 OID 16486)
-- Dependencies: 243
-- Data for Name: aplainattruniquevalue; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 4588 (class 0 OID 16491)
-- Dependencies: 244
-- Data for Name: aplainattrvalue; Type: TABLE DATA; Schema: public; Owner: -
--



--
-- TOC entry 4589 (class 0 OID 16496)
-- Dependencies: 245
-- Data for Name: application; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO application VALUES ('mightyApp', 'A cool application');


--
-- TOC entry 4579 (class 0 OID 16440)
-- Dependencies: 231
-- Data for Name: arelationship; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO arelationship VALUES ('11a0ec66-b59b-428a-af3d-f856950ff1c5', 'fc6dbc3a-6c07-4965-8781-921e7401a4a5', '8559d14d-58c2-46eb-a2d4-a7d35161e8f8', 'neighborhood');
INSERT INTO arelationship VALUES ('0194459c-2617-7d2e-86bd-6a36f4f7c3e7', '0194459c-25ab-779c-b055-80c9cf1bd6b4', '0194459c-25cc-7531-abae-d7761976f350', 'neighborhood');
INSERT INTO arelationship VALUES ('0194459c-2646-70f7-a83c-57cab8a8ed14', '0194459c-25cc-7531-abae-d7761976f350', '0194459c-25e7-7b3a-888a-554d77120a55', 'neighborhood');
INSERT INTO arelationship VALUES ('0194459c-27da-730f-897f-b614fdc25f02', '0194459c-27d8-77ac-ac15-9db6c698f618', '0194459c-27b0-7929-bf19-e53dec60260c', 'neighborhood');
INSERT INTO arelationship VALUES ('0194459c-2818-74ff-8023-de9eaafa1975', '0194459c-27b0-7929-bf19-e53dec60260c', '0194459c-27d8-77ac-ac15-9db6c698f618', 'neighborhood');


--
-- TOC entry 4590 (class 0 OID 16501)
-- Dependencies: 246
-- Data for Name: attrreleasepolicy; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO attrreleasepolicy VALUES ('219935c7-deb3-40b3-8a9a-683037e523a2', 'DenyAttrReleasePolicy', 0, '{"_class":"org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf","releaseAttrs":{},"allowedAttrs":[],"excludedAttrs":[],"includeOnlyAttrs":[],"principalIdAttr":null,"principalAttrRepoConf":{"mergingStrategy":"MULTIVALUED","ignoreResolvedAttributes":false,"expiration":0,"timeUnit":"HOURS","attrRepos":[]}}', NULL);
INSERT INTO attrreleasepolicy VALUES ('319935c7-deb3-40b3-8a9a-683037e523a2', 'AllowedAttrReleasePolicy', 0, '{"_class":"org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf","releaseAttrs":{},"allowedAttrs":["cn","givenName","uid"],"excludedAttrs":[],"includeOnlyAttrs":[],"principalIdAttr":null,"principalAttrRepoConf":{"mergingStrategy":"MULTIVALUED","ignoreResolvedAttributes":false,"expiration":0,"timeUnit":"HOURS","attrRepos":[]}}', NULL);
INSERT INTO attrreleasepolicy VALUES ('0194459e-2a12-7081-b919-996aa45f6be2', 'Test Attribute Release policy', 0, '{"_class":"org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf","releaseAttrs":{"uid":"username","cn":"fullname"},"allowedAttrs":["cn","givenName"],"excludedAttrs":[],"includeOnlyAttrs":["cn"],"principalIdAttr":null,"principalAttrRepoConf":{"mergingStrategy":"MULTIVALUED","ignoreResolvedAttributes":false,"expiration":0,"timeUnit":"HOURS","attrRepos":[]}}', 1);
INSERT INTO attrreleasepolicy VALUES ('0194459e-2b69-7a75-87fa-26928aaf6a21', 'Test Attribute Release policy', 0, '{"_class":"org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf","releaseAttrs":{"uid":"username","cn":"fullname"},"allowedAttrs":["cn","givenName","postalCode"],"excludedAttrs":[],"includeOnlyAttrs":["cn"],"principalIdAttr":null,"principalAttrRepoConf":{"mergingStrategy":"MULTIVALUED","ignoreResolvedAttributes":false,"expiration":0,"timeUnit":"HOURS","attrRepos":[]}}', 1);


--
-- TOC entry 4591 (class 0 OID 16506)
-- Dependencies: 247
-- Data for Name: attrrepo; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO attrrepo VALUES ('DefaultLDAPAttrRepo', NULL, 'ACTIVE', 'LDAP attr repo', NULL, '{"_class":"org.apache.syncope.common.lib.attr.LDAPAttrRepoConf","searchFilter":"cn={user}","subtreeSearch":true,"ldapUrl":"ldap://localhost:1389","bindDn":"uid=admin,ou=system","bindCredential":"secret","baseDn":"ou=People,o=isp","useAllQueryAttributes":true,"queryAttributes":{}}');
INSERT INTO attrrepo VALUES ('DefaultJDBCAttrRepo', NULL, 'ACTIVE', 'JDBC attr repo', NULL, '{"_class":"org.apache.syncope.common.lib.attr.JDBCAttrRepoConf","sql":"SELECT * FROM table WHERE name=?","dialect":"org.hibernate.dialect.H2Dialect","driverClass":"org.h2.Driver","url":"jdbc:h2:mem:syncopedb;DB_CLOSE_DELAY=-1","user":"username","password":"password","singleRow":true,"requireAllAttributes":true,"caseCanonicalization":"NONE","queryType":"AND","columnMappings":{},"username":[],"caseInsensitiveQueryAttributes":[],"queryAttributes":{}}');
INSERT INTO attrrepo VALUES ('DefaultStubAttrRepo', NULL, 'ACTIVE', 'Stub attr repo', '[{"intAttrName":"attr1","extAttrName":"identifier","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":"NONE","propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.StubAttrRepoConf","attributes":{"attr1":"value1"}}');
INSERT INTO attrrepo VALUES ('DefaultSyncopeAttrRepo', NULL, 'ACTIVE', 'Syncope attr repo', NULL, '{"_class":"org.apache.syncope.common.lib.attr.SyncopeAttrRepoConf","domain":"Master","searchFilter":"username=={user}","basicAuthUsername":"admin","basicAuthPassword":"password","headers":{}}');
INSERT INTO attrrepo VALUES ('TestSTUBAttrRepo88a28f32', 0, 'ACTIVE', 'A test STUB attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.StubAttrRepoConf","attributes":{"attr9":"a9400ef5-1ed8-426f-af16-89e3381361a9","attr8":"c0b8da63-bfe4-443d-986a-077b932099cb"}}');
INSERT INTO attrrepo VALUES ('TestSYNCOPEAttrRepo5fd4e86d', 0, 'ACTIVE', 'A test SYNCOPE attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.SyncopeAttrRepoConf","domain":"Master","searchFilter":null,"basicAuthUsername":null,"basicAuthPassword":null,"headers":{}}');
INSERT INTO attrrepo VALUES ('TestLDAPAttrRepo524ed3b7', 0, 'ACTIVE', 'A test LDAP attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.LDAPAttrRepoConf","searchFilter":"cn={user}","subtreeSearch":true,"pageSize":0,"baseDn":"cn=Directory Manager,dc=example,dc=org","ldapUrl":"ldap://localhost:1389","ldapType":"GENERIC","bindDn":null,"bindCredential":"Password","disablePooling":false,"minPoolSize":3,"maxPoolSize":10,"poolPassivator":"BIND","hostnameVerifier":"DEFAULT","trustManager":null,"validateOnCheckout":true,"validatePeriodically":true,"validateTimeout":5.000000000,"validatePeriod":300.000000000,"failFast":true,"idleTime":600.000000000,"prunePeriod":7200.000000000,"blockWaitTime":3.000000000,"connectionStrategy":null,"useStartTls":false,"connectTimeout":5.000000000,"responseTimeout":5.000000000,"allowMultipleDns":false,"allowMultipleEntries":false,"followReferrals":true,"binaryAttributes":["objectGUID","objectSid"],"useAllQueryAttributes":true,"queryAttributes":{}}');
INSERT INTO attrrepo VALUES ('TestJDBCAttrRepo7b4a9605', 0, 'ACTIVE', 'A test JDBC attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.JDBCAttrRepoConf","sql":"SELECT * FROM table WHERE name=?","dialect":"org.hibernate.dialect.H2Dialect","driverClass":"org.h2.Driver","url":"jdbc:h2:tcp://localhost:9092/mem:authdb;DB_CLOSE_DELAY=-1","user":"sa","password":"sa","defaultCatalog":null,"defaultSchema":null,"healthQuery":"","idleTimeout":600.000000000,"dataSourceName":null,"minPoolSize":6,"maxPoolSize":18,"maxPoolWait":2.000000000,"poolSuspension":false,"poolTimeoutMillis":1000,"poolLeakThreshold":3000,"singleRow":true,"requireAllAttributes":true,"caseCanonicalization":"NONE","queryType":"AND","columnMappings":{},"username":["name"],"caseInsensitiveQueryAttributes":[],"queryAttributes":{"key1":"value1"}}');
INSERT INTO attrrepo VALUES ('TestSYNCOPEAttrRepo3e004cb5', 0, 'ACTIVE', 'A test SYNCOPE attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.SyncopeAttrRepoConf","domain":"Two","searchFilter":"username=={user}","basicAuthUsername":"admin","basicAuthPassword":"password","headers":{}}');
INSERT INTO attrrepo VALUES ('TestLDAPAttrRepo1400694b', 0, 'ACTIVE', 'A test LDAP attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.LDAPAttrRepoConf","searchFilter":"cn={user}","subtreeSearch":false,"pageSize":0,"baseDn":"ou=People,o=isp","ldapUrl":"ldap://localhost:1389","ldapType":"GENERIC","bindDn":"uid=admin,ou=system","bindCredential":"secret","disablePooling":false,"minPoolSize":3,"maxPoolSize":10,"poolPassivator":"BIND","hostnameVerifier":"DEFAULT","trustManager":null,"validateOnCheckout":true,"validatePeriodically":true,"validateTimeout":5.000000000,"validatePeriod":300.000000000,"failFast":true,"idleTime":600.000000000,"prunePeriod":7200.000000000,"blockWaitTime":3.000000000,"connectionStrategy":null,"useStartTls":false,"connectTimeout":5.000000000,"responseTimeout":5.000000000,"allowMultipleDns":false,"allowMultipleEntries":false,"followReferrals":true,"binaryAttributes":["objectGUID","objectSid"],"useAllQueryAttributes":true,"queryAttributes":{}}');
INSERT INTO attrrepo VALUES ('TestSTUBAttrRepo37e37ef5', 0, 'ACTIVE', 'A test STUB attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.StubAttrRepoConf","attributes":{"attr1":"value1","attr3":"value3"}}');
INSERT INTO attrrepo VALUES ('TestJDBCAttrRepoa4d2b305', 0, 'ACTIVE', 'A test JDBC attr repo', '[{"intAttrName":"uid","extAttrName":"username","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]},{"intAttrName":"cn","extAttrName":"fullname","connObjectKey":false,"password":false,"mandatoryCondition":"false","purpose":null,"propagationJEXLTransformer":null,"pullJEXLTransformer":null,"transformers":[]}]', '{"_class":"org.apache.syncope.common.lib.attr.JDBCAttrRepoConf","sql":"SELECT * FROM table WHERE name=?","dialect":"org.hibernate.dialect.H2Dialect","driverClass":"org.h2.Driver","url":"jdbc:h2:mem:syncopedb;DB_CLOSE_DELAY=-1","user":"username","password":"password","defaultCatalog":null,"defaultSchema":null,"healthQuery":"","idleTimeout":600.000000000,"dataSourceName":null,"minPoolSize":6,"maxPoolSize":18,"maxPoolWait":2.000000000,"poolSuspension":false,"poolTimeoutMillis":1000,"poolLeakThreshold":3000,"singleRow":true,"requireAllAttributes":true,"caseCanonicalization":"UPPER","queryType":"AND","columnMappings":{},"username":[],"caseInsensitiveQueryAttributes":[],"queryAttributes":{}}');


--
-- TOC entry 4592 (class 0 OID 16511)
-- Dependencies: 248
-- Data for Name: auditconf; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[SyncopeLogic]:[]:[isSelfRegAllowed]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[WA]:[]:[AUTHENTICATION]:[validate]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[WA]:[]:[AuthenticationEvent]:[auth]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[ConnectorLogic]:[]:[create]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[ConnectorLogic]:[]:[update]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[ResourceLogic]:[]:[create]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[ResourceLogic]:[]:[update]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[assign]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[confirmPasswordReset]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[create]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[deprovision]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[link]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[mustChangePassword]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[provision]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[requestPasswordReset]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[selfCreate]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[selfStatus]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[selfUpdate]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[status]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[unassign]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[unlink]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[update]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[GroupLogic]:[]:[assign]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[GroupLogic]:[]:[create]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[GroupLogic]:[]:[deprovision]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[GroupLogic]:[]:[provisionMembers]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[GroupLogic]:[]:[unassign]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[GroupLogic]:[]:[unlink]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[GroupLogic]:[]:[update]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[assign]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[create]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[delete]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[deprovision]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[link]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[provision]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[unassign]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[unlink]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[AnyObjectLogic]:[]:[update]:[SUCCESS]', 1);
INSERT INTO auditconf VALUES ('syncope.audit.[PULL]:[USER]:[resource-ldap]:[matchingrule_update]:[SUCCESS]', 0);
INSERT INTO auditconf VALUES ('syncope.audit.[PULL]:[USER]:[resource-ldap]:[unmatchingrule_assign]:[SUCCESS]', 0);
INSERT INTO auditconf VALUES ('syncope.audit.[PULL]:[USER]:[resource-ldap]:[unmatchingrule_provision]:[SUCCESS]', 0);
INSERT INTO auditconf VALUES ('syncope.audit.[CUSTOM]:[]:[]:[MY_EVENT]:[SUCCESS]', 0);
INSERT INTO auditconf VALUES ('syncope.audit.[LOGIC]:[UserLogic]:[]:[search]:[SUCCESS]', 0);


--
-- TOC entry 4593 (class 0 OID 16514)
-- Dependencies: 249
-- Data for Name: auditentry; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO auditentry VALUES ('2025-01-08 12:10:47.209', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:47.19806+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"createb0b192d2\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"createc6dd7731\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-1ad3-7c0a-a463-a3e2c0453c12\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"createb0b192d2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:45.976762+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:45.977406+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"createc6dd7731\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-1ad3-7c0a-a463-a3e2c0453c12\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-1ad3-7c0a-a463-a3e2c0453c12\"]},{\"schema\":\"LOCATION\",\"values\":[\"createc6dd7731\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"createb0b192d2\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-1ad3-7c0a-a463-a3e2c0453c12\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-1ad3-7c0a-a463-a3e2c0453c12\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:47.479', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:47.47827+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"deletableb6c33ae0\",\"realm\":\"/even\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"deletable057062a9\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\",\"type\":\"PRINTER\",\"realm\":\"/even\",\"name\":\"deletableb6c33ae0\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:47.348273+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:47.348759+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"deletable057062a9\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\"]},{\"schema\":\"LOCATION\",\"values\":[\"deletable057062a9\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"deletableb6c33ae0\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:47.663', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:47.662737+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\",\"type\":\"PRINTER\",\"realm\":\"/even\",\"name\":\"deletableb6c33ae0\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:47.348273+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:47.348759+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"deletable057062a9\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\"", "false"], "logger": {"type": "LOGIC", "event": "delete", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\",\"type\":null,\"realm\":null,\"name\":null,\"creator\":null,\"creationDate\":null,\"creationContext\":null,\"lastModifier\":null,\"lastChangeDate\":null,\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\"]},{\"schema\":\"LOCATION\",\"values\":[\"deletable057062a9\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"deletableb6c33ae0\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-2030-7bd9-a1fd-eef8cb0aa4bf\"]}]},\"afterObj\":null,\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:47.81', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:47.810314+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"readAttrs074003a0\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"readAttrs4eb5e92d\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-2192-7511-abcf-19c50963d57a\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"readAttrs074003a0\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:47.701384+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:47.701563+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"readAttrs4eb5e92d\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-2192-7511-abcf-19c50963d57a\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-2192-7511-abcf-19c50963d57a\"]},{\"schema\":\"LOCATION\",\"values\":[\"readAttrs4eb5e92d\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"readAttrs074003a0\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-2192-7511-abcf-19c50963d57a\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-2192-7511-abcf-19c50963d57a\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:53.226', 'DEBUG', 'syncope.audit.Master', '{"who": "syncope-user f8624c58-811d-4a41-80f4-d44bfeaba3e6", "date": "2025-01-08T12:11:53.226524+01:00", "before": "\"f9ae8446-1cec-4d82-8179-c473df89c379\"", "inputs": ["[]"], "logger": {"type": "WA", "event": "auth", "result": "SUCCESS", "category": null, "subcategory": "AuthenticationEvent"}, "output": "\"34ea1539-4c33-460b-a590-409a25dbd50c\"", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:54.35', 'DEBUG', 'syncope.audit.Master', '{"who": "syncope-user 3b8eb659-f681-4af9-bc44-915985621237", "date": "2025-01-08T12:11:54.350109+01:00", "before": "\"e9ffb25a-5eb5-42ec-a9b5-a743e2dd0697\"", "inputs": ["[]"], "logger": {"type": "WA", "event": "validate", "result": "SUCCESS", "category": null, "subcategory": "AUTHENTICATION"}, "output": "\"9cc7be41-8d93-4ca8-a03b-b10614451377\"", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:57.632', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:57.630698+01:00", "before": "{\"key\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.ldap.LdapConnector\",\"bundleName\":\"net.tirasa.connid.bundles.ldap\",\"version\":\"1.5.9\",\"conf\":[{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"The name or IP address of the host where the LDAP server is running.\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"localhost\"],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"TCP Port\",\"helpMessage\":\"TCP/IP port number used to communicate with the LDAP server. The default is 389.\",\"type\":\"int\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[389]},\"values\":[1389],\"overridable\":false},{\"schema\":{\"name\":\"ssl\",\"displayName\":\"SSL\",\"helpMessage\":\"Select the check box to connect to the LDAP server using SSL. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"failover\",\"displayName\":\"Failover Servers\",\"helpMessage\":\"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \\\"ldap://ldap.example.com:389/\\\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"principal\",\"displayName\":\"Principal\",\"helpMessage\":\"The distinguished name with which to authenticate to the LDAP server.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=admin,ou=system\"],\"overridable\":false},{\"schema\":{\"name\":\"credentials\",\"displayName\":\"Password\",\"helpMessage\":\"Password for the principal.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":6,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"secret\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContexts\",\"displayName\":\"Base Contexts\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":true},{\"schema\":{\"name\":\"passwordAttribute\",\"displayName\":\"Password Attribute\",\"helpMessage\":\"The name of the LDAP attribute which holds the password. When changing an user''s password, the new password is set to this attribute. Default is \\\"userPassword\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"userPassword\"]},\"values\":[\"userpassword\"],\"overridable\":false},{\"schema\":{\"name\":\"accountObjectClasses\",\"displayName\":\"Account Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"top\",\"person\",\"organizationalPerson\",\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\"],\"overridable\":false},{\"schema\":{\"name\":\"accountUserNameAttributes\",\"displayName\":\"Account User Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the account''s user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[\"uid\",\"cn\"]},\"values\":[\"uid\"],\"overridable\":false},{\"schema\":{\"name\":\"userSearchScope\",\"displayName\":\"User search scope\",\"helpMessage\":\"The scope to utilise when searching for users. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Accounts\",\"helpMessage\":\"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=*\"],\"overridable\":false},{\"schema\":{\"name\":\"groupObjectClasses\",\"displayName\":\"Group Object Classes\",\"helpMessage\":\"The group class or classes that will be used when creating new group objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple group classes. Some group classes may require that you specify all group classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[\"top\",\"groupOfUniqueNames\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupNameAttributes\",\"displayName\":\"Group Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the group''s name. Default is \\\"cn\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"cn\"]},\"values\":[\"cn\"],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchScope\",\"displayName\":\"Group search scope\",\"helpMessage\":\"The scope to utilise when searching for groups. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupMemberAttribute\",\"displayName\":\"Group Member Attribute\",\"helpMessage\":\"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group. Default is \\\"uniqueMember\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"uniqueMember\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"maintainLdapGroupMembership\",\"displayName\":\"Maintain LDAP Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"maintainPosixGroupMembership\",\"displayName\":\"Maintain POSIX Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"addPrincipalToNewGroups\",\"displayName\":\"Automatically add the configured principal as first member of a new group\",\"helpMessage\":\"When enabled, the configured principal is added as first member of a new group. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectClasses\",\"displayName\":\"Any-object Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new any-object objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":20,\"confidential\":false,\"defaultValues\":[\"top\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectNameAttributes\",\"displayName\":\"Any-object Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the any-object''s name. \",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":21,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchFilter\",\"displayName\":\"LDAP filter for retrieving Any Objects\",\"helpMessage\":\"An optional LDAP filter to control which any objects are returned from the LDAP resource. If no filter is specified, only any objects that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":22,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchScope\",\"displayName\":\"Any Object search scope\",\"helpMessage\":\"The scope to utilise when searching for any objects. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":23,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordHashAlgorithm\",\"displayName\":\"Password Hash Algorithm\",\"helpMessage\":\"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SMD5, and MD5. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).\",\"type\":\"java.lang.String\",\"required\":false,\"order\":24,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"SHA\"],\"overridable\":false},{\"schema\":{\"name\":\"respectResourcePasswordPolicyChangeAfterReset\",\"displayName\":\"Respect Resource Password Policy Change-After-Reset\",\"helpMessage\":\"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource''s password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":25,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"useVlvControls\",\"displayName\":\"Use VLV Controls\",\"helpMessage\":\"Wheter to enforce usage of VLV controls over standard LDAP controls. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":26,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"vlvSortAttribute\",\"displayName\":\"VLV Sort Attribute\",\"helpMessage\":\"Specify the sort attribute to use for VLV indexes on the resource. Default is \\\"uid\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":27,\"confidential\":false,\"defaultValues\":[\"uid\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"uidAttribute\",\"displayName\":\"Uid Attribute\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":28,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"gidAttribute\",\"displayName\":\"Uid Attribute for groups\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute for groups. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":29,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"aoidAttribute\",\"displayName\":\"aoidAttribute\",\"helpMessage\":\"aoidAttribute\",\"type\":\"java.lang.String\",\"required\":false,\"order\":30,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readSchema\",\"displayName\":\"Read Schema\",\"helpMessage\":\"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":31,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContextsToSynchronize\",\"displayName\":\"Base Contexts to Synchronize\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":32,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassesToSynchronize\",\"displayName\":\"Object Classes to Synchronize\",\"helpMessage\":\"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \\\"inetOrgPerson\\\" objects should be synchronized, but the superclasses of \\\"inetOrgPerson\\\" (\\\"person\\\", \\\"organizationalperson\\\" and \\\"top\\\") should be filtered out, then list only \\\"inetOrgPerson\\\" here. All objects in LDAP are subclassed from \\\"top\\\". For this reason, you should never list \\\"top\\\", otherwise no object would be filtered. Default is \\\"inetOrgPerson\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":33,\"confidential\":false,\"defaultValues\":[\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\",\"groupOfUniqueNames\"],\"overridable\":false},{\"schema\":{\"name\":\"attributesToSynchronize\",\"displayName\":\"Attributes to Synchronize\",\"helpMessage\":\"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \\\"department\\\" is listed, then only changes that affect \\\"department\\\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":34,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"modifiersNamesToFilterOut\",\"displayName\":\"Filter Out Changes By\",\"helpMessage\":\"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \\\"modifiersName\\\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \\\"cn=Directory Manager\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":35,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSynchronizationFilter\",\"displayName\":\"LDAP Filter for Accounts to Synchronize\",\"helpMessage\":\"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":36,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogBlockSize\",\"displayName\":\"Change Log Block Size\",\"helpMessage\":\"The number of change log entries to fetch per query. Default is \\\"100\\\".\",\"type\":\"int\",\"required\":false,\"order\":37,\"confidential\":false,\"defaultValues\":[100]},\"values\":[100],\"overridable\":false},{\"schema\":{\"name\":\"changeNumberAttribute\",\"displayName\":\"Change Number Attribute\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":38,\"confidential\":false,\"defaultValues\":[\"changeNumber\"]},\"values\":[\"changeNumber\"],\"overridable\":false},{\"schema\":{\"name\":\"changeLogContext\",\"displayName\":\"Change Log Context\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":39,\"confidential\":false,\"defaultValues\":[\"cn=changelog\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogPagingSupport\",\"displayName\":\"Change Log Paging Support\",\"helpMessage\":\"Whether to use paging when querying the change log.\",\"type\":\"boolean\",\"required\":false,\"order\":40,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"filterWithOrInsteadOfAnd\",\"displayName\":\"Filter with Or Instead of And\",\"helpMessage\":\"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":41,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"removeLogEntryObjectClassFromFilter\",\"displayName\":\"Remove Log Entry Object Class from Filter\",\"helpMessage\":\"If this property is set (the default), the filter used to fetch change log entries does not contain the \\\"changeLogEntry\\\" object class, expecting that there are no entries of other object types in the change log. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":42,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"synchronizePasswords\",\"displayName\":\"Enable Password Synchronization\",\"helpMessage\":\"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":43,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordAttributeToSynchronize\",\"displayName\":\"Password Attribute to Synchronize\",\"helpMessage\":\"The name of the password attribute to synchronize when performing password synchronization.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":44,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionKey\",\"displayName\":\"Password Decryption Key\",\"helpMessage\":\"The key to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":45,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionInitializationVector\",\"displayName\":\"Password Decryption Initialization Vector\",\"helpMessage\":\"The initialization vector to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":46,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusManagementClass\",\"displayName\":\"Status management class \",\"helpMessage\":\"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":47,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement\"],\"overridable\":false},{\"schema\":{\"name\":\"retrievePasswordsWithSearch\",\"displayName\":\"Retrieve passwords with search\",\"helpMessage\":\"Whether to retrieve user passwords when searching. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":48,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"dnAttribute\",\"displayName\":\"Entry DN attribute name\",\"helpMessage\":\"Entry DN attribute name (default: entryDN)\",\"type\":\"java.lang.String\",\"required\":false,\"order\":49,\"confidential\":false,\"defaultValues\":[\"entryDN\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Groups\",\"helpMessage\":\"An optional LDAP filter to control which groups are returned from the LDAP resource. If no filter is specified, only groups that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":50,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readTimeout\",\"displayName\":\"Read Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait for a response to be received. If there is no response within the specified time period, the read attempt will be aborted. Value 0 or less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":51,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectTimeout\",\"displayName\":\"Connection Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait when opening new server connections. Value of 0 means the TCP network timeout will be used, which may be several minutes. Value less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":52,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncStrategy\",\"displayName\":\"Sync strategy class\",\"helpMessage\":\"A class implementing LdapSyncStrategy to be used for sync operations\",\"type\":\"java.lang.String\",\"required\":false,\"order\":53,\"confidential\":false,\"defaultValues\":[\"net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"UPDATE_DELTA\",\"DELETE\",\"SEARCH\"],\"displayName\":\"TestLDAP\",\"connRequestTimeout\":10,\"poolConf\":null}", "inputs": ["{\"key\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.ldap.LdapConnector\",\"bundleName\":\"net.tirasa.connid.bundles.ldap\",\"version\":\"1.5.9\",\"conf\":[{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"The name or IP address of the host where the LDAP server is running.\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"localhost\"],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"TCP Port\",\"helpMessage\":\"TCP/IP port number used to communicate with the LDAP server. The default is 389.\",\"type\":\"int\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[389]},\"values\":[1389],\"overridable\":false},{\"schema\":{\"name\":\"ssl\",\"displayName\":\"SSL\",\"helpMessage\":\"Select the check box to connect to the LDAP server using SSL. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"failover\",\"displayName\":\"Failover Servers\",\"helpMessage\":\"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \\\"ldap://ldap.example.com:389/\\\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"principal\",\"displayName\":\"Principal\",\"helpMessage\":\"The distinguished name with which to authenticate to the LDAP server.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=admin,ou=system\"],\"overridable\":false},{\"schema\":{\"name\":\"credentials\",\"displayName\":\"Password\",\"helpMessage\":\"Password for the principal.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":6,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"secret\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContexts\",\"displayName\":\"Base Contexts\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":true},{\"schema\":{\"name\":\"passwordAttribute\",\"displayName\":\"Password Attribute\",\"helpMessage\":\"The name of the LDAP attribute which holds the password. When changing an user''s password, the new password is set to this attribute. Default is \\\"userPassword\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"userPassword\"]},\"values\":[\"userpassword\"],\"overridable\":false},{\"schema\":{\"name\":\"accountObjectClasses\",\"displayName\":\"Account Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"top\",\"person\",\"organizationalPerson\",\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\"],\"overridable\":false},{\"schema\":{\"name\":\"accountUserNameAttributes\",\"displayName\":\"Account User Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the account''s user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[\"uid\",\"cn\"]},\"values\":[\"uid\"],\"overridable\":false},{\"schema\":{\"name\":\"userSearchScope\",\"displayName\":\"User search scope\",\"helpMessage\":\"The scope to utilise when searching for users. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Accounts\",\"helpMessage\":\"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=*\"],\"overridable\":false},{\"schema\":{\"name\":\"groupObjectClasses\",\"displayName\":\"Group Object Classes\",\"helpMessage\":\"The group class or classes that will be used when creating new group objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple group classes. Some group classes may require that you specify all group classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[\"top\",\"groupOfUniqueNames\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupNameAttributes\",\"displayName\":\"Group Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the group''s name. Default is \\\"cn\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"cn\"]},\"values\":[\"cn\"],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchScope\",\"displayName\":\"Group search scope\",\"helpMessage\":\"The scope to utilise when searching for groups. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupMemberAttribute\",\"displayName\":\"Group Member Attribute\",\"helpMessage\":\"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group. Default is \\\"uniqueMember\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"uniqueMember\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"maintainLdapGroupMembership\",\"displayName\":\"Maintain LDAP Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"maintainPosixGroupMembership\",\"displayName\":\"Maintain POSIX Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"addPrincipalToNewGroups\",\"displayName\":\"Automatically add the configured principal as first member of a new group\",\"helpMessage\":\"When enabled, the configured principal is added as first member of a new group. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectClasses\",\"displayName\":\"Any-object Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new any-object objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":20,\"confidential\":false,\"defaultValues\":[\"top\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectNameAttributes\",\"displayName\":\"Any-object Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the any-object''s name. \",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":21,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchFilter\",\"displayName\":\"LDAP filter for retrieving Any Objects\",\"helpMessage\":\"An optional LDAP filter to control which any objects are returned from the LDAP resource. If no filter is specified, only any objects that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":22,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchScope\",\"displayName\":\"Any Object search scope\",\"helpMessage\":\"The scope to utilise when searching for any objects. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":23,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordHashAlgorithm\",\"displayName\":\"Password Hash Algorithm\",\"helpMessage\":\"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SMD5, and MD5. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).\",\"type\":\"java.lang.String\",\"required\":false,\"order\":24,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"SHA\"],\"overridable\":false},{\"schema\":{\"name\":\"respectResourcePasswordPolicyChangeAfterReset\",\"displayName\":\"Respect Resource Password Policy Change-After-Reset\",\"helpMessage\":\"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource''s password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":25,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"useVlvControls\",\"displayName\":\"Use VLV Controls\",\"helpMessage\":\"Wheter to enforce usage of VLV controls over standard LDAP controls. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":26,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"vlvSortAttribute\",\"displayName\":\"VLV Sort Attribute\",\"helpMessage\":\"Specify the sort attribute to use for VLV indexes on the resource. Default is \\\"uid\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":27,\"confidential\":false,\"defaultValues\":[\"uid\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"uidAttribute\",\"displayName\":\"Uid Attribute\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":28,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"gidAttribute\",\"displayName\":\"Uid Attribute for groups\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute for groups. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":29,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"aoidAttribute\",\"displayName\":\"aoidAttribute\",\"helpMessage\":\"aoidAttribute\",\"type\":\"java.lang.String\",\"required\":false,\"order\":30,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readSchema\",\"displayName\":\"Read Schema\",\"helpMessage\":\"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":31,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContextsToSynchronize\",\"displayName\":\"Base Contexts to Synchronize\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":32,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassesToSynchronize\",\"displayName\":\"Object Classes to Synchronize\",\"helpMessage\":\"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \\\"inetOrgPerson\\\" objects should be synchronized, but the superclasses of \\\"inetOrgPerson\\\" (\\\"person\\\", \\\"organizationalperson\\\" and \\\"top\\\") should be filtered out, then list only \\\"inetOrgPerson\\\" here. All objects in LDAP are subclassed from \\\"top\\\". For this reason, you should never list \\\"top\\\", otherwise no object would be filtered. Default is \\\"inetOrgPerson\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":33,\"confidential\":false,\"defaultValues\":[\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\",\"groupOfUniqueNames\"],\"overridable\":false},{\"schema\":{\"name\":\"attributesToSynchronize\",\"displayName\":\"Attributes to Synchronize\",\"helpMessage\":\"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \\\"department\\\" is listed, then only changes that affect \\\"department\\\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":34,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"modifiersNamesToFilterOut\",\"displayName\":\"Filter Out Changes By\",\"helpMessage\":\"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \\\"modifiersName\\\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \\\"cn=Directory Manager\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":35,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSynchronizationFilter\",\"displayName\":\"LDAP Filter for Accounts to Synchronize\",\"helpMessage\":\"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":36,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogBlockSize\",\"displayName\":\"Change Log Block Size\",\"helpMessage\":\"The number of change log entries to fetch per query. Default is \\\"100\\\".\",\"type\":\"int\",\"required\":false,\"order\":37,\"confidential\":false,\"defaultValues\":[100]},\"values\":[100],\"overridable\":false},{\"schema\":{\"name\":\"changeNumberAttribute\",\"displayName\":\"Change Number Attribute\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":38,\"confidential\":false,\"defaultValues\":[\"changeNumber\"]},\"values\":[\"changeNumber\"],\"overridable\":false},{\"schema\":{\"name\":\"changeLogContext\",\"displayName\":\"Change Log Context\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":39,\"confidential\":false,\"defaultValues\":[\"cn=changelog\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogPagingSupport\",\"displayName\":\"Change Log Paging Support\",\"helpMessage\":\"Whether to use paging when querying the change log.\",\"type\":\"boolean\",\"required\":false,\"order\":40,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"filterWithOrInsteadOfAnd\",\"displayName\":\"Filter with Or Instead of And\",\"helpMessage\":\"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":41,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"removeLogEntryObjectClassFromFilter\",\"displayName\":\"Remove Log Entry Object Class from Filter\",\"helpMessage\":\"If this property is set (the default), the filter used to fetch change log entries does not contain the \\\"changeLogEntry\\\" object class, expecting that there are no entries of other object types in the change log. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":42,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"synchronizePasswords\",\"displayName\":\"Enable Password Synchronization\",\"helpMessage\":\"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":43,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordAttributeToSynchronize\",\"displayName\":\"Password Attribute to Synchronize\",\"helpMessage\":\"The name of the password attribute to synchronize when performing password synchronization.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":44,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionKey\",\"displayName\":\"Password Decryption Key\",\"helpMessage\":\"The key to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":45,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionInitializationVector\",\"displayName\":\"Password Decryption Initialization Vector\",\"helpMessage\":\"The initialization vector to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":46,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusManagementClass\",\"displayName\":\"Status management class \",\"helpMessage\":\"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":47,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement\"],\"overridable\":false},{\"schema\":{\"name\":\"retrievePasswordsWithSearch\",\"displayName\":\"Retrieve passwords with search\",\"helpMessage\":\"Whether to retrieve user passwords when searching. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":48,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"dnAttribute\",\"displayName\":\"Entry DN attribute name\",\"helpMessage\":\"Entry DN attribute name (default: entryDN)\",\"type\":\"java.lang.String\",\"required\":false,\"order\":49,\"confidential\":false,\"defaultValues\":[\"entryDN\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Groups\",\"helpMessage\":\"An optional LDAP filter to control which groups are returned from the LDAP resource. If no filter is specified, only groups that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":50,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readTimeout\",\"displayName\":\"Read Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait for a response to be received. If there is no response within the specified time period, the read attempt will be aborted. Value 0 or less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":51,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectTimeout\",\"displayName\":\"Connection Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait when opening new server connections. Value of 0 means the TCP network timeout will be used, which may be several minutes. Value less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":52,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncStrategy\",\"displayName\":\"Sync strategy class\",\"helpMessage\":\"A class implementing LdapSyncStrategy to be used for sync operations\",\"type\":\"java.lang.String\",\"required\":false,\"order\":53,\"confidential\":false,\"defaultValues\":[\"net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"TestLDAP modified\",\"connRequestTimeout\":10,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.ldap.LdapConnector\",\"bundleName\":\"net.tirasa.connid.bundles.ldap\",\"version\":\"1.5.9\",\"conf\":[{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"The name or IP address of the host where the LDAP server is running.\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"localhost\"],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"TCP Port\",\"helpMessage\":\"TCP/IP port number used to communicate with the LDAP server. The default is 389.\",\"type\":\"int\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[389]},\"values\":[1389],\"overridable\":false},{\"schema\":{\"name\":\"ssl\",\"displayName\":\"SSL\",\"helpMessage\":\"Select the check box to connect to the LDAP server using SSL. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"failover\",\"displayName\":\"Failover Servers\",\"helpMessage\":\"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \\\"ldap://ldap.example.com:389/\\\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"principal\",\"displayName\":\"Principal\",\"helpMessage\":\"The distinguished name with which to authenticate to the LDAP server.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=admin,ou=system\"],\"overridable\":false},{\"schema\":{\"name\":\"credentials\",\"displayName\":\"Password\",\"helpMessage\":\"Password for the principal.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":6,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"secret\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContexts\",\"displayName\":\"Base Contexts\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":true},{\"schema\":{\"name\":\"passwordAttribute\",\"displayName\":\"Password Attribute\",\"helpMessage\":\"The name of the LDAP attribute which holds the password. When changing an user''s password, the new password is set to this attribute. Default is \\\"userPassword\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"userPassword\"]},\"values\":[\"userpassword\"],\"overridable\":false},{\"schema\":{\"name\":\"accountObjectClasses\",\"displayName\":\"Account Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"top\",\"person\",\"organizationalPerson\",\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\"],\"overridable\":false},{\"schema\":{\"name\":\"accountUserNameAttributes\",\"displayName\":\"Account User Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the account''s user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[\"uid\",\"cn\"]},\"values\":[\"uid\"],\"overridable\":false},{\"schema\":{\"name\":\"userSearchScope\",\"displayName\":\"User search scope\",\"helpMessage\":\"The scope to utilise when searching for users. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Accounts\",\"helpMessage\":\"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=*\"],\"overridable\":false},{\"schema\":{\"name\":\"groupObjectClasses\",\"displayName\":\"Group Object Classes\",\"helpMessage\":\"The group class or classes that will be used when creating new group objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple group classes. Some group classes may require that you specify all group classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[\"top\",\"groupOfUniqueNames\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupNameAttributes\",\"displayName\":\"Group Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the group''s name. Default is \\\"cn\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"cn\"]},\"values\":[\"cn\"],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchScope\",\"displayName\":\"Group search scope\",\"helpMessage\":\"The scope to utilise when searching for groups. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupMemberAttribute\",\"displayName\":\"Group Member Attribute\",\"helpMessage\":\"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group. Default is \\\"uniqueMember\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"uniqueMember\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"maintainLdapGroupMembership\",\"displayName\":\"Maintain LDAP Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"maintainPosixGroupMembership\",\"displayName\":\"Maintain POSIX Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"addPrincipalToNewGroups\",\"displayName\":\"Automatically add the configured principal as first member of a new group\",\"helpMessage\":\"When enabled, the configured principal is added as first member of a new group. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectClasses\",\"displayName\":\"Any-object Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new any-object objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":20,\"confidential\":false,\"defaultValues\":[\"top\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectNameAttributes\",\"displayName\":\"Any-object Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the any-object''s name. \",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":21,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchFilter\",\"displayName\":\"LDAP filter for retrieving Any Objects\",\"helpMessage\":\"An optional LDAP filter to control which any objects are returned from the LDAP resource. If no filter is specified, only any objects that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":22,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchScope\",\"displayName\":\"Any Object search scope\",\"helpMessage\":\"The scope to utilise when searching for any objects. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":23,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordHashAlgorithm\",\"displayName\":\"Password Hash Algorithm\",\"helpMessage\":\"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SMD5, and MD5. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).\",\"type\":\"java.lang.String\",\"required\":false,\"order\":24,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"SHA\"],\"overridable\":false},{\"schema\":{\"name\":\"respectResourcePasswordPolicyChangeAfterReset\",\"displayName\":\"Respect Resource Password Policy Change-After-Reset\",\"helpMessage\":\"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource''s password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":25,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"useVlvControls\",\"displayName\":\"Use VLV Controls\",\"helpMessage\":\"Wheter to enforce usage of VLV controls over standard LDAP controls. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":26,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"vlvSortAttribute\",\"displayName\":\"VLV Sort Attribute\",\"helpMessage\":\"Specify the sort attribute to use for VLV indexes on the resource. Default is \\\"uid\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":27,\"confidential\":false,\"defaultValues\":[\"uid\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"uidAttribute\",\"displayName\":\"Uid Attribute\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":28,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"gidAttribute\",\"displayName\":\"Uid Attribute for groups\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute for groups. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":29,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"aoidAttribute\",\"displayName\":\"aoidAttribute\",\"helpMessage\":\"aoidAttribute\",\"type\":\"java.lang.String\",\"required\":false,\"order\":30,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readSchema\",\"displayName\":\"Read Schema\",\"helpMessage\":\"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":31,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContextsToSynchronize\",\"displayName\":\"Base Contexts to Synchronize\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":32,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassesToSynchronize\",\"displayName\":\"Object Classes to Synchronize\",\"helpMessage\":\"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \\\"inetOrgPerson\\\" objects should be synchronized, but the superclasses of \\\"inetOrgPerson\\\" (\\\"person\\\", \\\"organizationalperson\\\" and \\\"top\\\") should be filtered out, then list only \\\"inetOrgPerson\\\" here. All objects in LDAP are subclassed from \\\"top\\\". For this reason, you should never list \\\"top\\\", otherwise no object would be filtered. Default is \\\"inetOrgPerson\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":33,\"confidential\":false,\"defaultValues\":[\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\",\"groupOfUniqueNames\"],\"overridable\":false},{\"schema\":{\"name\":\"attributesToSynchronize\",\"displayName\":\"Attributes to Synchronize\",\"helpMessage\":\"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \\\"department\\\" is listed, then only changes that affect \\\"department\\\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":34,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"modifiersNamesToFilterOut\",\"displayName\":\"Filter Out Changes By\",\"helpMessage\":\"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \\\"modifiersName\\\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \\\"cn=Directory Manager\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":35,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSynchronizationFilter\",\"displayName\":\"LDAP Filter for Accounts to Synchronize\",\"helpMessage\":\"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":36,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogBlockSize\",\"displayName\":\"Change Log Block Size\",\"helpMessage\":\"The number of change log entries to fetch per query. Default is \\\"100\\\".\",\"type\":\"int\",\"required\":false,\"order\":37,\"confidential\":false,\"defaultValues\":[100]},\"values\":[100],\"overridable\":false},{\"schema\":{\"name\":\"changeNumberAttribute\",\"displayName\":\"Change Number Attribute\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":38,\"confidential\":false,\"defaultValues\":[\"changeNumber\"]},\"values\":[\"changeNumber\"],\"overridable\":false},{\"schema\":{\"name\":\"changeLogContext\",\"displayName\":\"Change Log Context\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":39,\"confidential\":false,\"defaultValues\":[\"cn=changelog\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogPagingSupport\",\"displayName\":\"Change Log Paging Support\",\"helpMessage\":\"Whether to use paging when querying the change log.\",\"type\":\"boolean\",\"required\":false,\"order\":40,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"filterWithOrInsteadOfAnd\",\"displayName\":\"Filter with Or Instead of And\",\"helpMessage\":\"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":41,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"removeLogEntryObjectClassFromFilter\",\"displayName\":\"Remove Log Entry Object Class from Filter\",\"helpMessage\":\"If this property is set (the default), the filter used to fetch change log entries does not contain the \\\"changeLogEntry\\\" object class, expecting that there are no entries of other object types in the change log. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":42,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"synchronizePasswords\",\"displayName\":\"Enable Password Synchronization\",\"helpMessage\":\"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":43,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordAttributeToSynchronize\",\"displayName\":\"Password Attribute to Synchronize\",\"helpMessage\":\"The name of the password attribute to synchronize when performing password synchronization.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":44,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionKey\",\"displayName\":\"Password Decryption Key\",\"helpMessage\":\"The key to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":45,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionInitializationVector\",\"displayName\":\"Password Decryption Initialization Vector\",\"helpMessage\":\"The initialization vector to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":46,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusManagementClass\",\"displayName\":\"Status management class \",\"helpMessage\":\"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":47,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement\"],\"overridable\":false},{\"schema\":{\"name\":\"retrievePasswordsWithSearch\",\"displayName\":\"Retrieve passwords with search\",\"helpMessage\":\"Whether to retrieve user passwords when searching. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":48,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"dnAttribute\",\"displayName\":\"Entry DN attribute name\",\"helpMessage\":\"Entry DN attribute name (default: entryDN)\",\"type\":\"java.lang.String\",\"required\":false,\"order\":49,\"confidential\":false,\"defaultValues\":[\"entryDN\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Groups\",\"helpMessage\":\"An optional LDAP filter to control which groups are returned from the LDAP resource. If no filter is specified, only groups that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":50,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readTimeout\",\"displayName\":\"Read Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait for a response to be received. If there is no response within the specified time period, the read attempt will be aborted. Value 0 or less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":51,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectTimeout\",\"displayName\":\"Connection Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait when opening new server connections. Value of 0 means the TCP network timeout will be used, which may be several minutes. Value less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":52,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncStrategy\",\"displayName\":\"Sync strategy class\",\"helpMessage\":\"A class implementing LdapSyncStrategy to be used for sync operations\",\"type\":\"java.lang.String\",\"required\":false,\"order\":53,\"confidential\":false,\"defaultValues\":[\"net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"TestLDAP modified\",\"connRequestTimeout\":10,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.064', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.063817+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"updated3601851\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"update5bb35ce3\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-2295-73ca-8242-b175f4bc7e54\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"updated3601851\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:47.960323+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:47.960487+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"update5bb35ce3\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-2295-73ca-8242-b175f4bc7e54\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]},{\"schema\":\"LOCATION\",\"values\":[\"update5bb35ce3\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"updated3601851\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.289', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.285729+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-2295-73ca-8242-b175f4bc7e54\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"updated3601851\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:47.960323+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:47.960487+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"update5bb35ce3\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459c-2295-73ca-8242-b175f4bc7e54\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"location\",\"values\":[\"new826cab85\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-2295-73ca-8242-b175f4bc7e54\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"updated3601851\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:47.960323+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.157023+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"new826cab85\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==0194459c-2295-73ca-8242-b175f4bc7e54\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]},{\"schema\":\"LOCATION\",\"values\":[\"update5bb35ce3\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"updated3601851\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]}]},\"afterObj\":{\"fiql\":\"__UID__==0194459c-2295-73ca-8242-b175f4bc7e54\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]},{\"schema\":\"LOCATION\",\"values\":[\"new826cab85\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"updated3601851\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-2295-73ca-8242-b175f4bc7e54\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.49', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.488379+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Canon MF 8030cn\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"2nd floor\"]},{\"schema\":\"model\",\"values\":[\"HP Laserjet 1300n\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"realm\":null,\"auxClasses\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"csv\"}],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"resource-db-scripted\"}],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Canon MF 8030cn\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.377579+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"2nd floor\"]},{\"schema\":\"model\",\"values\":[\"HP Laserjet 1300n\"]}],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\"]},{\"schema\":\"LOCATION\",\"values\":[\"2nd floor\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"Canon MF 8030cn\"]},{\"schema\":\"__NAME__\",\"values\":[\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\"]},{\"schema\":\"__UID__\",\"values\":[\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.564', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.564083+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Canon MF 8030cn\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.377579+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"2nd floor\"]},{\"schema\":\"model\",\"values\":[\"HP Laserjet 1300n\"]}],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"realm\":null,\"auxClasses\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"csv\"}],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"resource-db-scripted\"}],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Canon MF 8030cn\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.537646+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"2nd floor\"]},{\"schema\":\"model\",\"values\":[\"HP Laserjet 1300n\"]}],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.716', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.716004+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Canon MF 8030cn\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.537646+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"2nd floor\"]},{\"schema\":\"model\",\"values\":[\"HP Laserjet 1300n\"]}],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"realm\":null,\"auxClasses\":[{\"operation\":\"DELETE\",\"value\":\"csv\"}],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"DELETE\",\"value\":\"resource-db-scripted\"}],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Canon MF 8030cn\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.609544+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"2nd floor\"]},{\"schema\":\"model\",\"values\":[\"HP Laserjet 1300n\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==8559d14d-58c2-46eb-a2d4-a7d35161e8f8\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\"]},{\"schema\":\"LOCATION\",\"values\":[\"2nd floor\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"Canon MF 8030cn\"]},{\"schema\":\"__NAME__\",\"values\":[\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\"]},{\"schema\":\"__UID__\",\"values\":[\"8559d14d-58c2-46eb-a2d4-a7d35161e8f8\"]}]},\"afterObj\":null,\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.766', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.766358+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"printer16c76119b\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer17ad43db7\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-25ab-779c-b055-80c9cf1bd6b4\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"printer16c76119b\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.750645+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.750763+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer17ad43db7\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:58.701', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:58.699692+01:00", "before": "{\"key\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.ldap.LdapConnector\",\"bundleName\":\"net.tirasa.connid.bundles.ldap\",\"version\":\"1.5.9\",\"conf\":[{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"The name or IP address of the host where the LDAP server is running.\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"localhost\"],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"TCP Port\",\"helpMessage\":\"TCP/IP port number used to communicate with the LDAP server. The default is 389.\",\"type\":\"int\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[389]},\"values\":[1389],\"overridable\":false},{\"schema\":{\"name\":\"ssl\",\"displayName\":\"SSL\",\"helpMessage\":\"Select the check box to connect to the LDAP server using SSL. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"failover\",\"displayName\":\"Failover Servers\",\"helpMessage\":\"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \\\"ldap://ldap.example.com:389/\\\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"principal\",\"displayName\":\"Principal\",\"helpMessage\":\"The distinguished name with which to authenticate to the LDAP server.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=admin,ou=system\"],\"overridable\":false},{\"schema\":{\"name\":\"credentials\",\"displayName\":\"Password\",\"helpMessage\":\"Password for the principal.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":6,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"secret\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContexts\",\"displayName\":\"Base Contexts\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":true},{\"schema\":{\"name\":\"passwordAttribute\",\"displayName\":\"Password Attribute\",\"helpMessage\":\"The name of the LDAP attribute which holds the password. When changing an user''s password, the new password is set to this attribute. Default is \\\"userPassword\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"userPassword\"]},\"values\":[\"userpassword\"],\"overridable\":false},{\"schema\":{\"name\":\"accountObjectClasses\",\"displayName\":\"Account Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"top\",\"person\",\"organizationalPerson\",\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\"],\"overridable\":false},{\"schema\":{\"name\":\"accountUserNameAttributes\",\"displayName\":\"Account User Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the account''s user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[\"uid\",\"cn\"]},\"values\":[\"uid\"],\"overridable\":false},{\"schema\":{\"name\":\"userSearchScope\",\"displayName\":\"User search scope\",\"helpMessage\":\"The scope to utilise when searching for users. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Accounts\",\"helpMessage\":\"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=*\"],\"overridable\":false},{\"schema\":{\"name\":\"groupObjectClasses\",\"displayName\":\"Group Object Classes\",\"helpMessage\":\"The group class or classes that will be used when creating new group objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple group classes. Some group classes may require that you specify all group classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[\"top\",\"groupOfUniqueNames\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupNameAttributes\",\"displayName\":\"Group Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the group''s name. Default is \\\"cn\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"cn\"]},\"values\":[\"cn\"],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchScope\",\"displayName\":\"Group search scope\",\"helpMessage\":\"The scope to utilise when searching for groups. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupMemberAttribute\",\"displayName\":\"Group Member Attribute\",\"helpMessage\":\"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group. Default is \\\"uniqueMember\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"uniqueMember\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"maintainLdapGroupMembership\",\"displayName\":\"Maintain LDAP Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"maintainPosixGroupMembership\",\"displayName\":\"Maintain POSIX Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"addPrincipalToNewGroups\",\"displayName\":\"Automatically add the configured principal as first member of a new group\",\"helpMessage\":\"When enabled, the configured principal is added as first member of a new group. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectClasses\",\"displayName\":\"Any-object Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new any-object objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":20,\"confidential\":false,\"defaultValues\":[\"top\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectNameAttributes\",\"displayName\":\"Any-object Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the any-object''s name. \",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":21,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchFilter\",\"displayName\":\"LDAP filter for retrieving Any Objects\",\"helpMessage\":\"An optional LDAP filter to control which any objects are returned from the LDAP resource. If no filter is specified, only any objects that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":22,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchScope\",\"displayName\":\"Any Object search scope\",\"helpMessage\":\"The scope to utilise when searching for any objects. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":23,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordHashAlgorithm\",\"displayName\":\"Password Hash Algorithm\",\"helpMessage\":\"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SMD5, and MD5. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).\",\"type\":\"java.lang.String\",\"required\":false,\"order\":24,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"SHA\"],\"overridable\":false},{\"schema\":{\"name\":\"respectResourcePasswordPolicyChangeAfterReset\",\"displayName\":\"Respect Resource Password Policy Change-After-Reset\",\"helpMessage\":\"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource''s password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":25,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"useVlvControls\",\"displayName\":\"Use VLV Controls\",\"helpMessage\":\"Wheter to enforce usage of VLV controls over standard LDAP controls. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":26,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"vlvSortAttribute\",\"displayName\":\"VLV Sort Attribute\",\"helpMessage\":\"Specify the sort attribute to use for VLV indexes on the resource. Default is \\\"uid\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":27,\"confidential\":false,\"defaultValues\":[\"uid\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"uidAttribute\",\"displayName\":\"Uid Attribute\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":28,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"gidAttribute\",\"displayName\":\"Uid Attribute for groups\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute for groups. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":29,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"aoidAttribute\",\"displayName\":\"aoidAttribute\",\"helpMessage\":\"aoidAttribute\",\"type\":\"java.lang.String\",\"required\":false,\"order\":30,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readSchema\",\"displayName\":\"Read Schema\",\"helpMessage\":\"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":31,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContextsToSynchronize\",\"displayName\":\"Base Contexts to Synchronize\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":32,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassesToSynchronize\",\"displayName\":\"Object Classes to Synchronize\",\"helpMessage\":\"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \\\"inetOrgPerson\\\" objects should be synchronized, but the superclasses of \\\"inetOrgPerson\\\" (\\\"person\\\", \\\"organizationalperson\\\" and \\\"top\\\") should be filtered out, then list only \\\"inetOrgPerson\\\" here. All objects in LDAP are subclassed from \\\"top\\\". For this reason, you should never list \\\"top\\\", otherwise no object would be filtered. Default is \\\"inetOrgPerson\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":33,\"confidential\":false,\"defaultValues\":[\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\",\"groupOfUniqueNames\"],\"overridable\":false},{\"schema\":{\"name\":\"attributesToSynchronize\",\"displayName\":\"Attributes to Synchronize\",\"helpMessage\":\"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \\\"department\\\" is listed, then only changes that affect \\\"department\\\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":34,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"modifiersNamesToFilterOut\",\"displayName\":\"Filter Out Changes By\",\"helpMessage\":\"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \\\"modifiersName\\\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \\\"cn=Directory Manager\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":35,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSynchronizationFilter\",\"displayName\":\"LDAP Filter for Accounts to Synchronize\",\"helpMessage\":\"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":36,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogBlockSize\",\"displayName\":\"Change Log Block Size\",\"helpMessage\":\"The number of change log entries to fetch per query. Default is \\\"100\\\".\",\"type\":\"int\",\"required\":false,\"order\":37,\"confidential\":false,\"defaultValues\":[100]},\"values\":[100],\"overridable\":false},{\"schema\":{\"name\":\"changeNumberAttribute\",\"displayName\":\"Change Number Attribute\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":38,\"confidential\":false,\"defaultValues\":[\"changeNumber\"]},\"values\":[\"changeNumber\"],\"overridable\":false},{\"schema\":{\"name\":\"changeLogContext\",\"displayName\":\"Change Log Context\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":39,\"confidential\":false,\"defaultValues\":[\"cn=changelog\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogPagingSupport\",\"displayName\":\"Change Log Paging Support\",\"helpMessage\":\"Whether to use paging when querying the change log.\",\"type\":\"boolean\",\"required\":false,\"order\":40,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"filterWithOrInsteadOfAnd\",\"displayName\":\"Filter with Or Instead of And\",\"helpMessage\":\"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":41,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"removeLogEntryObjectClassFromFilter\",\"displayName\":\"Remove Log Entry Object Class from Filter\",\"helpMessage\":\"If this property is set (the default), the filter used to fetch change log entries does not contain the \\\"changeLogEntry\\\" object class, expecting that there are no entries of other object types in the change log. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":42,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"synchronizePasswords\",\"displayName\":\"Enable Password Synchronization\",\"helpMessage\":\"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":43,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordAttributeToSynchronize\",\"displayName\":\"Password Attribute to Synchronize\",\"helpMessage\":\"The name of the password attribute to synchronize when performing password synchronization.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":44,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionKey\",\"displayName\":\"Password Decryption Key\",\"helpMessage\":\"The key to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":45,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionInitializationVector\",\"displayName\":\"Password Decryption Initialization Vector\",\"helpMessage\":\"The initialization vector to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":46,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusManagementClass\",\"displayName\":\"Status management class \",\"helpMessage\":\"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":47,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement\"],\"overridable\":false},{\"schema\":{\"name\":\"retrievePasswordsWithSearch\",\"displayName\":\"Retrieve passwords with search\",\"helpMessage\":\"Whether to retrieve user passwords when searching. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":48,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"dnAttribute\",\"displayName\":\"Entry DN attribute name\",\"helpMessage\":\"Entry DN attribute name (default: entryDN)\",\"type\":\"java.lang.String\",\"required\":false,\"order\":49,\"confidential\":false,\"defaultValues\":[\"entryDN\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Groups\",\"helpMessage\":\"An optional LDAP filter to control which groups are returned from the LDAP resource. If no filter is specified, only groups that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":50,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readTimeout\",\"displayName\":\"Read Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait for a response to be received. If there is no response within the specified time period, the read attempt will be aborted. Value 0 or less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":51,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectTimeout\",\"displayName\":\"Connection Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait when opening new server connections. Value of 0 means the TCP network timeout will be used, which may be several minutes. Value less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":52,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncStrategy\",\"displayName\":\"Sync strategy class\",\"helpMessage\":\"A class implementing LdapSyncStrategy to be used for sync operations\",\"type\":\"java.lang.String\",\"required\":false,\"order\":53,\"confidential\":false,\"defaultValues\":[\"net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"TestLDAP modified\",\"connRequestTimeout\":10,\"poolConf\":null}", "inputs": ["{\"key\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.ldap.LdapConnector\",\"bundleName\":\"net.tirasa.connid.bundles.ldap\",\"version\":\"1.5.9\",\"conf\":[{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"The name or IP address of the host where the LDAP server is running.\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"localhost\"],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"TCP Port\",\"helpMessage\":\"TCP/IP port number used to communicate with the LDAP server. The default is 389.\",\"type\":\"int\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[389]},\"values\":[1389],\"overridable\":false},{\"schema\":{\"name\":\"ssl\",\"displayName\":\"SSL\",\"helpMessage\":\"Select the check box to connect to the LDAP server using SSL. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"failover\",\"displayName\":\"Failover Servers\",\"helpMessage\":\"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \\\"ldap://ldap.example.com:389/\\\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"principal\",\"displayName\":\"Principal\",\"helpMessage\":\"The distinguished name with which to authenticate to the LDAP server.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=admin,ou=system\"],\"overridable\":false},{\"schema\":{\"name\":\"credentials\",\"displayName\":\"Password\",\"helpMessage\":\"Password for the principal.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":6,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"secret\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContexts\",\"displayName\":\"Base Contexts\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":true},{\"schema\":{\"name\":\"passwordAttribute\",\"displayName\":\"Password Attribute\",\"helpMessage\":\"The name of the LDAP attribute which holds the password. When changing an user''s password, the new password is set to this attribute. Default is \\\"userPassword\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"userPassword\"]},\"values\":[\"userpassword\"],\"overridable\":false},{\"schema\":{\"name\":\"accountObjectClasses\",\"displayName\":\"Account Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"top\",\"person\",\"organizationalPerson\",\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\"],\"overridable\":false},{\"schema\":{\"name\":\"accountUserNameAttributes\",\"displayName\":\"Account User Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the account''s user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[\"uid\",\"cn\"]},\"values\":[\"uid\"],\"overridable\":false},{\"schema\":{\"name\":\"userSearchScope\",\"displayName\":\"User search scope\",\"helpMessage\":\"The scope to utilise when searching for users. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Accounts\",\"helpMessage\":\"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=*\"],\"overridable\":false},{\"schema\":{\"name\":\"groupObjectClasses\",\"displayName\":\"Group Object Classes\",\"helpMessage\":\"The group class or classes that will be used when creating new group objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple group classes. Some group classes may require that you specify all group classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[\"top\",\"groupOfUniqueNames\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupNameAttributes\",\"displayName\":\"Group Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the group''s name. Default is \\\"cn\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"cn\"]},\"values\":[\"cn\"],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchScope\",\"displayName\":\"Group search scope\",\"helpMessage\":\"The scope to utilise when searching for groups. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupMemberAttribute\",\"displayName\":\"Group Member Attribute\",\"helpMessage\":\"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group. Default is \\\"uniqueMember\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"uniqueMember\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"maintainLdapGroupMembership\",\"displayName\":\"Maintain LDAP Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"maintainPosixGroupMembership\",\"displayName\":\"Maintain POSIX Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"addPrincipalToNewGroups\",\"displayName\":\"Automatically add the configured principal as first member of a new group\",\"helpMessage\":\"When enabled, the configured principal is added as first member of a new group. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectClasses\",\"displayName\":\"Any-object Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new any-object objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":20,\"confidential\":false,\"defaultValues\":[\"top\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectNameAttributes\",\"displayName\":\"Any-object Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the any-object''s name. \",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":21,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchFilter\",\"displayName\":\"LDAP filter for retrieving Any Objects\",\"helpMessage\":\"An optional LDAP filter to control which any objects are returned from the LDAP resource. If no filter is specified, only any objects that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":22,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchScope\",\"displayName\":\"Any Object search scope\",\"helpMessage\":\"The scope to utilise when searching for any objects. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":23,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordHashAlgorithm\",\"displayName\":\"Password Hash Algorithm\",\"helpMessage\":\"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SMD5, and MD5. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).\",\"type\":\"java.lang.String\",\"required\":false,\"order\":24,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"SHA\"],\"overridable\":false},{\"schema\":{\"name\":\"respectResourcePasswordPolicyChangeAfterReset\",\"displayName\":\"Respect Resource Password Policy Change-After-Reset\",\"helpMessage\":\"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource''s password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":25,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"useVlvControls\",\"displayName\":\"Use VLV Controls\",\"helpMessage\":\"Wheter to enforce usage of VLV controls over standard LDAP controls. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":26,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"vlvSortAttribute\",\"displayName\":\"VLV Sort Attribute\",\"helpMessage\":\"Specify the sort attribute to use for VLV indexes on the resource. Default is \\\"uid\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":27,\"confidential\":false,\"defaultValues\":[\"uid\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"uidAttribute\",\"displayName\":\"Uid Attribute\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":28,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"gidAttribute\",\"displayName\":\"Uid Attribute for groups\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute for groups. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":29,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"aoidAttribute\",\"displayName\":\"aoidAttribute\",\"helpMessage\":\"aoidAttribute\",\"type\":\"java.lang.String\",\"required\":false,\"order\":30,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readSchema\",\"displayName\":\"Read Schema\",\"helpMessage\":\"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":31,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContextsToSynchronize\",\"displayName\":\"Base Contexts to Synchronize\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":32,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassesToSynchronize\",\"displayName\":\"Object Classes to Synchronize\",\"helpMessage\":\"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \\\"inetOrgPerson\\\" objects should be synchronized, but the superclasses of \\\"inetOrgPerson\\\" (\\\"person\\\", \\\"organizationalperson\\\" and \\\"top\\\") should be filtered out, then list only \\\"inetOrgPerson\\\" here. All objects in LDAP are subclassed from \\\"top\\\". For this reason, you should never list \\\"top\\\", otherwise no object would be filtered. Default is \\\"inetOrgPerson\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":33,\"confidential\":false,\"defaultValues\":[\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\",\"groupOfUniqueNames\"],\"overridable\":false},{\"schema\":{\"name\":\"attributesToSynchronize\",\"displayName\":\"Attributes to Synchronize\",\"helpMessage\":\"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \\\"department\\\" is listed, then only changes that affect \\\"department\\\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":34,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"modifiersNamesToFilterOut\",\"displayName\":\"Filter Out Changes By\",\"helpMessage\":\"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \\\"modifiersName\\\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \\\"cn=Directory Manager\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":35,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSynchronizationFilter\",\"displayName\":\"LDAP Filter for Accounts to Synchronize\",\"helpMessage\":\"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":36,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogBlockSize\",\"displayName\":\"Change Log Block Size\",\"helpMessage\":\"The number of change log entries to fetch per query. Default is \\\"100\\\".\",\"type\":\"int\",\"required\":false,\"order\":37,\"confidential\":false,\"defaultValues\":[100]},\"values\":[100],\"overridable\":false},{\"schema\":{\"name\":\"changeNumberAttribute\",\"displayName\":\"Change Number Attribute\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":38,\"confidential\":false,\"defaultValues\":[\"changeNumber\"]},\"values\":[\"changeNumber\"],\"overridable\":false},{\"schema\":{\"name\":\"changeLogContext\",\"displayName\":\"Change Log Context\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":39,\"confidential\":false,\"defaultValues\":[\"cn=changelog\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogPagingSupport\",\"displayName\":\"Change Log Paging Support\",\"helpMessage\":\"Whether to use paging when querying the change log.\",\"type\":\"boolean\",\"required\":false,\"order\":40,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"filterWithOrInsteadOfAnd\",\"displayName\":\"Filter with Or Instead of And\",\"helpMessage\":\"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":41,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"removeLogEntryObjectClassFromFilter\",\"displayName\":\"Remove Log Entry Object Class from Filter\",\"helpMessage\":\"If this property is set (the default), the filter used to fetch change log entries does not contain the \\\"changeLogEntry\\\" object class, expecting that there are no entries of other object types in the change log. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":42,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"synchronizePasswords\",\"displayName\":\"Enable Password Synchronization\",\"helpMessage\":\"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":43,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordAttributeToSynchronize\",\"displayName\":\"Password Attribute to Synchronize\",\"helpMessage\":\"The name of the password attribute to synchronize when performing password synchronization.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":44,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionKey\",\"displayName\":\"Password Decryption Key\",\"helpMessage\":\"The key to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":45,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionInitializationVector\",\"displayName\":\"Password Decryption Initialization Vector\",\"helpMessage\":\"The initialization vector to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":46,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusManagementClass\",\"displayName\":\"Status management class \",\"helpMessage\":\"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":47,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement\"],\"overridable\":false},{\"schema\":{\"name\":\"retrievePasswordsWithSearch\",\"displayName\":\"Retrieve passwords with search\",\"helpMessage\":\"Whether to retrieve user passwords when searching. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":48,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"dnAttribute\",\"displayName\":\"Entry DN attribute name\",\"helpMessage\":\"Entry DN attribute name (default: entryDN)\",\"type\":\"java.lang.String\",\"required\":false,\"order\":49,\"confidential\":false,\"defaultValues\":[\"entryDN\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Groups\",\"helpMessage\":\"An optional LDAP filter to control which groups are returned from the LDAP resource. If no filter is specified, only groups that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":50,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readTimeout\",\"displayName\":\"Read Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait for a response to be received. If there is no response within the specified time period, the read attempt will be aborted. Value 0 or less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":51,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectTimeout\",\"displayName\":\"Connection Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait when opening new server connections. Value of 0 means the TCP network timeout will be used, which may be several minutes. Value less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":52,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncStrategy\",\"displayName\":\"Sync strategy class\",\"helpMessage\":\"A class implementing LdapSyncStrategy to be used for sync operations\",\"type\":\"java.lang.String\",\"required\":false,\"order\":53,\"confidential\":false,\"defaultValues\":[\"net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"DELETE\",\"CREATE\",\"UPDATE\",\"UPDATE_DELTA\",\"SEARCH\"],\"displayName\":\"TestLDAP\",\"connRequestTimeout\":10,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.ldap.LdapConnector\",\"bundleName\":\"net.tirasa.connid.bundles.ldap\",\"version\":\"1.5.9\",\"conf\":[{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"The name or IP address of the host where the LDAP server is running.\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"localhost\"],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"TCP Port\",\"helpMessage\":\"TCP/IP port number used to communicate with the LDAP server. The default is 389.\",\"type\":\"int\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[389]},\"values\":[1389],\"overridable\":false},{\"schema\":{\"name\":\"ssl\",\"displayName\":\"SSL\",\"helpMessage\":\"Select the check box to connect to the LDAP server using SSL. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"failover\",\"displayName\":\"Failover Servers\",\"helpMessage\":\"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \\\"ldap://ldap.example.com:389/\\\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"principal\",\"displayName\":\"Principal\",\"helpMessage\":\"The distinguished name with which to authenticate to the LDAP server.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=admin,ou=system\"],\"overridable\":false},{\"schema\":{\"name\":\"credentials\",\"displayName\":\"Password\",\"helpMessage\":\"Password for the principal.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":6,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"secret\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContexts\",\"displayName\":\"Base Contexts\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":true},{\"schema\":{\"name\":\"passwordAttribute\",\"displayName\":\"Password Attribute\",\"helpMessage\":\"The name of the LDAP attribute which holds the password. When changing an user''s password, the new password is set to this attribute. Default is \\\"userPassword\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"userPassword\"]},\"values\":[\"userpassword\"],\"overridable\":false},{\"schema\":{\"name\":\"accountObjectClasses\",\"displayName\":\"Account Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"top\",\"person\",\"organizationalPerson\",\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\"],\"overridable\":false},{\"schema\":{\"name\":\"accountUserNameAttributes\",\"displayName\":\"Account User Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the account''s user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[\"uid\",\"cn\"]},\"values\":[\"uid\"],\"overridable\":false},{\"schema\":{\"name\":\"userSearchScope\",\"displayName\":\"User search scope\",\"helpMessage\":\"The scope to utilise when searching for users. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Accounts\",\"helpMessage\":\"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"uid=*\"],\"overridable\":false},{\"schema\":{\"name\":\"groupObjectClasses\",\"displayName\":\"Group Object Classes\",\"helpMessage\":\"The group class or classes that will be used when creating new group objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple group classes. Some group classes may require that you specify all group classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[\"top\",\"groupOfUniqueNames\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupNameAttributes\",\"displayName\":\"Group Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the group''s name. Default is \\\"cn\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"cn\"]},\"values\":[\"cn\"],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchScope\",\"displayName\":\"Group search scope\",\"helpMessage\":\"The scope to utilise when searching for groups. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupMemberAttribute\",\"displayName\":\"Group Member Attribute\",\"helpMessage\":\"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group. Default is \\\"uniqueMember\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"uniqueMember\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"maintainLdapGroupMembership\",\"displayName\":\"Maintain LDAP Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"maintainPosixGroupMembership\",\"displayName\":\"Maintain POSIX Group Membership\",\"helpMessage\":\"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"addPrincipalToNewGroups\",\"displayName\":\"Automatically add the configured principal as first member of a new group\",\"helpMessage\":\"When enabled, the configured principal is added as first member of a new group. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectClasses\",\"displayName\":\"Any-object Object Classes\",\"helpMessage\":\"The object class or classes that will be used when creating new any-object objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some classes may require that you specify all object classes in the class hierarchy.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":20,\"confidential\":false,\"defaultValues\":[\"top\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectNameAttributes\",\"displayName\":\"Any-object Name Attributes\",\"helpMessage\":\"Attribute or attributes which holds the any-object''s name. \",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":21,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchFilter\",\"displayName\":\"LDAP filter for retrieving Any Objects\",\"helpMessage\":\"An optional LDAP filter to control which any objects are returned from the LDAP resource. If no filter is specified, only any objects that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":22,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"anyObjectSearchScope\",\"displayName\":\"Any Object search scope\",\"helpMessage\":\"The scope to utilise when searching for any objects. Must be one of object, onelevel, subtree. Default is subtree\",\"type\":\"java.lang.String\",\"required\":false,\"order\":23,\"confidential\":false,\"defaultValues\":[\"subtree\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordHashAlgorithm\",\"displayName\":\"Password Hash Algorithm\",\"helpMessage\":\"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SMD5, and MD5. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).\",\"type\":\"java.lang.String\",\"required\":false,\"order\":24,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"SHA\"],\"overridable\":false},{\"schema\":{\"name\":\"respectResourcePasswordPolicyChangeAfterReset\",\"displayName\":\"Respect Resource Password Policy Change-After-Reset\",\"helpMessage\":\"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource''s password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":25,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"useVlvControls\",\"displayName\":\"Use VLV Controls\",\"helpMessage\":\"Wheter to enforce usage of VLV controls over standard LDAP controls. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":26,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"vlvSortAttribute\",\"displayName\":\"VLV Sort Attribute\",\"helpMessage\":\"Specify the sort attribute to use for VLV indexes on the resource. Default is \\\"uid\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":27,\"confidential\":false,\"defaultValues\":[\"uid\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"uidAttribute\",\"displayName\":\"Uid Attribute\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":28,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"gidAttribute\",\"displayName\":\"Uid Attribute for groups\",\"helpMessage\":\"The name of the LDAP attribute which is mapped to the Uid attribute for groups. Default is \\\"entryUUID\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":29,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[\"cn\"],\"overridable\":true},{\"schema\":{\"name\":\"aoidAttribute\",\"displayName\":\"aoidAttribute\",\"helpMessage\":\"aoidAttribute\",\"type\":\"java.lang.String\",\"required\":false,\"order\":30,\"confidential\":false,\"defaultValues\":[\"entryUUID\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readSchema\",\"displayName\":\"Read Schema\",\"helpMessage\":\"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":31,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"baseContextsToSynchronize\",\"displayName\":\"Base Contexts to Synchronize\",\"helpMessage\":\"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":32,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"ou=people,o=isp\",\"ou=groups,o=isp\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassesToSynchronize\",\"displayName\":\"Object Classes to Synchronize\",\"helpMessage\":\"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \\\"inetOrgPerson\\\" objects should be synchronized, but the superclasses of \\\"inetOrgPerson\\\" (\\\"person\\\", \\\"organizationalperson\\\" and \\\"top\\\") should be filtered out, then list only \\\"inetOrgPerson\\\" here. All objects in LDAP are subclassed from \\\"top\\\". For this reason, you should never list \\\"top\\\", otherwise no object would be filtered. Default is \\\"inetOrgPerson\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":33,\"confidential\":false,\"defaultValues\":[\"inetOrgPerson\"]},\"values\":[\"inetOrgPerson\",\"groupOfUniqueNames\"],\"overridable\":false},{\"schema\":{\"name\":\"attributesToSynchronize\",\"displayName\":\"Attributes to Synchronize\",\"helpMessage\":\"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \\\"department\\\" is listed, then only changes that affect \\\"department\\\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":34,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"modifiersNamesToFilterOut\",\"displayName\":\"Filter Out Changes By\",\"helpMessage\":\"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \\\"modifiersName\\\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \\\"cn=Directory Manager\\\".\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":35,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"accountSynchronizationFilter\",\"displayName\":\"LDAP Filter for Accounts to Synchronize\",\"helpMessage\":\"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":36,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogBlockSize\",\"displayName\":\"Change Log Block Size\",\"helpMessage\":\"The number of change log entries to fetch per query. Default is \\\"100\\\".\",\"type\":\"int\",\"required\":false,\"order\":37,\"confidential\":false,\"defaultValues\":[100]},\"values\":[100],\"overridable\":false},{\"schema\":{\"name\":\"changeNumberAttribute\",\"displayName\":\"Change Number Attribute\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":38,\"confidential\":false,\"defaultValues\":[\"changeNumber\"]},\"values\":[\"changeNumber\"],\"overridable\":false},{\"schema\":{\"name\":\"changeLogContext\",\"displayName\":\"Change Log Context\",\"helpMessage\":\"The name of the change number attribute in the change log entry. Default is \\\"changeNumber\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":39,\"confidential\":false,\"defaultValues\":[\"cn=changelog\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"changeLogPagingSupport\",\"displayName\":\"Change Log Paging Support\",\"helpMessage\":\"Whether to use paging when querying the change log.\",\"type\":\"boolean\",\"required\":false,\"order\":40,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"filterWithOrInsteadOfAnd\",\"displayName\":\"Filter with Or Instead of And\",\"helpMessage\":\"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":41,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"removeLogEntryObjectClassFromFilter\",\"displayName\":\"Remove Log Entry Object Class from Filter\",\"helpMessage\":\"If this property is set (the default), the filter used to fetch change log entries does not contain the \\\"changeLogEntry\\\" object class, expecting that there are no entries of other object types in the change log. Default is \\\"true\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":42,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"synchronizePasswords\",\"displayName\":\"Enable Password Synchronization\",\"helpMessage\":\"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work. Default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":43,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordAttributeToSynchronize\",\"displayName\":\"Password Attribute to Synchronize\",\"helpMessage\":\"The name of the password attribute to synchronize when performing password synchronization.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":44,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionKey\",\"displayName\":\"Password Decryption Key\",\"helpMessage\":\"The key to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":45,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"passwordDecryptionInitializationVector\",\"displayName\":\"Password Decryption Initialization Vector\",\"helpMessage\":\"The initialization vector to decrypt passwords with when performing password synchronization.\",\"type\":\"org.identityconnectors.common.security.GuardedByteArray\",\"required\":false,\"order\":46,\"confidential\":true,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusManagementClass\",\"displayName\":\"Status management class \",\"helpMessage\":\"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":47,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement\"],\"overridable\":false},{\"schema\":{\"name\":\"retrievePasswordsWithSearch\",\"displayName\":\"Retrieve passwords with search\",\"helpMessage\":\"Whether to retrieve user passwords when searching. The default is \\\"false\\\".\",\"type\":\"boolean\",\"required\":false,\"order\":48,\"confidential\":false,\"defaultValues\":[false]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"dnAttribute\",\"displayName\":\"Entry DN attribute name\",\"helpMessage\":\"Entry DN attribute name (default: entryDN)\",\"type\":\"java.lang.String\",\"required\":false,\"order\":49,\"confidential\":false,\"defaultValues\":[\"entryDN\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"groupSearchFilter\",\"displayName\":\"LDAP Filter for Retrieving Groups\",\"helpMessage\":\"An optional LDAP filter to control which groups are returned from the LDAP resource. If no filter is specified, only groups that include all specified object classes are returned.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":50,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"readTimeout\",\"displayName\":\"Read Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait for a response to be received. If there is no response within the specified time period, the read attempt will be aborted. Value 0 or less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":51,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectTimeout\",\"displayName\":\"Connection Timeout (Milliseconds)\",\"helpMessage\":\"Time to wait when opening new server connections. Value of 0 means the TCP network timeout will be used, which may be several minutes. Value less than 0 means there is no limit.\",\"type\":\"long\",\"required\":false,\"order\":52,\"confidential\":false,\"defaultValues\":[0]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncStrategy\",\"displayName\":\"Sync strategy class\",\"helpMessage\":\"A class implementing LdapSyncStrategy to be used for sync operations\",\"type\":\"java.lang.String\",\"required\":false,\"order\":53,\"confidential\":false,\"defaultValues\":[\"net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"UPDATE_DELTA\",\"DELETE\",\"SEARCH\"],\"displayName\":\"TestLDAP\",\"connRequestTimeout\":10,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.796', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.795789+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"printer21ce0a7d0\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer2c3470351\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-25cc-7531-abae-d7761976f350\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"printer21ce0a7d0\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.781902+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.781974+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer2c3470351\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.823', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.822636+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"printer365a1334f\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer3b2a21930\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-25e7-7b3a-888a-554d77120a55\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"printer365a1334f\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.809133+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.809201+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer3b2a21930\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.878', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.875667+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-25ab-779c-b055-80c9cf1bd6b4\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"printer16c76119b\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.750645+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.750763+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer17ad43db7\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459c-25ab-779c-b055-80c9cf1bd6b4\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[{\"operation\":\"ADD_REPLACE\",\"relationshipTO\":{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-25cc-7531-abae-d7761976f350\",\"otherEndName\":null}}],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-25ab-779c-b055-80c9cf1bd6b4\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"printer16c76119b\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.750645+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.863447+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer17ad43db7\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-25cc-7531-abae-d7761976f350\",\"otherEndName\":\"printer21ce0a7d0\"}],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:48.913', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:48.913129+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-25cc-7531-abae-d7761976f350\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"printer21ce0a7d0\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.781902+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.781974+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer2c3470351\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-25ab-779c-b055-80c9cf1bd6b4\",\"otherEndName\":\"printer16c76119b\"}],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459c-25cc-7531-abae-d7761976f350\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[{\"operation\":\"ADD_REPLACE\",\"relationshipTO\":{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-25e7-7b3a-888a-554d77120a55\",\"otherEndName\":null}}],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-25cc-7531-abae-d7761976f350\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"printer21ce0a7d0\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.781902+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.905181+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"printer2c3470351\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-25e7-7b3a-888a-554d77120a55\",\"otherEndName\":\"printer365a1334f\"},{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-25ab-779c-b055-80c9cf1bd6b4\",\"otherEndName\":\"printer16c76119b\"}],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:49.074', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:49.074232+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"updateAttr7b51590e\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"updateAttr2670b98e\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-268e-7d01-86cf-d26c3472ba8c\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"updateAttr7b51590e\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.977131+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.977204+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"updateAttr2670b98e\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-268e-7d01-86cf-d26c3472ba8c\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]},{\"schema\":\"LOCATION\",\"values\":[\"updateAttr2670b98e\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"updateAttr7b51590e\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:49.213', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:49.212776+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-268e-7d01-86cf-d26c3472ba8c\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"updateAttr7b51590e\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.977131+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:48.977204+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"updateAttr2670b98e\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459c-268e-7d01-86cf-d26c3472ba8c\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"location\",\"values\":[\"newlocation\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-268e-7d01-86cf-d26c3472ba8c\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"updateAttr7b51590e\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:48.977131+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.111201+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"newlocation\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==0194459c-268e-7d01-86cf-d26c3472ba8c\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]},{\"schema\":\"LOCATION\",\"values\":[\"updateAttr2670b98e\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"updateAttr7b51590e\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]}]},\"afterObj\":{\"fiql\":\"__UID__==0194459c-268e-7d01-86cf-d26c3472ba8c\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]},{\"schema\":\"LOCATION\",\"values\":[\"newlocation\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"updateAttr7b51590e\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-268e-7d01-86cf-d26c3472ba8c\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.912', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.912481+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-79f4-74cd-8951-adc7683e9229\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"unlink5fd94976\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.864478+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.864515+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["\"0194459d-79f4-74cd-8951-adc7683e9229\"", "[\"resource-ldap\"]"], "logger": {"type": "LOGIC", "event": "unlink", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-79f4-74cd-8951-adc7683e9229\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"unlink5fd94976\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.864478+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.909833+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:49.289', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:49.288411+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"unlimited1cda2b259\",\"realm\":\"/even/two\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"unlimited14c4544cd\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-27b0-7929-bf19-e53dec60260c\",\"type\":\"PRINTER\",\"realm\":\"/even/two\",\"name\":\"unlimited1cda2b259\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:49.268924+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.269085+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"unlimited14c4544cd\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:49.328', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:49.328122+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"unlimited2126918f3\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"unlimited2494b12d8\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-27b0-7929-bf19-e53dec60260c\",\"otherEndName\":null}],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-27d8-77ac-ac15-9db6c698f618\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"unlimited2126918f3\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:49.307473+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.307592+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"unlimited2494b12d8\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-27b0-7929-bf19-e53dec60260c\",\"otherEndName\":\"unlimited1cda2b259\"}],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:49.387', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:49.387349+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-27b0-7929-bf19-e53dec60260c\",\"type\":\"PRINTER\",\"realm\":\"/even/two\",\"name\":\"unlimited1cda2b259\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:49.268924+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.269085+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"unlimited14c4544cd\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-27d8-77ac-ac15-9db6c698f618\",\"otherEndName\":\"unlimited2126918f3\"}],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459c-27b0-7929-bf19-e53dec60260c\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[{\"operation\":\"ADD_REPLACE\",\"relationshipTO\":{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-27d8-77ac-ac15-9db6c698f618\",\"otherEndName\":null}}],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-27b0-7929-bf19-e53dec60260c\",\"type\":\"PRINTER\",\"realm\":\"/even/two\",\"name\":\"unlimited1cda2b259\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:49.268924+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.373048+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"unlimited14c4544cd\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-27d8-77ac-ac15-9db6c698f618\",\"otherEndName\":\"unlimited2126918f3\"},{\"type\":\"neighborhood\",\"end\":\"RIGHT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"0194459c-27d8-77ac-ac15-9db6c698f618\",\"otherEndName\":\"unlimited2126918f3\"}],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:49.694', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:49.693654+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"deleteAttrec56c135\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"deleteAttr0255de7a\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-28de-7b87-b5eb-5bff076909a5\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"deleteAttrec56c135\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:49.571101+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.571256+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"deleteAttr0255de7a\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-28de-7b87-b5eb-5bff076909a5\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]},{\"schema\":\"LOCATION\",\"values\":[\"deleteAttr0255de7a\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"deleteAttrec56c135\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:49.873', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:49.872849+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-28de-7b87-b5eb-5bff076909a5\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"deleteAttrec56c135\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:49.571101+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.571256+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"deleteAttr0255de7a\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459c-28de-7b87-b5eb-5bff076909a5\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"DELETE\",\"attr\":{\"schema\":\"location\",\"values\":[]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-28de-7b87-b5eb-5bff076909a5\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"deleteAttrec56c135\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:49.571101+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:49.729612+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==0194459c-28de-7b87-b5eb-5bff076909a5\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]},{\"schema\":\"LOCATION\",\"values\":[\"deleteAttr0255de7a\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"deleteAttrec56c135\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]}]},\"afterObj\":{\"fiql\":\"__UID__==0194459c-28de-7b87-b5eb-5bff076909a5\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]},{\"schema\":\"LOCATION\",\"values\":[\"deleteAttr0255de7a\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"deleteAttrec56c135\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-28de-7b87-b5eb-5bff076909a5\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:53.284', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:53.283891+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"7ca75b3daudit@syncope.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"fullname\",\"values\":[\"7ca75b3daudit@syncope.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"firstname\",\"values\":[\"7ca75b3daudit@syncope.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"7ca75b3daudit@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"userId\",\"values\":[\"7ca75b3daudit@syncope.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-21a0-7a23-b5b8-2fc0d065054d\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"7ca75b3daudit@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:11:53.255516+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:11:53.270401+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"7ca75b3daudit@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"7ca75b3daudit@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"7ca75b3daudit@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"7ca75b3daudit@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 7ca75b3daudit@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"7ca75b3daudit@syncope.org - 2025-01-08T12:11:53+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:11:53.249602+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:52.104', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:52.103986+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"Italy0fbfb08f\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"Italyae0008bf\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-3268-79e6-aea8-bffc80e3f831\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Italy0fbfb08f\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:52.011491+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:52.01162+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"Italyae0008bf\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-3268-79e6-aea8-bffc80e3f831\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-3268-79e6-aea8-bffc80e3f831\"]},{\"schema\":\"LOCATION\",\"values\":[\"Italyae0008bf\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"Italy0fbfb08f\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-3268-79e6-aea8-bffc80e3f831\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-3268-79e6-aea8-bffc80e3f831\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:53.247', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:53.247266+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-3268-79e6-aea8-bffc80e3f831\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Italy0fbfb08f\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:52.011491+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:52.01162+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"Italyae0008bf\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["\"0194459c-3268-79e6-aea8-bffc80e3f831\"", "false"], "logger": {"type": "LOGIC", "event": "delete", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-3268-79e6-aea8-bffc80e3f831\",\"type\":null,\"realm\":null,\"name\":null,\"creator\":null,\"creationDate\":null,\"creationContext\":null,\"lastModifier\":null,\"lastChangeDate\":null,\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==0194459c-3268-79e6-aea8-bffc80e3f831\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-3268-79e6-aea8-bffc80e3f831\"]},{\"schema\":\"LOCATION\",\"values\":[\"Italyae0008bf\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"Italy0fbfb08f\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-3268-79e6-aea8-bffc80e3f831\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-3268-79e6-aea8-bffc80e3f831\"]}]},\"afterObj\":null,\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:53.492', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:53.482987+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"13c210b5audit@syncope.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"firstname\",\"values\":[\"13c210b5audit@syncope.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-37a3-7c0b-8dc4-c61eaf5a62a7\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"13c210b5audit@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:53.374701+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:53.452092+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"13c210b5audit@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 13c210b5audit@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"13c210b5audit@syncope.org - 2025-01-08T12:10:53+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:53.347624+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:55.664', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:55.664206+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"USAa770cd26\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"USA765ceb4b\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459c-4059-770f-bc3d-ae2bc229e653\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"USAa770cd26\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:55.580002+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:55.580101+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"USA765ceb4b\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459c-4059-770f-bc3d-ae2bc229e653\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459c-4059-770f-bc3d-ae2bc229e653\"]},{\"schema\":\"LOCATION\",\"values\":[\"USA765ceb4b\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"USAa770cd26\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459c-4059-770f-bc3d-ae2bc229e653\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459c-4059-770f-bc3d-ae2bc229e653\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:54.393', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:54.391774+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"ae25025daudit-2@syncope.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"ae25025daudit-2@syncope.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"firstname\",\"values\":[\"ae25025daudit-2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"fullname\",\"values\":[\"ae25025daudit-2@syncope.org\"]},{\"schema\":\"email\",\"values\":[\"ae25025daudit-2@syncope.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-25fc-7e2b-9da4-3809f9bf242e\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"ae25025daudit-2@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:11:54.369975+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:11:54.378151+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ae25025daudit-2@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"ae25025daudit-2@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"ae25025daudit-2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ae25025daudit-2@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ae25025daudit-2@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"ae25025daudit-2@syncope.org - 2025-01-08T12:11:54+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:11:54.365087+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:57.915', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:57.911356+01:00", "before": "null", "inputs": ["{\"key\":\"0194459c-4973-73ab-bab7-79449aa39304\",\"resource\":\"resource-db-scripted\",\"operation\":\"CREATE\",\"objectClass\":\"__PRINTER__\",\"anyTypeKind\":\"ANY_OBJECT\",\"anyType\":\"PRINTER\",\"entityKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"connObjectKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"oldConnObjectKey\":null,\"propagationData\":{\"attributes\":[{\"name\":\"LOCATION\",\"value\":[\"1st floor\"]},{\"name\":\"PRINTERNAME\",\"value\":[\"HP LJ 1300n\"]},{\"name\":\"__NAME__\",\"value\":[\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\"]}],\"attributeDeltas\":null},\"beforeObj\":{\"empty\":true,\"present\":false}}"], "logger": {"type": "PROPAGATION", "event": "create", "result": "SUCCESS", "category": "ANY_OBJECT", "subcategory": "resource-db-scripted"}, "output": "[{\"start\":\"2025-01-08T12:10:57.85598+01:00\",\"end\":\"2025-01-08T12:10:57.907903+01:00\",\"key\":\"0194459c-493f-79b4-b7e2-dc22fe704b74\",\"jobType\":\"TASK\",\"refKey\":\"0194459c-4973-73ab-bab7-79449aa39304\",\"refDesc\":\"PROPAGATION Task 0194459c-4973-73ab-bab7-79449aa39304 fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"status\":\"SUCCESS\",\"message\":null,\"executor\":\"admin\"},{\"objectClass\":{\"objectClassValue\":\"__PRINTER__\",\"displayNameKey\":\"MESSAGE_OBJECT_CLASS___PRINTER__\"},\"name\":{\"name\":\"__NAME__\",\"value\":[\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\"]},\"attributes\":[{\"name\":\"LOCATION\",\"value\":[\"1st floor\"]},{\"name\":\"__NAME__\",\"value\":[\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\"]},{\"name\":\"PRINTERNAME\",\"value\":[\"HP LJ 1300n\"]},{\"name\":\"ID\",\"value\":[\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\"]},{\"name\":\"__UID__\",\"value\":[\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\"]}],\"uid\":{\"name\":\"__UID__\",\"value\":[\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\"]}}]", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:58.284', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:58.276955+01:00", "before": "null", "inputs": ["{\"token\":{\"type\":\"String\",\"value\":\"\"},\"deltaType\":\"CREATE_OR_UPDATE\",\"previousUid\":null,\"objectClass\":{\"objectClassValue\":\"__ACCOUNT__\",\"displayNameKey\":\"MESSAGE_OBJECT_CLASS___ACCOUNT__\"},\"uid\":{\"name\":\"__UID__\",\"value\":[\"pullFromLDAP\"]},\"object\":{\"objectClass\":{\"objectClassValue\":\"__ACCOUNT__\",\"displayNameKey\":\"MESSAGE_OBJECT_CLASS___ACCOUNT__\"},\"name\":{\"name\":\"__NAME__\",\"value\":[\"uid=pullFromLDAP,ou=people,o=isp\"]},\"attributes\":[{\"name\":\"__PASSWORD__\",\"value\":[{\"readOnly\":false,\"disposed\":false,\"encryptedBytes\":\"LJSCzTCvfPOcGmShM7jueg==\",\"base64SHA1Hash\":\"2jmj7l5rSw0yVb/vlWAYkK/YBwk=\"}]},{\"name\":\"cn\",\"value\":[\"pullFromLDAP\"]},{\"name\":\"__UID__\",\"value\":[\"pullFromLDAP\"]},{\"name\":\"__ENABLE__\",\"value\":[true]},{\"name\":\"jpegPhoto\",\"value\":[\"<binary>/9j/4AAQSkZJRgABAQEBKwErAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAEAAQDAREAAhEBAxEB/8QAFAABAAAAAAAAAAAAAAAAAAAACP/EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAUuf/8QAFhABAQEAAAAAAAAAAAAAAAAAAwAS/9oACAEBAAEFAiLV/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPwF//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPwF//8QAGhAAAQUBAAAAAAAAAAAAAAAAAgABESEiQf/aAAgBAQAGPwI9k2orq//EABkQAAMAAwAAAAAAAAAAAAAAAAERIQBBYf/aAAgBAQABPyF20CYlpT3P/9oADAMBAAIAAwAAABCf/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPxB//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPxB//8QAGhABAAIDAQAAAAAAAAAAAAAAAREhAEFRYf/aAAgBAQABPxCUKGDcAUFrvhoz/9k=</binary>\"]},{\"name\":\"uid\",\"value\":[\"pullFromLDAP\"]},{\"name\":\"mail\",\"value\":[\"pullFromLDAP@syncope.apache.org\"]},{\"name\":\"registeredAddress\",\"value\":[\"5BAA61E4C9B93F3F0682250B6CF8331B7EE68FD8\"]},{\"name\":\"postalAddress\",\"value\":[]},{\"name\":\"__NAME__\",\"value\":[\"uid=pullFromLDAP,ou=people,o=isp\"]},{\"name\":\"title\",\"value\":[\"odd\"]},{\"name\":\"sn\",\"value\":[\"Surname\"]},{\"name\":\"givenname\",\"value\":[\"pullFromLDAP\"]}],\"uid\":{\"name\":\"__UID__\",\"value\":[\"pullFromLDAP\"]}}}", "[]"], "logger": {"type": "PULL", "event": "unmatchingrule_assign", "result": "SUCCESS", "category": "USER", "subcategory": "resource-ldap"}, "output": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-4a6a-7bc2-a270-9db95841587f\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"pullFromLDAP\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:58.193262+01:00\",\"creationContext\":\"PullTask 0194459c-49eb-7daa-9d03-acb5bf933032 ''null''\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:58.227752+01:00\",\"lastChangeContext\":\"PullTask 0194459c-49eb-7daa-9d03-acb5bf933032 ''null''\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"pullFromLDAP\"]},{\"schema\":\"obscure\",\"values\":[\"A2B65D6D7B49585C340751546759B84C079C17DD\"]},{\"schema\":\"photo\",\"values\":[\"/9j/4AAQSkZJRgABAQEBKwErAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAEAAQDAREAAhEBAxEB/8QAFAABAAAAAAAAAAAAAAAAAAAACP/EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAUuf/8QAFhABAQEAAAAAAAAAAAAAAAAAAwAS/9oACAEBAAEFAiLV/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPwF//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPwF//8QAGhAAAQUBAAAAAAAAAAAAAAAAAgABESEiQf/aAAgBAQAGPwI9k2orq//EABkQAAMAAwAAAAAAAAAAAAAAAAERIQBBYf/aAAgBAQABPyF20CYlpT3P/9oADAMBAAIAAwAAABCf/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPxB//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPxB//8QAGhABAAIDAQAAAAAAAAAAAAAAAREhAEFRYf/aAAgBAQABPxCUKGDcAUFrvhoz/9k=\"]},{\"schema\":\"surname\",\"values\":[\"Surname\"]},{\"schema\":\"title\",\"values\":[\"odd\"]},{\"schema\":\"userId\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Surname, \"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"info\",\"values\":[\"pullFromLDAP - 2025-01-08T12:10:58+01:00[0]\"]},{\"schema\":\"mderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"noschema\",\"values\":[\"Surname, \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[\"pullFromLDAP\"]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:58.15493+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:17.301', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:17.300839+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"forProvisionc11053a9\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.166271+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.22658+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["\"0194459d-7f0c-7027-8030-3780651d3519\"", "\"PROVISION\""], "logger": {"type": "LOGIC", "event": "provisionMembers", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"start\":\"2025-01-08T12:12:17.300169+01:00\",\"end\":null,\"key\":null,\"jobType\":\"TASK\",\"refKey\":\"0194459d-7f83-7ce0-811a-214bd825b268\",\"refDesc\":\"SCHEDULED Task 0194459d-7f83-7ce0-811a-214bd825b268 provision members of group forProvisionc11053a9\",\"status\":\"JOB_FIRED\",\"message\":\"Job fired; waiting for results...\",\"executor\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:18.348', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:18.34796+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"forProvisionc11053a9\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.166271+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.22658+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["\"0194459d-7f0c-7027-8030-3780651d3519\"", "\"PROVISION\""], "logger": {"type": "LOGIC", "event": "provisionMembers", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"start\":\"2025-01-08T12:12:18.347696+01:00\",\"end\":null,\"key\":null,\"jobType\":\"TASK\",\"refKey\":\"0194459d-7f83-7ce0-811a-214bd825b268\",\"refDesc\":\"SCHEDULED Task 0194459d-7f83-7ce0-811a-214bd825b268 provision members of group forProvisionc11053a9\",\"status\":\"JOB_FIRED\",\"message\":\"Job fired; waiting for results...\",\"executor\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:31.905', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:31.905003+01:00", "before": "null", "inputs": ["{\"key\":\"5ef2a9bb\",\"connector\":\"be24b061-019d-4e3e-baf0-0a6d0a45cb9c\",\"connectorDisplayName\":\"H2-testpull\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"email\",\"extAttrName\":\"EMAIL\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"SURNAME\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"memberships[additional].aLong\",\"extAttrName\":\"ID\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"SURNAME\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"username\",\"extAttrName\":\"USERNAME\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"EMAIL\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"mustChangePassword\",\"extAttrName\":\"MUSTCHANGEPASSWORD\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":null,\"enforceMandatoryCondition\":false,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"5ef2a9bb\",\"connector\":\"be24b061-019d-4e3e-baf0-0a6d0a45cb9c\",\"connectorDisplayName\":\"H2-testpull\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"email\",\"extAttrName\":\"EMAIL\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"SURNAME\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"memberships[additional].aLong\",\"extAttrName\":\"ID\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"SURNAME\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"username\",\"extAttrName\":\"USERNAME\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"EMAIL\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"mustChangePassword\",\"extAttrName\":\"MUSTCHANGEPASSWORD\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":null,\"enforceMandatoryCondition\":false,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:55.52', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:55.515428+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"AuditGroupSearch4fcac597\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-2a51-7288-b571-d6335fd7ec54\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"AuditGroupSearch4fcac597\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:11:55.479784+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:11:55.479869+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:58.421', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:58.415961+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-4a6a-7bc2-a270-9db95841587f\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"pullFromLDAP\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:58.193262+01:00\",\"creationContext\":\"PullTask 0194459c-49eb-7daa-9d03-acb5bf933032 ''null''\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:58.227752+01:00\",\"lastChangeContext\":\"PullTask 0194459c-49eb-7daa-9d03-acb5bf933032 ''null''\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"pullFromLDAP\"]},{\"schema\":\"obscure\",\"values\":[\"A2B65D6D7B49585C340751546759B84C079C17DD\"]},{\"schema\":\"photo\",\"values\":[\"/9j/4AAQSkZJRgABAQEBKwErAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAEAAQDAREAAhEBAxEB/8QAFAABAAAAAAAAAAAAAAAAAAAACP/EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAUuf/8QAFhABAQEAAAAAAAAAAAAAAAAAAwAS/9oACAEBAAEFAiLV/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPwF//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPwF//8QAGhAAAQUBAAAAAAAAAAAAAAAAAgABESEiQf/aAAgBAQAGPwI9k2orq//EABkQAAMAAwAAAAAAAAAAAAAAAAERIQBBYf/aAAgBAQABPyF20CYlpT3P/9oADAMBAAIAAwAAABCf/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPxB//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPxB//8QAGhABAAIDAQAAAAAAAAAAAAAAAREhAEFRYf/aAAgBAQABPxCUKGDcAUFrvhoz/9k=\"]},{\"schema\":\"surname\",\"values\":[\"Surname\"]},{\"schema\":\"title\",\"values\":[\"odd\"]},{\"schema\":\"userId\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Surname, \"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"info\",\"values\":[\"pullFromLDAP - 2025-01-08T12:10:58+01:00[0]\"]},{\"schema\":\"mderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"noschema\",\"values\":[\"Surname, \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[\"pullFromLDAP\"]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:58.15493+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459c-4a6a-7bc2-a270-9db95841587f\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"ctype\",\"values\":[\"abcdef\"]}}],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-4a6a-7bc2-a270-9db95841587f\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"pullFromLDAP\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:58.193262+01:00\",\"creationContext\":\"PullTask 0194459c-49eb-7daa-9d03-acb5bf933032 ''null''\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:58.392395+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"abcdef\"]},{\"schema\":\"email\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"pullFromLDAP\"]},{\"schema\":\"obscure\",\"values\":[\"A2B65D6D7B49585C340751546759B84C079C17DD\"]},{\"schema\":\"photo\",\"values\":[\"/9j/4AAQSkZJRgABAQEBKwErAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAEAAQDAREAAhEBAxEB/8QAFAABAAAAAAAAAAAAAAAAAAAACP/EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAUuf/8QAFhABAQEAAAAAAAAAAAAAAAAAAwAS/9oACAEBAAEFAiLV/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPwF//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPwF//8QAGhAAAQUBAAAAAAAAAAAAAAAAAgABESEiQf/aAAgBAQAGPwI9k2orq//EABkQAAMAAwAAAAAAAAAAAAAAAAERIQBBYf/aAAgBAQABPyF20CYlpT3P/9oADAMBAAIAAwAAABCf/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPxB//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPxB//8QAGhABAAIDAQAAAAAAAAAAAAAAAREhAEFRYf/aAAgBAQABPxCUKGDcAUFrvhoz/9k=\"]},{\"schema\":\"surname\",\"values\":[\"Surname\"]},{\"schema\":\"title\",\"values\":[\"odd\"]},{\"schema\":\"userId\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Surname, \"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"info\",\"values\":[\"pullFromLDAP - 2025-01-08T12:10:58+01:00[0]\"]},{\"schema\":\"mderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"noschema\",\"values\":[\"Surname, \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[\"pullFromLDAP\"]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:58.15493+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:10:58.523', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:10:58.518991+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-4a6a-7bc2-a270-9db95841587f\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"pullFromLDAP\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:58.193262+01:00\",\"creationContext\":\"PullTask 0194459c-49eb-7daa-9d03-acb5bf933032 ''null''\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:58.392395+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"abcdef\"]},{\"schema\":\"email\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"pullFromLDAP\"]},{\"schema\":\"obscure\",\"values\":[\"A2B65D6D7B49585C340751546759B84C079C17DD\"]},{\"schema\":\"photo\",\"values\":[\"/9j/4AAQSkZJRgABAQEBKwErAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAEAAQDAREAAhEBAxEB/8QAFAABAAAAAAAAAAAAAAAAAAAACP/EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAUuf/8QAFhABAQEAAAAAAAAAAAAAAAAAAwAS/9oACAEBAAEFAiLV/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPwF//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPwF//8QAGhAAAQUBAAAAAAAAAAAAAAAAAgABESEiQf/aAAgBAQAGPwI9k2orq//EABkQAAMAAwAAAAAAAAAAAAAAAAERIQBBYf/aAAgBAQABPyF20CYlpT3P/9oADAMBAAIAAwAAABCf/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPxB//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPxB//8QAGhABAAIDAQAAAAAAAAAAAAAAAREhAEFRYf/aAAgBAQABPxCUKGDcAUFrvhoz/9k=\"]},{\"schema\":\"surname\",\"values\":[\"Surname\"]},{\"schema\":\"title\",\"values\":[\"odd\"]},{\"schema\":\"userId\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Surname, \"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"info\",\"values\":[\"pullFromLDAP - 2025-01-08T12:10:58+01:00[0]\"]},{\"schema\":\"mderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"noschema\",\"values\":[\"Surname, \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[\"pullFromLDAP\"]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:58.15493+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["\"0194459c-4a6a-7bc2-a270-9db95841587f\"", "[\"resource-ldap\"]"], "logger": {"type": "LOGIC", "event": "unlink", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-4a6a-7bc2-a270-9db95841587f\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"pullFromLDAP\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:58.193262+01:00\",\"creationContext\":\"PullTask 0194459c-49eb-7daa-9d03-acb5bf933032 ''null''\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:58.499116+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"abcdef\"]},{\"schema\":\"email\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"pullFromLDAP\"]},{\"schema\":\"obscure\",\"values\":[\"A2B65D6D7B49585C340751546759B84C079C17DD\"]},{\"schema\":\"photo\",\"values\":[\"/9j/4AAQSkZJRgABAQEBKwErAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAEAAQDAREAAhEBAxEB/8QAFAABAAAAAAAAAAAAAAAAAAAACP/EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAUuf/8QAFhABAQEAAAAAAAAAAAAAAAAAAwAS/9oACAEBAAEFAiLV/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPwF//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPwF//8QAGhAAAQUBAAAAAAAAAAAAAAAAAgABESEiQf/aAAgBAQAGPwI9k2orq//EABkQAAMAAwAAAAAAAAAAAAAAAAERIQBBYf/aAAgBAQABPyF20CYlpT3P/9oADAMBAAIAAwAAABCf/8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAwEBPxB//8QAFBEBAAAAAAAAAAAAAAAAAAAAAP/aAAgBAgEBPxB//8QAGhABAAIDAQAAAAAAAAAAAAAAAREhAEFRYf/aAAgBAQABPxCUKGDcAUFrvhoz/9k=\"]},{\"schema\":\"surname\",\"values\":[\"Surname\"]},{\"schema\":\"title\",\"values\":[\"odd\"]},{\"schema\":\"userId\",\"values\":[\"pullFromLDAP@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Surname, \"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"info\",\"values\":[\"pullFromLDAP - 2025-01-08T12:10:58+01:00[0]\"]},{\"schema\":\"mderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"noschema\",\"values\":[\"Surname, \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:58.15493+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:49.906', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:49.906305+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"syncope-179114c5f420\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"syncope-1791d43f7e5b\"]}],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"syncope-179114c5f420\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:11:49.822247+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:11:49.822596+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"syncope-1791d43f7e5b\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==0194459d-143b-7e30-b11e-b1eaa3ddbfe4\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]},{\"schema\":\"LOCATION\",\"values\":[\"syncope-1791d43f7e5b\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"syncope-179114c5f420\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:49.924', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:49.924488+01:00", "before": "\"before\"", "inputs": [], "logger": {"type": "CUSTOM", "event": "MY_EVENT", "result": "SUCCESS", "category": null, "subcategory": null}, "output": "\"2025-01-08T12:11:49.924324+01:00\"", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:50.008', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:50.007681+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"syncope-179114c5f420\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:11:49.822247+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:11:49.822596+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"syncope-1791d43f7e5b\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"location\",\"values\":[\"newfaf0b5b9\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"syncope-179114c5f420\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:11:49.822247+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:11:49.933515+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"newfaf0b5b9\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-db-scripted\"],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==0194459d-143b-7e30-b11e-b1eaa3ddbfe4\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]},{\"schema\":\"LOCATION\",\"values\":[\"syncope-1791d43f7e5b\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"syncope-179114c5f420\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]}]},\"afterObj\":{\"fiql\":\"__UID__==0194459d-143b-7e30-b11e-b1eaa3ddbfe4\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]},{\"schema\":\"LOCATION\",\"values\":[\"newfaf0b5b9\"]},{\"schema\":\"PRINTERNAME\",\"values\":[\"syncope-179114c5f420\"]},{\"schema\":\"__NAME__\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]},{\"schema\":\"__UID__\",\"values\":[\"0194459d-143b-7e30-b11e-b1eaa3ddbfe4\"]}]},\"resource\":\"resource-db-scripted\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:51.12', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:51.118939+01:00", "before": "{\"key\":\"resource-csv\",\"connector\":\"6c2acf1b-b052-46f0-8c56-7a8ad6905edf\",\"connectorDisplayName\":\"CSVDir\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"csv\",\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"id\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"id\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"firstname\",\"extAttrName\":\"name\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"surname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"csvuserid\",\"extAttrName\":\"__NAME__\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"groups[root].rderToBePropagated\",\"extAttrName\":\"theirgroup\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":null,\"enforceMandatoryCondition\":false,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":\"880f8553-069b-4aed-9930-2cd53873f544\",\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}", "inputs": ["{\"key\":\"resource-csv\",\"connector\":\"6c2acf1b-b052-46f0-8c56-7a8ad6905edf\",\"connectorDisplayName\":\"CSVDir\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"csv\",\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"id\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"id\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"firstname\",\"extAttrName\":\"name\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"surname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"csvuserid\",\"extAttrName\":\"__NAME__\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"groups[root].rderToBePropagated\",\"extAttrName\":\"theirgroup\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":100,\"enforceMandatoryCondition\":false,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":\"880f8553-069b-4aed-9930-2cd53873f544\",\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"resource-csv\",\"connector\":\"6c2acf1b-b052-46f0-8c56-7a8ad6905edf\",\"connectorDisplayName\":\"CSVDir\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"csv\",\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"id\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"id\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"firstname\",\"extAttrName\":\"name\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"surname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"csvuserid\",\"extAttrName\":\"__NAME__\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"groups[root].rderToBePropagated\",\"extAttrName\":\"theirgroup\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":100,\"enforceMandatoryCondition\":false,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":\"880f8553-069b-4aed-9930-2cd53873f544\",\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:51.169', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:51.166907+01:00", "before": "{\"key\":\"6c2acf1b-b052-46f0-8c56-7a8ad6905edf\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.csvdir.CSVDirConnector\",\"bundleName\":\"net.tirasa.connid.bundles.csvdir\",\"version\":\"0.8.9\",\"conf\":[{\"schema\":{\"name\":\"sourcePath\",\"displayName\":\"Source path\",\"helpMessage\":\"Absolute path of a directory where the CSV files to be processed are located\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-csvdir\"],\"overridable\":false},{\"schema\":{\"name\":\"fileMask\",\"displayName\":\"File mask\",\"helpMessage\":\"Regular expression describing files to be processed\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"test.csv\"],\"overridable\":false},{\"schema\":{\"name\":\"encoding\",\"displayName\":\"File encoding\",\"helpMessage\":\"Basic encoding of the file\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"UTF-8\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"fieldDelimiter\",\"displayName\":\"Field delimiter\",\"helpMessage\":\"Delimiter used to separate fields in CSV files. Default is \\\",\\\".\",\"type\":\"char\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\",\"]},\"values\":[\",\"],\"overridable\":false},{\"schema\":{\"name\":\"textQualifier\",\"displayName\":\"Text qualifier\",\"helpMessage\":\"Delimiter to determine beginning and end of text in value. Default is \\\".\",\"type\":\"char\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\\\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"keyColumnNames\",\"displayName\":\"Key column name\",\"helpMessage\":\"Name of the column used to identify user uniquely\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":6,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"name\",\"surname\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordColumnName\",\"displayName\":\"Password column name\",\"helpMessage\":\"Name of the column used to specify user password\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"password\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteColumnName\",\"displayName\":\"Delete column name\",\"helpMessage\":\"Name of the column used to specify users to be deleted\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"deleted\"],\"overridable\":false},{\"schema\":{\"name\":\"quotationRequired\",\"displayName\":\"Value quotation required\",\"helpMessage\":\"Specify if value quotation is required. Default is true.\",\"type\":\"java.lang.Boolean\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[true]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"fields\",\"displayName\":\"Column names\",\"helpMessage\":\"Column names\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"id\",\"name\",\"surname\",\"email\",\"password\",\"theirgroup\",\"membership\",\"status\",\"deleted\"],\"overridable\":false},{\"schema\":{\"name\":\"ignoreHeader\",\"displayName\":\"Ignore header\",\"helpMessage\":\"Specify if first line of the file must be ignored. Default is true.\",\"type\":\"java.lang.Boolean\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[true]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"keyseparator\",\"displayName\":\"Key separator\",\"helpMessage\":\"Character used to separate keys in a multi-key scenario. Default is \\\",\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[\",\"]},\"values\":[\",\"],\"overridable\":false},{\"schema\":{\"name\":\"multivalueSeparator\",\"displayName\":\"Multi value separator\",\"helpMessage\":\"Character used to separate values in a multi-value scenario. Multivalue unsupported if not provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"defaultStatusValue\",\"displayName\":\"Default Status Value\",\"helpMessage\":\"Enter the value for status in case of status not specified. Default is \\\"true\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"true\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"disabledStatusValue\",\"displayName\":\"Disabled Status Value\",\"helpMessage\":\"Specify a value for disabled status. Default is \\\"false\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"false\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"enabledStatusValue\",\"displayName\":\"Enable Status Value\",\"helpMessage\":\"Specify a value for enabled status. Default is \\\"true\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"true\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusColumn\",\"displayName\":\"Status Column name\",\"helpMessage\":\"Status column name.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"status\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassColumn\",\"displayName\":\"ObjectClass Column Name\",\"helpMessage\":\"Column name identifying identity record type\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"objectClass\",\"displayName\":\"Supported Object Classes\",\"helpMessage\":\"Supported object classes (__ACCOUNT__ as default if empty)\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[\"__ACCOUNT__\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"DELETE\",\"SEARCH\",\"SYNC\"],\"displayName\":\"CSVDir\",\"connRequestTimeout\":10,\"poolConf\":null}", "inputs": ["{\"key\":\"6c2acf1b-b052-46f0-8c56-7a8ad6905edf\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.csvdir.CSVDirConnector\",\"bundleName\":\"net.tirasa.connid.bundles.csvdir\",\"version\":\"0.8.9\",\"conf\":[{\"schema\":{\"name\":\"sourcePath\",\"displayName\":\"Source path\",\"helpMessage\":\"Absolute path of a directory where the CSV files to be processed are located\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-csvdir\"],\"overridable\":false},{\"schema\":{\"name\":\"fileMask\",\"displayName\":\"File mask\",\"helpMessage\":\"Regular expression describing files to be processed\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"test.csv\"],\"overridable\":false},{\"schema\":{\"name\":\"encoding\",\"displayName\":\"File encoding\",\"helpMessage\":\"Basic encoding of the file\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"UTF-8\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"fieldDelimiter\",\"displayName\":\"Field delimiter\",\"helpMessage\":\"Delimiter used to separate fields in CSV files. Default is \\\",\\\".\",\"type\":\"char\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\",\"]},\"values\":[\",\"],\"overridable\":false},{\"schema\":{\"name\":\"textQualifier\",\"displayName\":\"Text qualifier\",\"helpMessage\":\"Delimiter to determine beginning and end of text in value. Default is \\\".\",\"type\":\"char\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\\\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"keyColumnNames\",\"displayName\":\"Key column name\",\"helpMessage\":\"Name of the column used to identify user uniquely\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":6,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"name\",\"surname\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordColumnName\",\"displayName\":\"Password column name\",\"helpMessage\":\"Name of the column used to specify user password\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"password\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteColumnName\",\"displayName\":\"Delete column name\",\"helpMessage\":\"Name of the column used to specify users to be deleted\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"deleted\"],\"overridable\":false},{\"schema\":{\"name\":\"quotationRequired\",\"displayName\":\"Value quotation required\",\"helpMessage\":\"Specify if value quotation is required. Default is true.\",\"type\":\"java.lang.Boolean\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[true]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"fields\",\"displayName\":\"Column names\",\"helpMessage\":\"Column names\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"id\",\"name\",\"surname\",\"email\",\"password\",\"theirgroup\",\"membership\",\"status\",\"deleted\"],\"overridable\":false},{\"schema\":{\"name\":\"ignoreHeader\",\"displayName\":\"Ignore header\",\"helpMessage\":\"Specify if first line of the file must be ignored. Default is true.\",\"type\":\"java.lang.Boolean\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[true]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"keyseparator\",\"displayName\":\"Key separator\",\"helpMessage\":\"Character used to separate keys in a multi-key scenario. Default is \\\",\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[\",\"]},\"values\":[\",\"],\"overridable\":false},{\"schema\":{\"name\":\"multivalueSeparator\",\"displayName\":\"Multi value separator\",\"helpMessage\":\"Character used to separate values in a multi-value scenario. Multivalue unsupported if not provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"defaultStatusValue\",\"displayName\":\"Default Status Value\",\"helpMessage\":\"Enter the value for status in case of status not specified. Default is \\\"true\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"true\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"disabledStatusValue\",\"displayName\":\"Disabled Status Value\",\"helpMessage\":\"Specify a value for disabled status. Default is \\\"false\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"false\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"enabledStatusValue\",\"displayName\":\"Enable Status Value\",\"helpMessage\":\"Specify a value for enabled status. Default is \\\"true\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"true\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusColumn\",\"displayName\":\"Status Column name\",\"helpMessage\":\"Status column name.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"status\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassColumn\",\"displayName\":\"ObjectClass Column Name\",\"helpMessage\":\"Column name identifying identity record type\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"objectClass\",\"displayName\":\"Supported Object Classes\",\"helpMessage\":\"Supported object classes (__ACCOUNT__ as default if empty)\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[\"__ACCOUNT__\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"DELETE\",\"CREATE\",\"SYNC\",\"UPDATE\",\"SEARCH\"],\"displayName\":\"CSVDir\",\"connRequestTimeout\":10,\"poolConf\":{\"maxObjects\":null,\"minIdle\":null,\"maxIdle\":null,\"maxWait\":null,\"minEvictableIdleTimeMillis\":null}}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"6c2acf1b-b052-46f0-8c56-7a8ad6905edf\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.csvdir.CSVDirConnector\",\"bundleName\":\"net.tirasa.connid.bundles.csvdir\",\"version\":\"0.8.9\",\"conf\":[{\"schema\":{\"name\":\"sourcePath\",\"displayName\":\"Source path\",\"helpMessage\":\"Absolute path of a directory where the CSV files to be processed are located\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-csvdir\"],\"overridable\":false},{\"schema\":{\"name\":\"fileMask\",\"displayName\":\"File mask\",\"helpMessage\":\"Regular expression describing files to be processed\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"test.csv\"],\"overridable\":false},{\"schema\":{\"name\":\"encoding\",\"displayName\":\"File encoding\",\"helpMessage\":\"Basic encoding of the file\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"UTF-8\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"fieldDelimiter\",\"displayName\":\"Field delimiter\",\"helpMessage\":\"Delimiter used to separate fields in CSV files. Default is \\\",\\\".\",\"type\":\"char\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\",\"]},\"values\":[\",\"],\"overridable\":false},{\"schema\":{\"name\":\"textQualifier\",\"displayName\":\"Text qualifier\",\"helpMessage\":\"Delimiter to determine beginning and end of text in value. Default is \\\".\",\"type\":\"char\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\\\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"keyColumnNames\",\"displayName\":\"Key column name\",\"helpMessage\":\"Name of the column used to identify user uniquely\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":6,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"name\",\"surname\"],\"overridable\":false},{\"schema\":{\"name\":\"passwordColumnName\",\"displayName\":\"Password column name\",\"helpMessage\":\"Name of the column used to specify user password\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"password\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteColumnName\",\"displayName\":\"Delete column name\",\"helpMessage\":\"Name of the column used to specify users to be deleted\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"deleted\"],\"overridable\":false},{\"schema\":{\"name\":\"quotationRequired\",\"displayName\":\"Value quotation required\",\"helpMessage\":\"Specify if value quotation is required. Default is true.\",\"type\":\"java.lang.Boolean\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[true]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"fields\",\"displayName\":\"Column names\",\"helpMessage\":\"Column names\",\"type\":\"[Ljava.lang.String;\",\"required\":true,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"id\",\"name\",\"surname\",\"email\",\"password\",\"theirgroup\",\"membership\",\"status\",\"deleted\"],\"overridable\":false},{\"schema\":{\"name\":\"ignoreHeader\",\"displayName\":\"Ignore header\",\"helpMessage\":\"Specify if first line of the file must be ignored. Default is true.\",\"type\":\"java.lang.Boolean\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[true]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"keyseparator\",\"displayName\":\"Key separator\",\"helpMessage\":\"Character used to separate keys in a multi-key scenario. Default is \\\",\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[\",\"]},\"values\":[\",\"],\"overridable\":false},{\"schema\":{\"name\":\"multivalueSeparator\",\"displayName\":\"Multi value separator\",\"helpMessage\":\"Character used to separate values in a multi-value scenario. Multivalue unsupported if not provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"defaultStatusValue\",\"displayName\":\"Default Status Value\",\"helpMessage\":\"Enter the value for status in case of status not specified. Default is \\\"true\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[\"true\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"disabledStatusValue\",\"displayName\":\"Disabled Status Value\",\"helpMessage\":\"Specify a value for disabled status. Default is \\\"false\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[\"false\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"enabledStatusValue\",\"displayName\":\"Enable Status Value\",\"helpMessage\":\"Specify a value for enabled status. Default is \\\"true\\\".\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[\"true\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"statusColumn\",\"displayName\":\"Status Column name\",\"helpMessage\":\"Status column name.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"status\"],\"overridable\":false},{\"schema\":{\"name\":\"objectClassColumn\",\"displayName\":\"ObjectClass Column Name\",\"helpMessage\":\"Column name identifying identity record type\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"objectClass\",\"displayName\":\"Supported Object Classes\",\"helpMessage\":\"Supported object classes (__ACCOUNT__ as default if empty)\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":19,\"confidential\":false,\"defaultValues\":[\"__ACCOUNT__\"]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"DELETE\",\"SEARCH\",\"SYNC\"],\"displayName\":\"CSVDir\",\"connRequestTimeout\":10,\"poolConf\":{\"maxObjects\":10,\"minIdle\":1,\"maxIdle\":10,\"maxWait\":150000,\"minEvictableIdleTimeMillis\":120000}}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:11:58.744', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:11:58.744439+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"AuditGroup828a60e0\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-3704-7182-b4fc-81712e9dc6e6\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"AuditGroup828a60e0\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:11:58.729414+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:11:58.729778+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:01.203', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:01.201635+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"realm\":\"/even/two\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb\"],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:01.033673+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:01.060636+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org - 2025-01-08T12:12:01+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:01.026197+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==cf2ff9f2syncope164@syncope.apache.org\",\"attrs\":[{\"schema\":\"ID\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"cbfdac6008f9cab4083784cbd1874f76618d2a97\"]},{\"schema\":\"__UID__\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}]},\"resource\":\"resource-testdb\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:01.262', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:01.260799+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:01.033673+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:01.060636+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org - 2025-01-08T12:12:01+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:01.026197+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["\"0194459d-4001-7a8c-a1ea-07011a11de0c\"", "[\"resource-testdb\"]"], "logger": {"type": "LOGIC", "event": "unlink", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:01.033673+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:01.249569+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org - 2025-01-08T12:12:01+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:01.026197+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:01.359', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:01.355094+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:01.033673+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:01.249569+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org - 2025-01-08T12:12:01+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:01.026197+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":{\"operation\":\"ADD_REPLACE\",\"value\":\"<MASKED>\",\"onSyncope\":true,\"resources\":[]},\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:01.033673+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:01.34267+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org - 2025-01-08T12:12:01+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:01.317952+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:02.694', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:02.694015+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"5e4e43aeowner@syncope.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"firstname\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"email\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"5e4e43aeowner@syncope.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4670-7ea4-9aa1-c2fb97733ae9\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"5e4e43aeowner@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:02.677838+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.686284+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5e4e43aeowner@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5e4e43aeowner@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"5e4e43aeowner@syncope.org - 2025-01-08T12:12:02+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:02.673002+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:02.757', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:02.757392+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"forgroupownershipff9b602d\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":\"0194459d-4670-7ea4-9aa1-c2fb97733ae9\",\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"forgroupownershipff9b602d\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:02.710814+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.710871+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":\"0194459d-4670-7ea4-9aa1-c2fb97733ae9\",\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==forgroupownershipff9b602d\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=forgroupownershipff9b602d,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"forgroupownershipff9b602d\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"forgroupownershipff9b602d\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:02.867', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:02.865308+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"58748f2fforgroupownership@syncope.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"firstname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"fullname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":null,\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":null,\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-46d6-77dc-8a0f-13eae36ca009\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"58748f2fforgroupownership@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:02.797396+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.810517+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"58748f2fforgroupownership@syncope.org - 2025-01-08T12:12:02+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:02.77467+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":\"root\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==58748f2fforgroupownership@syncope.org\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=58748f2fforgroupownership@syncope.org,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"cn\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"surname\"]},{\"schema\":\"title\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:03.06', 'DEBUG', 'syncope.audit.Master', '{"who": "5e4e43aeowner@syncope.org", "date": "2025-01-08T12:12:03.058218+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-46d6-77dc-8a0f-13eae36ca009\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"58748f2fforgroupownership@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:02.797396+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.810517+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"58748f2fforgroupownership@syncope.org - 2025-01-08T12:12:02+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:02.77467+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":\"root\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-46d6-77dc-8a0f-13eae36ca009\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":{\"operation\":\"ADD_REPLACE\",\"value\":\"new21054505\"},\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-46d6-77dc-8a0f-13eae36ca009\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"new21054505\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:02.797396+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"5e4e43aeowner@syncope.org\",\"lastChangeDate\":\"2025-01-08T12:12:03.015879+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"new21054505 - 2025-01-08T12:12:02+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:02.77467+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":\"root\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==new21054505\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=58748f2fforgroupownership@syncope.org,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"cn\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"surname\"]},{\"schema\":\"title\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==new21054505\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=new21054505,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"new21054505\"]},{\"schema\":\"cn\",\"values\":[\"new21054505\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"58748f2fforgroupownership@syncope.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"surname\"]},{\"schema\":\"title\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:03.146', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:03.145361+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"56f27bbanonmember@syncope.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4828-71c7-9aa4-6621fe4f1b05\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"56f27bbanonmember@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.119534+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.130978+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"56f27bbanonmember@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 56f27bbanonmember@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"56f27bbanonmember@syncope.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.112586+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:03.287', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:03.285429+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"4a9dedadforgroupownership2@syncope.org\",\"realm\":\"/even\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"fullname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"userId\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"email\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":null,\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4874-73e5-8784-e7c0b1225f36\",\"type\":\"USER\",\"realm\":\"/even\",\"username\":\"4a9dedadforgroupownership2@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.196729+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.204356+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"4a9dedadforgroupownership2@syncope.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.188894+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==4a9dedadforgroupownership2@syncope.org\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=4a9dedadforgroupownership2@syncope.org,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"cn\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"surname\"]},{\"schema\":\"title\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:05.425', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:05.424179+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"ad87e002batch@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"userId\",\"values\":[\"ad87e002batch@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-5114-7879-8ed4-77caa60c066a\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"ad87e002batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.404947+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.413275+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ad87e002batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ad87e002batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"ad87e002batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.396638+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:09.535', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:09.535552+01:00", "before": "null", "inputs": ["{\"key\":null,\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":null,\"helpMessage\":null,\"type\":\"java.lang.String\",\"required\":true,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:9080/does_not_work\"],\"overridable\":true},{\"schema\":{\"name\":\"servicename\",\"displayName\":null,\"helpMessage\":null,\"type\":\"java.lang.String\",\"required\":true,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning\"],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"WSSoap\",\"connRequestTimeout\":null,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"0194459d-613a-71bb-b409-d388890c2af2\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:9080/does_not_work\"],\"overridable\":true},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"WSSoap\",\"connRequestTimeout\":10,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:03.431', 'DEBUG', 'syncope.audit.Master', '{"who": "5e4e43aeowner@syncope.org", "date": "2025-01-08T12:12:03.430274+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4874-73e5-8784-e7c0b1225f36\",\"type\":\"USER\",\"realm\":\"/even\",\"username\":\"4a9dedadforgroupownership2@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.196729+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.204356+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"4a9dedadforgroupownership2@syncope.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.188894+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-4874-73e5-8784-e7c0b1225f36\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":{\"operation\":\"ADD_REPLACE\",\"value\":\"new4a2318c2\"},\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4874-73e5-8784-e7c0b1225f36\",\"type\":\"USER\",\"realm\":\"/even\",\"username\":\"new4a2318c2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.196729+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"5e4e43aeowner@syncope.org\",\"lastChangeDate\":\"2025-01-08T12:12:03.370506+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"new4a2318c2 - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.188894+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==new4a2318c2\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=4a9dedadforgroupownership2@syncope.org,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"cn\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"surname\"]},{\"schema\":\"title\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==new4a2318c2\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=new4a2318c2,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"new4a2318c2\"]},{\"schema\":\"cn\",\"values\":[\"new4a2318c2\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"surname\"]},{\"schema\":\"title\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:03.549', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:03.548909+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"591f5e5dauth@test.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"email\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"fullname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-49c8-734a-bc7e-250cff4998ac\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"591f5e5dauth@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.532873+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.539541+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"591f5e5dauth@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 591f5e5dauth@test.org\"]},{\"schema\":\"info\",\"values\":[\"591f5e5dauth@test.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.528524+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:03.671', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:03.67111+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"1f1541e7checkFailedLogin@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"firstname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"userId\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"fullname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"User manager\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4a39-78f1-8eb6-ade14ff93f7e\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"1f1541e7checkFailedLogin@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.649444+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.659727+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.642114+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:03.845', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:03.844792+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"ec186541testuserread@test.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"firstname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"User manager\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4af4-793f-b2ce-dca2e8b84a47\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"ec186541testuserread@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.832634+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.837571+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ec186541testuserread@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ec186541testuserread@test.org\"]},{\"schema\":\"info\",\"values\":[\"ec186541testuserread@test.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.828597+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:04.043', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:04.042641+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"0fe92efacheckSuspension@syncope.apache.org\",\"realm\":\"/odd\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"firstname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"User manager\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4bb5-7e85-a7b3-cae5c302a4ff\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"0fe92efacheckSuspension@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:04.026898+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.034035+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:04.021539+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:04.222', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:04.220707+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4bb5-7e85-a7b3-cae5c302a4ff\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"0fe92efacheckSuspension@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:04.026898+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.156556+01:00\",\"lastChangeContext\":\"Failed authentication\",\"dynRealms\":[],\"status\":\"suspended\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org - 2025-01-08T12:12:04+01:00[3]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:04.021539+01:00\",\"failedLogins\":3,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":true,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"operation\":\"ADD_REPLACE\",\"value\":null,\"onSyncope\":true,\"resources\":[],\"key\":\"0194459d-4bb5-7e85-a7b3-cae5c302a4ff\",\"type\":\"REACTIVATE\",\"token\":null}", "false"], "logger": {"type": "LOGIC", "event": "status", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4bb5-7e85-a7b3-cae5c302a4ff\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"0fe92efacheckSuspension@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:04.026898+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.212912+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:04.021539+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:04.533', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:04.531892+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"c9b2dec2-00a7-4855-97c0-d854842b4b24\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"bellini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.417572+01:00\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"cool\",\"values\":[\"true\"]},{\"schema\":\"firstname\",\"values\":[\"Vincenzo\"]},{\"schema\":\"fullname\",\"values\":[\"Vincenzo Bellini\"]},{\"schema\":\"gender\",\"values\":[\"M\"]},{\"schema\":\"loginDate\",\"values\":[\"2009-06-23\"]},{\"schema\":\"surname\",\"values\":[\"Bellini\"]},{\"schema\":\"userId\",\"values\":[\"bellini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Bellini, Vincenzo\"]},{\"schema\":\"info\",\"values\":[\"bellini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Bellini, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-nopropagation\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:04.409505+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[{\"groupKey\":\"bf825fe1-7320-4a54-bd64-143b5c18ab97\",\"groupName\":\"managingDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"User manager\",\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"c9b2dec2-00a7-4855-97c0-d854842b4b24\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"role79537fa7\"}],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"c9b2dec2-00a7-4855-97c0-d854842b4b24\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"bellini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.523456+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"cool\",\"values\":[\"true\"]},{\"schema\":\"firstname\",\"values\":[\"Vincenzo\"]},{\"schema\":\"fullname\",\"values\":[\"Vincenzo Bellini\"]},{\"schema\":\"gender\",\"values\":[\"M\"]},{\"schema\":\"loginDate\",\"values\":[\"2009-06-23\"]},{\"schema\":\"surname\",\"values\":[\"Bellini\"]},{\"schema\":\"userId\",\"values\":[\"bellini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Bellini, Vincenzo\"]},{\"schema\":\"info\",\"values\":[\"bellini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Bellini, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-nopropagation\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:04.409505+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[{\"groupKey\":\"bf825fe1-7320-4a54-bd64-143b5c18ab97\",\"groupName\":\"managingDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"User manager\",\"User reviewer\",\"role79537fa7\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:04.601', 'DEBUG', 'syncope.audit.Master', '{"who": "bellini", "date": "2025-01-08T12:12:04.601505+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"home\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"pathfee592ed\",\"values\":[\"/home\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"FOLDER 458006bf\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-4de8-7a0f-aa6a-57b22aa73983\",\"type\":\"FOLDER 458006bf\",\"realm\":\"/\",\"name\":\"home\",\"creator\":\"bellini\",\"creationDate\":\"2025-01-08T12:12:04.586092+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"bellini\",\"lastChangeDate\":\"2025-01-08T12:12:04.586156+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"pathfee592ed\",\"values\":[\"/home\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:04.641', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:04.641095+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"0e646506admin@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"0e646506admin@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"userId\",\"values\":[\"0e646506admin@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"email\",\"values\":[\"0e646506admin@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0e646506admin@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"Delegated user admin\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4e0b-7470-8532-ff53a7c486b1\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"0e646506admin@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:04.625146+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.632587+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"0e646506admin@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"0e646506admin@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0e646506admin@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"0e646506admin@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 0e646506admin@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"0e646506admin@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:04.620043+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"Delegated user admin\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:04.714', 'DEBUG', 'syncope.audit.Master', '{"who": "0e646506admin@syncope.apache.org", "date": "2025-01-08T12:12:04.714009+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"16a5f34cdelegated@syncope.apache.org\",\"realm\":\"/even/two\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"firstname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"fullname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"email\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4e53-76e9-87e7-6b9920c19da4\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"16a5f34cdelegated@syncope.apache.org\",\"creator\":\"0e646506admin@syncope.apache.org\",\"creationDate\":\"2025-01-08T12:12:04.695661+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"0e646506admin@syncope.apache.org\",\"lastChangeDate\":\"2025-01-08T12:12:04.703214+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"16a5f34cdelegated@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:04.691734+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:04.844', 'DEBUG', 'syncope.audit.Master', '{"who": "0e646506admin@syncope.apache.org", "date": "2025-01-08T12:12:04.843837+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4e53-76e9-87e7-6b9920c19da4\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"16a5f34cdelegated@syncope.apache.org\",\"creator\":\"0e646506admin@syncope.apache.org\",\"creationDate\":\"2025-01-08T12:12:04.695661+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"0e646506admin@syncope.apache.org\",\"lastChangeDate\":\"2025-01-08T12:12:04.703214+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"16a5f34cdelegated@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:04.691734+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-4e53-76e9-87e7-6b9920c19da4\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"surname\",\"values\":[\"surname2\"]}}],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4e53-76e9-87e7-6b9920c19da4\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"16a5f34cdelegated@syncope.apache.org\",\"creator\":\"0e646506admin@syncope.apache.org\",\"creationDate\":\"2025-01-08T12:12:04.695661+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"0e646506admin@syncope.apache.org\",\"lastChangeDate\":\"2025-01-08T12:12:04.826854+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname2\"]},{\"schema\":\"userId\",\"values\":[\"16a5f34cdelegated@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname2, 16a5f34cdelegated@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"16a5f34cdelegated@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname2, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:04.691734+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:05.061', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:05.060884+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"722240aatestusersearch@test.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"userId\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"fullname\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"722240aatestusersearch@test.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"User reviewer\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4fb1-712d-a726-90b5be4fd7e3\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"722240aatestusersearch@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.046439+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.052255+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"722240aatestusersearch@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 722240aatestusersearch@test.org\"]},{\"schema\":\"info\",\"values\":[\"722240aatestusersearch@test.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.042187+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:05.531', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:05.53114+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"batch3e871874\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-518a-7950-bbba-de0a7a130697\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"batch3e871874\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.518995+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.519039+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:05.594', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:05.593816+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-5114-7879-8ed4-77caa60c066a\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"ad87e002batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.404947+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.413275+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ad87e002batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ad87e002batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"ad87e002batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.396638+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-5114-7879-8ed4-77caa60c066a\",\"realm\":{\"operation\":\"ADD_REPLACE\",\"value\":\"/odd\"},\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-5114-7879-8ed4-77caa60c066a\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"ad87e002batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.404947+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.584799+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ad87e002batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ad87e002batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"ad87e002batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.396638+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:05.757', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:05.756133+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"2c3891d2batch@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"fullname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"email\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"firstname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-525f-7210-9d0e-990baa4b1409\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"2c3891d2batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.733958+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.744094+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"2c3891d2batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.727957+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:05.788', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:05.788114+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"batch593bd874\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-528e-7442-bf66-ffaceca158bc\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"batch593bd874\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.776537+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.776584+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:05.83', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:05.829616+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-525f-7210-9d0e-990baa4b1409\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"2c3891d2batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.733958+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.744094+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"2c3891d2batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.727957+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-525f-7210-9d0e-990baa4b1409\",\"realm\":{\"operation\":\"ADD_REPLACE\",\"value\":\"/odd\"},\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-525f-7210-9d0e-990baa4b1409\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"2c3891d2batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.733958+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.818013+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"2c3891d2batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.727957+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:06.789', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:06.788365+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"5b6f04dcbatch@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-566d-7a15-bd2f-5d392492b2b1\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"5b6f04dcbatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.769977+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.778099+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"5b6f04dcbatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.76607+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:06.812', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:06.812347+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"batch074dc4f2\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-568c-717f-945b-93873b30f079\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"batch074dc4f2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.801511+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.801575+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:06.852', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:06.852432+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-566d-7a15-bd2f-5d392492b2b1\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"5b6f04dcbatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.769977+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.778099+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"5b6f04dcbatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.76607+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-566d-7a15-bd2f-5d392492b2b1\",\"realm\":{\"operation\":\"ADD_REPLACE\",\"value\":\"/odd\"},\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-566d-7a15-bd2f-5d392492b2b1\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"5b6f04dcbatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.769977+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.845732+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"5b6f04dcbatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.76607+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:06.914', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:06.914337+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"eb0706debatch@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"fullname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"email\",\"values\":[\"eb0706debatch@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-56ef-7373-9414-86d4cc6c69d7\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"eb0706debatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.902339+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.907988+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"eb0706debatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, eb0706debatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"eb0706debatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.896084+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:06.927', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:06.927604+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"batchbf4c2839\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-5706-7846-8389-a41e2747b038\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"batchbf4c2839\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.92066+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.920699+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:06.96', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:06.960062+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-56ef-7373-9414-86d4cc6c69d7\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"eb0706debatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.902339+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.907988+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"eb0706debatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, eb0706debatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"eb0706debatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.896084+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-56ef-7373-9414-86d4cc6c69d7\",\"realm\":{\"operation\":\"ADD_REPLACE\",\"value\":\"/odd\"},\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-56ef-7373-9414-86d4cc6c69d7\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"eb0706debatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.902339+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.952402+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"eb0706debatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, eb0706debatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"eb0706debatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.896084+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:08.916', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:08.916634+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"printer124\",\"realm\":\"/even/two/realm123\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"location\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-5ec6-7398-968c-f025d79b9ca9\",\"type\":\"PRINTER\",\"realm\":\"/even/two/realm123\",\"name\":\"printer124\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:08.903918+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:08.903968+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"location\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:08.957', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:08.957541+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-5ec6-7398-968c-f025d79b9ca9\",\"type\":\"PRINTER\",\"realm\":\"/even/two/realm123\",\"name\":\"printer124\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:08.903918+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:08.903968+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"location\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["\"0194459d-5ec6-7398-968c-f025d79b9ca9\"", "false"], "logger": {"type": "LOGIC", "event": "delete", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-5ec6-7398-968c-f025d79b9ca9\",\"type\":null,\"realm\":null,\"name\":null,\"creator\":null,\"creationDate\":null,\"creationContext\":null,\"lastModifier\":null,\"lastChangeDate\":null,\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.869', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.86923+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"c42af6b9delegating@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"fullname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"userId\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"firstname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"User reviewer\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6655-742e-9738-b62ee9c39cf8\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"c42af6b9delegating@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:10.847537+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.859526+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"c42af6b9delegating@syncope.apache.org - 2025-01-08T12:12:10+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:10.838234+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.906', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.905581+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"b5e566d7delegated@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"fullname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"firstname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"userId\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6687-7d7b-aef8-407ab843c339\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"b5e566d7delegated@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:10.891661+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.897182+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"b5e566d7delegated@syncope.apache.org - 2025-01-08T12:12:10+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:10.88744+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:11.199', 'DEBUG', 'syncope.audit.Master', '{"who": "bellini", "date": "2025-01-08T12:12:11.196401+01:00", "before": "null", "inputs": ["null", "1", "25", "[]", "\"/\"", "true", "true"], "logger": {"type": "LOGIC", "event": "search", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"21\":[{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4bb5-7e85-a7b3-cae5c302a4ff\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"0fe92efacheckSuspension@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:04.026898+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.237153+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:04.234437+01:00\",\"changePwdDate\":\"2025-01-08T12:12:04.021539+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-37a3-7c0b-8dc4-c61eaf5a62a7\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"13c210b5audit@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:53.374701+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:53.452092+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"13c210b5audit@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 13c210b5audit@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"13c210b5audit@syncope.org - 2025-01-08T12:10:53+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:53.347624+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4a39-78f1-8eb6-ade14ff93f7e\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"1f1541e7checkFailedLogin@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.649444+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.790536+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:03.787607+01:00\",\"changePwdDate\":\"2025-01-08T12:12:03.642114+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-525f-7210-9d0e-990baa4b1409\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"2c3891d2batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.733958+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.818013+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"2c3891d2batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.727957+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4828-71c7-9aa4-6621fe4f1b05\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"56f27bbanonmember@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.119534+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.130978+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"56f27bbanonmember@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 56f27bbanonmember@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"56f27bbanonmember@syncope.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.112586+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-49c8-734a-bc7e-250cff4998ac\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"591f5e5dauth@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.532873+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.570056+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"591f5e5dauth@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 591f5e5dauth@test.org\"]},{\"schema\":\"info\",\"values\":[\"591f5e5dauth@test.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:03.567508+01:00\",\"changePwdDate\":\"2025-01-08T12:12:03.528524+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-566d-7a15-bd2f-5d392492b2b1\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"5b6f04dcbatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.769977+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.845732+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"5b6f04dcbatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.76607+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4670-7ea4-9aa1-c2fb97733ae9\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"5e4e43aeowner@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:02.677838+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.916004+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5e4e43aeowner@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5e4e43aeowner@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"5e4e43aeowner@syncope.org - 2025-01-08T12:12:02+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:02.912913+01:00\",\"changePwdDate\":\"2025-01-08T12:12:02.673002+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4fb1-712d-a726-90b5be4fd7e3\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"722240aatestusersearch@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.046439+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.074439+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"722240aatestusersearch@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 722240aatestusersearch@test.org\"]},{\"schema\":\"info\",\"values\":[\"722240aatestusersearch@test.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:05.071705+01:00\",\"changePwdDate\":\"2025-01-08T12:12:05.042187+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-5114-7879-8ed4-77caa60c066a\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"ad87e002batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.404947+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.584799+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ad87e002batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ad87e002batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"ad87e002batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.396638+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6687-7d7b-aef8-407ab843c339\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"b5e566d7delegated@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:10.891661+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.897182+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"b5e566d7delegated@syncope.apache.org - 2025-01-08T12:12:10+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:10.88744+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"c9b2dec2-00a7-4855-97c0-d854842b4b24\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"bellini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:11.05622+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"cool\",\"values\":[\"true\"]},{\"schema\":\"firstname\",\"values\":[\"Vincenzo\"]},{\"schema\":\"fullname\",\"values\":[\"Vincenzo Bellini\"]},{\"schema\":\"gender\",\"values\":[\"M\"]},{\"schema\":\"loginDate\",\"values\":[\"2009-06-23\"]},{\"schema\":\"surname\",\"values\":[\"Bellini\"]},{\"schema\":\"userId\",\"values\":[\"bellini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Bellini, Vincenzo\"]},{\"schema\":\"info\",\"values\":[\"bellini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Bellini, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-nopropagation\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:11.053675+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[{\"groupKey\":\"bf825fe1-7320-4a54-bd64-143b5c18ab97\",\"groupName\":\"managingDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"User manager\",\"User reviewer\",\"role79537fa7\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[\"0194459d-6719-7462-ba78-51b3cc78ee6b\"],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6655-742e-9738-b62ee9c39cf8\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"c42af6b9delegating@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:10.847537+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.859526+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"c42af6b9delegating@syncope.apache.org - 2025-01-08T12:12:10+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:10.838234+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:01.033673+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.566041+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org - 2025-01-08T12:12:01+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:02.561364+01:00\",\"changePwdDate\":\"2025-01-08T12:12:01.317952+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-56ef-7373-9414-86d4cc6c69d7\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"eb0706debatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.902339+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.952402+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"eb0706debatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, eb0706debatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"eb0706debatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.896084+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4af4-793f-b2ce-dca2e8b84a47\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"ec186541testuserread@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.832634+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.860749+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ec186541testuserread@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ec186541testuserread@test.org\"]},{\"schema\":\"info\",\"values\":[\"ec186541testuserread@test.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:03.857855+01:00\",\"changePwdDate\":\"2025-01-08T12:12:03.828597+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4874-73e5-8784-e7c0b1225f36\",\"type\":\"USER\",\"realm\":\"/even\",\"username\":\"new4a2318c2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.196729+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"5e4e43aeowner@syncope.org\",\"lastChangeDate\":\"2025-01-08T12:12:03.370506+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"new4a2318c2 - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.188894+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"puccini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.348806+01:00\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"Giacomo\"]},{\"schema\":\"fullname\",\"values\":[\"Giacomo Puccini\"]},{\"schema\":\"surname\",\"values\":[\"Puccini\"]},{\"schema\":\"userId\",\"values\":[\"puccini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Puccini, Giacomo\"]},{\"schema\":\"info\",\"values\":[\"puccini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Puccini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:10.342741+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"groupName\":\"artDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Search for realm evenTwo\",\"Connector and Resource for realm evenTwo\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"1417acbe-cbf6-4277-9372-e75e04f97000\",\"type\":\"USER\",\"realm\":\"/even\",\"username\":\"rossini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"G\"]},{\"schema\":\"firstname\",\"values\":[\"Gioacchino\"]},{\"schema\":\"fullname\",\"values\":[\"Gioacchino Rossini\"]},{\"schema\":\"loginDate\",\"values\":[\"2009-05-25\",\"2010-05-25\"]},{\"schema\":\"surname\",\"values\":[\"Rossini\"]},{\"schema\":\"userId\",\"values\":[\"rossini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Rossini, Gioacchino\"]},{\"schema\":\"info\",\"values\":[\"rossini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Rossini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\",\"ws-target-resource-2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":\"root\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"f779c0d4-633b-4be5-8f57-32eb478a3ca5\",\"groupName\":\"otherchild\",\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"noschema\",\"values\":[\", \"]}],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Other\"],\"dynRoles\":[],\"privileges\":[\"postMighty\"],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[\"0194459d-6719-7462-ba78-51b3cc78ee6b\"]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"74cd8ece-715a-44a4-a736-e17b46c4e7e6\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"verdi\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"verdi@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"Giuseppe\"]},{\"schema\":\"fullname\",\"values\":[\"Giuseppe Verdi\"]},{\"schema\":\"surname\",\"values\":[\"Verdi\"]},{\"schema\":\"userId\",\"values\":[\"verdi@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Verdi, Giuseppe\"]},{\"schema\":\"info\",\"values\":[\"verdi - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Verdi, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-list-mappings-1\",\"ws-target-resource-list-mappings-2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":\"root\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"b1f7c12d-ec83-441f-a50e-1691daaedf3b\",\"groupName\":\"child\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"29f96485-729e-4d31-88a1-6fc60e4677f3\",\"groupName\":\"citizen\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"vivaldi\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"F\"]},{\"schema\":\"email\",\"values\":[\"vivaldi@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"Antonio\"]},{\"schema\":\"fullname\",\"values\":[\"Antonio Vivaldi\"]},{\"schema\":\"surname\",\"values\":[\"Vivaldi\"]},{\"schema\":\"userId\",\"values\":[\"vivaldi@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Vivaldi, Antonio\"]},{\"schema\":\"info\",\"values\":[\"vivaldi - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Vivaldi, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-1\",\"ws-target-resource-2\",\"ws-target-resource-delete\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:11.368', 'DEBUG', 'syncope.audit.Master', '{"who": "rossini [delegated by bellini]", "date": "2025-01-08T12:12:11.367524+01:00", "before": "null", "inputs": ["null", "1", "25", "[]", "\"/\"", "true", "true"], "logger": {"type": "LOGIC", "event": "search", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"21\":[{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4bb5-7e85-a7b3-cae5c302a4ff\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"0fe92efacheckSuspension@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:04.026898+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:04.237153+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 0fe92efacheckSuspension@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"0fe92efacheckSuspension@syncope.apache.org - 2025-01-08T12:12:04+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:04.234437+01:00\",\"changePwdDate\":\"2025-01-08T12:12:04.021539+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459c-37a3-7c0b-8dc4-c61eaf5a62a7\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"13c210b5audit@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:10:53.374701+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:10:53.452092+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"13c210b5audit@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"13c210b5audit@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 13c210b5audit@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"13c210b5audit@syncope.org - 2025-01-08T12:10:53+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:10:53.347624+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4a39-78f1-8eb6-ade14ff93f7e\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"1f1541e7checkFailedLogin@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.649444+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.790536+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 1f1541e7checkFailedLogin@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"1f1541e7checkFailedLogin@syncope.apache.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:03.787607+01:00\",\"changePwdDate\":\"2025-01-08T12:12:03.642114+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-525f-7210-9d0e-990baa4b1409\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"2c3891d2batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.733958+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.818013+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"2c3891d2batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 2c3891d2batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"2c3891d2batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.727957+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4828-71c7-9aa4-6621fe4f1b05\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"56f27bbanonmember@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.119534+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.130978+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"56f27bbanonmember@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"56f27bbanonmember@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 56f27bbanonmember@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"56f27bbanonmember@syncope.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.112586+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-49c8-734a-bc7e-250cff4998ac\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"591f5e5dauth@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.532873+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.570056+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"591f5e5dauth@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"591f5e5dauth@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 591f5e5dauth@test.org\"]},{\"schema\":\"info\",\"values\":[\"591f5e5dauth@test.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:03.567508+01:00\",\"changePwdDate\":\"2025-01-08T12:12:03.528524+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-566d-7a15-bd2f-5d392492b2b1\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"5b6f04dcbatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.769977+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.845732+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5b6f04dcbatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5b6f04dcbatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"5b6f04dcbatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.76607+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4670-7ea4-9aa1-c2fb97733ae9\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"5e4e43aeowner@syncope.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:02.677838+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.916004+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"5e4e43aeowner@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"5e4e43aeowner@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 5e4e43aeowner@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"5e4e43aeowner@syncope.org - 2025-01-08T12:12:02+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:02.912913+01:00\",\"changePwdDate\":\"2025-01-08T12:12:02.673002+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4fb1-712d-a726-90b5be4fd7e3\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"722240aatestusersearch@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.046439+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.074439+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"722240aatestusersearch@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"722240aatestusersearch@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 722240aatestusersearch@test.org\"]},{\"schema\":\"info\",\"values\":[\"722240aatestusersearch@test.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:05.071705+01:00\",\"changePwdDate\":\"2025-01-08T12:12:05.042187+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-5114-7879-8ed4-77caa60c066a\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"ad87e002batch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:05.404947+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:05.584799+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"ad87e002batch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ad87e002batch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ad87e002batch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"ad87e002batch@syncope.apache.org - 2025-01-08T12:12:05+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:05.396638+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6687-7d7b-aef8-407ab843c339\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"b5e566d7delegated@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:10.891661+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.897182+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"b5e566d7delegated@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, b5e566d7delegated@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"b5e566d7delegated@syncope.apache.org - 2025-01-08T12:12:10+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:10.88744+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"c9b2dec2-00a7-4855-97c0-d854842b4b24\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"bellini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:11.05622+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"cool\",\"values\":[\"true\"]},{\"schema\":\"firstname\",\"values\":[\"Vincenzo\"]},{\"schema\":\"fullname\",\"values\":[\"Vincenzo Bellini\"]},{\"schema\":\"gender\",\"values\":[\"M\"]},{\"schema\":\"loginDate\",\"values\":[\"2009-06-23\"]},{\"schema\":\"surname\",\"values\":[\"Bellini\"]},{\"schema\":\"userId\",\"values\":[\"bellini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Bellini, Vincenzo\"]},{\"schema\":\"info\",\"values\":[\"bellini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Bellini, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-nopropagation\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:11.053675+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[{\"type\":\"neighborhood\",\"end\":\"LEFT\",\"otherEndType\":\"PRINTER\",\"otherEndKey\":\"fc6dbc3a-6c07-4965-8781-921e7401a4a5\",\"otherEndName\":\"HP LJ 1300n\"}],\"memberships\":[{\"groupKey\":\"bf825fe1-7320-4a54-bd64-143b5c18ab97\",\"groupName\":\"managingDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"User manager\",\"User reviewer\",\"role79537fa7\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[\"0194459d-6719-7462-ba78-51b3cc78ee6b\"],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6655-742e-9738-b62ee9c39cf8\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"c42af6b9delegating@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:10.847537+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.859526+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"c42af6b9delegating@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, c42af6b9delegating@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"c42af6b9delegating@syncope.apache.org - 2025-01-08T12:12:10+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:10.838234+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4001-7a8c-a1ea-07011a11de0c\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"cf2ff9f2syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:01.033673+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:02.566041+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cf2ff9f2syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cf2ff9f2syncope164@syncope.apache.org - 2025-01-08T12:12:01+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:02.561364+01:00\",\"changePwdDate\":\"2025-01-08T12:12:01.317952+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-56ef-7373-9414-86d4cc6c69d7\",\"type\":\"USER\",\"realm\":\"/odd\",\"username\":\"eb0706debatch@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:06.902339+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:06.952402+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"eb0706debatch@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"eb0706debatch@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, eb0706debatch@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"eb0706debatch@syncope.apache.org - 2025-01-08T12:12:06+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:06.896084+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4af4-793f-b2ce-dca2e8b84a47\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"ec186541testuserread@test.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.832634+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:03.860749+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"firstname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"fullname\",\"values\":[\"ec186541testuserread@test.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"ec186541testuserread@test.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, ec186541testuserread@test.org\"]},{\"schema\":\"info\",\"values\":[\"ec186541testuserread@test.org - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:03.857855+01:00\",\"changePwdDate\":\"2025-01-08T12:12:03.828597+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User manager\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-4874-73e5-8784-e7c0b1225f36\",\"type\":\"USER\",\"realm\":\"/even\",\"username\":\"new4a2318c2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:03.196729+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"5e4e43aeowner@syncope.org\",\"lastChangeDate\":\"2025-01-08T12:12:03.370506+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"fullname\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"4a9dedadforgroupownership2@syncope.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 4a9dedadforgroupownership2@syncope.org\"]},{\"schema\":\"info\",\"values\":[\"new4a2318c2 - 2025-01-08T12:12:03+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:03.188894+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-468f-7f7e-afef-4a0663760532\",\"groupName\":\"forgroupownershipff9b602d\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"puccini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.348806+01:00\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"Giacomo\"]},{\"schema\":\"fullname\",\"values\":[\"Giacomo Puccini\"]},{\"schema\":\"surname\",\"values\":[\"Puccini\"]},{\"schema\":\"userId\",\"values\":[\"puccini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Puccini, Giacomo\"]},{\"schema\":\"info\",\"values\":[\"puccini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Puccini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:10.342741+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"groupName\":\"artDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Search for realm evenTwo\",\"Connector and Resource for realm evenTwo\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"1417acbe-cbf6-4277-9372-e75e04f97000\",\"type\":\"USER\",\"realm\":\"/even\",\"username\":\"rossini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:11.22432+01:00\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"G\"]},{\"schema\":\"firstname\",\"values\":[\"Gioacchino\"]},{\"schema\":\"fullname\",\"values\":[\"Gioacchino Rossini\"]},{\"schema\":\"loginDate\",\"values\":[\"2009-05-25\",\"2010-05-25\"]},{\"schema\":\"surname\",\"values\":[\"Rossini\"]},{\"schema\":\"userId\",\"values\":[\"rossini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Rossini, Gioacchino\"]},{\"schema\":\"info\",\"values\":[\"rossini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Rossini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\",\"ws-target-resource-2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:11.219841+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":\"root\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"f779c0d4-633b-4be5-8f57-32eb478a3ca5\",\"groupName\":\"otherchild\",\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"noschema\",\"values\":[\", \"]}],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Other\"],\"dynRoles\":[],\"privileges\":[\"postMighty\"],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[\"0194459d-6719-7462-ba78-51b3cc78ee6b\"]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"74cd8ece-715a-44a4-a736-e17b46c4e7e6\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"verdi\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"verdi@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"Giuseppe\"]},{\"schema\":\"fullname\",\"values\":[\"Giuseppe Verdi\"]},{\"schema\":\"surname\",\"values\":[\"Verdi\"]},{\"schema\":\"userId\",\"values\":[\"verdi@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Verdi, Giuseppe\"]},{\"schema\":\"info\",\"values\":[\"verdi - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Verdi, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-list-mappings-1\",\"ws-target-resource-list-mappings-2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"37d15e4c-cdc1-460b-a591-8505c8133806\",\"groupName\":\"root\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"b1f7c12d-ec83-441f-a50e-1691daaedf3b\",\"groupName\":\"child\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]},{\"groupKey\":\"29f96485-729e-4d31-88a1-6fc60e4677f3\",\"groupName\":\"citizen\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"vivaldi\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"F\"]},{\"schema\":\"email\",\"values\":[\"vivaldi@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"Antonio\"]},{\"schema\":\"fullname\",\"values\":[\"Antonio Vivaldi\"]},{\"schema\":\"surname\",\"values\":[\"Vivaldi\"]},{\"schema\":\"userId\",\"values\":[\"vivaldi@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Vivaldi, Antonio\"]},{\"schema\":\"info\",\"values\":[\"vivaldi - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Vivaldi, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-1\",\"ws-target-resource-2\",\"ws-target-resource-delete\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:12.439', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:12.438859+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"69b0c9a7delegating@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]},{\"schema\":\"email\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"userId\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"fullname\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"User reviewer\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6c84-7cb5-8d8f-8343769883ae\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"69b0c9a7delegating@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:12.425608+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:12.431981+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"69b0c9a7delegating@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 69b0c9a7delegating@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"69b0c9a7delegating@syncope.apache.org - 2025-01-08T12:12:12+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:12.420615+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"User reviewer\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:12.463', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:12.462469+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"4abc534bdelegated@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"email\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"userId\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"fullname\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6c9d-7f2e-9a34-7b5065d5bb7d\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"4abc534bdelegated@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:12.450749+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:12.456536+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"4abc534bdelegated@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 4abc534bdelegated@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"4abc534bdelegated@syncope.apache.org - 2025-01-08T12:12:12+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:12.446016+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:12.913', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:12.912979+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"e7749f28syncope1480@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"userId\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"61c0e33f\"]},{\"schema\":\"fullname\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6e53-761f-aca6-7d59039ef5e5\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"e7749f28syncope1480@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:12.88771+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:12.89924+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"name135e58a4\"],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"61c0e33f\"]},{\"schema\":\"email\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"e7749f28syncope1480@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, e7749f28syncope1480@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"e7749f28syncope1480@syncope.apache.org - 2025-01-08T12:12:12+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:12.883591+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:09.768', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:09.767882+01:00", "before": "{\"key\":\"fcf9f2b0-f7d6-42c9-84a6-61b28255a42b\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:9080/syncope-fit-build-tools/cxf/soap/provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"ConnInstance103\",\"connRequestTimeout\":10,\"poolConf\":null}", "inputs": ["{\"key\":\"fcf9f2b0-f7d6-42c9-84a6-61b28255a42b\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:9080/syncope-fit-build-tools/cxf/soap/provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"SEARCH\"],\"displayName\":\"ConnInstance103\",\"connRequestTimeout\":10,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"fcf9f2b0-f7d6-42c9-84a6-61b28255a42b\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:9080/syncope-fit-build-tools/cxf/soap/provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"SEARCH\"],\"displayName\":\"ConnInstance103\",\"connRequestTimeout\":10,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.173', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.173418+01:00", "before": "null", "inputs": ["{\"key\":null,\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"servicename\",\"displayName\":null,\"helpMessage\":null,\"type\":\"java.lang.String\",\"required\":true,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"endpoint\",\"displayName\":null,\"helpMessage\":null,\"type\":\"java.lang.String\",\"required\":true,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\",\"Provisioning\"],\"overridable\":false}],\"capabilities\":[\"CREATE\",\"UPDATE\"],\"displayName\":\"Display name\",\"connRequestTimeout\":15,\"poolConf\":{\"maxObjects\":1534,\"minIdle\":null,\"maxIdle\":null,\"maxWait\":null,\"minEvictableIdleTimeMillis\":null}}"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"0194459d-63b7-7a9d-94dd-3ba0b3d94e6e\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\",\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"Display name\",\"connRequestTimeout\":15,\"poolConf\":{\"maxObjects\":1534,\"minIdle\":1,\"maxIdle\":10,\"maxWait\":150000,\"minEvictableIdleTimeMillis\":120000}}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.187', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.187417+01:00", "before": "{\"key\":\"0194459d-63b7-7a9d-94dd-3ba0b3d94e6e\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\",\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"CREATE\",\"UPDATE\"],\"displayName\":\"Display name\",\"connRequestTimeout\":15,\"poolConf\":{\"maxObjects\":1534,\"minIdle\":1,\"maxIdle\":10,\"maxWait\":150000,\"minEvictableIdleTimeMillis\":120000}}", "inputs": ["{\"key\":\"0194459d-63b7-7a9d-94dd-3ba0b3d94e6e\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\",\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"CREATE\"],\"displayName\":\"Display name\",\"connRequestTimeout\":15,\"poolConf\":{\"maxObjects\":null,\"minIdle\":1,\"maxIdle\":10,\"maxWait\":150000,\"minEvictableIdleTimeMillis\":120000}}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"0194459d-63b7-7a9d-94dd-3ba0b3d94e6e\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\",\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"CREATE\"],\"displayName\":\"Display name\",\"connRequestTimeout\":15,\"poolConf\":{\"maxObjects\":10,\"minIdle\":1,\"maxIdle\":10,\"maxWait\":150000,\"minEvictableIdleTimeMillis\":120000}}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.306', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.305832+01:00", "before": "{\"key\":\"fcf9f2b0-f7d6-42c9-84a6-61b28255a42b\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:9080/syncope-fit-build-tools/cxf/soap/provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"SEARCH\"],\"displayName\":\"ConnInstance103\",\"connRequestTimeout\":10,\"poolConf\":null}", "inputs": ["{\"key\":\"fcf9f2b0-f7d6-42c9-84a6-61b28255a42b\",\"errored\":false,\"adminRealm\":\"/\",\"location\":null,\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"servicename\",\"displayName\":null,\"helpMessage\":null,\"type\":\"java.lang.String\",\"required\":true,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"endpoint\",\"displayName\":null,\"helpMessage\":null,\"type\":\"java.lang.String\",\"required\":true,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\"],\"overridable\":false}],\"capabilities\":[],\"displayName\":null,\"connRequestTimeout\":20,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"fcf9f2b0-f7d6-42c9-84a6-61b28255a42b\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"ConnInstance103\",\"connRequestTimeout\":20,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.421', 'DEBUG', 'syncope.audit.Master', '{"who": "puccini", "date": "2025-01-08T12:12:10.420348+01:00", "before": "{\"key\":\"a6d017fd-a705-4507-bb7c-6ab6a6745997\",\"errored\":false,\"adminRealm\":\"/even/two\",\"location\":\"connid://testconnectorserver@localhost:4554\",\"connectorName\":\"net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConnector\",\"bundleName\":\"net.tirasa.connid.bundles.db\",\"version\":\"2.3.0\",\"conf\":[{\"schema\":{\"name\":\"quoting\",\"displayName\":\"Name Quoting\",\"helpMessage\":\"<b>Name Quoting</b><br/>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-15,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"<b>Host</b><br/>Enter the name of the host where the database is running.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-14,\"confidential\":false,\"defaultValues\":[\"localhost\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"Port\",\"helpMessage\":\"<b>TCP Port</b><br/>Enter the port number the database server is listening on.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-13,\"confidential\":false,\"defaultValues\":[\"3306\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"user\",\"displayName\":\"User\",\"helpMessage\":\"<b>User</b><br/>Enter the name of the mandatory Database user with permission to account table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-12,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"password\",\"displayName\":\"User Password\",\"helpMessage\":\"<b>User Password</b><br/>Enter a user account that has permission to access accounts table.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":-11,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"database\",\"displayName\":\"Database\",\"helpMessage\":\"<b>Database</b><br/>Enter the name of the database on the database server that contains the table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-10,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jdbcDriver\",\"displayName\":\"JDBC Driver\",\"helpMessage\":\"<b>JDBC Driver</b><br/>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-9,\"confidential\":false,\"defaultValues\":[\"com.mysql.jdbc.Driver\"]},\"values\":[\"org.h2.Driver\"],\"overridable\":false},{\"schema\":{\"name\":\"jdbcUrlTemplate\",\"displayName\":\"JDBC Connection URL\",\"helpMessage\":\"<b>JDBC Connection URL</b><br/>Specify the JDBC Driver Connection URL.<br/> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br/>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-8,\"confidential\":false,\"defaultValues\":[\"jdbc:mysql://%h:%p/%d\"]},\"values\":[\"jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1\"],\"overridable\":false},{\"schema\":{\"name\":\"autoCommit\",\"displayName\":\"autoCommit\",\"helpMessage\":\"autoCommit\",\"type\":\"boolean\",\"required\":false,\"order\":-7,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"enableEmptyString\",\"displayName\":\"Enable writing empty string\",\"helpMessage\":\"<b>Enable writing empty string</b><br/>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.\",\"type\":\"boolean\",\"required\":false,\"order\":-6,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"rethrowAllSQLExceptions\",\"displayName\":\"Rethrow all SQLExceptions\",\"helpMessage\":\"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.\",\"type\":\"boolean\",\"required\":false,\"order\":-5,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"nativeTimestamps\",\"displayName\":\"Native Timestamps\",\"helpMessage\":\"<b>Native Timestamps</b><br/>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-4,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"allNative\",\"displayName\":\"All native\",\"helpMessage\":\"<b>All native</b><br/>Select to retrieve all data type of the columns in a native format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"validConnectionQuery\",\"displayName\":\"Validate Connection Query\",\"helpMessage\":\"<b>Validate Connection Query</b><br/>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"datasource\",\"displayName\":\"Datasource Path\",\"helpMessage\":\"<b>JDBC Data Source Name/Path</b><br/>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br/>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-1,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jndiProperties\",\"displayName\":\"Initial JNDI Properties\",\"helpMessage\":\"<b>Initial JNDI Properties</b><br/>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"scriptingLanguage\",\"displayName\":\"scriptingLanguage\",\"helpMessage\":\"scriptingLanguage\",\"type\":\"java.lang.String\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[\"GROOVY\"]},\"values\":[\"GROOVY\"],\"overridable\":false},{\"schema\":{\"name\":\"clearTextPasswordToScript\",\"displayName\":\"clearTextPasswordToScript\",\"helpMessage\":\"clearTextPasswordToScript\",\"type\":\"boolean\",\"required\":false,\"order\":1,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"reloadScriptOnExecution\",\"displayName\":\"reloadScriptOnExecution\",\"helpMessage\":\"reloadScriptOnExecution\",\"type\":\"boolean\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"createScript\",\"displayName\":\"createScript\",\"helpMessage\":\"createScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"updateScript\",\"displayName\":\"updateScript\",\"helpMessage\":\"updateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"deleteScript\",\"displayName\":\"deleteScript\",\"helpMessage\":\"deleteScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"searchScript\",\"displayName\":\"searchScript\",\"helpMessage\":\"searchScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScript\",\"displayName\":\"resolveUsernameScript\",\"helpMessage\":\"resolveUsernameScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"authenticateScript\",\"displayName\":\"authenticateScript\",\"helpMessage\":\"authenticateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScript\",\"displayName\":\"syncScript\",\"helpMessage\":\"syncScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"schemaScript\",\"displayName\":\"schemaScript\",\"helpMessage\":\"schemaScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"testScript\",\"displayName\":\"testScript\",\"helpMessage\":\"testScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"createScriptFileName\",\"displayName\":\"createScriptFileName\",\"helpMessage\":\"createScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/CreateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"updateScriptFileName\",\"displayName\":\"updateScriptFileName\",\"helpMessage\":\"updateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/UpdateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteScriptFileName\",\"displayName\":\"deleteScriptFileName\",\"helpMessage\":\"deleteScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/DeleteScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"searchScriptFileName\",\"displayName\":\"searchScriptFileName\",\"helpMessage\":\"searchScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SearchScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"authenticateScriptFileName\",\"displayName\":\"authenticateScriptFileName\",\"helpMessage\":\"authenticateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScriptFileName\",\"displayName\":\"resolveUsernameScriptFileName\",\"helpMessage\":\"resolveUsernameScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScriptFileName\",\"displayName\":\"syncScriptFileName\",\"helpMessage\":\"syncScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SyncScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"schemaScriptFileName\",\"displayName\":\"schemaScriptFileName\",\"helpMessage\":\"schemaScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SchemaScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"testScriptFileName\",\"displayName\":\"testScriptFileName\",\"helpMessage\":\"testScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/TestScript.groovy\"],\"overridable\":true}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"UPDATE_DELTA\",\"DELETE\",\"SEARCH\",\"SYNC\"],\"displayName\":\"Scripted SQL\",\"connRequestTimeout\":10,\"poolConf\":null}", "inputs": ["{\"key\":\"a6d017fd-a705-4507-bb7c-6ab6a6745997\",\"errored\":false,\"adminRealm\":\"/even/two\",\"location\":\"connid://testconnectorserver@localhost:4554\",\"connectorName\":\"net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConnector\",\"bundleName\":\"net.tirasa.connid.bundles.db\",\"version\":\"2.3.0\",\"conf\":[{\"schema\":{\"name\":\"quoting\",\"displayName\":\"Name Quoting\",\"helpMessage\":\"<b>Name Quoting</b><br/>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-15,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"<b>Host</b><br/>Enter the name of the host where the database is running.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-14,\"confidential\":false,\"defaultValues\":[\"localhost\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"Port\",\"helpMessage\":\"<b>TCP Port</b><br/>Enter the port number the database server is listening on.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-13,\"confidential\":false,\"defaultValues\":[\"3306\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"user\",\"displayName\":\"User\",\"helpMessage\":\"<b>User</b><br/>Enter the name of the mandatory Database user with permission to account table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-12,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"password\",\"displayName\":\"User Password\",\"helpMessage\":\"<b>User Password</b><br/>Enter a user account that has permission to access accounts table.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":-11,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"database\",\"displayName\":\"Database\",\"helpMessage\":\"<b>Database</b><br/>Enter the name of the database on the database server that contains the table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-10,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jdbcDriver\",\"displayName\":\"JDBC Driver\",\"helpMessage\":\"<b>JDBC Driver</b><br/>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-9,\"confidential\":false,\"defaultValues\":[\"com.mysql.jdbc.Driver\"]},\"values\":[\"org.h2.Driver\"],\"overridable\":false},{\"schema\":{\"name\":\"jdbcUrlTemplate\",\"displayName\":\"JDBC Connection URL\",\"helpMessage\":\"<b>JDBC Connection URL</b><br/>Specify the JDBC Driver Connection URL.<br/> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br/>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-8,\"confidential\":false,\"defaultValues\":[\"jdbc:mysql://%h:%p/%d\"]},\"values\":[\"jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1\"],\"overridable\":false},{\"schema\":{\"name\":\"autoCommit\",\"displayName\":\"autoCommit\",\"helpMessage\":\"autoCommit\",\"type\":\"boolean\",\"required\":false,\"order\":-7,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"enableEmptyString\",\"displayName\":\"Enable writing empty string\",\"helpMessage\":\"<b>Enable writing empty string</b><br/>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.\",\"type\":\"boolean\",\"required\":false,\"order\":-6,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"rethrowAllSQLExceptions\",\"displayName\":\"Rethrow all SQLExceptions\",\"helpMessage\":\"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.\",\"type\":\"boolean\",\"required\":false,\"order\":-5,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"nativeTimestamps\",\"displayName\":\"Native Timestamps\",\"helpMessage\":\"<b>Native Timestamps</b><br/>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-4,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"allNative\",\"displayName\":\"All native\",\"helpMessage\":\"<b>All native</b><br/>Select to retrieve all data type of the columns in a native format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"validConnectionQuery\",\"displayName\":\"Validate Connection Query\",\"helpMessage\":\"<b>Validate Connection Query</b><br/>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"datasource\",\"displayName\":\"Datasource Path\",\"helpMessage\":\"<b>JDBC Data Source Name/Path</b><br/>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br/>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-1,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jndiProperties\",\"displayName\":\"Initial JNDI Properties\",\"helpMessage\":\"<b>Initial JNDI Properties</b><br/>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"scriptingLanguage\",\"displayName\":\"scriptingLanguage\",\"helpMessage\":\"scriptingLanguage\",\"type\":\"java.lang.String\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[\"GROOVY\"]},\"values\":[\"GROOVY\"],\"overridable\":false},{\"schema\":{\"name\":\"clearTextPasswordToScript\",\"displayName\":\"clearTextPasswordToScript\",\"helpMessage\":\"clearTextPasswordToScript\",\"type\":\"boolean\",\"required\":false,\"order\":1,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"reloadScriptOnExecution\",\"displayName\":\"reloadScriptOnExecution\",\"helpMessage\":\"reloadScriptOnExecution\",\"type\":\"boolean\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"createScript\",\"displayName\":\"createScript\",\"helpMessage\":\"createScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"updateScript\",\"displayName\":\"updateScript\",\"helpMessage\":\"updateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"deleteScript\",\"displayName\":\"deleteScript\",\"helpMessage\":\"deleteScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"searchScript\",\"displayName\":\"searchScript\",\"helpMessage\":\"searchScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScript\",\"displayName\":\"resolveUsernameScript\",\"helpMessage\":\"resolveUsernameScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"authenticateScript\",\"displayName\":\"authenticateScript\",\"helpMessage\":\"authenticateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScript\",\"displayName\":\"syncScript\",\"helpMessage\":\"syncScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"schemaScript\",\"displayName\":\"schemaScript\",\"helpMessage\":\"schemaScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"testScript\",\"displayName\":\"testScript\",\"helpMessage\":\"testScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"createScriptFileName\",\"displayName\":\"createScriptFileName\",\"helpMessage\":\"createScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/CreateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"updateScriptFileName\",\"displayName\":\"updateScriptFileName\",\"helpMessage\":\"updateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/UpdateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteScriptFileName\",\"displayName\":\"deleteScriptFileName\",\"helpMessage\":\"deleteScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/DeleteScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"searchScriptFileName\",\"displayName\":\"searchScriptFileName\",\"helpMessage\":\"searchScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SearchScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"authenticateScriptFileName\",\"displayName\":\"authenticateScriptFileName\",\"helpMessage\":\"authenticateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScriptFileName\",\"displayName\":\"resolveUsernameScriptFileName\",\"helpMessage\":\"resolveUsernameScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScriptFileName\",\"displayName\":\"syncScriptFileName\",\"helpMessage\":\"syncScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SyncScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"schemaScriptFileName\",\"displayName\":\"schemaScriptFileName\",\"helpMessage\":\"schemaScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SchemaScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"testScriptFileName\",\"displayName\":\"testScriptFileName\",\"helpMessage\":\"testScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/TestScript.groovy\"],\"overridable\":true}],\"capabilities\":[\"DELETE\",\"CREATE\",\"SYNC\",\"UPDATE\",\"UPDATE_DELTA\",\"SEARCH\"],\"displayName\":\"Scripted SQL\",\"connRequestTimeout\":10,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"a6d017fd-a705-4507-bb7c-6ab6a6745997\",\"errored\":false,\"adminRealm\":\"/even/two\",\"location\":\"connid://testconnectorserver@localhost:4554\",\"connectorName\":\"net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConnector\",\"bundleName\":\"net.tirasa.connid.bundles.db\",\"version\":\"2.3.0\",\"conf\":[{\"schema\":{\"name\":\"quoting\",\"displayName\":\"Name Quoting\",\"helpMessage\":\"<b>Name Quoting</b><br/>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-15,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"<b>Host</b><br/>Enter the name of the host where the database is running.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-14,\"confidential\":false,\"defaultValues\":[\"localhost\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"Port\",\"helpMessage\":\"<b>TCP Port</b><br/>Enter the port number the database server is listening on.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-13,\"confidential\":false,\"defaultValues\":[\"3306\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"user\",\"displayName\":\"User\",\"helpMessage\":\"<b>User</b><br/>Enter the name of the mandatory Database user with permission to account table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-12,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"password\",\"displayName\":\"User Password\",\"helpMessage\":\"<b>User Password</b><br/>Enter a user account that has permission to access accounts table.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":-11,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"database\",\"displayName\":\"Database\",\"helpMessage\":\"<b>Database</b><br/>Enter the name of the database on the database server that contains the table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-10,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jdbcDriver\",\"displayName\":\"JDBC Driver\",\"helpMessage\":\"<b>JDBC Driver</b><br/>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-9,\"confidential\":false,\"defaultValues\":[\"com.mysql.jdbc.Driver\"]},\"values\":[\"org.h2.Driver\"],\"overridable\":false},{\"schema\":{\"name\":\"jdbcUrlTemplate\",\"displayName\":\"JDBC Connection URL\",\"helpMessage\":\"<b>JDBC Connection URL</b><br/>Specify the JDBC Driver Connection URL.<br/> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br/>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-8,\"confidential\":false,\"defaultValues\":[\"jdbc:mysql://%h:%p/%d\"]},\"values\":[\"jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1\"],\"overridable\":false},{\"schema\":{\"name\":\"autoCommit\",\"displayName\":\"autoCommit\",\"helpMessage\":\"autoCommit\",\"type\":\"boolean\",\"required\":false,\"order\":-7,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"enableEmptyString\",\"displayName\":\"Enable writing empty string\",\"helpMessage\":\"<b>Enable writing empty string</b><br/>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.\",\"type\":\"boolean\",\"required\":false,\"order\":-6,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"rethrowAllSQLExceptions\",\"displayName\":\"Rethrow all SQLExceptions\",\"helpMessage\":\"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.\",\"type\":\"boolean\",\"required\":false,\"order\":-5,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"nativeTimestamps\",\"displayName\":\"Native Timestamps\",\"helpMessage\":\"<b>Native Timestamps</b><br/>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-4,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"allNative\",\"displayName\":\"All native\",\"helpMessage\":\"<b>All native</b><br/>Select to retrieve all data type of the columns in a native format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"validConnectionQuery\",\"displayName\":\"Validate Connection Query\",\"helpMessage\":\"<b>Validate Connection Query</b><br/>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"datasource\",\"displayName\":\"Datasource Path\",\"helpMessage\":\"<b>JDBC Data Source Name/Path</b><br/>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br/>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-1,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jndiProperties\",\"displayName\":\"Initial JNDI Properties\",\"helpMessage\":\"<b>Initial JNDI Properties</b><br/>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"scriptingLanguage\",\"displayName\":\"scriptingLanguage\",\"helpMessage\":\"scriptingLanguage\",\"type\":\"java.lang.String\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[\"GROOVY\"]},\"values\":[\"GROOVY\"],\"overridable\":false},{\"schema\":{\"name\":\"clearTextPasswordToScript\",\"displayName\":\"clearTextPasswordToScript\",\"helpMessage\":\"clearTextPasswordToScript\",\"type\":\"boolean\",\"required\":false,\"order\":1,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"reloadScriptOnExecution\",\"displayName\":\"reloadScriptOnExecution\",\"helpMessage\":\"reloadScriptOnExecution\",\"type\":\"boolean\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"createScript\",\"displayName\":\"createScript\",\"helpMessage\":\"createScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"updateScript\",\"displayName\":\"updateScript\",\"helpMessage\":\"updateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"deleteScript\",\"displayName\":\"deleteScript\",\"helpMessage\":\"deleteScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScript\",\"displayName\":\"resolveUsernameScript\",\"helpMessage\":\"resolveUsernameScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"authenticateScript\",\"displayName\":\"authenticateScript\",\"helpMessage\":\"authenticateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"searchScript\",\"displayName\":\"searchScript\",\"helpMessage\":\"searchScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScript\",\"displayName\":\"syncScript\",\"helpMessage\":\"syncScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"schemaScript\",\"displayName\":\"schemaScript\",\"helpMessage\":\"schemaScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"testScript\",\"displayName\":\"testScript\",\"helpMessage\":\"testScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"createScriptFileName\",\"displayName\":\"createScriptFileName\",\"helpMessage\":\"createScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/CreateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"updateScriptFileName\",\"displayName\":\"updateScriptFileName\",\"helpMessage\":\"updateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/UpdateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteScriptFileName\",\"displayName\":\"deleteScriptFileName\",\"helpMessage\":\"deleteScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/DeleteScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"searchScriptFileName\",\"displayName\":\"searchScriptFileName\",\"helpMessage\":\"searchScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SearchScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"authenticateScriptFileName\",\"displayName\":\"authenticateScriptFileName\",\"helpMessage\":\"authenticateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScriptFileName\",\"displayName\":\"resolveUsernameScriptFileName\",\"helpMessage\":\"resolveUsernameScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScriptFileName\",\"displayName\":\"syncScriptFileName\",\"helpMessage\":\"syncScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SyncScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"schemaScriptFileName\",\"displayName\":\"schemaScriptFileName\",\"helpMessage\":\"schemaScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SchemaScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"testScriptFileName\",\"displayName\":\"testScriptFileName\",\"helpMessage\":\"testScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/TestScript.groovy\"],\"overridable\":true}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"UPDATE_DELTA\",\"DELETE\",\"SEARCH\",\"SYNC\"],\"displayName\":\"Scripted SQL\",\"connRequestTimeout\":10,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.46', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.459778+01:00", "before": "{\"key\":\"a6d017fd-a705-4507-bb7c-6ab6a6745997\",\"errored\":false,\"adminRealm\":\"/even/two\",\"location\":\"connid://testconnectorserver@localhost:4554\",\"connectorName\":\"net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConnector\",\"bundleName\":\"net.tirasa.connid.bundles.db\",\"version\":\"2.3.0\",\"conf\":[{\"schema\":{\"name\":\"quoting\",\"displayName\":\"Name Quoting\",\"helpMessage\":\"<b>Name Quoting</b><br/>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-15,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"<b>Host</b><br/>Enter the name of the host where the database is running.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-14,\"confidential\":false,\"defaultValues\":[\"localhost\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"Port\",\"helpMessage\":\"<b>TCP Port</b><br/>Enter the port number the database server is listening on.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-13,\"confidential\":false,\"defaultValues\":[\"3306\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"user\",\"displayName\":\"User\",\"helpMessage\":\"<b>User</b><br/>Enter the name of the mandatory Database user with permission to account table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-12,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"password\",\"displayName\":\"User Password\",\"helpMessage\":\"<b>User Password</b><br/>Enter a user account that has permission to access accounts table.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":-11,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"database\",\"displayName\":\"Database\",\"helpMessage\":\"<b>Database</b><br/>Enter the name of the database on the database server that contains the table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-10,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jdbcDriver\",\"displayName\":\"JDBC Driver\",\"helpMessage\":\"<b>JDBC Driver</b><br/>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-9,\"confidential\":false,\"defaultValues\":[\"com.mysql.jdbc.Driver\"]},\"values\":[\"org.h2.Driver\"],\"overridable\":false},{\"schema\":{\"name\":\"jdbcUrlTemplate\",\"displayName\":\"JDBC Connection URL\",\"helpMessage\":\"<b>JDBC Connection URL</b><br/>Specify the JDBC Driver Connection URL.<br/> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br/>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-8,\"confidential\":false,\"defaultValues\":[\"jdbc:mysql://%h:%p/%d\"]},\"values\":[\"jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1\"],\"overridable\":false},{\"schema\":{\"name\":\"autoCommit\",\"displayName\":\"autoCommit\",\"helpMessage\":\"autoCommit\",\"type\":\"boolean\",\"required\":false,\"order\":-7,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"enableEmptyString\",\"displayName\":\"Enable writing empty string\",\"helpMessage\":\"<b>Enable writing empty string</b><br/>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.\",\"type\":\"boolean\",\"required\":false,\"order\":-6,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"rethrowAllSQLExceptions\",\"displayName\":\"Rethrow all SQLExceptions\",\"helpMessage\":\"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.\",\"type\":\"boolean\",\"required\":false,\"order\":-5,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"nativeTimestamps\",\"displayName\":\"Native Timestamps\",\"helpMessage\":\"<b>Native Timestamps</b><br/>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-4,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"allNative\",\"displayName\":\"All native\",\"helpMessage\":\"<b>All native</b><br/>Select to retrieve all data type of the columns in a native format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"validConnectionQuery\",\"displayName\":\"Validate Connection Query\",\"helpMessage\":\"<b>Validate Connection Query</b><br/>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"datasource\",\"displayName\":\"Datasource Path\",\"helpMessage\":\"<b>JDBC Data Source Name/Path</b><br/>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br/>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-1,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jndiProperties\",\"displayName\":\"Initial JNDI Properties\",\"helpMessage\":\"<b>Initial JNDI Properties</b><br/>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"scriptingLanguage\",\"displayName\":\"scriptingLanguage\",\"helpMessage\":\"scriptingLanguage\",\"type\":\"java.lang.String\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[\"GROOVY\"]},\"values\":[\"GROOVY\"],\"overridable\":false},{\"schema\":{\"name\":\"clearTextPasswordToScript\",\"displayName\":\"clearTextPasswordToScript\",\"helpMessage\":\"clearTextPasswordToScript\",\"type\":\"boolean\",\"required\":false,\"order\":1,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"reloadScriptOnExecution\",\"displayName\":\"reloadScriptOnExecution\",\"helpMessage\":\"reloadScriptOnExecution\",\"type\":\"boolean\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"createScript\",\"displayName\":\"createScript\",\"helpMessage\":\"createScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"updateScript\",\"displayName\":\"updateScript\",\"helpMessage\":\"updateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"deleteScript\",\"displayName\":\"deleteScript\",\"helpMessage\":\"deleteScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScript\",\"displayName\":\"resolveUsernameScript\",\"helpMessage\":\"resolveUsernameScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"authenticateScript\",\"displayName\":\"authenticateScript\",\"helpMessage\":\"authenticateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"searchScript\",\"displayName\":\"searchScript\",\"helpMessage\":\"searchScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScript\",\"displayName\":\"syncScript\",\"helpMessage\":\"syncScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"schemaScript\",\"displayName\":\"schemaScript\",\"helpMessage\":\"schemaScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"testScript\",\"displayName\":\"testScript\",\"helpMessage\":\"testScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"createScriptFileName\",\"displayName\":\"createScriptFileName\",\"helpMessage\":\"createScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/CreateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"updateScriptFileName\",\"displayName\":\"updateScriptFileName\",\"helpMessage\":\"updateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/UpdateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteScriptFileName\",\"displayName\":\"deleteScriptFileName\",\"helpMessage\":\"deleteScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/DeleteScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"searchScriptFileName\",\"displayName\":\"searchScriptFileName\",\"helpMessage\":\"searchScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SearchScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"authenticateScriptFileName\",\"displayName\":\"authenticateScriptFileName\",\"helpMessage\":\"authenticateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScriptFileName\",\"displayName\":\"resolveUsernameScriptFileName\",\"helpMessage\":\"resolveUsernameScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScriptFileName\",\"displayName\":\"syncScriptFileName\",\"helpMessage\":\"syncScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SyncScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"schemaScriptFileName\",\"displayName\":\"schemaScriptFileName\",\"helpMessage\":\"schemaScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SchemaScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"testScriptFileName\",\"displayName\":\"testScriptFileName\",\"helpMessage\":\"testScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/TestScript.groovy\"],\"overridable\":true}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"UPDATE_DELTA\",\"DELETE\",\"SEARCH\",\"SYNC\"],\"displayName\":\"Scripted SQL\",\"connRequestTimeout\":10,\"poolConf\":null}", "inputs": ["{\"key\":\"a6d017fd-a705-4507-bb7c-6ab6a6745997\",\"errored\":false,\"adminRealm\":\"/even/two\",\"location\":\"connid://testconnectorserver@localhost:4554\",\"connectorName\":\"net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConnector\",\"bundleName\":\"net.tirasa.connid.bundles.db\",\"version\":\"2.3.0\",\"conf\":[{\"schema\":{\"name\":\"quoting\",\"displayName\":\"Name Quoting\",\"helpMessage\":\"<b>Name Quoting</b><br/>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-15,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"<b>Host</b><br/>Enter the name of the host where the database is running.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-14,\"confidential\":false,\"defaultValues\":[\"localhost\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"Port\",\"helpMessage\":\"<b>TCP Port</b><br/>Enter the port number the database server is listening on.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-13,\"confidential\":false,\"defaultValues\":[\"3306\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"user\",\"displayName\":\"User\",\"helpMessage\":\"<b>User</b><br/>Enter the name of the mandatory Database user with permission to account table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-12,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"password\",\"displayName\":\"User Password\",\"helpMessage\":\"<b>User Password</b><br/>Enter a user account that has permission to access accounts table.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":-11,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"database\",\"displayName\":\"Database\",\"helpMessage\":\"<b>Database</b><br/>Enter the name of the database on the database server that contains the table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-10,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jdbcDriver\",\"displayName\":\"JDBC Driver\",\"helpMessage\":\"<b>JDBC Driver</b><br/>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-9,\"confidential\":false,\"defaultValues\":[\"com.mysql.jdbc.Driver\"]},\"values\":[\"org.h2.Driver\"],\"overridable\":false},{\"schema\":{\"name\":\"jdbcUrlTemplate\",\"displayName\":\"JDBC Connection URL\",\"helpMessage\":\"<b>JDBC Connection URL</b><br/>Specify the JDBC Driver Connection URL.<br/> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br/>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-8,\"confidential\":false,\"defaultValues\":[\"jdbc:mysql://%h:%p/%d\"]},\"values\":[\"jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1\"],\"overridable\":false},{\"schema\":{\"name\":\"autoCommit\",\"displayName\":\"autoCommit\",\"helpMessage\":\"autoCommit\",\"type\":\"boolean\",\"required\":false,\"order\":-7,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"enableEmptyString\",\"displayName\":\"Enable writing empty string\",\"helpMessage\":\"<b>Enable writing empty string</b><br/>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.\",\"type\":\"boolean\",\"required\":false,\"order\":-6,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"rethrowAllSQLExceptions\",\"displayName\":\"Rethrow all SQLExceptions\",\"helpMessage\":\"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.\",\"type\":\"boolean\",\"required\":false,\"order\":-5,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"nativeTimestamps\",\"displayName\":\"Native Timestamps\",\"helpMessage\":\"<b>Native Timestamps</b><br/>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-4,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"allNative\",\"displayName\":\"All native\",\"helpMessage\":\"<b>All native</b><br/>Select to retrieve all data type of the columns in a native format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"validConnectionQuery\",\"displayName\":\"Validate Connection Query\",\"helpMessage\":\"<b>Validate Connection Query</b><br/>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"datasource\",\"displayName\":\"Datasource Path\",\"helpMessage\":\"<b>JDBC Data Source Name/Path</b><br/>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br/>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-1,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jndiProperties\",\"displayName\":\"Initial JNDI Properties\",\"helpMessage\":\"<b>Initial JNDI Properties</b><br/>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"scriptingLanguage\",\"displayName\":\"scriptingLanguage\",\"helpMessage\":\"scriptingLanguage\",\"type\":\"java.lang.String\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[\"GROOVY\"]},\"values\":[\"GROOVY\"],\"overridable\":false},{\"schema\":{\"name\":\"clearTextPasswordToScript\",\"displayName\":\"clearTextPasswordToScript\",\"helpMessage\":\"clearTextPasswordToScript\",\"type\":\"boolean\",\"required\":false,\"order\":1,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"reloadScriptOnExecution\",\"displayName\":\"reloadScriptOnExecution\",\"helpMessage\":\"reloadScriptOnExecution\",\"type\":\"boolean\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"createScript\",\"displayName\":\"createScript\",\"helpMessage\":\"createScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"updateScript\",\"displayName\":\"updateScript\",\"helpMessage\":\"updateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"deleteScript\",\"displayName\":\"deleteScript\",\"helpMessage\":\"deleteScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScript\",\"displayName\":\"resolveUsernameScript\",\"helpMessage\":\"resolveUsernameScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"authenticateScript\",\"displayName\":\"authenticateScript\",\"helpMessage\":\"authenticateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"searchScript\",\"displayName\":\"searchScript\",\"helpMessage\":\"searchScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScript\",\"displayName\":\"syncScript\",\"helpMessage\":\"syncScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"schemaScript\",\"displayName\":\"schemaScript\",\"helpMessage\":\"schemaScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"testScript\",\"displayName\":\"testScript\",\"helpMessage\":\"testScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"createScriptFileName\",\"displayName\":\"createScriptFileName\",\"helpMessage\":\"createScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/CreateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"updateScriptFileName\",\"displayName\":\"updateScriptFileName\",\"helpMessage\":\"updateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/UpdateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteScriptFileName\",\"displayName\":\"deleteScriptFileName\",\"helpMessage\":\"deleteScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/DeleteScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"searchScriptFileName\",\"displayName\":\"searchScriptFileName\",\"helpMessage\":\"searchScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SearchScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"authenticateScriptFileName\",\"displayName\":\"authenticateScriptFileName\",\"helpMessage\":\"authenticateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScriptFileName\",\"displayName\":\"resolveUsernameScriptFileName\",\"helpMessage\":\"resolveUsernameScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScriptFileName\",\"displayName\":\"syncScriptFileName\",\"helpMessage\":\"syncScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SyncScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"schemaScriptFileName\",\"displayName\":\"schemaScriptFileName\",\"helpMessage\":\"schemaScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SchemaScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"testScriptFileName\",\"displayName\":\"testScriptFileName\",\"helpMessage\":\"testScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/TestScript.groovy\"],\"overridable\":true}],\"capabilities\":[\"DELETE\",\"CREATE\",\"SYNC\",\"UPDATE\",\"UPDATE_DELTA\",\"SEARCH\"],\"displayName\":\"Scripted SQL\",\"connRequestTimeout\":10,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"a6d017fd-a705-4507-bb7c-6ab6a6745997\",\"errored\":false,\"adminRealm\":\"/even/two\",\"location\":\"connid://testconnectorserver@localhost:4554\",\"connectorName\":\"net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConnector\",\"bundleName\":\"net.tirasa.connid.bundles.db\",\"version\":\"2.3.0\",\"conf\":[{\"schema\":{\"name\":\"quoting\",\"displayName\":\"Name Quoting\",\"helpMessage\":\"<b>Name Quoting</b><br/>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-15,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"host\",\"displayName\":\"Host\",\"helpMessage\":\"<b>Host</b><br/>Enter the name of the host where the database is running.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-14,\"confidential\":false,\"defaultValues\":[\"localhost\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"port\",\"displayName\":\"Port\",\"helpMessage\":\"<b>TCP Port</b><br/>Enter the port number the database server is listening on.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-13,\"confidential\":false,\"defaultValues\":[\"3306\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"user\",\"displayName\":\"User\",\"helpMessage\":\"<b>User</b><br/>Enter the name of the mandatory Database user with permission to account table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-12,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"password\",\"displayName\":\"User Password\",\"helpMessage\":\"<b>User Password</b><br/>Enter a user account that has permission to access accounts table.\",\"type\":\"org.identityconnectors.common.security.GuardedString\",\"required\":false,\"order\":-11,\"confidential\":true,\"defaultValues\":[]},\"values\":[\"sa\"],\"overridable\":false},{\"schema\":{\"name\":\"database\",\"displayName\":\"Database\",\"helpMessage\":\"<b>Database</b><br/>Enter the name of the database on the database server that contains the table.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-10,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jdbcDriver\",\"displayName\":\"JDBC Driver\",\"helpMessage\":\"<b>JDBC Driver</b><br/>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-9,\"confidential\":false,\"defaultValues\":[\"com.mysql.jdbc.Driver\"]},\"values\":[\"org.h2.Driver\"],\"overridable\":false},{\"schema\":{\"name\":\"jdbcUrlTemplate\",\"displayName\":\"JDBC Connection URL\",\"helpMessage\":\"<b>JDBC Connection URL</b><br/>Specify the JDBC Driver Connection URL.<br/> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br/>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br/>Could be empty if datasource is provided.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-8,\"confidential\":false,\"defaultValues\":[\"jdbc:mysql://%h:%p/%d\"]},\"values\":[\"jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1\"],\"overridable\":false},{\"schema\":{\"name\":\"autoCommit\",\"displayName\":\"autoCommit\",\"helpMessage\":\"autoCommit\",\"type\":\"boolean\",\"required\":false,\"order\":-7,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"enableEmptyString\",\"displayName\":\"Enable writing empty string\",\"helpMessage\":\"<b>Enable writing empty string</b><br/>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.\",\"type\":\"boolean\",\"required\":false,\"order\":-6,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"rethrowAllSQLExceptions\",\"displayName\":\"Rethrow all SQLExceptions\",\"helpMessage\":\"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.\",\"type\":\"boolean\",\"required\":false,\"order\":-5,\"confidential\":false,\"defaultValues\":[true]},\"values\":[true],\"overridable\":false},{\"schema\":{\"name\":\"nativeTimestamps\",\"displayName\":\"Native Timestamps\",\"helpMessage\":\"<b>Native Timestamps</b><br/>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-4,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"allNative\",\"displayName\":\"All native\",\"helpMessage\":\"<b>All native</b><br/>Select to retrieve all data type of the columns in a native format from the database table.\",\"type\":\"boolean\",\"required\":false,\"order\":-3,\"confidential\":false,\"defaultValues\":[false]},\"values\":[false],\"overridable\":false},{\"schema\":{\"name\":\"validConnectionQuery\",\"displayName\":\"Validate Connection Query\",\"helpMessage\":\"<b>Validate Connection Query</b><br/>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-2,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"datasource\",\"displayName\":\"Datasource Path\",\"helpMessage\":\"<b>JDBC Data Source Name/Path</b><br/>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br/>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>\",\"type\":\"java.lang.String\",\"required\":false,\"order\":-1,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"jndiProperties\",\"displayName\":\"Initial JNDI Properties\",\"helpMessage\":\"<b>Initial JNDI Properties</b><br/>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.\",\"type\":\"[Ljava.lang.String;\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"scriptingLanguage\",\"displayName\":\"scriptingLanguage\",\"helpMessage\":\"scriptingLanguage\",\"type\":\"java.lang.String\",\"required\":false,\"order\":0,\"confidential\":false,\"defaultValues\":[\"GROOVY\"]},\"values\":[\"GROOVY\"],\"overridable\":false},{\"schema\":{\"name\":\"clearTextPasswordToScript\",\"displayName\":\"clearTextPasswordToScript\",\"helpMessage\":\"clearTextPasswordToScript\",\"type\":\"boolean\",\"required\":false,\"order\":1,\"confidential\":false,\"defaultValues\":[true]},\"values\":[\"false\"],\"overridable\":false},{\"schema\":{\"name\":\"reloadScriptOnExecution\",\"displayName\":\"reloadScriptOnExecution\",\"helpMessage\":\"reloadScriptOnExecution\",\"type\":\"boolean\",\"required\":false,\"order\":2,\"confidential\":false,\"defaultValues\":[false]},\"values\":[\"true\"],\"overridable\":false},{\"schema\":{\"name\":\"createScript\",\"displayName\":\"createScript\",\"helpMessage\":\"createScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"updateScript\",\"displayName\":\"updateScript\",\"helpMessage\":\"updateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"deleteScript\",\"displayName\":\"deleteScript\",\"helpMessage\":\"deleteScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScript\",\"displayName\":\"resolveUsernameScript\",\"helpMessage\":\"resolveUsernameScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"authenticateScript\",\"displayName\":\"authenticateScript\",\"helpMessage\":\"authenticateScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"searchScript\",\"displayName\":\"searchScript\",\"helpMessage\":\"searchScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":6,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScript\",\"displayName\":\"syncScript\",\"helpMessage\":\"syncScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":7,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"schemaScript\",\"displayName\":\"schemaScript\",\"helpMessage\":\"schemaScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":8,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"testScript\",\"displayName\":\"testScript\",\"helpMessage\":\"testScript\",\"type\":\"java.lang.String\",\"required\":false,\"order\":9,\"confidential\":false,\"defaultValues\":[\"\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"createScriptFileName\",\"displayName\":\"createScriptFileName\",\"helpMessage\":\"createScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":10,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/CreateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"updateScriptFileName\",\"displayName\":\"updateScriptFileName\",\"helpMessage\":\"updateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":11,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/UpdateScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"deleteScriptFileName\",\"displayName\":\"deleteScriptFileName\",\"helpMessage\":\"deleteScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":12,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/DeleteScript.groovy\"],\"overridable\":false},{\"schema\":{\"name\":\"searchScriptFileName\",\"displayName\":\"searchScriptFileName\",\"helpMessage\":\"searchScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":13,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SearchScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"authenticateScriptFileName\",\"displayName\":\"authenticateScriptFileName\",\"helpMessage\":\"authenticateScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":14,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"resolveUsernameScriptFileName\",\"displayName\":\"resolveUsernameScriptFileName\",\"helpMessage\":\"resolveUsernameScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":15,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"syncScriptFileName\",\"displayName\":\"syncScriptFileName\",\"helpMessage\":\"syncScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":16,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SyncScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"schemaScriptFileName\",\"displayName\":\"schemaScriptFileName\",\"helpMessage\":\"schemaScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":17,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/SchemaScript.groovy\"],\"overridable\":true},{\"schema\":{\"name\":\"testScriptFileName\",\"displayName\":\"testScriptFileName\",\"helpMessage\":\"testScriptFileName\",\"type\":\"java.lang.String\",\"required\":false,\"order\":18,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/test-classes/scriptedsql/TestScript.groovy\"],\"overridable\":true}],\"capabilities\":[\"CREATE\",\"UPDATE\",\"UPDATE_DELTA\",\"DELETE\",\"SEARCH\",\"SYNC\"],\"displayName\":\"Scripted SQL\",\"connRequestTimeout\":10,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.677', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.677783+01:00", "before": "null", "inputs": ["{\"key\":null,\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"newDisplayName7453d614\",\"connRequestTimeout\":20,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"0194459d-65b1-79c9-a49e-e6792df512cf\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"newDisplayName7453d614\",\"connRequestTimeout\":20,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.705', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.70504+01:00", "before": "null", "inputs": ["{\"key\":\"newAbout103335eff39\",\"connector\":\"0194459d-65b1-79c9-a49e-e6792df512cf\",\"connectorDisplayName\":\"ConnInstance103\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"fullname\",\"extAttrName\":\"fullname\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":null,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":\"986d1236-3ac5-4a19-810c-5ab21d79cba1\",\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"newAbout103335eff39\",\"connector\":\"0194459d-65b1-79c9-a49e-e6792df512cf\",\"connectorDisplayName\":\"newDisplayName7453d614\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"fullname\",\"extAttrName\":\"fullname\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":null,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":\"986d1236-3ac5-4a19-810c-5ab21d79cba1\",\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:10.753', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:10.753579+01:00", "before": "{\"key\":\"0194459d-65b1-79c9-a49e-e6792df512cf\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[],\"displayName\":\"newDisplayName7453d614\",\"connRequestTimeout\":20,\"poolConf\":null}", "inputs": ["{\"key\":\"0194459d-65b1-79c9-a49e-e6792df512cf\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"AUTHENTICATE\"],\"displayName\":\"newDisplayName7453d614\",\"connRequestTimeout\":20,\"poolConf\":null}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ConnectorLogic", "subcategory": null}, "output": "{\"key\":\"0194459d-65b1-79c9-a49e-e6792df512cf\",\"errored\":false,\"adminRealm\":\"/\",\"location\":\"file:/home/ilgrosso/work/syncope/syncope/fit/core-reference/target/bundles/\",\"connectorName\":\"net.tirasa.connid.bundles.soap.WebServiceConnector\",\"bundleName\":\"net.tirasa.connid.bundles.soap\",\"version\":\"1.4.5\",\"conf\":[{\"schema\":{\"name\":\"endpoint\",\"displayName\":\"Service Endpoint\",\"helpMessage\":\"Service Endpoint\",\"type\":\"java.lang.String\",\"required\":true,\"order\":1,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"http://localhost:8888/syncope-fit-build-tools/cxf/soap\"],\"overridable\":false},{\"schema\":{\"name\":\"servicename\",\"displayName\":\"Service name\",\"helpMessage\":\"Service name\",\"type\":\"java.lang.String\",\"required\":true,\"order\":2,\"confidential\":false,\"defaultValues\":[]},\"values\":[\"Provisioning\"],\"overridable\":false},{\"schema\":{\"name\":\"connectionTimeout\",\"displayName\":\"Connection timeout (seconds)\",\"helpMessage\":\"Connection timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":3,\"confidential\":false,\"defaultValues\":[\"30\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"receiveTimeout\",\"displayName\":\"Receive timeout (seconds)\",\"helpMessage\":\"Receive timeout\",\"type\":\"java.lang.String\",\"required\":false,\"order\":4,\"confidential\":false,\"defaultValues\":[\"60\"]},\"values\":[],\"overridable\":false},{\"schema\":{\"name\":\"soapActionUriPrefix\",\"displayName\":\"SOAPAction URI Prefix\",\"helpMessage\":\"SOAPAction URI Prefix\",\"type\":\"java.lang.String\",\"required\":false,\"order\":5,\"confidential\":false,\"defaultValues\":[]},\"values\":[],\"overridable\":false}],\"capabilities\":[\"AUTHENTICATE\"],\"displayName\":\"newDisplayName7453d614\",\"connRequestTimeout\":20,\"poolConf\":null}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.394', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.394211+01:00", "before": "null", "inputs": ["{\"key\":\"new-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"displayProperty\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"key\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + displayProperty + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":0,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"new-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[]},\"virSchemas\":[]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"displayProperty\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"key\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PROPAGATION\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + displayProperty + '',ou=groups,o=isp''\",\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":0,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.754', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.754155+01:00", "before": "{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}", "inputs": ["{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[\"SEARCH\"],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[\"SEARCH\"],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.81', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.809798+01:00", "before": "{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[\"SEARCH\"],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}", "inputs": ["{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":true,\"capabilitiesOverride\":[\"SEARCH\"],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":true,\"capabilitiesOverride\":[\"SEARCH\"],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.877', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.877759+01:00", "before": "{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":true,\"capabilitiesOverride\":[\"SEARCH\"],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}", "inputs": ["{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"resource-ldap\",\"connector\":\"74141a3b-0762-4720-a4aa-fc3e374ef3ef\",\"connectorDisplayName\":\"TestLDAP\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[\"generic membership\",\"minimal group\"],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"username\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"sn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"fullname\",\"extAttrName\":\"cn\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"title\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"postalAddress\",\"extAttrName\":\"postalAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userId\",\"extAttrName\":\"mail\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"obscure\",\"extAttrName\":\"registeredAddress\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"photo\",\"extAttrName\":\"jpegPhoto\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''uid='' + username + '',ou=people,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"virtualReadOnly\",\"extAttrName\":\"givenname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"PULL\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"virtualReadOnly\"]},{\"anyType\":\"GROUP\",\"objectClass\":\"__GROUP__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"name\",\"extAttrName\":\"cn\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"userOwner\",\"extAttrName\":\"owner\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"title\",\"extAttrName\":\"description\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":\"''cn='' + name + '',ou=groups,o=isp''\",\"linkingItems\":[{\"intAttrName\":\"rvirtualdata\",\"extAttrName\":\"businessCategory\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"false\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}]},\"virSchemas\":[\"rvirtualdata\"]}],\"orgUnit\":null,\"propagationPriority\":1,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[\"GenerateRandomPasswordPropagationActions\",\"LDAPMembershipPropagationActions\"]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:18.764', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:18.763919+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"deprovision68391c91\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-8534-7d83-a974-42176d3d6ab5\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"deprovision68391c91\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.744146+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.744185+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==deprovision68391c91\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=deprovision68391c91,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"deprovision68391c91\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"deprovision68391c91\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:23.969', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:23.968945+01:00", "before": "{\"key\":\"rest-target-resource\",\"connector\":\"44c02549-19c3-483c-8025-4919c3283c37\",\"connectorDisplayName\":\"REST\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"firstname\",\"extAttrName\":\"firstName\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"key\",\"extAttrName\":\"key\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"username\",\"extAttrName\":\"username\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"surname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":0,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":null,\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}", "inputs": ["{\"key\":\"rest-target-resource\",\"connector\":\"44c02549-19c3-483c-8025-4919c3283c37\",\"connectorDisplayName\":\"REST\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"firstname\",\"extAttrName\":\"firstName\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"key\",\"extAttrName\":\"key\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"username\",\"extAttrName\":\"username\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"surname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":0,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":\"0194459d-9965-7e1c-aa84-b7a8fdd5a340\",\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "ResourceLogic", "subcategory": null}, "output": "{\"key\":\"rest-target-resource\",\"connector\":\"44c02549-19c3-483c-8025-4919c3283c37\",\"connectorDisplayName\":\"REST\",\"provisions\":[{\"anyType\":\"USER\",\"objectClass\":\"__ACCOUNT__\",\"auxClasses\":[],\"syncToken\":null,\"ignoreCaseMatch\":false,\"uidOnCreate\":null,\"mapping\":{\"items\":[{\"intAttrName\":\"firstname\",\"extAttrName\":\"firstName\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"key\",\"extAttrName\":\"key\",\"connObjectKey\":true,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"password\",\"extAttrName\":\"__PASSWORD__\",\"connObjectKey\":false,\"password\":true,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"username\",\"extAttrName\":\"username\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"email\",\"extAttrName\":\"email\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]},{\"intAttrName\":\"surname\",\"extAttrName\":\"surname\",\"connObjectKey\":false,\"password\":false,\"mandatoryCondition\":\"true\",\"purpose\":\"BOTH\",\"propagationJEXLTransformer\":null,\"pullJEXLTransformer\":null,\"transformers\":[]}],\"connObjectLink\":null,\"linkingItems\":[]},\"virSchemas\":[]}],\"orgUnit\":null,\"propagationPriority\":0,\"enforceMandatoryCondition\":true,\"createTraceLevel\":\"ALL\",\"updateTraceLevel\":\"ALL\",\"deleteTraceLevel\":\"ALL\",\"provisioningTraceLevel\":\"ALL\",\"passwordPolicy\":null,\"accountPolicy\":null,\"propagationPolicy\":null,\"pullPolicy\":\"0194459d-9965-7e1c-aa84-b7a8fdd5a340\",\"pushPolicy\":null,\"provisionSorter\":null,\"authPolicy\":null,\"accessPolicy\":null,\"confOverride\":[],\"overrideCapabilities\":false,\"capabilitiesOverride\":[],\"propagationActions\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:30.073', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:30.07337+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"aprinter112\",\"realm\":\"/odd/macro\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"location\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-b156-7061-b8b2-dfc77d00e17b\",\"type\":\"PRINTER\",\"realm\":\"/odd/macro\",\"name\":\"aprinter112\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:30.048308+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:30.049097+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"location\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:31.801', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:31.799328+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-b7c1-7c56-8871-e0691b732fc4\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"7d74db8fmemb@apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:31.691749+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:31.702008+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"aLong\",\"values\":[\"1976\"]},{\"schema\":\"email\",\"values\":[\"7d74db8fmemb@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"7d74db8fmemb@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"7d74db8fmemb@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"7d74db8fmemb@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 7d74db8fmemb@apache.org\"]},{\"schema\":\"info\",\"values\":[\"7d74db8fmemb@apache.org - 2025-01-08T12:12:31+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:31.68215+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"034740a9-fa10-453b-af37-dc7897e98fb1\",\"groupName\":\"additional\",\"plainAttrs\":[{\"schema\":\"aLong\",\"values\":[\"1977\"]}],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]},{\"schema\":\"noschema\",\"values\":[\", \"]}],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-b7c1-7c56-8871-e0691b732fc4\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"aLong\",\"values\":[\"1977\"]}}],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[{\"operation\":\"ADD_REPLACE\",\"group\":\"034740a9-fa10-453b-af37-dc7897e98fb1\",\"plainAttrs\":[{\"schema\":\"aLong\",\"values\":[\"1976\"]},{\"schema\":\"ctype\",\"values\":[\"membership type\"]}],\"virAttrs\":[]}],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-b7c1-7c56-8871-e0691b732fc4\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"7d74db8fmemb@apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:31.691749+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:31.776036+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"aLong\",\"values\":[\"1977\"]},{\"schema\":\"email\",\"values\":[\"7d74db8fmemb@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"7d74db8fmemb@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"7d74db8fmemb@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"7d74db8fmemb@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 7d74db8fmemb@apache.org\"]},{\"schema\":\"info\",\"values\":[\"7d74db8fmemb@apache.org - 2025-01-08T12:12:31+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:31.68215+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"034740a9-fa10-453b-af37-dc7897e98fb1\",\"groupName\":\"additional\",\"plainAttrs\":[{\"schema\":\"aLong\",\"values\":[\"1976\"]},{\"schema\":\"ctype\",\"values\":[\"membership type\"]}],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]},{\"schema\":\"noschema\",\"values\":[\", \"]}],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:34.573', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:34.572574+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"df9e84a1typeExt@apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"fullname\",\"values\":[\"df9e84a1typeExt@apache.org\"]},{\"schema\":\"userId\",\"values\":[\"df9e84a1typeExt@apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"firstname\",\"values\":[\"df9e84a1typeExt@apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"email\",\"values\":[\"df9e84a1typeExt@apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-c2d5-7c7b-9cfe-1dc73020ce72\",\"groupName\":null,\"plainAttrs\":[{\"schema\":\"aLong\",\"values\":[\"1454\"]}],\"derAttrs\":[],\"virAttrs\":[]}],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-c2ed-7f44-b9d1-9f95e6a1defa\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"df9e84a1typeExt@apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:34.547376+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:34.561104+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"df9e84a1typeExt@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"df9e84a1typeExt@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"df9e84a1typeExt@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"df9e84a1typeExt@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, df9e84a1typeExt@apache.org\"]},{\"schema\":\"info\",\"values\":[\"df9e84a1typeExt@apache.org - 2025-01-08T12:12:34+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:34.541375+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-c2d5-7c7b-9cfe-1dc73020ce72\",\"groupName\":\"typeExt9d47519a\",\"plainAttrs\":[{\"schema\":\"aLong\",\"values\":[\"1454\"]}],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]},{\"schema\":\"noschema\",\"values\":[\", \"]}],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.118', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:13.118289+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"puccini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:10.348806+01:00\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"Giacomo\"]},{\"schema\":\"fullname\",\"values\":[\"Giacomo Puccini\"]},{\"schema\":\"surname\",\"values\":[\"Puccini\"]},{\"schema\":\"userId\",\"values\":[\"puccini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Puccini, Giacomo\"]},{\"schema\":\"info\",\"values\":[\"puccini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Puccini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:10.342741+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"groupName\":\"artDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Search for realm evenTwo\",\"Connector and Resource for realm evenTwo\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"cool\",\"values\":[\"true\"]}}],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"puccini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.108335+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"realm1\",\"realm2\"],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"cool\",\"values\":[\"true\"]},{\"schema\":\"firstname\",\"values\":[\"Giacomo\"]},{\"schema\":\"fullname\",\"values\":[\"Giacomo Puccini\"]},{\"schema\":\"surname\",\"values\":[\"Puccini\"]},{\"schema\":\"userId\",\"values\":[\"puccini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Puccini, Giacomo\"]},{\"schema\":\"info\",\"values\":[\"puccini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Puccini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:10.342741+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"groupName\":\"artDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Search for realm evenTwo\",\"Connector and Resource for realm evenTwo\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.208', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:13.208029+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"puccini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.108335+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"cool\",\"values\":[\"true\"]},{\"schema\":\"firstname\",\"values\":[\"Giacomo\"]},{\"schema\":\"fullname\",\"values\":[\"Giacomo Puccini\"]},{\"schema\":\"surname\",\"values\":[\"Puccini\"]},{\"schema\":\"userId\",\"values\":[\"puccini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Puccini, Giacomo\"]},{\"schema\":\"info\",\"values\":[\"puccini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Puccini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:10.342741+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"groupName\":\"artDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Search for realm evenTwo\",\"Connector and Resource for realm evenTwo\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"DELETE\",\"attr\":{\"schema\":\"cool\",\"values\":[]}}],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"puccini\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.196507+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"Giacomo\"]},{\"schema\":\"fullname\",\"values\":[\"Giacomo Puccini\"]},{\"schema\":\"surname\",\"values\":[\"Puccini\"]},{\"schema\":\"userId\",\"values\":[\"puccini@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Puccini, Giacomo\"]},{\"schema\":\"info\",\"values\":[\"puccini - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Puccini, \"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb2\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":\"2025-01-08T12:12:10.342741+01:00\",\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"groupName\":\"artDirector\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[\"Search for realm evenTwo\",\"Connector and Resource for realm evenTwo\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.331', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:13.330391+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"92fef1f5dynRealmAdmin@apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]},{\"schema\":\"email\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"fullname\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"userId\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[\"Administer LDAP468f3b87\"],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-6ff9-7d35-bd66-653a166439ab\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"92fef1f5dynRealmAdmin@apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.310461+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.319391+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 92fef1f5dynRealmAdmin@apache.org\"]},{\"schema\":\"info\",\"values\":[\"92fef1f5dynRealmAdmin@apache.org - 2025-01-08T12:12:13+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:13.306049+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[\"Administer LDAP468f3b87\"],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.395', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:13.395244+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"d9dc3188dynRealmUser@apache.org\",\"realm\":\"/even/two\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-701a-73e9-9111-89d52e8cafce\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"d9dc3188dynRealmUser@apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.345587+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.35491+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"LDAPLovers4683c434\"],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"info\",\"values\":[\"d9dc3188dynRealmUser@apache.org - 2025-01-08T12:12:13+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:13.33889+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==d9dc3188dynRealmUser@apache.org\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=d9dc3188dynRealmUser@apache.org,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"cn\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"surname\"]},{\"schema\":\"title\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.442', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:13.441935+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"dynRealmGroupf213eb9c\",\"realm\":\"/odd\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-705c-7571-a82d-cd73af19d6f3\",\"type\":\"GROUP\",\"realm\":\"/odd\",\"name\":\"dynRealmGroupf213eb9c\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.407378+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.407421+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"LDAPLovers4683c434\"],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==dynRealmGroupf213eb9c\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=dynRealmGroupf213eb9c,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"dynRealmGroupf213eb9c\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"dynRealmGroupf213eb9c\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.692', 'DEBUG', 'syncope.audit.Master', '{"who": "92fef1f5dynRealmAdmin@apache.org", "date": "2025-01-08T12:12:13.692242+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-701a-73e9-9111-89d52e8cafce\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"d9dc3188dynRealmUser@apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.345587+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.35491+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"LDAPLovers4683c434\"],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"info\",\"values\":[\"d9dc3188dynRealmUser@apache.org - 2025-01-08T12:12:13+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:13.33889+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"0194459d-701a-73e9-9111-89d52e8cafce\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"ws-target-resource-nopropagation\"}],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-701a-73e9-9111-89d52e8cafce\",\"type\":\"USER\",\"realm\":\"/even/two\",\"username\":\"d9dc3188dynRealmUser@apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.345587+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"92fef1f5dynRealmAdmin@apache.org\",\"lastChangeDate\":\"2025-01-08T12:12:13.675931+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"LDAPLovers4683c434\"],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"d9dc3188dynRealmUser@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, d9dc3188dynRealmUser@apache.org\"]},{\"schema\":\"info\",\"values\":[\"d9dc3188dynRealmUser@apache.org - 2025-01-08T12:12:13+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[{\"schema\":\"virtualReadOnly\",\"values\":[]}],\"resources\":[\"resource-ldap\",\"ws-target-resource-nopropagation\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:13.33889+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":null,\"resource\":\"ws-target-resource-nopropagation\",\"status\":\"NOT_ATTEMPTED\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.736', 'DEBUG', 'syncope.audit.Master', '{"who": "92fef1f5dynRealmAdmin@apache.org", "date": "2025-01-08T12:12:13.733318+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-705c-7571-a82d-cd73af19d6f3\",\"type\":\"GROUP\",\"realm\":\"/odd\",\"name\":\"dynRealmGroupf213eb9c\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.407378+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.407421+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"LDAPLovers4683c434\"],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-705c-7571-a82d-cd73af19d6f3\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"icon\",\"values\":[\"modified\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-705c-7571-a82d-cd73af19d6f3\",\"type\":\"GROUP\",\"realm\":\"/odd\",\"name\":\"dynRealmGroupf213eb9c\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.407378+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"92fef1f5dynRealmAdmin@apache.org\",\"lastChangeDate\":\"2025-01-08T12:12:13.727669+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[\"LDAPLovers4683c434\"],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"modified\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"modified: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:13.952', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:13.952473+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"child10bb34e98\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7275-798a-9619-32618d3dee16\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"child10bb34e98\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:13.943568+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:13.943611+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.03', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.029845+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"a8286013issue654_1@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[\"uniqueAttribute453a07e2\"],\"plainAttrs\":[{\"schema\":\"fullname\",\"values\":[\"a8286013issue654_1@syncope.apache.org\"]},{\"schema\":\"unique1edde565\",\"values\":[\"unique1edde565\"]},{\"schema\":\"userId\",\"values\":[\"a8286013issue654_1@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"a8286013issue654_1@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-72b7-7a32-a41b-755dbf098a83\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"a8286013issue654_1@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.015683+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.022734+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[\"uniqueAttribute453a07e2\"],\"plainAttrs\":[{\"schema\":\"fullname\",\"values\":[\"a8286013issue654_1@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"a8286013issue654_1@syncope.apache.org\"]},{\"schema\":\"unique1edde565\",\"values\":[\"unique1edde565\"]},{\"schema\":\"userId\",\"values\":[\"a8286013issue654_1@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"a8286013issue654_1@syncope.apache.org, \"]},{\"schema\":\"info\",\"values\":[\"a8286013issue654_1@syncope.apache.org - 2025-01-08T12:12:14+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"a8286013issue654_1@syncope.apache.org, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:14.008296+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.359', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.359359+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"lastGroupb5d35943\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"show\",\"values\":[\"true\"]},{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7409-70e8-b36e-7a5e5a30605c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupb5d35943\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.349742+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.349817+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"show\",\"values\":[\"true\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon_true\"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.464', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.463616+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7409-70e8-b36e-7a5e5a30605c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupb5d35943\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.349742+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.349817+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"show\",\"values\":[\"true\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon_true\"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7409-70e8-b36e-7a5e5a30605c\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"new-ldap\"}],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7409-70e8-b36e-7a5e5a30605c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupb5d35943\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.349742+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.430706+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"show\",\"values\":[\"true\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon_true\"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[\"new-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==anIcon_true\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=anIcon_true,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"anIcon_true\"]},{\"schema\":\"cn\",\"values\":[\"anIcon_true\"]},{\"schema\":\"description\",\"values\":[\"0194459d-7409-70e8-b36e-7a5e5a30605c\"]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"new-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.52', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.520638+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7409-70e8-b36e-7a5e5a30605c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupb5d35943\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.349742+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.430706+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"show\",\"values\":[\"true\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon_true\"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[\"new-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7409-70e8-b36e-7a5e5a30605c\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"icon\",\"values\":[\"anotherIcon\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7409-70e8-b36e-7a5e5a30605c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupb5d35943\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.349742+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.487444+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anotherIcon\"]},{\"schema\":\"show\",\"values\":[\"true\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anotherIcon_true\"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[\"new-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==anotherIcon_true\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=anIcon_true,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"anIcon_true\"]},{\"schema\":\"cn\",\"values\":[\"anIcon_true\"]},{\"schema\":\"description\",\"values\":[\"0194459d-7409-70e8-b36e-7a5e5a30605c\"]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==anotherIcon_true\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=anotherIcon_true,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"anotherIcon_true\"]},{\"schema\":\"cn\",\"values\":[\"anotherIcon_true\"]},{\"schema\":\"description\",\"values\":[\"0194459d-7409-70e8-b36e-7a5e5a30605c\"]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"new-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:28.795', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:28.794656+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"linkedAccount14074@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"fullname\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"email\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"userId\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"firstname\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[{\"key\":null,\"connObjectKeyValue\":\"uid=linkedAccount14074@syncope.apache.org,ou=People,o=isp\",\"resource\":\"resource-ldap\",\"username\":\"LinkedUsername\",\"password\":null,\"suspended\":false,\"plainAttrs\":[{\"schema\":\"surname\",\"values\":[\"LINKED_SURNAME\"]}],\"privileges\":[\"postMighty\"]}]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-ac4c-73f2-8188-9b7bfb247f50\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"linkedAccount14074@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:28.752195+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:28.763921+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"linkedAccount14074@syncope.apache.org - 2025-01-08T12:12:28+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:28.748287+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[{\"key\":\"0194459d-ac4c-73f2-8188-9b7bfb247f51\",\"connObjectKeyValue\":\"uid=linkedAccount14074@syncope.apache.org,ou=People,o=isp\",\"resource\":\"resource-ldap\",\"username\":\"LinkedUsername\",\"password\":null,\"suspended\":false,\"plainAttrs\":[{\"schema\":\"surname\",\"values\":[\"LINKED_SURNAME\"]}],\"privileges\":[\"postMighty\"]}],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==uid=linkedAccount14074@syncope.apache.org,ou=People,o=isp\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"uid=linkedAccount14074@syncope.apache.org,ou=people,o=isp\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"\"]},{\"schema\":\"__UID__\",\"values\":[\"uid=linkedAccount14074@syncope.apache.org,ou=People,o=isp\"]},{\"schema\":\"cn\",\"values\":[\"uid=linkedAccount14074@syncope.apache.org,ou=People,o=isp\"]},{\"schema\":\"givenname\",\"values\":[]},{\"schema\":\"jpegPhoto\",\"values\":[]},{\"schema\":\"mail\",\"values\":[\"linkedAccount14074@syncope.apache.org\"]},{\"schema\":\"postalAddress\",\"values\":[]},{\"schema\":\"registeredAddress\",\"values\":[]},{\"schema\":\"sn\",\"values\":[\"LINKED_SURNAME\"]},{\"schema\":\"title\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.717', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.717538+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"syncope71761441f94\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"doublea53c92d8\",\"values\":[\"11.23\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7570-7148-96fc-cbd0093a4ee9\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope71761441f94\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.708228+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.708409+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"doublea53c92d8\",\"values\":[\"11.23\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.762', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.762598+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7570-7148-96fc-cbd0093a4ee9\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope71761441f94\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.708228+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.708409+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"doublea53c92d8\",\"values\":[\"11.230\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7570-7148-96fc-cbd0093a4ee9\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"doublea53c92d8\",\"values\":[\"11.257\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7570-7148-96fc-cbd0093a4ee9\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope71761441f94\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.708228+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.755904+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"doublea53c92d8\",\"values\":[\"11.257\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.791', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.791119+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7570-7148-96fc-cbd0093a4ee9\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope71761441f94\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.708228+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.755904+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"doublea53c92d8\",\"values\":[\"11.257\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7570-7148-96fc-cbd0093a4ee9\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"doublea53c92d8\",\"values\":[\"11.23\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7570-7148-96fc-cbd0093a4ee9\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope71761441f94\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.708228+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.786505+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"doublea53c92d8\",\"values\":[\"11.23\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.88', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.880481+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"aDynamicMembership872952ce\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{\"PRINTER\":\"location==home;$type==PRINTER\"},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-75fe-7537-a27e-a02c5e0a9e18\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"aDynamicMembership872952ce\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.851962+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.85202+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{\"PRINTER\":\"location==home;$type==PRINTER\"},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.91', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.910173+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"Printer_da42785a\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"home\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-7627-786e-a316-a548a8d2ac9f\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Printer_da42785a\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.888657+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.8887+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"home\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[{\"groupKey\":\"0194459d-75fe-7537-a27e-a02c5e0a9e18\",\"groupName\":\"aDynamicMembership872952ce\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.942', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.942062+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-7627-786e-a316-a548a8d2ac9f\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Printer_da42785a\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.888657+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.8887+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"home\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[{\"groupKey\":\"0194459d-75fe-7537-a27e-a02c5e0a9e18\",\"groupName\":\"aDynamicMembership872952ce\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}]}", "inputs": ["\"0194459d-7627-786e-a316-a548a8d2ac9f\"", "false"], "logger": {"type": "LOGIC", "event": "delete", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-7627-786e-a316-a548a8d2ac9f\",\"type\":null,\"realm\":null,\"name\":null,\"creator\":null,\"creationDate\":null,\"creationContext\":null,\"lastModifier\":null,\"lastChangeDate\":null,\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:14.981', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:14.981452+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"deprovision62fd2074\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-767b-7b6b-90af-0222dcda2c69\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"deprovision62fd2074\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.975034+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.975075+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.076', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.076175+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-767b-7b6b-90af-0222dcda2c69\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"deprovision62fd2074\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.975034+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.975075+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["\"0194459d-767b-7b6b-90af-0222dcda2c69\"", "[\"resource-ldap\"]", "false"], "logger": {"type": "LOGIC", "event": "deprovision", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-767b-7b6b-90af-0222dcda2c69\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"deprovision62fd2074\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:14.975034+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:14.975075+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==deprovision62fd2074\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=deprovision62fd2074,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"deprovision62fd2074\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"deprovision62fd2074\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":null,\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.138', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.137887+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"assigne2ab0509\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7716-743e-b78b-6430a62003ce\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"assigne2ab0509\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.130521+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.130574+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.201', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.201328+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7716-743e-b78b-6430a62003ce\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"assigne2ab0509\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.130521+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.130574+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["\"0194459d-7716-743e-b78b-6430a62003ce\"", "[\"resource-ldap\"]", "false", "null", "false"], "logger": {"type": "LOGIC", "event": "assign", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7716-743e-b78b-6430a62003ce\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"assigne2ab0509\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.130521+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.175717+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==assigne2ab0509\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=assigne2ab0509,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"assigne2ab0509\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"assigne2ab0509\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.304', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.304425+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"lastGroupd32f35f7\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[\"rvirtualvalue\"]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":\"f779c0d4-633b-4be5-8f57-32eb478a3ca5\",\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-77a6-7356-891d-388a1e8168ba\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupd32f35f7\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.274041+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.274075+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[\"rvirtualvalue\"]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":\"f779c0d4-633b-4be5-8f57-32eb478a3ca5\",\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==lastGroupd32f35f7\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=lastGroupd32f35f7,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"lastGroupd32f35f7\"]},{\"schema\":\"businessCategory\",\"values\":[\"rvirtualvalue\"]},{\"schema\":\"cn\",\"values\":[\"lastGroupd32f35f7\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[\"cn=otherchild,ou=groups,o=isp\"]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.349', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.349017+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-77a6-7356-891d-388a1e8168ba\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupd32f35f7\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.274041+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.274075+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[\"rvirtualvalue\"]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":\"f779c0d4-633b-4be5-8f57-32eb478a3ca5\",\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-77a6-7356-891d-388a1e8168ba\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":{\"operation\":\"ADD_REPLACE\",\"value\":null},\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-77a6-7356-891d-388a1e8168ba\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupd32f35f7\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.274041+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.332114+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[\"rvirtualvalue\"]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==lastGroupd32f35f7\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=lastGroupd32f35f7,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"lastGroupd32f35f7\"]},{\"schema\":\"businessCategory\",\"values\":[\"rvirtualvalue\"]},{\"schema\":\"cn\",\"values\":[\"lastGroupd32f35f7\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[\"cn=otherchild,ou=groups,o=isp\"]}]},\"afterObj\":{\"fiql\":\"__UID__==lastGroupd32f35f7\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=lastGroupd32f35f7,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"lastGroupd32f35f7\"]},{\"schema\":\"businessCategory\",\"values\":[\"rvirtualvalue\"]},{\"schema\":\"cn\",\"values\":[\"lastGroupd32f35f7\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.386', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.386037+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"toBeDeleted09146bec\",\"realm\":\"/even\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7801-78e4-9abd-9907248a147c\",\"type\":\"GROUP\",\"realm\":\"/even\",\"name\":\"toBeDeleted09146bec\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.364478+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.364519+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==toBeDeleted09146bec\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=toBeDeleted09146bec,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"toBeDeleted09146bec\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"toBeDeleted09146bec\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.46', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.460499+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"räksmörgås49428572\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-784f-76b5-8782-aecc5895645e\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"räksmörgås49428572\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.44259+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.442631+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==räksmörgås49428572\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=räksmörgås49428572,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"räksmörgås49428572\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"räksmörgås49428572\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.487', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.487611+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"aDynMembership23ab09ab\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{\"PRINTER\":\"location!=$null;$type==PRINTER\"},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"aDynMembership23ab09ab\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.470399+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.47044+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":13,\"adynMembershipConds\":{\"PRINTER\":\"location!=$null;$type==PRINTER\"},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.518', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.518524+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"aDynMembership694e7a16\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"aDynMembershipd20ffc1a\"]}],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-7889-7a58-85f0-20372a39981e\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"aDynMembership694e7a16\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.498598+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.498642+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"aDynMembershipd20ffc1a\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[{\"groupKey\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"groupName\":\"aDynMembership23ab09ab\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.573', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.57368+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"aDynMembership23ab09ab\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.470399+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.47044+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":14,\"adynMembershipConds\":{\"PRINTER\":\"location!=$null;$type==PRINTER\"},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{\"PRINTER\":\"location==$null;$type==PRINTER\"},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"aDynMembership23ab09ab\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.470399+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.569554+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":2,\"adynMembershipConds\":{\"PRINTER\":\"location==$null;$type==PRINTER\"},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.603', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.603686+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-7889-7a58-85f0-20372a39981e\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"aDynMembership694e7a16\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.498598+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.498642+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"location\",\"values\":[\"aDynMembershipd20ffc1a\"]}],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectUR\",\"key\":\"0194459d-7889-7a58-85f0-20372a39981e\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"DELETE\",\"attr\":{\"schema\":\"location\",\"values\":[]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"relationships\":[],\"memberships\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-7889-7a58-85f0-20372a39981e\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"aDynMembership694e7a16\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.498598+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.597373+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[{\"groupKey\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"groupName\":\"aDynMembership23ab09ab\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.668', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.668542+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"lastGroupa562f065\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7917-7be8-9e2b-dc56faec6d4c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupa562f065\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.644579+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.644619+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==lastGroupa562f065\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=lastGroupa562f065,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"lastGroupa562f065\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"lastGroupa562f065\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.732', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.732367+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7917-7be8-9e2b-dc56faec6d4c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupa562f065\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.644579+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.644619+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7917-7be8-9e2b-dc56faec6d4c\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"badge8906740f\",\"values\":[\"xxxxxxxxxx\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7917-7be8-9e2b-dc56faec6d4c\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"lastGroupa562f065\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.644579+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.728887+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"badge8906740f\",\"values\":[\"xxxxxxxxxx\"]},{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.768', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.767884+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"aStaticMembershipc5d151b6\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-798d-7336-8a12-2f158a08da7d\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"aStaticMembershipc5d151b6\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.761451+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.76149+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.807', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.807048+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.AnyObjectCR\",\"name\":\"Printer_f1d19040\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"type\":\"PRINTER\",\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-798d-7336-8a12-2f158a08da7d\",\"groupName\":null,\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-79a0-72bd-80f4-2651e1cc9c70\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Printer_f1d19040\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.778629+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.778693+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-798d-7336-8a12-2f158a08da7d\",\"groupName\":\"aStaticMembershipc5d151b6\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[{\"groupKey\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"groupName\":\"aDynMembership23ab09ab\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.835', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.834817+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-79a0-72bd-80f4-2651e1cc9c70\",\"type\":\"PRINTER\",\"realm\":\"/\",\"name\":\"Printer_f1d19040\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.778629+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.778693+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-798d-7336-8a12-2f158a08da7d\",\"groupName\":\"aStaticMembershipc5d151b6\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[{\"groupKey\":\"0194459d-786b-7f8a-aad7-f05eb16eb585\",\"groupName\":\"aDynMembership23ab09ab\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}]}", "inputs": ["\"0194459d-79a0-72bd-80f4-2651e1cc9c70\"", "false"], "logger": {"type": "LOGIC", "event": "delete", "result": "SUCCESS", "category": "AnyObjectLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.AnyObjectTO\",\"key\":\"0194459d-79a0-72bd-80f4-2651e1cc9c70\",\"type\":null,\"realm\":null,\"name\":null,\"creator\":null,\"creationDate\":null,\"creationContext\":null,\"lastModifier\":null,\"lastChangeDate\":null,\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[],\"resources\":[],\"relationships\":[],\"memberships\":[],\"dynMemberships\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.885', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.885647+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"unlink5fd94976\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-79f4-74cd-8951-adc7683e9229\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"unlink5fd94976\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.864478+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.864515+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==unlink5fd94976\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=unlink5fd94976,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"unlink5fd94976\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"unlink5fd94976\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.95', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.950696+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"latestGroupdc4cd885fec333f2\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a3b-7d21-acbf-d84815a0e64d\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"latestGroupdc4cd885fec333f2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.934377+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.934419+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==latestGroupdc4cd885fec333f2\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=latestGroupdc4cd885fec333f2,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"latestGroupdc4cd885fec333f2\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"latestGroupdc4cd885fec333f2\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:15.984', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:15.984401+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a3b-7d21-acbf-d84815a0e64d\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"latestGroupdc4cd885fec333f2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.934377+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.934419+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7a3b-7d21-acbf-d84815a0e64d\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"show\",\"values\":[\"FALSE\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":{\"operation\":\"ADD_REPLACE\",\"value\":\"finalGroup093df416\"},\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a3b-7d21-acbf-d84815a0e64d\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"finalGroup093df416\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.934377+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.966516+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"show\",\"values\":[\"false\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: false\"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==finalGroup093df416\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=latestGroupdc4cd885fec333f2,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"latestGroupdc4cd885fec333f2\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"latestGroupdc4cd885fec333f2\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==finalGroup093df416\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=finalGroup093df416,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"finalGroup093df416\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"finalGroup093df416\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.009', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.008961+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a3b-7d21-acbf-d84815a0e64d\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"finalGroup093df416\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.934377+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:15.966516+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"show\",\"values\":[\"false\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: false\"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7a3b-7d21-acbf-d84815a0e64d\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"DELETE\",\"attr\":{\"schema\":\"show\",\"values\":[]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a3b-7d21-acbf-d84815a0e64d\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"finalGroup093df416\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:15.934377+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.005235+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.034', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.03472+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"issueSYNCOPE1467\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a8f-7716-9061-6b9068e3ec26\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"issueSYNCOPE1467\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.018796+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.018835+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==issueSYNCOPE1467\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=issueSYNCOPE1467,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"issueSYNCOPE1467\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"issueSYNCOPE1467\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.078', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.078467+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a8f-7716-9061-6b9068e3ec26\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"issueSYNCOPE1467\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.018796+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.018835+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7a8f-7716-9061-6b9068e3ec26\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":{\"operation\":\"ADD_REPLACE\",\"value\":\"fixedSYNCOPE1467\"},\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7a8f-7716-9061-6b9068e3ec26\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"fixedSYNCOPE1467\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.018796+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.061351+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==fixedSYNCOPE1467\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=issueSYNCOPE1467,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"issueSYNCOPE1467\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"issueSYNCOPE1467\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==fixedSYNCOPE1467\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=fixedSYNCOPE1467,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"fixedSYNCOPE1467\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"fixedSYNCOPE1467\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.142', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.142189+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"artDirector\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"realm\":null,\"auxClasses\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"csv\"}],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"resource-testdb\"}],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"artDirector\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.13943+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.159', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.159472+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"artDirector\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.13943+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"realm\":null,\"auxClasses\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"csv\"}],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"resource-testdb\"}],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"artDirector\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.15681+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.175', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.175686+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"artDirector\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.15681+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[\"csv\"],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"csvuserid\",\"values\":[\",\"]},{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[\"resource-testdb\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"realm\":null,\"auxClasses\":[{\"operation\":\"DELETE\",\"value\":\"csv\"}],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"DELETE\",\"value\":\"resource-testdb\"}],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ece66293-8f31-4a84-8e8d-23da36e70846\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"artDirector\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.173013+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.205', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.205594+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"provision337017f2\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7b3f-78b1-b2bd-ca1bae6843ea\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"provision337017f2\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.196715+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.196778+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.292', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.292709+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"unassignd1e424a6\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7b92-7a7c-a85e-f63059a4b0fd\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"unassignd1e424a6\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.277076+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.277114+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==unassignd1e424a6\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=unassignd1e424a6,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"unassignd1e424a6\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"unassignd1e424a6\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.338', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.337724+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7b92-7a7c-a85e-f63059a4b0fd\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"unassignd1e424a6\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.277076+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.277114+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["\"0194459d-7b92-7a7c-a85e-f63059a4b0fd\"", "[\"resource-ldap\"]", "false"], "logger": {"type": "LOGIC", "event": "unassign", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7b92-7a7c-a85e-f63059a4b0fd\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"unassignd1e424a6\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.277076+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.317851+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==unassignd1e424a6\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=unassignd1e424a6,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"unassignd1e424a6\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"unassignd1e424a6\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":null,\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.381', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.381773+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"link13198d76\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7bf7-70f5-85ee-06e72ac49d2d\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"link13198d76\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.377712+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.37775+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.605', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.604917+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"patch890b94cc\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"(($groups==ebf97068-aa4b-4a85-9f01-680e8c4cf227;$resources!=ws-target-resource-1);aLong==1)\",\"adynMembershipConds\":{\"PRINTER\":\"(($groups==ece66293-8f31-4a84-8e8d-23da36e70846;cool==ss);$resources==ws-target-resource-2);$type==PRINTER\"},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7caf-7d4f-acfe-69deec4506c7\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"patch890b94cc\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.564592+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.564675+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"(($groups==ebf97068-aa4b-4a85-9f01-680e8c4cf227;$resources!=ws-target-resource-1);aLong==1)\",\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{\"PRINTER\":\"(($groups==ece66293-8f31-4a84-8e8d-23da36e70846;cool==ss);$resources==ws-target-resource-2);$type==PRINTER\"},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.671', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.67172+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7caf-7d4f-acfe-69deec4506c7\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"patch890b94cc\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.564592+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.564675+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"(($groups==ebf97068-aa4b-4a85-9f01-680e8c4cf227;$resources!=ws-target-resource-1);aLong==1)\",\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{\"PRINTER\":\"(($groups==ece66293-8f31-4a84-8e8d-23da36e70846;cool==ss);$resources==ws-target-resource-2);$type==PRINTER\"},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7caf-7d4f-acfe-69deec4506c7\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"rderived_sx\",\"values\":[\"sx\"]}},{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"title\",\"values\":[\"mr\"]}},{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"rderived_dx\",\"values\":[\"dx\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"(($groups==ebf97068-aa4b-4a85-9f01-680e8c4cf227;$resources!=ws-target-resource-1);aLong==1)\",\"adynMembershipConds\":{\"PRINTER\":\"(($groups==ece66293-8f31-4a84-8e8d-23da36e70846;cool==ss);$resources==ws-target-resource-2);$type==PRINTER\"},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7caf-7d4f-acfe-69deec4506c7\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"patch890b94cc\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.564592+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.665128+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"rderived_dx\",\"values\":[\"dx\"]},{\"schema\":\"rderived_sx\",\"values\":[\"sx\"]},{\"schema\":\"title\",\"values\":[\"mr\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"sx-dx\"]},{\"schema\":\"rderiveddata\",\"values\":[\"sx-dx\"]},{\"schema\":\"rderivedschema\",\"values\":[\"sx-dx\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"(($groups==ebf97068-aa4b-4a85-9f01-680e8c4cf227;$resources!=ws-target-resource-1);aLong==1)\",\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{\"PRINTER\":\"(($groups==ece66293-8f31-4a84-8e8d-23da36e70846;cool==ss);$resources==ws-target-resource-2);$type==PRINTER\"},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.707', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.707519+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"syncope7145ffa12a1\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"title\",\"values\":[\"first\"]},{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope7145ffa12a1\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.689564+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.689598+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"title\",\"values\":[\"first\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==syncope7145ffa12a1\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=syncope7145ffa12a1,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"description\",\"values\":[\"first\"]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.74', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.740128+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope7145ffa12a1\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.689564+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.689598+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"title\",\"values\":[\"first\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"title\",\"values\":[\"second\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope7145ffa12a1\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.689564+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.722708+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"title\",\"values\":[\"second\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==syncope7145ffa12a1\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=syncope7145ffa12a1,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"description\",\"values\":[\"first\"]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==syncope7145ffa12a1\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=syncope7145ffa12a1,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"description\",\"values\":[\"second\"]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.796', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.796062+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope7145ffa12a1\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.689564+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.722708+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"title\",\"values\":[\"second\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"title\",\"values\":[\"third\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope7145ffa12a1\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.689564+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.777156+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"title\",\"values\":[\"third\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==syncope7145ffa12a1\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=syncope7145ffa12a1,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"description\",\"values\":[\"second\"]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==syncope7145ffa12a1\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=syncope7145ffa12a1,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"description\",\"values\":[\"third\"]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.862', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.862161+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope7145ffa12a1\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.689564+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.777156+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"title\",\"values\":[\"third\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"title\",\"values\":[\"fourth\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7d2f-7582-876b-e0f49a121d37\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"syncope7145ffa12a1\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.689564+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.835845+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]},{\"schema\":\"title\",\"values\":[\"fourth\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==syncope7145ffa12a1\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=syncope7145ffa12a1,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"description\",\"values\":[\"third\"]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":{\"fiql\":\"__UID__==syncope7145ffa12a1\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=syncope7145ffa12a1,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"syncope7145ffa12a1\"]},{\"schema\":\"description\",\"values\":[\"third\"]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"NOT_ATTEMPTED\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.891', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.891651+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"torenamef9dda066\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7df4-789f-80fa-c274555de1af\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"torenamef9dda066\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.886987+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.887228+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.909', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.909212+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7df4-789f-80fa-c274555de1af\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"torenamef9dda066\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.886987+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.887228+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7df4-789f-80fa-c274555de1af\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":{\"operation\":\"ADD_REPLACE\",\"value\":\"renamed1d2d783a\"},\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7df4-789f-80fa-c274555de1af\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"renamed1d2d783a\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.886987+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.905168+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.93', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.929869+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"typeExtensions575b88fd\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[{\"anyType\":\"USER\",\"auxClasses\":[\"csv\"]}]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7e16-746c-81bb-5a9dc2a46f54\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"typeExtensions575b88fd\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.922179+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.922238+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[{\"anyType\":\"USER\",\"auxClasses\":[\"csv\"]}]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:16.952', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:16.952035+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7e16-746c-81bb-5a9dc2a46f54\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"typeExtensions575b88fd\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.922179+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.922238+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[{\"anyType\":\"USER\",\"auxClasses\":[\"csv\"]}]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7e16-746c-81bb-5a9dc2a46f54\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[{\"anyType\":\"USER\",\"auxClasses\":[\"csv\",\"other\"]}]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7e16-746c-81bb-5a9dc2a46f54\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"typeExtensions575b88fd\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:16.922179+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:16.947805+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[{\"anyType\":\"USER\",\"auxClasses\":[\"csv\",\"other\"]}]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:17.024', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:17.024147+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"unlimited53a541d4\",\"realm\":\"/even/two\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7e7a-759f-9bfd-56175628a6c6\",\"type\":\"GROUP\",\"realm\":\"/even/two\",\"name\":\"unlimited53a541d4\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.020946+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.020983+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:17.055', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:17.055285+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"f1b15698unlimited@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"email\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"userId\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-7e7a-759f-9bfd-56175628a6c6\",\"groupName\":null,\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-7e86-79f3-a7fe-073f30f4fa20\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"f1b15698unlimited@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.033952+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.045951+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"f1b15698unlimited@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, f1b15698unlimited@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"f1b15698unlimited@syncope.apache.org - 2025-01-08T12:12:17+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:17.030562+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-7e7a-759f-9bfd-56175628a6c6\",\"groupName\":\"unlimited53a541d4\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:17.155', 'DEBUG', 'syncope.audit.Master', '{"who": "puccini", "date": "2025-01-08T12:12:17.155779+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ebf97068-aa4b-4a85-9f01-680e8c4cf227\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"director\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2010-10-20T10:00:00Z\",\"lastChangeContext\":null,\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"icon6\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"icon6: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"ebf97068-aa4b-4a85-9f01-680e8c4cf227\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":{\"operation\":\"ADD_REPLACE\",\"value\":\"Director\"},\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"ebf97068-aa4b-4a85-9f01-680e8c4cf227\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"Director\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"puccini\",\"lastChangeDate\":\"2025-01-08T12:12:17.150169+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"icon6\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"icon6: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":\"823074dc-d280-436d-a7dd-07399fae48ec\",\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:17.17', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:17.170005+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"forProvisionc11053a9\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"forProvisionc11053a9\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.166271+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.166313+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:17.207', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:17.206823+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"810c9976forProvision@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"fullname\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"userId\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"email\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"groupName\":null,\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-7f18-7f96-990f-c3e0f9e184c5\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"810c9976forProvision@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.182014+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.19244+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"810c9976forProvision@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, 810c9976forProvision@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"810c9976forProvision@syncope.apache.org - 2025-01-08T12:12:17+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:17.176516+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[{\"groupKey\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"groupName\":\"forProvisionc11053a9\",\"plainAttrs\":[],\"derAttrs\":[],\"virAttrs\":[]}],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:17.247', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:17.246699+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"forProvisionc11053a9\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.166271+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.166313+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[{\"operation\":\"ADD_REPLACE\",\"value\":\"resource-ldap\"}],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-7f0c-7027-8030-3780651d3519\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"forProvisionc11053a9\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:17.166271+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:17.22658+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":1,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==forProvisionc11053a9\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=forProvisionc11053a9,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"forProvisionc11053a9\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"forProvisionc11053a9\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:18.52', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:18.520621+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"uDynMembershipc9701843\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"cool==true\",\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-8443-732f-ba32-36dca8a3064a\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"uDynMembershipc9701843\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.501913+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.501965+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"cool==true\",\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":1,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:18.584', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:18.584292+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-8443-732f-ba32-36dca8a3064a\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"uDynMembershipc9701843\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.501913+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.501965+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"cool==true\",\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":1,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-8443-732f-ba32-36dca8a3064a\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"cool==false\",\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-8443-732f-ba32-36dca8a3064a\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"uDynMembershipc9701843\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.501913+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.579122+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\": \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[],\"resources\":[],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":\"cool==false\",\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:18.675', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:18.675744+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupCR\",\"name\":\"encryptedb2a20e54\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"encrypted77580af4\",\"values\":[\"testvalue\"]},{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"virAttrs\":[],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-84df-70c4-94af-32fbf08eb9e1\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"encryptedb2a20e54\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.659042+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.65908+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"encrypted77580af4\",\"values\":[\"548032E3E11AEF8D64B743608E7A9FE930050B7BC8D32B1CFFFF949A0075D7D7ABC6E9E4DBDBB48F7A546628A74857E53F6C3E890EB95BDEC328917CDD18CBDB\"]},{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":null,\"afterObj\":{\"fiql\":\"__UID__==encryptedb2a20e54\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=encryptedb2a20e54,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"encryptedb2a20e54\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"encryptedb2a20e54\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:18.718', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:18.718562+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-84df-70c4-94af-32fbf08eb9e1\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"encryptedb2a20e54\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.659042+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.65908+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"encrypted77580af4\",\"values\":[\"548032E3E11AEF8D64B743608E7A9FE930050B7BC8D32B1CFFFF949A0075D7D7ABC6E9E4DBDBB48F7A546628A74857E53F6C3E890EB95BDEC328917CDD18CBDB\"]},{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.GroupUR\",\"key\":\"0194459d-84df-70c4-94af-32fbf08eb9e1\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[{\"operation\":\"ADD_REPLACE\",\"attr\":{\"schema\":\"encrypted77580af4\",\"values\":[\"testvalue\"]}}],\"virAttrs\":[],\"resources\":[],\"name\":null,\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-84df-70c4-94af-32fbf08eb9e1\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"encryptedb2a20e54\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.659042+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.711985+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"encrypted77580af4\",\"values\":[\"testvalue\"]},{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:18.797', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:18.797852+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-8534-7d83-a974-42176d3d6ab5\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"deprovision68391c91\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.744146+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.744185+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]}", "inputs": ["\"0194459d-8534-7d83-a974-42176d3d6ab5\"", "[\"resource-ldap\"]", "false"], "logger": {"type": "LOGIC", "event": "deprovision", "result": "SUCCESS", "category": "GroupLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.GroupTO\",\"key\":\"0194459d-8534-7d83-a974-42176d3d6ab5\",\"type\":\"GROUP\",\"realm\":\"/\",\"name\":\"deprovision68391c91\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:18.744146+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:18.744185+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":null,\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"icon\",\"values\":[\"anIcon\"]}],\"derAttrs\":[{\"schema\":\"displayProperty\",\"values\":[\"anIcon: \"]},{\"schema\":\"rderToBePropagated\",\"values\":[\"-\"]},{\"schema\":\"rderiveddata\",\"values\":[\"-\"]},{\"schema\":\"rderivedschema\",\"values\":[\"-\"]}],\"virAttrs\":[{\"schema\":\"rvirtualdata\",\"values\":[]}],\"resources\":[\"resource-ldap\"],\"userOwner\":null,\"groupOwner\":null,\"udynMembershipCond\":null,\"staticUserMembershipCount\":0,\"dynamicUserMembershipCount\":0,\"staticAnyObjectMembershipCount\":0,\"dynamicAnyObjectMembershipCount\":0,\"adynMembershipConds\":{},\"typeExtensions\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==deprovision68391c91\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"true\"]},{\"schema\":\"__NAME__\",\"values\":[\"cn=deprovision68391c91,ou=groups,o=isp\"]},{\"schema\":\"__UID__\",\"values\":[\"deprovision68391c91\"]},{\"schema\":\"businessCategory\",\"values\":[]},{\"schema\":\"cn\",\"values\":[\"deprovision68391c91\"]},{\"schema\":\"description\",\"values\":[]},{\"schema\":\"owner\",\"values\":[]}]},\"afterObj\":null,\"resource\":\"resource-ldap\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:19.331', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:19.331349+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"cc85d5d3syncope164@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]}],\"virAttrs\":[],\"resources\":[],\"password\":\"<MASKED>\",\"storePassword\":true,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[]}", "false"], "logger": {"type": "LOGIC", "event": "create", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"0194459d-876d-7270-8f00-ba2614e6c5a9\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"cc85d5d3syncope164@syncope.apache.org\",\"creator\":\"admin\",\"creationDate\":\"2025-01-08T12:12:19.313923+01:00\",\"creationContext\":\"REST\",\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:19.321993+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"created\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"email\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"firstname\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"fullname\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"loginDate\",\"values\":[\"2025-01-08\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"userId\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"surname, cc85d5d3syncope164@syncope.apache.org\"]},{\"schema\":\"info\",\"values\":[\"cc85d5d3syncope164@syncope.apache.org - 2025-01-08T12:12:19+01:00[0]\"]},{\"schema\":\"noschema\",\"values\":[\"surname, \"]}],\"virAttrs\":[],\"resources\":[],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":\"2025-01-08T12:12:19.30981+01:00\",\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:26.908', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:26.905514+01:00", "before": "{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"vivaldi\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:25.4393+01:00\",\"lastChangeContext\":\"PullTask 0194459d-99b1-7c4d-b4e7-bb9e8d71ed76 ''Linked Account Pull Task''\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"F\"]},{\"schema\":\"email\",\"values\":[\"vivaldi@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"Antonio\"]},{\"schema\":\"fullname\",\"values\":[\"Antonio Vivaldi\"]},{\"schema\":\"surname\",\"values\":[\"Vivaldi\"]},{\"schema\":\"userId\",\"values\":[\"vivaldi@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Vivaldi, Antonio\"]},{\"schema\":\"info\",\"values\":[\"vivaldi - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Vivaldi, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-1\",\"ws-target-resource-2\",\"ws-target-resource-delete\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[{\"key\":\"0194459d-9c9f-755c-96de-e1c7c188aa53\",\"connObjectKeyValue\":\"7f2c70e1-01d5-4baf-a4b4-583aa5804508\",\"resource\":\"rest-target-resource\",\"username\":\"linkedaccount2\",\"password\":null,\"suspended\":false,\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"Giovannino\"]}],\"privileges\":[]},{\"key\":\"0194459d-9d0b-791a-8cfb-dba3f78e2edb\",\"connObjectKeyValue\":\"198b4802-f5f0-4121-80ee-af952feb2274\",\"resource\":\"rest-target-resource\",\"username\":\"not.vivaldi\",\"password\":null,\"suspended\":true,\"plainAttrs\":[{\"schema\":\"email\",\"values\":[\"not.vivaldi@syncope.org\"]}],\"privileges\":[]}],\"delegatingDelegations\":[],\"delegatedDelegations\":[]}", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserUR\",\"key\":\"b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee\",\"realm\":null,\"auxClasses\":[],\"plainAttrs\":[],\"virAttrs\":[],\"resources\":[],\"username\":null,\"password\":null,\"securityQuestion\":null,\"securityAnswer\":null,\"mustChangePassword\":null,\"relationships\":[],\"memberships\":[],\"roles\":[],\"linkedAccounts\":[{\"operation\":\"DELETE\",\"linkedAccountTO\":{\"key\":null,\"connObjectKeyValue\":\"7f2c70e1-01d5-4baf-a4b4-583aa5804508\",\"resource\":\"rest-target-resource\",\"username\":null,\"password\":null,\"suspended\":false,\"plainAttrs\":[],\"privileges\":[]}},{\"operation\":\"DELETE\",\"linkedAccountTO\":{\"key\":null,\"connObjectKeyValue\":\"198b4802-f5f0-4121-80ee-af952feb2274\",\"resource\":\"rest-target-resource\",\"username\":null,\"password\":null,\"suspended\":false,\"plainAttrs\":[],\"privileges\":[]}}]}", "false"], "logger": {"type": "LOGIC", "event": "update", "result": "SUCCESS", "category": "UserLogic", "subcategory": null}, "output": "{\"entity\":{\"_class\":\"org.apache.syncope.common.lib.to.UserTO\",\"key\":\"b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee\",\"type\":\"USER\",\"realm\":\"/\",\"username\":\"vivaldi\",\"creator\":\"admin\",\"creationDate\":\"2010-10-20T10:00:00Z\",\"creationContext\":null,\"lastModifier\":\"admin\",\"lastChangeDate\":\"2025-01-08T12:12:26.252954+01:00\",\"lastChangeContext\":\"REST\",\"dynRealms\":[],\"status\":\"active\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"ctype\",\"values\":[\"F\"]},{\"schema\":\"email\",\"values\":[\"vivaldi@syncope.org\"]},{\"schema\":\"firstname\",\"values\":[\"Antonio\"]},{\"schema\":\"fullname\",\"values\":[\"Antonio Vivaldi\"]},{\"schema\":\"surname\",\"values\":[\"Vivaldi\"]},{\"schema\":\"userId\",\"values\":[\"vivaldi@apache.org\"]}],\"derAttrs\":[{\"schema\":\"cn\",\"values\":[\"Vivaldi, Antonio\"]},{\"schema\":\"info\",\"values\":[\"vivaldi - 2010-10-20T10:00:00Z[0]\"]},{\"schema\":\"noschema\",\"values\":[\"Vivaldi, \"]}],\"virAttrs\":[],\"resources\":[\"ws-target-resource-1\",\"ws-target-resource-2\",\"ws-target-resource-delete\"],\"password\":null,\"token\":null,\"tokenExpireTime\":null,\"lastLoginDate\":null,\"changePwdDate\":null,\"failedLogins\":0,\"securityQuestion\":null,\"securityAnswer\":null,\"suspended\":false,\"mustChangePassword\":false,\"relationships\":[],\"memberships\":[],\"dynMemberships\":[],\"roles\":[],\"dynRoles\":[],\"privileges\":[],\"linkedAccounts\":[],\"delegatingDelegations\":[],\"delegatedDelegations\":[]},\"propagationStatuses\":[{\"beforeObj\":{\"fiql\":\"__UID__==198b4802-f5f0-4121-80ee-af952feb2274\",\"attrs\":[{\"schema\":\"__ENABLE__\",\"values\":[\"false\"]},{\"schema\":\"__NAME__\",\"values\":[\"198b4802-f5f0-4121-80ee-af952feb2274\"]},{\"schema\":\"__PASSWORD__\",\"values\":[\"Password123\"]},{\"schema\":\"__UID__\",\"values\":[\"198b4802-f5f0-4121-80ee-af952feb2274\"]},{\"schema\":\"email\",\"values\":[\"not.vivaldi@syncope.org\"]},{\"schema\":\"firstName\",\"values\":[]},{\"schema\":\"key\",\"values\":[\"198b4802-f5f0-4121-80ee-af952feb2274\"]},{\"schema\":\"surname\",\"values\":[]},{\"schema\":\"username\",\"values\":[\"not.vivaldi\"]}]},\"afterObj\":null,\"resource\":\"rest-target-resource\",\"status\":\"SUCCESS\",\"failureReason\":null}]}", "throwable": null}', '');
INSERT INTO auditentry VALUES ('2025-01-08 12:12:27.219', 'DEBUG', 'syncope.audit.Master', '{"who": "admin", "date": "2025-01-08T12:12:27.219001+01:00", "before": "null", "inputs": ["{\"_class\":\"org.apache.syncope.common.lib.request.UserCR\",\"username\":\"linkedAccount59765@syncope.apache.org\",\"realm\":\"/\",\"auxClasses\":[],\"plainAttrs\":[{\"schema\":\"firstname\",\"values\":[\"linkedAccount59765@syncope.apache.org\"]},{\"schema\":\"ctype\",\"values\":[\"a type\"]},{\"schema\":\"surname\",\"values\":[\"surname\"]},{\"schema\":\"fullname\",\"values\