/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.fedplanner;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.utils.Statistics;

public class FederatedCompilationTimer {
    private static final List<TimeEntry> times = new ArrayList<TimeEntry>();
    private static TimeEntry privProcessTime;
    private static TimeEntry enumerationTime;
    private static TimeEntry selectPlanTime;
    private static boolean activated;

    public static TimeEntry startPrivProcessTimer() {
        privProcessTime = new TimeEntry("PrivProcess");
        times.add(privProcessTime);
        return privProcessTime;
    }

    public static TimeEntry stopPrivProcessTimer() {
        privProcessTime.stopTime();
        return privProcessTime;
    }

    public static TimeEntry startPrivFetchTimer(long hopID) {
        TimeEntry privFetchTimer = new TimeEntry("PrivFetch" + hopID);
        times.add(privFetchTimer);
        return privFetchTimer;
    }

    public static void startEnumerationTimer() {
        enumerationTime = new TimeEntry("Enumeration");
        times.add(enumerationTime);
    }

    public static void stopEnumerationTimer() {
        enumerationTime.stopTime();
    }

    public static void startSelectPlanTimer() {
        selectPlanTime = new TimeEntry("Selection");
        times.add(selectPlanTime);
    }

    public static void stopSelectPlanTimer() {
        selectPlanTime.stopTime();
    }

    private static long getTotalFetchTime() {
        return times.stream().filter(t -> t.is("PrivFetch")).map(TimeEntry::getDuration).reduce(0L, Long::sum);
    }

    private static long getBasicCompileTime() {
        return Statistics.getCompileTime() - privProcessTime.getDuration() - enumerationTime.getDuration() - selectPlanTime.getDuration();
    }

    private static String nanoToSeconds(long nanoSeconds) {
        return String.format("%.3f", (double)nanoSeconds * 1.0E-9) + " sec.";
    }

    public static String getStringRepresentation() {
        if (activated && FederatedCompilationTimer.timesNotNull()) {
            long totalFetchTime = FederatedCompilationTimer.getTotalFetchTime();
            long privPropagationTime = privProcessTime.getDuration() - totalFetchTime;
            long basicCompileTime = FederatedCompilationTimer.getBasicCompileTime();
            StringBuilder sb = new StringBuilder();
            sb.append("Basic Compilation Time:\t\t").append(FederatedCompilationTimer.nanoToSeconds(basicCompileTime)).append("\n");
            sb.append("Total Privacy Fetch Time:\t").append(FederatedCompilationTimer.nanoToSeconds(totalFetchTime)).append("\n");
            sb.append("Privacy Propagation Time:\t").append(FederatedCompilationTimer.nanoToSeconds(privPropagationTime)).append("\n");
            sb.append("Plan Enumeration Time:\t\t").append(FederatedCompilationTimer.nanoToSeconds(enumerationTime.getDuration())).append("\n");
            sb.append("Plan Selection Time:\t\t").append(FederatedCompilationTimer.nanoToSeconds(selectPlanTime.getDuration())).append("\n");
            return sb.toString();
        }
        return "";
    }

    private static boolean timesNotNull() {
        return privProcessTime != null && enumerationTime != null && selectPlanTime != null;
    }

    public static void activate() {
        activated = true;
    }

    public static void display() {
        System.out.println(FederatedCompilationTimer.getStringRepresentation());
    }

    static {
        activated = false;
    }

    public static class TimeEntry {
        private final long startTime;
        private long stopTime;
        private long duration;
        private String name;

        public TimeEntry(String name) {
            this.name = name;
            this.startTime = System.nanoTime();
        }

        public void stopTime() {
            this.stopTime = System.nanoTime();
            this.duration = this.stopTime - this.startTime;
        }

        public boolean is(String searchName) {
            return this.name.contains(searchName);
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

