/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.fedplanner;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.fedplanner.FederatedMemoTable;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;

public class FederatedMemoTablePrinter {
    public static void printFedPlanTree(FederatedMemoTable.FedPlan rootFedPlan, FederatedMemoTable memoTable, double additionalTotalCost) {
        System.out.println("Additional Cost: " + additionalTotalCost);
        HashSet<FederatedMemoTable.FedPlan> visited = new HashSet<FederatedMemoTable.FedPlan>();
        FederatedMemoTablePrinter.printFedPlanTreeRecursive(rootFedPlan, memoTable, visited, 0);
    }

    private static void printFedPlanTreeRecursive(FederatedMemoTable.FedPlan plan, FederatedMemoTable memoTable, Set<FederatedMemoTable.FedPlan> visited, int depth) {
        if (plan == null || visited.contains(plan)) {
            return;
        }
        visited.add(plan);
        Hop hop = plan.getHopRef();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("(%d) ", plan.getHopRef().getHopID())).append(plan.getHopRef().getOpString()).append(" [").append((Object)plan.getFedOutType()).append("]");
        StringBuilder childs = new StringBuilder();
        childs.append(" (");
        boolean childAdded = false;
        for (Hop input : hop.getInput()) {
            childs.append(childAdded ? "," : "");
            childs.append(input.getHopID());
            childAdded = true;
        }
        childs.append(")");
        if (childAdded) {
            sb.append(childs.toString());
        }
        sb.append(String.format(" {Total: %.1f, Self: %.1f, Net: %.1f}", plan.getTotalCost(), plan.getSelfCost(), plan.getNetTransferCost()));
        sb.append(" [").append(hop.getDim1()).append(", ").append(hop.getDim2()).append(", ").append(hop.getBlocksize()).append(", ").append(hop.getNnz());
        if (hop.getUpdateType().isInPlace()) {
            sb.append(", ").append(hop.getUpdateType().toString().toLowerCase());
        }
        sb.append("]");
        sb.append(" [").append(OptimizerUtils.toMB(hop.getInputMemEstimate())).append(", ").append(OptimizerUtils.toMB(hop.getIntermediateMemEstimate())).append(", ").append(OptimizerUtils.toMB(hop.getOutputMemEstimate())).append(" -> ").append(OptimizerUtils.toMB(hop.getMemEstimate())).append("MB]");
        if (hop.requiresReblock() && hop.requiresCheckpoint()) {
            sb.append(" [rblk, chkpt]");
        } else if (hop.requiresReblock()) {
            sb.append(" [rblk]");
        } else if (hop.requiresCheckpoint()) {
            sb.append(" [chkpt]");
        }
        if (hop.getExecType() != null) {
            sb.append(", ").append((Object)hop.getExecType());
        }
        System.out.println(sb);
        List<Pair<Long, FEDInstruction.FederatedOutput>> childFedPlanPairs = plan.getChildFedPlans();
        for (int i = 0; i < childFedPlanPairs.size(); ++i) {
            Pair<Long, FEDInstruction.FederatedOutput> childFedPlanPair = childFedPlanPairs.get(i);
            FederatedMemoTable.FedPlanVariants childVariants = memoTable.getFedPlanVariants(childFedPlanPair);
            if (childVariants == null || childVariants.isEmpty()) continue;
            for (FederatedMemoTable.FedPlan childPlan : childVariants.getFedPlanVariants()) {
                FederatedMemoTablePrinter.printFedPlanTreeRecursive(childPlan, memoTable, visited, depth + 1);
            }
        }
    }
}

