/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.services;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.Request;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseModel;

public class MapperService {
    public static <T extends BaseModel> T getModelFromBody(Request request, Class<T> classType) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            if (!request.getBody().isEmpty() && !request.getBody().isBlank()) {
                return (T)((BaseModel)mapper.readValue(request.getBody(), classType));
            }
            return (T)((BaseModel)classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends BaseModel> T mapResultToModel(ResultSet resultSet, Class<T> classType) {
        try {
            BaseModel result = (BaseModel)classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] fields = result.getClass().getFields();
            for (int column = 1; column <= resultSet.getMetaData().getColumnCount(); ++column) {
                String colName = resultSet.getMetaData().getColumnName(column);
                for (Field field : fields) {
                    String fieldName = field.getName();
                    if (!colName.equalsIgnoreCase(fieldName)) continue;
                    if (resultSet.getMetaData().getColumnType(column) == 12) {
                        result.getClass().getField(fieldName).set(result, resultSet.getString(column));
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(column) == 8) {
                        result.getClass().getField(fieldName).set(result, resultSet.getDouble(column));
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(column) == 4) {
                        result.getClass().getField(fieldName).set(result, resultSet.getLong(column));
                        continue;
                    }
                    if (resultSet.getMetaData().getColumnType(column) != 93) continue;
                    result.getClass().getField(fieldName).set(result, resultSet.getTimestamp(column).toLocalDateTime());
                }
            }
            return (T)result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

