/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.common.Warnings;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockLDRB;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DenseBlockLInt32
extends DenseBlockLDRB {
    private static final long serialVersionUID = 4273439182762731283L;
    private int[][] _blocks;

    public DenseBlockLInt32(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlocks(int numBlocks) {
        this._blocks = new int[numBlocks][];
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._blocks[bix] = new int[length];
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._blocks[bix][ix] = UtilFunctions.toInt(v);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.INT32 == vt;
    }

    @Override
    public boolean isContiguous() {
        return this._blocks.length == 1;
    }

    @Override
    public int numBlocks() {
        return this._blocks.length;
    }

    @Override
    public long capacity() {
        return this._blocks != null ? (long)(this._blocks.length - 1) * (long)this._blocks[0].length + (long)this._blocks[this._blocks.length - 1].length : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return UtilFunctions.computeNnz(this._blocks[bix], start, length);
    }

    @Override
    public double[] values(int r) {
        return this.valuesAt(this.index(r));
    }

    @Override
    public double[] valuesAt(int bix) {
        Warnings.warnFullFP64Conversion(this._blocks[bix].length);
        return DataConverter.toDouble(this._blocks[bix]);
    }

    @Override
    public void incr(int r, int c) {
        this.incr(r, c, 1.0);
    }

    @Override
    public void incr(int r, int c, double delta) {
        int[] nArray = this._blocks[this.index(r)];
        int n = this.pos(r, c);
        nArray[n] = (int)((double)nArray[n] + delta);
    }

    @Override
    public void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        Arrays.fill(this._blocks[bix], fromIndex, toIndex, UtilFunctions.toInt(v));
    }

    @Override
    public void fillRow(int r, double v) {
        int start = this.pos(r);
        int end = start + this.getDim(1);
        Arrays.fill(this._blocks[this.index(r)], start, end, UtilFunctions.toInt(v));
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._blocks[this.index((int)r)][this.pos((int)r, (int)c)] = UtilFunctions.toInt(v);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = UtilFunctions.toInt(v);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = (int)v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = Integer.parseInt(v);
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this._blocks[this.index(r)][this.pos(r, c)];
    }

    @Override
    public double get(int[] ix) {
        return this._blocks[this.index(ix[0])][this.pos(ix)];
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this._blocks[ix[0]][this.pos(ix)]);
    }

    @Override
    public long getLong(int[] ix) {
        return this._blocks[this.index(ix[0])][this.pos(ix)];
    }
}

