/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class StatementEventSupport {
    PooledConnection source;
    HashSet mlisteners = new HashSet();

    public StatementEventSupport(PooledConnection pooledConnection) {
        this.source = pooledConnection;
    }

    public synchronized void addStatementEventListener(StatementEventListener statementEventListener) {
        this.mlisteners.add(statementEventListener);
    }

    public synchronized void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.mlisteners.remove(statementEventListener);
    }

    public synchronized void printListeners() {
        System.err.println(this.mlisteners);
    }

    public synchronized int getListenerCount() {
        return this.mlisteners.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStatementClosed(PreparedStatement preparedStatement) {
        Set set;
        Object object = this;
        synchronized (object) {
            set = (Set)this.mlisteners.clone();
        }
        object = new StatementEvent(this.source, preparedStatement);
        for (StatementEventListener statementEventListener : set) {
            statementEventListener.statementClosed((StatementEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStatementErrorOccurred(PreparedStatement preparedStatement, SQLException sQLException) {
        Set set;
        Object object = this;
        synchronized (object) {
            set = (Set)this.mlisteners.clone();
        }
        object = new StatementEvent(this.source, preparedStatement, sQLException);
        for (StatementEventListener statementEventListener : set) {
            statementEventListener.statementErrorOccurred((StatementEvent)object);
        }
    }
}

