/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperationException;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.Property;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class EnvelopeOperation
extends AbstractOperation {
    private static final long serialVersionUID = 8034615858550405350L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("Envelope", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    final CoordinateReferenceSystem targetCRS;
    private final CoordinateOperation[] attributeToCRS;
    private transient Set<String> dependencies;
    private final DefaultAttributeType<Envelope> resultType;

    EnvelopeOperation(Map<String, ?> map, CoordinateReferenceSystem object, AbstractIdentifiedType[] abstractIdentifiedTypeArray) throws FactoryException {
        super(map);
        Object object2;
        Object object3;
        String string = null;
        boolean bl = false;
        LinkedHashMap<String, CoordinateReferenceSystem> linkedHashMap = new LinkedHashMap<String, CoordinateReferenceSystem>(4);
        for (AbstractIdentifiedType abstractIdentifiedType : abstractIdentifiedTypeArray) {
            object3 = Features.toAttribute(abstractIdentifiedType);
            if (!((Optional)object3).isPresent() || !Geometries.isKnownType(((Optional)object3).get().getValueClass())) continue;
            object2 = abstractIdentifiedType.getName();
            String string2 = abstractIdentifiedType instanceof LinkOperation ? ((LinkOperation)abstractIdentifiedType).referentName : object2.toString();
            boolean bl2 = AttributeConvention.GEOMETRY_PROPERTY.equals(object2);
            if (bl2) {
                string = string2;
            }
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            DefaultAttributeType<?> defaultAttributeType = ((DefaultAttributeType)((Optional)object3).get()).characteristics().get("sis:crs");
            if (defaultAttributeType != null && CoordinateReferenceSystem.class.isAssignableFrom(defaultAttributeType.getValueClass())) {
                coordinateReferenceSystem = (CoordinateReferenceSystem)defaultAttributeType.getDefaultValue();
                if (object == null && bl2) {
                    object = coordinateReferenceSystem;
                }
                bl = true;
            }
            linkedHashMap.putIfAbsent(string2, coordinateReferenceSystem);
        }
        linkedHashMap.remove(null);
        this.attributeNames = new String[linkedHashMap.size()];
        this.attributeToCRS = bl ? new CoordinateOperation[this.attributeNames.length] : null;
        int n = string == null ? 0 : 1;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            int n2;
            object3 = (String)entry.getKey();
            if (((String)object3).equals(string)) {
                string = null;
                n2 = 0;
            } else {
                n2 = n++;
            }
            this.attributeNames[n2] = object3;
            if (!bl || (object2 = (CoordinateReferenceSystem)entry.getValue()) == null) continue;
            if (object == null) {
                object = object2;
            }
            this.attributeToCRS[n2] = CRS.findOperation((CoordinateReferenceSystem)object2, (CoordinateReferenceSystem)object, null);
        }
        this.resultType = FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(map), Envelope.class, 1, 1, null, new DefaultAttributeType[0]));
        this.targetCRS = object;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public synchronized Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CollectionsExt.immutableSet(true, this.attributeNames);
        }
        return this.dependencies;
    }

    @Override
    public Property apply(AbstractFeature abstractFeature, ParameterValueGroup parameterValueGroup) {
        return new Result(abstractFeature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + Arrays.hashCode(this.attributeToCRS);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            EnvelopeOperation envelopeOperation = (EnvelopeOperation)object;
            return Arrays.equals(this.attributeNames, envelopeOperation.attributeNames) && Arrays.equals(this.attributeToCRS, envelopeOperation.attributeToCRS) && Objects.equals(this.targetCRS, envelopeOperation.targetCRS);
        }
        return false;
    }

    private final class Result
    extends AbstractAttribute<Envelope> {
        private static final long serialVersionUID = 926172863066901618L;
        private final AbstractFeature feature;

        Result(AbstractFeature abstractFeature) {
            super(EnvelopeOperation.this.resultType);
            this.feature = abstractFeature;
        }

        @Override
        public Envelope getValue() throws FeatureOperationException {
            String[] stringArray = EnvelopeOperation.this.attributeNames;
            GeneralEnvelope generalEnvelope = null;
            GeneralEnvelope[] generalEnvelopeArray = null;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                GeneralEnvelope generalEnvelope2 = Geometries.wrap(this.feature.getPropertyValue(stringArray[i])).map(GeometryWrapper::getEnvelope).orElse(null);
                if (generalEnvelope2 == null) continue;
                CoordinateReferenceSystem coordinateReferenceSystem = generalEnvelope2.getCoordinateReferenceSystem();
                CoordinateOperation coordinateOperation = null;
                if (EnvelopeOperation.this.attributeToCRS != null) {
                    coordinateOperation = EnvelopeOperation.this.attributeToCRS[i];
                    if (coordinateReferenceSystem == null) {
                        Object obj;
                        AbstractAttribute<?> abstractAttribute = ((AbstractAttribute)this.feature.getProperty(stringArray[i])).characteristics().get("sis:crs");
                        if (abstractAttribute != null && (obj = abstractAttribute.getValue()) != null) {
                            if (!(obj instanceof CoordinateReferenceSystem)) {
                                throw new FeatureOperationException(Resources.formatInternational((short)25, AttributeConvention.CRS_CHARACTERISTIC, CoordinateReferenceSystem.class, obj.getClass()));
                            }
                            coordinateReferenceSystem = (CoordinateReferenceSystem)obj;
                        } else if (coordinateOperation != null) {
                            coordinateReferenceSystem = coordinateOperation.getSourceCRS();
                        }
                        generalEnvelope2.setCoordinateReferenceSystem(coordinateReferenceSystem);
                    }
                }
                if (coordinateReferenceSystem != null && EnvelopeOperation.this.targetCRS != null) {
                    try {
                        if (coordinateOperation == null) {
                            coordinateOperation = CRS.findOperation(coordinateReferenceSystem, EnvelopeOperation.this.targetCRS, null);
                        }
                        if (!coordinateOperation.getMathTransform().isIdentity()) {
                            generalEnvelope2 = Envelopes.transform(coordinateOperation, (Envelope)generalEnvelope2);
                        }
                    }
                    catch (TransformException | FactoryException exception) {
                        throw new FeatureOperationException(Errors.formatInternational((short)16), exception);
                    }
                }
                bl |= coordinateReferenceSystem == null;
                if (generalEnvelope == null) {
                    generalEnvelope = generalEnvelope2;
                    continue;
                }
                if (bl) {
                    throw new FeatureOperationException(Errors.formatInternational((short)157));
                }
                if (EnvelopeOperation.this.targetCRS != null) {
                    generalEnvelope.add(generalEnvelope2);
                    continue;
                }
                if (generalEnvelopeArray == null) {
                    generalEnvelopeArray = new GeneralEnvelope[stringArray.length];
                    generalEnvelopeArray[0] = generalEnvelope;
                }
                generalEnvelopeArray[i] = generalEnvelope2;
            }
            if (generalEnvelopeArray == null) {
                return generalEnvelope;
            }
            try {
                return Envelopes.union(generalEnvelopeArray);
            }
            catch (TransformException transformException) {
                throw new FeatureOperationException(Errors.formatInternational((short)16), transformException);
            }
        }

        @Override
        public void setValue(Envelope envelope) {
            throw new UnsupportedOperationException(Errors.format((short)153, AbstractAttribute.class));
        }
    }
}

