/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.services;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.LongStream;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.service.Service;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.tinkergraph.services.TinkerServiceRegistry;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.AbstractTinkerGraph;
import org.apache.tinkerpop.gremlin.util.CollectionUtil;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class TinkerDegreeCentralityFactory
extends TinkerServiceRegistry.TinkerServiceFactory<Vertex, Long>
implements Service<Vertex, Long> {
    public static final String NAME = "tinker.degree.centrality";

    public TinkerDegreeCentralityFactory(AbstractTinkerGraph graph) {
        super(graph, NAME);
    }

    public Service.Type getType() {
        return Service.Type.Streaming;
    }

    @Override
    public Map describeParams() {
        return Params.DESCRIBE;
    }

    public Set<Service.Type> getSupportedTypes() {
        return Collections.singleton(Service.Type.Streaming);
    }

    public Service<Vertex, Long> createService(boolean isStart, Map params) {
        if (isStart) {
            throw new UnsupportedOperationException("This service cannot be used to start a traversal.");
        }
        return this;
    }

    public CloseableIterator<Long> execute(Service.ServiceCallContext ctx, Traverser.Admin<Vertex> in, Map params) {
        long count;
        Direction direction = params.getOrDefault("direction", Direction.IN);
        Vertex v = (Vertex)in.get();
        try (CloseableIterator it = CloseableIterator.of((Iterator)v.edges(direction, new String[0]));){
            count = IteratorUtils.count((Iterator)it);
        }
        return CloseableIterator.of((Iterator)LongStream.range(0L, in.bulk()).map(i -> count).iterator());
    }

    public void close() {
    }

    public static interface Params {
        public static final String DIRECTION = "direction";
        public static final Map DESCRIBE = CollectionUtil.asMap((Object[])new Object[]{"direction", "Specify the edge direction (optional), default is Direction.IN"});
    }
}

