/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import jakarta.batch.runtime.BatchStatus;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.batchee.container.Controller;
import org.apache.batchee.container.ExecutionElementController;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.JobContextImpl;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.BaseStepController;
import org.apache.batchee.container.impl.controller.DecisionController;
import org.apache.batchee.container.impl.controller.ExecutionElementControllerFactory;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.jsl.ExecutionElement;
import org.apache.batchee.container.jsl.IllegalTransitionException;
import org.apache.batchee.container.jsl.Transition;
import org.apache.batchee.container.jsl.TransitionElement;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.services.BatchKernelService;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.status.ExecutionStatus;
import org.apache.batchee.container.status.ExtendedBatchStatus;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.jaxb.Decision;
import org.apache.batchee.jaxb.End;
import org.apache.batchee.jaxb.Fail;
import org.apache.batchee.jaxb.Flow;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.Split;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.jaxb.Stop;

public class ExecutionTransitioner {
    private final ServicesManager manager;
    private RuntimeJobExecution jobExecution;
    private long rootJobExecutionId;
    private ModelNavigator<?> modelNavigator;
    private volatile ExecutionElementController currentStoppableElementController;
    private ExecutionElementController previousElementController;
    private ExecutionElement currentExecutionElement = null;
    private ExecutionElement previousExecutionElement = null;
    private JobContextImpl jobContext;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue = null;
    private List<Long> stepExecIds;
    private StepContextImpl parentStepContext;

    public ExecutionTransitioner(RuntimeJobExecution jobExecution, long rootJobExecutionId, ModelNavigator<?> modelNavigator, ServicesManager servicesManager) {
        this.jobExecution = jobExecution;
        this.rootJobExecutionId = rootJobExecutionId;
        this.modelNavigator = modelNavigator;
        this.jobContext = jobExecution.getJobContext();
        this.manager = servicesManager;
    }

    public ExecutionTransitioner(RuntimeJobExecution jobExecution, long rootJobExecutionId, ModelNavigator<JSLJob> jobNavigator, BlockingQueue<PartitionDataWrapper> analyzerQueue, ServicesManager manager) {
        this.jobExecution = jobExecution;
        this.rootJobExecutionId = rootJobExecutionId;
        this.modelNavigator = jobNavigator;
        this.jobContext = jobExecution.getJobContext();
        this.analyzerQueue = analyzerQueue;
        this.manager = manager;
    }

    public ExecutionStatus doExecutionLoop() {
        Transition nextTransition;
        try {
            this.currentExecutionElement = this.modelNavigator.getFirstExecutionElement(this.jobExecution.getRestartOn());
        }
        catch (IllegalTransitionException e) {
            throw new IllegalArgumentException("Could not transition to first execution element within job.", e);
        }
        while (true) {
            ExecutionElementController currentElementController;
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                return new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
            }
            this.currentStoppableElementController = currentElementController = this.getNextElementController();
            if (BaseStepController.class.isInstance(currentElementController)) {
                ((BaseStepController)BaseStepController.class.cast(currentElementController)).setParentStepContext(this.parentStepContext);
            }
            ExecutionStatus status = currentElementController.execute();
            if ((this.currentExecutionElement instanceof Split || this.currentExecutionElement instanceof Flow) && !status.getExtendedBatchStatus().equals((Object)ExtendedBatchStatus.NORMAL_COMPLETION)) {
                return status;
            }
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
                throw new BatchContainerRuntimeException("Sub-execution returned its own BatchStatus of FAILED.  Deal with this by throwing exception to the next layer.");
            }
            this.currentStoppableElementController = null;
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                return new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
            }
            try {
                nextTransition = this.modelNavigator.getNextTransition(this.currentExecutionElement, status);
            }
            catch (IllegalTransitionException e) {
                throw new BatchContainerRuntimeException("Problem transitioning to next execution element.", e);
            }
            if (nextTransition.isFinishedTransitioning()) {
                this.stepExecIds = currentElementController.getLastRunStepExecutions();
                return new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, status.getExitStatus());
            }
            if (nextTransition.noTransitionElementMatchedAfterException()) {
                return new ExecutionStatus(ExtendedBatchStatus.EXCEPTION_THROWN, status.getExitStatus());
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            this.previousExecutionElement = this.currentExecutionElement;
            this.previousElementController = currentElementController;
            this.currentExecutionElement = nextTransition.getNextExecutionElement();
        }
        if (nextTransition.getTransitionElement() != null) {
            return this.handleTerminatingTransitionElement(nextTransition.getTransitionElement());
        }
        throw new IllegalStateException("Not sure how we'd end up in this state...aborting rather than looping.");
    }

    private ExecutionElementController getNextElementController() {
        ExecutionElementController elementController;
        if (this.currentExecutionElement instanceof Decision) {
            Decision decision = (Decision)this.currentExecutionElement;
            DecisionController decisionController = elementController = ExecutionElementControllerFactory.getDecisionController(this.manager, this.jobExecution, decision);
            decisionController.setPreviousStepExecutions(this.previousExecutionElement, this.previousElementController);
        } else if (this.currentExecutionElement instanceof Flow) {
            Flow flow = (Flow)this.currentExecutionElement;
            elementController = ExecutionElementControllerFactory.getFlowController(this.manager, this.jobExecution, flow, this.rootJobExecutionId);
        } else if (this.currentExecutionElement instanceof Split) {
            Split split = (Split)this.currentExecutionElement;
            elementController = ExecutionElementControllerFactory.getSplitController(this.manager.service(BatchKernelService.class), this.jobExecution, split, this.rootJobExecutionId);
        } else if (this.currentExecutionElement instanceof Step) {
            Step step = (Step)this.currentExecutionElement;
            StepContextImpl stepContext = new StepContextImpl(step.getId());
            elementController = ExecutionElementControllerFactory.getStepController(this.jobExecution, step, stepContext, this.rootJobExecutionId, this.analyzerQueue, this.manager);
        } else {
            elementController = null;
        }
        return elementController;
    }

    private ExecutionStatus handleTerminatingTransitionElement(TransitionElement transitionElement) {
        ExecutionStatus retVal;
        if (transitionElement instanceof Stop) {
            Stop stopElement = (Stop)transitionElement;
            String restartOn = stopElement.getRestart();
            String exitStatusFromJSL = stopElement.getExitStatus();
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_STOP);
            if (exitStatusFromJSL != null) {
                this.jobContext.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
            if (restartOn != null) {
                this.jobContext.setRestartOn(restartOn);
                retVal.setRestartOn(restartOn);
            }
        } else if (transitionElement instanceof End) {
            End endElement = (End)transitionElement;
            String exitStatusFromJSL = endElement.getExitStatus();
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_END);
            if (exitStatusFromJSL != null) {
                this.jobContext.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
        } else if (transitionElement instanceof Fail) {
            Fail failElement = (Fail)transitionElement;
            String exitStatusFromJSL = failElement.getExitStatus();
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_FAIL);
            if (exitStatusFromJSL != null) {
                this.jobContext.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
        } else {
            throw new IllegalStateException("Not sure how we'd get here...aborting.");
        }
        return retVal;
    }

    public Controller getCurrentStoppableElementController() {
        return this.currentStoppableElementController;
    }

    public List<Long> getStepExecIds() {
        return this.stepExecIds;
    }

    public void setParentStepContext(StepContextImpl parentStepContext) {
        this.parentStepContext = parentStepContext;
    }
}

