/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.impl.DefaultFacesConfigurationProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class FacesConfigurationProviderFactory {
    private static final String FACTORY_KEY = FacesConfigurationProviderFactory.class.getName();

    public static FacesConfigurationProviderFactory getFacesConfigurationProviderFactory(ExternalContext ctx) {
        FacesConfigurationProviderFactory factory = (FacesConfigurationProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (factory != null) {
            return factory;
        }
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                factory = (FacesConfigurationProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, FacesConfigurationProviderFactory.class, DefaultFacesConfigurationProviderFactory.class));
            } else {
                factory = (FacesConfigurationProviderFactory)SpiUtils.build(ctx, FacesConfigurationProviderFactory.class, DefaultFacesConfigurationProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (factory != null) {
            FacesConfigurationProviderFactory.setFacesConfigurationProviderFactory(ctx, factory);
        }
        return factory;
    }

    public static void setFacesConfigurationProviderFactory(ExternalContext ctx, FacesConfigurationProviderFactory factory) {
        ctx.getApplicationMap().put(FACTORY_KEY, factory);
    }

    public abstract FacesConfigurationProvider getFacesConfigurationProvider(ExternalContext var1);
}

