/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;

public class ContextualStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<Object, ContextualInstanceInfo<?>> contextualInstances;
    protected Map<String, Object> beanNameToKeyMapping;
    protected BeanManager beanManager;
    protected boolean concurrent;
    protected boolean passivating;
    protected volatile transient boolean activated;

    public ContextualStorage() {
        this.activated = true;
    }

    public ContextualStorage(BeanManager beanManager, boolean concurrent, boolean passivating) {
        this.beanManager = beanManager;
        this.concurrent = concurrent;
        this.passivating = passivating;
        if (concurrent) {
            this.contextualInstances = new ConcurrentHashMap();
            this.beanNameToKeyMapping = new ConcurrentHashMap<String, Object>();
        } else {
            this.contextualInstances = new HashMap();
            this.beanNameToKeyMapping = new HashMap<String, Object>();
        }
        this.activated = true;
    }

    public Map<Object, ContextualInstanceInfo<?>> getStorage() {
        return this.contextualInstances;
    }

    public void clear() {
        this.contextualInstances.clear();
        this.beanNameToKeyMapping.clear();
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T createContextualInstance(Contextual<T> bean, CreationalContext<T> creationalContext) {
        String name;
        Object beanKey = this.getBeanKey(bean);
        if (this.isConcurrent()) {
            ConcurrentHashMap concurrentMap = (ConcurrentHashMap)this.contextualInstances;
            ContextualInstanceInfo<T> instanceInfo = new ContextualInstanceInfo<T>();
            ContextualInstanceInfo oldInstanceInfo = concurrentMap.putIfAbsent(beanKey, instanceInfo);
            if (oldInstanceInfo != null) {
                instanceInfo = oldInstanceInfo;
            }
            ContextualInstanceInfo<T> contextualInstanceInfo = instanceInfo;
            synchronized (contextualInstanceInfo) {
                Object instance = instanceInfo.getContextualInstance();
                if (instance == null) {
                    String name2;
                    instance = bean.create(creationalContext);
                    instanceInfo.setContextualInstance(instance);
                    instanceInfo.setCreationalContext(creationalContext);
                    if (bean instanceof Bean && (name2 = ((Bean)bean).getName()) != null) {
                        this.beanNameToKeyMapping.put(name2, beanKey);
                    }
                }
                return instance;
            }
        }
        ContextualInstanceInfo<Object> instanceInfo = new ContextualInstanceInfo<Object>();
        instanceInfo.setCreationalContext(creationalContext);
        instanceInfo.setContextualInstance(bean.create(creationalContext));
        this.contextualInstances.put(beanKey, instanceInfo);
        if (bean instanceof Bean && (name = ((Bean)bean).getName()) != null) {
            this.beanNameToKeyMapping.put(name, beanKey);
        }
        return instanceInfo.getContextualInstance();
    }

    public <T> Object getBeanKey(Contextual<T> bean) {
        if (bean instanceof PassivationCapable && this.passivating) {
            return ((PassivationCapable)bean).getId();
        }
        return bean;
    }

    public Contextual<?> getBean(Object beanKey) {
        if (beanKey instanceof String && this.passivating) {
            return this.beanManager.getPassivationCapableBean((String)beanKey);
        }
        if (beanKey instanceof Contextual) {
            return (Contextual)beanKey;
        }
        return null;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate() {
        this.activated = false;
    }

    public Map<String, Object> getBeanNameToKeyMapping() {
        return this.beanNameToKeyMapping;
    }
}

