// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/documentai/v1/document_processor_service.proto

package documentaipb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The final state of human review on a processed document.
type HumanReviewStatus_State int32

const (
	// Human review state is unspecified. Most likely due to an internal error.
	HumanReviewStatus_STATE_UNSPECIFIED HumanReviewStatus_State = 0
	// Human review is skipped for the document. This can happen because human
	// review isn't enabled on the processor or the processing request has
	// been set to skip this document.
	HumanReviewStatus_SKIPPED HumanReviewStatus_State = 1
	// Human review validation is triggered and passed, so no review is needed.
	HumanReviewStatus_VALIDATION_PASSED HumanReviewStatus_State = 2
	// Human review validation is triggered and the document is under review.
	HumanReviewStatus_IN_PROGRESS HumanReviewStatus_State = 3
	// Some error happened during triggering human review, see the
	// [state_message][google.cloud.documentai.v1.HumanReviewStatus.state_message]
	// for details.
	HumanReviewStatus_ERROR HumanReviewStatus_State = 4
)

// Enum value maps for HumanReviewStatus_State.
var (
	HumanReviewStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SKIPPED",
		2: "VALIDATION_PASSED",
		3: "IN_PROGRESS",
		4: "ERROR",
	}
	HumanReviewStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SKIPPED":           1,
		"VALIDATION_PASSED": 2,
		"IN_PROGRESS":       3,
		"ERROR":             4,
	}
)

func (x HumanReviewStatus_State) Enum() *HumanReviewStatus_State {
	p := new(HumanReviewStatus_State)
	*p = x
	return p
}

func (x HumanReviewStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HumanReviewStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[0].Descriptor()
}

func (HumanReviewStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[0]
}

func (x HumanReviewStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HumanReviewStatus_State.Descriptor instead.
func (HumanReviewStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{2, 0}
}

// Possible states of the batch processing operation.
type BatchProcessMetadata_State int32

const (
	// The default value. This value is used if the state is omitted.
	BatchProcessMetadata_STATE_UNSPECIFIED BatchProcessMetadata_State = 0
	// Request operation is waiting for scheduling.
	BatchProcessMetadata_WAITING BatchProcessMetadata_State = 1
	// Request is being processed.
	BatchProcessMetadata_RUNNING BatchProcessMetadata_State = 2
	// The batch processing completed successfully.
	BatchProcessMetadata_SUCCEEDED BatchProcessMetadata_State = 3
	// The batch processing was being cancelled.
	BatchProcessMetadata_CANCELLING BatchProcessMetadata_State = 4
	// The batch processing was cancelled.
	BatchProcessMetadata_CANCELLED BatchProcessMetadata_State = 5
	// The batch processing has failed.
	BatchProcessMetadata_FAILED BatchProcessMetadata_State = 6
)

// Enum value maps for BatchProcessMetadata_State.
var (
	BatchProcessMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "WAITING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "CANCELLING",
		5: "CANCELLED",
		6: "FAILED",
	}
	BatchProcessMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"WAITING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"CANCELLING":        4,
		"CANCELLED":         5,
		"FAILED":            6,
	}
)

func (x BatchProcessMetadata_State) Enum() *BatchProcessMetadata_State {
	p := new(BatchProcessMetadata_State)
	*p = x
	return p
}

func (x BatchProcessMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchProcessMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[1].Descriptor()
}

func (BatchProcessMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[1]
}

func (x BatchProcessMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchProcessMetadata_State.Descriptor instead.
func (BatchProcessMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{6, 0}
}

// Training Method for CDE. `TRAINING_METHOD_UNSPECIFIED` will fall back to
// `MODEL_BASED`.
type TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod int32

const (
	TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TRAINING_METHOD_UNSPECIFIED TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod = 0
	TrainProcessorVersionRequest_CustomDocumentExtractionOptions_MODEL_BASED                 TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod = 1
	TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TEMPLATE_BASED              TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod = 2
)

// Enum value maps for TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod.
var (
	TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod_name = map[int32]string{
		0: "TRAINING_METHOD_UNSPECIFIED",
		1: "MODEL_BASED",
		2: "TEMPLATE_BASED",
	}
	TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod_value = map[string]int32{
		"TRAINING_METHOD_UNSPECIFIED": 0,
		"MODEL_BASED":                 1,
		"TEMPLATE_BASED":              2,
	}
)

func (x TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod) Enum() *TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod {
	p := new(TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod)
	*p = x
	return p
}

func (x TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[2].Descriptor()
}

func (TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[2]
}

func (x TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod.Descriptor instead.
func (TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{38, 1, 0}
}

// The priority level of the human review task.
type ReviewDocumentRequest_Priority int32

const (
	// The default priority level.
	ReviewDocumentRequest_DEFAULT ReviewDocumentRequest_Priority = 0
	// The urgent priority level. The labeling manager should allocate labeler
	// resource to the urgent task queue to respect this priority level.
	ReviewDocumentRequest_URGENT ReviewDocumentRequest_Priority = 1
)

// Enum value maps for ReviewDocumentRequest_Priority.
var (
	ReviewDocumentRequest_Priority_name = map[int32]string{
		0: "DEFAULT",
		1: "URGENT",
	}
	ReviewDocumentRequest_Priority_value = map[string]int32{
		"DEFAULT": 0,
		"URGENT":  1,
	}
)

func (x ReviewDocumentRequest_Priority) Enum() *ReviewDocumentRequest_Priority {
	p := new(ReviewDocumentRequest_Priority)
	*p = x
	return p
}

func (x ReviewDocumentRequest_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReviewDocumentRequest_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[3].Descriptor()
}

func (ReviewDocumentRequest_Priority) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[3]
}

func (x ReviewDocumentRequest_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReviewDocumentRequest_Priority.Descriptor instead.
func (ReviewDocumentRequest_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{41, 0}
}

// Possible states of the review operation.
type ReviewDocumentResponse_State int32

const (
	// The default value. This value is used if the state is omitted.
	ReviewDocumentResponse_STATE_UNSPECIFIED ReviewDocumentResponse_State = 0
	// The review operation is rejected by the reviewer.
	ReviewDocumentResponse_REJECTED ReviewDocumentResponse_State = 1
	// The review operation is succeeded.
	ReviewDocumentResponse_SUCCEEDED ReviewDocumentResponse_State = 2
)

// Enum value maps for ReviewDocumentResponse_State.
var (
	ReviewDocumentResponse_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "REJECTED",
		2: "SUCCEEDED",
	}
	ReviewDocumentResponse_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"REJECTED":          1,
		"SUCCEEDED":         2,
	}
)

func (x ReviewDocumentResponse_State) Enum() *ReviewDocumentResponse_State {
	p := new(ReviewDocumentResponse_State)
	*p = x
	return p
}

func (x ReviewDocumentResponse_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReviewDocumentResponse_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[4].Descriptor()
}

func (ReviewDocumentResponse_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[4]
}

func (x ReviewDocumentResponse_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReviewDocumentResponse_State.Descriptor instead.
func (ReviewDocumentResponse_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{42, 0}
}

// Options for Process API
type ProcessOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A subset of pages to process. If not specified, all pages are processed.
	// If a page range is set, only the given pages are extracted and processed
	// from the document. In the output document,
	// [Document.Page.page_number][google.cloud.documentai.v1.Document.Page.page_number]
	// refers to the page number in the original document. This configuration
	// only applies to sync requests.
	//
	// Types that are assignable to PageRange:
	//
	//	*ProcessOptions_IndividualPageSelector_
	//	*ProcessOptions_FromStart
	//	*ProcessOptions_FromEnd
	PageRange isProcessOptions_PageRange `protobuf_oneof:"page_range"`
	// Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
	// Returns error if set on other processor types.
	OcrConfig *OcrConfig `protobuf:"bytes,1,opt,name=ocr_config,json=ocrConfig,proto3" json:"ocr_config,omitempty"`
	// Optional. Override the schema of the
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]. Will
	// return an Invalid Argument error if this field is set when the underlying
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion] doesn't
	// support schema override.
	SchemaOverride *DocumentSchema `protobuf:"bytes,8,opt,name=schema_override,json=schemaOverride,proto3" json:"schema_override,omitempty"`
}

func (x *ProcessOptions) Reset() {
	*x = ProcessOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessOptions) ProtoMessage() {}

func (x *ProcessOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessOptions.ProtoReflect.Descriptor instead.
func (*ProcessOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{0}
}

func (m *ProcessOptions) GetPageRange() isProcessOptions_PageRange {
	if m != nil {
		return m.PageRange
	}
	return nil
}

func (x *ProcessOptions) GetIndividualPageSelector() *ProcessOptions_IndividualPageSelector {
	if x, ok := x.GetPageRange().(*ProcessOptions_IndividualPageSelector_); ok {
		return x.IndividualPageSelector
	}
	return nil
}

func (x *ProcessOptions) GetFromStart() int32 {
	if x, ok := x.GetPageRange().(*ProcessOptions_FromStart); ok {
		return x.FromStart
	}
	return 0
}

func (x *ProcessOptions) GetFromEnd() int32 {
	if x, ok := x.GetPageRange().(*ProcessOptions_FromEnd); ok {
		return x.FromEnd
	}
	return 0
}

func (x *ProcessOptions) GetOcrConfig() *OcrConfig {
	if x != nil {
		return x.OcrConfig
	}
	return nil
}

func (x *ProcessOptions) GetSchemaOverride() *DocumentSchema {
	if x != nil {
		return x.SchemaOverride
	}
	return nil
}

type isProcessOptions_PageRange interface {
	isProcessOptions_PageRange()
}

type ProcessOptions_IndividualPageSelector_ struct {
	// Which pages to process (1-indexed).
	IndividualPageSelector *ProcessOptions_IndividualPageSelector `protobuf:"bytes,5,opt,name=individual_page_selector,json=individualPageSelector,proto3,oneof"`
}

type ProcessOptions_FromStart struct {
	// Only process certain pages from the start. Process all if the document
	// has fewer pages.
	FromStart int32 `protobuf:"varint,6,opt,name=from_start,json=fromStart,proto3,oneof"`
}

type ProcessOptions_FromEnd struct {
	// Only process certain pages from the end, same as above.
	FromEnd int32 `protobuf:"varint,7,opt,name=from_end,json=fromEnd,proto3,oneof"`
}

func (*ProcessOptions_IndividualPageSelector_) isProcessOptions_PageRange() {}

func (*ProcessOptions_FromStart) isProcessOptions_PageRange() {}

func (*ProcessOptions_FromEnd) isProcessOptions_PageRange() {}

// Request message for the
// [ProcessDocument][google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument]
// method.
type ProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload.
	//
	// Types that are assignable to Source:
	//
	//	*ProcessRequest_InlineDocument
	//	*ProcessRequest_RawDocument
	//	*ProcessRequest_GcsDocument
	Source isProcessRequest_Source `protobuf_oneof:"source"`
	// Required. The resource name of the
	// [Processor][google.cloud.documentai.v1.Processor] or
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion]
	// to use for processing. If a
	// [Processor][google.cloud.documentai.v1.Processor] is specified, the server
	// will use its [default
	// version][google.cloud.documentai.v1.Processor.default_processor_version].
	// Format: `projects/{project}/locations/{location}/processors/{processor}`,
	// or
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Whether human review should be skipped for this request. Default to
	// `false`.
	SkipHumanReview bool `protobuf:"varint,3,opt,name=skip_human_review,json=skipHumanReview,proto3" json:"skip_human_review,omitempty"`
	// Specifies which fields to include in the
	// [ProcessResponse.document][google.cloud.documentai.v1.ProcessResponse.document]
	// output. Only supports top-level document and pages field, so it must be in
	// the form of `{document_field_name}` or `pages.{page_field_name}`.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Inference-time options for the process API
	ProcessOptions *ProcessOptions `protobuf:"bytes,7,opt,name=process_options,json=processOptions,proto3" json:"process_options,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints) and can only contain lowercase letters, numeric
	// characters, underscores, and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ProcessRequest) Reset() {
	*x = ProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessRequest) ProtoMessage() {}

func (x *ProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessRequest.ProtoReflect.Descriptor instead.
func (*ProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{1}
}

func (m *ProcessRequest) GetSource() isProcessRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ProcessRequest) GetInlineDocument() *Document {
	if x, ok := x.GetSource().(*ProcessRequest_InlineDocument); ok {
		return x.InlineDocument
	}
	return nil
}

func (x *ProcessRequest) GetRawDocument() *RawDocument {
	if x, ok := x.GetSource().(*ProcessRequest_RawDocument); ok {
		return x.RawDocument
	}
	return nil
}

func (x *ProcessRequest) GetGcsDocument() *GcsDocument {
	if x, ok := x.GetSource().(*ProcessRequest_GcsDocument); ok {
		return x.GcsDocument
	}
	return nil
}

func (x *ProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProcessRequest) GetSkipHumanReview() bool {
	if x != nil {
		return x.SkipHumanReview
	}
	return false
}

func (x *ProcessRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *ProcessRequest) GetProcessOptions() *ProcessOptions {
	if x != nil {
		return x.ProcessOptions
	}
	return nil
}

func (x *ProcessRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isProcessRequest_Source interface {
	isProcessRequest_Source()
}

type ProcessRequest_InlineDocument struct {
	// An inline document proto.
	InlineDocument *Document `protobuf:"bytes,4,opt,name=inline_document,json=inlineDocument,proto3,oneof"`
}

type ProcessRequest_RawDocument struct {
	// A raw document content (bytes).
	RawDocument *RawDocument `protobuf:"bytes,5,opt,name=raw_document,json=rawDocument,proto3,oneof"`
}

type ProcessRequest_GcsDocument struct {
	// A raw document on Google Cloud Storage.
	GcsDocument *GcsDocument `protobuf:"bytes,8,opt,name=gcs_document,json=gcsDocument,proto3,oneof"`
}

func (*ProcessRequest_InlineDocument) isProcessRequest_Source() {}

func (*ProcessRequest_RawDocument) isProcessRequest_Source() {}

func (*ProcessRequest_GcsDocument) isProcessRequest_Source() {}

// The status of human review on a processed document.
type HumanReviewStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of human review on the processing request.
	State HumanReviewStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1.HumanReviewStatus_State" json:"state,omitempty"`
	// A message providing more details about the human review state.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The name of the operation triggered by the processed document. This field
	// is populated only when the
	// [state][google.cloud.documentai.v1.HumanReviewStatus.state] is
	// `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as
	// the long-running operation returned by
	// [ReviewDocument][google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument].
	HumanReviewOperation string `protobuf:"bytes,3,opt,name=human_review_operation,json=humanReviewOperation,proto3" json:"human_review_operation,omitempty"`
}

func (x *HumanReviewStatus) Reset() {
	*x = HumanReviewStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanReviewStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanReviewStatus) ProtoMessage() {}

func (x *HumanReviewStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanReviewStatus.ProtoReflect.Descriptor instead.
func (*HumanReviewStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{2}
}

func (x *HumanReviewStatus) GetState() HumanReviewStatus_State {
	if x != nil {
		return x.State
	}
	return HumanReviewStatus_STATE_UNSPECIFIED
}

func (x *HumanReviewStatus) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *HumanReviewStatus) GetHumanReviewOperation() string {
	if x != nil {
		return x.HumanReviewOperation
	}
	return ""
}

// Response message for the
// [ProcessDocument][google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument]
// method.
type ProcessResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload, will populate fields based on the processor's
	// behavior.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The status of human review on the processed document.
	HumanReviewStatus *HumanReviewStatus `protobuf:"bytes,3,opt,name=human_review_status,json=humanReviewStatus,proto3" json:"human_review_status,omitempty"`
}

func (x *ProcessResponse) Reset() {
	*x = ProcessResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessResponse) ProtoMessage() {}

func (x *ProcessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessResponse.ProtoReflect.Descriptor instead.
func (*ProcessResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{3}
}

func (x *ProcessResponse) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *ProcessResponse) GetHumanReviewStatus() *HumanReviewStatus {
	if x != nil {
		return x.HumanReviewStatus
	}
	return nil
}

// Request message for
// [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments].
type BatchProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of
	// [Processor][google.cloud.documentai.v1.Processor] or
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
	// Format: `projects/{project}/locations/{location}/processors/{processor}`,
	// or
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The input documents for the
	// [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments]
	// method.
	InputDocuments *BatchDocumentsInputConfig `protobuf:"bytes,5,opt,name=input_documents,json=inputDocuments,proto3" json:"input_documents,omitempty"`
	// The output configuration for the
	// [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments]
	// method.
	DocumentOutputConfig *DocumentOutputConfig `protobuf:"bytes,6,opt,name=document_output_config,json=documentOutputConfig,proto3" json:"document_output_config,omitempty"`
	// Whether human review should be skipped for this request. Default to
	// `false`.
	SkipHumanReview bool `protobuf:"varint,4,opt,name=skip_human_review,json=skipHumanReview,proto3" json:"skip_human_review,omitempty"`
	// Inference-time options for the process API
	ProcessOptions *ProcessOptions `protobuf:"bytes,7,opt,name=process_options,json=processOptions,proto3" json:"process_options,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints) and can only contain lowercase letters, numeric
	// characters, underscores, and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchProcessRequest) Reset() {
	*x = BatchProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessRequest) ProtoMessage() {}

func (x *BatchProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessRequest.ProtoReflect.Descriptor instead.
func (*BatchProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{4}
}

func (x *BatchProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BatchProcessRequest) GetInputDocuments() *BatchDocumentsInputConfig {
	if x != nil {
		return x.InputDocuments
	}
	return nil
}

func (x *BatchProcessRequest) GetDocumentOutputConfig() *DocumentOutputConfig {
	if x != nil {
		return x.DocumentOutputConfig
	}
	return nil
}

func (x *BatchProcessRequest) GetSkipHumanReview() bool {
	if x != nil {
		return x.SkipHumanReview
	}
	return false
}

func (x *BatchProcessRequest) GetProcessOptions() *ProcessOptions {
	if x != nil {
		return x.ProcessOptions
	}
	return nil
}

func (x *BatchProcessRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Response message for
// [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments].
type BatchProcessResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchProcessResponse) Reset() {
	*x = BatchProcessResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessResponse) ProtoMessage() {}

func (x *BatchProcessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessResponse.ProtoReflect.Descriptor instead.
func (*BatchProcessResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{5}
}

// The long-running operation metadata for
// [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments].
type BatchProcessMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the current batch processing.
	State BatchProcessMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1.BatchProcessMetadata_State" json:"state,omitempty"`
	// A message providing more details about the current state of processing.
	// For example, the error message if the operation is failed.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The creation time of the operation.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update time of the operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The list of response details of each document.
	IndividualProcessStatuses []*BatchProcessMetadata_IndividualProcessStatus `protobuf:"bytes,5,rep,name=individual_process_statuses,json=individualProcessStatuses,proto3" json:"individual_process_statuses,omitempty"`
}

func (x *BatchProcessMetadata) Reset() {
	*x = BatchProcessMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessMetadata) ProtoMessage() {}

func (x *BatchProcessMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessMetadata.ProtoReflect.Descriptor instead.
func (*BatchProcessMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{6}
}

func (x *BatchProcessMetadata) GetState() BatchProcessMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchProcessMetadata_STATE_UNSPECIFIED
}

func (x *BatchProcessMetadata) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *BatchProcessMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BatchProcessMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BatchProcessMetadata) GetIndividualProcessStatuses() []*BatchProcessMetadata_IndividualProcessStatus {
	if x != nil {
		return x.IndividualProcessStatuses
	}
	return nil
}

// Request message for the
// [FetchProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.FetchProcessorTypes]
// method. Some processor types may require the project be added to an
// allowlist.
type FetchProcessorTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of processor types to list.
	// Format: `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *FetchProcessorTypesRequest) Reset() {
	*x = FetchProcessorTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchProcessorTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchProcessorTypesRequest) ProtoMessage() {}

func (x *FetchProcessorTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchProcessorTypesRequest.ProtoReflect.Descriptor instead.
func (*FetchProcessorTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{7}
}

func (x *FetchProcessorTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for the
// [FetchProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.FetchProcessorTypes]
// method.
type FetchProcessorTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of processor types.
	ProcessorTypes []*ProcessorType `protobuf:"bytes,1,rep,name=processor_types,json=processorTypes,proto3" json:"processor_types,omitempty"`
}

func (x *FetchProcessorTypesResponse) Reset() {
	*x = FetchProcessorTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchProcessorTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchProcessorTypesResponse) ProtoMessage() {}

func (x *FetchProcessorTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchProcessorTypesResponse.ProtoReflect.Descriptor instead.
func (*FetchProcessorTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{8}
}

func (x *FetchProcessorTypesResponse) GetProcessorTypes() []*ProcessorType {
	if x != nil {
		return x.ProcessorTypes
	}
	return nil
}

// Request message for the
// [ListProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.ListProcessorTypes]
// method. Some processor types may require the project be added to an
// allowlist.
type ListProcessorTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of processor types to list.
	// Format: `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of processor types to return.
	// If unspecified, at most `100` processor types will be returned.
	// The maximum value is `500`. Values above `500` will be coerced to `500`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Used to retrieve the next page of results, empty if at the end of the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProcessorTypesRequest) Reset() {
	*x = ListProcessorTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorTypesRequest) ProtoMessage() {}

func (x *ListProcessorTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorTypesRequest.ProtoReflect.Descriptor instead.
func (*ListProcessorTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListProcessorTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessorTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessorTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the
// [ListProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.ListProcessorTypes]
// method.
type ListProcessorTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The processor types.
	ProcessorTypes []*ProcessorType `protobuf:"bytes,1,rep,name=processor_types,json=processorTypes,proto3" json:"processor_types,omitempty"`
	// Points to the next page, otherwise empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProcessorTypesResponse) Reset() {
	*x = ListProcessorTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorTypesResponse) ProtoMessage() {}

func (x *ListProcessorTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorTypesResponse.ProtoReflect.Descriptor instead.
func (*ListProcessorTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListProcessorTypesResponse) GetProcessorTypes() []*ProcessorType {
	if x != nil {
		return x.ProcessorTypes
	}
	return nil
}

func (x *ListProcessorTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for list all processors belongs to a project.
type ListProcessorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project and location) which owns this collection of
	// Processors. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of processors to return.
	// If unspecified, at most `50` processors will be returned.
	// The maximum value is `100`. Values above `100` will be coerced to `100`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// We will return the processors sorted by creation time. The page token
	// will point to the next processor.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProcessorsRequest) Reset() {
	*x = ListProcessorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorsRequest) ProtoMessage() {}

func (x *ListProcessorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorsRequest.ProtoReflect.Descriptor instead.
func (*ListProcessorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListProcessorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the
// [ListProcessors][google.cloud.documentai.v1.DocumentProcessorService.ListProcessors]
// method.
type ListProcessorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of processors.
	Processors []*Processor `protobuf:"bytes,1,rep,name=processors,proto3" json:"processors,omitempty"`
	// Points to the next processor, otherwise empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProcessorsResponse) Reset() {
	*x = ListProcessorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorsResponse) ProtoMessage() {}

func (x *ListProcessorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorsResponse.ProtoReflect.Descriptor instead.
func (*ListProcessorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListProcessorsResponse) GetProcessors() []*Processor {
	if x != nil {
		return x.Processors
	}
	return nil
}

func (x *ListProcessorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the
// [GetProcessorType][google.cloud.documentai.v1.DocumentProcessorService.GetProcessorType]
// method.
type GetProcessorTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor type resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessorTypeRequest) Reset() {
	*x = GetProcessorTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessorTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessorTypeRequest) ProtoMessage() {}

func (x *GetProcessorTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessorTypeRequest.ProtoReflect.Descriptor instead.
func (*GetProcessorTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetProcessorTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the
// [GetProcessor][google.cloud.documentai.v1.DocumentProcessorService.GetProcessor]
// method.
type GetProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessorRequest) Reset() {
	*x = GetProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessorRequest) ProtoMessage() {}

func (x *GetProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessorRequest.ProtoReflect.Descriptor instead.
func (*GetProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the
// [GetProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.GetProcessorVersion]
// method.
type GetProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessorVersionRequest) Reset() {
	*x = GetProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessorVersionRequest) ProtoMessage() {}

func (x *GetProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*GetProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{15}
}

func (x *GetProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for list all processor versions belongs to a processor.
type ListProcessorVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project, location and processor) to list all
	// versions. Format:
	// `projects/{project}/locations/{location}/processors/{processor}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of processor versions to return.
	// If unspecified, at most `10` processor versions will be returned.
	// The maximum value is `20`. Values above `20` will be coerced to `20`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// We will return the processor versions sorted by creation time. The page
	// token will point to the next processor version.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProcessorVersionsRequest) Reset() {
	*x = ListProcessorVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorVersionsRequest) ProtoMessage() {}

func (x *ListProcessorVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListProcessorVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListProcessorVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessorVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessorVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the
// [ListProcessorVersions][google.cloud.documentai.v1.DocumentProcessorService.ListProcessorVersions]
// method.
type ListProcessorVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of processors.
	ProcessorVersions []*ProcessorVersion `protobuf:"bytes,1,rep,name=processor_versions,json=processorVersions,proto3" json:"processor_versions,omitempty"`
	// Points to the next processor, otherwise empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProcessorVersionsResponse) Reset() {
	*x = ListProcessorVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessorVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessorVersionsResponse) ProtoMessage() {}

func (x *ListProcessorVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessorVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListProcessorVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{17}
}

func (x *ListProcessorVersionsResponse) GetProcessorVersions() []*ProcessorVersion {
	if x != nil {
		return x.ProcessorVersions
	}
	return nil
}

func (x *ListProcessorVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the
// [DeleteProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessorVersion]
// method.
type DeleteProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor version resource name to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProcessorVersionRequest) Reset() {
	*x = DeleteProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorVersionRequest) ProtoMessage() {}

func (x *DeleteProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*DeleteProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The long-running operation metadata for the
// [DeleteProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessorVersion]
// method.
type DeleteProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DeleteProcessorVersionMetadata) Reset() {
	*x = DeleteProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorVersionMetadata) ProtoMessage() {}

func (x *DeleteProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*DeleteProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the
// [DeployProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.DeployProcessorVersion]
// method.
type DeployProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor version resource name to be deployed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeployProcessorVersionRequest) Reset() {
	*x = DeployProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployProcessorVersionRequest) ProtoMessage() {}

func (x *DeployProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*DeployProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{20}
}

func (x *DeployProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the
// [DeployProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.DeployProcessorVersion]
// method.
type DeployProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployProcessorVersionResponse) Reset() {
	*x = DeployProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployProcessorVersionResponse) ProtoMessage() {}

func (x *DeployProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*DeployProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{21}
}

// The long-running operation metadata for the
// [DeployProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.DeployProcessorVersion]
// method.
type DeployProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DeployProcessorVersionMetadata) Reset() {
	*x = DeployProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployProcessorVersionMetadata) ProtoMessage() {}

func (x *DeployProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*DeployProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{22}
}

func (x *DeployProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the
// [UndeployProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.UndeployProcessorVersion]
// method.
type UndeployProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor version resource name to be undeployed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeployProcessorVersionRequest) Reset() {
	*x = UndeployProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployProcessorVersionRequest) ProtoMessage() {}

func (x *UndeployProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*UndeployProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{23}
}

func (x *UndeployProcessorVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the
// [UndeployProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.UndeployProcessorVersion]
// method.
type UndeployProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployProcessorVersionResponse) Reset() {
	*x = UndeployProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployProcessorVersionResponse) ProtoMessage() {}

func (x *UndeployProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*UndeployProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{24}
}

// The long-running operation metadata for the
// [UndeployProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.UndeployProcessorVersion]
// method.
type UndeployProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *UndeployProcessorVersionMetadata) Reset() {
	*x = UndeployProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployProcessorVersionMetadata) ProtoMessage() {}

func (x *UndeployProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*UndeployProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{25}
}

func (x *UndeployProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the
// [CreateProcessor][google.cloud.documentai.v1.DocumentProcessorService.CreateProcessor]
// method. Notice this request is sent to a regionalized backend service. If the
// [ProcessorType][google.cloud.documentai.v1.ProcessorType] isn't available in
// that region, the creation fails.
type CreateProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project and location) under which to create the
	// processor. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The processor to be created, requires
	// [Processor.type][google.cloud.documentai.v1.Processor.type] and
	// [Processor.display_name][google.cloud.documentai.v1.Processor.display_name]
	// to be set. Also, the
	// [Processor.kms_key_name][google.cloud.documentai.v1.Processor.kms_key_name]
	// field must be set if the processor is under CMEK.
	Processor *Processor `protobuf:"bytes,2,opt,name=processor,proto3" json:"processor,omitempty"`
}

func (x *CreateProcessorRequest) Reset() {
	*x = CreateProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProcessorRequest) ProtoMessage() {}

func (x *CreateProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProcessorRequest.ProtoReflect.Descriptor instead.
func (*CreateProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{26}
}

func (x *CreateProcessorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProcessorRequest) GetProcessor() *Processor {
	if x != nil {
		return x.Processor
	}
	return nil
}

// Request message for the
// [DeleteProcessor][google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessor]
// method.
type DeleteProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProcessorRequest) Reset() {
	*x = DeleteProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorRequest) ProtoMessage() {}

func (x *DeleteProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorRequest.ProtoReflect.Descriptor instead.
func (*DeleteProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The long-running operation metadata for the
// [DeleteProcessor][google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessor]
// method.
type DeleteProcessorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DeleteProcessorMetadata) Reset() {
	*x = DeleteProcessorMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessorMetadata) ProtoMessage() {}

func (x *DeleteProcessorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessorMetadata.ProtoReflect.Descriptor instead.
func (*DeleteProcessorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{28}
}

func (x *DeleteProcessorMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the
// [EnableProcessor][google.cloud.documentai.v1.DocumentProcessorService.EnableProcessor]
// method.
type EnableProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name to be enabled.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EnableProcessorRequest) Reset() {
	*x = EnableProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableProcessorRequest) ProtoMessage() {}

func (x *EnableProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableProcessorRequest.ProtoReflect.Descriptor instead.
func (*EnableProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{29}
}

func (x *EnableProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the
// [EnableProcessor][google.cloud.documentai.v1.DocumentProcessorService.EnableProcessor]
// method. Intentionally empty proto for adding fields in future.
type EnableProcessorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EnableProcessorResponse) Reset() {
	*x = EnableProcessorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableProcessorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableProcessorResponse) ProtoMessage() {}

func (x *EnableProcessorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableProcessorResponse.ProtoReflect.Descriptor instead.
func (*EnableProcessorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{30}
}

// The long-running operation metadata for the
// [EnableProcessor][google.cloud.documentai.v1.DocumentProcessorService.EnableProcessor]
// method.
type EnableProcessorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *EnableProcessorMetadata) Reset() {
	*x = EnableProcessorMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnableProcessorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableProcessorMetadata) ProtoMessage() {}

func (x *EnableProcessorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableProcessorMetadata.ProtoReflect.Descriptor instead.
func (*EnableProcessorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{31}
}

func (x *EnableProcessorMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the
// [DisableProcessor][google.cloud.documentai.v1.DocumentProcessorService.DisableProcessor]
// method.
type DisableProcessorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name to be disabled.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DisableProcessorRequest) Reset() {
	*x = DisableProcessorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableProcessorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableProcessorRequest) ProtoMessage() {}

func (x *DisableProcessorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableProcessorRequest.ProtoReflect.Descriptor instead.
func (*DisableProcessorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{32}
}

func (x *DisableProcessorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for the
// [DisableProcessor][google.cloud.documentai.v1.DocumentProcessorService.DisableProcessor]
// method. Intentionally empty proto for adding fields in future.
type DisableProcessorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisableProcessorResponse) Reset() {
	*x = DisableProcessorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableProcessorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableProcessorResponse) ProtoMessage() {}

func (x *DisableProcessorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableProcessorResponse.ProtoReflect.Descriptor instead.
func (*DisableProcessorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{33}
}

// The long-running operation metadata for the
// [DisableProcessor][google.cloud.documentai.v1.DocumentProcessorService.DisableProcessor]
// method.
type DisableProcessorMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *DisableProcessorMetadata) Reset() {
	*x = DisableProcessorMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisableProcessorMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableProcessorMetadata) ProtoMessage() {}

func (x *DisableProcessorMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableProcessorMetadata.ProtoReflect.Descriptor instead.
func (*DisableProcessorMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{34}
}

func (x *DisableProcessorMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the
// [SetDefaultProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.SetDefaultProcessorVersion]
// method.
type SetDefaultProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the
	// [Processor][google.cloud.documentai.v1.Processor] to change default
	// version.
	Processor string `protobuf:"bytes,1,opt,name=processor,proto3" json:"processor,omitempty"`
	// Required. The resource name of child
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion] to use as
	// default. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{version}`
	DefaultProcessorVersion string `protobuf:"bytes,2,opt,name=default_processor_version,json=defaultProcessorVersion,proto3" json:"default_processor_version,omitempty"`
}

func (x *SetDefaultProcessorVersionRequest) Reset() {
	*x = SetDefaultProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetDefaultProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDefaultProcessorVersionRequest) ProtoMessage() {}

func (x *SetDefaultProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDefaultProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*SetDefaultProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{35}
}

func (x *SetDefaultProcessorVersionRequest) GetProcessor() string {
	if x != nil {
		return x.Processor
	}
	return ""
}

func (x *SetDefaultProcessorVersionRequest) GetDefaultProcessorVersion() string {
	if x != nil {
		return x.DefaultProcessorVersion
	}
	return ""
}

// Response message for the
// [SetDefaultProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.SetDefaultProcessorVersion]
// method.
type SetDefaultProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetDefaultProcessorVersionResponse) Reset() {
	*x = SetDefaultProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetDefaultProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDefaultProcessorVersionResponse) ProtoMessage() {}

func (x *SetDefaultProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDefaultProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*SetDefaultProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{36}
}

// The long-running operation metadata for the
// [SetDefaultProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.SetDefaultProcessorVersion]
// method.
type SetDefaultProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *SetDefaultProcessorVersionMetadata) Reset() {
	*x = SetDefaultProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetDefaultProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetDefaultProcessorVersionMetadata) ProtoMessage() {}

func (x *SetDefaultProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetDefaultProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*SetDefaultProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{37}
}

func (x *SetDefaultProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Request message for the
// [TrainProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.TrainProcessorVersion]
// method.
type TrainProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ProcessorFlags:
	//
	//	*TrainProcessorVersionRequest_CustomDocumentExtractionOptions_
	//	*TrainProcessorVersionRequest_FoundationModelTuningOptions_
	ProcessorFlags isTrainProcessorVersionRequest_ProcessorFlags `protobuf_oneof:"processor_flags"`
	// Required. The parent (project, location and processor) to create the new
	// version for. Format:
	// `projects/{project}/locations/{location}/processors/{processor}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The processor version to be created.
	ProcessorVersion *ProcessorVersion `protobuf:"bytes,2,opt,name=processor_version,json=processorVersion,proto3" json:"processor_version,omitempty"`
	// Optional. The schema the processor version will be trained with.
	DocumentSchema *DocumentSchema `protobuf:"bytes,10,opt,name=document_schema,json=documentSchema,proto3" json:"document_schema,omitempty"`
	// Optional. The input data used to train the
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
	InputData *TrainProcessorVersionRequest_InputData `protobuf:"bytes,4,opt,name=input_data,json=inputData,proto3" json:"input_data,omitempty"`
	// Optional. The processor version to use as a base for training. This
	// processor version must be a child of `parent`. Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
	BaseProcessorVersion string `protobuf:"bytes,8,opt,name=base_processor_version,json=baseProcessorVersion,proto3" json:"base_processor_version,omitempty"`
}

func (x *TrainProcessorVersionRequest) Reset() {
	*x = TrainProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainProcessorVersionRequest) ProtoMessage() {}

func (x *TrainProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*TrainProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{38}
}

func (m *TrainProcessorVersionRequest) GetProcessorFlags() isTrainProcessorVersionRequest_ProcessorFlags {
	if m != nil {
		return m.ProcessorFlags
	}
	return nil
}

func (x *TrainProcessorVersionRequest) GetCustomDocumentExtractionOptions() *TrainProcessorVersionRequest_CustomDocumentExtractionOptions {
	if x, ok := x.GetProcessorFlags().(*TrainProcessorVersionRequest_CustomDocumentExtractionOptions_); ok {
		return x.CustomDocumentExtractionOptions
	}
	return nil
}

func (x *TrainProcessorVersionRequest) GetFoundationModelTuningOptions() *TrainProcessorVersionRequest_FoundationModelTuningOptions {
	if x, ok := x.GetProcessorFlags().(*TrainProcessorVersionRequest_FoundationModelTuningOptions_); ok {
		return x.FoundationModelTuningOptions
	}
	return nil
}

func (x *TrainProcessorVersionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TrainProcessorVersionRequest) GetProcessorVersion() *ProcessorVersion {
	if x != nil {
		return x.ProcessorVersion
	}
	return nil
}

func (x *TrainProcessorVersionRequest) GetDocumentSchema() *DocumentSchema {
	if x != nil {
		return x.DocumentSchema
	}
	return nil
}

func (x *TrainProcessorVersionRequest) GetInputData() *TrainProcessorVersionRequest_InputData {
	if x != nil {
		return x.InputData
	}
	return nil
}

func (x *TrainProcessorVersionRequest) GetBaseProcessorVersion() string {
	if x != nil {
		return x.BaseProcessorVersion
	}
	return ""
}

type isTrainProcessorVersionRequest_ProcessorFlags interface {
	isTrainProcessorVersionRequest_ProcessorFlags()
}

type TrainProcessorVersionRequest_CustomDocumentExtractionOptions_ struct {
	// Options to control Custom Document Extraction (CDE) Processor.
	CustomDocumentExtractionOptions *TrainProcessorVersionRequest_CustomDocumentExtractionOptions `protobuf:"bytes,5,opt,name=custom_document_extraction_options,json=customDocumentExtractionOptions,proto3,oneof"`
}

type TrainProcessorVersionRequest_FoundationModelTuningOptions_ struct {
	// Options to control foundation model tuning of a processor.
	FoundationModelTuningOptions *TrainProcessorVersionRequest_FoundationModelTuningOptions `protobuf:"bytes,12,opt,name=foundation_model_tuning_options,json=foundationModelTuningOptions,proto3,oneof"`
}

func (*TrainProcessorVersionRequest_CustomDocumentExtractionOptions_) isTrainProcessorVersionRequest_ProcessorFlags() {
}

func (*TrainProcessorVersionRequest_FoundationModelTuningOptions_) isTrainProcessorVersionRequest_ProcessorFlags() {
}

// The response for
// [TrainProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.TrainProcessorVersion].
type TrainProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the processor version produced by training.
	ProcessorVersion string `protobuf:"bytes,1,opt,name=processor_version,json=processorVersion,proto3" json:"processor_version,omitempty"`
}

func (x *TrainProcessorVersionResponse) Reset() {
	*x = TrainProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainProcessorVersionResponse) ProtoMessage() {}

func (x *TrainProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*TrainProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{39}
}

func (x *TrainProcessorVersionResponse) GetProcessorVersion() string {
	if x != nil {
		return x.ProcessorVersion
	}
	return ""
}

// The metadata that represents a processor version being created.
type TrainProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// The training dataset validation information.
	TrainingDatasetValidation *TrainProcessorVersionMetadata_DatasetValidation `protobuf:"bytes,2,opt,name=training_dataset_validation,json=trainingDatasetValidation,proto3" json:"training_dataset_validation,omitempty"`
	// The test dataset validation information.
	TestDatasetValidation *TrainProcessorVersionMetadata_DatasetValidation `protobuf:"bytes,3,opt,name=test_dataset_validation,json=testDatasetValidation,proto3" json:"test_dataset_validation,omitempty"`
}

func (x *TrainProcessorVersionMetadata) Reset() {
	*x = TrainProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainProcessorVersionMetadata) ProtoMessage() {}

func (x *TrainProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*TrainProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{40}
}

func (x *TrainProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *TrainProcessorVersionMetadata) GetTrainingDatasetValidation() *TrainProcessorVersionMetadata_DatasetValidation {
	if x != nil {
		return x.TrainingDatasetValidation
	}
	return nil
}

func (x *TrainProcessorVersionMetadata) GetTestDatasetValidation() *TrainProcessorVersionMetadata_DatasetValidation {
	if x != nil {
		return x.TestDatasetValidation
	}
	return nil
}

// Request message for the
// [ReviewDocument][google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument]
// method.
type ReviewDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload.
	//
	// Types that are assignable to Source:
	//
	//	*ReviewDocumentRequest_InlineDocument
	Source isReviewDocumentRequest_Source `protobuf_oneof:"source"`
	// Required. The resource name of the
	// [HumanReviewConfig][google.cloud.documentai.v1.HumanReviewConfig] that the
	// document will be reviewed with.
	HumanReviewConfig string `protobuf:"bytes,1,opt,name=human_review_config,json=humanReviewConfig,proto3" json:"human_review_config,omitempty"`
	// Whether the validation should be performed on the ad-hoc review request.
	EnableSchemaValidation bool `protobuf:"varint,3,opt,name=enable_schema_validation,json=enableSchemaValidation,proto3" json:"enable_schema_validation,omitempty"`
	// The priority of the human review task.
	Priority ReviewDocumentRequest_Priority `protobuf:"varint,5,opt,name=priority,proto3,enum=google.cloud.documentai.v1.ReviewDocumentRequest_Priority" json:"priority,omitempty"`
	// The document schema of the human review task.
	DocumentSchema *DocumentSchema `protobuf:"bytes,6,opt,name=document_schema,json=documentSchema,proto3" json:"document_schema,omitempty"`
}

func (x *ReviewDocumentRequest) Reset() {
	*x = ReviewDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentRequest) ProtoMessage() {}

func (x *ReviewDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentRequest.ProtoReflect.Descriptor instead.
func (*ReviewDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{41}
}

func (m *ReviewDocumentRequest) GetSource() isReviewDocumentRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ReviewDocumentRequest) GetInlineDocument() *Document {
	if x, ok := x.GetSource().(*ReviewDocumentRequest_InlineDocument); ok {
		return x.InlineDocument
	}
	return nil
}

func (x *ReviewDocumentRequest) GetHumanReviewConfig() string {
	if x != nil {
		return x.HumanReviewConfig
	}
	return ""
}

func (x *ReviewDocumentRequest) GetEnableSchemaValidation() bool {
	if x != nil {
		return x.EnableSchemaValidation
	}
	return false
}

func (x *ReviewDocumentRequest) GetPriority() ReviewDocumentRequest_Priority {
	if x != nil {
		return x.Priority
	}
	return ReviewDocumentRequest_DEFAULT
}

func (x *ReviewDocumentRequest) GetDocumentSchema() *DocumentSchema {
	if x != nil {
		return x.DocumentSchema
	}
	return nil
}

type isReviewDocumentRequest_Source interface {
	isReviewDocumentRequest_Source()
}

type ReviewDocumentRequest_InlineDocument struct {
	// An inline document proto.
	InlineDocument *Document `protobuf:"bytes,4,opt,name=inline_document,json=inlineDocument,proto3,oneof"`
}

func (*ReviewDocumentRequest_InlineDocument) isReviewDocumentRequest_Source() {}

// Response message for the
// [ReviewDocument][google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument]
// method.
type ReviewDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage uri for the human reviewed document if the review is
	// succeeded.
	GcsDestination string `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
	// The state of the review operation.
	State ReviewDocumentResponse_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.documentai.v1.ReviewDocumentResponse_State" json:"state,omitempty"`
	// The reason why the review is rejected by reviewer.
	RejectionReason string `protobuf:"bytes,3,opt,name=rejection_reason,json=rejectionReason,proto3" json:"rejection_reason,omitempty"`
}

func (x *ReviewDocumentResponse) Reset() {
	*x = ReviewDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentResponse) ProtoMessage() {}

func (x *ReviewDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentResponse.ProtoReflect.Descriptor instead.
func (*ReviewDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{42}
}

func (x *ReviewDocumentResponse) GetGcsDestination() string {
	if x != nil {
		return x.GcsDestination
	}
	return ""
}

func (x *ReviewDocumentResponse) GetState() ReviewDocumentResponse_State {
	if x != nil {
		return x.State
	}
	return ReviewDocumentResponse_STATE_UNSPECIFIED
}

func (x *ReviewDocumentResponse) GetRejectionReason() string {
	if x != nil {
		return x.RejectionReason
	}
	return ""
}

// The long-running operation metadata for the
// [ReviewDocument][google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument]
// method.
type ReviewDocumentOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
	// The Crowd Compute question ID.
	QuestionId string `protobuf:"bytes,6,opt,name=question_id,json=questionId,proto3" json:"question_id,omitempty"`
}

func (x *ReviewDocumentOperationMetadata) Reset() {
	*x = ReviewDocumentOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentOperationMetadata) ProtoMessage() {}

func (x *ReviewDocumentOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentOperationMetadata.ProtoReflect.Descriptor instead.
func (*ReviewDocumentOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{43}
}

func (x *ReviewDocumentOperationMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

func (x *ReviewDocumentOperationMetadata) GetQuestionId() string {
	if x != nil {
		return x.QuestionId
	}
	return ""
}

// Evaluates the given
// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion] against the
// supplied documents.
type EvaluateProcessorVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion] to
	// evaluate.
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
	ProcessorVersion string `protobuf:"bytes,1,opt,name=processor_version,json=processorVersion,proto3" json:"processor_version,omitempty"`
	// Optional. The documents used in the evaluation. If unspecified, use the
	// processor's dataset as evaluation input.
	EvaluationDocuments *BatchDocumentsInputConfig `protobuf:"bytes,3,opt,name=evaluation_documents,json=evaluationDocuments,proto3" json:"evaluation_documents,omitempty"`
}

func (x *EvaluateProcessorVersionRequest) Reset() {
	*x = EvaluateProcessorVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluateProcessorVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluateProcessorVersionRequest) ProtoMessage() {}

func (x *EvaluateProcessorVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluateProcessorVersionRequest.ProtoReflect.Descriptor instead.
func (*EvaluateProcessorVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{44}
}

func (x *EvaluateProcessorVersionRequest) GetProcessorVersion() string {
	if x != nil {
		return x.ProcessorVersion
	}
	return ""
}

func (x *EvaluateProcessorVersionRequest) GetEvaluationDocuments() *BatchDocumentsInputConfig {
	if x != nil {
		return x.EvaluationDocuments
	}
	return nil
}

// Metadata of the
// [EvaluateProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.EvaluateProcessorVersion]
// method.
type EvaluateProcessorVersionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long-running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,1,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *EvaluateProcessorVersionMetadata) Reset() {
	*x = EvaluateProcessorVersionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluateProcessorVersionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluateProcessorVersionMetadata) ProtoMessage() {}

func (x *EvaluateProcessorVersionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluateProcessorVersionMetadata.ProtoReflect.Descriptor instead.
func (*EvaluateProcessorVersionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{45}
}

func (x *EvaluateProcessorVersionMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// Response of the
// [EvaluateProcessorVersion][google.cloud.documentai.v1.DocumentProcessorService.EvaluateProcessorVersion]
// method.
type EvaluateProcessorVersionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the created evaluation.
	Evaluation string `protobuf:"bytes,2,opt,name=evaluation,proto3" json:"evaluation,omitempty"`
}

func (x *EvaluateProcessorVersionResponse) Reset() {
	*x = EvaluateProcessorVersionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluateProcessorVersionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluateProcessorVersionResponse) ProtoMessage() {}

func (x *EvaluateProcessorVersionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluateProcessorVersionResponse.ProtoReflect.Descriptor instead.
func (*EvaluateProcessorVersionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{46}
}

func (x *EvaluateProcessorVersionResponse) GetEvaluation() string {
	if x != nil {
		return x.Evaluation
	}
	return ""
}

// Retrieves a specific Evaluation.
type GetEvaluationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the
	// [Evaluation][google.cloud.documentai.v1.Evaluation] to get.
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}/evaluations/{evaluation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEvaluationRequest) Reset() {
	*x = GetEvaluationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEvaluationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEvaluationRequest) ProtoMessage() {}

func (x *GetEvaluationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEvaluationRequest.ProtoReflect.Descriptor instead.
func (*GetEvaluationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{47}
}

func (x *GetEvaluationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Retrieves a list of evaluations for a given
// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
type ListEvaluationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the
	// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion] to list
	// evaluations for.
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The standard list page size.
	// If unspecified, at most `5` evaluations are returned.
	// The maximum value is `100`. Values above `100` are coerced to `100`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListEvaluations` call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEvaluationsRequest) Reset() {
	*x = ListEvaluationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEvaluationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEvaluationsRequest) ProtoMessage() {}

func (x *ListEvaluationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEvaluationsRequest.ProtoReflect.Descriptor instead.
func (*ListEvaluationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{48}
}

func (x *ListEvaluationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEvaluationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEvaluationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from `ListEvaluations`.
type ListEvaluationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The evaluations requested.
	Evaluations []*Evaluation `protobuf:"bytes,1,rep,name=evaluations,proto3" json:"evaluations,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEvaluationsResponse) Reset() {
	*x = ListEvaluationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEvaluationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEvaluationsResponse) ProtoMessage() {}

func (x *ListEvaluationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEvaluationsResponse.ProtoReflect.Descriptor instead.
func (*ListEvaluationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{49}
}

func (x *ListEvaluationsResponse) GetEvaluations() []*Evaluation {
	if x != nil {
		return x.Evaluations
	}
	return nil
}

func (x *ListEvaluationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A list of individual page numbers.
type ProcessOptions_IndividualPageSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Indices of the pages (starting from 1).
	Pages []int32 `protobuf:"varint,1,rep,packed,name=pages,proto3" json:"pages,omitempty"`
}

func (x *ProcessOptions_IndividualPageSelector) Reset() {
	*x = ProcessOptions_IndividualPageSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessOptions_IndividualPageSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessOptions_IndividualPageSelector) ProtoMessage() {}

func (x *ProcessOptions_IndividualPageSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessOptions_IndividualPageSelector.ProtoReflect.Descriptor instead.
func (*ProcessOptions_IndividualPageSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ProcessOptions_IndividualPageSelector) GetPages() []int32 {
	if x != nil {
		return x.Pages
	}
	return nil
}

// The status of a each individual document in the batch process.
type BatchProcessMetadata_IndividualProcessStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the document, same as the
	// [input_gcs_source][google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus.input_gcs_source]
	// field in the request when the batch process started.
	InputGcsSource string `protobuf:"bytes,1,opt,name=input_gcs_source,json=inputGcsSource,proto3" json:"input_gcs_source,omitempty"`
	// The status processing the document.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// The Cloud Storage output destination (in the request as
	// [DocumentOutputConfig.GcsOutputConfig.gcs_uri][google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.gcs_uri])
	// of the processed document if it was successful, otherwise empty.
	OutputGcsDestination string `protobuf:"bytes,3,opt,name=output_gcs_destination,json=outputGcsDestination,proto3" json:"output_gcs_destination,omitempty"`
	// The status of human review on the processed document.
	HumanReviewStatus *HumanReviewStatus `protobuf:"bytes,5,opt,name=human_review_status,json=humanReviewStatus,proto3" json:"human_review_status,omitempty"`
}

func (x *BatchProcessMetadata_IndividualProcessStatus) Reset() {
	*x = BatchProcessMetadata_IndividualProcessStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessMetadata_IndividualProcessStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessMetadata_IndividualProcessStatus) ProtoMessage() {}

func (x *BatchProcessMetadata_IndividualProcessStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessMetadata_IndividualProcessStatus.ProtoReflect.Descriptor instead.
func (*BatchProcessMetadata_IndividualProcessStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetInputGcsSource() string {
	if x != nil {
		return x.InputGcsSource
	}
	return ""
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetOutputGcsDestination() string {
	if x != nil {
		return x.OutputGcsDestination
	}
	return ""
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetHumanReviewStatus() *HumanReviewStatus {
	if x != nil {
		return x.HumanReviewStatus
	}
	return nil
}

// The input data used to train a new
// [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
type TrainProcessorVersionRequest_InputData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The documents used for training the new version.
	TrainingDocuments *BatchDocumentsInputConfig `protobuf:"bytes,3,opt,name=training_documents,json=trainingDocuments,proto3" json:"training_documents,omitempty"`
	// The documents used for testing the trained version.
	TestDocuments *BatchDocumentsInputConfig `protobuf:"bytes,4,opt,name=test_documents,json=testDocuments,proto3" json:"test_documents,omitempty"`
}

func (x *TrainProcessorVersionRequest_InputData) Reset() {
	*x = TrainProcessorVersionRequest_InputData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainProcessorVersionRequest_InputData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainProcessorVersionRequest_InputData) ProtoMessage() {}

func (x *TrainProcessorVersionRequest_InputData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainProcessorVersionRequest_InputData.ProtoReflect.Descriptor instead.
func (*TrainProcessorVersionRequest_InputData) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{38, 0}
}

func (x *TrainProcessorVersionRequest_InputData) GetTrainingDocuments() *BatchDocumentsInputConfig {
	if x != nil {
		return x.TrainingDocuments
	}
	return nil
}

func (x *TrainProcessorVersionRequest_InputData) GetTestDocuments() *BatchDocumentsInputConfig {
	if x != nil {
		return x.TestDocuments
	}
	return nil
}

// Options to control the training of the Custom Document Extraction (CDE)
// Processor.
type TrainProcessorVersionRequest_CustomDocumentExtractionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Training method to use for CDE training.
	TrainingMethod TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod `protobuf:"varint,3,opt,name=training_method,json=trainingMethod,proto3,enum=google.cloud.documentai.v1.TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod" json:"training_method,omitempty"`
}

func (x *TrainProcessorVersionRequest_CustomDocumentExtractionOptions) Reset() {
	*x = TrainProcessorVersionRequest_CustomDocumentExtractionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainProcessorVersionRequest_CustomDocumentExtractionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainProcessorVersionRequest_CustomDocumentExtractionOptions) ProtoMessage() {}

func (x *TrainProcessorVersionRequest_CustomDocumentExtractionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainProcessorVersionRequest_CustomDocumentExtractionOptions.ProtoReflect.Descriptor instead.
func (*TrainProcessorVersionRequest_CustomDocumentExtractionOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{38, 1}
}

func (x *TrainProcessorVersionRequest_CustomDocumentExtractionOptions) GetTrainingMethod() TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod {
	if x != nil {
		return x.TrainingMethod
	}
	return TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TRAINING_METHOD_UNSPECIFIED
}

// Options to control foundation model tuning of the processor.
type TrainProcessorVersionRequest_FoundationModelTuningOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The number of steps to run for model tuning. Valid values are
	// between 1 and 400. If not provided, recommended steps will be used.
	TrainSteps int32 `protobuf:"varint,2,opt,name=train_steps,json=trainSteps,proto3" json:"train_steps,omitempty"`
	// Optional. The multiplier to apply to the recommended learning rate. Valid
	// values are between 0.1 and 10. If not provided, recommended learning rate
	// will be used.
	LearningRateMultiplier float32 `protobuf:"fixed32,3,opt,name=learning_rate_multiplier,json=learningRateMultiplier,proto3" json:"learning_rate_multiplier,omitempty"`
}

func (x *TrainProcessorVersionRequest_FoundationModelTuningOptions) Reset() {
	*x = TrainProcessorVersionRequest_FoundationModelTuningOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainProcessorVersionRequest_FoundationModelTuningOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainProcessorVersionRequest_FoundationModelTuningOptions) ProtoMessage() {}

func (x *TrainProcessorVersionRequest_FoundationModelTuningOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainProcessorVersionRequest_FoundationModelTuningOptions.ProtoReflect.Descriptor instead.
func (*TrainProcessorVersionRequest_FoundationModelTuningOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{38, 2}
}

func (x *TrainProcessorVersionRequest_FoundationModelTuningOptions) GetTrainSteps() int32 {
	if x != nil {
		return x.TrainSteps
	}
	return 0
}

func (x *TrainProcessorVersionRequest_FoundationModelTuningOptions) GetLearningRateMultiplier() float32 {
	if x != nil {
		return x.LearningRateMultiplier
	}
	return 0
}

// The dataset validation information.
// This includes any and all errors with documents and the dataset.
type TrainProcessorVersionMetadata_DatasetValidation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of document errors.
	DocumentErrorCount int32 `protobuf:"varint,3,opt,name=document_error_count,json=documentErrorCount,proto3" json:"document_error_count,omitempty"`
	// The total number of dataset errors.
	DatasetErrorCount int32 `protobuf:"varint,4,opt,name=dataset_error_count,json=datasetErrorCount,proto3" json:"dataset_error_count,omitempty"`
	// Error information pertaining to specific documents. A maximum of 10
	// document errors will be returned.
	// Any document with errors will not be used throughout training.
	DocumentErrors []*status.Status `protobuf:"bytes,1,rep,name=document_errors,json=documentErrors,proto3" json:"document_errors,omitempty"`
	// Error information for the dataset as a whole. A maximum of 10 dataset
	// errors will be returned.
	// A single dataset error is terminal for training.
	DatasetErrors []*status.Status `protobuf:"bytes,2,rep,name=dataset_errors,json=datasetErrors,proto3" json:"dataset_errors,omitempty"`
}

func (x *TrainProcessorVersionMetadata_DatasetValidation) Reset() {
	*x = TrainProcessorVersionMetadata_DatasetValidation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainProcessorVersionMetadata_DatasetValidation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainProcessorVersionMetadata_DatasetValidation) ProtoMessage() {}

func (x *TrainProcessorVersionMetadata_DatasetValidation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainProcessorVersionMetadata_DatasetValidation.ProtoReflect.Descriptor instead.
func (*TrainProcessorVersionMetadata_DatasetValidation) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{40, 0}
}

func (x *TrainProcessorVersionMetadata_DatasetValidation) GetDocumentErrorCount() int32 {
	if x != nil {
		return x.DocumentErrorCount
	}
	return 0
}

func (x *TrainProcessorVersionMetadata_DatasetValidation) GetDatasetErrorCount() int32 {
	if x != nil {
		return x.DatasetErrorCount
	}
	return 0
}

func (x *TrainProcessorVersionMetadata_DatasetValidation) GetDocumentErrors() []*status.Status {
	if x != nil {
		return x.DocumentErrors
	}
	return nil
}

func (x *TrainProcessorVersionMetadata_DatasetValidation) GetDatasetErrors() []*status.Status {
	if x != nil {
		return x.DatasetErrors
	}
	return nil
}

var File_google_cloud_documentai_v1_document_processor_service_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76,
	0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76,
	0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb0, 0x03, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7d, 0x0a, 0x18, 0x69, 0x6e, 0x64, 0x69, 0x76,
	0x69, 0x64, 0x75, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c,
	0x50, 0x61, 0x67, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x16,
	0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x50, 0x61, 0x67, 0x65, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x66, 0x72,
	0x6f, 0x6d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x1b, 0x0a, 0x08, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x65, 0x6e, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x07, 0x66, 0x72, 0x6f,
	0x6d, 0x45, 0x6e, 0x64, 0x12, 0x44, 0x0a, 0x0a, 0x6f, 0x63, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x63, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x6f, 0x63, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x1a, 0x33, 0x0a, 0x16, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75,
	0x61, 0x6c, 0x50, 0x61, 0x67, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x19,
	0x0a, 0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xf2, 0x04, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0f, 0x69, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x0c, 0x72,
	0x61, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x61,
	0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x0c, 0x67, 0x63, 0x73,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x63, 0x73, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x68,
	0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x53, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x99, 0x02, 0x0a,
	0x11, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50,
	0x50, 0x45, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b,
	0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x22, 0xb2, 0x01, 0x0a, 0x0f, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5d,
	0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x11, 0x68, 0x75, 0x6d, 0x61,
	0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x92, 0x04,
	0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x66, 0x0a, 0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x11,
	0x73, 0x6b, 0x69, 0x70, 0x5f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x48, 0x75, 0x6d,
	0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x53, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x16, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x89, 0x06, 0x0a, 0x14, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x88, 0x01, 0x0a, 0x1b, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x5f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64,
	0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x19, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x1a, 0x84, 0x02, 0x0a, 0x17,
	0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x34, 0x0a,
	0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75,
	0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x22, 0x65, 0x0a, 0x1a, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x71, 0x0a,
	0x1b, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x22, 0xa0, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x52, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x12, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x5e, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x56, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x1a, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa6, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x1d, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x12,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x67, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7e, 0x0a, 0x1e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x67, 0x0a, 0x1d, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x20, 0x0a, 0x1e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7e, 0x0a, 0x1e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x69, 0x0a, 0x1f, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x22, 0x0a, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa7, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x22, 0x59, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x77, 0x0a, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x59, 0x0a, 0x16, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x19, 0x0a, 0x17, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x77, 0x0a, 0x17, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x5a, 0x0a, 0x17, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x1a, 0x0a, 0x18, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x78, 0x0a, 0x18,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xde, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x74, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x09,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x6e, 0x0a, 0x19, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x24, 0x0a, 0x22, 0x53, 0x65, 0x74, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x82, 0x01,
	0x0a, 0x22, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x85, 0x0b, 0x0a, 0x1c, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0xa7, 0x01, 0x0a, 0x22, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x1f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x9e, 0x01,
	0x0a, 0x1f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00,
	0x52, 0x1c, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x66, 0x0a,
	0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x16, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x62, 0x61, 0x73, 0x65,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x1a, 0xcf, 0x01, 0x0a, 0x09, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x64,
	0x0a, 0x12, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x11, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x5c, 0x0a, 0x0e, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0d, 0x74, 0x65, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x1a, 0x8c, 0x02, 0x0a, 0x1f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x90, 0x01, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x56, 0x0a, 0x0e, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1f, 0x0a, 0x1b, 0x54,
	0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b,
	0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x12, 0x0a,
	0x0e, 0x54, 0x45, 0x4d, 0x50, 0x4c, 0x41, 0x54, 0x45, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x44, 0x10,
	0x02, 0x1a, 0x83, 0x01, 0x0a, 0x1c, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x73, 0x74, 0x65, 0x70,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0x3d, 0x0a, 0x18, 0x6c, 0x65, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70,
	0x6c, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x16, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65, 0x4d, 0x75, 0x6c,
	0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x42, 0x11, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x4c, 0x0a, 0x1d, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x05, 0x0a, 0x1d, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x8b, 0x01, 0x0a, 0x1b, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69,
	0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x19, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x17, 0x74, 0x65, 0x73, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x74, 0x65, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xed, 0x01, 0x0a,
	0x11, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x12, 0x39, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0xe3, 0x03, 0x0a,
	0x15, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e,
	0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x18,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x53,
	0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x22, 0x23, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x55, 0x52, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a,
	0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x22, 0x3b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x22, 0xa0,
	0x01, 0x0a, 0x1f, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x1f, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x22, 0xf1, 0x01, 0x0a, 0x1f, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x14, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x80, 0x01, 0x0a, 0x20, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x42, 0x0a, 0x20, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x58, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8b, 0x01, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x9c, 0x2a, 0x0a, 0x18, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x87, 0x02, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x9a, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x8c, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0xbd,
	0x02, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd3, 0x01, 0xca, 0x41, 0x2c, 0x0a, 0x14,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x96, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x54, 0x3a, 0x01, 0x2a,
	0x22, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0xd0,
	0x01, 0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65,
	0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0xc8, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xb5, 0x01, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34,
	0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12,
	0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x12,
	0xa5, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa2, 0x02, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x69,
	0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaf, 0x01, 0xca, 0x41, 0x3e,
	0x0a, 0x1d, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1d, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a,
	0x01, 0x2a, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x12, 0xce, 0x01, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x80, 0x02, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8b, 0x01, 0xca, 0x41, 0x37, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x2a, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x02, 0x0a, 0x16, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x01, 0xca, 0x41, 0x40, 0x0a,
	0x1e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22,
	0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x9d, 0x02, 0x0a, 0x18, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0xca, 0x41, 0x44, 0x0a, 0x20, 0x55, 0x6e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x55, 0x6e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0xc2, 0x01, 0x0a, 0x0f, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22, 0x54, 0xda, 0x41, 0x10, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x22,
	0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x12,
	0xd6, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdb, 0x01, 0x0a, 0x0f, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x75, 0xca, 0x41, 0x32, 0x0a, 0x17, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22,
	0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x12, 0xe0, 0x01, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x78, 0xca, 0x41, 0x34, 0x0a, 0x18, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01,
	0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x12, 0xa1, 0x02, 0x0a, 0x1a, 0x53, 0x65,
	0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x22, 0x53, 0x65,
	0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x22, 0x53, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0xa0, 0x02,
	0x0a, 0x0e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xbb, 0x01, 0xca, 0x41, 0x39, 0x0a, 0x16, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1f, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x3a, 0x01, 0x2a,
	0x22, 0x5e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x68,
	0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x7d, 0x3a, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0xc7, 0x02, 0x0a, 0x18, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xce, 0x01, 0xca, 0x41, 0x44, 0x0a,
	0x20, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x20, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6d, 0x3a, 0x01, 0x2a,
	0x22, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0xca, 0x01, 0x0a, 0x0d, 0x47,
	0x65, 0x74, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xaa, 0x03, 0xea, 0x41, 0x7f, 0x0a, 0x2b, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x7d, 0x2f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xea, 0x41, 0x4d, 0x0a, 0x22,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x1e, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x69, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0x3b, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData = file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc
)

func file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData
}

var file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes = make([]protoimpl.MessageInfo, 58)
var file_google_cloud_documentai_v1_document_processor_service_proto_goTypes = []interface{}{
	(HumanReviewStatus_State)(0),    // 0: google.cloud.documentai.v1.HumanReviewStatus.State
	(BatchProcessMetadata_State)(0), // 1: google.cloud.documentai.v1.BatchProcessMetadata.State
	(TrainProcessorVersionRequest_CustomDocumentExtractionOptions_TrainingMethod)(0), // 2: google.cloud.documentai.v1.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod
	(ReviewDocumentRequest_Priority)(0),                                              // 3: google.cloud.documentai.v1.ReviewDocumentRequest.Priority
	(ReviewDocumentResponse_State)(0),                                                // 4: google.cloud.documentai.v1.ReviewDocumentResponse.State
	(*ProcessOptions)(nil),                                                           // 5: google.cloud.documentai.v1.ProcessOptions
	(*ProcessRequest)(nil),                                                           // 6: google.cloud.documentai.v1.ProcessRequest
	(*HumanReviewStatus)(nil),                                                        // 7: google.cloud.documentai.v1.HumanReviewStatus
	(*ProcessResponse)(nil),                                                          // 8: google.cloud.documentai.v1.ProcessResponse
	(*BatchProcessRequest)(nil),                                                      // 9: google.cloud.documentai.v1.BatchProcessRequest
	(*BatchProcessResponse)(nil),                                                     // 10: google.cloud.documentai.v1.BatchProcessResponse
	(*BatchProcessMetadata)(nil),                                                     // 11: google.cloud.documentai.v1.BatchProcessMetadata
	(*FetchProcessorTypesRequest)(nil),                                               // 12: google.cloud.documentai.v1.FetchProcessorTypesRequest
	(*FetchProcessorTypesResponse)(nil),                                              // 13: google.cloud.documentai.v1.FetchProcessorTypesResponse
	(*ListProcessorTypesRequest)(nil),                                                // 14: google.cloud.documentai.v1.ListProcessorTypesRequest
	(*ListProcessorTypesResponse)(nil),                                               // 15: google.cloud.documentai.v1.ListProcessorTypesResponse
	(*ListProcessorsRequest)(nil),                                                    // 16: google.cloud.documentai.v1.ListProcessorsRequest
	(*ListProcessorsResponse)(nil),                                                   // 17: google.cloud.documentai.v1.ListProcessorsResponse
	(*GetProcessorTypeRequest)(nil),                                                  // 18: google.cloud.documentai.v1.GetProcessorTypeRequest
	(*GetProcessorRequest)(nil),                                                      // 19: google.cloud.documentai.v1.GetProcessorRequest
	(*GetProcessorVersionRequest)(nil),                                               // 20: google.cloud.documentai.v1.GetProcessorVersionRequest
	(*ListProcessorVersionsRequest)(nil),                                             // 21: google.cloud.documentai.v1.ListProcessorVersionsRequest
	(*ListProcessorVersionsResponse)(nil),                                            // 22: google.cloud.documentai.v1.ListProcessorVersionsResponse
	(*DeleteProcessorVersionRequest)(nil),                                            // 23: google.cloud.documentai.v1.DeleteProcessorVersionRequest
	(*DeleteProcessorVersionMetadata)(nil),                                           // 24: google.cloud.documentai.v1.DeleteProcessorVersionMetadata
	(*DeployProcessorVersionRequest)(nil),                                            // 25: google.cloud.documentai.v1.DeployProcessorVersionRequest
	(*DeployProcessorVersionResponse)(nil),                                           // 26: google.cloud.documentai.v1.DeployProcessorVersionResponse
	(*DeployProcessorVersionMetadata)(nil),                                           // 27: google.cloud.documentai.v1.DeployProcessorVersionMetadata
	(*UndeployProcessorVersionRequest)(nil),                                          // 28: google.cloud.documentai.v1.UndeployProcessorVersionRequest
	(*UndeployProcessorVersionResponse)(nil),                                         // 29: google.cloud.documentai.v1.UndeployProcessorVersionResponse
	(*UndeployProcessorVersionMetadata)(nil),                                         // 30: google.cloud.documentai.v1.UndeployProcessorVersionMetadata
	(*CreateProcessorRequest)(nil),                                                   // 31: google.cloud.documentai.v1.CreateProcessorRequest
	(*DeleteProcessorRequest)(nil),                                                   // 32: google.cloud.documentai.v1.DeleteProcessorRequest
	(*DeleteProcessorMetadata)(nil),                                                  // 33: google.cloud.documentai.v1.DeleteProcessorMetadata
	(*EnableProcessorRequest)(nil),                                                   // 34: google.cloud.documentai.v1.EnableProcessorRequest
	(*EnableProcessorResponse)(nil),                                                  // 35: google.cloud.documentai.v1.EnableProcessorResponse
	(*EnableProcessorMetadata)(nil),                                                  // 36: google.cloud.documentai.v1.EnableProcessorMetadata
	(*DisableProcessorRequest)(nil),                                                  // 37: google.cloud.documentai.v1.DisableProcessorRequest
	(*DisableProcessorResponse)(nil),                                                 // 38: google.cloud.documentai.v1.DisableProcessorResponse
	(*DisableProcessorMetadata)(nil),                                                 // 39: google.cloud.documentai.v1.DisableProcessorMetadata
	(*SetDefaultProcessorVersionRequest)(nil),                                        // 40: google.cloud.documentai.v1.SetDefaultProcessorVersionRequest
	(*SetDefaultProcessorVersionResponse)(nil),                                       // 41: google.cloud.documentai.v1.SetDefaultProcessorVersionResponse
	(*SetDefaultProcessorVersionMetadata)(nil),                                       // 42: google.cloud.documentai.v1.SetDefaultProcessorVersionMetadata
	(*TrainProcessorVersionRequest)(nil),                                             // 43: google.cloud.documentai.v1.TrainProcessorVersionRequest
	(*TrainProcessorVersionResponse)(nil),                                            // 44: google.cloud.documentai.v1.TrainProcessorVersionResponse
	(*TrainProcessorVersionMetadata)(nil),                                            // 45: google.cloud.documentai.v1.TrainProcessorVersionMetadata
	(*ReviewDocumentRequest)(nil),                                                    // 46: google.cloud.documentai.v1.ReviewDocumentRequest
	(*ReviewDocumentResponse)(nil),                                                   // 47: google.cloud.documentai.v1.ReviewDocumentResponse
	(*ReviewDocumentOperationMetadata)(nil),                                          // 48: google.cloud.documentai.v1.ReviewDocumentOperationMetadata
	(*EvaluateProcessorVersionRequest)(nil),                                          // 49: google.cloud.documentai.v1.EvaluateProcessorVersionRequest
	(*EvaluateProcessorVersionMetadata)(nil),                                         // 50: google.cloud.documentai.v1.EvaluateProcessorVersionMetadata
	(*EvaluateProcessorVersionResponse)(nil),                                         // 51: google.cloud.documentai.v1.EvaluateProcessorVersionResponse
	(*GetEvaluationRequest)(nil),                                                     // 52: google.cloud.documentai.v1.GetEvaluationRequest
	(*ListEvaluationsRequest)(nil),                                                   // 53: google.cloud.documentai.v1.ListEvaluationsRequest
	(*ListEvaluationsResponse)(nil),                                                  // 54: google.cloud.documentai.v1.ListEvaluationsResponse
	(*ProcessOptions_IndividualPageSelector)(nil),                                    // 55: google.cloud.documentai.v1.ProcessOptions.IndividualPageSelector
	nil, // 56: google.cloud.documentai.v1.ProcessRequest.LabelsEntry
	nil, // 57: google.cloud.documentai.v1.BatchProcessRequest.LabelsEntry
	(*BatchProcessMetadata_IndividualProcessStatus)(nil),                 // 58: google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus
	(*TrainProcessorVersionRequest_InputData)(nil),                       // 59: google.cloud.documentai.v1.TrainProcessorVersionRequest.InputData
	(*TrainProcessorVersionRequest_CustomDocumentExtractionOptions)(nil), // 60: google.cloud.documentai.v1.TrainProcessorVersionRequest.CustomDocumentExtractionOptions
	(*TrainProcessorVersionRequest_FoundationModelTuningOptions)(nil),    // 61: google.cloud.documentai.v1.TrainProcessorVersionRequest.FoundationModelTuningOptions
	(*TrainProcessorVersionMetadata_DatasetValidation)(nil),              // 62: google.cloud.documentai.v1.TrainProcessorVersionMetadata.DatasetValidation
	(*OcrConfig)(nil),                 // 63: google.cloud.documentai.v1.OcrConfig
	(*DocumentSchema)(nil),            // 64: google.cloud.documentai.v1.DocumentSchema
	(*Document)(nil),                  // 65: google.cloud.documentai.v1.Document
	(*RawDocument)(nil),               // 66: google.cloud.documentai.v1.RawDocument
	(*GcsDocument)(nil),               // 67: google.cloud.documentai.v1.GcsDocument
	(*fieldmaskpb.FieldMask)(nil),     // 68: google.protobuf.FieldMask
	(*BatchDocumentsInputConfig)(nil), // 69: google.cloud.documentai.v1.BatchDocumentsInputConfig
	(*DocumentOutputConfig)(nil),      // 70: google.cloud.documentai.v1.DocumentOutputConfig
	(*timestamppb.Timestamp)(nil),     // 71: google.protobuf.Timestamp
	(*ProcessorType)(nil),             // 72: google.cloud.documentai.v1.ProcessorType
	(*Processor)(nil),                 // 73: google.cloud.documentai.v1.Processor
	(*ProcessorVersion)(nil),          // 74: google.cloud.documentai.v1.ProcessorVersion
	(*CommonOperationMetadata)(nil),   // 75: google.cloud.documentai.v1.CommonOperationMetadata
	(*Evaluation)(nil),                // 76: google.cloud.documentai.v1.Evaluation
	(*status.Status)(nil),             // 77: google.rpc.Status
	(*longrunningpb.Operation)(nil),   // 78: google.longrunning.Operation
}
var file_google_cloud_documentai_v1_document_processor_service_proto_depIdxs = []int32{
	55, // 0: google.cloud.documentai.v1.ProcessOptions.individual_page_selector:type_name -> google.cloud.documentai.v1.ProcessOptions.IndividualPageSelector
	63, // 1: google.cloud.documentai.v1.ProcessOptions.ocr_config:type_name -> google.cloud.documentai.v1.OcrConfig
	64, // 2: google.cloud.documentai.v1.ProcessOptions.schema_override:type_name -> google.cloud.documentai.v1.DocumentSchema
	65, // 3: google.cloud.documentai.v1.ProcessRequest.inline_document:type_name -> google.cloud.documentai.v1.Document
	66, // 4: google.cloud.documentai.v1.ProcessRequest.raw_document:type_name -> google.cloud.documentai.v1.RawDocument
	67, // 5: google.cloud.documentai.v1.ProcessRequest.gcs_document:type_name -> google.cloud.documentai.v1.GcsDocument
	68, // 6: google.cloud.documentai.v1.ProcessRequest.field_mask:type_name -> google.protobuf.FieldMask
	5,  // 7: google.cloud.documentai.v1.ProcessRequest.process_options:type_name -> google.cloud.documentai.v1.ProcessOptions
	56, // 8: google.cloud.documentai.v1.ProcessRequest.labels:type_name -> google.cloud.documentai.v1.ProcessRequest.LabelsEntry
	0,  // 9: google.cloud.documentai.v1.HumanReviewStatus.state:type_name -> google.cloud.documentai.v1.HumanReviewStatus.State
	65, // 10: google.cloud.documentai.v1.ProcessResponse.document:type_name -> google.cloud.documentai.v1.Document
	7,  // 11: google.cloud.documentai.v1.ProcessResponse.human_review_status:type_name -> google.cloud.documentai.v1.HumanReviewStatus
	69, // 12: google.cloud.documentai.v1.BatchProcessRequest.input_documents:type_name -> google.cloud.documentai.v1.BatchDocumentsInputConfig
	70, // 13: google.cloud.documentai.v1.BatchProcessRequest.document_output_config:type_name -> google.cloud.documentai.v1.DocumentOutputConfig
	5,  // 14: google.cloud.documentai.v1.BatchProcessRequest.process_options:type_name -> google.cloud.documentai.v1.ProcessOptions
	57, // 15: google.cloud.documentai.v1.BatchProcessRequest.labels:type_name -> google.cloud.documentai.v1.BatchProcessRequest.LabelsEntry
	1,  // 16: google.cloud.documentai.v1.BatchProcessMetadata.state:type_name -> google.cloud.documentai.v1.BatchProcessMetadata.State
	71, // 17: google.cloud.documentai.v1.BatchProcessMetadata.create_time:type_name -> google.protobuf.Timestamp
	71, // 18: google.cloud.documentai.v1.BatchProcessMetadata.update_time:type_name -> google.protobuf.Timestamp
	58, // 19: google.cloud.documentai.v1.BatchProcessMetadata.individual_process_statuses:type_name -> google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus
	72, // 20: google.cloud.documentai.v1.FetchProcessorTypesResponse.processor_types:type_name -> google.cloud.documentai.v1.ProcessorType
	72, // 21: google.cloud.documentai.v1.ListProcessorTypesResponse.processor_types:type_name -> google.cloud.documentai.v1.ProcessorType
	73, // 22: google.cloud.documentai.v1.ListProcessorsResponse.processors:type_name -> google.cloud.documentai.v1.Processor
	74, // 23: google.cloud.documentai.v1.ListProcessorVersionsResponse.processor_versions:type_name -> google.cloud.documentai.v1.ProcessorVersion
	75, // 24: google.cloud.documentai.v1.DeleteProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	75, // 25: google.cloud.documentai.v1.DeployProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	75, // 26: google.cloud.documentai.v1.UndeployProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	73, // 27: google.cloud.documentai.v1.CreateProcessorRequest.processor:type_name -> google.cloud.documentai.v1.Processor
	75, // 28: google.cloud.documentai.v1.DeleteProcessorMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	75, // 29: google.cloud.documentai.v1.EnableProcessorMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	75, // 30: google.cloud.documentai.v1.DisableProcessorMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	75, // 31: google.cloud.documentai.v1.SetDefaultProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	60, // 32: google.cloud.documentai.v1.TrainProcessorVersionRequest.custom_document_extraction_options:type_name -> google.cloud.documentai.v1.TrainProcessorVersionRequest.CustomDocumentExtractionOptions
	61, // 33: google.cloud.documentai.v1.TrainProcessorVersionRequest.foundation_model_tuning_options:type_name -> google.cloud.documentai.v1.TrainProcessorVersionRequest.FoundationModelTuningOptions
	74, // 34: google.cloud.documentai.v1.TrainProcessorVersionRequest.processor_version:type_name -> google.cloud.documentai.v1.ProcessorVersion
	64, // 35: google.cloud.documentai.v1.TrainProcessorVersionRequest.document_schema:type_name -> google.cloud.documentai.v1.DocumentSchema
	59, // 36: google.cloud.documentai.v1.TrainProcessorVersionRequest.input_data:type_name -> google.cloud.documentai.v1.TrainProcessorVersionRequest.InputData
	75, // 37: google.cloud.documentai.v1.TrainProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	62, // 38: google.cloud.documentai.v1.TrainProcessorVersionMetadata.training_dataset_validation:type_name -> google.cloud.documentai.v1.TrainProcessorVersionMetadata.DatasetValidation
	62, // 39: google.cloud.documentai.v1.TrainProcessorVersionMetadata.test_dataset_validation:type_name -> google.cloud.documentai.v1.TrainProcessorVersionMetadata.DatasetValidation
	65, // 40: google.cloud.documentai.v1.ReviewDocumentRequest.inline_document:type_name -> google.cloud.documentai.v1.Document
	3,  // 41: google.cloud.documentai.v1.ReviewDocumentRequest.priority:type_name -> google.cloud.documentai.v1.ReviewDocumentRequest.Priority
	64, // 42: google.cloud.documentai.v1.ReviewDocumentRequest.document_schema:type_name -> google.cloud.documentai.v1.DocumentSchema
	4,  // 43: google.cloud.documentai.v1.ReviewDocumentResponse.state:type_name -> google.cloud.documentai.v1.ReviewDocumentResponse.State
	75, // 44: google.cloud.documentai.v1.ReviewDocumentOperationMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	69, // 45: google.cloud.documentai.v1.EvaluateProcessorVersionRequest.evaluation_documents:type_name -> google.cloud.documentai.v1.BatchDocumentsInputConfig
	75, // 46: google.cloud.documentai.v1.EvaluateProcessorVersionMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	76, // 47: google.cloud.documentai.v1.ListEvaluationsResponse.evaluations:type_name -> google.cloud.documentai.v1.Evaluation
	77, // 48: google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus.status:type_name -> google.rpc.Status
	7,  // 49: google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus.human_review_status:type_name -> google.cloud.documentai.v1.HumanReviewStatus
	69, // 50: google.cloud.documentai.v1.TrainProcessorVersionRequest.InputData.training_documents:type_name -> google.cloud.documentai.v1.BatchDocumentsInputConfig
	69, // 51: google.cloud.documentai.v1.TrainProcessorVersionRequest.InputData.test_documents:type_name -> google.cloud.documentai.v1.BatchDocumentsInputConfig
	2,  // 52: google.cloud.documentai.v1.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.training_method:type_name -> google.cloud.documentai.v1.TrainProcessorVersionRequest.CustomDocumentExtractionOptions.TrainingMethod
	77, // 53: google.cloud.documentai.v1.TrainProcessorVersionMetadata.DatasetValidation.document_errors:type_name -> google.rpc.Status
	77, // 54: google.cloud.documentai.v1.TrainProcessorVersionMetadata.DatasetValidation.dataset_errors:type_name -> google.rpc.Status
	6,  // 55: google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument:input_type -> google.cloud.documentai.v1.ProcessRequest
	9,  // 56: google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments:input_type -> google.cloud.documentai.v1.BatchProcessRequest
	12, // 57: google.cloud.documentai.v1.DocumentProcessorService.FetchProcessorTypes:input_type -> google.cloud.documentai.v1.FetchProcessorTypesRequest
	14, // 58: google.cloud.documentai.v1.DocumentProcessorService.ListProcessorTypes:input_type -> google.cloud.documentai.v1.ListProcessorTypesRequest
	18, // 59: google.cloud.documentai.v1.DocumentProcessorService.GetProcessorType:input_type -> google.cloud.documentai.v1.GetProcessorTypeRequest
	16, // 60: google.cloud.documentai.v1.DocumentProcessorService.ListProcessors:input_type -> google.cloud.documentai.v1.ListProcessorsRequest
	19, // 61: google.cloud.documentai.v1.DocumentProcessorService.GetProcessor:input_type -> google.cloud.documentai.v1.GetProcessorRequest
	43, // 62: google.cloud.documentai.v1.DocumentProcessorService.TrainProcessorVersion:input_type -> google.cloud.documentai.v1.TrainProcessorVersionRequest
	20, // 63: google.cloud.documentai.v1.DocumentProcessorService.GetProcessorVersion:input_type -> google.cloud.documentai.v1.GetProcessorVersionRequest
	21, // 64: google.cloud.documentai.v1.DocumentProcessorService.ListProcessorVersions:input_type -> google.cloud.documentai.v1.ListProcessorVersionsRequest
	23, // 65: google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessorVersion:input_type -> google.cloud.documentai.v1.DeleteProcessorVersionRequest
	25, // 66: google.cloud.documentai.v1.DocumentProcessorService.DeployProcessorVersion:input_type -> google.cloud.documentai.v1.DeployProcessorVersionRequest
	28, // 67: google.cloud.documentai.v1.DocumentProcessorService.UndeployProcessorVersion:input_type -> google.cloud.documentai.v1.UndeployProcessorVersionRequest
	31, // 68: google.cloud.documentai.v1.DocumentProcessorService.CreateProcessor:input_type -> google.cloud.documentai.v1.CreateProcessorRequest
	32, // 69: google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessor:input_type -> google.cloud.documentai.v1.DeleteProcessorRequest
	34, // 70: google.cloud.documentai.v1.DocumentProcessorService.EnableProcessor:input_type -> google.cloud.documentai.v1.EnableProcessorRequest
	37, // 71: google.cloud.documentai.v1.DocumentProcessorService.DisableProcessor:input_type -> google.cloud.documentai.v1.DisableProcessorRequest
	40, // 72: google.cloud.documentai.v1.DocumentProcessorService.SetDefaultProcessorVersion:input_type -> google.cloud.documentai.v1.SetDefaultProcessorVersionRequest
	46, // 73: google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument:input_type -> google.cloud.documentai.v1.ReviewDocumentRequest
	49, // 74: google.cloud.documentai.v1.DocumentProcessorService.EvaluateProcessorVersion:input_type -> google.cloud.documentai.v1.EvaluateProcessorVersionRequest
	52, // 75: google.cloud.documentai.v1.DocumentProcessorService.GetEvaluation:input_type -> google.cloud.documentai.v1.GetEvaluationRequest
	53, // 76: google.cloud.documentai.v1.DocumentProcessorService.ListEvaluations:input_type -> google.cloud.documentai.v1.ListEvaluationsRequest
	8,  // 77: google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument:output_type -> google.cloud.documentai.v1.ProcessResponse
	78, // 78: google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments:output_type -> google.longrunning.Operation
	13, // 79: google.cloud.documentai.v1.DocumentProcessorService.FetchProcessorTypes:output_type -> google.cloud.documentai.v1.FetchProcessorTypesResponse
	15, // 80: google.cloud.documentai.v1.DocumentProcessorService.ListProcessorTypes:output_type -> google.cloud.documentai.v1.ListProcessorTypesResponse
	72, // 81: google.cloud.documentai.v1.DocumentProcessorService.GetProcessorType:output_type -> google.cloud.documentai.v1.ProcessorType
	17, // 82: google.cloud.documentai.v1.DocumentProcessorService.ListProcessors:output_type -> google.cloud.documentai.v1.ListProcessorsResponse
	73, // 83: google.cloud.documentai.v1.DocumentProcessorService.GetProcessor:output_type -> google.cloud.documentai.v1.Processor
	78, // 84: google.cloud.documentai.v1.DocumentProcessorService.TrainProcessorVersion:output_type -> google.longrunning.Operation
	74, // 85: google.cloud.documentai.v1.DocumentProcessorService.GetProcessorVersion:output_type -> google.cloud.documentai.v1.ProcessorVersion
	22, // 86: google.cloud.documentai.v1.DocumentProcessorService.ListProcessorVersions:output_type -> google.cloud.documentai.v1.ListProcessorVersionsResponse
	78, // 87: google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessorVersion:output_type -> google.longrunning.Operation
	78, // 88: google.cloud.documentai.v1.DocumentProcessorService.DeployProcessorVersion:output_type -> google.longrunning.Operation
	78, // 89: google.cloud.documentai.v1.DocumentProcessorService.UndeployProcessorVersion:output_type -> google.longrunning.Operation
	73, // 90: google.cloud.documentai.v1.DocumentProcessorService.CreateProcessor:output_type -> google.cloud.documentai.v1.Processor
	78, // 91: google.cloud.documentai.v1.DocumentProcessorService.DeleteProcessor:output_type -> google.longrunning.Operation
	78, // 92: google.cloud.documentai.v1.DocumentProcessorService.EnableProcessor:output_type -> google.longrunning.Operation
	78, // 93: google.cloud.documentai.v1.DocumentProcessorService.DisableProcessor:output_type -> google.longrunning.Operation
	78, // 94: google.cloud.documentai.v1.DocumentProcessorService.SetDefaultProcessorVersion:output_type -> google.longrunning.Operation
	78, // 95: google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument:output_type -> google.longrunning.Operation
	78, // 96: google.cloud.documentai.v1.DocumentProcessorService.EvaluateProcessorVersion:output_type -> google.longrunning.Operation
	76, // 97: google.cloud.documentai.v1.DocumentProcessorService.GetEvaluation:output_type -> google.cloud.documentai.v1.Evaluation
	54, // 98: google.cloud.documentai.v1.DocumentProcessorService.ListEvaluations:output_type -> google.cloud.documentai.v1.ListEvaluationsResponse
	77, // [77:99] is the sub-list for method output_type
	55, // [55:77] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1_document_processor_service_proto_init() }
func file_google_cloud_documentai_v1_document_processor_service_proto_init() {
	if File_google_cloud_documentai_v1_document_processor_service_proto != nil {
		return
	}
	file_google_cloud_documentai_v1_document_proto_init()
	file_google_cloud_documentai_v1_document_io_proto_init()
	file_google_cloud_documentai_v1_document_schema_proto_init()
	file_google_cloud_documentai_v1_evaluation_proto_init()
	file_google_cloud_documentai_v1_operation_metadata_proto_init()
	file_google_cloud_documentai_v1_processor_proto_init()
	file_google_cloud_documentai_v1_processor_type_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HumanReviewStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchProcessorTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchProcessorTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessorTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessorVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessorMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableProcessorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnableProcessorMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableProcessorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableProcessorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DisableProcessorMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetDefaultProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetDefaultProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetDefaultProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluateProcessorVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluateProcessorVersionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluateProcessorVersionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEvaluationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEvaluationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEvaluationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessOptions_IndividualPageSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessMetadata_IndividualProcessStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainProcessorVersionRequest_InputData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainProcessorVersionRequest_CustomDocumentExtractionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainProcessorVersionRequest_FoundationModelTuningOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainProcessorVersionMetadata_DatasetValidation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ProcessOptions_IndividualPageSelector_)(nil),
		(*ProcessOptions_FromStart)(nil),
		(*ProcessOptions_FromEnd)(nil),
	}
	file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ProcessRequest_InlineDocument)(nil),
		(*ProcessRequest_RawDocument)(nil),
		(*ProcessRequest_GcsDocument)(nil),
	}
	file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*TrainProcessorVersionRequest_CustomDocumentExtractionOptions_)(nil),
		(*TrainProcessorVersionRequest_FoundationModelTuningOptions_)(nil),
	}
	file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[41].OneofWrappers = []interface{}{
		(*ReviewDocumentRequest_InlineDocument)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   58,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_documentai_v1_document_processor_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1_document_processor_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1_document_processor_service_proto = out.File
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc = nil
	file_google_cloud_documentai_v1_document_processor_service_proto_goTypes = nil
	file_google_cloud_documentai_v1_document_processor_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentProcessorServiceClient is the client API for DocumentProcessorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentProcessorServiceClient interface {
	// Processes a single document.
	ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches processor types. Note that we don't use
	// [ListProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.ListProcessorTypes]
	// here, because it isn't paginated.
	FetchProcessorTypes(ctx context.Context, in *FetchProcessorTypesRequest, opts ...grpc.CallOption) (*FetchProcessorTypesResponse, error)
	// Lists the processor types that exist.
	ListProcessorTypes(ctx context.Context, in *ListProcessorTypesRequest, opts ...grpc.CallOption) (*ListProcessorTypesResponse, error)
	// Gets a processor type detail.
	GetProcessorType(ctx context.Context, in *GetProcessorTypeRequest, opts ...grpc.CallOption) (*ProcessorType, error)
	// Lists all processors which belong to this project.
	ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error)
	// Gets a processor detail.
	GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error)
	// Trains a new processor version.
	// Operation metadata is returned as
	// [TrainProcessorVersionMetadata][google.cloud.documentai.v1.TrainProcessorVersionMetadata].
	TrainProcessorVersion(ctx context.Context, in *TrainProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a processor version detail.
	GetProcessorVersion(ctx context.Context, in *GetProcessorVersionRequest, opts ...grpc.CallOption) (*ProcessorVersion, error)
	// Lists all versions of a processor.
	ListProcessorVersions(ctx context.Context, in *ListProcessorVersionsRequest, opts ...grpc.CallOption) (*ListProcessorVersionsResponse, error)
	// Deletes the processor version, all artifacts under the processor version
	// will be deleted.
	DeleteProcessorVersion(ctx context.Context, in *DeleteProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys the processor version.
	DeployProcessorVersion(ctx context.Context, in *DeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys the processor version.
	UndeployProcessorVersion(ctx context.Context, in *UndeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a processor from the
	// [ProcessorType][google.cloud.documentai.v1.ProcessorType] provided. The
	// processor will be at `ENABLED` state by default after its creation.
	CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*Processor, error)
	// Deletes the processor, unloads all deployed model artifacts if it was
	// enabled and then deletes all artifacts associated with this processor.
	DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Enables a processor
	EnableProcessor(ctx context.Context, in *EnableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Disables a processor
	DisableProcessor(ctx context.Context, in *DisableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Set the default (active) version of a
	// [Processor][google.cloud.documentai.v1.Processor] that will be used in
	// [ProcessDocument][google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument]
	// and
	// [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments].
	SetDefaultProcessorVersion(ctx context.Context, in *SetDefaultProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Evaluates a ProcessorVersion against annotated documents, producing an
	// Evaluation.
	EvaluateProcessorVersion(ctx context.Context, in *EvaluateProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a specific evaluation.
	GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error)
	// Retrieves a set of evaluations for a given processor version.
	ListEvaluations(ctx context.Context, in *ListEvaluationsRequest, opts ...grpc.CallOption) (*ListEvaluationsResponse, error)
}

type documentProcessorServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentProcessorServiceClient(cc grpc.ClientConnInterface) DocumentProcessorServiceClient {
	return &documentProcessorServiceClient{cc}
}

func (c *documentProcessorServiceClient) ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error) {
	out := new(ProcessResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ProcessDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/BatchProcessDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) FetchProcessorTypes(ctx context.Context, in *FetchProcessorTypesRequest, opts ...grpc.CallOption) (*FetchProcessorTypesResponse, error) {
	out := new(FetchProcessorTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/FetchProcessorTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessorTypes(ctx context.Context, in *ListProcessorTypesRequest, opts ...grpc.CallOption) (*ListProcessorTypesResponse, error) {
	out := new(ListProcessorTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ListProcessorTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessorType(ctx context.Context, in *GetProcessorTypeRequest, opts ...grpc.CallOption) (*ProcessorType, error) {
	out := new(ProcessorType)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/GetProcessorType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessors(ctx context.Context, in *ListProcessorsRequest, opts ...grpc.CallOption) (*ListProcessorsResponse, error) {
	out := new(ListProcessorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ListProcessors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessor(ctx context.Context, in *GetProcessorRequest, opts ...grpc.CallOption) (*Processor, error) {
	out := new(Processor)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/GetProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) TrainProcessorVersion(ctx context.Context, in *TrainProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/TrainProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetProcessorVersion(ctx context.Context, in *GetProcessorVersionRequest, opts ...grpc.CallOption) (*ProcessorVersion, error) {
	out := new(ProcessorVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/GetProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListProcessorVersions(ctx context.Context, in *ListProcessorVersionsRequest, opts ...grpc.CallOption) (*ListProcessorVersionsResponse, error) {
	out := new(ListProcessorVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ListProcessorVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeleteProcessorVersion(ctx context.Context, in *DeleteProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/DeleteProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeployProcessorVersion(ctx context.Context, in *DeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/DeployProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) UndeployProcessorVersion(ctx context.Context, in *UndeployProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/UndeployProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) CreateProcessor(ctx context.Context, in *CreateProcessorRequest, opts ...grpc.CallOption) (*Processor, error) {
	out := new(Processor)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/CreateProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DeleteProcessor(ctx context.Context, in *DeleteProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/DeleteProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) EnableProcessor(ctx context.Context, in *EnableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/EnableProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) DisableProcessor(ctx context.Context, in *DisableProcessorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/DisableProcessor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) SetDefaultProcessorVersion(ctx context.Context, in *SetDefaultProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/SetDefaultProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ReviewDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) EvaluateProcessorVersion(ctx context.Context, in *EvaluateProcessorVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/EvaluateProcessorVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) GetEvaluation(ctx context.Context, in *GetEvaluationRequest, opts ...grpc.CallOption) (*Evaluation, error) {
	out := new(Evaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/GetEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ListEvaluations(ctx context.Context, in *ListEvaluationsRequest, opts ...grpc.CallOption) (*ListEvaluationsResponse, error) {
	out := new(ListEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ListEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentProcessorServiceServer is the server API for DocumentProcessorService service.
type DocumentProcessorServiceServer interface {
	// Processes a single document.
	ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunningpb.Operation, error)
	// Fetches processor types. Note that we don't use
	// [ListProcessorTypes][google.cloud.documentai.v1.DocumentProcessorService.ListProcessorTypes]
	// here, because it isn't paginated.
	FetchProcessorTypes(context.Context, *FetchProcessorTypesRequest) (*FetchProcessorTypesResponse, error)
	// Lists the processor types that exist.
	ListProcessorTypes(context.Context, *ListProcessorTypesRequest) (*ListProcessorTypesResponse, error)
	// Gets a processor type detail.
	GetProcessorType(context.Context, *GetProcessorTypeRequest) (*ProcessorType, error)
	// Lists all processors which belong to this project.
	ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error)
	// Gets a processor detail.
	GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error)
	// Trains a new processor version.
	// Operation metadata is returned as
	// [TrainProcessorVersionMetadata][google.cloud.documentai.v1.TrainProcessorVersionMetadata].
	TrainProcessorVersion(context.Context, *TrainProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Gets a processor version detail.
	GetProcessorVersion(context.Context, *GetProcessorVersionRequest) (*ProcessorVersion, error)
	// Lists all versions of a processor.
	ListProcessorVersions(context.Context, *ListProcessorVersionsRequest) (*ListProcessorVersionsResponse, error)
	// Deletes the processor version, all artifacts under the processor version
	// will be deleted.
	DeleteProcessorVersion(context.Context, *DeleteProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Deploys the processor version.
	DeployProcessorVersion(context.Context, *DeployProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Undeploys the processor version.
	UndeployProcessorVersion(context.Context, *UndeployProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Creates a processor from the
	// [ProcessorType][google.cloud.documentai.v1.ProcessorType] provided. The
	// processor will be at `ENABLED` state by default after its creation.
	CreateProcessor(context.Context, *CreateProcessorRequest) (*Processor, error)
	// Deletes the processor, unloads all deployed model artifacts if it was
	// enabled and then deletes all artifacts associated with this processor.
	DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunningpb.Operation, error)
	// Enables a processor
	EnableProcessor(context.Context, *EnableProcessorRequest) (*longrunningpb.Operation, error)
	// Disables a processor
	DisableProcessor(context.Context, *DisableProcessorRequest) (*longrunningpb.Operation, error)
	// Set the default (active) version of a
	// [Processor][google.cloud.documentai.v1.Processor] that will be used in
	// [ProcessDocument][google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument]
	// and
	// [BatchProcessDocuments][google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments].
	SetDefaultProcessorVersion(context.Context, *SetDefaultProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunningpb.Operation, error)
	// Evaluates a ProcessorVersion against annotated documents, producing an
	// Evaluation.
	EvaluateProcessorVersion(context.Context, *EvaluateProcessorVersionRequest) (*longrunningpb.Operation, error)
	// Retrieves a specific evaluation.
	GetEvaluation(context.Context, *GetEvaluationRequest) (*Evaluation, error)
	// Retrieves a set of evaluations for a given processor version.
	ListEvaluations(context.Context, *ListEvaluationsRequest) (*ListEvaluationsResponse, error)
}

// UnimplementedDocumentProcessorServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentProcessorServiceServer struct {
}

func (*UnimplementedDocumentProcessorServiceServer) ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ProcessDocument not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchProcessDocuments not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) FetchProcessorTypes(context.Context, *FetchProcessorTypesRequest) (*FetchProcessorTypesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchProcessorTypes not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ListProcessorTypes(context.Context, *ListProcessorTypesRequest) (*ListProcessorTypesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProcessorTypes not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) GetProcessorType(context.Context, *GetProcessorTypeRequest) (*ProcessorType, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProcessorType not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ListProcessors(context.Context, *ListProcessorsRequest) (*ListProcessorsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProcessors not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) GetProcessor(context.Context, *GetProcessorRequest) (*Processor, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) TrainProcessorVersion(context.Context, *TrainProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method TrainProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) GetProcessorVersion(context.Context, *GetProcessorVersionRequest) (*ProcessorVersion, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ListProcessorVersions(context.Context, *ListProcessorVersionsRequest) (*ListProcessorVersionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListProcessorVersions not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DeleteProcessorVersion(context.Context, *DeleteProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DeployProcessorVersion(context.Context, *DeployProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeployProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) UndeployProcessorVersion(context.Context, *UndeployProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UndeployProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) CreateProcessor(context.Context, *CreateProcessorRequest) (*Processor, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DeleteProcessor(context.Context, *DeleteProcessorRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) EnableProcessor(context.Context, *EnableProcessorRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method EnableProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) DisableProcessor(context.Context, *DisableProcessorRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DisableProcessor not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) SetDefaultProcessorVersion(context.Context, *SetDefaultProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SetDefaultProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ReviewDocument not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) EvaluateProcessorVersion(context.Context, *EvaluateProcessorVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method EvaluateProcessorVersion not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) GetEvaluation(context.Context, *GetEvaluationRequest) (*Evaluation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEvaluation not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ListEvaluations(context.Context, *ListEvaluationsRequest) (*ListEvaluationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEvaluations not implemented")
}

func RegisterDocumentProcessorServiceServer(s *grpc.Server, srv DocumentProcessorServiceServer) {
	s.RegisterService(&_DocumentProcessorService_serviceDesc, srv)
}

func _DocumentProcessorService_ProcessDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ProcessDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, req.(*ProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_BatchProcessDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/BatchProcessDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, req.(*BatchProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_FetchProcessorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchProcessorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).FetchProcessorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/FetchProcessorTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).FetchProcessorTypes(ctx, req.(*FetchProcessorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ListProcessorTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessorTypes(ctx, req.(*ListProcessorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessorType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessorType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/GetProcessorType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessorType(ctx, req.(*GetProcessorTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ListProcessors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessors(ctx, req.(*ListProcessorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/GetProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessor(ctx, req.(*GetProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_TrainProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).TrainProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/TrainProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).TrainProcessorVersion(ctx, req.(*TrainProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/GetProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetProcessorVersion(ctx, req.(*GetProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListProcessorVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessorVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListProcessorVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ListProcessorVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListProcessorVersions(ctx, req.(*ListProcessorVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeleteProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeleteProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/DeleteProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeleteProcessorVersion(ctx, req.(*DeleteProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeployProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeployProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/DeployProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeployProcessorVersion(ctx, req.(*DeployProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_UndeployProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).UndeployProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/UndeployProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).UndeployProcessorVersion(ctx, req.(*UndeployProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_CreateProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).CreateProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/CreateProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).CreateProcessor(ctx, req.(*CreateProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DeleteProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DeleteProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/DeleteProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DeleteProcessor(ctx, req.(*DeleteProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_EnableProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).EnableProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/EnableProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).EnableProcessor(ctx, req.(*EnableProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_DisableProcessor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableProcessorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).DisableProcessor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/DisableProcessor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).DisableProcessor(ctx, req.(*DisableProcessorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_SetDefaultProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).SetDefaultProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/SetDefaultProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).SetDefaultProcessorVersion(ctx, req.(*SetDefaultProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ReviewDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReviewDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ReviewDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, req.(*ReviewDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_EvaluateProcessorVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvaluateProcessorVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).EvaluateProcessorVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/EvaluateProcessorVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).EvaluateProcessorVersion(ctx, req.(*EvaluateProcessorVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_GetEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).GetEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/GetEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).GetEvaluation(ctx, req.(*GetEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ListEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ListEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ListEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ListEvaluations(ctx, req.(*ListEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentProcessorService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1.DocumentProcessorService",
	HandlerType: (*DocumentProcessorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessDocument",
			Handler:    _DocumentProcessorService_ProcessDocument_Handler,
		},
		{
			MethodName: "BatchProcessDocuments",
			Handler:    _DocumentProcessorService_BatchProcessDocuments_Handler,
		},
		{
			MethodName: "FetchProcessorTypes",
			Handler:    _DocumentProcessorService_FetchProcessorTypes_Handler,
		},
		{
			MethodName: "ListProcessorTypes",
			Handler:    _DocumentProcessorService_ListProcessorTypes_Handler,
		},
		{
			MethodName: "GetProcessorType",
			Handler:    _DocumentProcessorService_GetProcessorType_Handler,
		},
		{
			MethodName: "ListProcessors",
			Handler:    _DocumentProcessorService_ListProcessors_Handler,
		},
		{
			MethodName: "GetProcessor",
			Handler:    _DocumentProcessorService_GetProcessor_Handler,
		},
		{
			MethodName: "TrainProcessorVersion",
			Handler:    _DocumentProcessorService_TrainProcessorVersion_Handler,
		},
		{
			MethodName: "GetProcessorVersion",
			Handler:    _DocumentProcessorService_GetProcessorVersion_Handler,
		},
		{
			MethodName: "ListProcessorVersions",
			Handler:    _DocumentProcessorService_ListProcessorVersions_Handler,
		},
		{
			MethodName: "DeleteProcessorVersion",
			Handler:    _DocumentProcessorService_DeleteProcessorVersion_Handler,
		},
		{
			MethodName: "DeployProcessorVersion",
			Handler:    _DocumentProcessorService_DeployProcessorVersion_Handler,
		},
		{
			MethodName: "UndeployProcessorVersion",
			Handler:    _DocumentProcessorService_UndeployProcessorVersion_Handler,
		},
		{
			MethodName: "CreateProcessor",
			Handler:    _DocumentProcessorService_CreateProcessor_Handler,
		},
		{
			MethodName: "DeleteProcessor",
			Handler:    _DocumentProcessorService_DeleteProcessor_Handler,
		},
		{
			MethodName: "EnableProcessor",
			Handler:    _DocumentProcessorService_EnableProcessor_Handler,
		},
		{
			MethodName: "DisableProcessor",
			Handler:    _DocumentProcessorService_DisableProcessor_Handler,
		},
		{
			MethodName: "SetDefaultProcessorVersion",
			Handler:    _DocumentProcessorService_SetDefaultProcessorVersion_Handler,
		},
		{
			MethodName: "ReviewDocument",
			Handler:    _DocumentProcessorService_ReviewDocument_Handler,
		},
		{
			MethodName: "EvaluateProcessorVersion",
			Handler:    _DocumentProcessorService_EvaluateProcessorVersion_Handler,
		},
		{
			MethodName: "GetEvaluation",
			Handler:    _DocumentProcessorService_GetEvaluation_Handler,
		},
		{
			MethodName: "ListEvaluations",
			Handler:    _DocumentProcessorService_ListEvaluations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1/document_processor_service.proto",
}
