//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Fence types to enable or disable when using MAV_CMD_DO_FENCE_ENABLE.
// Note that at least one of these flags must be set in MAV_CMD_DO_FENCE_ENABLE.param2.
// If none are set, the flight stack will ignore the field and enable/disable its default set of fences (usually all of them).
type FENCE_TYPE uint64

const (
	// Maximum altitude fence
	FENCE_TYPE_ALT_MAX FENCE_TYPE = 1
	// Circle fence
	FENCE_TYPE_CIRCLE FENCE_TYPE = 2
	// Polygon fence
	FENCE_TYPE_POLYGON FENCE_TYPE = 4
	// Minimum altitude fence
	FENCE_TYPE_ALT_MIN FENCE_TYPE = 8
)

var values_FENCE_TYPE = []FENCE_TYPE{
	FENCE_TYPE_ALT_MAX,
	FENCE_TYPE_CIRCLE,
	FENCE_TYPE_POLYGON,
	FENCE_TYPE_ALT_MIN,
}

var value_to_label_FENCE_TYPE = map[FENCE_TYPE]string{
	FENCE_TYPE_ALT_MAX: "FENCE_TYPE_ALT_MAX",
	FENCE_TYPE_CIRCLE:  "FENCE_TYPE_CIRCLE",
	FENCE_TYPE_POLYGON: "FENCE_TYPE_POLYGON",
	FENCE_TYPE_ALT_MIN: "FENCE_TYPE_ALT_MIN",
}

var label_to_value_FENCE_TYPE = map[string]FENCE_TYPE{
	"FENCE_TYPE_ALT_MAX": FENCE_TYPE_ALT_MAX,
	"FENCE_TYPE_CIRCLE":  FENCE_TYPE_CIRCLE,
	"FENCE_TYPE_POLYGON": FENCE_TYPE_POLYGON,
	"FENCE_TYPE_ALT_MIN": FENCE_TYPE_ALT_MIN,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e FENCE_TYPE) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_FENCE_TYPE {
		if e&val == val {
			names = append(names, value_to_label_FENCE_TYPE[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *FENCE_TYPE) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask FENCE_TYPE
	for _, label := range labels {
		if value, ok := label_to_value_FENCE_TYPE[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= FENCE_TYPE(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e FENCE_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
