//autogenerated:yes
//nolint:revive,misspell,govet,lll
package marsh

// State report for motion platform used for moving the cockpit with the pilot for motion cueing. This is the primary message for MARSH_TYPE_MOTION_PLATFORM.
type MessageMotionPlatformState struct {
	// Timestamp (time since system boot).
	TimeBootMs uint32
	// Generic system health (error and warning) status.
	Health MOTION_PLATFORM_HEALTH `mavenum:"uint8"`
	// Generic system operating mode.
	Mode MOTION_PLATFORM_MODE `mavenum:"uint8"`
	// X axis (surge) position, positive forward.
	X float32
	// Y axis (sway) position, positive right.
	Y float32
	// Z axis (heave) position, positive down.
	Z float32
	// Roll position, positive right.
	Roll float32
	// Pitch position, positive nose up.
	Pitch float32
	// Yaw position, positive right.
	Yaw float32
	// X axis (surge) velocity, positive forward.
	VelX float32
	// Y axis (sway) velocity, positive right.
	VelY float32
	// Z axis (heave) velocity, positive down.
	VelZ float32
	// Roll velocity, positive right.
	VelRoll float32
	// Pitch velocity, positive nose up.
	VelPitch float32
	// Yaw velocity, positive right.
	VelYaw float32
	// X axis (surge) acceleration, positive forward.
	AccX float32
	// Y axis (sway) acceleration, positive right.
	AccY float32
	// Z axis (heave) acceleration, positive down.
	AccZ float32
	// Roll acceleration, positive right. Unit rad/s/s, currently not part of mavschema.xsd
	AccRoll float32
	// Pitch acceleration, positive nose up. Unit rad/s/s, currently not part of mavschema.xsd
	AccPitch float32
	// Yaw acceleration, positive right. Unit rad/s/s, currently not part of mavschema.xsd
	AccYaw float32
}

// GetID implements the message.Message interface.
func (*MessageMotionPlatformState) GetID() uint32 {
	return 52502
}
