// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/monitoring/v3/service.proto

package monitoring

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	calendarperiod "google.golang.org/genproto/googleapis/type/calendarperiod"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `ServiceLevelObjective.View` determines what form of
// `ServiceLevelObjective` is returned from `GetServiceLevelObjective`,
// `ListServiceLevelObjectives`, and `ListServiceLevelObjectiveVersions` RPCs.
type ServiceLevelObjective_View int32

const (
	// Same as FULL.
	ServiceLevelObjective_VIEW_UNSPECIFIED ServiceLevelObjective_View = 0
	// Return the embedded `ServiceLevelIndicator` in the form in which it was
	// defined. If it was defined using a `BasicSli`, return that `BasicSli`.
	ServiceLevelObjective_FULL ServiceLevelObjective_View = 2
	// For `ServiceLevelIndicator`s using `BasicSli` articulation, instead
	// return the `ServiceLevelIndicator` with its mode of computation fully
	// spelled out as a `RequestBasedSli`. For `ServiceLevelIndicator`s using
	// `RequestBasedSli` or `WindowsBasedSli`, return the
	// `ServiceLevelIndicator` as it was provided.
	ServiceLevelObjective_EXPLICIT ServiceLevelObjective_View = 1
)

// Enum value maps for ServiceLevelObjective_View.
var (
	ServiceLevelObjective_View_name = map[int32]string{
		0: "VIEW_UNSPECIFIED",
		2: "FULL",
		1: "EXPLICIT",
	}
	ServiceLevelObjective_View_value = map[string]int32{
		"VIEW_UNSPECIFIED": 0,
		"FULL":             2,
		"EXPLICIT":         1,
	}
)

func (x ServiceLevelObjective_View) Enum() *ServiceLevelObjective_View {
	p := new(ServiceLevelObjective_View)
	*p = x
	return p
}

func (x ServiceLevelObjective_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceLevelObjective_View) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_v3_service_proto_enumTypes[0].Descriptor()
}

func (ServiceLevelObjective_View) Type() protoreflect.EnumType {
	return &file_google_monitoring_v3_service_proto_enumTypes[0]
}

func (x ServiceLevelObjective_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceLevelObjective_View.Descriptor instead.
func (ServiceLevelObjective_View) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{1, 0}
}

// A `Service` is a discrete, autonomous, and network-accessible unit, designed
// to solve an individual concern
// ([Wikipedia](https://en.wikipedia.org/wiki/Service-orientation)). In
// Cloud Monitoring, a `Service` acts as the root resource under which
// operational aspects of the service are accessible.
type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name for this Service. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Name used for UI elements listing this Service.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// REQUIRED. Service-identifying atoms specifying the underlying service.
	//
	// Types that are assignable to Identifier:
	//	*Service_Custom_
	//	*Service_AppEngine_
	//	*Service_CloudEndpoints_
	//	*Service_ClusterIstio_
	//	*Service_MeshIstio_
	//	*Service_IstioCanonicalService_
	Identifier isService_Identifier `protobuf_oneof:"identifier"`
	// Configuration for how to query telemetry on a Service.
	Telemetry *Service_Telemetry `protobuf:"bytes,13,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	// Labels which have been used to annotate the service. Label keys must start
	// with a letter. Label keys and values may contain lowercase letters,
	// numbers, underscores, and dashes. Label keys and values have a maximum
	// length of 63 characters, and must be less than 128 bytes in size. Up to 64
	// label entries may be stored. For labels which do not have a semantic value,
	// the empty string may be supplied for the label value.
	UserLabels map[string]string `protobuf:"bytes,14,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0}
}

func (x *Service) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Service) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *Service) GetIdentifier() isService_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (x *Service) GetCustom() *Service_Custom {
	if x, ok := x.GetIdentifier().(*Service_Custom_); ok {
		return x.Custom
	}
	return nil
}

func (x *Service) GetAppEngine() *Service_AppEngine {
	if x, ok := x.GetIdentifier().(*Service_AppEngine_); ok {
		return x.AppEngine
	}
	return nil
}

func (x *Service) GetCloudEndpoints() *Service_CloudEndpoints {
	if x, ok := x.GetIdentifier().(*Service_CloudEndpoints_); ok {
		return x.CloudEndpoints
	}
	return nil
}

func (x *Service) GetClusterIstio() *Service_ClusterIstio {
	if x, ok := x.GetIdentifier().(*Service_ClusterIstio_); ok {
		return x.ClusterIstio
	}
	return nil
}

func (x *Service) GetMeshIstio() *Service_MeshIstio {
	if x, ok := x.GetIdentifier().(*Service_MeshIstio_); ok {
		return x.MeshIstio
	}
	return nil
}

func (x *Service) GetIstioCanonicalService() *Service_IstioCanonicalService {
	if x, ok := x.GetIdentifier().(*Service_IstioCanonicalService_); ok {
		return x.IstioCanonicalService
	}
	return nil
}

func (x *Service) GetTelemetry() *Service_Telemetry {
	if x != nil {
		return x.Telemetry
	}
	return nil
}

func (x *Service) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

type isService_Identifier interface {
	isService_Identifier()
}

type Service_Custom_ struct {
	// Custom service type.
	Custom *Service_Custom `protobuf:"bytes,6,opt,name=custom,proto3,oneof"`
}

type Service_AppEngine_ struct {
	// Type used for App Engine services.
	AppEngine *Service_AppEngine `protobuf:"bytes,7,opt,name=app_engine,json=appEngine,proto3,oneof"`
}

type Service_CloudEndpoints_ struct {
	// Type used for Cloud Endpoints services.
	CloudEndpoints *Service_CloudEndpoints `protobuf:"bytes,8,opt,name=cloud_endpoints,json=cloudEndpoints,proto3,oneof"`
}

type Service_ClusterIstio_ struct {
	// Type used for Istio services that live in a Kubernetes cluster.
	ClusterIstio *Service_ClusterIstio `protobuf:"bytes,9,opt,name=cluster_istio,json=clusterIstio,proto3,oneof"`
}

type Service_MeshIstio_ struct {
	// Type used for Istio services scoped to an Istio mesh.
	MeshIstio *Service_MeshIstio `protobuf:"bytes,10,opt,name=mesh_istio,json=meshIstio,proto3,oneof"`
}

type Service_IstioCanonicalService_ struct {
	// Type used for canonical services scoped to an Istio mesh.
	// Metrics for Istio are
	// [documented here](https://istio.io/latest/docs/reference/config/metrics/)
	IstioCanonicalService *Service_IstioCanonicalService `protobuf:"bytes,11,opt,name=istio_canonical_service,json=istioCanonicalService,proto3,oneof"`
}

func (*Service_Custom_) isService_Identifier() {}

func (*Service_AppEngine_) isService_Identifier() {}

func (*Service_CloudEndpoints_) isService_Identifier() {}

func (*Service_ClusterIstio_) isService_Identifier() {}

func (*Service_MeshIstio_) isService_Identifier() {}

func (*Service_IstioCanonicalService_) isService_Identifier() {}

// A Service-Level Objective (SLO) describes a level of desired good service. It
// consists of a service-level indicator (SLI), a performance goal, and a period
// over which the objective is to be evaluated against that goal. The SLO can
// use SLIs defined in a number of different manners. Typical SLOs might include
// "99% of requests in each rolling week have latency below 200 milliseconds" or
// "99.5% of requests in each calendar month return successfully."
type ServiceLevelObjective struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name for this `ServiceLevelObjective`. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Name used for UI elements listing this SLO.
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The definition of good service, used to measure and calculate the quality
	// of the `Service`'s performance with respect to a single aspect of service
	// quality.
	ServiceLevelIndicator *ServiceLevelIndicator `protobuf:"bytes,3,opt,name=service_level_indicator,json=serviceLevelIndicator,proto3" json:"service_level_indicator,omitempty"`
	// The fraction of service that must be good in order for this objective to be
	// met. `0 < goal <= 0.999`.
	Goal float64 `protobuf:"fixed64,4,opt,name=goal,proto3" json:"goal,omitempty"`
	// The time period over which the objective will be evaluated.
	//
	// Types that are assignable to Period:
	//	*ServiceLevelObjective_RollingPeriod
	//	*ServiceLevelObjective_CalendarPeriod
	Period isServiceLevelObjective_Period `protobuf_oneof:"period"`
	// Labels which have been used to annotate the service-level objective. Label
	// keys must start with a letter. Label keys and values may contain lowercase
	// letters, numbers, underscores, and dashes. Label keys and values have a
	// maximum length of 63 characters, and must be less than 128 bytes in size.
	// Up to 64 label entries may be stored. For labels which do not have a
	// semantic value, the empty string may be supplied for the label value.
	UserLabels map[string]string `protobuf:"bytes,12,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ServiceLevelObjective) Reset() {
	*x = ServiceLevelObjective{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceLevelObjective) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceLevelObjective) ProtoMessage() {}

func (x *ServiceLevelObjective) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceLevelObjective.ProtoReflect.Descriptor instead.
func (*ServiceLevelObjective) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{1}
}

func (x *ServiceLevelObjective) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceLevelObjective) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ServiceLevelObjective) GetServiceLevelIndicator() *ServiceLevelIndicator {
	if x != nil {
		return x.ServiceLevelIndicator
	}
	return nil
}

func (x *ServiceLevelObjective) GetGoal() float64 {
	if x != nil {
		return x.Goal
	}
	return 0
}

func (m *ServiceLevelObjective) GetPeriod() isServiceLevelObjective_Period {
	if m != nil {
		return m.Period
	}
	return nil
}

func (x *ServiceLevelObjective) GetRollingPeriod() *durationpb.Duration {
	if x, ok := x.GetPeriod().(*ServiceLevelObjective_RollingPeriod); ok {
		return x.RollingPeriod
	}
	return nil
}

func (x *ServiceLevelObjective) GetCalendarPeriod() calendarperiod.CalendarPeriod {
	if x, ok := x.GetPeriod().(*ServiceLevelObjective_CalendarPeriod); ok {
		return x.CalendarPeriod
	}
	return calendarperiod.CalendarPeriod_CALENDAR_PERIOD_UNSPECIFIED
}

func (x *ServiceLevelObjective) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

type isServiceLevelObjective_Period interface {
	isServiceLevelObjective_Period()
}

type ServiceLevelObjective_RollingPeriod struct {
	// A rolling time period, semantically "in the past `<rolling_period>`".
	// Must be an integer multiple of 1 day no larger than 30 days.
	RollingPeriod *durationpb.Duration `protobuf:"bytes,5,opt,name=rolling_period,json=rollingPeriod,proto3,oneof"`
}

type ServiceLevelObjective_CalendarPeriod struct {
	// A calendar period, semantically "since the start of the current
	// `<calendar_period>`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
	// `MONTH` are supported.
	CalendarPeriod calendarperiod.CalendarPeriod `protobuf:"varint,6,opt,name=calendar_period,json=calendarPeriod,proto3,enum=google.type.CalendarPeriod,oneof"`
}

func (*ServiceLevelObjective_RollingPeriod) isServiceLevelObjective_Period() {}

func (*ServiceLevelObjective_CalendarPeriod) isServiceLevelObjective_Period() {}

// A Service-Level Indicator (SLI) describes the "performance" of a service. For
// some services, the SLI is well-defined. In such cases, the SLI can be
// described easily by referencing the well-known SLI and providing the needed
// parameters. Alternatively, a "custom" SLI can be defined with a query to the
// underlying metric store. An SLI is defined to be `good_service /
// total_service` over any queried time interval. The value of performance
// always falls into the range `0 <= performance <= 1`. A custom SLI describes
// how to compute this ratio, whether this is by dividing values from a pair of
// time series, cutting a `Distribution` into good and bad counts, or counting
// time windows in which the service complies with a criterion. For separation
// of concerns, a single Service-Level Indicator measures performance for only
// one aspect of service quality, such as fraction of successful queries or
// fast-enough queries.
type ServiceLevelIndicator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Service level indicators can be grouped by whether the "unit" of service
	// being measured is based on counts of good requests or on counts of good
	// time windows
	//
	// Types that are assignable to Type:
	//	*ServiceLevelIndicator_BasicSli
	//	*ServiceLevelIndicator_RequestBased
	//	*ServiceLevelIndicator_WindowsBased
	Type isServiceLevelIndicator_Type `protobuf_oneof:"type"`
}

func (x *ServiceLevelIndicator) Reset() {
	*x = ServiceLevelIndicator{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceLevelIndicator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceLevelIndicator) ProtoMessage() {}

func (x *ServiceLevelIndicator) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceLevelIndicator.ProtoReflect.Descriptor instead.
func (*ServiceLevelIndicator) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{2}
}

func (m *ServiceLevelIndicator) GetType() isServiceLevelIndicator_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *ServiceLevelIndicator) GetBasicSli() *BasicSli {
	if x, ok := x.GetType().(*ServiceLevelIndicator_BasicSli); ok {
		return x.BasicSli
	}
	return nil
}

func (x *ServiceLevelIndicator) GetRequestBased() *RequestBasedSli {
	if x, ok := x.GetType().(*ServiceLevelIndicator_RequestBased); ok {
		return x.RequestBased
	}
	return nil
}

func (x *ServiceLevelIndicator) GetWindowsBased() *WindowsBasedSli {
	if x, ok := x.GetType().(*ServiceLevelIndicator_WindowsBased); ok {
		return x.WindowsBased
	}
	return nil
}

type isServiceLevelIndicator_Type interface {
	isServiceLevelIndicator_Type()
}

type ServiceLevelIndicator_BasicSli struct {
	// Basic SLI on a well-known service type.
	BasicSli *BasicSli `protobuf:"bytes,4,opt,name=basic_sli,json=basicSli,proto3,oneof"`
}

type ServiceLevelIndicator_RequestBased struct {
	// Request-based SLIs
	RequestBased *RequestBasedSli `protobuf:"bytes,1,opt,name=request_based,json=requestBased,proto3,oneof"`
}

type ServiceLevelIndicator_WindowsBased struct {
	// Windows-based SLIs
	WindowsBased *WindowsBasedSli `protobuf:"bytes,2,opt,name=windows_based,json=windowsBased,proto3,oneof"`
}

func (*ServiceLevelIndicator_BasicSli) isServiceLevelIndicator_Type() {}

func (*ServiceLevelIndicator_RequestBased) isServiceLevelIndicator_Type() {}

func (*ServiceLevelIndicator_WindowsBased) isServiceLevelIndicator_Type() {}

// An SLI measuring performance on a well-known service type. Performance will
// be computed on the basis of pre-defined metrics. The type of the
// `service_resource` determines the metrics to use and the
// `service_resource.labels` and `metric_labels` are used to construct a
// monitoring filter to filter that metric down to just the data relevant to
// this service.
type BasicSli struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
	// other methods will not be used to calculate performance for this SLI. If
	// omitted, this SLI applies to all the Service's methods. For service types
	// that don't support breaking down by method, setting this field will result
	// in an error.
	Method []string `protobuf:"bytes,7,rep,name=method,proto3" json:"method,omitempty"`
	// OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
	// from other locations will not be used to calculate performance for this
	// SLI. If omitted, this SLI applies to all locations in which the Service has
	// activity. For service types that don't support breaking down by location,
	// setting this field will result in an error.
	Location []string `protobuf:"bytes,8,rep,name=location,proto3" json:"location,omitempty"`
	// OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
	// from other API versions will not be used to calculate performance for this
	// SLI. If omitted, this SLI applies to all API versions. For service types
	// that don't support breaking down by version, setting this field will result
	// in an error.
	Version []string `protobuf:"bytes,9,rep,name=version,proto3" json:"version,omitempty"`
	// This SLI can be evaluated on the basis of availability or latency.
	//
	// Types that are assignable to SliCriteria:
	//	*BasicSli_Availability
	//	*BasicSli_Latency
	SliCriteria isBasicSli_SliCriteria `protobuf_oneof:"sli_criteria"`
}

func (x *BasicSli) Reset() {
	*x = BasicSli{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BasicSli) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BasicSli) ProtoMessage() {}

func (x *BasicSli) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BasicSli.ProtoReflect.Descriptor instead.
func (*BasicSli) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{3}
}

func (x *BasicSli) GetMethod() []string {
	if x != nil {
		return x.Method
	}
	return nil
}

func (x *BasicSli) GetLocation() []string {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *BasicSli) GetVersion() []string {
	if x != nil {
		return x.Version
	}
	return nil
}

func (m *BasicSli) GetSliCriteria() isBasicSli_SliCriteria {
	if m != nil {
		return m.SliCriteria
	}
	return nil
}

func (x *BasicSli) GetAvailability() *BasicSli_AvailabilityCriteria {
	if x, ok := x.GetSliCriteria().(*BasicSli_Availability); ok {
		return x.Availability
	}
	return nil
}

func (x *BasicSli) GetLatency() *BasicSli_LatencyCriteria {
	if x, ok := x.GetSliCriteria().(*BasicSli_Latency); ok {
		return x.Latency
	}
	return nil
}

type isBasicSli_SliCriteria interface {
	isBasicSli_SliCriteria()
}

type BasicSli_Availability struct {
	// Good service is defined to be the count of requests made to this service
	// that return successfully.
	Availability *BasicSli_AvailabilityCriteria `protobuf:"bytes,2,opt,name=availability,proto3,oneof"`
}

type BasicSli_Latency struct {
	// Good service is defined to be the count of requests made to this service
	// that are fast enough with respect to `latency.threshold`.
	Latency *BasicSli_LatencyCriteria `protobuf:"bytes,3,opt,name=latency,proto3,oneof"`
}

func (*BasicSli_Availability) isBasicSli_SliCriteria() {}

func (*BasicSli_Latency) isBasicSli_SliCriteria() {}

// Range of numerical values within `min` and `max`.
type Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Range minimum.
	Min float64 `protobuf:"fixed64,1,opt,name=min,proto3" json:"min,omitempty"`
	// Range maximum.
	Max float64 `protobuf:"fixed64,2,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *Range) Reset() {
	*x = Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Range) ProtoMessage() {}

func (x *Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Range.ProtoReflect.Descriptor instead.
func (*Range) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{4}
}

func (x *Range) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *Range) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

// Service Level Indicators for which atomic units of service are counted
// directly.
type RequestBasedSli struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The means to compute a ratio of `good_service` to `total_service`.
	//
	// Types that are assignable to Method:
	//	*RequestBasedSli_GoodTotalRatio
	//	*RequestBasedSli_DistributionCut
	Method isRequestBasedSli_Method `protobuf_oneof:"method"`
}

func (x *RequestBasedSli) Reset() {
	*x = RequestBasedSli{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestBasedSli) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestBasedSli) ProtoMessage() {}

func (x *RequestBasedSli) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestBasedSli.ProtoReflect.Descriptor instead.
func (*RequestBasedSli) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{5}
}

func (m *RequestBasedSli) GetMethod() isRequestBasedSli_Method {
	if m != nil {
		return m.Method
	}
	return nil
}

func (x *RequestBasedSli) GetGoodTotalRatio() *TimeSeriesRatio {
	if x, ok := x.GetMethod().(*RequestBasedSli_GoodTotalRatio); ok {
		return x.GoodTotalRatio
	}
	return nil
}

func (x *RequestBasedSli) GetDistributionCut() *DistributionCut {
	if x, ok := x.GetMethod().(*RequestBasedSli_DistributionCut); ok {
		return x.DistributionCut
	}
	return nil
}

type isRequestBasedSli_Method interface {
	isRequestBasedSli_Method()
}

type RequestBasedSli_GoodTotalRatio struct {
	// `good_total_ratio` is used when the ratio of `good_service` to
	// `total_service` is computed from two `TimeSeries`.
	GoodTotalRatio *TimeSeriesRatio `protobuf:"bytes,1,opt,name=good_total_ratio,json=goodTotalRatio,proto3,oneof"`
}

type RequestBasedSli_DistributionCut struct {
	// `distribution_cut` is used when `good_service` is a count of values
	// aggregated in a `Distribution` that fall into a good range. The
	// `total_service` is the total count of all values aggregated in the
	// `Distribution`.
	DistributionCut *DistributionCut `protobuf:"bytes,3,opt,name=distribution_cut,json=distributionCut,proto3,oneof"`
}

func (*RequestBasedSli_GoodTotalRatio) isRequestBasedSli_Method() {}

func (*RequestBasedSli_DistributionCut) isRequestBasedSli_Method() {}

// A `TimeSeriesRatio` specifies two `TimeSeries` to use for computing the
// `good_service / total_service` ratio. The specified `TimeSeries` must have
// `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
// DELTA` or `MetricKind = CUMULATIVE`. The `TimeSeriesRatio` must specify
// exactly two of good, bad, and total, and the relationship `good_service +
// bad_service = total_service` will be assumed.
type TimeSeriesRatio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` quantifying good service provided. Must have
	// `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
	// DELTA` or `MetricKind = CUMULATIVE`.
	GoodServiceFilter string `protobuf:"bytes,4,opt,name=good_service_filter,json=goodServiceFilter,proto3" json:"good_service_filter,omitempty"`
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` quantifying bad service, either demanded service
	// that was not provided or demanded service that was of inadequate quality.
	// Must have `ValueType = DOUBLE` or `ValueType = INT64` and must have
	// `MetricKind = DELTA` or `MetricKind = CUMULATIVE`.
	BadServiceFilter string `protobuf:"bytes,5,opt,name=bad_service_filter,json=badServiceFilter,proto3" json:"bad_service_filter,omitempty"`
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` quantifying total demanded service. Must have
	// `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
	// DELTA` or `MetricKind = CUMULATIVE`.
	TotalServiceFilter string `protobuf:"bytes,6,opt,name=total_service_filter,json=totalServiceFilter,proto3" json:"total_service_filter,omitempty"`
}

func (x *TimeSeriesRatio) Reset() {
	*x = TimeSeriesRatio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeriesRatio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeriesRatio) ProtoMessage() {}

func (x *TimeSeriesRatio) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeriesRatio.ProtoReflect.Descriptor instead.
func (*TimeSeriesRatio) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{6}
}

func (x *TimeSeriesRatio) GetGoodServiceFilter() string {
	if x != nil {
		return x.GoodServiceFilter
	}
	return ""
}

func (x *TimeSeriesRatio) GetBadServiceFilter() string {
	if x != nil {
		return x.BadServiceFilter
	}
	return ""
}

func (x *TimeSeriesRatio) GetTotalServiceFilter() string {
	if x != nil {
		return x.TotalServiceFilter
	}
	return ""
}

// A `DistributionCut` defines a `TimeSeries` and thresholds used for measuring
// good service and total service. The `TimeSeries` must have `ValueType =
// DISTRIBUTION` and `MetricKind = DELTA` or `MetricKind = CUMULATIVE`. The
// computed `good_service` will be the estimated count of values in the
// `Distribution` that fall within the specified `min` and `max`.
type DistributionCut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` aggregating values. Must have `ValueType =
	// DISTRIBUTION` and `MetricKind = DELTA` or `MetricKind = CUMULATIVE`.
	DistributionFilter string `protobuf:"bytes,4,opt,name=distribution_filter,json=distributionFilter,proto3" json:"distribution_filter,omitempty"`
	// Range of values considered "good." For a one-sided range, set one bound to
	// an infinite value.
	Range *Range `protobuf:"bytes,5,opt,name=range,proto3" json:"range,omitempty"`
}

func (x *DistributionCut) Reset() {
	*x = DistributionCut{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionCut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionCut) ProtoMessage() {}

func (x *DistributionCut) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionCut.ProtoReflect.Descriptor instead.
func (*DistributionCut) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{7}
}

func (x *DistributionCut) GetDistributionFilter() string {
	if x != nil {
		return x.DistributionFilter
	}
	return ""
}

func (x *DistributionCut) GetRange() *Range {
	if x != nil {
		return x.Range
	}
	return nil
}

// A `WindowsBasedSli` defines `good_service` as the count of time windows for
// which the provided service was of good quality. Criteria for determining
// if service was good are embedded in the `window_criterion`.
type WindowsBasedSli struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The criterion to use for evaluating window goodness.
	//
	// Types that are assignable to WindowCriterion:
	//	*WindowsBasedSli_GoodBadMetricFilter
	//	*WindowsBasedSli_GoodTotalRatioThreshold
	//	*WindowsBasedSli_MetricMeanInRange
	//	*WindowsBasedSli_MetricSumInRange
	WindowCriterion isWindowsBasedSli_WindowCriterion `protobuf_oneof:"window_criterion"`
	// Duration over which window quality is evaluated. Must be an integer
	// fraction of a day and at least `60s`.
	WindowPeriod *durationpb.Duration `protobuf:"bytes,4,opt,name=window_period,json=windowPeriod,proto3" json:"window_period,omitempty"`
}

func (x *WindowsBasedSli) Reset() {
	*x = WindowsBasedSli{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsBasedSli) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsBasedSli) ProtoMessage() {}

func (x *WindowsBasedSli) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsBasedSli.ProtoReflect.Descriptor instead.
func (*WindowsBasedSli) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{8}
}

func (m *WindowsBasedSli) GetWindowCriterion() isWindowsBasedSli_WindowCriterion {
	if m != nil {
		return m.WindowCriterion
	}
	return nil
}

func (x *WindowsBasedSli) GetGoodBadMetricFilter() string {
	if x, ok := x.GetWindowCriterion().(*WindowsBasedSli_GoodBadMetricFilter); ok {
		return x.GoodBadMetricFilter
	}
	return ""
}

func (x *WindowsBasedSli) GetGoodTotalRatioThreshold() *WindowsBasedSli_PerformanceThreshold {
	if x, ok := x.GetWindowCriterion().(*WindowsBasedSli_GoodTotalRatioThreshold); ok {
		return x.GoodTotalRatioThreshold
	}
	return nil
}

func (x *WindowsBasedSli) GetMetricMeanInRange() *WindowsBasedSli_MetricRange {
	if x, ok := x.GetWindowCriterion().(*WindowsBasedSli_MetricMeanInRange); ok {
		return x.MetricMeanInRange
	}
	return nil
}

func (x *WindowsBasedSli) GetMetricSumInRange() *WindowsBasedSli_MetricRange {
	if x, ok := x.GetWindowCriterion().(*WindowsBasedSli_MetricSumInRange); ok {
		return x.MetricSumInRange
	}
	return nil
}

func (x *WindowsBasedSli) GetWindowPeriod() *durationpb.Duration {
	if x != nil {
		return x.WindowPeriod
	}
	return nil
}

type isWindowsBasedSli_WindowCriterion interface {
	isWindowsBasedSli_WindowCriterion()
}

type WindowsBasedSli_GoodBadMetricFilter struct {
	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
	// any `true` values appear in the window.
	GoodBadMetricFilter string `protobuf:"bytes,5,opt,name=good_bad_metric_filter,json=goodBadMetricFilter,proto3,oneof"`
}

type WindowsBasedSli_GoodTotalRatioThreshold struct {
	// A window is good if its `performance` is high enough.
	GoodTotalRatioThreshold *WindowsBasedSli_PerformanceThreshold `protobuf:"bytes,2,opt,name=good_total_ratio_threshold,json=goodTotalRatioThreshold,proto3,oneof"`
}

type WindowsBasedSli_MetricMeanInRange struct {
	// A window is good if the metric's value is in a good range, averaged
	// across returned streams.
	MetricMeanInRange *WindowsBasedSli_MetricRange `protobuf:"bytes,6,opt,name=metric_mean_in_range,json=metricMeanInRange,proto3,oneof"`
}

type WindowsBasedSli_MetricSumInRange struct {
	// A window is good if the metric's value is in a good range, summed across
	// returned streams.
	MetricSumInRange *WindowsBasedSli_MetricRange `protobuf:"bytes,7,opt,name=metric_sum_in_range,json=metricSumInRange,proto3,oneof"`
}

func (*WindowsBasedSli_GoodBadMetricFilter) isWindowsBasedSli_WindowCriterion() {}

func (*WindowsBasedSli_GoodTotalRatioThreshold) isWindowsBasedSli_WindowCriterion() {}

func (*WindowsBasedSli_MetricMeanInRange) isWindowsBasedSli_WindowCriterion() {}

func (*WindowsBasedSli_MetricSumInRange) isWindowsBasedSli_WindowCriterion() {}

// Custom view of service telemetry. Currently a place-holder pending final
// design.
type Service_Custom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Service_Custom) Reset() {
	*x = Service_Custom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service_Custom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_Custom) ProtoMessage() {}

func (x *Service_Custom) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_Custom.ProtoReflect.Descriptor instead.
func (*Service_Custom) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0, 0}
}

// App Engine service. Learn more at https://cloud.google.com/appengine.
type Service_AppEngine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the App Engine module underlying this service. Corresponds to
	// the `module_id` resource label in the `gae_app` monitored resource:
	// https://cloud.google.com/monitoring/api/resources#tag_gae_app
	ModuleId string `protobuf:"bytes,1,opt,name=module_id,json=moduleId,proto3" json:"module_id,omitempty"`
}

func (x *Service_AppEngine) Reset() {
	*x = Service_AppEngine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service_AppEngine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_AppEngine) ProtoMessage() {}

func (x *Service_AppEngine) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_AppEngine.ProtoReflect.Descriptor instead.
func (*Service_AppEngine) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Service_AppEngine) GetModuleId() string {
	if x != nil {
		return x.ModuleId
	}
	return ""
}

// Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
type Service_CloudEndpoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Cloud Endpoints service underlying this service.
	// Corresponds to the `service` resource label in the `api` monitored
	// resource: https://cloud.google.com/monitoring/api/resources#tag_api
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *Service_CloudEndpoints) Reset() {
	*x = Service_CloudEndpoints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service_CloudEndpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_CloudEndpoints) ProtoMessage() {}

func (x *Service_CloudEndpoints) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_CloudEndpoints.ProtoReflect.Descriptor instead.
func (*Service_CloudEndpoints) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Service_CloudEndpoints) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// Istio service scoped to a single Kubernetes cluster. Learn more at
// https://istio.io. Clusters running OSS Istio will have their services
// ingested as this type.
type Service_ClusterIstio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location of the Kubernetes cluster in which this Istio service is
	// defined. Corresponds to the `location` resource label in `k8s_cluster`
	// resources.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The name of the Kubernetes cluster in which this Istio service is
	// defined. Corresponds to the `cluster_name` resource label in
	// `k8s_cluster` resources.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// The namespace of the Istio service underlying this service. Corresponds
	// to the `destination_service_namespace` metric label in Istio metrics.
	ServiceNamespace string `protobuf:"bytes,3,opt,name=service_namespace,json=serviceNamespace,proto3" json:"service_namespace,omitempty"`
	// The name of the Istio service underlying this service. Corresponds to the
	// `destination_service_name` metric label in Istio metrics.
	ServiceName string `protobuf:"bytes,4,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
}

func (x *Service_ClusterIstio) Reset() {
	*x = Service_ClusterIstio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service_ClusterIstio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_ClusterIstio) ProtoMessage() {}

func (x *Service_ClusterIstio) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_ClusterIstio.ProtoReflect.Descriptor instead.
func (*Service_ClusterIstio) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Service_ClusterIstio) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Service_ClusterIstio) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *Service_ClusterIstio) GetServiceNamespace() string {
	if x != nil {
		return x.ServiceNamespace
	}
	return ""
}

func (x *Service_ClusterIstio) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

// Istio service scoped to an Istio mesh. Anthos clusters running ASM < 1.6.8
// will have their services ingested as this type.
type Service_MeshIstio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for the mesh in which this Istio service is defined.
	// Corresponds to the `mesh_uid` metric label in Istio metrics.
	MeshUid string `protobuf:"bytes,1,opt,name=mesh_uid,json=meshUid,proto3" json:"mesh_uid,omitempty"`
	// The namespace of the Istio service underlying this service. Corresponds
	// to the `destination_service_namespace` metric label in Istio metrics.
	ServiceNamespace string `protobuf:"bytes,3,opt,name=service_namespace,json=serviceNamespace,proto3" json:"service_namespace,omitempty"`
	// The name of the Istio service underlying this service. Corresponds to the
	// `destination_service_name` metric label in Istio metrics.
	ServiceName string `protobuf:"bytes,4,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
}

func (x *Service_MeshIstio) Reset() {
	*x = Service_MeshIstio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service_MeshIstio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_MeshIstio) ProtoMessage() {}

func (x *Service_MeshIstio) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_MeshIstio.ProtoReflect.Descriptor instead.
func (*Service_MeshIstio) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Service_MeshIstio) GetMeshUid() string {
	if x != nil {
		return x.MeshUid
	}
	return ""
}

func (x *Service_MeshIstio) GetServiceNamespace() string {
	if x != nil {
		return x.ServiceNamespace
	}
	return ""
}

func (x *Service_MeshIstio) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

// Canonical service scoped to an Istio mesh. Anthos clusters running ASM >=
// 1.6.8 will have their services ingested as this type.
type Service_IstioCanonicalService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for the Istio mesh in which this canonical service is defined.
	// Corresponds to the `mesh_uid` metric label in
	// [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
	MeshUid string `protobuf:"bytes,1,opt,name=mesh_uid,json=meshUid,proto3" json:"mesh_uid,omitempty"`
	// The namespace of the canonical service underlying this service.
	// Corresponds to the `destination_canonical_service_namespace` metric
	// label in [Istio
	// metrics](https://cloud.google.com/monitoring/api/metrics_istio).
	CanonicalServiceNamespace string `protobuf:"bytes,3,opt,name=canonical_service_namespace,json=canonicalServiceNamespace,proto3" json:"canonical_service_namespace,omitempty"`
	// The name of the canonical service underlying this service.
	// Corresponds to the `destination_canonical_service_name` metric label in
	// label in [Istio
	// metrics](https://cloud.google.com/monitoring/api/metrics_istio).
	CanonicalService string `protobuf:"bytes,4,opt,name=canonical_service,json=canonicalService,proto3" json:"canonical_service,omitempty"`
}

func (x *Service_IstioCanonicalService) Reset() {
	*x = Service_IstioCanonicalService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service_IstioCanonicalService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_IstioCanonicalService) ProtoMessage() {}

func (x *Service_IstioCanonicalService) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_IstioCanonicalService.ProtoReflect.Descriptor instead.
func (*Service_IstioCanonicalService) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Service_IstioCanonicalService) GetMeshUid() string {
	if x != nil {
		return x.MeshUid
	}
	return ""
}

func (x *Service_IstioCanonicalService) GetCanonicalServiceNamespace() string {
	if x != nil {
		return x.CanonicalServiceNamespace
	}
	return ""
}

func (x *Service_IstioCanonicalService) GetCanonicalService() string {
	if x != nil {
		return x.CanonicalService
	}
	return ""
}

// Configuration for how to query telemetry on a Service.
type Service_Telemetry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the resource that defines this service. Formatted as
	// described in https://cloud.google.com/apis/design/resource_names.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
}

func (x *Service_Telemetry) Reset() {
	*x = Service_Telemetry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service_Telemetry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service_Telemetry) ProtoMessage() {}

func (x *Service_Telemetry) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service_Telemetry.ProtoReflect.Descriptor instead.
func (*Service_Telemetry) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Service_Telemetry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

// Future parameters for the availability SLI.
type BasicSli_AvailabilityCriteria struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BasicSli_AvailabilityCriteria) Reset() {
	*x = BasicSli_AvailabilityCriteria{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BasicSli_AvailabilityCriteria) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BasicSli_AvailabilityCriteria) ProtoMessage() {}

func (x *BasicSli_AvailabilityCriteria) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BasicSli_AvailabilityCriteria.ProtoReflect.Descriptor instead.
func (*BasicSli_AvailabilityCriteria) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{3, 0}
}

// Parameters for a latency threshold SLI.
type BasicSli_LatencyCriteria struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Good service is defined to be the count of requests made to this service
	// that return in no more than `threshold`.
	Threshold *durationpb.Duration `protobuf:"bytes,3,opt,name=threshold,proto3" json:"threshold,omitempty"`
}

func (x *BasicSli_LatencyCriteria) Reset() {
	*x = BasicSli_LatencyCriteria{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BasicSli_LatencyCriteria) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BasicSli_LatencyCriteria) ProtoMessage() {}

func (x *BasicSli_LatencyCriteria) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BasicSli_LatencyCriteria.ProtoReflect.Descriptor instead.
func (*BasicSli_LatencyCriteria) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *BasicSli_LatencyCriteria) GetThreshold() *durationpb.Duration {
	if x != nil {
		return x.Threshold
	}
	return nil
}

// A `PerformanceThreshold` is used when each window is good when that window
// has a sufficiently high `performance`.
type WindowsBasedSli_PerformanceThreshold struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The means, either a request-based SLI or a basic SLI, by which to compute
	// performance over a window.
	//
	// Types that are assignable to Type:
	//	*WindowsBasedSli_PerformanceThreshold_Performance
	//	*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance
	Type isWindowsBasedSli_PerformanceThreshold_Type `protobuf_oneof:"type"`
	// If window `performance >= threshold`, the window is counted as good.
	Threshold float64 `protobuf:"fixed64,2,opt,name=threshold,proto3" json:"threshold,omitempty"`
}

func (x *WindowsBasedSli_PerformanceThreshold) Reset() {
	*x = WindowsBasedSli_PerformanceThreshold{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsBasedSli_PerformanceThreshold) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsBasedSli_PerformanceThreshold) ProtoMessage() {}

func (x *WindowsBasedSli_PerformanceThreshold) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsBasedSli_PerformanceThreshold.ProtoReflect.Descriptor instead.
func (*WindowsBasedSli_PerformanceThreshold) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{8, 0}
}

func (m *WindowsBasedSli_PerformanceThreshold) GetType() isWindowsBasedSli_PerformanceThreshold_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *WindowsBasedSli_PerformanceThreshold) GetPerformance() *RequestBasedSli {
	if x, ok := x.GetType().(*WindowsBasedSli_PerformanceThreshold_Performance); ok {
		return x.Performance
	}
	return nil
}

func (x *WindowsBasedSli_PerformanceThreshold) GetBasicSliPerformance() *BasicSli {
	if x, ok := x.GetType().(*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance); ok {
		return x.BasicSliPerformance
	}
	return nil
}

func (x *WindowsBasedSli_PerformanceThreshold) GetThreshold() float64 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

type isWindowsBasedSli_PerformanceThreshold_Type interface {
	isWindowsBasedSli_PerformanceThreshold_Type()
}

type WindowsBasedSli_PerformanceThreshold_Performance struct {
	// `RequestBasedSli` to evaluate to judge window quality.
	Performance *RequestBasedSli `protobuf:"bytes,1,opt,name=performance,proto3,oneof"`
}

type WindowsBasedSli_PerformanceThreshold_BasicSliPerformance struct {
	// `BasicSli` to evaluate to judge window quality.
	BasicSliPerformance *BasicSli `protobuf:"bytes,3,opt,name=basic_sli_performance,json=basicSliPerformance,proto3,oneof"`
}

func (*WindowsBasedSli_PerformanceThreshold_Performance) isWindowsBasedSli_PerformanceThreshold_Type() {
}

func (*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance) isWindowsBasedSli_PerformanceThreshold_Type() {
}

// A `MetricRange` is used when each window is good when the value x of a
// single `TimeSeries` satisfies `range.min <= x <= range.max`. The provided
// `TimeSeries` must have `ValueType = INT64` or `ValueType = DOUBLE` and
// `MetricKind = GAUGE`.
type WindowsBasedSli_MetricRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
	// specifying the `TimeSeries` to use for evaluating window quality.
	TimeSeries string `protobuf:"bytes,1,opt,name=time_series,json=timeSeries,proto3" json:"time_series,omitempty"`
	// Range of values considered "good." For a one-sided range, set one bound
	// to an infinite value.
	Range *Range `protobuf:"bytes,4,opt,name=range,proto3" json:"range,omitempty"`
}

func (x *WindowsBasedSli_MetricRange) Reset() {
	*x = WindowsBasedSli_MetricRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowsBasedSli_MetricRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsBasedSli_MetricRange) ProtoMessage() {}

func (x *WindowsBasedSli_MetricRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsBasedSli_MetricRange.ProtoReflect.Descriptor instead.
func (*WindowsBasedSli_MetricRange) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_service_proto_rawDescGZIP(), []int{8, 1}
}

func (x *WindowsBasedSli_MetricRange) GetTimeSeries() string {
	if x != nil {
		return x.TimeSeries
	}
	return ""
}

func (x *WindowsBasedSli_MetricRange) GetRange() *Range {
	if x != nil {
		return x.Range
	}
	return nil
}

var File_google_monitoring_v3_service_proto protoreflect.FileDescriptor

var file_google_monitoring_v3_service_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x5f, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x89, 0x0c, 0x0a, 0x07, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x48, 0x00, 0x52, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x12, 0x48, 0x0a, 0x0a, 0x61,
	0x70, 0x70, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x41,
	0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x09, 0x61, 0x70, 0x70, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x51,
	0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x73, 0x74, 0x69,
	0x6f, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x73, 0x74, 0x69,
	0x6f, 0x12, 0x48, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x68, 0x5f, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x48, 0x00,
	0x52, 0x09, 0x6d, 0x65, 0x73, 0x68, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x12, 0x6d, 0x0a, 0x17, 0x69,
	0x73, 0x74, 0x69, 0x6f, 0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x49, 0x73, 0x74, 0x69,
	0x6f, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x15, 0x69, 0x73, 0x74, 0x69, 0x6f, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x74, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x52, 0x09, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72,
	0x79, 0x12, 0x4e, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x1a, 0x08, 0x0a, 0x06, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x1a, 0x28, 0x0a, 0x09, 0x41,
	0x70, 0x70, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x49, 0x64, 0x1a, 0x2a, 0x0a, 0x0e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x1a, 0x9d, 0x01, 0x0a, 0x0c, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x73, 0x74,
	0x69, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x1a, 0x76, 0x0a, 0x09, 0x4d, 0x65, 0x73, 0x68, 0x49, 0x73, 0x74, 0x69, 0x6f, 0x12, 0x19,
	0x0a, 0x08, 0x6d, 0x65, 0x73, 0x68, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x68, 0x55, 0x69, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x9f, 0x01, 0x0a, 0x15, 0x49, 0x73,
	0x74, 0x69, 0x6f, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x68, 0x5f, 0x75, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x68, 0x55, 0x69, 0x64, 0x12, 0x3e,
	0x0a, 0x1b, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x19, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x2b,
	0x0a, 0x11, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x61, 0x6e, 0x6f, 0x6e,
	0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x1a, 0x30, 0x0a, 0x09, 0x54,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x3d, 0x0a,
	0x0f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xa7, 0x01, 0xea,
	0x41, 0xa3, 0x01, 0x0a, 0x21, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x25, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x12, 0x2f, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x12, 0x23,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x7d, 0x12, 0x01, 0x2a, 0x42, 0x0c, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x22, 0xfd, 0x06, 0x0a, 0x15, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x17, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x6f,
	0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x12, 0x42,
	0x0a, 0x0e, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x12, 0x46, 0x0a, 0x0f, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x5f, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x61, 0x6c, 0x65, 0x6e, 0x64,
	0x61, 0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x61, 0x6c, 0x65,
	0x6e, 0x64, 0x61, 0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x5c, 0x0a, 0x0b, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x34, 0x0a, 0x04, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x14, 0x0a, 0x10, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x01, 0x3a, 0xca, 0x02,
	0xea, 0x41, 0xc6, 0x02, 0x0a, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x7d, 0x12, 0x60, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x7d, 0x12,
	0x54, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x7d, 0x12, 0x01, 0x2a, 0x20, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x70, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x22, 0xfa, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x3d,
	0x0a, 0x09, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f, 0x73, 0x6c, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x53, 0x6c,
	0x69, 0x48, 0x00, 0x52, 0x08, 0x62, 0x61, 0x73, 0x69, 0x63, 0x53, 0x6c, 0x69, 0x12, 0x4c, 0x0a,
	0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x42, 0x61, 0x73, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x48, 0x00, 0x52, 0x0c, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x61, 0x73, 0x65, 0x64, 0x12, 0x4c, 0x0a, 0x0d, 0x77,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x42, 0x61, 0x73, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x48, 0x00, 0x52, 0x0c, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x42, 0x61, 0x73, 0x65, 0x64, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x22, 0xf3, 0x02, 0x0a, 0x08, 0x42, 0x61, 0x73, 0x69, 0x63, 0x53, 0x6c, 0x69, 0x12, 0x16,
	0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0c,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x53,
	0x6c, 0x69, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x4a, 0x0a, 0x07, 0x6c, 0x61, 0x74, 0x65, 0x6e,
	0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e,
	0x42, 0x61, 0x73, 0x69, 0x63, 0x53, 0x6c, 0x69, 0x2e, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x48, 0x00, 0x52, 0x07, 0x6c, 0x61, 0x74, 0x65,
	0x6e, 0x63, 0x79, 0x1a, 0x16, 0x0a, 0x14, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x1a, 0x4a, 0x0a, 0x0f, 0x4c,
	0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x37,
	0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x73, 0x6c, 0x69, 0x5f, 0x63,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x22, 0x2b, 0x0a, 0x05, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x6d,
	0x69, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x03, 0x6d, 0x61, 0x78, 0x22, 0xc2, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x42, 0x61, 0x73, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x12, 0x51, 0x0a, 0x10, 0x67, 0x6f, 0x6f, 0x64,
	0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x6f, 0x6f,
	0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x52, 0x0a, 0x10, 0x64,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0f,
	0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x74, 0x42,
	0x08, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0xa1, 0x01, 0x0a, 0x0f, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x2e, 0x0a,
	0x13, 0x67, 0x6f, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x67, 0x6f, 0x6f, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2c, 0x0a,
	0x12, 0x62, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x61, 0x64, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x75, 0x0a,
	0x0f, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x74,
	0x12, 0x2f, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x31, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x05, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x22, 0xa4, 0x06, 0x0a, 0x0f, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73,
	0x42, 0x61, 0x73, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x12, 0x35, 0x0a, 0x16, 0x67, 0x6f, 0x6f, 0x64,
	0x5f, 0x62, 0x61, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x13, 0x67, 0x6f, 0x6f, 0x64,
	0x42, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x79, 0x0a, 0x1a, 0x67, 0x6f, 0x6f, 0x64, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x42, 0x61, 0x73, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x48,
	0x00, 0x52, 0x17, 0x67, 0x6f, 0x6f, 0x64, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x61, 0x74, 0x69,
	0x6f, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x64, 0x0a, 0x14, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x69, 0x6e, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x42, 0x61, 0x73, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x11, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x61, 0x6e, 0x49, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x62, 0x0a, 0x13, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x75, 0x6d, 0x5f, 0x69,
	0x6e, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x42, 0x61, 0x73, 0x65,
	0x64, 0x53, 0x6c, 0x69, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x48, 0x00, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x75, 0x6d, 0x49, 0x6e, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x3e, 0x0a, 0x0d, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x70,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x1a, 0xdd, 0x01, 0x0a, 0x14, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x49, 0x0a,
	0x0b, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x42, 0x61, 0x73, 0x65, 0x64, 0x53, 0x6c, 0x69, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x65, 0x72,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x15, 0x62, 0x61, 0x73, 0x69,
	0x63, 0x5f, 0x73, 0x6c, 0x69, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x42,
	0x61, 0x73, 0x69, 0x63, 0x53, 0x6c, 0x69, 0x48, 0x00, 0x52, 0x13, 0x62, 0x61, 0x73, 0x69, 0x63,
	0x53, 0x6c, 0x69, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x06, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x1a, 0x61, 0x0a, 0x0b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x42, 0xce, 0x01, 0x0a, 0x18,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x42, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x33, 0x3b, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x33, 0xca,
	0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x33, 0xea, 0x02, 0x1d, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_monitoring_v3_service_proto_rawDescOnce sync.Once
	file_google_monitoring_v3_service_proto_rawDescData = file_google_monitoring_v3_service_proto_rawDesc
)

func file_google_monitoring_v3_service_proto_rawDescGZIP() []byte {
	file_google_monitoring_v3_service_proto_rawDescOnce.Do(func() {
		file_google_monitoring_v3_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_monitoring_v3_service_proto_rawDescData)
	})
	return file_google_monitoring_v3_service_proto_rawDescData
}

var file_google_monitoring_v3_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_monitoring_v3_service_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_monitoring_v3_service_proto_goTypes = []interface{}{
	(ServiceLevelObjective_View)(0),              // 0: google.monitoring.v3.ServiceLevelObjective.View
	(*Service)(nil),                              // 1: google.monitoring.v3.Service
	(*ServiceLevelObjective)(nil),                // 2: google.monitoring.v3.ServiceLevelObjective
	(*ServiceLevelIndicator)(nil),                // 3: google.monitoring.v3.ServiceLevelIndicator
	(*BasicSli)(nil),                             // 4: google.monitoring.v3.BasicSli
	(*Range)(nil),                                // 5: google.monitoring.v3.Range
	(*RequestBasedSli)(nil),                      // 6: google.monitoring.v3.RequestBasedSli
	(*TimeSeriesRatio)(nil),                      // 7: google.monitoring.v3.TimeSeriesRatio
	(*DistributionCut)(nil),                      // 8: google.monitoring.v3.DistributionCut
	(*WindowsBasedSli)(nil),                      // 9: google.monitoring.v3.WindowsBasedSli
	(*Service_Custom)(nil),                       // 10: google.monitoring.v3.Service.Custom
	(*Service_AppEngine)(nil),                    // 11: google.monitoring.v3.Service.AppEngine
	(*Service_CloudEndpoints)(nil),               // 12: google.monitoring.v3.Service.CloudEndpoints
	(*Service_ClusterIstio)(nil),                 // 13: google.monitoring.v3.Service.ClusterIstio
	(*Service_MeshIstio)(nil),                    // 14: google.monitoring.v3.Service.MeshIstio
	(*Service_IstioCanonicalService)(nil),        // 15: google.monitoring.v3.Service.IstioCanonicalService
	(*Service_Telemetry)(nil),                    // 16: google.monitoring.v3.Service.Telemetry
	nil,                                          // 17: google.monitoring.v3.Service.UserLabelsEntry
	nil,                                          // 18: google.monitoring.v3.ServiceLevelObjective.UserLabelsEntry
	(*BasicSli_AvailabilityCriteria)(nil),        // 19: google.monitoring.v3.BasicSli.AvailabilityCriteria
	(*BasicSli_LatencyCriteria)(nil),             // 20: google.monitoring.v3.BasicSli.LatencyCriteria
	(*WindowsBasedSli_PerformanceThreshold)(nil), // 21: google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
	(*WindowsBasedSli_MetricRange)(nil),          // 22: google.monitoring.v3.WindowsBasedSli.MetricRange
	(*durationpb.Duration)(nil),                  // 23: google.protobuf.Duration
	(calendarperiod.CalendarPeriod)(0),           // 24: google.type.CalendarPeriod
}
var file_google_monitoring_v3_service_proto_depIdxs = []int32{
	10, // 0: google.monitoring.v3.Service.custom:type_name -> google.monitoring.v3.Service.Custom
	11, // 1: google.monitoring.v3.Service.app_engine:type_name -> google.monitoring.v3.Service.AppEngine
	12, // 2: google.monitoring.v3.Service.cloud_endpoints:type_name -> google.monitoring.v3.Service.CloudEndpoints
	13, // 3: google.monitoring.v3.Service.cluster_istio:type_name -> google.monitoring.v3.Service.ClusterIstio
	14, // 4: google.monitoring.v3.Service.mesh_istio:type_name -> google.monitoring.v3.Service.MeshIstio
	15, // 5: google.monitoring.v3.Service.istio_canonical_service:type_name -> google.monitoring.v3.Service.IstioCanonicalService
	16, // 6: google.monitoring.v3.Service.telemetry:type_name -> google.monitoring.v3.Service.Telemetry
	17, // 7: google.monitoring.v3.Service.user_labels:type_name -> google.monitoring.v3.Service.UserLabelsEntry
	3,  // 8: google.monitoring.v3.ServiceLevelObjective.service_level_indicator:type_name -> google.monitoring.v3.ServiceLevelIndicator
	23, // 9: google.monitoring.v3.ServiceLevelObjective.rolling_period:type_name -> google.protobuf.Duration
	24, // 10: google.monitoring.v3.ServiceLevelObjective.calendar_period:type_name -> google.type.CalendarPeriod
	18, // 11: google.monitoring.v3.ServiceLevelObjective.user_labels:type_name -> google.monitoring.v3.ServiceLevelObjective.UserLabelsEntry
	4,  // 12: google.monitoring.v3.ServiceLevelIndicator.basic_sli:type_name -> google.monitoring.v3.BasicSli
	6,  // 13: google.monitoring.v3.ServiceLevelIndicator.request_based:type_name -> google.monitoring.v3.RequestBasedSli
	9,  // 14: google.monitoring.v3.ServiceLevelIndicator.windows_based:type_name -> google.monitoring.v3.WindowsBasedSli
	19, // 15: google.monitoring.v3.BasicSli.availability:type_name -> google.monitoring.v3.BasicSli.AvailabilityCriteria
	20, // 16: google.monitoring.v3.BasicSli.latency:type_name -> google.monitoring.v3.BasicSli.LatencyCriteria
	7,  // 17: google.monitoring.v3.RequestBasedSli.good_total_ratio:type_name -> google.monitoring.v3.TimeSeriesRatio
	8,  // 18: google.monitoring.v3.RequestBasedSli.distribution_cut:type_name -> google.monitoring.v3.DistributionCut
	5,  // 19: google.monitoring.v3.DistributionCut.range:type_name -> google.monitoring.v3.Range
	21, // 20: google.monitoring.v3.WindowsBasedSli.good_total_ratio_threshold:type_name -> google.monitoring.v3.WindowsBasedSli.PerformanceThreshold
	22, // 21: google.monitoring.v3.WindowsBasedSli.metric_mean_in_range:type_name -> google.monitoring.v3.WindowsBasedSli.MetricRange
	22, // 22: google.monitoring.v3.WindowsBasedSli.metric_sum_in_range:type_name -> google.monitoring.v3.WindowsBasedSli.MetricRange
	23, // 23: google.monitoring.v3.WindowsBasedSli.window_period:type_name -> google.protobuf.Duration
	23, // 24: google.monitoring.v3.BasicSli.LatencyCriteria.threshold:type_name -> google.protobuf.Duration
	6,  // 25: google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.performance:type_name -> google.monitoring.v3.RequestBasedSli
	4,  // 26: google.monitoring.v3.WindowsBasedSli.PerformanceThreshold.basic_sli_performance:type_name -> google.monitoring.v3.BasicSli
	5,  // 27: google.monitoring.v3.WindowsBasedSli.MetricRange.range:type_name -> google.monitoring.v3.Range
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_monitoring_v3_service_proto_init() }
func file_google_monitoring_v3_service_proto_init() {
	if File_google_monitoring_v3_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_monitoring_v3_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceLevelObjective); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceLevelIndicator); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BasicSli); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Range); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestBasedSli); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeriesRatio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistributionCut); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsBasedSli); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service_Custom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service_AppEngine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service_CloudEndpoints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service_ClusterIstio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service_MeshIstio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service_IstioCanonicalService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Service_Telemetry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BasicSli_AvailabilityCriteria); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BasicSli_LatencyCriteria); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsBasedSli_PerformanceThreshold); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowsBasedSli_MetricRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_monitoring_v3_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Service_Custom_)(nil),
		(*Service_AppEngine_)(nil),
		(*Service_CloudEndpoints_)(nil),
		(*Service_ClusterIstio_)(nil),
		(*Service_MeshIstio_)(nil),
		(*Service_IstioCanonicalService_)(nil),
	}
	file_google_monitoring_v3_service_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ServiceLevelObjective_RollingPeriod)(nil),
		(*ServiceLevelObjective_CalendarPeriod)(nil),
	}
	file_google_monitoring_v3_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ServiceLevelIndicator_BasicSli)(nil),
		(*ServiceLevelIndicator_RequestBased)(nil),
		(*ServiceLevelIndicator_WindowsBased)(nil),
	}
	file_google_monitoring_v3_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*BasicSli_Availability)(nil),
		(*BasicSli_Latency)(nil),
	}
	file_google_monitoring_v3_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*RequestBasedSli_GoodTotalRatio)(nil),
		(*RequestBasedSli_DistributionCut)(nil),
	}
	file_google_monitoring_v3_service_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*WindowsBasedSli_GoodBadMetricFilter)(nil),
		(*WindowsBasedSli_GoodTotalRatioThreshold)(nil),
		(*WindowsBasedSli_MetricMeanInRange)(nil),
		(*WindowsBasedSli_MetricSumInRange)(nil),
	}
	file_google_monitoring_v3_service_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*WindowsBasedSli_PerformanceThreshold_Performance)(nil),
		(*WindowsBasedSli_PerformanceThreshold_BasicSliPerformance)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_monitoring_v3_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_monitoring_v3_service_proto_goTypes,
		DependencyIndexes: file_google_monitoring_v3_service_proto_depIdxs,
		EnumInfos:         file_google_monitoring_v3_service_proto_enumTypes,
		MessageInfos:      file_google_monitoring_v3_service_proto_msgTypes,
	}.Build()
	File_google_monitoring_v3_service_proto = out.File
	file_google_monitoring_v3_service_proto_rawDesc = nil
	file_google_monitoring_v3_service_proto_goTypes = nil
	file_google_monitoring_v3_service_proto_depIdxs = nil
}
