/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the BucketObject type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &BucketObject{}

// BucketObject struct for BucketObject
type BucketObject struct {
	Key string `json:"key"`
	LastModified time.Time `json:"last_modified"`
	Size int32 `json:"size"`
	Etag *string `json:"etag,omitempty"`
}

type _BucketObject BucketObject

// NewBucketObject instantiates a new BucketObject object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBucketObject(key string, lastModified time.Time, size int32) *BucketObject {
	this := BucketObject{}
	this.Key = key
	this.LastModified = lastModified
	this.Size = size
	return &this
}

// NewBucketObjectWithDefaults instantiates a new BucketObject object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBucketObjectWithDefaults() *BucketObject {
	this := BucketObject{}
	return &this
}

// GetKey returns the Key field value
func (o *BucketObject) GetKey() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Key
}

// GetKeyOk returns a tuple with the Key field value
// and a boolean to check if the value has been set.
func (o *BucketObject) GetKeyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Key, true
}

// SetKey sets field value
func (o *BucketObject) SetKey(v string) {
	o.Key = v
}

// GetLastModified returns the LastModified field value
func (o *BucketObject) GetLastModified() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.LastModified
}

// GetLastModifiedOk returns a tuple with the LastModified field value
// and a boolean to check if the value has been set.
func (o *BucketObject) GetLastModifiedOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LastModified, true
}

// SetLastModified sets field value
func (o *BucketObject) SetLastModified(v time.Time) {
	o.LastModified = v
}

// GetSize returns the Size field value
func (o *BucketObject) GetSize() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Size
}

// GetSizeOk returns a tuple with the Size field value
// and a boolean to check if the value has been set.
func (o *BucketObject) GetSizeOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Size, true
}

// SetSize sets field value
func (o *BucketObject) SetSize(v int32) {
	o.Size = v
}

// GetEtag returns the Etag field value if set, zero value otherwise.
func (o *BucketObject) GetEtag() string {
	if o == nil || IsNil(o.Etag) {
		var ret string
		return ret
	}
	return *o.Etag
}

// GetEtagOk returns a tuple with the Etag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BucketObject) GetEtagOk() (*string, bool) {
	if o == nil || IsNil(o.Etag) {
		return nil, false
	}
	return o.Etag, true
}

// HasEtag returns a boolean if a field has been set.
func (o *BucketObject) HasEtag() bool {
	if o != nil && !IsNil(o.Etag) {
		return true
	}

	return false
}

// SetEtag gets a reference to the given string and assigns it to the Etag field.
func (o *BucketObject) SetEtag(v string) {
	o.Etag = &v
}

func (o BucketObject) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o BucketObject) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["key"] = o.Key
	toSerialize["last_modified"] = o.LastModified
	toSerialize["size"] = o.Size
	if !IsNil(o.Etag) {
		toSerialize["etag"] = o.Etag
	}
	return toSerialize, nil
}

func (o *BucketObject) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"key",
		"last_modified",
		"size",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varBucketObject := _BucketObject{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varBucketObject)

	if err != nil {
		return err
	}

	*o = BucketObject(varBucketObject)

	return err
}

type NullableBucketObject struct {
	value *BucketObject
	isSet bool
}

func (v NullableBucketObject) Get() *BucketObject {
	return v.value
}

func (v *NullableBucketObject) Set(val *BucketObject) {
	v.value = val
	v.isSet = true
}

func (v NullableBucketObject) IsSet() bool {
	return v.isSet
}

func (v *NullableBucketObject) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBucketObject(val *BucketObject) *NullableBucketObject {
	return &NullableBucketObject{value: val, isSet: true}
}

func (v NullableBucketObject) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBucketObject) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


