# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv4-prefix-sets/ipv4-prefix-set/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv4 prefix sets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__description','__prefix',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv4-prefix-sets', 'ipv4-prefix-set', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config/name (string)

    YANG Description: A user defined name of the IPv4 prefix set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: A user defined name of the IPv4 prefix set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config/description (string)

    YANG Description: A user defined IPv4 prefix set description.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user defined IPv4 prefix set description.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)


  def _get_prefix(self):
    """
    Getter method for prefix, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config/prefix (oc-inet:ipv4-prefix)

    YANG Description: A user defined list of IPv4 prefixes to be used in match
conditions. Each entry is a IPv4 + mask combination.
    """
    return self.__prefix
      
  def _set_prefix(self, v, load=False):
    """
    Setter method for prefix, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config/prefix (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_prefix is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_prefix() directly.

    YANG Description: A user defined list of IPv4 prefixes to be used in match
conditions. Each entry is a IPv4 + mask combination.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """prefix must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__prefix = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_prefix(self):
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  description = __builtin__.property(_get_description, _set_description)
  prefix = __builtin__.property(_get_prefix, _set_prefix)


  _pyangbind_elements = OrderedDict([('name', name), ('description', description), ('prefix', prefix), ])


class yc_state_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv4-prefix-sets/ipv4-prefix-set/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for IPv4 prefix sets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__description','__prefix',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv4-prefix-sets', 'ipv4-prefix-set', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state/name (string)

    YANG Description: A user defined name of the IPv4 prefix set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: A user defined name of the IPv4 prefix set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state/description (string)

    YANG Description: A user defined IPv4 prefix set description.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user defined IPv4 prefix set description.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)


  def _get_prefix(self):
    """
    Getter method for prefix, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state/prefix (oc-inet:ipv4-prefix)

    YANG Description: A user defined list of IPv4 prefixes to be used in match
conditions. Each entry is a IPv4 + mask combination.
    """
    return self.__prefix
      
  def _set_prefix(self, v, load=False):
    """
    Setter method for prefix, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state/prefix (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_prefix is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_prefix() directly.

    YANG Description: A user defined list of IPv4 prefixes to be used in match
conditions. Each entry is a IPv4 + mask combination.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """prefix must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__prefix = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_prefix(self):
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv4-prefix', is_config=False)

  name = __builtin__.property(_get_name)
  description = __builtin__.property(_get_description)
  prefix = __builtin__.property(_get_prefix)


  _pyangbind_elements = OrderedDict([('name', name), ('description', description), ('prefix', prefix), ])


class yc_ipv4_prefix_set_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv4-prefix-sets/ipv4-prefix-set. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of IPv4 prefix sets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'ipv4-prefix-set'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv4-prefix-sets', 'ipv4-prefix-set']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/name (leafref)

    YANG Description: Reference to the name of the IPv4 prefix set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the IPv4 prefix set.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config (container)

    YANG Description: Configuration data for IPv4 prefix sets.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv4 prefix sets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state (container)

    YANG Description: State data for IPv4 prefix sets.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for IPv4 prefix sets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_ipv4_prefix_sets_openconfig_defined_sets__defined_sets_ipv4_prefix_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv4-prefix-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container to hold the list of IPv4 prefix sets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__ipv4_prefix_set',)

  _yang_name = 'ipv4-prefix-sets'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ipv4_prefix_set = YANGDynClass(base=YANGListType("name",yc_ipv4_prefix_set_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set, yang_name="ipv4-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv4-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv4-prefix-sets']

  def _get_ipv4_prefix_set(self):
    """
    Getter method for ipv4_prefix_set, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set (list)

    YANG Description: List of IPv4 prefix sets.
    """
    return self.__ipv4_prefix_set
      
  def _set_ipv4_prefix_set(self, v, load=False):
    """
    Setter method for ipv4_prefix_set, mapped from YANG variable /defined_sets/ipv4_prefix_sets/ipv4_prefix_set (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv4_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv4_prefix_set() directly.

    YANG Description: List of IPv4 prefix sets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_ipv4_prefix_set_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set, yang_name="ipv4-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv4-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv4_prefix_set must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_ipv4_prefix_set_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set, yang_name="ipv4-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv4-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)""",
        })

    self.__ipv4_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv4_prefix_set(self):
    self.__ipv4_prefix_set = YANGDynClass(base=YANGListType("name",yc_ipv4_prefix_set_openconfig_defined_sets__defined_sets_ipv4_prefix_sets_ipv4_prefix_set, yang_name="ipv4-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv4-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)

  ipv4_prefix_set = __builtin__.property(_get_ipv4_prefix_set, _set_ipv4_prefix_set)


  _pyangbind_elements = OrderedDict([('ipv4_prefix_set', ipv4_prefix_set), ])


class yc_config_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv6-prefix-sets/ipv6-prefix-set/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv6 prefix sets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__description','__prefix',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv6-prefix-sets', 'ipv6-prefix-set', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config/name (string)

    YANG Description: Name of the IPv6 prefix set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the IPv6 prefix set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config/description (string)

    YANG Description: A user defined IPv6 prefix set description.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user defined IPv6 prefix set description.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)


  def _get_prefix(self):
    """
    Getter method for prefix, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config/prefix (oc-inet:ipv6-prefix)

    YANG Description: A user defined list of IPv6 prefixes to be used in match
conditions. Each entry is a IPv6 + mask combination.
    """
    return self.__prefix
      
  def _set_prefix(self, v, load=False):
    """
    Setter method for prefix, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config/prefix (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_prefix is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_prefix() directly.

    YANG Description: A user defined list of IPv6 prefixes to be used in match
conditions. Each entry is a IPv6 + mask combination.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """prefix must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__prefix = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_prefix(self):
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  description = __builtin__.property(_get_description, _set_description)
  prefix = __builtin__.property(_get_prefix, _set_prefix)


  _pyangbind_elements = OrderedDict([('name', name), ('description', description), ('prefix', prefix), ])


class yc_state_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv6-prefix-sets/ipv6-prefix-set/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for prefix lists.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__description','__prefix',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv6-prefix-sets', 'ipv6-prefix-set', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state/name (string)

    YANG Description: Name of the IPv6 prefix set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the IPv6 prefix set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state/description (string)

    YANG Description: A user defined IPv6 prefix set description.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user defined IPv6 prefix set description.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)


  def _get_prefix(self):
    """
    Getter method for prefix, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state/prefix (oc-inet:ipv6-prefix)

    YANG Description: A user defined list of IPv6 prefixes to be used in match
conditions. Each entry is a IPv6 + mask combination.
    """
    return self.__prefix
      
  def _set_prefix(self, v, load=False):
    """
    Setter method for prefix, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state/prefix (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_prefix is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_prefix() directly.

    YANG Description: A user defined list of IPv6 prefixes to be used in match
conditions. Each entry is a IPv6 + mask combination.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """prefix must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__prefix = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_prefix(self):
    self.__prefix = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'})), is_leaf=False, yang_name="prefix", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-inet:ipv6-prefix', is_config=False)

  name = __builtin__.property(_get_name)
  description = __builtin__.property(_get_description)
  prefix = __builtin__.property(_get_prefix)


  _pyangbind_elements = OrderedDict([('name', name), ('description', description), ('prefix', prefix), ])


class yc_ipv6_prefix_set_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv6-prefix-sets/ipv6-prefix-set. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of IPv6 prefix sets. Each defined set
is uniquely identified by a name
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'ipv6-prefix-set'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv6-prefix-sets', 'ipv6-prefix-set']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/name (leafref)

    YANG Description: Reference to the name of the IPv6 prefix set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the name of the IPv6 prefix set.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config (container)

    YANG Description: Configuration data for IPv6 prefix sets.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv6 prefix sets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state (container)

    YANG Description: State data for prefix lists.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for prefix lists.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_ipv6_prefix_sets_openconfig_defined_sets__defined_sets_ipv6_prefix_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/ipv6-prefix-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container to hold the list of IPv4 prefix sets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__ipv6_prefix_set',)

  _yang_name = 'ipv6-prefix-sets'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ipv6_prefix_set = YANGDynClass(base=YANGListType("name",yc_ipv6_prefix_set_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set, yang_name="ipv6-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv6-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'ipv6-prefix-sets']

  def _get_ipv6_prefix_set(self):
    """
    Getter method for ipv6_prefix_set, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set (list)

    YANG Description: List of IPv6 prefix sets. Each defined set
is uniquely identified by a name
    """
    return self.__ipv6_prefix_set
      
  def _set_ipv6_prefix_set(self, v, load=False):
    """
    Setter method for ipv6_prefix_set, mapped from YANG variable /defined_sets/ipv6_prefix_sets/ipv6_prefix_set (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6_prefix_set() directly.

    YANG Description: List of IPv6 prefix sets. Each defined set
is uniquely identified by a name
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_ipv6_prefix_set_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set, yang_name="ipv6-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv6-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6_prefix_set must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_ipv6_prefix_set_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set, yang_name="ipv6-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv6-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)""",
        })

    self.__ipv6_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6_prefix_set(self):
    self.__ipv6_prefix_set = YANGDynClass(base=YANGListType("name",yc_ipv6_prefix_set_openconfig_defined_sets__defined_sets_ipv6_prefix_sets_ipv6_prefix_set, yang_name="ipv6-prefix-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="ipv6-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)

  ipv6_prefix_set = __builtin__.property(_get_ipv6_prefix_set, _set_ipv6_prefix_set)


  _pyangbind_elements = OrderedDict([('ipv6_prefix_set', ipv6_prefix_set), ])


class yc_config_openconfig_defined_sets__defined_sets_port_sets_port_set_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/port-sets/port-set/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for port lists.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__description','__port',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    self.__port = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'port-sets', 'port-set', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/port_sets/port_set/config/name (string)

    YANG Description: A user defined name of the port set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/port_sets/port_set/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: A user defined name of the port set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /defined_sets/port_sets/port_set/config/description (string)

    YANG Description: A user defined description for the port set
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /defined_sets/port_sets/port_set/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user defined description for the port set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=True)


  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /defined_sets/port_sets/port_set/config/port (oc-pkt-match-types:port-num-range)

    YANG Description: A user defined set of ports to be
used in the match conditions.
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /defined_sets/port_sets/port_set/config/port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: A user defined set of ports to be
used in the match conditions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=True)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  description = __builtin__.property(_get_description, _set_description)
  port = __builtin__.property(_get_port, _set_port)


  _pyangbind_elements = OrderedDict([('name', name), ('description', description), ('port', port), ])


class yc_state_openconfig_defined_sets__defined_sets_port_sets_port_set_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/port-sets/port-set/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data for port lists.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__description','__port',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    self.__port = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'port-sets', 'port-set', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/port_sets/port_set/state/name (string)

    YANG Description: A user defined name of the port set.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/port_sets/port_set/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: A user defined name of the port set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /defined_sets/port_sets/port_set/state/description (string)

    YANG Description: A user defined description for the port set
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /defined_sets/port_sets/port_set/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user defined description for the port set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='string', is_config=False)


  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /defined_sets/port_sets/port_set/state/port (oc-pkt-match-types:port-num-range)

    YANG Description: A user defined set of ports to be
used in the match conditions.
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /defined_sets/port_sets/port_set/state/port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: A user defined set of ports to be
used in the match conditions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=False)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),]), is_leaf=False, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='oc-pkt-match-types:port-num-range', is_config=False)

  name = __builtin__.property(_get_name)
  description = __builtin__.property(_get_description)
  port = __builtin__.property(_get_port)


  _pyangbind_elements = OrderedDict([('name', name), ('description', description), ('port', port), ])


class yc_port_set_openconfig_defined_sets__defined_sets_port_sets_port_set(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/port-sets/port-set. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of port sets. Each por set is uniquely
identified by its name
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'port-set'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_port_sets_port_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_port_sets_port_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'port-sets', 'port-set']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /defined_sets/port_sets/port_set/name (leafref)

    YANG Description: Name of the port set. The name is used to
reference the set in match conditions.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /defined_sets/port_sets/port_set/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the port set. The name is used to
reference the set in match conditions.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /defined_sets/port_sets/port_set/config (container)

    YANG Description: Configuration data for port lists.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /defined_sets/port_sets/port_set/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for port lists.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_defined_sets__defined_sets_port_sets_port_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_port_sets_port_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_defined_sets__defined_sets_port_sets_port_set_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /defined_sets/port_sets/port_set/state (container)

    YANG Description: State data for port lists.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /defined_sets/port_sets/port_set/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data for port lists.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_defined_sets__defined_sets_port_sets_port_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_port_sets_port_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_defined_sets__defined_sets_port_sets_port_set_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_port_sets_openconfig_defined_sets__defined_sets_port_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets/port-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container to hold the list of port sets.
  """
  __slots__ = ('_path_helper', '_extmethods', '__port_set',)

  _yang_name = 'port-sets'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__port_set = YANGDynClass(base=YANGListType("name",yc_port_set_openconfig_defined_sets__defined_sets_port_sets_port_set, yang_name="port-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets', 'port-sets']

  def _get_port_set(self):
    """
    Getter method for port_set, mapped from YANG variable /defined_sets/port_sets/port_set (list)

    YANG Description: List of port sets. Each por set is uniquely
identified by its name
    """
    return self.__port_set
      
  def _set_port_set(self, v, load=False):
    """
    Setter method for port_set, mapped from YANG variable /defined_sets/port_sets/port_set (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_set() directly.

    YANG Description: List of port sets. Each por set is uniquely
identified by its name
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_port_set_openconfig_defined_sets__defined_sets_port_sets_port_set, yang_name="port-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_set must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_port_set_openconfig_defined_sets__defined_sets_port_sets_port_set, yang_name="port-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)""",
        })

    self.__port_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_set(self):
    self.__port_set = YANGDynClass(base=YANGListType("name",yc_port_set_openconfig_defined_sets__defined_sets_port_sets_port_set, yang_name="port-set", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='list', is_config=True)

  port_set = __builtin__.property(_get_port_set, _set_port_set)


  _pyangbind_elements = OrderedDict([('port_set', port_set), ])


class yc_defined_sets_openconfig_defined_sets__defined_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /defined-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level enclosing container for defined-set model
config and operational state data.
  """
  __slots__ = ('_path_helper', '_extmethods', '__ipv4_prefix_sets','__ipv6_prefix_sets','__port_sets',)

  _yang_name = 'defined-sets'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ipv4_prefix_sets = YANGDynClass(base=yc_ipv4_prefix_sets_openconfig_defined_sets__defined_sets_ipv4_prefix_sets, is_container='container', yang_name="ipv4-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    self.__ipv6_prefix_sets = YANGDynClass(base=yc_ipv6_prefix_sets_openconfig_defined_sets__defined_sets_ipv6_prefix_sets, is_container='container', yang_name="ipv6-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    self.__port_sets = YANGDynClass(base=yc_port_sets_openconfig_defined_sets__defined_sets_port_sets, is_container='container', yang_name="port-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['defined-sets']

  def _get_ipv4_prefix_sets(self):
    """
    Getter method for ipv4_prefix_sets, mapped from YANG variable /defined_sets/ipv4_prefix_sets (container)

    YANG Description: Container to hold the list of IPv4 prefix sets.
    """
    return self.__ipv4_prefix_sets
      
  def _set_ipv4_prefix_sets(self, v, load=False):
    """
    Setter method for ipv4_prefix_sets, mapped from YANG variable /defined_sets/ipv4_prefix_sets (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv4_prefix_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv4_prefix_sets() directly.

    YANG Description: Container to hold the list of IPv4 prefix sets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ipv4_prefix_sets_openconfig_defined_sets__defined_sets_ipv4_prefix_sets, is_container='container', yang_name="ipv4-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv4_prefix_sets must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ipv4_prefix_sets_openconfig_defined_sets__defined_sets_ipv4_prefix_sets, is_container='container', yang_name="ipv4-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__ipv4_prefix_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv4_prefix_sets(self):
    self.__ipv4_prefix_sets = YANGDynClass(base=yc_ipv4_prefix_sets_openconfig_defined_sets__defined_sets_ipv4_prefix_sets, is_container='container', yang_name="ipv4-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)


  def _get_ipv6_prefix_sets(self):
    """
    Getter method for ipv6_prefix_sets, mapped from YANG variable /defined_sets/ipv6_prefix_sets (container)

    YANG Description: Container to hold the list of IPv4 prefix sets.
    """
    return self.__ipv6_prefix_sets
      
  def _set_ipv6_prefix_sets(self, v, load=False):
    """
    Setter method for ipv6_prefix_sets, mapped from YANG variable /defined_sets/ipv6_prefix_sets (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ipv6_prefix_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ipv6_prefix_sets() directly.

    YANG Description: Container to hold the list of IPv4 prefix sets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ipv6_prefix_sets_openconfig_defined_sets__defined_sets_ipv6_prefix_sets, is_container='container', yang_name="ipv6-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ipv6_prefix_sets must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ipv6_prefix_sets_openconfig_defined_sets__defined_sets_ipv6_prefix_sets, is_container='container', yang_name="ipv6-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__ipv6_prefix_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ipv6_prefix_sets(self):
    self.__ipv6_prefix_sets = YANGDynClass(base=yc_ipv6_prefix_sets_openconfig_defined_sets__defined_sets_ipv6_prefix_sets, is_container='container', yang_name="ipv6-prefix-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)


  def _get_port_sets(self):
    """
    Getter method for port_sets, mapped from YANG variable /defined_sets/port_sets (container)

    YANG Description: Container to hold the list of port sets.
    """
    return self.__port_sets
      
  def _set_port_sets(self, v, load=False):
    """
    Setter method for port_sets, mapped from YANG variable /defined_sets/port_sets (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_sets() directly.

    YANG Description: Container to hold the list of port sets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_port_sets_openconfig_defined_sets__defined_sets_port_sets, is_container='container', yang_name="port-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_sets must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_port_sets_openconfig_defined_sets__defined_sets_port_sets, is_container='container', yang_name="port-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__port_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_sets(self):
    self.__port_sets = YANGDynClass(base=yc_port_sets_openconfig_defined_sets__defined_sets_port_sets, is_container='container', yang_name="port-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

  ipv4_prefix_sets = __builtin__.property(_get_ipv4_prefix_sets, _set_ipv4_prefix_sets)
  ipv6_prefix_sets = __builtin__.property(_get_ipv6_prefix_sets, _set_ipv6_prefix_sets)
  port_sets = __builtin__.property(_get_port_sets, _set_port_sets)


  _pyangbind_elements = OrderedDict([('ipv4_prefix_sets', ipv4_prefix_sets), ('ipv6_prefix_sets', ipv6_prefix_sets), ('port_sets', port_sets), ])


class openconfig_defined_sets(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-defined-sets - based on the path /openconfig-defined-sets. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state
data for defined sets (sets of IPv4 prefixes, sets of
IPv6 prefixes, sets of ports, etc). These sets are used,
for example, in network access control lists (i.e., filters,
rules, etc.) in the matching fields.
  """
  __slots__ = ('_path_helper', '_extmethods', '__defined_sets',)

  _yang_name = 'openconfig-defined-sets'
  _yang_namespace = 'http://openconfig.net/yang/defined-sets'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__defined_sets = YANGDynClass(base=yc_defined_sets_openconfig_defined_sets__defined_sets, is_container='container', yang_name="defined-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_defined_sets(self):
    """
    Getter method for defined_sets, mapped from YANG variable /defined_sets (container)

    YANG Description: Top level enclosing container for defined-set model
config and operational state data.
    """
    return self.__defined_sets
      
  def _set_defined_sets(self, v, load=False):
    """
    Setter method for defined_sets, mapped from YANG variable /defined_sets (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_defined_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_defined_sets() directly.

    YANG Description: Top level enclosing container for defined-set model
config and operational state data.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_defined_sets_openconfig_defined_sets__defined_sets, is_container='container', yang_name="defined-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """defined_sets must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_defined_sets_openconfig_defined_sets__defined_sets, is_container='container', yang_name="defined-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)""",
        })

    self.__defined_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_defined_sets(self):
    self.__defined_sets = YANGDynClass(base=yc_defined_sets_openconfig_defined_sets__defined_sets, is_container='container', yang_name="defined-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/defined-sets', defining_module='openconfig-defined-sets', yang_type='container', is_config=True)

  defined_sets = __builtin__.property(_get_defined_sets, _set_defined_sets)


  _pyangbind_elements = OrderedDict([('defined_sets', defined_sets), ])


