# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_system_utilization(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system-utilization - based on the path /openconfig-system-utilization. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module adds configuration and operational state for
system wide resource utilization thresholds.
  """
  _pyangbind_elements = {}

  

class openconfig_system_controlplane(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system-controlplane - based on the path /openconfig-system-controlplane. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module adds configuration and operational state relating to
policies for traffic destined to the system's control-plane.
Particularly, it allows for mechanisms to:
 - apply an ACL that forwards or drops traffic towards the control-plane.
 - classify traffic that is destined to the control-plane according to
   a QoS classifier.
 - schedule traffic that has been forwarded towards the control-plane,
   to allow for policies such as rate limits to be applied.
The configured policies apply generically to all control-planes that
exist within the system, and should be mapped to the internal interfaces
via which packets are forwarded to control-plane modules.
When a packet is received at an input interface - it is classified into a
forwarding group which drains to a specific queue. If this input mapping
is sufficient, the CPU-facing interface uses the specified scheduler
to determine how to drain queues. If more granular remapping is required
(e.g., to classify control-plane traffic more granularly), a user specifies
an alternate classifier that is used to reclassify traffic into
a new set of forwarding-groups (and hence queues) that can subsequently
be scheduled by the specified scheduler.
The specified control-plane ACL is applied to traffic received by the
control-plane of the system.
  """
  _pyangbind_elements = {}

  

class openconfig_aaa_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-aaa-types - based on the path /openconfig-aaa-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines shared types for data related to AAA
(authentication, authorization, accounting).
  """
  _pyangbind_elements = {}

  

class openconfig_system_terminal(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system-terminal - based on the path /openconfig-system-terminal. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
related to remote terminal services such as ssh and telnet.
  """
  _pyangbind_elements = {}

  

class openconfig_aaa(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-aaa - based on the path /openconfig-aaa. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
related to authorization, authentication, and accounting (AAA)
management.

Portions of this model reuse data definitions or structure from
RFC 7317 - A YANG Data Model for System Management
  """
  _pyangbind_elements = {}

  

class openconfig_aaa_tacacs(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-aaa-tacacs - based on the path /openconfig-aaa-tacacs. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
related to the TACACS+ protocol for authentication,
authorization, and accounting.
  """
  _pyangbind_elements = {}

  

class openconfig_aaa_radius(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-aaa-radius - based on the path /openconfig-aaa-radius. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
related to the RADIUS protocol for authentication,
authorization, and accounting.
  """
  _pyangbind_elements = {}

  

class openconfig_license(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-license - based on the path /openconfig-license. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational
state data for licenses.
  """
  _pyangbind_elements = {}

  

class openconfig_alarm_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-alarm-types - based on the path /openconfig-alarm-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines operational state data related to alarms
that the device is reporting.

This model reuses some data items defined in the draft IETF
YANG Alarm Module:
https://tools.ietf.org/html/draft-vallin-netmod-alarm-module-02

Portions of this code were derived from the draft IETF YANG Alarm
Module. Please reproduce this note if possible.

IETF code is subject to the following copyright and license:
Copyright (c) IETF Trust and the persons identified as authors of
the code.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, is permitted pursuant to, and subject to the license
terms contained in, the Simplified BSD License set forth in
Section 4.c of the IETF Trust's Legal Provisions Relating
to IETF Documents (http://trustee.ietf.org/license-info).
  """
  _pyangbind_elements = {}

  

class openconfig_system_grpc(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system-grpc - based on the path /openconfig-system-grpc. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module adds configuration and operational state relating to gRPC
services running on a network device. The GRPC_SERVICE identity is used
to create an extensible list of services that can be instantiated, with
a base set defined in this module. New services can extend the identity
to be included in the list.
  """
  _pyangbind_elements = {}

  

class openconfig_aaa_tacacs(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-aaa-tacacs - based on the path /openconfig-aaa-tacacs. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
related to the TACACS+ protocol for authentication,
authorization, and accounting.
  """
  _pyangbind_elements = {}

  

class openconfig_alarms(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-alarms - based on the path /openconfig-alarms. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines operational state data related to alarms
that the device is reporting.

This model reuses some data items defined in the draft IETF
YANG Alarm Module:
https://tools.ietf.org/html/draft-vallin-netmod-alarm-module-02

Portions of this code were derived from the draft IETF YANG Alarm
Module. Please reproduce this note if possible.

IETF code is subject to the following copyright and license:
Copyright (c) IETF Trust and the persons identified as authors of
the code.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, is permitted pursuant to, and subject to the license
terms contained in, the Simplified BSD License set forth in
Section 4.c of the IETF Trust's Legal Provisions Relating
to IETF Documents (http://trustee.ietf.org/license-info).
  """
  _pyangbind_elements = {}

  

class openconfig_procmon(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-procmon - based on the path /openconfig-procmon. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module provides data definitions for process health
monitoring of one or more processes running on the system.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_system__system_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global configuration data for the system
  """
  __slots__ = ('_path_helper', '_extmethods', '__hostname','__domain_name','__login_banner','__motd_banner',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)
    self.__domain_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)
    self.__login_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__motd_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'config']

  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /system/config/hostname (oc-inet:domain-name)

    YANG Description: The hostname of the device -- should be a single domain
label, without the domain.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /system/config/hostname (oc-inet:domain-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: The hostname of the device -- should be a single domain
label, without the domain.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with oc-inet:domain-name""",
          'defined-type': "oc-inet:domain-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)


  def _get_domain_name(self):
    """
    Getter method for domain_name, mapped from YANG variable /system/config/domain_name (oc-inet:domain-name)

    YANG Description: Specifies the domain name used to form fully qualified name
for unqualified hostnames.
    """
    return self.__domain_name
      
  def _set_domain_name(self, v, load=False):
    """
    Setter method for domain_name, mapped from YANG variable /system/config/domain_name (oc-inet:domain-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_domain_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_domain_name() directly.

    YANG Description: Specifies the domain name used to form fully qualified name
for unqualified hostnames.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """domain_name must be of a type compatible with oc-inet:domain-name""",
          'defined-type': "oc-inet:domain-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)""",
        })

    self.__domain_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_domain_name(self):
    self.__domain_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=True)


  def _get_login_banner(self):
    """
    Getter method for login_banner, mapped from YANG variable /system/config/login_banner (string)

    YANG Description: The console login message displayed before the login prompt,
i.e., before a user logs into the system.
    """
    return self.__login_banner
      
  def _set_login_banner(self, v, load=False):
    """
    Setter method for login_banner, mapped from YANG variable /system/config/login_banner (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_login_banner is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_login_banner() directly.

    YANG Description: The console login message displayed before the login prompt,
i.e., before a user logs into the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """login_banner must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__login_banner = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_login_banner(self):
    self.__login_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_motd_banner(self):
    """
    Getter method for motd_banner, mapped from YANG variable /system/config/motd_banner (string)

    YANG Description: The console message displayed after a user logs into the
system.  They system may append additional standard
information such as the current system date and time, uptime,
last login timestamp, etc.
    """
    return self.__motd_banner
      
  def _set_motd_banner(self, v, load=False):
    """
    Setter method for motd_banner, mapped from YANG variable /system/config/motd_banner (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_motd_banner is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_motd_banner() directly.

    YANG Description: The console message displayed after a user logs into the
system.  They system may append additional standard
information such as the current system date and time, uptime,
last login timestamp, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """motd_banner must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__motd_banner = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_motd_banner(self):
    self.__motd_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)

  hostname = __builtin__.property(_get_hostname, _set_hostname)
  domain_name = __builtin__.property(_get_domain_name, _set_domain_name)
  login_banner = __builtin__.property(_get_login_banner, _set_login_banner)
  motd_banner = __builtin__.property(_get_motd_banner, _set_motd_banner)


  _pyangbind_elements = OrderedDict([('hostname', hostname), ('domain_name', domain_name), ('login_banner', login_banner), ('motd_banner', motd_banner), ])


class yc_state_openconfig_system__system_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global operational state data for the system
  """
  __slots__ = ('_path_helper', '_extmethods', '__hostname','__domain_name','__login_banner','__motd_banner','__current_datetime','__boot_time','__software_version','__last_configuration_timestamp',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)
    self.__domain_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)
    self.__login_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__motd_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__current_datetime = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])[Tt](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9]):(0[0-9]|[1-5][0-9]|60)(\\.[0-9]+)?([Zz]|([+-](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])))'}), is_leaf=True, yang_name="current-datetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:date-and-time', is_config=False)
    self.__boot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="boot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__last_configuration_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-configuration-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'state']

  def _get_hostname(self):
    """
    Getter method for hostname, mapped from YANG variable /system/state/hostname (oc-inet:domain-name)

    YANG Description: The hostname of the device -- should be a single domain
label, without the domain.
    """
    return self.__hostname
      
  def _set_hostname(self, v, load=False):
    """
    Setter method for hostname, mapped from YANG variable /system/state/hostname (oc-inet:domain-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hostname is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hostname() directly.

    YANG Description: The hostname of the device -- should be a single domain
label, without the domain.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hostname must be of a type compatible with oc-inet:domain-name""",
          'defined-type': "oc-inet:domain-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)""",
        })

    self.__hostname = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hostname(self):
    self.__hostname = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="hostname", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)


  def _get_domain_name(self):
    """
    Getter method for domain_name, mapped from YANG variable /system/state/domain_name (oc-inet:domain-name)

    YANG Description: Specifies the domain name used to form fully qualified name
for unqualified hostnames.
    """
    return self.__domain_name
      
  def _set_domain_name(self, v, load=False):
    """
    Setter method for domain_name, mapped from YANG variable /system/state/domain_name (oc-inet:domain-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_domain_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_domain_name() directly.

    YANG Description: Specifies the domain name used to form fully qualified name
for unqualified hostnames.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """domain_name must be of a type compatible with oc-inet:domain-name""",
          'defined-type': "oc-inet:domain-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)""",
        })

    self.__domain_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_domain_name(self):
    self.__domain_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}), is_leaf=True, yang_name="domain-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:domain-name', is_config=False)


  def _get_login_banner(self):
    """
    Getter method for login_banner, mapped from YANG variable /system/state/login_banner (string)

    YANG Description: The console login message displayed before the login prompt,
i.e., before a user logs into the system.
    """
    return self.__login_banner
      
  def _set_login_banner(self, v, load=False):
    """
    Setter method for login_banner, mapped from YANG variable /system/state/login_banner (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_login_banner is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_login_banner() directly.

    YANG Description: The console login message displayed before the login prompt,
i.e., before a user logs into the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """login_banner must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__login_banner = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_login_banner(self):
    self.__login_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="login-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_motd_banner(self):
    """
    Getter method for motd_banner, mapped from YANG variable /system/state/motd_banner (string)

    YANG Description: The console message displayed after a user logs into the
system.  They system may append additional standard
information such as the current system date and time, uptime,
last login timestamp, etc.
    """
    return self.__motd_banner
      
  def _set_motd_banner(self, v, load=False):
    """
    Setter method for motd_banner, mapped from YANG variable /system/state/motd_banner (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_motd_banner is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_motd_banner() directly.

    YANG Description: The console message displayed after a user logs into the
system.  They system may append additional standard
information such as the current system date and time, uptime,
last login timestamp, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """motd_banner must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__motd_banner = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_motd_banner(self):
    self.__motd_banner = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="motd-banner", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_current_datetime(self):
    """
    Getter method for current_datetime, mapped from YANG variable /system/state/current_datetime (oc-yang:date-and-time)

    YANG Description: The current system date and time.
    """
    return self.__current_datetime
      
  def _set_current_datetime(self, v, load=False):
    """
    Setter method for current_datetime, mapped from YANG variable /system/state/current_datetime (oc-yang:date-and-time)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_current_datetime is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_current_datetime() directly.

    YANG Description: The current system date and time.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])[Tt](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9]):(0[0-9]|[1-5][0-9]|60)(\\.[0-9]+)?([Zz]|([+-](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])))'}), is_leaf=True, yang_name="current-datetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:date-and-time', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """current_datetime must be of a type compatible with oc-yang:date-and-time""",
          'defined-type': "oc-yang:date-and-time",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])[Tt](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9]):(0[0-9]|[1-5][0-9]|60)(\\.[0-9]+)?([Zz]|([+-](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])))'}), is_leaf=True, yang_name="current-datetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:date-and-time', is_config=False)""",
        })

    self.__current_datetime = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_current_datetime(self):
    self.__current_datetime = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])[Tt](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9]):(0[0-9]|[1-5][0-9]|60)(\\.[0-9]+)?([Zz]|([+-](0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])))'}), is_leaf=True, yang_name="current-datetime", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:date-and-time', is_config=False)


  def _get_boot_time(self):
    """
    Getter method for boot_time, mapped from YANG variable /system/state/boot_time (oc-types:timeticks64)

    YANG Description: This timestamp indicates the time that the system was last
restarted.  The value is the timestamp in nanoseconds relative
to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__boot_time
      
  def _set_boot_time(self, v, load=False):
    """
    Setter method for boot_time, mapped from YANG variable /system/state/boot_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_boot_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_boot_time() directly.

    YANG Description: This timestamp indicates the time that the system was last
restarted.  The value is the timestamp in nanoseconds relative
to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="boot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """boot_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="boot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__boot_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_boot_time(self):
    self.__boot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="boot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)


  def _get_software_version(self):
    """
    Getter method for software_version, mapped from YANG variable /system/state/software_version (string)

    YANG Description: Operating system version of the currently active controller
of the device.  It is required that this value matches the
value of the state/software-version leaf in the component
of type OPERATING_SYSTEM.
    """
    return self.__software_version
      
  def _set_software_version(self, v, load=False):
    """
    Setter method for software_version, mapped from YANG variable /system/state/software_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_version() directly.

    YANG Description: Operating system version of the currently active controller
of the device.  It is required that this value matches the
value of the state/software-version leaf in the component
of type OPERATING_SYSTEM.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__software_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_version(self):
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_last_configuration_timestamp(self):
    """
    Getter method for last_configuration_timestamp, mapped from YANG variable /system/state/last_configuration_timestamp (oc-types:timeticks64)

    YANG Description: Indicates the monotonically increasing timestamp at which the
last configuration change was made. This may may be through CLI,
gNMI or some other mechanism. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_configuration_timestamp
      
  def _set_last_configuration_timestamp(self, v, load=False):
    """
    Setter method for last_configuration_timestamp, mapped from YANG variable /system/state/last_configuration_timestamp (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_configuration_timestamp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_configuration_timestamp() directly.

    YANG Description: Indicates the monotonically increasing timestamp at which the
last configuration change was made. This may may be through CLI,
gNMI or some other mechanism. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-configuration-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_configuration_timestamp must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-configuration-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_configuration_timestamp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_configuration_timestamp(self):
    self.__last_configuration_timestamp = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-configuration-timestamp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)

  hostname = __builtin__.property(_get_hostname)
  domain_name = __builtin__.property(_get_domain_name)
  login_banner = __builtin__.property(_get_login_banner)
  motd_banner = __builtin__.property(_get_motd_banner)
  current_datetime = __builtin__.property(_get_current_datetime)
  boot_time = __builtin__.property(_get_boot_time)
  software_version = __builtin__.property(_get_software_version)
  last_configuration_timestamp = __builtin__.property(_get_last_configuration_timestamp)


  _pyangbind_elements = OrderedDict([('hostname', hostname), ('domain_name', domain_name), ('login_banner', login_banner), ('motd_banner', motd_banner), ('current_datetime', current_datetime), ('boot_time', boot_time), ('software_version', software_version), ('last_configuration_timestamp', last_configuration_timestamp), ])


class yc_state_openconfig_system__system_mount_points_mount_point_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/mount-points/mount-point/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State of system mount point.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__storage_component','__size','__available','__utilized',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__storage_component = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="storage-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    self.__size = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'mount-points', 'mount-point', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/mount_points/mount_point/state/name (string)

    YANG Description: Mount point name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/mount_points/mount_point/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Mount point name.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_storage_component(self):
    """
    Getter method for storage_component, mapped from YANG variable /system/mount_points/mount_point/state/storage_component (leafref)

    YANG Description: In the case that the filesystem that is mounted corresponds to a
physical or logical component within the system, this leaf provides
a reference to the hosting component within the /components
hierarchy.

The reference should be to the most specific component (e.g., if an
entry for /dev/sda1 exists, then this should be referred to,
otherwise a reference to /dev/sda may be provided.
    """
    return self.__storage_component
      
  def _set_storage_component(self, v, load=False):
    """
    Setter method for storage_component, mapped from YANG variable /system/mount_points/mount_point/state/storage_component (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_storage_component is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_storage_component() directly.

    YANG Description: In the case that the filesystem that is mounted corresponds to a
physical or logical component within the system, this leaf provides
a reference to the hosting component within the /components
hierarchy.

The reference should be to the most specific component (e.g., if an
entry for /dev/sda1 exists, then this should be referred to,
otherwise a reference to /dev/sda may be provided.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="storage-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """storage_component must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="storage-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)""",
        })

    self.__storage_component = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_storage_component(self):
    self.__storage_component = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="storage-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)


  def _get_size(self):
    """
    Getter method for size, mapped from YANG variable /system/mount_points/mount_point/state/size (uint64)

    YANG Description: The total size of the initialised filesystem.
    """
    return self.__size
      
  def _set_size(self, v, load=False):
    """
    Setter method for size, mapped from YANG variable /system/mount_points/mount_point/state/size (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_size is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_size() directly.

    YANG Description: The total size of the initialised filesystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """size must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)""",
        })

    self.__size = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_size(self):
    self.__size = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)


  def _get_available(self):
    """
    Getter method for available, mapped from YANG variable /system/mount_points/mount_point/state/available (uint64)

    YANG Description: The amount of unused space on the filesystem.
    """
    return self.__available
      
  def _set_available(self, v, load=False):
    """
    Setter method for available, mapped from YANG variable /system/mount_points/mount_point/state/available (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_available is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_available() directly.

    YANG Description: The amount of unused space on the filesystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """available must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)""",
        })

    self.__available = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_available(self):
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)


  def _get_utilized(self):
    """
    Getter method for utilized, mapped from YANG variable /system/mount_points/mount_point/state/utilized (uint64)

    YANG Description: The amount of space currently in use on the filesystem.
    """
    return self.__utilized
      
  def _set_utilized(self, v, load=False):
    """
    Setter method for utilized, mapped from YANG variable /system/mount_points/mount_point/state/utilized (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilized is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilized() directly.

    YANG Description: The amount of space currently in use on the filesystem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilized must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)""",
        })

    self.__utilized = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilized(self):
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)

  name = __builtin__.property(_get_name)
  storage_component = __builtin__.property(_get_storage_component)
  size = __builtin__.property(_get_size)
  available = __builtin__.property(_get_available)
  utilized = __builtin__.property(_get_utilized)


  _pyangbind_elements = OrderedDict([('name', name), ('storage_component', storage_component), ('size', size), ('available', available), ('utilized', utilized), ])


class yc_mount_point_openconfig_system__system_mount_points_mount_point(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/mount-points/mount-point. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of mount points in the system.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__state',)

  _yang_name = 'mount-point'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_mount_points_mount_point_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'mount-points', 'mount-point']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/mount_points/mount_point/name (leafref)

    YANG Description: Reference to the key for list of mount points.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/mount_points/mount_point/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the key for list of mount points.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/mount_points/mount_point/state (container)

    YANG Description: State of system mount point.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/mount_points/mount_point/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State of system mount point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_mount_points_mount_point_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_mount_points_mount_point_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_mount_points_mount_point_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('name', name), ('state', state), ])


class yc_mount_points_openconfig_system__system_mount_points(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/mount-points. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: When a system has a set of filesystems that are attached to a
directory (i.e., mounted on the system) they are expected to be
present in this list. If the system has the concept of mounting
physical or virtual resources to a mount point within the root
filesystem (/) they should also be included in this list.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mount_point',)

  _yang_name = 'mount-points'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mount_point = YANGDynClass(base=YANGListType("name",yc_mount_point_openconfig_system__system_mount_points_mount_point, yang_name="mount-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="mount-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'mount-points']

  def _get_mount_point(self):
    """
    Getter method for mount_point, mapped from YANG variable /system/mount_points/mount_point (list)

    YANG Description: List of mount points in the system.
    """
    return self.__mount_point
      
  def _set_mount_point(self, v, load=False):
    """
    Setter method for mount_point, mapped from YANG variable /system/mount_points/mount_point (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mount_point is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mount_point() directly.

    YANG Description: List of mount points in the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_mount_point_openconfig_system__system_mount_points_mount_point, yang_name="mount-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="mount-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mount_point must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_mount_point_openconfig_system__system_mount_points_mount_point, yang_name="mount-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="mount-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)""",
        })

    self.__mount_point = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mount_point(self):
    self.__mount_point = YANGDynClass(base=YANGListType("name",yc_mount_point_openconfig_system__system_mount_points_mount_point, yang_name="mount-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="mount-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)

  mount_point = __builtin__.property(_get_mount_point)


  _pyangbind_elements = OrderedDict([('mount_point', mount_point), ])


class yc_config_openconfig_system__system_aaa_authentication_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for global authentication services
  """
  __slots__ = ('_path_helper', '_extmethods', '__authentication_method',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__authentication_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'config']

  def _get_authentication_method(self):
    """
    Getter method for authentication_method, mapped from YANG variable /system/aaa/authentication/config/authentication_method (union)

    YANG Description: Ordered list of authentication methods for users.  This
can be either a reference to a server group, or a well-
defined designation in the AAA_METHOD_TYPE identity.  If
authentication fails with one method, the next defined
method is tried -- failure of all methods results in the
user being denied access.
    """
    return self.__authentication_method
      
  def _set_authentication_method(self, v, load=False):
    """
    Setter method for authentication_method, mapped from YANG variable /system/aaa/authentication/config/authentication_method (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_authentication_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_authentication_method() directly.

    YANG Description: Ordered list of authentication methods for users.  This
can be either a reference to a server group, or a well-
defined designation in the AAA_METHOD_TYPE identity.  If
authentication fails with one method, the next defined
method is tried -- failure of all methods results in the
user being denied access.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """authentication_method must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)""",
        })

    self.__authentication_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_authentication_method(self):
    self.__authentication_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

  authentication_method = __builtin__.property(_get_authentication_method, _set_authentication_method)


  _pyangbind_elements = OrderedDict([('authentication_method', authentication_method), ])


class yc_state_openconfig_system__system_aaa_authentication_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for global authentication
services
  """
  __slots__ = ('_path_helper', '_extmethods', '__authentication_method',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__authentication_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'state']

  def _get_authentication_method(self):
    """
    Getter method for authentication_method, mapped from YANG variable /system/aaa/authentication/state/authentication_method (union)

    YANG Description: Ordered list of authentication methods for users.  This
can be either a reference to a server group, or a well-
defined designation in the AAA_METHOD_TYPE identity.  If
authentication fails with one method, the next defined
method is tried -- failure of all methods results in the
user being denied access.
    """
    return self.__authentication_method
      
  def _set_authentication_method(self, v, load=False):
    """
    Setter method for authentication_method, mapped from YANG variable /system/aaa/authentication/state/authentication_method (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_authentication_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_authentication_method() directly.

    YANG Description: Ordered list of authentication methods for users.  This
can be either a reference to a server group, or a well-
defined designation in the AAA_METHOD_TYPE identity.  If
authentication fails with one method, the next defined
method is tried -- failure of all methods results in the
user being denied access.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """authentication_method must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)""",
        })

    self.__authentication_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_authentication_method(self):
    self.__authentication_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authentication-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

  authentication_method = __builtin__.property(_get_authentication_method)


  _pyangbind_elements = OrderedDict([('authentication_method', authentication_method), ])


class yc_config_openconfig_system__system_aaa_authentication_admin_user_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/admin-user/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the root user account
  """
  __slots__ = ('_path_helper', '_extmethods', '__admin_password','__admin_password_hashed',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__admin_password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__admin_password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'admin-user', 'config']

  def _get_admin_password(self):
    """
    Getter method for admin_password, mapped from YANG variable /system/aaa/authentication/admin_user/config/admin_password (string)

    YANG Description: The admin/root password, supplied as a cleartext string.
The system should hash and only store the password as a
hashed value.
    """
    return self.__admin_password
      
  def _set_admin_password(self, v, load=False):
    """
    Setter method for admin_password, mapped from YANG variable /system/aaa/authentication/admin_user/config/admin_password (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_password is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_password() directly.

    YANG Description: The admin/root password, supplied as a cleartext string.
The system should hash and only store the password as a
hashed value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_password must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__admin_password = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_password(self):
    self.__admin_password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_admin_password_hashed(self):
    """
    Getter method for admin_password_hashed, mapped from YANG variable /system/aaa/authentication/admin_user/config/admin_password_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The admin/root password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    return self.__admin_password_hashed
      
  def _set_admin_password_hashed(self, v, load=False):
    """
    Setter method for admin_password_hashed, mapped from YANG variable /system/aaa/authentication/admin_user/config/admin_password_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_password_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_password_hashed() directly.

    YANG Description: The admin/root password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_password_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)""",
        })

    self.__admin_password_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_password_hashed(self):
    self.__admin_password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)

  admin_password = __builtin__.property(_get_admin_password, _set_admin_password)
  admin_password_hashed = __builtin__.property(_get_admin_password_hashed, _set_admin_password_hashed)


  _pyangbind_elements = OrderedDict([('admin_password', admin_password), ('admin_password_hashed', admin_password_hashed), ])


class yc_state_openconfig_system__system_aaa_authentication_admin_user_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/admin-user/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the root user account
  """
  __slots__ = ('_path_helper', '_extmethods', '__admin_password','__admin_password_hashed','__admin_username',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__admin_password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__admin_password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    self.__admin_username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'admin-user', 'state']

  def _get_admin_password(self):
    """
    Getter method for admin_password, mapped from YANG variable /system/aaa/authentication/admin_user/state/admin_password (string)

    YANG Description: The admin/root password, supplied as a cleartext string.
The system should hash and only store the password as a
hashed value.
    """
    return self.__admin_password
      
  def _set_admin_password(self, v, load=False):
    """
    Setter method for admin_password, mapped from YANG variable /system/aaa/authentication/admin_user/state/admin_password (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_password is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_password() directly.

    YANG Description: The admin/root password, supplied as a cleartext string.
The system should hash and only store the password as a
hashed value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_password must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__admin_password = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_password(self):
    self.__admin_password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_admin_password_hashed(self):
    """
    Getter method for admin_password_hashed, mapped from YANG variable /system/aaa/authentication/admin_user/state/admin_password_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The admin/root password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    return self.__admin_password_hashed
      
  def _set_admin_password_hashed(self, v, load=False):
    """
    Setter method for admin_password_hashed, mapped from YANG variable /system/aaa/authentication/admin_user/state/admin_password_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_password_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_password_hashed() directly.

    YANG Description: The admin/root password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_password_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)""",
        })

    self.__admin_password_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_password_hashed(self):
    self.__admin_password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)


  def _get_admin_username(self):
    """
    Getter method for admin_username, mapped from YANG variable /system/aaa/authentication/admin_user/state/admin_username (string)

    YANG Description: Name of the administrator user account, e.g., admin, root,
etc.
    """
    return self.__admin_username
      
  def _set_admin_username(self, v, load=False):
    """
    Setter method for admin_username, mapped from YANG variable /system/aaa/authentication/admin_user/state/admin_username (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_username is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_username() directly.

    YANG Description: Name of the administrator user account, e.g., admin, root,
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="admin-username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_username must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__admin_username = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_username(self):
    self.__admin_username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="admin-username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)

  admin_password = __builtin__.property(_get_admin_password)
  admin_password_hashed = __builtin__.property(_get_admin_password_hashed)
  admin_username = __builtin__.property(_get_admin_username)


  _pyangbind_elements = OrderedDict([('admin_password', admin_password), ('admin_password_hashed', admin_password_hashed), ('admin_username', admin_username), ])


class yc_admin_user_openconfig_system__system_aaa_authentication_admin_user(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/admin-user. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the system root or admin user
configuration and operational state
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'admin-user'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_admin_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_admin_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'admin-user']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/authentication/admin_user/config (container)

    YANG Description: Configuration data for the root user account
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/authentication/admin_user/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the root user account
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_authentication_admin_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_admin_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_admin_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/authentication/admin_user/state (container)

    YANG Description: Operational state data for the root user account
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/authentication/admin_user/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the root user account
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_authentication_admin_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_admin_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_admin_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_system__system_aaa_authentication_users_user_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/users/user/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for local users
  """
  __slots__ = ('_path_helper', '_extmethods', '__username','__password','__password_hashed','__ssh_key','__role',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    self.__ssh_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__role = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'users', 'user', 'config']

  def _get_username(self):
    """
    Getter method for username, mapped from YANG variable /system/aaa/authentication/users/user/config/username (string)

    YANG Description: Assigned username for this user
    """
    return self.__username
      
  def _set_username(self, v, load=False):
    """
    Setter method for username, mapped from YANG variable /system/aaa/authentication/users/user/config/username (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_username is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_username() directly.

    YANG Description: Assigned username for this user
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """username must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__username = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_username(self):
    self.__username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_password(self):
    """
    Getter method for password, mapped from YANG variable /system/aaa/authentication/users/user/config/password (string)

    YANG Description: The user password, supplied as cleartext.  The system
must hash the value and only store the hashed value.
    """
    return self.__password
      
  def _set_password(self, v, load=False):
    """
    Setter method for password, mapped from YANG variable /system/aaa/authentication/users/user/config/password (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_password is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_password() directly.

    YANG Description: The user password, supplied as cleartext.  The system
must hash the value and only store the hashed value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """password must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__password = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_password(self):
    self.__password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_password_hashed(self):
    """
    Getter method for password_hashed, mapped from YANG variable /system/aaa/authentication/users/user/config/password_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The user password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    return self.__password_hashed
      
  def _set_password_hashed(self, v, load=False):
    """
    Setter method for password_hashed, mapped from YANG variable /system/aaa/authentication/users/user/config/password_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_password_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_password_hashed() directly.

    YANG Description: The user password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """password_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)""",
        })

    self.__password_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_password_hashed(self):
    self.__password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)


  def _get_ssh_key(self):
    """
    Getter method for ssh_key, mapped from YANG variable /system/aaa/authentication/users/user/config/ssh_key (string)

    YANG Description: SSH public key for the user (RSA or DSA)
    """
    return self.__ssh_key
      
  def _set_ssh_key(self, v, load=False):
    """
    Setter method for ssh_key, mapped from YANG variable /system/aaa/authentication/users/user/config/ssh_key (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ssh_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ssh_key() directly.

    YANG Description: SSH public key for the user (RSA or DSA)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ssh_key must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__ssh_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ssh_key(self):
    self.__ssh_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_role(self):
    """
    Getter method for role, mapped from YANG variable /system/aaa/authentication/users/user/config/role (union)

    YANG Description: Role assigned to the user.  The role must be supplied
as a role defined by the SYSTEM_DEFINED_ROLES
identity or a string that matches a user defined role.
    """
    return self.__role
      
  def _set_role(self, v, load=False):
    """
    Setter method for role, mapped from YANG variable /system/aaa/authentication/users/user/config/role (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_role() directly.

    YANG Description: Role assigned to the user.  The role must be supplied
as a role defined by the SYSTEM_DEFINED_ROLES
identity or a string that matches a user defined role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """role must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)""",
        })

    self.__role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_role(self):
    self.__role = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

  username = __builtin__.property(_get_username, _set_username)
  password = __builtin__.property(_get_password, _set_password)
  password_hashed = __builtin__.property(_get_password_hashed, _set_password_hashed)
  ssh_key = __builtin__.property(_get_ssh_key, _set_ssh_key)
  role = __builtin__.property(_get_role, _set_role)


  _pyangbind_elements = OrderedDict([('username', username), ('password', password), ('password_hashed', password_hashed), ('ssh_key', ssh_key), ('role', role), ])


class yc_state_openconfig_system__system_aaa_authentication_users_user_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/users/user/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for local users
  """
  __slots__ = ('_path_helper', '_extmethods', '__username','__password','__password_hashed','__ssh_key','__role',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    self.__ssh_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__role = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'users', 'user', 'state']

  def _get_username(self):
    """
    Getter method for username, mapped from YANG variable /system/aaa/authentication/users/user/state/username (string)

    YANG Description: Assigned username for this user
    """
    return self.__username
      
  def _set_username(self, v, load=False):
    """
    Setter method for username, mapped from YANG variable /system/aaa/authentication/users/user/state/username (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_username is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_username() directly.

    YANG Description: Assigned username for this user
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """username must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__username = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_username(self):
    self.__username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_password(self):
    """
    Getter method for password, mapped from YANG variable /system/aaa/authentication/users/user/state/password (string)

    YANG Description: The user password, supplied as cleartext.  The system
must hash the value and only store the hashed value.
    """
    return self.__password
      
  def _set_password(self, v, load=False):
    """
    Setter method for password, mapped from YANG variable /system/aaa/authentication/users/user/state/password (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_password is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_password() directly.

    YANG Description: The user password, supplied as cleartext.  The system
must hash the value and only store the hashed value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """password must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__password = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_password(self):
    self.__password = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_password_hashed(self):
    """
    Getter method for password_hashed, mapped from YANG variable /system/aaa/authentication/users/user/state/password_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The user password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    return self.__password_hashed
      
  def _set_password_hashed(self, v, load=False):
    """
    Setter method for password_hashed, mapped from YANG variable /system/aaa/authentication/users/user/state/password_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_password_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_password_hashed() directly.

    YANG Description: The user password, supplied as a hashed value
using the notation described in the definition of the
crypt-password-type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """password_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)""",
        })

    self.__password_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_password_hashed(self):
    self.__password_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="password-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)


  def _get_ssh_key(self):
    """
    Getter method for ssh_key, mapped from YANG variable /system/aaa/authentication/users/user/state/ssh_key (string)

    YANG Description: SSH public key for the user (RSA or DSA)
    """
    return self.__ssh_key
      
  def _set_ssh_key(self, v, load=False):
    """
    Setter method for ssh_key, mapped from YANG variable /system/aaa/authentication/users/user/state/ssh_key (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ssh_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ssh_key() directly.

    YANG Description: SSH public key for the user (RSA or DSA)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ssh_key must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__ssh_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ssh_key(self):
    self.__ssh_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="ssh-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_role(self):
    """
    Getter method for role, mapped from YANG variable /system/aaa/authentication/users/user/state/role (union)

    YANG Description: Role assigned to the user.  The role must be supplied
as a role defined by the SYSTEM_DEFINED_ROLES
identity or a string that matches a user defined role.
    """
    return self.__role
      
  def _set_role(self, v, load=False):
    """
    Setter method for role, mapped from YANG variable /system/aaa/authentication/users/user/state/role (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_role() directly.

    YANG Description: Role assigned to the user.  The role must be supplied
as a role defined by the SYSTEM_DEFINED_ROLES
identity or a string that matches a user defined role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """role must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)""",
        })

    self.__role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_role(self):
    self.__role = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:SYSTEM_ROLE_ADMIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),], is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

  username = __builtin__.property(_get_username)
  password = __builtin__.property(_get_password)
  password_hashed = __builtin__.property(_get_password_hashed)
  ssh_key = __builtin__.property(_get_ssh_key)
  role = __builtin__.property(_get_role)


  _pyangbind_elements = OrderedDict([('username', username), ('password', password), ('password_hashed', password_hashed), ('ssh_key', ssh_key), ('role', role), ])


class yc_user_openconfig_system__system_aaa_authentication_users_user(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/users/user. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of local users on the system
  """
  __slots__ = ('_path_helper', '_extmethods', '__username','__config','__state',)

  _yang_name = 'user'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_users_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_users_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'users', 'user']

  def _get_username(self):
    """
    Getter method for username, mapped from YANG variable /system/aaa/authentication/users/user/username (leafref)

    YANG Description: References the configured username for the user
    """
    return self.__username
      
  def _set_username(self, v, load=False):
    """
    Setter method for username, mapped from YANG variable /system/aaa/authentication/users/user/username (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_username is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_username() directly.

    YANG Description: References the configured username for the user
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """username must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__username = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_username(self):
    self.__username = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="username", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/authentication/users/user/config (container)

    YANG Description: Configuration data for local users
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/authentication/users/user/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for local users
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_authentication_users_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_users_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_users_user_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/authentication/users/user/state (container)

    YANG Description: Operational state data for local users
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/authentication/users/user/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for local users
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_authentication_users_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_users_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_users_user_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  username = __builtin__.property(_get_username, _set_username)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('username', username), ('config', config), ('state', state), ])


class yc_users_openconfig_system__system_aaa_authentication_users(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication/users. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container list of local users
  """
  __slots__ = ('_path_helper', '_extmethods', '__user',)

  _yang_name = 'users'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__user = YANGDynClass(base=YANGListType("username",yc_user_openconfig_system__system_aaa_authentication_users_user, yang_name="user", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='username', extensions=None), is_container='list', yang_name="user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication', 'users']

  def _get_user(self):
    """
    Getter method for user, mapped from YANG variable /system/aaa/authentication/users/user (list)

    YANG Description: List of local users on the system
    """
    return self.__user
      
  def _set_user(self, v, load=False):
    """
    Setter method for user, mapped from YANG variable /system/aaa/authentication/users/user (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_user is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_user() directly.

    YANG Description: List of local users on the system
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("username",yc_user_openconfig_system__system_aaa_authentication_users_user, yang_name="user", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='username', extensions=None), is_container='list', yang_name="user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """user must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("username",yc_user_openconfig_system__system_aaa_authentication_users_user, yang_name="user", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='username', extensions=None), is_container='list', yang_name="user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__user = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_user(self):
    self.__user = YANGDynClass(base=YANGListType("username",yc_user_openconfig_system__system_aaa_authentication_users_user, yang_name="user", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='username', extensions=None), is_container='list', yang_name="user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  user = __builtin__.property(_get_user, _set_user)


  _pyangbind_elements = OrderedDict([('user', user), ])


class yc_authentication_openconfig_system__system_aaa_authentication(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authentication. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for global authentication data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__admin_user','__users',)

  _yang_name = 'authentication'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__admin_user = YANGDynClass(base=yc_admin_user_openconfig_system__system_aaa_authentication_admin_user, is_container='container', yang_name="admin-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__users = YANGDynClass(base=yc_users_openconfig_system__system_aaa_authentication_users, is_container='container', yang_name="users", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authentication']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/authentication/config (container)

    YANG Description: Configuration data for global authentication services
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/authentication/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for global authentication services
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_authentication_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authentication_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/authentication/state (container)

    YANG Description: Operational state data for global authentication
services
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/authentication/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for global authentication
services
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_authentication_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authentication_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_admin_user(self):
    """
    Getter method for admin_user, mapped from YANG variable /system/aaa/authentication/admin_user (container)

    YANG Description: Top-level container for the system root or admin user
configuration and operational state
    """
    return self.__admin_user
      
  def _set_admin_user(self, v, load=False):
    """
    Setter method for admin_user, mapped from YANG variable /system/aaa/authentication/admin_user (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_user is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_user() directly.

    YANG Description: Top-level container for the system root or admin user
configuration and operational state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_admin_user_openconfig_system__system_aaa_authentication_admin_user, is_container='container', yang_name="admin-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_user must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_admin_user_openconfig_system__system_aaa_authentication_admin_user, is_container='container', yang_name="admin-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__admin_user = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_user(self):
    self.__admin_user = YANGDynClass(base=yc_admin_user_openconfig_system__system_aaa_authentication_admin_user, is_container='container', yang_name="admin-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_users(self):
    """
    Getter method for users, mapped from YANG variable /system/aaa/authentication/users (container)

    YANG Description: Enclosing container list of local users
    """
    return self.__users
      
  def _set_users(self, v, load=False):
    """
    Setter method for users, mapped from YANG variable /system/aaa/authentication/users (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_users is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_users() directly.

    YANG Description: Enclosing container list of local users
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_users_openconfig_system__system_aaa_authentication_users, is_container='container', yang_name="users", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """users must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_users_openconfig_system__system_aaa_authentication_users, is_container='container', yang_name="users", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__users = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_users(self):
    self.__users = YANGDynClass(base=yc_users_openconfig_system__system_aaa_authentication_users, is_container='container', yang_name="users", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  admin_user = __builtin__.property(_get_admin_user, _set_admin_user)
  users = __builtin__.property(_get_users, _set_users)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('admin_user', admin_user), ('users', users), ])


class yc_config_openconfig_system__system_aaa_authorization_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authorization/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for authorization based on AAA
methods
  """
  __slots__ = ('_path_helper', '_extmethods', '__authorization_method',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__authorization_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authorization', 'config']

  def _get_authorization_method(self):
    """
    Getter method for authorization_method, mapped from YANG variable /system/aaa/authorization/config/authorization_method (union)

    YANG Description: Ordered list of methods for authorizing commands.  The first
method that provides a response (positive or negative) should
be used.  The list may contain a well-defined method such
as the set of all TACACS or RADIUS servers, or the name of
a defined AAA server group.  The system must validate
that the named server group exists.
    """
    return self.__authorization_method
      
  def _set_authorization_method(self, v, load=False):
    """
    Setter method for authorization_method, mapped from YANG variable /system/aaa/authorization/config/authorization_method (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_authorization_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_authorization_method() directly.

    YANG Description: Ordered list of methods for authorizing commands.  The first
method that provides a response (positive or negative) should
be used.  The list may contain a well-defined method such
as the set of all TACACS or RADIUS servers, or the name of
a defined AAA server group.  The system must validate
that the named server group exists.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """authorization_method must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)""",
        })

    self.__authorization_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_authorization_method(self):
    self.__authorization_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

  authorization_method = __builtin__.property(_get_authorization_method, _set_authorization_method)


  _pyangbind_elements = OrderedDict([('authorization_method', authorization_method), ])


class yc_state_openconfig_system__system_aaa_authorization_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authorization/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for authorization based on AAA
  """
  __slots__ = ('_path_helper', '_extmethods', '__authorization_method',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__authorization_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authorization', 'state']

  def _get_authorization_method(self):
    """
    Getter method for authorization_method, mapped from YANG variable /system/aaa/authorization/state/authorization_method (union)

    YANG Description: Ordered list of methods for authorizing commands.  The first
method that provides a response (positive or negative) should
be used.  The list may contain a well-defined method such
as the set of all TACACS or RADIUS servers, or the name of
a defined AAA server group.  The system must validate
that the named server group exists.
    """
    return self.__authorization_method
      
  def _set_authorization_method(self, v, load=False):
    """
    Setter method for authorization_method, mapped from YANG variable /system/aaa/authorization/state/authorization_method (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_authorization_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_authorization_method() directly.

    YANG Description: Ordered list of methods for authorizing commands.  The first
method that provides a response (positive or negative) should
be used.  The list may contain a well-defined method such
as the set of all TACACS or RADIUS servers, or the name of
a defined AAA server group.  The system must validate
that the named server group exists.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """authorization_method must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)""",
        })

    self.__authorization_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_authorization_method(self):
    self.__authorization_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="authorization-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

  authorization_method = __builtin__.property(_get_authorization_method)


  _pyangbind_elements = OrderedDict([('authorization_method', authorization_method), ])


class yc_config_openconfig_system__system_aaa_authorization_events_event_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authorization/events/event/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each authorized event
  """
  __slots__ = ('_path_helper', '_extmethods', '__event_type',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authorization', 'events', 'event', 'config']

  def _get_event_type(self):
    """
    Getter method for event_type, mapped from YANG variable /system/aaa/authorization/events/event/config/event_type (identityref)

    YANG Description: The type of event to record at the AAA authorization
server
    """
    return self.__event_type
      
  def _set_event_type(self, v, load=False):
    """
    Setter method for event_type, mapped from YANG variable /system/aaa/authorization/events/event/config/event_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event_type() directly.

    YANG Description: The type of event to record at the AAA authorization
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)""",
        })

    self.__event_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event_type(self):
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)

  event_type = __builtin__.property(_get_event_type, _set_event_type)


  _pyangbind_elements = OrderedDict([('event_type', event_type), ])


class yc_state_openconfig_system__system_aaa_authorization_events_event_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authorization/events/event/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each authorized activity
  """
  __slots__ = ('_path_helper', '_extmethods', '__event_type',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authorization', 'events', 'event', 'state']

  def _get_event_type(self):
    """
    Getter method for event_type, mapped from YANG variable /system/aaa/authorization/events/event/state/event_type (identityref)

    YANG Description: The type of event to record at the AAA authorization
server
    """
    return self.__event_type
      
  def _set_event_type(self, v, load=False):
    """
    Setter method for event_type, mapped from YANG variable /system/aaa/authorization/events/event/state/event_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event_type() directly.

    YANG Description: The type of event to record at the AAA authorization
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)""",
        })

    self.__event_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event_type(self):
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_AUTHORIZATION_EVENT_CONFIG': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)

  event_type = __builtin__.property(_get_event_type)


  _pyangbind_elements = OrderedDict([('event_type', event_type), ])


class yc_event_openconfig_system__system_aaa_authorization_events_event(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authorization/events/event. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of events subject to AAA authorization
  """
  __slots__ = ('_path_helper', '_extmethods', '__event_type','__config','__state',)

  _yang_name = 'event'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authorization_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authorization_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authorization', 'events', 'event']

  def _get_event_type(self):
    """
    Getter method for event_type, mapped from YANG variable /system/aaa/authorization/events/event/event_type (leafref)

    YANG Description: Reference to the event-type list key
    """
    return self.__event_type
      
  def _set_event_type(self, v, load=False):
    """
    Setter method for event_type, mapped from YANG variable /system/aaa/authorization/events/event/event_type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event_type() directly.

    YANG Description: Reference to the event-type list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event_type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__event_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event_type(self):
    self.__event_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/authorization/events/event/config (container)

    YANG Description: Configuration data for each authorized event
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/authorization/events/event/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each authorized event
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_authorization_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_authorization_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authorization_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/authorization/events/event/state (container)

    YANG Description: Operational state data for each authorized activity
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/authorization/events/event/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each authorized activity
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_authorization_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_authorization_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authorization_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  event_type = __builtin__.property(_get_event_type, _set_event_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('event_type', event_type), ('config', config), ('state', state), ])


class yc_events_openconfig_system__system_aaa_authorization_events(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authorization/events. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the set of events subject
to authorization
  """
  __slots__ = ('_path_helper', '_extmethods', '__event',)

  _yang_name = 'events'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event = YANGDynClass(base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_authorization_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authorization', 'events']

  def _get_event(self):
    """
    Getter method for event, mapped from YANG variable /system/aaa/authorization/events/event (list)

    YANG Description: List of events subject to AAA authorization
    """
    return self.__event
      
  def _set_event(self, v, load=False):
    """
    Setter method for event, mapped from YANG variable /system/aaa/authorization/events/event (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event() directly.

    YANG Description: List of events subject to AAA authorization
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_authorization_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_authorization_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__event = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event(self):
    self.__event = YANGDynClass(base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_authorization_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  event = __builtin__.property(_get_event, _set_event)


  _pyangbind_elements = OrderedDict([('event', event), ])


class yc_authorization_openconfig_system__system_aaa_authorization(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/authorization. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for AAA authorization configuration
and operational state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__events',)

  _yang_name = 'authorization'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authorization_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authorization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__events = YANGDynClass(base=yc_events_openconfig_system__system_aaa_authorization_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'authorization']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/authorization/config (container)

    YANG Description: Configuration data for authorization based on AAA
methods
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/authorization/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for authorization based on AAA
methods
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_authorization_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_authorization_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_authorization_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/authorization/state (container)

    YANG Description: Operational state data for authorization based on AAA
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/authorization/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for authorization based on AAA
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_authorization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_authorization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_authorization_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_events(self):
    """
    Getter method for events, mapped from YANG variable /system/aaa/authorization/events (container)

    YANG Description: Enclosing container for the set of events subject
to authorization
    """
    return self.__events
      
  def _set_events(self, v, load=False):
    """
    Setter method for events, mapped from YANG variable /system/aaa/authorization/events (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_events is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_events() directly.

    YANG Description: Enclosing container for the set of events subject
to authorization
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_events_openconfig_system__system_aaa_authorization_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """events must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_events_openconfig_system__system_aaa_authorization_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__events = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_events(self):
    self.__events = YANGDynClass(base=yc_events_openconfig_system__system_aaa_authorization_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  events = __builtin__.property(_get_events, _set_events)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('events', events), ])


class yc_config_openconfig_system__system_aaa_accounting_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/accounting/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for user activity accounting.
  """
  __slots__ = ('_path_helper', '_extmethods', '__accounting_method',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__accounting_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'accounting', 'config']

  def _get_accounting_method(self):
    """
    Getter method for accounting_method, mapped from YANG variable /system/aaa/accounting/config/accounting_method (union)

    YANG Description: An ordered list of methods used for AAA accounting for this
event type.  The method is defined by the destination for
accounting data, which may be specified as the group of
all TACACS+/RADIUS servers, a defined server group, or
the local system.
    """
    return self.__accounting_method
      
  def _set_accounting_method(self, v, load=False):
    """
    Setter method for accounting_method, mapped from YANG variable /system/aaa/accounting/config/accounting_method (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_accounting_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_accounting_method() directly.

    YANG Description: An ordered list of methods used for AAA accounting for this
event type.  The method is defined by the destination for
accounting data, which may be specified as the group of
all TACACS+/RADIUS servers, a defined server group, or
the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """accounting_method must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)""",
        })

    self.__accounting_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_accounting_method(self):
    self.__accounting_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)

  accounting_method = __builtin__.property(_get_accounting_method, _set_accounting_method)


  _pyangbind_elements = OrderedDict([('accounting_method', accounting_method), ])


class yc_state_openconfig_system__system_aaa_accounting_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/accounting/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for user accounting.
  """
  __slots__ = ('_path_helper', '_extmethods', '__accounting_method',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__accounting_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'accounting', 'state']

  def _get_accounting_method(self):
    """
    Getter method for accounting_method, mapped from YANG variable /system/aaa/accounting/state/accounting_method (union)

    YANG Description: An ordered list of methods used for AAA accounting for this
event type.  The method is defined by the destination for
accounting data, which may be specified as the group of
all TACACS+/RADIUS servers, a defined server group, or
the local system.
    """
    return self.__accounting_method
      
  def _set_accounting_method(self, v, load=False):
    """
    Setter method for accounting_method, mapped from YANG variable /system/aaa/accounting/state/accounting_method (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_accounting_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_accounting_method() directly.

    YANG Description: An ordered list of methods used for AAA accounting for this
event type.  The method is defined by the destination for
accounting data, which may be specified as the group of
all TACACS+/RADIUS servers, a defined server group, or
the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """accounting_method must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)""",
        })

    self.__accounting_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_accounting_method(self):
    self.__accounting_method = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:TACACS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:RADIUS_ALL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:LOCAL': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},),six.text_type,]), is_leaf=False, yang_name="accounting-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

  accounting_method = __builtin__.property(_get_accounting_method)


  _pyangbind_elements = OrderedDict([('accounting_method', accounting_method), ])


class yc_config_openconfig_system__system_aaa_accounting_events_event_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/accounting/events/event/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for accounting events
  """
  __slots__ = ('_path_helper', '_extmethods', '__event_type','__record',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    self.__record = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'accounting', 'events', 'event', 'config']

  def _get_event_type(self):
    """
    Getter method for event_type, mapped from YANG variable /system/aaa/accounting/events/event/config/event_type (identityref)

    YANG Description: The type of activity to record at the AAA accounting
server
    """
    return self.__event_type
      
  def _set_event_type(self, v, load=False):
    """
    Setter method for event_type, mapped from YANG variable /system/aaa/accounting/events/event/config/event_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event_type() directly.

    YANG Description: The type of activity to record at the AAA accounting
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)""",
        })

    self.__event_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event_type(self):
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)


  def _get_record(self):
    """
    Getter method for record, mapped from YANG variable /system/aaa/accounting/events/event/config/record (enumeration)

    YANG Description: Type of record to send to the accounting server for this
activity type
    """
    return self.__record
      
  def _set_record(self, v, load=False):
    """
    Setter method for record, mapped from YANG variable /system/aaa/accounting/events/event/config/record (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_record is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_record() directly.

    YANG Description: Type of record to send to the accounting server for this
activity type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """record must be of a type compatible with enumeration""",
          'defined-type': "openconfig-system:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)""",
        })

    self.__record = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_record(self):
    self.__record = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)

  event_type = __builtin__.property(_get_event_type, _set_event_type)
  record = __builtin__.property(_get_record, _set_record)


  _pyangbind_elements = OrderedDict([('event_type', event_type), ('record', record), ])


class yc_state_openconfig_system__system_aaa_accounting_events_event_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/accounting/events/event/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for accounting events
  """
  __slots__ = ('_path_helper', '_extmethods', '__event_type','__record',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    self.__record = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'accounting', 'events', 'event', 'state']

  def _get_event_type(self):
    """
    Getter method for event_type, mapped from YANG variable /system/aaa/accounting/events/event/state/event_type (identityref)

    YANG Description: The type of activity to record at the AAA accounting
server
    """
    return self.__event_type
      
  def _set_event_type(self, v, load=False):
    """
    Setter method for event_type, mapped from YANG variable /system/aaa/accounting/events/event/state/event_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event_type() directly.

    YANG Description: The type of activity to record at the AAA accounting
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)""",
        })

    self.__event_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event_type(self):
    self.__event_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_COMMAND': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}, 'oc-aaa-types:AAA_ACCOUNTING_EVENT_LOGIN': {'@module': 'openconfig-aaa-types', '@namespace': 'http://openconfig.net/yang/aaa/types'}},), is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)


  def _get_record(self):
    """
    Getter method for record, mapped from YANG variable /system/aaa/accounting/events/event/state/record (enumeration)

    YANG Description: Type of record to send to the accounting server for this
activity type
    """
    return self.__record
      
  def _set_record(self, v, load=False):
    """
    Setter method for record, mapped from YANG variable /system/aaa/accounting/events/event/state/record (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_record is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_record() directly.

    YANG Description: Type of record to send to the accounting server for this
activity type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """record must be of a type compatible with enumeration""",
          'defined-type': "openconfig-system:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)""",
        })

    self.__record = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_record(self):
    self.__record = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'START_STOP': {}, 'STOP': {}},), is_leaf=True, yang_name="record", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)

  event_type = __builtin__.property(_get_event_type)
  record = __builtin__.property(_get_record)


  _pyangbind_elements = OrderedDict([('event_type', event_type), ('record', record), ])


class yc_event_openconfig_system__system_aaa_accounting_events_event(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/accounting/events/event. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of events subject to accounting
  """
  __slots__ = ('_path_helper', '_extmethods', '__event_type','__config','__state',)

  _yang_name = 'event'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_accounting_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_accounting_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'accounting', 'events', 'event']

  def _get_event_type(self):
    """
    Getter method for event_type, mapped from YANG variable /system/aaa/accounting/events/event/event_type (leafref)

    YANG Description: Reference to the event-type being logged at the
accounting server
    """
    return self.__event_type
      
  def _set_event_type(self, v, load=False):
    """
    Setter method for event_type, mapped from YANG variable /system/aaa/accounting/events/event/event_type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event_type() directly.

    YANG Description: Reference to the event-type being logged at the
accounting server
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event_type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__event_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event_type(self):
    self.__event_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="event-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/accounting/events/event/config (container)

    YANG Description: Configuration data for accounting events
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/accounting/events/event/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for accounting events
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_accounting_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_accounting_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_accounting_events_event_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/accounting/events/event/state (container)

    YANG Description: Operational state data for accounting events
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/accounting/events/event/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for accounting events
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_accounting_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_accounting_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_accounting_events_event_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  event_type = __builtin__.property(_get_event_type, _set_event_type)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('event_type', event_type), ('config', config), ('state', state), ])


class yc_events_openconfig_system__system_aaa_accounting_events(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/accounting/events. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for defining handling of events
for accounting
  """
  __slots__ = ('_path_helper', '_extmethods', '__event',)

  _yang_name = 'events'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__event = YANGDynClass(base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_accounting_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'accounting', 'events']

  def _get_event(self):
    """
    Getter method for event, mapped from YANG variable /system/aaa/accounting/events/event (list)

    YANG Description: List of events subject to accounting
    """
    return self.__event
      
  def _set_event(self, v, load=False):
    """
    Setter method for event, mapped from YANG variable /system/aaa/accounting/events/event (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_event is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_event() directly.

    YANG Description: List of events subject to accounting
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_accounting_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """event must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_accounting_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__event = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_event(self):
    self.__event = YANGDynClass(base=YANGListType("event_type",yc_event_openconfig_system__system_aaa_accounting_events_event, yang_name="event", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='event-type', extensions=None), is_container='list', yang_name="event", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  event = __builtin__.property(_get_event, _set_event)


  _pyangbind_elements = OrderedDict([('event', event), ])


class yc_accounting_openconfig_system__system_aaa_accounting(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/accounting. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for AAA accounting
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__events',)

  _yang_name = 'accounting'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_accounting_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_accounting_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__events = YANGDynClass(base=yc_events_openconfig_system__system_aaa_accounting_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'accounting']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/accounting/config (container)

    YANG Description: Configuration data for user activity accounting.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/accounting/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for user activity accounting.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_accounting_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_accounting_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_accounting_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/accounting/state (container)

    YANG Description: Operational state data for user accounting.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/accounting/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for user accounting.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_accounting_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_accounting_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_accounting_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_events(self):
    """
    Getter method for events, mapped from YANG variable /system/aaa/accounting/events (container)

    YANG Description: Enclosing container for defining handling of events
for accounting
    """
    return self.__events
      
  def _set_events(self, v, load=False):
    """
    Setter method for events, mapped from YANG variable /system/aaa/accounting/events (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_events is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_events() directly.

    YANG Description: Enclosing container for defining handling of events
for accounting
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_events_openconfig_system__system_aaa_accounting_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """events must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_events_openconfig_system__system_aaa_accounting_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__events = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_events(self):
    self.__events = YANGDynClass(base=yc_events_openconfig_system__system_aaa_accounting_events, is_container='container', yang_name="events", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  events = __builtin__.property(_get_events, _set_events)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('events', events), ])


class yc_config_openconfig_system__system_aaa_server_groups_server_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each server group
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/config/name (string)

    YANG Description: Name for the server group
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name for the server group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /system/aaa/server_groups/server_group/config/type (identityref)

    YANG Description: AAA server type -- all servers in the group must be of this
type
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /system/aaa/server_groups/server_group/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: AAA server type -- all servers in the group must be of this
type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_state_openconfig_system__system_aaa_server_groups_server_group_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each server group
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/state/name (string)

    YANG Description: Name for the server group
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name for the server group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /system/aaa/server_groups/server_group/state/type (identityref)

    YANG Description: AAA server type -- all servers in the group must be of this
type
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /system/aaa/server_groups/server_group/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: AAA server type -- all servers in the group must be of this
type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:TACACS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}, 'oc-aaa:RADIUS': {'@module': 'openconfig-aaa', '@namespace': 'http://openconfig.net/yang/aaa'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ])


class yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__address','__timeout',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config/name (string)

    YANG Description: Name assigned to the server
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name assigned to the server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_address(self):
    """
    Getter method for address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config/address (oc-inet:ip-address)

    YANG Description: Address of the authentication server
    """
    return self.__address
      
  def _set_address(self, v, load=False):
    """
    Setter method for address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config/address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_address() directly.

    YANG Description: Address of the authentication server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_address(self):
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)


  def _get_timeout(self):
    """
    Getter method for timeout, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config/timeout (uint16)

    YANG Description: Set the timeout in seconds on responses from the AAA
server
    """
    return self.__timeout
      
  def _set_timeout(self, v, load=False):
    """
    Setter method for timeout, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config/timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout() directly.

    YANG Description: Set the timeout in seconds on responses from the AAA
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)""",
        })

    self.__timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout(self):
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  address = __builtin__.property(_get_address, _set_address)
  timeout = __builtin__.property(_get_timeout, _set_timeout)


  _pyangbind_elements = OrderedDict([('name', name), ('address', address), ('timeout', timeout), ])


class yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__address','__timeout','__connection_opens','__connection_closes','__connection_aborts','__connection_failures','__connection_timeouts','__messages_sent','__messages_received','__errors_received',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    self.__connection_opens = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-opens", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__connection_closes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-closes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__connection_aborts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-aborts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__connection_failures = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__connection_timeouts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-timeouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__messages_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__messages_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__errors_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errors-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/name (string)

    YANG Description: Name assigned to the server
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name assigned to the server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_address(self):
    """
    Getter method for address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/address (oc-inet:ip-address)

    YANG Description: Address of the authentication server
    """
    return self.__address
      
  def _set_address(self, v, load=False):
    """
    Setter method for address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_address() directly.

    YANG Description: Address of the authentication server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_address(self):
    self.__address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)


  def _get_timeout(self):
    """
    Getter method for timeout, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/timeout (uint16)

    YANG Description: Set the timeout in seconds on responses from the AAA
server
    """
    return self.__timeout
      
  def _set_timeout(self, v, load=False):
    """
    Setter method for timeout, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout() directly.

    YANG Description: Set the timeout in seconds on responses from the AAA
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)""",
        })

    self.__timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout(self):
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)


  def _get_connection_opens(self):
    """
    Getter method for connection_opens, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_opens (oc-yang:counter64)

    YANG Description: Number of new connection requests sent to the server, e.g.
socket open
    """
    return self.__connection_opens
      
  def _set_connection_opens(self, v, load=False):
    """
    Setter method for connection_opens, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_opens (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connection_opens is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connection_opens() directly.

    YANG Description: Number of new connection requests sent to the server, e.g.
socket open
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-opens", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connection_opens must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-opens", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__connection_opens = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connection_opens(self):
    self.__connection_opens = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-opens", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_connection_closes(self):
    """
    Getter method for connection_closes, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_closes (oc-yang:counter64)

    YANG Description: Number of connection close requests sent to the server, e.g.
socket close
    """
    return self.__connection_closes
      
  def _set_connection_closes(self, v, load=False):
    """
    Setter method for connection_closes, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_closes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connection_closes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connection_closes() directly.

    YANG Description: Number of connection close requests sent to the server, e.g.
socket close
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-closes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connection_closes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-closes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__connection_closes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connection_closes(self):
    self.__connection_closes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-closes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_connection_aborts(self):
    """
    Getter method for connection_aborts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_aborts (oc-yang:counter64)

    YANG Description: Number of aborted connections to the server.  These do
not include connections that are close gracefully.
    """
    return self.__connection_aborts
      
  def _set_connection_aborts(self, v, load=False):
    """
    Setter method for connection_aborts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_aborts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connection_aborts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connection_aborts() directly.

    YANG Description: Number of aborted connections to the server.  These do
not include connections that are close gracefully.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-aborts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connection_aborts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-aborts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__connection_aborts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connection_aborts(self):
    self.__connection_aborts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-aborts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_connection_failures(self):
    """
    Getter method for connection_failures, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_failures (oc-yang:counter64)

    YANG Description: Number of connection failures to the server
    """
    return self.__connection_failures
      
  def _set_connection_failures(self, v, load=False):
    """
    Setter method for connection_failures, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_failures (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connection_failures is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connection_failures() directly.

    YANG Description: Number of connection failures to the server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connection_failures must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__connection_failures = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connection_failures(self):
    self.__connection_failures = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_connection_timeouts(self):
    """
    Getter method for connection_timeouts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_timeouts (oc-yang:counter64)

    YANG Description: Number of connection timeouts to the server
    """
    return self.__connection_timeouts
      
  def _set_connection_timeouts(self, v, load=False):
    """
    Setter method for connection_timeouts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/connection_timeouts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connection_timeouts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connection_timeouts() directly.

    YANG Description: Number of connection timeouts to the server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-timeouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connection_timeouts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-timeouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__connection_timeouts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connection_timeouts(self):
    self.__connection_timeouts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="connection-timeouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_messages_sent(self):
    """
    Getter method for messages_sent, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/messages_sent (oc-yang:counter64)

    YANG Description: Number of messages sent to the server
    """
    return self.__messages_sent
      
  def _set_messages_sent(self, v, load=False):
    """
    Setter method for messages_sent, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/messages_sent (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_messages_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_messages_sent() directly.

    YANG Description: Number of messages sent to the server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """messages_sent must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__messages_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_messages_sent(self):
    self.__messages_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_messages_received(self):
    """
    Getter method for messages_received, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/messages_received (oc-yang:counter64)

    YANG Description: Number of messages received by the server
    """
    return self.__messages_received
      
  def _set_messages_received(self, v, load=False):
    """
    Setter method for messages_received, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/messages_received (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_messages_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_messages_received() directly.

    YANG Description: Number of messages received by the server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """messages_received must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__messages_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_messages_received(self):
    self.__messages_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="messages-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_errors_received(self):
    """
    Getter method for errors_received, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/errors_received (oc-yang:counter64)

    YANG Description: Number of error messages received from the server
    """
    return self.__errors_received
      
  def _set_errors_received(self, v, load=False):
    """
    Setter method for errors_received, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state/errors_received (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_errors_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_errors_received() directly.

    YANG Description: Number of error messages received from the server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errors-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """errors_received must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errors-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__errors_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_errors_received(self):
    self.__errors_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errors-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)

  name = __builtin__.property(_get_name)
  address = __builtin__.property(_get_address)
  timeout = __builtin__.property(_get_timeout)
  connection_opens = __builtin__.property(_get_connection_opens)
  connection_closes = __builtin__.property(_get_connection_closes)
  connection_aborts = __builtin__.property(_get_connection_aborts)
  connection_failures = __builtin__.property(_get_connection_failures)
  connection_timeouts = __builtin__.property(_get_connection_timeouts)
  messages_sent = __builtin__.property(_get_messages_sent)
  messages_received = __builtin__.property(_get_messages_received)
  errors_received = __builtin__.property(_get_errors_received)


  _pyangbind_elements = OrderedDict([('name', name), ('address', address), ('timeout', timeout), ('connection_opens', connection_opens), ('connection_closes', connection_closes), ('connection_aborts', connection_aborts), ('connection_failures', connection_failures), ('connection_timeouts', connection_timeouts), ('messages_sent', messages_sent), ('messages_received', messages_received), ('errors_received', errors_received), ])


class yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/tacacs/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for TACACS+ server
  """
  __slots__ = ('_path_helper', '_extmethods', '__port','__secret_key','__secret_key_hashed','__source_address',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'tacacs', 'config']

  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/port (oc-inet:port-number)

    YANG Description: The port number on which to contact the TACACS server
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: The port number on which to contact the TACACS server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)


  def _get_secret_key(self):
    """
    Getter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/secret_key (oc-types:routing-password)

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    return self.__secret_key
      
  def _set_secret_key(self, v, load=False):
    """
    Setter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/secret_key (oc-types:routing-password)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key() directly.

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key must be of a type compatible with oc-types:routing-password""",
          'defined-type': "oc-types:routing-password",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)""",
        })

    self.__secret_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key(self):
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)


  def _get_secret_key_hashed(self):
    """
    Getter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/secret_key_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    return self.__secret_key_hashed
      
  def _set_secret_key_hashed(self, v, load=False):
    """
    Setter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/secret_key_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key_hashed() directly.

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)""",
        })

    self.__secret_key_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key_hashed(self):
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)


  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/source_address (oc-inet:ip-address)

    YANG Description: Source IP address to use in messages to the TACACS server
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config/source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IP address to use in messages to the TACACS server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)

  port = __builtin__.property(_get_port, _set_port)
  secret_key = __builtin__.property(_get_secret_key, _set_secret_key)
  secret_key_hashed = __builtin__.property(_get_secret_key_hashed, _set_secret_key_hashed)
  source_address = __builtin__.property(_get_source_address, _set_source_address)


  _pyangbind_elements = OrderedDict([('port', port), ('secret_key', secret_key), ('secret_key_hashed', secret_key_hashed), ('source_address', source_address), ])


class yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/tacacs/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for TACACS+ server
  """
  __slots__ = ('_path_helper', '_extmethods', '__port','__secret_key','__secret_key_hashed','__source_address',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'tacacs', 'state']

  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/port (oc-inet:port-number)

    YANG Description: The port number on which to contact the TACACS server
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: The port number on which to contact the TACACS server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(49), is_leaf=True, yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)


  def _get_secret_key(self):
    """
    Getter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/secret_key (oc-types:routing-password)

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    return self.__secret_key
      
  def _set_secret_key(self, v, load=False):
    """
    Setter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/secret_key (oc-types:routing-password)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key() directly.

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key must be of a type compatible with oc-types:routing-password""",
          'defined-type': "oc-types:routing-password",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)""",
        })

    self.__secret_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key(self):
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)


  def _get_secret_key_hashed(self):
    """
    Getter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/secret_key_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    return self.__secret_key_hashed
      
  def _set_secret_key_hashed(self, v, load=False):
    """
    Setter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/secret_key_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key_hashed() directly.

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)""",
        })

    self.__secret_key_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key_hashed(self):
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)


  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/source_address (oc-inet:ip-address)

    YANG Description: Source IP address to use in messages to the TACACS server
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state/source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IP address to use in messages to the TACACS server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)

  port = __builtin__.property(_get_port)
  secret_key = __builtin__.property(_get_secret_key)
  secret_key_hashed = __builtin__.property(_get_secret_key_hashed)
  source_address = __builtin__.property(_get_source_address)


  _pyangbind_elements = OrderedDict([('port', port), ('secret_key', secret_key), ('secret_key_hashed', secret_key_hashed), ('source_address', source_address), ])


class yc_tacacs_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/tacacs. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for TACACS+ server data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'tacacs'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'tacacs']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config (container)

    YANG Description: Configuration data for TACACS+ server
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for TACACS+ server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state (container)

    YANG Description: Operational state data for TACACS+ server
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for TACACS+ server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/radius/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for RADIUS servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__auth_port','__acct_port','__secret_key','__secret_key_hashed','__source_address','__retransmit_attempts',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__auth_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)
    self.__acct_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)
    self.__retransmit_attempts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'radius', 'config']

  def _get_auth_port(self):
    """
    Getter method for auth_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/auth_port (oc-inet:port-number)

    YANG Description: Port number for authentication requests
    """
    return self.__auth_port
      
  def _set_auth_port(self, v, load=False):
    """
    Setter method for auth_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/auth_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_auth_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_auth_port() directly.

    YANG Description: Port number for authentication requests
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """auth_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__auth_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_auth_port(self):
    self.__auth_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)


  def _get_acct_port(self):
    """
    Getter method for acct_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/acct_port (oc-inet:port-number)

    YANG Description: Port number for accounting requests
    """
    return self.__acct_port
      
  def _set_acct_port(self, v, load=False):
    """
    Setter method for acct_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/acct_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acct_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acct_port() directly.

    YANG Description: Port number for accounting requests
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acct_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__acct_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acct_port(self):
    self.__acct_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)


  def _get_secret_key(self):
    """
    Getter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/secret_key (oc-types:routing-password)

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    return self.__secret_key
      
  def _set_secret_key(self, v, load=False):
    """
    Setter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/secret_key (oc-types:routing-password)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key() directly.

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key must be of a type compatible with oc-types:routing-password""",
          'defined-type': "oc-types:routing-password",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)""",
        })

    self.__secret_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key(self):
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=True)


  def _get_secret_key_hashed(self):
    """
    Getter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/secret_key_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    return self.__secret_key_hashed
      
  def _set_secret_key_hashed(self, v, load=False):
    """
    Setter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/secret_key_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key_hashed() directly.

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)""",
        })

    self.__secret_key_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key_hashed(self):
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=True)


  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/source_address (oc-inet:ip-address)

    YANG Description: Source IP address to use in messages to the RADIUS server
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IP address to use in messages to the RADIUS server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)


  def _get_retransmit_attempts(self):
    """
    Getter method for retransmit_attempts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/retransmit_attempts (uint8)

    YANG Description: Number of times the system may resend a request to the
RADIUS server when it is unresponsive
    """
    return self.__retransmit_attempts
      
  def _set_retransmit_attempts(self, v, load=False):
    """
    Setter method for retransmit_attempts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config/retransmit_attempts (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_retransmit_attempts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_retransmit_attempts() directly.

    YANG Description: Number of times the system may resend a request to the
RADIUS server when it is unresponsive
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """retransmit_attempts must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=True)""",
        })

    self.__retransmit_attempts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_retransmit_attempts(self):
    self.__retransmit_attempts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=True)

  auth_port = __builtin__.property(_get_auth_port, _set_auth_port)
  acct_port = __builtin__.property(_get_acct_port, _set_acct_port)
  secret_key = __builtin__.property(_get_secret_key, _set_secret_key)
  secret_key_hashed = __builtin__.property(_get_secret_key_hashed, _set_secret_key_hashed)
  source_address = __builtin__.property(_get_source_address, _set_source_address)
  retransmit_attempts = __builtin__.property(_get_retransmit_attempts, _set_retransmit_attempts)


  _pyangbind_elements = OrderedDict([('auth_port', auth_port), ('acct_port', acct_port), ('secret_key', secret_key), ('secret_key_hashed', secret_key_hashed), ('source_address', source_address), ('retransmit_attempts', retransmit_attempts), ])


class yc_counters_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/radius/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A collection of RADIUS related state objects.
  """
  __slots__ = ('_path_helper', '_extmethods', '__retried_access_requests','__access_accepts','__access_rejects','__timeout_access_requests',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__retried_access_requests = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="retried-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__access_accepts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-accepts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__access_rejects = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-rejects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__timeout_access_requests = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timeout-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'radius', 'state', 'counters']

  def _get_retried_access_requests(self):
    """
    Getter method for retried_access_requests, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/retried_access_requests (oc-yang:counter64)

    YANG Description: Retransmitted Access-Request messages.
    """
    return self.__retried_access_requests
      
  def _set_retried_access_requests(self, v, load=False):
    """
    Setter method for retried_access_requests, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/retried_access_requests (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_retried_access_requests is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_retried_access_requests() directly.

    YANG Description: Retransmitted Access-Request messages.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="retried-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """retried_access_requests must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="retried-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__retried_access_requests = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_retried_access_requests(self):
    self.__retried_access_requests = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="retried-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_access_accepts(self):
    """
    Getter method for access_accepts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/access_accepts (oc-yang:counter64)

    YANG Description: Received Access-Accept messages.
    """
    return self.__access_accepts
      
  def _set_access_accepts(self, v, load=False):
    """
    Setter method for access_accepts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/access_accepts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_access_accepts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_access_accepts() directly.

    YANG Description: Received Access-Accept messages.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-accepts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """access_accepts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-accepts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__access_accepts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_access_accepts(self):
    self.__access_accepts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-accepts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_access_rejects(self):
    """
    Getter method for access_rejects, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/access_rejects (oc-yang:counter64)

    YANG Description: Received Access-Reject messages.
    """
    return self.__access_rejects
      
  def _set_access_rejects(self, v, load=False):
    """
    Setter method for access_rejects, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/access_rejects (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_access_rejects is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_access_rejects() directly.

    YANG Description: Received Access-Reject messages.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-rejects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """access_rejects must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-rejects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__access_rejects = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_access_rejects(self):
    self.__access_rejects = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="access-rejects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_timeout_access_requests(self):
    """
    Getter method for timeout_access_requests, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/timeout_access_requests (oc-yang:counter64)

    YANG Description: Access-Request messages that have timed-out,
requiring retransmission.
    """
    return self.__timeout_access_requests
      
  def _set_timeout_access_requests(self, v, load=False):
    """
    Setter method for timeout_access_requests, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters/timeout_access_requests (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout_access_requests is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout_access_requests() directly.

    YANG Description: Access-Request messages that have timed-out,
requiring retransmission.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timeout-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout_access_requests must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timeout-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__timeout_access_requests = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout_access_requests(self):
    self.__timeout_access_requests = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="timeout-access-requests", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)

  retried_access_requests = __builtin__.property(_get_retried_access_requests)
  access_accepts = __builtin__.property(_get_access_accepts)
  access_rejects = __builtin__.property(_get_access_rejects)
  timeout_access_requests = __builtin__.property(_get_timeout_access_requests)


  _pyangbind_elements = OrderedDict([('retried_access_requests', retried_access_requests), ('access_accepts', access_accepts), ('access_rejects', access_rejects), ('timeout_access_requests', timeout_access_requests), ])


class yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/radius/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for RADIUS servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__auth_port','__acct_port','__secret_key','__secret_key_hashed','__source_address','__retransmit_attempts','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__auth_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)
    self.__acct_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)
    self.__retransmit_attempts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'radius', 'state']

  def _get_auth_port(self):
    """
    Getter method for auth_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/auth_port (oc-inet:port-number)

    YANG Description: Port number for authentication requests
    """
    return self.__auth_port
      
  def _set_auth_port(self, v, load=False):
    """
    Setter method for auth_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/auth_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_auth_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_auth_port() directly.

    YANG Description: Port number for authentication requests
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """auth_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__auth_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_auth_port(self):
    self.__auth_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1812), is_leaf=True, yang_name="auth-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)


  def _get_acct_port(self):
    """
    Getter method for acct_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/acct_port (oc-inet:port-number)

    YANG Description: Port number for accounting requests
    """
    return self.__acct_port
      
  def _set_acct_port(self, v, load=False):
    """
    Setter method for acct_port, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/acct_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acct_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acct_port() directly.

    YANG Description: Port number for accounting requests
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acct_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__acct_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acct_port(self):
    self.__acct_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(1813), is_leaf=True, yang_name="acct-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)


  def _get_secret_key(self):
    """
    Getter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/secret_key (oc-types:routing-password)

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    return self.__secret_key
      
  def _set_secret_key(self, v, load=False):
    """
    Setter method for secret_key, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/secret_key (oc-types:routing-password)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key() directly.

    YANG Description: The unencrypted shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key must be of a type compatible with oc-types:routing-password""",
          'defined-type': "oc-types:routing-password",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)""",
        })

    self.__secret_key = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key(self):
    self.__secret_key = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:routing-password', is_config=False)


  def _get_secret_key_hashed(self):
    """
    Getter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/secret_key_hashed (oc-aaa-types:crypt-password-type)

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    return self.__secret_key_hashed
      
  def _set_secret_key_hashed(self, v, load=False):
    """
    Setter method for secret_key_hashed, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/secret_key_hashed (oc-aaa-types:crypt-password-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_secret_key_hashed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_secret_key_hashed() directly.

    YANG Description: The hashed shared key used between the authentication
server and the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """secret_key_hashed must be of a type compatible with oc-aaa-types:crypt-password-type""",
          'defined-type': "oc-aaa-types:crypt-password-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)""",
        })

    self.__secret_key_hashed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_secret_key_hashed(self):
    self.__secret_key_hashed = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="secret-key-hashed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-aaa-types:crypt-password-type', is_config=False)


  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/source_address (oc-inet:ip-address)

    YANG Description: Source IP address to use in messages to the RADIUS server
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IP address to use in messages to the RADIUS server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)


  def _get_retransmit_attempts(self):
    """
    Getter method for retransmit_attempts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/retransmit_attempts (uint8)

    YANG Description: Number of times the system may resend a request to the
RADIUS server when it is unresponsive
    """
    return self.__retransmit_attempts
      
  def _set_retransmit_attempts(self, v, load=False):
    """
    Setter method for retransmit_attempts, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/retransmit_attempts (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_retransmit_attempts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_retransmit_attempts() directly.

    YANG Description: Number of times the system may resend a request to the
RADIUS server when it is unresponsive
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """retransmit_attempts must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)""",
        })

    self.__retransmit_attempts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_retransmit_attempts(self):
    self.__retransmit_attempts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="retransmit-attempts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters (container)

    YANG Description: A collection of RADIUS related state objects.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: A collection of RADIUS related state objects.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

  auth_port = __builtin__.property(_get_auth_port)
  acct_port = __builtin__.property(_get_acct_port)
  secret_key = __builtin__.property(_get_secret_key)
  secret_key_hashed = __builtin__.property(_get_secret_key_hashed)
  source_address = __builtin__.property(_get_source_address)
  retransmit_attempts = __builtin__.property(_get_retransmit_attempts)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('auth_port', auth_port), ('acct_port', acct_port), ('secret_key', secret_key), ('secret_key_hashed', secret_key_hashed), ('source_address', source_address), ('retransmit_attempts', retransmit_attempts), ('counters', counters), ])


class yc_radius_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server/radius. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for RADIUS server data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'radius'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server', 'radius']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config (container)

    YANG Description: Configuration data for RADIUS servers
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for RADIUS servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state (container)

    YANG Description: Operational state data for RADIUS servers
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for RADIUS servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_server_openconfig_system__system_aaa_server_groups_server_group_servers_server(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers/server. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of AAA servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__address','__config','__state','__tacacs','__radius',)

  _yang_name = 'server'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__tacacs = YANGDynClass(base=yc_tacacs_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs, is_container='container', yang_name="tacacs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__radius = YANGDynClass(base=yc_radius_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius, is_container='container', yang_name="radius", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers', 'server']

  def _get_address(self):
    """
    Getter method for address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/address (leafref)

    YANG Description: Reference to the configured address of the AAA server
    """
    return self.__address
      
  def _set_address(self, v, load=False):
    """
    Setter method for address, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/address (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_address() directly.

    YANG Description: Reference to the configured address of the AAA server
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """address must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_address(self):
    self.__address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_servers_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_servers_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_tacacs(self):
    """
    Getter method for tacacs, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs (container)

    YANG Description: Top-level container for TACACS+ server data
    """
    return self.__tacacs
      
  def _set_tacacs(self, v, load=False):
    """
    Setter method for tacacs, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/tacacs (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tacacs is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tacacs() directly.

    YANG Description: Top-level container for TACACS+ server data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_tacacs_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs, is_container='container', yang_name="tacacs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tacacs must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_tacacs_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs, is_container='container', yang_name="tacacs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__tacacs = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tacacs(self):
    self.__tacacs = YANGDynClass(base=yc_tacacs_openconfig_system__system_aaa_server_groups_server_group_servers_server_tacacs, is_container='container', yang_name="tacacs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_radius(self):
    """
    Getter method for radius, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius (container)

    YANG Description: Top-level container for RADIUS server data
    """
    return self.__radius
      
  def _set_radius(self, v, load=False):
    """
    Setter method for radius, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server/radius (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_radius is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_radius() directly.

    YANG Description: Top-level container for RADIUS server data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_radius_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius, is_container='container', yang_name="radius", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """radius must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_radius_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius, is_container='container', yang_name="radius", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__radius = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_radius(self):
    self.__radius = YANGDynClass(base=yc_radius_openconfig_system__system_aaa_server_groups_server_group_servers_server_radius, is_container='container', yang_name="radius", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  address = __builtin__.property(_get_address, _set_address)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  tacacs = __builtin__.property(_get_tacacs, _set_tacacs)
  radius = __builtin__.property(_get_radius, _set_radius)


  _pyangbind_elements = OrderedDict([('address', address), ('config', config), ('state', state), ('tacacs', tacacs), ('radius', radius), ])


class yc_servers_openconfig_system__system_aaa_server_groups_server_group_servers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group/servers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container the list of servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__server',)

  _yang_name = 'servers'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__server = YANGDynClass(base=YANGListType("address",yc_server_openconfig_system__system_aaa_server_groups_server_group_servers_server, yang_name="server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='address', extensions=None), is_container='list', yang_name="server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group', 'servers']

  def _get_server(self):
    """
    Getter method for server, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server (list)

    YANG Description: List of AAA servers
    """
    return self.__server
      
  def _set_server(self, v, load=False):
    """
    Setter method for server, mapped from YANG variable /system/aaa/server_groups/server_group/servers/server (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_server is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_server() directly.

    YANG Description: List of AAA servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("address",yc_server_openconfig_system__system_aaa_server_groups_server_group_servers_server, yang_name="server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='address', extensions=None), is_container='list', yang_name="server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """server must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("address",yc_server_openconfig_system__system_aaa_server_groups_server_group_servers_server, yang_name="server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='address', extensions=None), is_container='list', yang_name="server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__server = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_server(self):
    self.__server = YANGDynClass(base=YANGListType("address",yc_server_openconfig_system__system_aaa_server_groups_server_group_servers_server, yang_name="server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='address', extensions=None), is_container='list', yang_name="server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  server = __builtin__.property(_get_server, _set_server)


  _pyangbind_elements = OrderedDict([('server', server), ])


class yc_server_group_openconfig_system__system_aaa_server_groups_server_group(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups/server-group. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of AAA server groups.  All servers in a group
must have the same type as indicated by the server
type.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__servers',)

  _yang_name = 'server-group'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__servers = YANGDynClass(base=yc_servers_openconfig_system__system_aaa_server_groups_server_group_servers, is_container='container', yang_name="servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups', 'server-group']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/name (leafref)

    YANG Description: Reference to configured name of the server group
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/aaa/server_groups/server_group/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to configured name of the server group
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/config (container)

    YANG Description: Configuration data for each server group
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/aaa/server_groups/server_group/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each server group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_aaa_server_groups_server_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_aaa_server_groups_server_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/state (container)

    YANG Description: Operational state data for each server group
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/aaa/server_groups/server_group/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each server group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_aaa_server_groups_server_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_aaa_server_groups_server_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_servers(self):
    """
    Getter method for servers, mapped from YANG variable /system/aaa/server_groups/server_group/servers (container)

    YANG Description: Enclosing container the list of servers
    """
    return self.__servers
      
  def _set_servers(self, v, load=False):
    """
    Setter method for servers, mapped from YANG variable /system/aaa/server_groups/server_group/servers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_servers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_servers() directly.

    YANG Description: Enclosing container the list of servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_servers_openconfig_system__system_aaa_server_groups_server_group_servers, is_container='container', yang_name="servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """servers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_servers_openconfig_system__system_aaa_server_groups_server_group_servers, is_container='container', yang_name="servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__servers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_servers(self):
    self.__servers = YANGDynClass(base=yc_servers_openconfig_system__system_aaa_server_groups_server_group_servers, is_container='container', yang_name="servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  servers = __builtin__.property(_get_servers, _set_servers)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('servers', servers), ])


class yc_server_groups_openconfig_system__system_aaa_server_groups(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa/server-groups. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for AAA server groups
  """
  __slots__ = ('_path_helper', '_extmethods', '__server_group',)

  _yang_name = 'server-groups'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__server_group = YANGDynClass(base=YANGListType("name",yc_server_group_openconfig_system__system_aaa_server_groups_server_group, yang_name="server-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa', 'server-groups']

  def _get_server_group(self):
    """
    Getter method for server_group, mapped from YANG variable /system/aaa/server_groups/server_group (list)

    YANG Description: List of AAA server groups.  All servers in a group
must have the same type as indicated by the server
type.
    """
    return self.__server_group
      
  def _set_server_group(self, v, load=False):
    """
    Setter method for server_group, mapped from YANG variable /system/aaa/server_groups/server_group (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_server_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_server_group() directly.

    YANG Description: List of AAA server groups.  All servers in a group
must have the same type as indicated by the server
type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_server_group_openconfig_system__system_aaa_server_groups_server_group, yang_name="server-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """server_group must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_server_group_openconfig_system__system_aaa_server_groups_server_group, yang_name="server-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__server_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_server_group(self):
    self.__server_group = YANGDynClass(base=YANGListType("name",yc_server_group_openconfig_system__system_aaa_server_groups_server_group, yang_name="server-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="server-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  server_group = __builtin__.property(_get_server_group, _set_server_group)


  _pyangbind_elements = OrderedDict([('server_group', server_group), ])


class yc_aaa_openconfig_system__system_aaa(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/aaa. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for AAA services
  """
  __slots__ = ('_path_helper', '_extmethods', '__authentication','__authorization','__accounting','__server_groups',)

  _yang_name = 'aaa'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__authentication = YANGDynClass(base=yc_authentication_openconfig_system__system_aaa_authentication, is_container='container', yang_name="authentication", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__authorization = YANGDynClass(base=yc_authorization_openconfig_system__system_aaa_authorization, is_container='container', yang_name="authorization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__accounting = YANGDynClass(base=yc_accounting_openconfig_system__system_aaa_accounting, is_container='container', yang_name="accounting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__server_groups = YANGDynClass(base=yc_server_groups_openconfig_system__system_aaa_server_groups, is_container='container', yang_name="server-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'aaa']

  def _get_authentication(self):
    """
    Getter method for authentication, mapped from YANG variable /system/aaa/authentication (container)

    YANG Description: Top-level container for global authentication data
    """
    return self.__authentication
      
  def _set_authentication(self, v, load=False):
    """
    Setter method for authentication, mapped from YANG variable /system/aaa/authentication (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_authentication is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_authentication() directly.

    YANG Description: Top-level container for global authentication data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_authentication_openconfig_system__system_aaa_authentication, is_container='container', yang_name="authentication", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """authentication must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_authentication_openconfig_system__system_aaa_authentication, is_container='container', yang_name="authentication", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__authentication = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_authentication(self):
    self.__authentication = YANGDynClass(base=yc_authentication_openconfig_system__system_aaa_authentication, is_container='container', yang_name="authentication", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_authorization(self):
    """
    Getter method for authorization, mapped from YANG variable /system/aaa/authorization (container)

    YANG Description: Top-level container for AAA authorization configuration
and operational state data
    """
    return self.__authorization
      
  def _set_authorization(self, v, load=False):
    """
    Setter method for authorization, mapped from YANG variable /system/aaa/authorization (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_authorization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_authorization() directly.

    YANG Description: Top-level container for AAA authorization configuration
and operational state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_authorization_openconfig_system__system_aaa_authorization, is_container='container', yang_name="authorization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """authorization must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_authorization_openconfig_system__system_aaa_authorization, is_container='container', yang_name="authorization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__authorization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_authorization(self):
    self.__authorization = YANGDynClass(base=yc_authorization_openconfig_system__system_aaa_authorization, is_container='container', yang_name="authorization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_accounting(self):
    """
    Getter method for accounting, mapped from YANG variable /system/aaa/accounting (container)

    YANG Description: Top-level container for AAA accounting
    """
    return self.__accounting
      
  def _set_accounting(self, v, load=False):
    """
    Setter method for accounting, mapped from YANG variable /system/aaa/accounting (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_accounting is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_accounting() directly.

    YANG Description: Top-level container for AAA accounting
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_accounting_openconfig_system__system_aaa_accounting, is_container='container', yang_name="accounting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """accounting must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_accounting_openconfig_system__system_aaa_accounting, is_container='container', yang_name="accounting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__accounting = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_accounting(self):
    self.__accounting = YANGDynClass(base=yc_accounting_openconfig_system__system_aaa_accounting, is_container='container', yang_name="accounting", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_server_groups(self):
    """
    Getter method for server_groups, mapped from YANG variable /system/aaa/server_groups (container)

    YANG Description: Enclosing container for AAA server groups
    """
    return self.__server_groups
      
  def _set_server_groups(self, v, load=False):
    """
    Setter method for server_groups, mapped from YANG variable /system/aaa/server_groups (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_server_groups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_server_groups() directly.

    YANG Description: Enclosing container for AAA server groups
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_server_groups_openconfig_system__system_aaa_server_groups, is_container='container', yang_name="server-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """server_groups must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_server_groups_openconfig_system__system_aaa_server_groups, is_container='container', yang_name="server-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__server_groups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_server_groups(self):
    self.__server_groups = YANGDynClass(base=yc_server_groups_openconfig_system__system_aaa_server_groups, is_container='container', yang_name="server-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  authentication = __builtin__.property(_get_authentication, _set_authentication)
  authorization = __builtin__.property(_get_authorization, _set_authorization)
  accounting = __builtin__.property(_get_accounting, _set_accounting)
  server_groups = __builtin__.property(_get_server_groups, _set_server_groups)


  _pyangbind_elements = OrderedDict([('authentication', authentication), ('authorization', authorization), ('accounting', accounting), ('server_groups', server_groups), ])


class yc_state_openconfig_system__system_alarms_alarm_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/alarms/alarm/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for a device alarm
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__resource','__text','__time_created','__severity','__type_id',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__resource = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__text = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="text", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__time_created = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="time-created", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    self.__type_id = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},),], is_leaf=True, yang_name="type-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'alarms', 'alarm', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /system/alarms/alarm/state/id (string)

    YANG Description: Unique ID for the alarm -- this will not be a
configurable parameter on many implementations
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /system/alarms/alarm/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Unique ID for the alarm -- this will not be a
configurable parameter on many implementations
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_resource(self):
    """
    Getter method for resource, mapped from YANG variable /system/alarms/alarm/state/resource (string)

    YANG Description: The item that is under alarm within the device. The
resource may be a reference to an item which is
defined elsewhere in the model. For example, it
may be a platform/component, interfaces/interface,
terminal-device/logical-channels/channel, etc. In this
case the system should match the name of the referenced
item exactly. The referenced item could alternatively be
the path of the item within the model.
    """
    return self.__resource
      
  def _set_resource(self, v, load=False):
    """
    Setter method for resource, mapped from YANG variable /system/alarms/alarm/state/resource (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_resource is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_resource() directly.

    YANG Description: The item that is under alarm within the device. The
resource may be a reference to an item which is
defined elsewhere in the model. For example, it
may be a platform/component, interfaces/interface,
terminal-device/logical-channels/channel, etc. In this
case the system should match the name of the referenced
item exactly. The referenced item could alternatively be
the path of the item within the model.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """resource must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__resource = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_resource(self):
    self.__resource = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="resource", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_text(self):
    """
    Getter method for text, mapped from YANG variable /system/alarms/alarm/state/text (string)

    YANG Description: The string used to inform operators about the alarm. This
MUST contain enough information for an operator to be able
to understand the problem. If this string contains structure,
this format should be clearly documented for programs to be
able to parse that information
    """
    return self.__text
      
  def _set_text(self, v, load=False):
    """
    Setter method for text, mapped from YANG variable /system/alarms/alarm/state/text (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_text is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_text() directly.

    YANG Description: The string used to inform operators about the alarm. This
MUST contain enough information for an operator to be able
to understand the problem. If this string contains structure,
this format should be clearly documented for programs to be
able to parse that information
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="text", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """text must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="text", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__text = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_text(self):
    self.__text = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="text", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_time_created(self):
    """
    Getter method for time_created, mapped from YANG variable /system/alarms/alarm/state/time_created (oc-types:timeticks64)

    YANG Description: The time at which the alarm was raised by the system.
This value is expressed relative to the Unix Epoch.
    """
    return self.__time_created
      
  def _set_time_created(self, v, load=False):
    """
    Setter method for time_created, mapped from YANG variable /system/alarms/alarm/state/time_created (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_time_created is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_time_created() directly.

    YANG Description: The time at which the alarm was raised by the system.
This value is expressed relative to the Unix Epoch.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="time-created", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """time_created must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="time-created", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__time_created = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_time_created(self):
    self.__time_created = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="time-created", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)


  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/alarms/alarm/state/severity (identityref)

    YANG Description: The severity level indicating the criticality and impact
of the alarm
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/alarms/alarm/state/severity (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: The severity level indicating the criticality and impact
of the alarm
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:UNKNOWN': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MINOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:WARNING': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:MAJOR': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:CRITICAL': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)


  def _get_type_id(self):
    """
    Getter method for type_id, mapped from YANG variable /system/alarms/alarm/state/type_id (union)

    YANG Description: The abbreviated name of the alarm, for example LOS,
EQPT, or OTS. Also referred to in different systems as
condition type, alarm identifier, or alarm mnemonic. It
is recommended to use the OPENCONFIG_ALARM_TYPE_ID
identities where possible and only use the string type
when the desired identityref is not yet defined
    """
    return self.__type_id
      
  def _set_type_id(self, v, load=False):
    """
    Setter method for type_id, mapped from YANG variable /system/alarms/alarm/state/type_id (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type_id() directly.

    YANG Description: The abbreviated name of the alarm, for example LOS,
EQPT, or OTS. Also referred to in different systems as
condition type, alarm identifier, or alarm mnemonic. It
is recommended to use the OPENCONFIG_ALARM_TYPE_ID
identities where possible and only use the string type
when the desired identityref is not yet defined
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},),], is_leaf=True, yang_name="type-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type_id must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},),], is_leaf=True, yang_name="type-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)""",
        })

    self.__type_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type_id(self):
    self.__type_id = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:AIS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:EQPT': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:LOS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}, 'oc-alarm-types:OTS': {'@module': 'openconfig-alarm-types', '@namespace': 'http://openconfig.net/yang/alarms/types'}},),], is_leaf=True, yang_name="type-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)

  id = __builtin__.property(_get_id)
  resource = __builtin__.property(_get_resource)
  text = __builtin__.property(_get_text)
  time_created = __builtin__.property(_get_time_created)
  severity = __builtin__.property(_get_severity)
  type_id = __builtin__.property(_get_type_id)


  _pyangbind_elements = OrderedDict([('id', id), ('resource', resource), ('text', text), ('time_created', time_created), ('severity', severity), ('type_id', type_id), ])


class yc_alarm_openconfig_system__system_alarms_alarm(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/alarms/alarm. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of alarms, keyed by a unique id
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state',)

  _yang_name = 'alarm'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_alarms_alarm_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'alarms', 'alarm']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /system/alarms/alarm/id (leafref)

    YANG Description: References the unique alarm id
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /system/alarms/alarm/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: References the unique alarm id
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/alarms/alarm/state (container)

    YANG Description: Operational state data for a device alarm
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/alarms/alarm/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for a device alarm
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_alarms_alarm_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_alarms_alarm_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_alarms_alarm_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ])


class yc_alarms_openconfig_system__system_alarms(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/alarms. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for device alarms
  """
  __slots__ = ('_path_helper', '_extmethods', '__alarm',)

  _yang_name = 'alarms'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__alarm = YANGDynClass(base=YANGListType("id",yc_alarm_openconfig_system__system_alarms_alarm, yang_name="alarm", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="alarm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'alarms']

  def _get_alarm(self):
    """
    Getter method for alarm, mapped from YANG variable /system/alarms/alarm (list)

    YANG Description: List of alarms, keyed by a unique id
    """
    return self.__alarm
      
  def _set_alarm(self, v, load=False):
    """
    Setter method for alarm, mapped from YANG variable /system/alarms/alarm (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_alarm is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_alarm() directly.

    YANG Description: List of alarms, keyed by a unique id
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_alarm_openconfig_system__system_alarms_alarm, yang_name="alarm", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="alarm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """alarm must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_alarm_openconfig_system__system_alarms_alarm, yang_name="alarm", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="alarm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)""",
        })

    self.__alarm = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_alarm(self):
    self.__alarm = YANGDynClass(base=YANGListType("id",yc_alarm_openconfig_system__system_alarms_alarm, yang_name="alarm", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="alarm", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=False)

  alarm = __builtin__.property(_get_alarm)


  _pyangbind_elements = OrderedDict([('alarm', alarm), ])


class yc_config_openconfig_system__system_logging_console_selectors_selector_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/console/selectors/selector/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__facility','__severity',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'console', 'selectors', 'selector', 'config']

  def _get_facility(self):
    """
    Getter method for facility, mapped from YANG variable /system/logging/console/selectors/selector/config/facility (identityref)

    YANG Description: Specifies the facility, or class of messages to log
    """
    return self.__facility
      
  def _set_facility(self, v, load=False):
    """
    Setter method for facility, mapped from YANG variable /system/logging/console/selectors/selector/config/facility (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_facility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_facility() directly.

    YANG Description: Specifies the facility, or class of messages to log
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """facility must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)""",
        })

    self.__facility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_facility(self):
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)


  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/logging/console/selectors/selector/config/severity (syslog-severity)

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/logging/console/selectors/selector/config/severity (syslog-severity)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with syslog-severity""",
          'defined-type': "openconfig-system:syslog-severity",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)

  facility = __builtin__.property(_get_facility, _set_facility)
  severity = __builtin__.property(_get_severity, _set_severity)


  _pyangbind_elements = OrderedDict([('facility', facility), ('severity', severity), ])


class yc_state_openconfig_system__system_logging_console_selectors_selector_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/console/selectors/selector/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__facility','__severity',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'console', 'selectors', 'selector', 'state']

  def _get_facility(self):
    """
    Getter method for facility, mapped from YANG variable /system/logging/console/selectors/selector/state/facility (identityref)

    YANG Description: Specifies the facility, or class of messages to log
    """
    return self.__facility
      
  def _set_facility(self, v, load=False):
    """
    Setter method for facility, mapped from YANG variable /system/logging/console/selectors/selector/state/facility (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_facility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_facility() directly.

    YANG Description: Specifies the facility, or class of messages to log
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """facility must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)""",
        })

    self.__facility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_facility(self):
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)


  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/logging/console/selectors/selector/state/severity (syslog-severity)

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/logging/console/selectors/selector/state/severity (syslog-severity)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with syslog-severity""",
          'defined-type': "openconfig-system:syslog-severity",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)

  facility = __builtin__.property(_get_facility)
  severity = __builtin__.property(_get_severity)


  _pyangbind_elements = OrderedDict([('facility', facility), ('severity', severity), ])


class yc_selector_openconfig_system__system_logging_console_selectors_selector(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/console/selectors/selector. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of selectors for log messages
  """
  __slots__ = ('_path_helper', '_extmethods', '__facility','__severity','__config','__state',)

  _yang_name = 'selector'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__facility = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__severity = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_logging_console_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_logging_console_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'console', 'selectors', 'selector']

  def _get_facility(self):
    """
    Getter method for facility, mapped from YANG variable /system/logging/console/selectors/selector/facility (leafref)

    YANG Description: Reference to facility list key
    """
    return self.__facility
      
  def _set_facility(self, v, load=False):
    """
    Setter method for facility, mapped from YANG variable /system/logging/console/selectors/selector/facility (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_facility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_facility() directly.

    YANG Description: Reference to facility list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """facility must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__facility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_facility(self):
    self.__facility = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/logging/console/selectors/selector/severity (leafref)

    YANG Description: Reference to severity list key
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/logging/console/selectors/selector/severity (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Reference to severity list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/logging/console/selectors/selector/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/logging/console/selectors/selector/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_logging_console_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_logging_console_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_logging_console_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/logging/console/selectors/selector/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/logging/console/selectors/selector/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_logging_console_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_logging_console_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_logging_console_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  facility = __builtin__.property(_get_facility, _set_facility)
  severity = __builtin__.property(_get_severity, _set_severity)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('facility', facility), ('severity', severity), ('config', config), ('state', state), ])


class yc_selectors_openconfig_system__system_logging_console_selectors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/console/selectors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container 
  """
  __slots__ = ('_path_helper', '_extmethods', '__selector',)

  _yang_name = 'selectors'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__selector = YANGDynClass(base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_console_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'console', 'selectors']

  def _get_selector(self):
    """
    Getter method for selector, mapped from YANG variable /system/logging/console/selectors/selector (list)

    YANG Description: List of selectors for log messages
    """
    return self.__selector
      
  def _set_selector(self, v, load=False):
    """
    Setter method for selector, mapped from YANG variable /system/logging/console/selectors/selector (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_selector is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_selector() directly.

    YANG Description: List of selectors for log messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_console_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """selector must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_console_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__selector = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_selector(self):
    self.__selector = YANGDynClass(base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_console_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  selector = __builtin__.property(_get_selector, _set_selector)


  _pyangbind_elements = OrderedDict([('selector', selector), ])


class yc_console_openconfig_system__system_logging_console(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/console. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for data related to console-based
logging
  """
  __slots__ = ('_path_helper', '_extmethods', '__selectors',)

  _yang_name = 'console'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__selectors = YANGDynClass(base=yc_selectors_openconfig_system__system_logging_console_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'console']

  def _get_selectors(self):
    """
    Getter method for selectors, mapped from YANG variable /system/logging/console/selectors (container)

    YANG Description: Enclosing container 
    """
    return self.__selectors
      
  def _set_selectors(self, v, load=False):
    """
    Setter method for selectors, mapped from YANG variable /system/logging/console/selectors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_selectors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_selectors() directly.

    YANG Description: Enclosing container 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_selectors_openconfig_system__system_logging_console_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """selectors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_selectors_openconfig_system__system_logging_console_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__selectors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_selectors(self):
    self.__selectors = YANGDynClass(base=yc_selectors_openconfig_system__system_logging_console_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  selectors = __builtin__.property(_get_selectors, _set_selectors)


  _pyangbind_elements = OrderedDict([('selectors', selectors), ])


class yc_config_openconfig_system__system_logging_remote_servers_remote_server_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers/remote-server/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for remote log servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__host','__source_address','__network_instance','__remote_port',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__host = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=True)
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)
    self.__network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=True)
    self.__remote_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers', 'remote-server', 'config']

  def _get_host(self):
    """
    Getter method for host, mapped from YANG variable /system/logging/remote_servers/remote_server/config/host (oc-inet:host)

    YANG Description: IP address or hostname of the remote log server
    """
    return self.__host
      
  def _set_host(self, v, load=False):
    """
    Setter method for host, mapped from YANG variable /system/logging/remote_servers/remote_server/config/host (oc-inet:host)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host() directly.

    YANG Description: IP address or hostname of the remote log server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host must be of a type compatible with oc-inet:host""",
          'defined-type': "oc-inet:host",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=True)""",
        })

    self.__host = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host(self):
    self.__host = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=True)


  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /system/logging/remote_servers/remote_server/config/source_address (oc-inet:ip-address)

    YANG Description: Source IP address for packets to the log server
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /system/logging/remote_servers/remote_server/config/source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IP address for packets to the log server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=True)


  def _get_network_instance(self):
    """
    Getter method for network_instance, mapped from YANG variable /system/logging/remote_servers/remote_server/config/network_instance (oc-ni:network-instance-ref)

    YANG Description: The network instance used to reach the log server.  If no
instance is specified, DEFAULT_INSTANCE is used.
    """
    return self.__network_instance
      
  def _set_network_instance(self, v, load=False):
    """
    Setter method for network_instance, mapped from YANG variable /system/logging/remote_servers/remote_server/config/network_instance (oc-ni:network-instance-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network_instance() directly.

    YANG Description: The network instance used to reach the log server.  If no
instance is specified, DEFAULT_INSTANCE is used.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network_instance must be of a type compatible with oc-ni:network-instance-ref""",
          'defined-type': "oc-ni:network-instance-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=True)""",
        })

    self.__network_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network_instance(self):
    self.__network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=True)


  def _get_remote_port(self):
    """
    Getter method for remote_port, mapped from YANG variable /system/logging/remote_servers/remote_server/config/remote_port (oc-inet:port-number)

    YANG Description: Sets the destination port number for syslog UDP messages to
the server.  The default for syslog is 514.
    """
    return self.__remote_port
      
  def _set_remote_port(self, v, load=False):
    """
    Setter method for remote_port, mapped from YANG variable /system/logging/remote_servers/remote_server/config/remote_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_port() directly.

    YANG Description: Sets the destination port number for syslog UDP messages to
the server.  The default for syslog is 514.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)""",
        })

    self.__remote_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_port(self):
    self.__remote_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=True)

  host = __builtin__.property(_get_host, _set_host)
  source_address = __builtin__.property(_get_source_address, _set_source_address)
  network_instance = __builtin__.property(_get_network_instance, _set_network_instance)
  remote_port = __builtin__.property(_get_remote_port, _set_remote_port)


  _pyangbind_elements = OrderedDict([('host', host), ('source_address', source_address), ('network_instance', network_instance), ('remote_port', remote_port), ])


class yc_state_openconfig_system__system_logging_remote_servers_remote_server_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers/remote-server/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for remote log servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__host','__source_address','__network_instance','__remote_port',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__host = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=False)
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)
    self.__network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=False)
    self.__remote_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers', 'remote-server', 'state']

  def _get_host(self):
    """
    Getter method for host, mapped from YANG variable /system/logging/remote_servers/remote_server/state/host (oc-inet:host)

    YANG Description: IP address or hostname of the remote log server
    """
    return self.__host
      
  def _set_host(self, v, load=False):
    """
    Setter method for host, mapped from YANG variable /system/logging/remote_servers/remote_server/state/host (oc-inet:host)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host() directly.

    YANG Description: IP address or hostname of the remote log server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host must be of a type compatible with oc-inet:host""",
          'defined-type': "oc-inet:host",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=False)""",
        })

    self.__host = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host(self):
    self.__host = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)', 'length': ['1..253']}),], is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:host', is_config=False)


  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /system/logging/remote_servers/remote_server/state/source_address (oc-inet:ip-address)

    YANG Description: Source IP address for packets to the log server
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /system/logging/remote_servers/remote_server/state/source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IP address for packets to the log server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:ip-address', is_config=False)


  def _get_network_instance(self):
    """
    Getter method for network_instance, mapped from YANG variable /system/logging/remote_servers/remote_server/state/network_instance (oc-ni:network-instance-ref)

    YANG Description: The network instance used to reach the log server.  If no
instance is specified, DEFAULT_INSTANCE is used.
    """
    return self.__network_instance
      
  def _set_network_instance(self, v, load=False):
    """
    Setter method for network_instance, mapped from YANG variable /system/logging/remote_servers/remote_server/state/network_instance (oc-ni:network-instance-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network_instance() directly.

    YANG Description: The network instance used to reach the log server.  If no
instance is specified, DEFAULT_INSTANCE is used.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network_instance must be of a type compatible with oc-ni:network-instance-ref""",
          'defined-type': "oc-ni:network-instance-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=False)""",
        })

    self.__network_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network_instance(self):
    self.__network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-ni:network-instance-ref', is_config=False)


  def _get_remote_port(self):
    """
    Getter method for remote_port, mapped from YANG variable /system/logging/remote_servers/remote_server/state/remote_port (oc-inet:port-number)

    YANG Description: Sets the destination port number for syslog UDP messages to
the server.  The default for syslog is 514.
    """
    return self.__remote_port
      
  def _set_remote_port(self, v, load=False):
    """
    Setter method for remote_port, mapped from YANG variable /system/logging/remote_servers/remote_server/state/remote_port (oc-inet:port-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_port() directly.

    YANG Description: Sets the destination port number for syslog UDP messages to
the server.  The default for syslog is 514.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_port must be of a type compatible with oc-inet:port-number""",
          'defined-type': "oc-inet:port-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)""",
        })

    self.__remote_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_port(self):
    self.__remote_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(514), is_leaf=True, yang_name="remote-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-inet:port-number', is_config=False)

  host = __builtin__.property(_get_host)
  source_address = __builtin__.property(_get_source_address)
  network_instance = __builtin__.property(_get_network_instance)
  remote_port = __builtin__.property(_get_remote_port)


  _pyangbind_elements = OrderedDict([('host', host), ('source_address', source_address), ('network_instance', network_instance), ('remote_port', remote_port), ])


class yc_config_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers/remote-server/selectors/selector/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__facility','__severity',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers', 'remote-server', 'selectors', 'selector', 'config']

  def _get_facility(self):
    """
    Getter method for facility, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/config/facility (identityref)

    YANG Description: Specifies the facility, or class of messages to log
    """
    return self.__facility
      
  def _set_facility(self, v, load=False):
    """
    Setter method for facility, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/config/facility (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_facility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_facility() directly.

    YANG Description: Specifies the facility, or class of messages to log
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """facility must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)""",
        })

    self.__facility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_facility(self):
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)


  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/config/severity (syslog-severity)

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/config/severity (syslog-severity)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with syslog-severity""",
          'defined-type': "openconfig-system:syslog-severity",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=True)

  facility = __builtin__.property(_get_facility, _set_facility)
  severity = __builtin__.property(_get_severity, _set_severity)


  _pyangbind_elements = OrderedDict([('facility', facility), ('severity', severity), ])


class yc_state_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers/remote-server/selectors/selector/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__facility','__severity',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers', 'remote-server', 'selectors', 'selector', 'state']

  def _get_facility(self):
    """
    Getter method for facility, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/state/facility (identityref)

    YANG Description: Specifies the facility, or class of messages to log
    """
    return self.__facility
      
  def _set_facility(self, v, load=False):
    """
    Setter method for facility, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/state/facility (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_facility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_facility() directly.

    YANG Description: Specifies the facility, or class of messages to log
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """facility must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)""",
        })

    self.__facility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_facility(self):
    self.__facility = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:ALL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:KERNEL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:USER': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:MAIL': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSTEM_DAEMON': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTH': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:SYSLOG': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUTHPRIV': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:NTP': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:AUDIT': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:CONSOLE': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL0': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL1': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL2': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL3': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL4': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL5': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL6': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}, 'oc-log:LOCAL7': {'@module': 'openconfig-system-logging', '@namespace': 'http://openconfig.net/yang/system/logging'}},), is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)


  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/state/severity (syslog-severity)

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/state/severity (syslog-severity)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Specifies that only messages of the given severity (or
greater severity) for the corresonding facility are logged
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with syslog-severity""",
          'defined-type': "openconfig-system:syslog-severity",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='syslog-severity', is_config=False)

  facility = __builtin__.property(_get_facility)
  severity = __builtin__.property(_get_severity)


  _pyangbind_elements = OrderedDict([('facility', facility), ('severity', severity), ])


class yc_selector_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers/remote-server/selectors/selector. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of selectors for log messages
  """
  __slots__ = ('_path_helper', '_extmethods', '__facility','__severity','__config','__state',)

  _yang_name = 'selector'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__facility = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__severity = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers', 'remote-server', 'selectors', 'selector']

  def _get_facility(self):
    """
    Getter method for facility, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/facility (leafref)

    YANG Description: Reference to facility list key
    """
    return self.__facility
      
  def _set_facility(self, v, load=False):
    """
    Setter method for facility, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/facility (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_facility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_facility() directly.

    YANG Description: Reference to facility list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """facility must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__facility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_facility(self):
    self.__facility = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="facility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/severity (leafref)

    YANG Description: Reference to severity list key
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/severity (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Reference to severity list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  facility = __builtin__.property(_get_facility, _set_facility)
  severity = __builtin__.property(_get_severity, _set_severity)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('facility', facility), ('severity', severity), ('config', config), ('state', state), ])


class yc_selectors_openconfig_system__system_logging_remote_servers_remote_server_selectors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers/remote-server/selectors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container 
  """
  __slots__ = ('_path_helper', '_extmethods', '__selector',)

  _yang_name = 'selectors'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__selector = YANGDynClass(base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers', 'remote-server', 'selectors']

  def _get_selector(self):
    """
    Getter method for selector, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector (list)

    YANG Description: List of selectors for log messages
    """
    return self.__selector
      
  def _set_selector(self, v, load=False):
    """
    Setter method for selector, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors/selector (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_selector is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_selector() directly.

    YANG Description: List of selectors for log messages
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """selector must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__selector = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_selector(self):
    self.__selector = YANGDynClass(base=YANGListType("facility severity",yc_selector_openconfig_system__system_logging_remote_servers_remote_server_selectors_selector, yang_name="selector", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='facility severity', extensions=None), is_container='list', yang_name="selector", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  selector = __builtin__.property(_get_selector, _set_selector)


  _pyangbind_elements = OrderedDict([('selector', selector), ])


class yc_remote_server_openconfig_system__system_logging_remote_servers_remote_server(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers/remote-server. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of remote log servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__host','__config','__state','__selectors',)

  _yang_name = 'remote-server'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__host = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__selectors = YANGDynClass(base=yc_selectors_openconfig_system__system_logging_remote_servers_remote_server_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers', 'remote-server']

  def _get_host(self):
    """
    Getter method for host, mapped from YANG variable /system/logging/remote_servers/remote_server/host (leafref)

    YANG Description: Reference to the host list key
    """
    return self.__host
      
  def _set_host(self, v, load=False):
    """
    Setter method for host, mapped from YANG variable /system/logging/remote_servers/remote_server/host (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host() directly.

    YANG Description: Reference to the host list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__host = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host(self):
    self.__host = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="host", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/logging/remote_servers/remote_server/config (container)

    YANG Description: Configuration data for remote log servers
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/logging/remote_servers/remote_server/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for remote log servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_logging_remote_servers_remote_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/logging/remote_servers/remote_server/state (container)

    YANG Description: Operational state data for remote log servers
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/logging/remote_servers/remote_server/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for remote log servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_logging_remote_servers_remote_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_selectors(self):
    """
    Getter method for selectors, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors (container)

    YANG Description: Enclosing container 
    """
    return self.__selectors
      
  def _set_selectors(self, v, load=False):
    """
    Setter method for selectors, mapped from YANG variable /system/logging/remote_servers/remote_server/selectors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_selectors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_selectors() directly.

    YANG Description: Enclosing container 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_selectors_openconfig_system__system_logging_remote_servers_remote_server_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """selectors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_selectors_openconfig_system__system_logging_remote_servers_remote_server_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__selectors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_selectors(self):
    self.__selectors = YANGDynClass(base=yc_selectors_openconfig_system__system_logging_remote_servers_remote_server_selectors, is_container='container', yang_name="selectors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  host = __builtin__.property(_get_host, _set_host)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  selectors = __builtin__.property(_get_selectors, _set_selectors)


  _pyangbind_elements = OrderedDict([('host', host), ('config', config), ('state', state), ('selectors', selectors), ])


class yc_remote_servers_openconfig_system__system_logging_remote_servers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging/remote-servers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of remote log servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__remote_server',)

  _yang_name = 'remote-servers'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__remote_server = YANGDynClass(base=YANGListType("host",yc_remote_server_openconfig_system__system_logging_remote_servers_remote_server, yang_name="remote-server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='host', extensions=None), is_container='list', yang_name="remote-server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging', 'remote-servers']

  def _get_remote_server(self):
    """
    Getter method for remote_server, mapped from YANG variable /system/logging/remote_servers/remote_server (list)

    YANG Description: List of remote log servers
    """
    return self.__remote_server
      
  def _set_remote_server(self, v, load=False):
    """
    Setter method for remote_server, mapped from YANG variable /system/logging/remote_servers/remote_server (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_server is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_server() directly.

    YANG Description: List of remote log servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("host",yc_remote_server_openconfig_system__system_logging_remote_servers_remote_server, yang_name="remote-server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='host', extensions=None), is_container='list', yang_name="remote-server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_server must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("host",yc_remote_server_openconfig_system__system_logging_remote_servers_remote_server, yang_name="remote-server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='host', extensions=None), is_container='list', yang_name="remote-server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__remote_server = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_server(self):
    self.__remote_server = YANGDynClass(base=YANGListType("host",yc_remote_server_openconfig_system__system_logging_remote_servers_remote_server, yang_name="remote-server", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='host', extensions=None), is_container='list', yang_name="remote-server", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  remote_server = __builtin__.property(_get_remote_server, _set_remote_server)


  _pyangbind_elements = OrderedDict([('remote_server', remote_server), ])


class yc_logging_openconfig_system__system_logging(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/logging. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for data related to logging / syslog
  """
  __slots__ = ('_path_helper', '_extmethods', '__console','__remote_servers',)

  _yang_name = 'logging'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__console = YANGDynClass(base=yc_console_openconfig_system__system_logging_console, is_container='container', yang_name="console", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__remote_servers = YANGDynClass(base=yc_remote_servers_openconfig_system__system_logging_remote_servers, is_container='container', yang_name="remote-servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'logging']

  def _get_console(self):
    """
    Getter method for console, mapped from YANG variable /system/logging/console (container)

    YANG Description: Top-level container for data related to console-based
logging
    """
    return self.__console
      
  def _set_console(self, v, load=False):
    """
    Setter method for console, mapped from YANG variable /system/logging/console (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_console is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_console() directly.

    YANG Description: Top-level container for data related to console-based
logging
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_console_openconfig_system__system_logging_console, is_container='container', yang_name="console", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """console must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_console_openconfig_system__system_logging_console, is_container='container', yang_name="console", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__console = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_console(self):
    self.__console = YANGDynClass(base=yc_console_openconfig_system__system_logging_console, is_container='container', yang_name="console", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_remote_servers(self):
    """
    Getter method for remote_servers, mapped from YANG variable /system/logging/remote_servers (container)

    YANG Description: Enclosing container for the list of remote log servers
    """
    return self.__remote_servers
      
  def _set_remote_servers(self, v, load=False):
    """
    Setter method for remote_servers, mapped from YANG variable /system/logging/remote_servers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_servers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_servers() directly.

    YANG Description: Enclosing container for the list of remote log servers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_remote_servers_openconfig_system__system_logging_remote_servers, is_container='container', yang_name="remote-servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_servers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_remote_servers_openconfig_system__system_logging_remote_servers, is_container='container', yang_name="remote-servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__remote_servers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_servers(self):
    self.__remote_servers = YANGDynClass(base=yc_remote_servers_openconfig_system__system_logging_remote_servers, is_container='container', yang_name="remote-servers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  console = __builtin__.property(_get_console, _set_console)
  remote_servers = __builtin__.property(_get_remote_servers, _set_remote_servers)


  _pyangbind_elements = OrderedDict([('console', console), ('remote_servers', remote_servers), ])


class yc_state_openconfig_system__system_processes_process_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/processes/process/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State parameters related to monitored processes
  """
  __slots__ = ('_path_helper', '_extmethods', '__pid','__name','__args','__start_time','__cpu_usage_user','__cpu_usage_system','__cpu_utilization','__memory_usage','__memory_utilization',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__pid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__args = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="args", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)
    self.__cpu_usage_user = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__cpu_usage_system = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    self.__cpu_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="cpu-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)
    self.__memory_usage = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    self.__memory_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="memory-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'processes', 'process', 'state']

  def _get_pid(self):
    """
    Getter method for pid, mapped from YANG variable /system/processes/process/state/pid (uint64)

    YANG Description: The process pid
    """
    return self.__pid
      
  def _set_pid(self, v, load=False):
    """
    Setter method for pid, mapped from YANG variable /system/processes/process/state/pid (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pid() directly.

    YANG Description: The process pid
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pid must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)""",
        })

    self.__pid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pid(self):
    self.__pid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)


  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /system/processes/process/state/name (string)

    YANG Description: The process name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /system/processes/process/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The process name
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_args(self):
    """
    Getter method for args, mapped from YANG variable /system/processes/process/state/args (string)

    YANG Description: Current process command line arguments.  Arguments with
a parameter (e.g., --option 10  or -option=10) should be
represented as a single element of the list with the
argument name and parameter together.  Flag arguments, i.e.,
those without a parameter should also be in their own list
element.
    """
    return self.__args
      
  def _set_args(self, v, load=False):
    """
    Setter method for args, mapped from YANG variable /system/processes/process/state/args (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_args is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_args() directly.

    YANG Description: Current process command line arguments.  Arguments with
a parameter (e.g., --option 10  or -option=10) should be
represented as a single element of the list with the
argument name and parameter together.  Flag arguments, i.e.,
those without a parameter should also be in their own list
element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="args", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """args must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="args", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__args = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_args(self):
    self.__args = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="args", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_start_time(self):
    """
    Getter method for start_time, mapped from YANG variable /system/processes/process/state/start_time (oc-types:timeticks64)

    YANG Description: The time at which this process started,
relative to the UNIX epoch.  The system must be
synchronized such that the start-time can be
reported accurately, otherwise it should not be reported.
    """
    return self.__start_time
      
  def _set_start_time(self, v, load=False):
    """
    Setter method for start_time, mapped from YANG variable /system/processes/process/state/start_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_time() directly.

    YANG Description: The time at which this process started,
relative to the UNIX epoch.  The system must be
synchronized such that the start-time can be
reported accurately, otherwise it should not be reported.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__start_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_time(self):
    self.__start_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="start-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:timeticks64', is_config=False)


  def _get_cpu_usage_user(self):
    """
    Getter method for cpu_usage_user, mapped from YANG variable /system/processes/process/state/cpu_usage_user (oc-yang:counter64)

    YANG Description: CPU time consumed by this process in user mode in
nanoseconds.
    """
    return self.__cpu_usage_user
      
  def _set_cpu_usage_user(self, v, load=False):
    """
    Setter method for cpu_usage_user, mapped from YANG variable /system/processes/process/state/cpu_usage_user (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu_usage_user is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu_usage_user() directly.

    YANG Description: CPU time consumed by this process in user mode in
nanoseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu_usage_user must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__cpu_usage_user = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu_usage_user(self):
    self.__cpu_usage_user = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-user", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_cpu_usage_system(self):
    """
    Getter method for cpu_usage_system, mapped from YANG variable /system/processes/process/state/cpu_usage_system (oc-yang:counter64)

    YANG Description: CPU time consumed by this process in kernel mode.
    """
    return self.__cpu_usage_system
      
  def _set_cpu_usage_system(self, v, load=False):
    """
    Setter method for cpu_usage_system, mapped from YANG variable /system/processes/process/state/cpu_usage_system (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu_usage_system is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu_usage_system() directly.

    YANG Description: CPU time consumed by this process in kernel mode.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu_usage_system must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__cpu_usage_system = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu_usage_system(self):
    self.__cpu_usage_system = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="cpu-usage-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-yang:counter64', is_config=False)


  def _get_cpu_utilization(self):
    """
    Getter method for cpu_utilization, mapped from YANG variable /system/processes/process/state/cpu_utilization (oc-types:percentage)

    YANG Description: The percentage of CPU that is being used by the process.
    """
    return self.__cpu_utilization
      
  def _set_cpu_utilization(self, v, load=False):
    """
    Setter method for cpu_utilization, mapped from YANG variable /system/processes/process/state/cpu_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu_utilization() directly.

    YANG Description: The percentage of CPU that is being used by the process.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="cpu-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="cpu-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__cpu_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu_utilization(self):
    self.__cpu_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="cpu-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)


  def _get_memory_usage(self):
    """
    Getter method for memory_usage, mapped from YANG variable /system/processes/process/state/memory_usage (uint64)

    YANG Description: Bytes allocated and still in use by the process
    """
    return self.__memory_usage
      
  def _set_memory_usage(self, v, load=False):
    """
    Setter method for memory_usage, mapped from YANG variable /system/processes/process/state/memory_usage (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_memory_usage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_memory_usage() directly.

    YANG Description: Bytes allocated and still in use by the process
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """memory_usage must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)""",
        })

    self.__memory_usage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_memory_usage(self):
    self.__memory_usage = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="memory-usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)


  def _get_memory_utilization(self):
    """
    Getter method for memory_utilization, mapped from YANG variable /system/processes/process/state/memory_utilization (oc-types:percentage)

    YANG Description: The percentage of RAM that is being used by the process.
    """
    return self.__memory_utilization
      
  def _set_memory_utilization(self, v, load=False):
    """
    Setter method for memory_utilization, mapped from YANG variable /system/processes/process/state/memory_utilization (oc-types:percentage)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_memory_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_memory_utilization() directly.

    YANG Description: The percentage of RAM that is being used by the process.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="memory-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """memory_utilization must be of a type compatible with oc-types:percentage""",
          'defined-type': "oc-types:percentage",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="memory-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)""",
        })

    self.__memory_utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_memory_utilization(self):
    self.__memory_utilization = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..100']}), is_leaf=True, yang_name="memory-utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-types:percentage', is_config=False)

  pid = __builtin__.property(_get_pid)
  name = __builtin__.property(_get_name)
  args = __builtin__.property(_get_args)
  start_time = __builtin__.property(_get_start_time)
  cpu_usage_user = __builtin__.property(_get_cpu_usage_user)
  cpu_usage_system = __builtin__.property(_get_cpu_usage_system)
  cpu_utilization = __builtin__.property(_get_cpu_utilization)
  memory_usage = __builtin__.property(_get_memory_usage)
  memory_utilization = __builtin__.property(_get_memory_utilization)


  _pyangbind_elements = OrderedDict([('pid', pid), ('name', name), ('args', args), ('start_time', start_time), ('cpu_usage_user', cpu_usage_user), ('cpu_usage_system', cpu_usage_system), ('cpu_utilization', cpu_utilization), ('memory_usage', memory_usage), ('memory_utilization', memory_utilization), ])


class yc_process_openconfig_system__system_processes_process(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/processes/process. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of monitored processes
  """
  __slots__ = ('_path_helper', '_extmethods', '__pid','__state',)

  _yang_name = 'process'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__pid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_processes_process_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'processes', 'process']

  def _get_pid(self):
    """
    Getter method for pid, mapped from YANG variable /system/processes/process/pid (leafref)

    YANG Description: Reference to the process pid key
    """
    return self.__pid
      
  def _set_pid(self, v, load=False):
    """
    Setter method for pid, mapped from YANG variable /system/processes/process/pid (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pid() directly.

    YANG Description: Reference to the process pid key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pid must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)""",
        })

    self.__pid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pid(self):
    self.__pid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="pid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/processes/process/state (container)

    YANG Description: State parameters related to monitored processes
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/processes/process/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State parameters related to monitored processes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_processes_process_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_processes_process_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_processes_process_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

  pid = __builtin__.property(_get_pid)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('pid', pid), ('state', state), ])


class yc_processes_openconfig_system__system_processes(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/processes. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Parameters related to all monitored processes
  """
  __slots__ = ('_path_helper', '_extmethods', '__process',)

  _yang_name = 'processes'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__process = YANGDynClass(base=YANGListType("pid",yc_process_openconfig_system__system_processes_process, yang_name="process", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='pid', extensions=None), is_container='list', yang_name="process", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'processes']

  def _get_process(self):
    """
    Getter method for process, mapped from YANG variable /system/processes/process (list)

    YANG Description: List of monitored processes
    """
    return self.__process
      
  def _set_process(self, v, load=False):
    """
    Setter method for process, mapped from YANG variable /system/processes/process (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_process is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_process() directly.

    YANG Description: List of monitored processes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("pid",yc_process_openconfig_system__system_processes_process, yang_name="process", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='pid', extensions=None), is_container='list', yang_name="process", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """process must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("pid",yc_process_openconfig_system__system_processes_process, yang_name="process", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='pid', extensions=None), is_container='list', yang_name="process", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__process = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_process(self):
    self.__process = YANGDynClass(base=YANGListType("pid",yc_process_openconfig_system__system_processes_process, yang_name="process", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='pid', extensions=None), is_container='list', yang_name="process", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  process = __builtin__.property(_get_process, _set_process)


  _pyangbind_elements = OrderedDict([('process', process), ])


class yc_config_openconfig_system__system_messages_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for Syslog messages.
  """
  __slots__ = ('_path_helper', '_extmethods', '__severity',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages', 'config']

  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/messages/config/severity (oc-log:syslog-severity)

    YANG Description: Specifies that only messages of the given severity (or
greater severity) are sent over the RPC.

This is analogous to differentiating which severity is to be
sent to legacy Syslog servers, as opposed to local buffer or
files.
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/messages/config/severity (oc-log:syslog-severity)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Specifies that only messages of the given severity (or
greater severity) are sent over the RPC.

This is analogous to differentiating which severity is to be
sent to legacy Syslog servers, as opposed to local buffer or
files.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with oc-log:syslog-severity""",
          'defined-type': "oc-log:syslog-severity",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=True)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=True)

  severity = __builtin__.property(_get_severity, _set_severity)


  _pyangbind_elements = OrderedDict([('severity', severity), ])


class yc_message_openconfig_system__system_messages_state_message(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages/state/message. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Syslog messages the client is Subscribing to. This is all
messages currently configured to be sent according to
syslog-severity.
  """
  __slots__ = ('_path_helper', '_extmethods', '__msg','__priority','__app_name','__procid','__msgid',)

  _yang_name = 'message'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__msg = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)
    self.__app_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="app-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__procid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="procid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__msgid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="msgid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages', 'state', 'message']

  def _get_msg(self):
    """
    Getter method for msg, mapped from YANG variable /system/messages/state/message/msg (string)

    YANG Description: Message payload. If other leafs within this container not
supported, this leaf MAY include the entire message,
inclding pri, procid, app-name etc..
    """
    return self.__msg
      
  def _set_msg(self, v, load=False):
    """
    Setter method for msg, mapped from YANG variable /system/messages/state/message/msg (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_msg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_msg() directly.

    YANG Description: Message payload. If other leafs within this container not
supported, this leaf MAY include the entire message,
inclding pri, procid, app-name etc..
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """msg must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__msg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_msg(self):
    self.__msg = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_priority(self):
    """
    Getter method for priority, mapped from YANG variable /system/messages/state/message/priority (uint8)

    YANG Description: The Priority value (PRIVAL) represents both the
Facility and Severity.
    """
    return self.__priority
      
  def _set_priority(self, v, load=False):
    """
    Setter method for priority, mapped from YANG variable /system/messages/state/message/priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_priority() directly.

    YANG Description: The Priority value (PRIVAL) represents both the
Facility and Severity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)""",
        })

    self.__priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_priority(self):
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint8', is_config=False)


  def _get_app_name(self):
    """
    Getter method for app_name, mapped from YANG variable /system/messages/state/message/app_name (string)

    YANG Description: The APP-NAME field SHOULD identify the device or
application that originated the message.
    """
    return self.__app_name
      
  def _set_app_name(self, v, load=False):
    """
    Setter method for app_name, mapped from YANG variable /system/messages/state/message/app_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_app_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_app_name() directly.

    YANG Description: The APP-NAME field SHOULD identify the device or
application that originated the message.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="app-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """app_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="app-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__app_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_app_name(self):
    self.__app_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="app-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_procid(self):
    """
    Getter method for procid, mapped from YANG variable /system/messages/state/message/procid (string)

    YANG Description: PROCID is a value that is included in the message, having
no interoperable meaning, except that a change in the value
indicates there has been a discontinuity in syslog
reporting.
    """
    return self.__procid
      
  def _set_procid(self, v, load=False):
    """
    Setter method for procid, mapped from YANG variable /system/messages/state/message/procid (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_procid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_procid() directly.

    YANG Description: PROCID is a value that is included in the message, having
no interoperable meaning, except that a change in the value
indicates there has been a discontinuity in syslog
reporting.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="procid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """procid must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="procid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__procid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_procid(self):
    self.__procid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="procid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_msgid(self):
    """
    Getter method for msgid, mapped from YANG variable /system/messages/state/message/msgid (string)

    YANG Description: The MSGID SHOULD identify the type of message. For
example, a firewall might use the MSGID 'TCPIN' for
incoming TCP traffic and the MSGID 'TCPOUT' for outgoing
TCP traffic.
    """
    return self.__msgid
      
  def _set_msgid(self, v, load=False):
    """
    Setter method for msgid, mapped from YANG variable /system/messages/state/message/msgid (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_msgid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_msgid() directly.

    YANG Description: The MSGID SHOULD identify the type of message. For
example, a firewall might use the MSGID 'TCPIN' for
incoming TCP traffic and the MSGID 'TCPOUT' for outgoing
TCP traffic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="msgid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """msgid must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="msgid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__msgid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_msgid(self):
    self.__msgid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="msgid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)

  msg = __builtin__.property(_get_msg)
  priority = __builtin__.property(_get_priority)
  app_name = __builtin__.property(_get_app_name)
  procid = __builtin__.property(_get_procid)
  msgid = __builtin__.property(_get_msgid)


  _pyangbind_elements = OrderedDict([('msg', msg), ('priority', priority), ('app_name', app_name), ('procid', procid), ('msgid', msgid), ])


class yc_state_openconfig_system__system_messages_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for a Syslog messages.
  """
  __slots__ = ('_path_helper', '_extmethods', '__severity','__message',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=False)
    self.__message = YANGDynClass(base=yc_message_openconfig_system__system_messages_state_message, is_container='container', yang_name="message", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages', 'state']

  def _get_severity(self):
    """
    Getter method for severity, mapped from YANG variable /system/messages/state/severity (oc-log:syslog-severity)

    YANG Description: Specifies that only messages of the given severity (or
greater severity) are sent over the RPC.

This is analogous to differentiating which severity is to be
sent to legacy Syslog servers, as opposed to local buffer or
files.
    """
    return self.__severity
      
  def _set_severity(self, v, load=False):
    """
    Setter method for severity, mapped from YANG variable /system/messages/state/severity (oc-log:syslog-severity)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severity() directly.

    YANG Description: Specifies that only messages of the given severity (or
greater severity) are sent over the RPC.

This is analogous to differentiating which severity is to be
sent to legacy Syslog servers, as opposed to local buffer or
files.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severity must be of a type compatible with oc-log:syslog-severity""",
          'defined-type': "oc-log:syslog-severity",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=False)""",
        })

    self.__severity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severity(self):
    self.__severity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EMERGENCY': {}, 'ALERT': {}, 'CRITICAL': {}, 'ERROR': {}, 'WARNING': {}, 'NOTICE': {}, 'INFORMATIONAL': {}, 'DEBUG': {}},), is_leaf=True, yang_name="severity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='oc-log:syslog-severity', is_config=False)


  def _get_message(self):
    """
    Getter method for message, mapped from YANG variable /system/messages/state/message (container)

    YANG Description: Syslog messages the client is Subscribing to. This is all
messages currently configured to be sent according to
syslog-severity.
    """
    return self.__message
      
  def _set_message(self, v, load=False):
    """
    Setter method for message, mapped from YANG variable /system/messages/state/message (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_message is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_message() directly.

    YANG Description: Syslog messages the client is Subscribing to. This is all
messages currently configured to be sent according to
syslog-severity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_message_openconfig_system__system_messages_state_message, is_container='container', yang_name="message", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """message must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_message_openconfig_system__system_messages_state_message, is_container='container', yang_name="message", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)""",
        })

    self.__message = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_message(self):
    self.__message = YANGDynClass(base=yc_message_openconfig_system__system_messages_state_message, is_container='container', yang_name="message", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=False)

  severity = __builtin__.property(_get_severity)
  message = __builtin__.property(_get_message)


  _pyangbind_elements = OrderedDict([('severity', severity), ('message', message), ])


class yc_config_openconfig_system__system_messages_debug_entries_debug_service_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages/debug-entries/debug-service/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for debug service entries.
  """
  __slots__ = ('_path_helper', '_extmethods', '__service','__enabled',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__service = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages', 'debug-entries', 'debug-service', 'config']

  def _get_service(self):
    """
    Getter method for service, mapped from YANG variable /system/messages/debug_entries/debug_service/config/service (identityref)

    YANG Description: Enumeration of all services which can have debugging enabled.
Vendors are to augment this base identity with their platform
or OS specific debug options.
    """
    return self.__service
      
  def _set_service(self, v, load=False):
    """
    Setter method for service, mapped from YANG variable /system/messages/debug_entries/debug_service/config/service (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_service is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_service() directly.

    YANG Description: Enumeration of all services which can have debugging enabled.
Vendors are to augment this base identity with their platform
or OS specific debug options.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """service must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)""",
        })

    self.__service = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_service(self):
    self.__service = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /system/messages/debug_entries/debug_service/config/enabled (boolean)

    YANG Description: Enable and disable debugging.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /system/messages/debug_entries/debug_service/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Enable and disable debugging.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)

  service = __builtin__.property(_get_service, _set_service)
  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('service', service), ('enabled', enabled), ])


class yc_state_openconfig_system__system_messages_debug_entries_debug_service_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages/debug-entries/debug-service/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for enabled debugs.
  """
  __slots__ = ('_path_helper', '_extmethods', '__service','__enabled',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__service = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages', 'debug-entries', 'debug-service', 'state']

  def _get_service(self):
    """
    Getter method for service, mapped from YANG variable /system/messages/debug_entries/debug_service/state/service (identityref)

    YANG Description: Enumeration of all services which can have debugging enabled.
Vendors are to augment this base identity with their platform
or OS specific debug options.
    """
    return self.__service
      
  def _set_service(self, v, load=False):
    """
    Setter method for service, mapped from YANG variable /system/messages/debug_entries/debug_service/state/service (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_service is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_service() directly.

    YANG Description: Enumeration of all services which can have debugging enabled.
Vendors are to augment this base identity with their platform
or OS specific debug options.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """service must be of a type compatible with identityref""",
          'defined-type': "openconfig-system:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)""",
        })

    self.__service = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_service(self):
    self.__service = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='identityref', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /system/messages/debug_entries/debug_service/state/enabled (boolean)

    YANG Description: Enable and disable debugging.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /system/messages/debug_entries/debug_service/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Enable and disable debugging.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)

  service = __builtin__.property(_get_service)
  enabled = __builtin__.property(_get_enabled)


  _pyangbind_elements = OrderedDict([('service', service), ('enabled', enabled), ])


class yc_debug_service_openconfig_system__system_messages_debug_entries_debug_service(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages/debug-entries/debug-service. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of debugging entries.
  """
  __slots__ = ('_path_helper', '_extmethods', '__service','__config','__state',)

  _yang_name = 'debug-service'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__service = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_messages_debug_entries_debug_service_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_messages_debug_entries_debug_service_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages', 'debug-entries', 'debug-service']

  def _get_service(self):
    """
    Getter method for service, mapped from YANG variable /system/messages/debug_entries/debug_service/service (leafref)

    YANG Description: Reference to the debug-enable service key.
    """
    return self.__service
      
  def _set_service(self, v, load=False):
    """
    Setter method for service, mapped from YANG variable /system/messages/debug_entries/debug_service/service (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_service is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_service() directly.

    YANG Description: Reference to the debug-enable service key.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """service must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__service = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_service(self):
    self.__service = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/messages/debug_entries/debug_service/config (container)

    YANG Description: Configuration data for debug service entries.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/messages/debug_entries/debug_service/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for debug service entries.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_messages_debug_entries_debug_service_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_messages_debug_entries_debug_service_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_messages_debug_entries_debug_service_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/messages/debug_entries/debug_service/state (container)

    YANG Description: Operational state data for enabled debugs.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/messages/debug_entries/debug_service/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for enabled debugs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_messages_debug_entries_debug_service_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_messages_debug_entries_debug_service_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_messages_debug_entries_debug_service_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  service = __builtin__.property(_get_service, _set_service)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('service', service), ('config', config), ('state', state), ])


class yc_debug_entries_openconfig_system__system_messages_debug_entries(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages/debug-entries. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of debugs to enable.
  """
  __slots__ = ('_path_helper', '_extmethods', '__debug_service',)

  _yang_name = 'debug-entries'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__debug_service = YANGDynClass(base=YANGListType("service",yc_debug_service_openconfig_system__system_messages_debug_entries_debug_service, yang_name="debug-service", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='service', extensions=None), is_container='list', yang_name="debug-service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages', 'debug-entries']

  def _get_debug_service(self):
    """
    Getter method for debug_service, mapped from YANG variable /system/messages/debug_entries/debug_service (list)

    YANG Description: List of debugging entries.
    """
    return self.__debug_service
      
  def _set_debug_service(self, v, load=False):
    """
    Setter method for debug_service, mapped from YANG variable /system/messages/debug_entries/debug_service (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_debug_service is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_debug_service() directly.

    YANG Description: List of debugging entries.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("service",yc_debug_service_openconfig_system__system_messages_debug_entries_debug_service, yang_name="debug-service", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='service', extensions=None), is_container='list', yang_name="debug-service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """debug_service must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("service",yc_debug_service_openconfig_system__system_messages_debug_entries_debug_service, yang_name="debug-service", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='service', extensions=None), is_container='list', yang_name="debug-service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__debug_service = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_debug_service(self):
    self.__debug_service = YANGDynClass(base=YANGListType("service",yc_debug_service_openconfig_system__system_messages_debug_entries_debug_service, yang_name="debug-service", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='service', extensions=None), is_container='list', yang_name="debug-service", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  debug_service = __builtin__.property(_get_debug_service, _set_debug_service)


  _pyangbind_elements = OrderedDict([('debug_service', debug_service), ])


class yc_messages_openconfig_system__system_messages(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/messages. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for Syslog messages.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__debug_entries',)

  _yang_name = 'messages'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_messages_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_messages_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__debug_entries = YANGDynClass(base=yc_debug_entries_openconfig_system__system_messages_debug_entries, is_container='container', yang_name="debug-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'messages']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/messages/config (container)

    YANG Description: Configuration data for Syslog messages.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/messages/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for Syslog messages.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_messages_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_messages_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_messages_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/messages/state (container)

    YANG Description: Operational state data for a Syslog messages.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/messages/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for a Syslog messages.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_messages_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_messages_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_messages_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_debug_entries(self):
    """
    Getter method for debug_entries, mapped from YANG variable /system/messages/debug_entries (container)

    YANG Description: Enclosing container for list of debugs to enable.
    """
    return self.__debug_entries
      
  def _set_debug_entries(self, v, load=False):
    """
    Setter method for debug_entries, mapped from YANG variable /system/messages/debug_entries (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_debug_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_debug_entries() directly.

    YANG Description: Enclosing container for list of debugs to enable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_debug_entries_openconfig_system__system_messages_debug_entries, is_container='container', yang_name="debug-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """debug_entries must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_debug_entries_openconfig_system__system_messages_debug_entries, is_container='container', yang_name="debug-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__debug_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_debug_entries(self):
    self.__debug_entries = YANGDynClass(base=yc_debug_entries_openconfig_system__system_messages_debug_entries, is_container='container', yang_name="debug-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  debug_entries = __builtin__.property(_get_debug_entries, _set_debug_entries)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('debug_entries', debug_entries), ])


class yc_config_openconfig_system__system_license_licenses_license_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/license/licenses/license/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for license
  """
  __slots__ = ('_path_helper', '_extmethods', '__license_id','__license_data','__active',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__license_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    self.__license_data = YANGDynClass(base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)
    self.__active = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'license', 'licenses', 'license', 'config']

  def _get_license_id(self):
    """
    Getter method for license_id, mapped from YANG variable /system/license/licenses/license/config/license_id (string)

    YANG Description: License ID. A string that uniquelly identifies the license. The
platform should list all the licenses it supports being activated.
    """
    return self.__license_id
      
  def _set_license_id(self, v, load=False):
    """
    Setter method for license_id, mapped from YANG variable /system/license/licenses/license/config/license_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_license_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_license_id() directly.

    YANG Description: License ID. A string that uniquelly identifies the license. The
platform should list all the licenses it supports being activated.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """license_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)""",
        })

    self.__license_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_license_id(self):
    self.__license_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=True)


  def _get_license_data(self):
    """
    Getter method for license_data, mapped from YANG variable /system/license/licenses/license/config/license_data (union)

    YANG Description: The contents of the licence (if required) - which may be
supplied as a binary blob, or a simple string value. If this
value is considered sensitive, it may be read as an empty value.
    """
    return self.__license_data
      
  def _set_license_data(self, v, load=False):
    """
    Setter method for license_data, mapped from YANG variable /system/license/licenses/license/config/license_data (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_license_data is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_license_data() directly.

    YANG Description: The contents of the licence (if required) - which may be
supplied as a binary blob, or a simple string value. If this
value is considered sensitive, it may be read as an empty value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """license_data must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)""",
        })

    self.__license_data = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_license_data(self):
    self.__license_data = YANGDynClass(base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=True)


  def _get_active(self):
    """
    Getter method for active, mapped from YANG variable /system/license/licenses/license/config/active (boolean)

    YANG Description: The activation state of the license.
    """
    return self.__active
      
  def _set_active(self, v, load=False):
    """
    Setter method for active, mapped from YANG variable /system/license/licenses/license/config/active (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_active is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_active() directly.

    YANG Description: The activation state of the license.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """active must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)""",
        })

    self.__active = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_active(self):
    self.__active = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)

  license_id = __builtin__.property(_get_license_id, _set_license_id)
  license_data = __builtin__.property(_get_license_data, _set_license_data)
  active = __builtin__.property(_get_active, _set_active)


  _pyangbind_elements = OrderedDict([('license_id', license_id), ('license_data', license_data), ('active', active), ])


class yc_state_openconfig_system__system_license_licenses_license_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/license/licenses/license/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for license.
  """
  __slots__ = ('_path_helper', '_extmethods', '__license_id','__license_data','__active','__description','__issue_date','__expiration_date','__in_use','__expired','__valid',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__license_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__license_data = YANGDynClass(base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)
    self.__active = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    self.__issue_date = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="issue-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    self.__expiration_date = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="expiration-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    self.__in_use = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="in-use", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    self.__expired = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="expired", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    self.__valid = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'license', 'licenses', 'license', 'state']

  def _get_license_id(self):
    """
    Getter method for license_id, mapped from YANG variable /system/license/licenses/license/state/license_id (string)

    YANG Description: License ID. A string that uniquelly identifies the license. The
platform should list all the licenses it supports being activated.
    """
    return self.__license_id
      
  def _set_license_id(self, v, load=False):
    """
    Setter method for license_id, mapped from YANG variable /system/license/licenses/license/state/license_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_license_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_license_id() directly.

    YANG Description: License ID. A string that uniquelly identifies the license. The
platform should list all the licenses it supports being activated.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """license_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__license_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_license_id(self):
    self.__license_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_license_data(self):
    """
    Getter method for license_data, mapped from YANG variable /system/license/licenses/license/state/license_data (union)

    YANG Description: The contents of the licence (if required) - which may be
supplied as a binary blob, or a simple string value. If this
value is considered sensitive, it may be read as an empty value.
    """
    return self.__license_data
      
  def _set_license_data(self, v, load=False):
    """
    Setter method for license_data, mapped from YANG variable /system/license/licenses/license/state/license_data (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_license_data is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_license_data() directly.

    YANG Description: The contents of the licence (if required) - which may be
supplied as a binary blob, or a simple string value. If this
value is considered sensitive, it may be read as an empty value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """license_data must be of a type compatible with union""",
          'defined-type': "openconfig-system:union",
          'generated-type': """YANGDynClass(base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)""",
        })

    self.__license_data = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_license_data(self):
    self.__license_data = YANGDynClass(base=[bitarray,six.text_type,], is_leaf=True, yang_name="license-data", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='union', is_config=False)


  def _get_active(self):
    """
    Getter method for active, mapped from YANG variable /system/license/licenses/license/state/active (boolean)

    YANG Description: The activation state of the license.
    """
    return self.__active
      
  def _set_active(self, v, load=False):
    """
    Setter method for active, mapped from YANG variable /system/license/licenses/license/state/active (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_active is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_active() directly.

    YANG Description: The activation state of the license.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """active must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)""",
        })

    self.__active = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_active(self):
    self.__active = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /system/license/licenses/license/state/description (string)

    YANG Description: The license description.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /system/license/licenses/license/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: The license description.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='string', is_config=False)


  def _get_issue_date(self):
    """
    Getter method for issue_date, mapped from YANG variable /system/license/licenses/license/state/issue_date (uint64)

    YANG Description: The date and time at which the license was issued, expressed as the
number of nanoseconds since the Unix Epoch
(January 1, 1970, 00:00 UTC).
    """
    return self.__issue_date
      
  def _set_issue_date(self, v, load=False):
    """
    Setter method for issue_date, mapped from YANG variable /system/license/licenses/license/state/issue_date (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_issue_date is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_issue_date() directly.

    YANG Description: The date and time at which the license was issued, expressed as the
number of nanoseconds since the Unix Epoch
(January 1, 1970, 00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="issue-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """issue_date must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="issue-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)""",
        })

    self.__issue_date = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_issue_date(self):
    self.__issue_date = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="issue-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)


  def _get_expiration_date(self):
    """
    Getter method for expiration_date, mapped from YANG variable /system/license/licenses/license/state/expiration_date (uint64)

    YANG Description: The date and time at which the license will expire, expressed as the
number of nanoseconds since the Unix Epoch
(January 1, 1970, 00:00 UTC). Zero if it does not expire.
    """
    return self.__expiration_date
      
  def _set_expiration_date(self, v, load=False):
    """
    Setter method for expiration_date, mapped from YANG variable /system/license/licenses/license/state/expiration_date (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_expiration_date is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_expiration_date() directly.

    YANG Description: The date and time at which the license will expire, expressed as the
number of nanoseconds since the Unix Epoch
(January 1, 1970, 00:00 UTC). Zero if it does not expire.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="expiration-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """expiration_date must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="expiration-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)""",
        })

    self.__expiration_date = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_expiration_date(self):
    self.__expiration_date = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="expiration-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint64', is_config=False)


  def _get_in_use(self):
    """
    Getter method for in_use, mapped from YANG variable /system/license/licenses/license/state/in_use (boolean)

    YANG Description: The license is in use. Different from active. This states that the
license is effectively being used in addition to being active. If
license for feature X was activated but feature X is not being used,
then this should be false.
    """
    return self.__in_use
      
  def _set_in_use(self, v, load=False):
    """
    Setter method for in_use, mapped from YANG variable /system/license/licenses/license/state/in_use (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_use is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_use() directly.

    YANG Description: The license is in use. Different from active. This states that the
license is effectively being used in addition to being active. If
license for feature X was activated but feature X is not being used,
then this should be false.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="in-use", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_use must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="in-use", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)""",
        })

    self.__in_use = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_use(self):
    self.__in_use = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="in-use", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)


  def _get_expired(self):
    """
    Getter method for expired, mapped from YANG variable /system/license/licenses/license/state/expired (boolean)

    YANG Description: The license has expired.
    """
    return self.__expired
      
  def _set_expired(self, v, load=False):
    """
    Setter method for expired, mapped from YANG variable /system/license/licenses/license/state/expired (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_expired is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_expired() directly.

    YANG Description: The license has expired.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="expired", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """expired must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="expired", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)""",
        })

    self.__expired = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_expired(self):
    self.__expired = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="expired", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)


  def _get_valid(self):
    """
    Getter method for valid, mapped from YANG variable /system/license/licenses/license/state/valid (boolean)

    YANG Description: The license is valid. Can be activated in the system or platform.
    """
    return self.__valid
      
  def _set_valid(self, v, load=False):
    """
    Setter method for valid, mapped from YANG variable /system/license/licenses/license/state/valid (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_valid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_valid() directly.

    YANG Description: The license is valid. Can be activated in the system or platform.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """valid must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)""",
        })

    self.__valid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_valid(self):
    self.__valid = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)

  license_id = __builtin__.property(_get_license_id)
  license_data = __builtin__.property(_get_license_data)
  active = __builtin__.property(_get_active)
  description = __builtin__.property(_get_description)
  issue_date = __builtin__.property(_get_issue_date)
  expiration_date = __builtin__.property(_get_expiration_date)
  in_use = __builtin__.property(_get_in_use)
  expired = __builtin__.property(_get_expired)
  valid = __builtin__.property(_get_valid)


  _pyangbind_elements = OrderedDict([('license_id', license_id), ('license_data', license_data), ('active', active), ('description', description), ('issue_date', issue_date), ('expiration_date', expiration_date), ('in_use', in_use), ('expired', expired), ('valid', valid), ])


class yc_license_openconfig_system__system_license_licenses_license(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/license/licenses/license. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of licenses.
  """
  __slots__ = ('_path_helper', '_extmethods', '__license_id','__config','__state',)

  _yang_name = 'license'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__license_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_license_licenses_license_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_license_licenses_license_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'license', 'licenses', 'license']

  def _get_license_id(self):
    """
    Getter method for license_id, mapped from YANG variable /system/license/licenses/license/license_id (leafref)

    YANG Description: Reference to license id list key
    """
    return self.__license_id
      
  def _set_license_id(self, v, load=False):
    """
    Setter method for license_id, mapped from YANG variable /system/license/licenses/license/license_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_license_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_license_id() directly.

    YANG Description: Reference to license id list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """license_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)""",
        })

    self.__license_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_license_id(self):
    self.__license_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="license-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/license/licenses/license/config (container)

    YANG Description: Configuration data for license
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/license/licenses/license/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for license
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_license_licenses_license_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_license_licenses_license_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_license_licenses_license_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/license/licenses/license/state (container)

    YANG Description: Operational state data for license.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/license/licenses/license/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for license.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_license_licenses_license_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_license_licenses_license_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_license_licenses_license_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  license_id = __builtin__.property(_get_license_id, _set_license_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('license_id', license_id), ('config', config), ('state', state), ])


class yc_licenses_openconfig_system__system_license_licenses(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/license/licenses. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of licenses
  """
  __slots__ = ('_path_helper', '_extmethods', '__license',)

  _yang_name = 'licenses'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__license = YANGDynClass(base=YANGListType("license_id",yc_license_openconfig_system__system_license_licenses_license, yang_name="license", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='license-id', extensions=None), is_container='list', yang_name="license", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'license', 'licenses']

  def _get_license(self):
    """
    Getter method for license, mapped from YANG variable /system/license/licenses/license (list)

    YANG Description: List of licenses.
    """
    return self.__license
      
  def _set_license(self, v, load=False):
    """
    Setter method for license, mapped from YANG variable /system/license/licenses/license (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_license is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_license() directly.

    YANG Description: List of licenses.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("license_id",yc_license_openconfig_system__system_license_licenses_license, yang_name="license", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='license-id', extensions=None), is_container='list', yang_name="license", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """license must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("license_id",yc_license_openconfig_system__system_license_licenses_license, yang_name="license", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='license-id', extensions=None), is_container='list', yang_name="license", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)""",
        })

    self.__license = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_license(self):
    self.__license = YANGDynClass(base=YANGListType("license_id",yc_license_openconfig_system__system_license_licenses_license, yang_name="license", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='license-id', extensions=None), is_container='list', yang_name="license", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='list', is_config=True)

  license = __builtin__.property(_get_license, _set_license)


  _pyangbind_elements = OrderedDict([('license', license), ])


class yc_license_openconfig_system__system_license(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/license. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for license model
  """
  __slots__ = ('_path_helper', '_extmethods', '__licenses',)

  _yang_name = 'license'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__licenses = YANGDynClass(base=yc_licenses_openconfig_system__system_license_licenses, is_container='container', yang_name="licenses", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'license']

  def _get_licenses(self):
    """
    Getter method for licenses, mapped from YANG variable /system/license/licenses (container)

    YANG Description: Enclosing container for list of licenses
    """
    return self.__licenses
      
  def _set_licenses(self, v, load=False):
    """
    Setter method for licenses, mapped from YANG variable /system/license/licenses (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_licenses is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_licenses() directly.

    YANG Description: Enclosing container for list of licenses
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_licenses_openconfig_system__system_license_licenses, is_container='container', yang_name="licenses", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """licenses must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_licenses_openconfig_system__system_license_licenses, is_container='container', yang_name="licenses", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__licenses = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_licenses(self):
    self.__licenses = YANGDynClass(base=yc_licenses_openconfig_system__system_license_licenses, is_container='container', yang_name="licenses", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  licenses = __builtin__.property(_get_licenses, _set_licenses)


  _pyangbind_elements = OrderedDict([('licenses', licenses), ])


class yc_config_openconfig_system__system_ssh_server_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/ssh-server/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the system ssh server
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__protocol_version','__timeout','__rate_limit','__session_limit',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)
    self.__protocol_version = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'ssh-server', 'config']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /system/ssh_server/config/enable (boolean)

    YANG Description: Enables the ssh server.  The ssh server is enabled by
default.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /system/ssh_server/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the ssh server.  The ssh server is enabled by
default.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)


  def _get_protocol_version(self):
    """
    Getter method for protocol_version, mapped from YANG variable /system/ssh_server/config/protocol_version (enumeration)

    YANG Description: Set the protocol version for SSH connections to the system
    """
    return self.__protocol_version
      
  def _set_protocol_version(self, v, load=False):
    """
    Setter method for protocol_version, mapped from YANG variable /system/ssh_server/config/protocol_version (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol_version() directly.

    YANG Description: Set the protocol version for SSH connections to the system
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol_version must be of a type compatible with enumeration""",
          'defined-type': "openconfig-system:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)""",
        })

    self.__protocol_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol_version(self):
    self.__protocol_version = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=True)


  def _get_timeout(self):
    """
    Getter method for timeout, mapped from YANG variable /system/ssh_server/config/timeout (uint16)

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    return self.__timeout
      
  def _set_timeout(self, v, load=False):
    """
    Setter method for timeout, mapped from YANG variable /system/ssh_server/config/timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout() directly.

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)""",
        })

    self.__timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout(self):
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)


  def _get_rate_limit(self):
    """
    Getter method for rate_limit, mapped from YANG variable /system/ssh_server/config/rate_limit (uint16)

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    return self.__rate_limit
      
  def _set_rate_limit(self, v, load=False):
    """
    Setter method for rate_limit, mapped from YANG variable /system/ssh_server/config/rate_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_limit() directly.

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)""",
        })

    self.__rate_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_limit(self):
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)


  def _get_session_limit(self):
    """
    Getter method for session_limit, mapped from YANG variable /system/ssh_server/config/session_limit (uint16)

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    return self.__session_limit
      
  def _set_session_limit(self, v, load=False):
    """
    Setter method for session_limit, mapped from YANG variable /system/ssh_server/config/session_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_session_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_session_limit() directly.

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """session_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)""",
        })

    self.__session_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_session_limit(self):
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)

  enable = __builtin__.property(_get_enable, _set_enable)
  protocol_version = __builtin__.property(_get_protocol_version, _set_protocol_version)
  timeout = __builtin__.property(_get_timeout, _set_timeout)
  rate_limit = __builtin__.property(_get_rate_limit, _set_rate_limit)
  session_limit = __builtin__.property(_get_session_limit, _set_session_limit)


  _pyangbind_elements = OrderedDict([('enable', enable), ('protocol_version', protocol_version), ('timeout', timeout), ('rate_limit', rate_limit), ('session_limit', session_limit), ])


class yc_state_openconfig_system__system_ssh_server_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/ssh-server/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the system ssh server
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__protocol_version','__timeout','__rate_limit','__session_limit',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    self.__protocol_version = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'ssh-server', 'state']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /system/ssh_server/state/enable (boolean)

    YANG Description: Enables the ssh server.  The ssh server is enabled by
default.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /system/ssh_server/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the ssh server.  The ssh server is enabled by
default.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)


  def _get_protocol_version(self):
    """
    Getter method for protocol_version, mapped from YANG variable /system/ssh_server/state/protocol_version (enumeration)

    YANG Description: Set the protocol version for SSH connections to the system
    """
    return self.__protocol_version
      
  def _set_protocol_version(self, v, load=False):
    """
    Setter method for protocol_version, mapped from YANG variable /system/ssh_server/state/protocol_version (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol_version() directly.

    YANG Description: Set the protocol version for SSH connections to the system
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol_version must be of a type compatible with enumeration""",
          'defined-type': "openconfig-system:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)""",
        })

    self.__protocol_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol_version(self):
    self.__protocol_version = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'V2': {}, 'V1': {}, 'V1_V2': {}},), default=six.text_type("V2"), is_leaf=True, yang_name="protocol-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='enumeration', is_config=False)


  def _get_timeout(self):
    """
    Getter method for timeout, mapped from YANG variable /system/ssh_server/state/timeout (uint16)

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    return self.__timeout
      
  def _set_timeout(self, v, load=False):
    """
    Setter method for timeout, mapped from YANG variable /system/ssh_server/state/timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout() directly.

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)""",
        })

    self.__timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout(self):
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)


  def _get_rate_limit(self):
    """
    Getter method for rate_limit, mapped from YANG variable /system/ssh_server/state/rate_limit (uint16)

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    return self.__rate_limit
      
  def _set_rate_limit(self, v, load=False):
    """
    Setter method for rate_limit, mapped from YANG variable /system/ssh_server/state/rate_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_limit() directly.

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)""",
        })

    self.__rate_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_limit(self):
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)


  def _get_session_limit(self):
    """
    Getter method for session_limit, mapped from YANG variable /system/ssh_server/state/session_limit (uint16)

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    return self.__session_limit
      
  def _set_session_limit(self, v, load=False):
    """
    Setter method for session_limit, mapped from YANG variable /system/ssh_server/state/session_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_session_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_session_limit() directly.

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """session_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)""",
        })

    self.__session_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_session_limit(self):
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)

  enable = __builtin__.property(_get_enable)
  protocol_version = __builtin__.property(_get_protocol_version)
  timeout = __builtin__.property(_get_timeout)
  rate_limit = __builtin__.property(_get_rate_limit)
  session_limit = __builtin__.property(_get_session_limit)


  _pyangbind_elements = OrderedDict([('enable', enable), ('protocol_version', protocol_version), ('timeout', timeout), ('rate_limit', rate_limit), ('session_limit', session_limit), ])


class yc_ssh_server_openconfig_system__system_ssh_server(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/ssh-server. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for ssh server
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'ssh-server'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_ssh_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_ssh_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'ssh-server']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/ssh_server/config (container)

    YANG Description: Configuration data for the system ssh server
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/ssh_server/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the system ssh server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_ssh_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_ssh_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_ssh_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/ssh_server/state (container)

    YANG Description: Operational state data for the system ssh server
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/ssh_server/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the system ssh server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_ssh_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_ssh_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_ssh_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_system__system_telnet_server_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/telnet-server/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for telnet
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__timeout','__rate_limit','__session_limit',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'telnet-server', 'config']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /system/telnet_server/config/enable (boolean)

    YANG Description: Enables the telnet server.  Telnet is disabled by
default
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /system/telnet_server/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the telnet server.  Telnet is disabled by
default
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=True)


  def _get_timeout(self):
    """
    Getter method for timeout, mapped from YANG variable /system/telnet_server/config/timeout (uint16)

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    return self.__timeout
      
  def _set_timeout(self, v, load=False):
    """
    Setter method for timeout, mapped from YANG variable /system/telnet_server/config/timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout() directly.

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)""",
        })

    self.__timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout(self):
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)


  def _get_rate_limit(self):
    """
    Getter method for rate_limit, mapped from YANG variable /system/telnet_server/config/rate_limit (uint16)

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    return self.__rate_limit
      
  def _set_rate_limit(self, v, load=False):
    """
    Setter method for rate_limit, mapped from YANG variable /system/telnet_server/config/rate_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_limit() directly.

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)""",
        })

    self.__rate_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_limit(self):
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)


  def _get_session_limit(self):
    """
    Getter method for session_limit, mapped from YANG variable /system/telnet_server/config/session_limit (uint16)

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    return self.__session_limit
      
  def _set_session_limit(self, v, load=False):
    """
    Setter method for session_limit, mapped from YANG variable /system/telnet_server/config/session_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_session_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_session_limit() directly.

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """session_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)""",
        })

    self.__session_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_session_limit(self):
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=True)

  enable = __builtin__.property(_get_enable, _set_enable)
  timeout = __builtin__.property(_get_timeout, _set_timeout)
  rate_limit = __builtin__.property(_get_rate_limit, _set_rate_limit)
  session_limit = __builtin__.property(_get_session_limit, _set_session_limit)


  _pyangbind_elements = OrderedDict([('enable', enable), ('timeout', timeout), ('rate_limit', rate_limit), ('session_limit', session_limit), ])


class yc_state_openconfig_system__system_telnet_server_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/telnet-server/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for telnet
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__timeout','__rate_limit','__session_limit',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'telnet-server', 'state']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /system/telnet_server/state/enable (boolean)

    YANG Description: Enables the telnet server.  Telnet is disabled by
default
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /system/telnet_server/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the telnet server.  Telnet is disabled by
default
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='boolean', is_config=False)


  def _get_timeout(self):
    """
    Getter method for timeout, mapped from YANG variable /system/telnet_server/state/timeout (uint16)

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    return self.__timeout
      
  def _set_timeout(self, v, load=False):
    """
    Setter method for timeout, mapped from YANG variable /system/telnet_server/state/timeout (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timeout is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timeout() directly.

    YANG Description: Set the idle timeout in seconds on terminal connections to
the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timeout must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)""",
        })

    self.__timeout = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timeout(self):
    self.__timeout = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="timeout", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)


  def _get_rate_limit(self):
    """
    Getter method for rate_limit, mapped from YANG variable /system/telnet_server/state/rate_limit (uint16)

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    return self.__rate_limit
      
  def _set_rate_limit(self, v, load=False):
    """
    Setter method for rate_limit, mapped from YANG variable /system/telnet_server/state/rate_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_limit() directly.

    YANG Description: Set a limit on the number of connection attempts per
minute to the system for the protocol.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)""",
        })

    self.__rate_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_limit(self):
    self.__rate_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="rate-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)


  def _get_session_limit(self):
    """
    Getter method for session_limit, mapped from YANG variable /system/telnet_server/state/session_limit (uint16)

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    return self.__session_limit
      
  def _set_session_limit(self, v, load=False):
    """
    Setter method for session_limit, mapped from YANG variable /system/telnet_server/state/session_limit (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_session_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_session_limit() directly.

    YANG Description: Set a limit on the number of simultaneous active terminal
sessions to the system for the protocol (e.g., ssh,
telnet, ...) 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """session_limit must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)""",
        })

    self.__session_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_session_limit(self):
    self.__session_limit = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="session-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='uint16', is_config=False)

  enable = __builtin__.property(_get_enable)
  timeout = __builtin__.property(_get_timeout)
  rate_limit = __builtin__.property(_get_rate_limit)
  session_limit = __builtin__.property(_get_session_limit)


  _pyangbind_elements = OrderedDict([('enable', enable), ('timeout', timeout), ('rate_limit', rate_limit), ('session_limit', session_limit), ])


class yc_telnet_server_openconfig_system__system_telnet_server(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/telnet-server. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for telnet terminal servers
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'telnet-server'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_telnet_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_telnet_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'telnet-server']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /system/telnet_server/config (container)

    YANG Description: Configuration data for telnet
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /system/telnet_server/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for telnet
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_system__system_telnet_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_system__system_telnet_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_system__system_telnet_server_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /system/telnet_server/state (container)

    YANG Description: Operational state data for telnet
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /system/telnet_server/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for telnet
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_system__system_telnet_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_system__system_telnet_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_system__system_telnet_server_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_system__system_clock_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/clock/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for system clock
  """
  __slots__ = ('_path_helper', '_extmethods', '__timezone_name',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__timezone_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="timezone-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='timezone-name-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'clock', 'config']

  def _get_timezone_name(self):
    """
    Getter method for timezone_name, mapped from YANG variable /system/clock/config/timezone_name (timezone-name-type)

    YANG Description: The TZ database name to use for the system, such
as 'Europe/Stockholm'.
    """
    return self.__timezone_name
      
  def _set_timezone_name(self, v, load=False):
    """
    Setter method for timezone_name, mapped from YANG variable /system/clock/config/timezone_name (timezone-name-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_timezone_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_timezone_name() directly.

    YANG Description: The TZ database name to use for the system, such
as 'Europe/Stockholm'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="timezone-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='timezone-name-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """timezone_name must be of a type compatible with timezone-name-type""",
          'defined-type': "openconfig-system:timezone-name-type",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="timezone-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='timezone-name-type', is_config=True)""",
        })

    self.__timezone_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_timezone_name(self):
    self.__timezone_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="timezone-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='timezone-name-type', is_config=True)

  timezone_name = __builtin__.property(_get_timezone_name, _set_timezone_name)


  _pyangbind_elements = OrderedDict([('timezone_name', timezone_name), ])


class yc_state_openconfig_system__system_clock_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-system - based on the path /system/clock/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for system clock
  """
  __slots__ = ('_path_helper', '_extmethods', '__timezone_name',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__timezone_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="timezone-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/system', defining_module='openconfig-system', yang_type='timezone-name-type', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['system', 'clock', 'state']

  def _get_timezone_name(self):
    """
    Getter method for timezone_name, mapped from YANG variable /system/clock/state/timezone_name (timezone-name-type)

    YANG Description: The TZ database name to use for the system, such
as 'Europe/Stockholm'.
    """
    return self.__timezone_name
      
  def _set_timezone_name(self, v, load=False):
    """
    Setter method for timezone_name, mapped from YANG variable /system/clock/state/timezone_name (timezone-name-type)
    If this variable is 