// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewScopeMetrics()
				CopyScopeMetrics(dest, src)
				assert.Equal(t, src, dest)
				CopyScopeMetrics(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyScopeMetricsSlice(t *testing.T) {
	src := []ScopeMetrics{}
	dest := []ScopeMetrics{}
	// Test CopyTo empty
	dest = CopyScopeMetricsSlice(dest, src)
	assert.Equal(t, []ScopeMetrics{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeMetricsSlice()
	dest = CopyScopeMetricsSlice(dest, src)
	assert.Equal(t, GenTestScopeMetricsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeMetricsSlice(dest, src)
	assert.Equal(t, GenTestScopeMetricsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeMetricsSlice(dest, []ScopeMetrics{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeMetricsSlice(dest, src)
	assert.Equal(t, GenTestScopeMetricsSlice(), dest)
}

func TestCopyScopeMetricsPtrSlice(t *testing.T) {
	src := []*ScopeMetrics{}
	dest := []*ScopeMetrics{}
	// Test CopyTo empty
	dest = CopyScopeMetricsPtrSlice(dest, src)
	assert.Equal(t, []*ScopeMetrics{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeMetricsPtrSlice()
	dest = CopyScopeMetricsPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeMetricsPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeMetricsPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeMetricsPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeMetricsPtrSlice(dest, []*ScopeMetrics{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeMetricsPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeMetricsPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONScopeMetricsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewScopeMetrics()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewScopeMetrics(), dest)
}

func TestMarshalAndUnmarshalJSONScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewScopeMetrics()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteScopeMetrics(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoScopeMetricsFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesScopeMetrics() {
		t.Run(name, func(t *testing.T) {
			dest := NewScopeMetrics()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoScopeMetricsUnknown(t *testing.T) {
	dest := NewScopeMetrics()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewScopeMetrics(), dest)
}

func TestMarshalAndUnmarshalProtoScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewScopeMetrics()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteScopeMetrics(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufScopeMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeMetrics() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.ScopeMetrics{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewScopeMetrics()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesScopeMetrics() map[string][]byte {
	return map[string][]byte{
		"invalid_field":             {0x02},
		"Scope/wrong_wire_type":     {0xc},
		"Scope/missing_value":       {0xa},
		"Metrics/wrong_wire_type":   {0x14},
		"Metrics/missing_value":     {0x12},
		"SchemaUrl/wrong_wire_type": {0x1c},
		"SchemaUrl/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesScopeMetrics() map[string]*ScopeMetrics {
	return map[string]*ScopeMetrics{
		"empty":          NewScopeMetrics(),
		"Scope/test":     {Scope: *GenTestInstrumentationScope()},
		"Metrics/test":   {Metrics: []*Metric{{}, GenTestMetric()}},
		"SchemaUrl/test": {SchemaUrl: "test_schemaurl"},
	}
}
