// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewScopeSpans()
				CopyScopeSpans(dest, src)
				assert.Equal(t, src, dest)
				CopyScopeSpans(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyScopeSpansSlice(t *testing.T) {
	src := []ScopeSpans{}
	dest := []ScopeSpans{}
	// Test CopyTo empty
	dest = CopyScopeSpansSlice(dest, src)
	assert.Equal(t, []ScopeSpans{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeSpansSlice()
	dest = CopyScopeSpansSlice(dest, src)
	assert.Equal(t, GenTestScopeSpansSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeSpansSlice(dest, src)
	assert.Equal(t, GenTestScopeSpansSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeSpansSlice(dest, []ScopeSpans{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeSpansSlice(dest, src)
	assert.Equal(t, GenTestScopeSpansSlice(), dest)
}

func TestCopyScopeSpansPtrSlice(t *testing.T) {
	src := []*ScopeSpans{}
	dest := []*ScopeSpans{}
	// Test CopyTo empty
	dest = CopyScopeSpansPtrSlice(dest, src)
	assert.Equal(t, []*ScopeSpans{}, dest)

	// Test CopyTo larger slice
	src = GenTestScopeSpansPtrSlice()
	dest = CopyScopeSpansPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeSpansPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyScopeSpansPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeSpansPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyScopeSpansPtrSlice(dest, []*ScopeSpans{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyScopeSpansPtrSlice(dest, src)
	assert.Equal(t, GenTestScopeSpansPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONScopeSpansUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewScopeSpans()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewScopeSpans(), dest)
}

func TestMarshalAndUnmarshalJSONScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewScopeSpans()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteScopeSpans(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoScopeSpansFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesScopeSpans() {
		t.Run(name, func(t *testing.T) {
			dest := NewScopeSpans()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoScopeSpansUnknown(t *testing.T) {
	dest := NewScopeSpans()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewScopeSpans(), dest)
}

func TestMarshalAndUnmarshalProtoScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewScopeSpans()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteScopeSpans(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.ScopeSpans{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewScopeSpans()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesScopeSpans() map[string][]byte {
	return map[string][]byte{
		"invalid_field":             {0x02},
		"Scope/wrong_wire_type":     {0xc},
		"Scope/missing_value":       {0xa},
		"Spans/wrong_wire_type":     {0x14},
		"Spans/missing_value":       {0x12},
		"SchemaUrl/wrong_wire_type": {0x1c},
		"SchemaUrl/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesScopeSpans() map[string]*ScopeSpans {
	return map[string]*ScopeSpans{
		"empty":          NewScopeSpans(),
		"Scope/test":     {Scope: *GenTestInstrumentationScope()},
		"Spans/test":     {Spans: []*Span{{}, GenTestSpan()}},
		"SchemaUrl/test": {SchemaUrl: "test_schemaurl"},
	}
}
