// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/assistant/embedded/v1alpha1/embedded_assistant.proto

package embedded

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Audio encoding of the data sent in the audio message.
// Audio must be one-channel (mono). The only language supported is "en-US".
type AudioInConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioInConfig_ENCODING_UNSPECIFIED AudioInConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// This encoding includes no header, only the raw audio bytes.
	AudioInConfig_LINEAR16 AudioInConfig_Encoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is
	// lossless--therefore recognition is not compromised--and
	// requires only about half the bandwidth of `LINEAR16`. This encoding
	// includes the `FLAC` stream header followed by audio data. It supports
	// 16-bit and 24-bit samples, however, not all fields in `STREAMINFO` are
	// supported.
	AudioInConfig_FLAC AudioInConfig_Encoding = 2
)

// Enum value maps for AudioInConfig_Encoding.
var (
	AudioInConfig_Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "LINEAR16",
		2: "FLAC",
	}
	AudioInConfig_Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED": 0,
		"LINEAR16":             1,
		"FLAC":                 2,
	}
)

func (x AudioInConfig_Encoding) Enum() *AudioInConfig_Encoding {
	p := new(AudioInConfig_Encoding)
	*p = x
	return p
}

func (x AudioInConfig_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioInConfig_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[0].Descriptor()
}

func (AudioInConfig_Encoding) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[0]
}

func (x AudioInConfig_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioInConfig_Encoding.Descriptor instead.
func (AudioInConfig_Encoding) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{1, 0}
}

// Audio encoding of the data returned in the audio message. All encodings are
// raw audio bytes with no header, except as indicated below.
type AudioOutConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioOutConfig_ENCODING_UNSPECIFIED AudioOutConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioOutConfig_LINEAR16 AudioOutConfig_Encoding = 1
	// MP3 audio encoding. The sample rate is encoded in the payload.
	AudioOutConfig_MP3 AudioOutConfig_Encoding = 2
	// Opus-encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android and in some browsers (such
	// as Chrome). The quality of the encoding is considerably higher than MP3
	// while using the same bitrate. The sample rate is encoded in the payload.
	AudioOutConfig_OPUS_IN_OGG AudioOutConfig_Encoding = 3
)

// Enum value maps for AudioOutConfig_Encoding.
var (
	AudioOutConfig_Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "LINEAR16",
		2: "MP3",
		3: "OPUS_IN_OGG",
	}
	AudioOutConfig_Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED": 0,
		"LINEAR16":             1,
		"MP3":                  2,
		"OPUS_IN_OGG":          3,
	}
)

func (x AudioOutConfig_Encoding) Enum() *AudioOutConfig_Encoding {
	p := new(AudioOutConfig_Encoding)
	*p = x
	return p
}

func (x AudioOutConfig_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioOutConfig_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[1].Descriptor()
}

func (AudioOutConfig_Encoding) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[1]
}

func (x AudioOutConfig_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioOutConfig_Encoding.Descriptor instead.
func (AudioOutConfig_Encoding) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{2, 0}
}

// Possible states of the microphone after a `Converse` RPC completes.
type ConverseResult_MicrophoneMode int32

const (
	// No mode specified.
	ConverseResult_MICROPHONE_MODE_UNSPECIFIED ConverseResult_MicrophoneMode = 0
	// The service is not expecting a follow-on question from the user.
	// The microphone should remain off until the user re-activates it.
	ConverseResult_CLOSE_MICROPHONE ConverseResult_MicrophoneMode = 1
	// The service is expecting a follow-on question from the user. The
	// microphone should be re-opened when the `AudioOut` playback completes
	// (by starting a new `Converse` RPC call to send the new audio).
	ConverseResult_DIALOG_FOLLOW_ON ConverseResult_MicrophoneMode = 2
)

// Enum value maps for ConverseResult_MicrophoneMode.
var (
	ConverseResult_MicrophoneMode_name = map[int32]string{
		0: "MICROPHONE_MODE_UNSPECIFIED",
		1: "CLOSE_MICROPHONE",
		2: "DIALOG_FOLLOW_ON",
	}
	ConverseResult_MicrophoneMode_value = map[string]int32{
		"MICROPHONE_MODE_UNSPECIFIED": 0,
		"CLOSE_MICROPHONE":            1,
		"DIALOG_FOLLOW_ON":            2,
	}
)

func (x ConverseResult_MicrophoneMode) Enum() *ConverseResult_MicrophoneMode {
	p := new(ConverseResult_MicrophoneMode)
	*p = x
	return p
}

func (x ConverseResult_MicrophoneMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConverseResult_MicrophoneMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[2].Descriptor()
}

func (ConverseResult_MicrophoneMode) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[2]
}

func (x ConverseResult_MicrophoneMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConverseResult_MicrophoneMode.Descriptor instead.
func (ConverseResult_MicrophoneMode) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{5, 0}
}

// Indicates the type of event.
type ConverseResponse_EventType int32

const (
	// No event specified.
	ConverseResponse_EVENT_TYPE_UNSPECIFIED ConverseResponse_EventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection.
	ConverseResponse_END_OF_UTTERANCE ConverseResponse_EventType = 1
)

// Enum value maps for ConverseResponse_EventType.
var (
	ConverseResponse_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "END_OF_UTTERANCE",
	}
	ConverseResponse_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED": 0,
		"END_OF_UTTERANCE":       1,
	}
)

func (x ConverseResponse_EventType) Enum() *ConverseResponse_EventType {
	p := new(ConverseResponse_EventType)
	*p = x
	return p
}

func (x ConverseResponse_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConverseResponse_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[3].Descriptor()
}

func (ConverseResponse_EventType) Type() protoreflect.EnumType {
	return &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes[3]
}

func (x ConverseResponse_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConverseResponse_EventType.Descriptor instead.
func (ConverseResponse_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{7, 0}
}

// Specifies how to process the `ConverseRequest` messages.
type ConverseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* Specifies how to process the subsequent incoming audio.
	AudioInConfig *AudioInConfig `protobuf:"bytes,1,opt,name=audio_in_config,json=audioInConfig,proto3" json:"audio_in_config,omitempty"`
	// *Required* Specifies how to format the audio that will be returned.
	AudioOutConfig *AudioOutConfig `protobuf:"bytes,2,opt,name=audio_out_config,json=audioOutConfig,proto3" json:"audio_out_config,omitempty"`
	// *Required* Represents the current dialog state.
	ConverseState *ConverseState `protobuf:"bytes,3,opt,name=converse_state,json=converseState,proto3" json:"converse_state,omitempty"`
}

func (x *ConverseConfig) Reset() {
	*x = ConverseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConverseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConverseConfig) ProtoMessage() {}

func (x *ConverseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConverseConfig.ProtoReflect.Descriptor instead.
func (*ConverseConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{0}
}

func (x *ConverseConfig) GetAudioInConfig() *AudioInConfig {
	if x != nil {
		return x.AudioInConfig
	}
	return nil
}

func (x *ConverseConfig) GetAudioOutConfig() *AudioOutConfig {
	if x != nil {
		return x.AudioOutConfig
	}
	return nil
}

func (x *ConverseConfig) GetConverseState() *ConverseState {
	if x != nil {
		return x.ConverseState
	}
	return nil
}

// Specifies how to process the `audio_in` data that will be provided in
// subsequent requests. For recommended settings, see the Google Assistant SDK
// [best
// practices](https://developers.google.com/assistant/sdk/develop/grpc/best-practices/audio).
type AudioInConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* Encoding of audio data sent in all `audio_in` messages.
	Encoding AudioInConfig_Encoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.assistant.embedded.v1alpha1.AudioInConfig_Encoding" json:"encoding,omitempty"`
	// *Required* Sample rate (in Hertz) of the audio data sent in all `audio_in`
	// messages. Valid values are from 16000-24000, but 16000 is optimal.
	// For best results, set the sampling rate of the audio source to 16000 Hz.
	// If that's not possible, use the native sample rate of the audio source
	// (instead of re-sampling).
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
}

func (x *AudioInConfig) Reset() {
	*x = AudioInConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioInConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioInConfig) ProtoMessage() {}

func (x *AudioInConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioInConfig.ProtoReflect.Descriptor instead.
func (*AudioInConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{1}
}

func (x *AudioInConfig) GetEncoding() AudioInConfig_Encoding {
	if x != nil {
		return x.Encoding
	}
	return AudioInConfig_ENCODING_UNSPECIFIED
}

func (x *AudioInConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

// Specifies the desired format for the server to use when it returns
// `audio_out` messages.
type AudioOutConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* The encoding of audio data to be returned in all `audio_out`
	// messages.
	Encoding AudioOutConfig_Encoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.assistant.embedded.v1alpha1.AudioOutConfig_Encoding" json:"encoding,omitempty"`
	// *Required* The sample rate in Hertz of the audio data returned in
	// `audio_out` messages. Valid values are: 16000-24000.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// *Required* Current volume setting of the device's audio output.
	// Valid values are 1 to 100 (corresponding to 1% to 100%).
	VolumePercentage int32 `protobuf:"varint,3,opt,name=volume_percentage,json=volumePercentage,proto3" json:"volume_percentage,omitempty"`
}

func (x *AudioOutConfig) Reset() {
	*x = AudioOutConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioOutConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioOutConfig) ProtoMessage() {}

func (x *AudioOutConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioOutConfig.ProtoReflect.Descriptor instead.
func (*AudioOutConfig) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{2}
}

func (x *AudioOutConfig) GetEncoding() AudioOutConfig_Encoding {
	if x != nil {
		return x.Encoding
	}
	return AudioOutConfig_ENCODING_UNSPECIFIED
}

func (x *AudioOutConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *AudioOutConfig) GetVolumePercentage() int32 {
	if x != nil {
		return x.VolumePercentage
	}
	return 0
}

// Provides information about the current dialog state.
type ConverseState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Required* The `conversation_state` value returned in the prior
	// `ConverseResponse`. Omit (do not set the field) if there was no prior
	// `ConverseResponse`. If there was a prior `ConverseResponse`, do not omit
	// this field; doing so will end that conversation (and this new request will
	// start a new conversation).
	ConversationState []byte `protobuf:"bytes,1,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
}

func (x *ConverseState) Reset() {
	*x = ConverseState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConverseState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConverseState) ProtoMessage() {}

func (x *ConverseState) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConverseState.ProtoReflect.Descriptor instead.
func (*ConverseState) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{3}
}

func (x *ConverseState) GetConversationState() []byte {
	if x != nil {
		return x.ConversationState
	}
	return nil
}

// The audio containing the assistant's response to the query. Sequential chunks
// of audio data are received in sequential `ConverseResponse` messages.
type AudioOut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Output-only* The audio data containing the assistant's response to the
	// query. Sequential chunks of audio data are received in sequential
	// `ConverseResponse` messages.
	AudioData []byte `protobuf:"bytes,1,opt,name=audio_data,json=audioData,proto3" json:"audio_data,omitempty"`
}

func (x *AudioOut) Reset() {
	*x = AudioOut{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioOut) ProtoMessage() {}

func (x *AudioOut) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioOut.ProtoReflect.Descriptor instead.
func (*AudioOut) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{4}
}

func (x *AudioOut) GetAudioData() []byte {
	if x != nil {
		return x.AudioData
	}
	return nil
}

// The semantic result for the user's spoken query.
type ConverseResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *Output-only* The recognized transcript of what the user said.
	SpokenRequestText string `protobuf:"bytes,1,opt,name=spoken_request_text,json=spokenRequestText,proto3" json:"spoken_request_text,omitempty"`
	// *Output-only* The text of the assistant's spoken response. This is only
	// returned for an IFTTT action.
	SpokenResponseText string `protobuf:"bytes,2,opt,name=spoken_response_text,json=spokenResponseText,proto3" json:"spoken_response_text,omitempty"`
	// *Output-only* State information for subsequent `ConverseRequest`. This
	// value should be saved in the client and returned in the
	// `conversation_state` with the next `ConverseRequest`. (The client does not
	// need to interpret or otherwise use this value.) There is no need to save
	// this information across device restarts.
	ConversationState []byte `protobuf:"bytes,3,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
	// *Output-only* Specifies the mode of the microphone after this `Converse`
	// RPC is processed.
	MicrophoneMode ConverseResult_MicrophoneMode `protobuf:"varint,4,opt,name=microphone_mode,json=microphoneMode,proto3,enum=google.assistant.embedded.v1alpha1.ConverseResult_MicrophoneMode" json:"microphone_mode,omitempty"`
	// *Output-only* Updated volume level. The value will be 0 or omitted
	// (indicating no change) unless a voice command such as "Increase the volume"
	// or "Set volume level 4" was recognized, in which case the value will be
	// between 1 and 100 (corresponding to the new volume level of 1% to 100%).
	// Typically, a client should use this volume level when playing the
	// `audio_out` data, and retain this value as the current volume level and
	// supply it in the `AudioOutConfig` of the next `ConverseRequest`. (Some
	// clients may also implement other ways to allow the current volume level to
	// be changed, for example, by providing a knob that the user can turn.)
	VolumePercentage int32 `protobuf:"varint,5,opt,name=volume_percentage,json=volumePercentage,proto3" json:"volume_percentage,omitempty"`
}

func (x *ConverseResult) Reset() {
	*x = ConverseResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConverseResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConverseResult) ProtoMessage() {}

func (x *ConverseResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConverseResult.ProtoReflect.Descriptor instead.
func (*ConverseResult) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{5}
}

func (x *ConverseResult) GetSpokenRequestText() string {
	if x != nil {
		return x.SpokenRequestText
	}
	return ""
}

func (x *ConverseResult) GetSpokenResponseText() string {
	if x != nil {
		return x.SpokenResponseText
	}
	return ""
}

func (x *ConverseResult) GetConversationState() []byte {
	if x != nil {
		return x.ConversationState
	}
	return nil
}

func (x *ConverseResult) GetMicrophoneMode() ConverseResult_MicrophoneMode {
	if x != nil {
		return x.MicrophoneMode
	}
	return ConverseResult_MICROPHONE_MODE_UNSPECIFIED
}

func (x *ConverseResult) GetVolumePercentage() int32 {
	if x != nil {
		return x.VolumePercentage
	}
	return 0
}

// The top-level message sent by the client. Clients must send at least two, and
// typically numerous `ConverseRequest` messages. The first message must
// contain a `config` message and must not contain `audio_in` data. All
// subsequent messages must contain `audio_in` data and must not contain a
// `config` message.
type ConverseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one of these fields must be specified in each `ConverseRequest`.
	//
	// Types that are assignable to ConverseRequest:
	//
	//	*ConverseRequest_Config
	//	*ConverseRequest_AudioIn
	ConverseRequest isConverseRequest_ConverseRequest `protobuf_oneof:"converse_request"`
}

func (x *ConverseRequest) Reset() {
	*x = ConverseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConverseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConverseRequest) ProtoMessage() {}

func (x *ConverseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConverseRequest.ProtoReflect.Descriptor instead.
func (*ConverseRequest) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{6}
}

func (m *ConverseRequest) GetConverseRequest() isConverseRequest_ConverseRequest {
	if m != nil {
		return m.ConverseRequest
	}
	return nil
}

func (x *ConverseRequest) GetConfig() *ConverseConfig {
	if x, ok := x.GetConverseRequest().(*ConverseRequest_Config); ok {
		return x.Config
	}
	return nil
}

func (x *ConverseRequest) GetAudioIn() []byte {
	if x, ok := x.GetConverseRequest().(*ConverseRequest_AudioIn); ok {
		return x.AudioIn
	}
	return nil
}

type isConverseRequest_ConverseRequest interface {
	isConverseRequest_ConverseRequest()
}

type ConverseRequest_Config struct {
	// The `config` message provides information to the recognizer that
	// specifies how to process the request.
	// The first `ConverseRequest` message must contain a `config` message.
	Config *ConverseConfig `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

type ConverseRequest_AudioIn struct {
	// The audio data to be recognized. Sequential chunks of audio data are sent
	// in sequential `ConverseRequest` messages. The first `ConverseRequest`
	// message must not contain `audio_in` data and all subsequent
	// `ConverseRequest` messages must contain `audio_in` data. The audio bytes
	// must be encoded as specified in `AudioInConfig`.
	// Audio must be sent at approximately real-time (16000 samples per second).
	// An error will be returned if audio is sent significantly faster or
	// slower.
	AudioIn []byte `protobuf:"bytes,2,opt,name=audio_in,json=audioIn,proto3,oneof"`
}

func (*ConverseRequest_Config) isConverseRequest_ConverseRequest() {}

func (*ConverseRequest_AudioIn) isConverseRequest_ConverseRequest() {}

// The top-level message received by the client. A series of one or more
// `ConverseResponse` messages are streamed back to the client.
type ConverseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one of these fields will be populated in each `ConverseResponse`.
	//
	// Types that are assignable to ConverseResponse:
	//
	//	*ConverseResponse_Error
	//	*ConverseResponse_EventType_
	//	*ConverseResponse_AudioOut
	//	*ConverseResponse_Result
	ConverseResponse isConverseResponse_ConverseResponse `protobuf_oneof:"converse_response"`
}

func (x *ConverseResponse) Reset() {
	*x = ConverseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConverseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConverseResponse) ProtoMessage() {}

func (x *ConverseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConverseResponse.ProtoReflect.Descriptor instead.
func (*ConverseResponse) Descriptor() ([]byte, []int) {
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP(), []int{7}
}

func (m *ConverseResponse) GetConverseResponse() isConverseResponse_ConverseResponse {
	if m != nil {
		return m.ConverseResponse
	}
	return nil
}

func (x *ConverseResponse) GetError() *status.Status {
	if x, ok := x.GetConverseResponse().(*ConverseResponse_Error); ok {
		return x.Error
	}
	return nil
}

func (x *ConverseResponse) GetEventType() ConverseResponse_EventType {
	if x, ok := x.GetConverseResponse().(*ConverseResponse_EventType_); ok {
		return x.EventType
	}
	return ConverseResponse_EVENT_TYPE_UNSPECIFIED
}

func (x *ConverseResponse) GetAudioOut() *AudioOut {
	if x, ok := x.GetConverseResponse().(*ConverseResponse_AudioOut); ok {
		return x.AudioOut
	}
	return nil
}

func (x *ConverseResponse) GetResult() *ConverseResult {
	if x, ok := x.GetConverseResponse().(*ConverseResponse_Result); ok {
		return x.Result
	}
	return nil
}

type isConverseResponse_ConverseResponse interface {
	isConverseResponse_ConverseResponse()
}

type ConverseResponse_Error struct {
	// *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status]
	// message that specifies the error for the operation. If an error occurs
	// during processing, this message will be set and there will be no further
	// messages sent.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type ConverseResponse_EventType_ struct {
	// *Output-only* Indicates the type of event.
	EventType ConverseResponse_EventType `protobuf:"varint,2,opt,name=event_type,json=eventType,proto3,enum=google.assistant.embedded.v1alpha1.ConverseResponse_EventType,oneof"`
}

type ConverseResponse_AudioOut struct {
	// *Output-only* The audio containing the assistant's response to the query.
	AudioOut *AudioOut `protobuf:"bytes,3,opt,name=audio_out,json=audioOut,proto3,oneof"`
}

type ConverseResponse_Result struct {
	// *Output-only* The semantic result for the user's spoken query.
	Result *ConverseResult `protobuf:"bytes,5,opt,name=result,proto3,oneof"`
}

func (*ConverseResponse_Error) isConverseResponse_ConverseResponse() {}

func (*ConverseResponse_EventType_) isConverseResponse_ConverseResponse() {}

func (*ConverseResponse_AudioOut) isConverseResponse_ConverseResponse() {}

func (*ConverseResponse_Result) isConverseResponse_ConverseResponse() {}

var File_google_assistant_embedded_v1alpha1_embedded_assistant_proto protoreflect.FileDescriptor

var file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x2f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x02, 0x0a, 0x0e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x0f, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x5f, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x10, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x6f, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xd1,
	0x01, 0x0a, 0x0d, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x56, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48,
	0x65, 0x72, 0x74, 0x7a, 0x22, 0x3c, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x49,
	0x4e, 0x45, 0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x41, 0x43,
	0x10, 0x02, 0x22, 0x90, 0x02, 0x0a, 0x0e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x4f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2a,
	0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65,
	0x72, 0x74, 0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x2b, 0x0a, 0x11, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x50, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x22, 0x4c, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d,
	0x50, 0x33, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x50, 0x55, 0x53, 0x5f, 0x49, 0x4e, 0x5f,
	0x4f, 0x47, 0x47, 0x10, 0x03, 0x22, 0x3e, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x29, 0x0a, 0x08, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x44, 0x61, 0x74, 0x61,
	0x22, 0x99, 0x03, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54,
	0x65, 0x78, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x6a, 0x0a, 0x0f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f,
	0x6e, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x52, 0x0e, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x2b, 0x0a, 0x11, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x22, 0x5d, 0x0a,
	0x0e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x1f, 0x0a, 0x1b, 0x4d, 0x49, 0x43, 0x52, 0x4f, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x14, 0x0a, 0x10, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x5f, 0x4d, 0x49, 0x43, 0x52, 0x4f, 0x50,
	0x48, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x49, 0x41, 0x4c, 0x4f, 0x47,
	0x5f, 0x46, 0x4f, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x90, 0x01, 0x0a,
	0x0f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1b,
	0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x48, 0x00, 0x52, 0x07, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x42, 0x12, 0x0a, 0x10, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22,
	0x8e, 0x03, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x5f, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x4b, 0x0a, 0x09, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4f,
	0x75, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x4f, 0x75, 0x74, 0x12, 0x4c,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x3d, 0x0a, 0x09,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x56, 0x45,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f,
	0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x32, 0x8e, 0x01, 0x0a, 0x11, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x41, 0x73, 0x73,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x79, 0x0a, 0x08, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x30,
	0x01, 0x42, 0x86, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x65, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x65, 0x64, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0e, 0x41, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2f,
	0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x3b, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescOnce sync.Once
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescData = file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDesc
)

func file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescGZIP() []byte {
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescOnce.Do(func() {
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescData)
	})
	return file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDescData
}

var file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_goTypes = []interface{}{
	(AudioInConfig_Encoding)(0),        // 0: google.assistant.embedded.v1alpha1.AudioInConfig.Encoding
	(AudioOutConfig_Encoding)(0),       // 1: google.assistant.embedded.v1alpha1.AudioOutConfig.Encoding
	(ConverseResult_MicrophoneMode)(0), // 2: google.assistant.embedded.v1alpha1.ConverseResult.MicrophoneMode
	(ConverseResponse_EventType)(0),    // 3: google.assistant.embedded.v1alpha1.ConverseResponse.EventType
	(*ConverseConfig)(nil),             // 4: google.assistant.embedded.v1alpha1.ConverseConfig
	(*AudioInConfig)(nil),              // 5: google.assistant.embedded.v1alpha1.AudioInConfig
	(*AudioOutConfig)(nil),             // 6: google.assistant.embedded.v1alpha1.AudioOutConfig
	(*ConverseState)(nil),              // 7: google.assistant.embedded.v1alpha1.ConverseState
	(*AudioOut)(nil),                   // 8: google.assistant.embedded.v1alpha1.AudioOut
	(*ConverseResult)(nil),             // 9: google.assistant.embedded.v1alpha1.ConverseResult
	(*ConverseRequest)(nil),            // 10: google.assistant.embedded.v1alpha1.ConverseRequest
	(*ConverseResponse)(nil),           // 11: google.assistant.embedded.v1alpha1.ConverseResponse
	(*status.Status)(nil),              // 12: google.rpc.Status
}
var file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_depIdxs = []int32{
	5,  // 0: google.assistant.embedded.v1alpha1.ConverseConfig.audio_in_config:type_name -> google.assistant.embedded.v1alpha1.AudioInConfig
	6,  // 1: google.assistant.embedded.v1alpha1.ConverseConfig.audio_out_config:type_name -> google.assistant.embedded.v1alpha1.AudioOutConfig
	7,  // 2: google.assistant.embedded.v1alpha1.ConverseConfig.converse_state:type_name -> google.assistant.embedded.v1alpha1.ConverseState
	0,  // 3: google.assistant.embedded.v1alpha1.AudioInConfig.encoding:type_name -> google.assistant.embedded.v1alpha1.AudioInConfig.Encoding
	1,  // 4: google.assistant.embedded.v1alpha1.AudioOutConfig.encoding:type_name -> google.assistant.embedded.v1alpha1.AudioOutConfig.Encoding
	2,  // 5: google.assistant.embedded.v1alpha1.ConverseResult.microphone_mode:type_name -> google.assistant.embedded.v1alpha1.ConverseResult.MicrophoneMode
	4,  // 6: google.assistant.embedded.v1alpha1.ConverseRequest.config:type_name -> google.assistant.embedded.v1alpha1.ConverseConfig
	12, // 7: google.assistant.embedded.v1alpha1.ConverseResponse.error:type_name -> google.rpc.Status
	3,  // 8: google.assistant.embedded.v1alpha1.ConverseResponse.event_type:type_name -> google.assistant.embedded.v1alpha1.ConverseResponse.EventType
	8,  // 9: google.assistant.embedded.v1alpha1.ConverseResponse.audio_out:type_name -> google.assistant.embedded.v1alpha1.AudioOut
	9,  // 10: google.assistant.embedded.v1alpha1.ConverseResponse.result:type_name -> google.assistant.embedded.v1alpha1.ConverseResult
	10, // 11: google.assistant.embedded.v1alpha1.EmbeddedAssistant.Converse:input_type -> google.assistant.embedded.v1alpha1.ConverseRequest
	11, // 12: google.assistant.embedded.v1alpha1.EmbeddedAssistant.Converse:output_type -> google.assistant.embedded.v1alpha1.ConverseResponse
	12, // [12:13] is the sub-list for method output_type
	11, // [11:12] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_init() }
func file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_init() {
	if File_google_assistant_embedded_v1alpha1_embedded_assistant_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConverseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioInConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioOutConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConverseState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioOut); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConverseResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConverseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConverseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*ConverseRequest_Config)(nil),
		(*ConverseRequest_AudioIn)(nil),
	}
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ConverseResponse_Error)(nil),
		(*ConverseResponse_EventType_)(nil),
		(*ConverseResponse_AudioOut)(nil),
		(*ConverseResponse_Result)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_goTypes,
		DependencyIndexes: file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_depIdxs,
		EnumInfos:         file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_enumTypes,
		MessageInfos:      file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_msgTypes,
	}.Build()
	File_google_assistant_embedded_v1alpha1_embedded_assistant_proto = out.File
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_rawDesc = nil
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_goTypes = nil
	file_google_assistant_embedded_v1alpha1_embedded_assistant_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EmbeddedAssistantClient is the client API for EmbeddedAssistant service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EmbeddedAssistantClient interface {
	// Initiates or continues a conversation with the embedded assistant service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   ConverseRequest.config
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseResponse.event_type.END_OF_UTTERANCE
	// *   ConverseResponse.result.microphone_mode.DIALOG_FOLLOW_ON
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	//
	// The user then says *bagels* and the assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Converse` method, again with streamed requests and
	// responses, such as:
	//
	// *   ConverseRequest.config
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseResponse.event_type.END_OF_UTTERANCE
	// *   ConverseResponse.result.microphone_mode.CLOSE_MICROPHONE
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// ConverseResponse.audio_out messages will always contain sequential portions
	// of audio.
	Converse(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_ConverseClient, error)
}

type embeddedAssistantClient struct {
	cc grpc.ClientConnInterface
}

func NewEmbeddedAssistantClient(cc grpc.ClientConnInterface) EmbeddedAssistantClient {
	return &embeddedAssistantClient{cc}
}

func (c *embeddedAssistantClient) Converse(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_ConverseClient, error) {
	stream, err := c.cc.NewStream(ctx, &_EmbeddedAssistant_serviceDesc.Streams[0], "/google.assistant.embedded.v1alpha1.EmbeddedAssistant/Converse", opts...)
	if err != nil {
		return nil, err
	}
	x := &embeddedAssistantConverseClient{stream}
	return x, nil
}

type EmbeddedAssistant_ConverseClient interface {
	Send(*ConverseRequest) error
	Recv() (*ConverseResponse, error)
	grpc.ClientStream
}

type embeddedAssistantConverseClient struct {
	grpc.ClientStream
}

func (x *embeddedAssistantConverseClient) Send(m *ConverseRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *embeddedAssistantConverseClient) Recv() (*ConverseResponse, error) {
	m := new(ConverseResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// EmbeddedAssistantServer is the server API for EmbeddedAssistant service.
type EmbeddedAssistantServer interface {
	// Initiates or continues a conversation with the embedded assistant service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   ConverseRequest.config
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseResponse.event_type.END_OF_UTTERANCE
	// *   ConverseResponse.result.microphone_mode.DIALOG_FOLLOW_ON
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	//
	// The user then says *bagels* and the assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Converse` method, again with streamed requests and
	// responses, such as:
	//
	// *   ConverseRequest.config
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseRequest.audio_in
	// *   ConverseResponse.event_type.END_OF_UTTERANCE
	// *   ConverseResponse.result.microphone_mode.CLOSE_MICROPHONE
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	// *   ConverseResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// ConverseResponse.audio_out messages will always contain sequential portions
	// of audio.
	Converse(EmbeddedAssistant_ConverseServer) error
}

// UnimplementedEmbeddedAssistantServer can be embedded to have forward compatible implementations.
type UnimplementedEmbeddedAssistantServer struct {
}

func (*UnimplementedEmbeddedAssistantServer) Converse(EmbeddedAssistant_ConverseServer) error {
	return status1.Errorf(codes.Unimplemented, "method Converse not implemented")
}

func RegisterEmbeddedAssistantServer(s *grpc.Server, srv EmbeddedAssistantServer) {
	s.RegisterService(&_EmbeddedAssistant_serviceDesc, srv)
}

func _EmbeddedAssistant_Converse_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(EmbeddedAssistantServer).Converse(&embeddedAssistantConverseServer{stream})
}

type EmbeddedAssistant_ConverseServer interface {
	Send(*ConverseResponse) error
	Recv() (*ConverseRequest, error)
	grpc.ServerStream
}

type embeddedAssistantConverseServer struct {
	grpc.ServerStream
}

func (x *embeddedAssistantConverseServer) Send(m *ConverseResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *embeddedAssistantConverseServer) Recv() (*ConverseRequest, error) {
	m := new(ConverseRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _EmbeddedAssistant_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.assistant.embedded.v1alpha1.EmbeddedAssistant",
	HandlerType: (*EmbeddedAssistantServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Converse",
			Handler:       _EmbeddedAssistant_Converse_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/assistant/embedded/v1alpha1/embedded_assistant.proto",
}
