/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.firewall.policy.dto.ip.protocol.ipv6;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.ubnt.net.integration.api.firewall.policy.dto.ip.protocol.ipv6.IntegrationFirewallPolicyIpv6ProtocolFilterDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.beans.ConstructorProperties;
import lombok.Generated;

@Schema(name="Firewall policy IPv4 protocol number", description="Defines rules for matching by protocol number.")
@JsonDeserialize(builder=IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder.class)
public final class IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto
implements IntegrationFirewallPolicyIpv6ProtocolFilterDto {
    @Min(value=0L)
    @Max(value=255L)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Protocol number as defined by IANA.")
    private final @Min(value=0L) @Max(value=255L) int protocolNumber;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Match on all protocols except the specified protocol.")
    private final boolean matchOpposite;

    @ConstructorProperties(value={"protocolNumber", "matchOpposite"})
    @Generated
    IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto(int n2, boolean bl) {
        this.protocolNumber = n2;
        this.matchOpposite = bl;
    }

    @Generated
    public static IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder builder() {
        return new IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder();
    }

    @Generated
    public int getProtocolNumber() {
        return this.protocolNumber;
    }

    @Generated
    public boolean isMatchOpposite() {
        return this.matchOpposite;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto)) {
            return false;
        }
        IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto integrationFirewallPolicyIpv6ProtocolNumberFilterDto = (IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto)object;
        if (this.getProtocolNumber() != integrationFirewallPolicyIpv6ProtocolNumberFilterDto.getProtocolNumber()) {
            return false;
        }
        return this.isMatchOpposite() == integrationFirewallPolicyIpv6ProtocolNumberFilterDto.isMatchOpposite();
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        n2 = n2 * 59 + this.getProtocolNumber();
        n2 = n2 * 59 + (this.isMatchOpposite() ? 79 : 97);
        return n2;
    }

    @Generated
    public String toString() {
        return "IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto(protocolNumber=" + this.getProtocolNumber() + ", matchOpposite=" + this.isMatchOpposite() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder {
        @Generated
        private int \u00d200000;
        @Generated
        private boolean o00000;

        @Generated
        IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder() {
        }

        @Generated
        public IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder protocolNumber(int n2) {
            this.\u00d200000 = n2;
            return this;
        }

        @Generated
        public IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder matchOpposite(boolean bl) {
            this.o00000 = bl;
            return this;
        }

        @Generated
        public IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto build() {
            return new IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto(this.\u00d200000, this.o00000);
        }

        @Generated
        public String toString() {
            return "IntegrationFirewallPolicyIpv6ProtocolNumberFilterDto.IntegrationFirewallPolicyIpv6ProtocolNumberFilterDtoBuilder(protocolNumber=" + this.\u00d200000 + ", matchOpposite=" + this.o00000 + ")";
        }
    }
}

