/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.serializer.AbstractRecordSerializer;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordSerializer
extends AbstractRecordSerializer<Record> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Record record;

    public RecordSerializer(Record record) {
        this.record = record;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing Record");
        this.writeContentType(this.record);
        this.writeProtocolVersion(this.record);
        if (this.record.getEpoch() != null) {
            this.appendInt((Integer)this.record.getEpoch().getValue(), 2);
            this.appendBigInteger((BigInteger)this.record.getSequenceNumber().getValue(), 6);
        }
        this.writeLength(this.record);
        this.writeProtocolMessageBytes(this.record);
        return this.getAlreadySerialized();
    }

    private void writeContentType(Record record) {
        this.appendByte((Byte)record.getContentType().getValue());
        LOGGER.debug("ContentType: " + record.getContentType().getValue());
    }

    private void writeProtocolVersion(Record record) {
        this.appendBytes((byte[])record.getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])record.getProtocolVersion().getValue())));
    }

    private void writeLength(Record record) {
        this.appendInt((Integer)record.getLength().getValue(), 2);
        LOGGER.debug("Length: " + record.getLength().getValue());
    }

    private void writeProtocolMessageBytes(Record record) {
        this.appendBytes((byte[])record.getProtocolMessageBytes().getValue());
        LOGGER.debug("ProtocolMessageBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])record.getProtocolMessageBytes().getValue())));
    }
}

