/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FindReceivedProtocolMessageAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private ProtocolMessageType protocolMessageType;
    private Boolean found = false;

    public FindReceivedProtocolMessageAction() {
    }

    public FindReceivedProtocolMessageAction(ProtocolMessageType protocolMessageType) {
        this.protocolMessageType = protocolMessageType;
    }

    public FindReceivedProtocolMessageAction(String alias, ProtocolMessageType protocolMessageType) {
        super(alias);
        this.protocolMessageType = protocolMessageType;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext ctx = state.getTlsContext(this.getConnectionAlias());
        this.found = WorkflowTraceUtil.didReceiveMessage(this.protocolMessageType, state.getWorkflowTrace());
        if (this.found.booleanValue()) {
            LOGGER.info("Found " + this.protocolMessageType.name() + " (" + this.protocolMessageType.getValue() + ")");
        }
        this.setExecuted(Boolean.TRUE);
    }

    public ProtocolMessageType getProtocolMessageType() {
        return this.protocolMessageType;
    }

    public void setProtocolMessageType(ProtocolMessageType protocolMessageType) {
        this.protocolMessageType = protocolMessageType;
    }

    public Boolean isFound() {
        return this.found;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }
}

