/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.tls.TlsUtils;

public class PseudoRandomFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MASTER_SECRET_LABEL = "master secret";
    public static final String CLIENT_FINISHED_LABEL = "client finished";
    public static final String SERVER_FINISHED_LABEL = "server finished";
    public static final String KEY_EXPANSION_LABEL = "key expansion";
    public static final String EXTENDED_MASTER_SECRET_LABEL = "extended master secret";
    public static final String CLIENT_WRITE_KEY_LABEL = "client write key";
    public static final String SERVER_WRITE_KEY_LABEL = "server write key";
    public static final String IV_BLOCK_LABEL = "IV block";

    public static byte[] compute(PRFAlgorithm prfAlgorithm, byte[] secret, String label, byte[] seed, int size) throws CryptoException {
        if (prfAlgorithm == null) {
            LOGGER.warn("Trying to compute PRF without specified PRF algorithm. Using TLS 1.0/TLS 1.1 as default.");
            prfAlgorithm = PRFAlgorithm.TLS_PRF_LEGACY;
        }
        switch (prfAlgorithm) {
            case TLS_PRF_SHA256: 
            case TLS_PRF_SHA384: 
            case TLS_PRF_GOSTR3411: 
            case TLS_PRF_GOSTR3411_2012_256: {
                return PseudoRandomFunction.computeTls12(secret, label, seed, size, prfAlgorithm.getMacAlgorithm().getJavaName());
            }
            case TLS_PRF_LEGACY: {
                return TlsUtils.PRF_legacy((byte[])secret, (String)label, (byte[])seed, (int)size);
            }
        }
        throw new UnsupportedOperationException("PRF computation for different protocol versions is not supported yet");
    }

    private static byte[] computeTls12(byte[] secret, String label, byte[] seed, int size, String macAlgorithm) throws CryptoException {
        try {
            SecretKeySpec keySpec;
            byte[] labelSeed;
            block9: {
                labelSeed = ArrayConverter.concatenate((byte[][])new byte[][]{label.getBytes(Charset.forName("ASCII")), seed});
                keySpec = null;
                if (secret == null || secret.length == 0) {
                    try {
                        keySpec = new SecretKeySpec(new byte[]{0, 0}, macAlgorithm);
                        try {
                            Field field = keySpec.getClass().getDeclaredField("key");
                            field.setAccessible(true);
                            field.set(keySpec, new byte[0]);
                            break block9;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                            throw new CryptoException("Could not access KeySpec with empty Key", ex);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CryptoException("Could not tls12_prf output without Secret", ex);
                    }
                }
                keySpec = new SecretKeySpec(secret, macAlgorithm);
            }
            Mac mac = Mac.getInstance(macAlgorithm);
            mac.init(keySpec);
            byte[] out = new byte[]{};
            byte[] ai = labelSeed;
            while (out.length < size) {
                mac.update(ai);
                byte[] buf = mac.doFinal();
                ai = buf;
                mac.update(ai);
                mac.update(labelSeed);
                byte[] buf2 = mac.doFinal();
                if (buf2.length == 0) {
                    throw new CryptoException("Could not Calc PRF output. Mac length is zero!");
                }
                out = ArrayConverter.concatenate((byte[][])new byte[][]{out, buf2});
            }
            return Arrays.copyOf(out, size);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new CryptoException(ex);
        }
    }

    private PseudoRandomFunction() {
    }
}

