/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.PWDServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PWDServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PWDServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;

public class PWDServerKeyExchangeHandler
extends ServerKeyExchangeHandler<PWDServerKeyExchangeMessage> {
    public PWDServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public PWDServerKeyExchangeParser getParser(byte[] message, int pointer) {
        return new PWDServerKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), AlgorithmResolver.getKeyExchangeAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite()), this.tlsContext.getConfig());
    }

    public PWDServerKeyExchangePreparator getPreparator(PWDServerKeyExchangeMessage message) {
        return new PWDServerKeyExchangePreparator(this.tlsContext.getChooser(), message);
    }

    public PWDServerKeyExchangeSerializer getSerializer(PWDServerKeyExchangeMessage message) {
        return new PWDServerKeyExchangeSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(PWDServerKeyExchangeMessage message) {
        this.tlsContext.setSelectedGroup(NamedGroup.getNamedGroup((byte[])message.getNamedGroup().getValue()));
        this.tlsContext.setServerPWDSalt((byte[])message.getSalt().getValue());
        this.tlsContext.setServerPWDElement(PointFormatter.formatFromByteArray(this.tlsContext.getChooser().getSelectedNamedGroup(), (byte[])message.getElement().getValue()));
        this.tlsContext.setServerPWDScalar(new BigInteger(1, (byte[])message.getScalar().getValue()));
        if (message.getComputations() != null) {
            this.tlsContext.setPWDPE(message.getComputations().getPasswordElement());
            this.tlsContext.setServerPWDPrivate(message.getComputations().getPrivateKeyScalar());
        }
    }
}

