/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.asn1.parser.ParserException;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponse;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponseParser;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateStatusHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusMessage
extends HandshakeMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger certificateStatusType;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger ocspResponseLength;
    @ModifiableVariableProperty
    private ModifiableByteArray ocspResponseBytes;

    public CertificateStatusMessage() {
        super(HandshakeMessageType.CERTIFICATE_STATUS);
    }

    public CertificateStatusMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.CERTIFICATE_STATUS);
    }

    @Override
    public CertificateStatusHandler getHandler(TlsContext context) {
        return new CertificateStatusHandler(context);
    }

    @Override
    public String toString() {
        OCSPResponse response = null;
        if (this.getOcspResponseBytes() != null) {
            try {
                response = OCSPResponseParser.parseResponse((byte[])this.getOcspResponseBytes().getValue());
            }
            catch (ParserException | IOException e) {
                LOGGER.error("Could not parse embedded OCSP response in CertificateStatusMessage." + e);
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("CertificateStatusMessage:");
        if (response != null) {
            try {
                builder.append("\n ").append(response.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not print parsed OCSP response in CertificateStatusMessage.");
            }
        } else {
            builder.append("\n null");
        }
        return builder.toString();
    }

    public ModifiableInteger getCertificateStatusType() {
        return this.certificateStatusType;
    }

    public void setCertificateStatusType(int certificateStatusType) {
        this.certificateStatusType = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificateStatusType, (Integer)certificateStatusType);
    }

    public void setCertificateStatusType(ModifiableInteger certificateStatusType) {
        this.certificateStatusType = certificateStatusType;
    }

    public ModifiableInteger getOcspResponseLength() {
        return this.ocspResponseLength;
    }

    public void setOcspResponseLength(int ocspResponseLength) {
        this.ocspResponseLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.ocspResponseLength, (Integer)ocspResponseLength);
    }

    public void setOcspResponseLength(ModifiableInteger ocspResponseLength) {
        this.ocspResponseLength = ocspResponseLength;
    }

    public ModifiableByteArray getOcspResponseBytes() {
        return this.ocspResponseBytes;
    }

    public void setOcspResponseBytes(byte[] ocspResponseBytes) {
        this.ocspResponseBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.ocspResponseBytes, (byte[])ocspResponseBytes);
    }

    public void setOcspResponseBytes(ModifiableByteArray ocspResponseBytes) {
        this.ocspResponseBytes = ocspResponseBytes;
    }
}

