/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.HelloRetryRequestHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public class HelloRetryRequestMessage
extends HandshakeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray protocolVersion;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray selectedCipherSuite;

    public HelloRetryRequestMessage() {
        super(HandshakeMessageType.HELLO_RETRY_REQUEST);
    }

    public HelloRetryRequestMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.HELLO_RETRY_REQUEST);
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setProtocolVersion(byte[] array) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])array);
    }

    public ModifiableByteArray getSelectedCipherSuite() {
        return this.selectedCipherSuite;
    }

    public void setSelectedCipherSuite(ModifiableByteArray cipherSuite) {
        this.selectedCipherSuite = cipherSuite;
    }

    public void setSelectedCipherSuite(byte[] value) {
        this.selectedCipherSuite = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.selectedCipherSuite, (byte[])value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HelloRetryRequestMessage:");
        sb.append("\n  Protocol Version: ");
        if (this.protocolVersion != null && this.protocolVersion.getValue() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.protocolVersion.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Selected Cipher Suite: ");
        if (this.selectedCipherSuite != null && this.selectedCipherSuite.getValue() != null) {
            sb.append((Object)CipherSuite.getCipherSuite((byte[])this.selectedCipherSuite.getValue())).append("\n  Extensions: ");
        } else {
            sb.append("null");
        }
        sb.append("\n  Extensions: ");
        if (this.getExtensions() == null) {
            sb.append("null");
        } else {
            for (ExtensionMessage e : this.getExtensions()) {
                sb.append("\n  ").append(e.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new HelloRetryRequestHandler(context);
    }
}

