/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.cert;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificatePair;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificatePairParser
extends Parser<CertificatePair> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificatePairParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public CertificatePair parse() {
        LOGGER.debug("Parsing CertificatePair");
        CertificatePair pair = new CertificatePair();
        this.parseCertificateLength(pair);
        this.parseCertificate(pair);
        this.parseExtensionsLength(pair);
        this.parseExtensions(pair);
        return pair;
    }

    private void parseCertificateLength(CertificatePair pair) {
        pair.setCertificateLength(this.parseIntField(3));
        LOGGER.debug("CertificateLength: " + pair.getCertificateLength().getValue());
    }

    private void parseCertificate(CertificatePair pair) {
        pair.setCertificate(this.parseByteArrayField((Integer)pair.getCertificateLength().getValue()));
        LOGGER.debug("Certificate: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getCertificate().getValue())));
    }

    private void parseExtensionsLength(CertificatePair pair) {
        pair.setExtensionsLength(this.parseIntField(2));
        LOGGER.debug("ExtensionsLength: " + pair.getCertificateLength().getValue());
    }

    private void parseExtensions(CertificatePair pair) {
        pair.setExtensions(this.parseByteArrayField((Integer)pair.getExtensionsLength().getValue()));
        LOGGER.debug("Extensions: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getCertificate().getValue())));
    }
}

