/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignedCertificateTimestampExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignedCertificateTimestampExtensionParser
extends ExtensionParser<SignedCertificateTimestampExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SignedCertificateTimestampExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(SignedCertificateTimestampExtensionMessage msg) {
        if ((Integer)msg.getExtensionLength().getValue() > 65535) {
            LOGGER.warn("The SingedCertificateTimestamp ticket length shouldn't exceed 2 bytes as defined in RFC 6962. Length was " + msg.getExtensionLength().getValue());
        }
        msg.setSignedTimestamp(this.parseByteArrayField((Integer)msg.getExtensionLength().getValue()));
        LOGGER.debug("The signed certificate timestamp extension parser parsed the value " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getSignedTimestamp()));
    }

    @Override
    protected SignedCertificateTimestampExtensionMessage createExtensionMessage() {
        return new SignedCertificateTimestampExtensionMessage();
    }
}

