/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAClientKeyExchangePreparator<T extends RSAClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected byte[] padding;
    protected byte[] premasterSecret;
    protected byte[] clientServerRandom;
    protected byte[] masterSecret;
    protected byte[] encrypted;
    protected final T msg;

    public RSAClientKeyExchangePreparator(Chooser chooser, T message) {
        super(chooser, (ClientKeyExchangeMessage)message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing RSAClientKeyExchangeMessage");
        this.prepareAfterParse(true);
        this.prepareSerializedPublicKey(this.msg);
        this.prepareSerializedPublicKeyLength(this.msg);
    }

    protected byte[] generatePremasterSecret() {
        byte[] tempPremasterSecret = this.chooser.getContext().getPreMasterSecret();
        if (tempPremasterSecret != null) {
            LOGGER.debug("Using preset PreMasterSecret from context.");
            return tempPremasterSecret;
        }
        ((RSAClientKeyExchangeMessage)this.msg).getComputations().setPremasterSecretProtocolVersion(this.chooser.getHighestClientProtocolVersion().getValue());
        tempPremasterSecret = new byte[46];
        this.chooser.getContext().getRandom().nextBytes(tempPremasterSecret);
        return ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])((RSAClientKeyExchangeMessage)this.msg).getComputations().getPremasterSecretProtocolVersion().getValue(), tempPremasterSecret});
    }

    protected RSAPublicKey generateFreshKey() {
        KeyPairGenerator keyGen = null;
        try {
            keyGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PreparationException("Could not generate a new Key", ex);
        }
        return (RSAPublicKey)keyGen.genKeyPair().getPublic();
    }

    protected void preparePadding(T msg) {
        ((RSAClientKeyExchangeMessage)msg).getComputations().setPadding(this.padding);
        LOGGER.debug("Padding: " + ArrayConverter.bytesToHexString((byte[])((byte[])((RSAClientKeyExchangeMessage)msg).getComputations().getPadding().getValue())));
    }

    protected void preparePremasterSecret(T msg) {
        ((RSAClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        LOGGER.debug("PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])((RSAClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue())));
    }

    protected void preparePlainPaddedPremasterSecret(T msg) {
        ((RSAClientKeyExchangeMessage)msg).getComputations().setPlainPaddedPremasterSecret(ArrayConverter.concatenate((byte[][])new byte[][]{{0, 2}, this.padding, {0}, (byte[])((RSAClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue()}));
        LOGGER.debug("PlainPaddedPremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])((RSAClientKeyExchangeMessage)msg).getComputations().getPlainPaddedPremasterSecret().getValue())));
    }

    protected void prepareClientServerRandom(T msg) {
        this.clientServerRandom = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((RSAClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.clientServerRandom);
        LOGGER.debug("ClientRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])((RSAClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue())));
    }

    protected void prepareSerializedPublicKey(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKey(this.encrypted);
        LOGGER.debug("SerializedPublicKey (encrypted premaster secret): " + ArrayConverter.bytesToHexString((byte[])((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue())));
    }

    protected void prepareSerializedPublicKeyLength(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("SerializedPublicKeyLength (encrypted premaster secret length): " + ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected byte[] decryptPremasterSecret() {
        BigInteger bigIntegerEncryptedPremasterSecret = new BigInteger(1, (byte[])((ClientKeyExchangeMessage)this.msg).getPublicKey().getValue());
        BigInteger serverPrivateKey = this.chooser.getServerRSAPrivateKey();
        if (this.chooser.getServerRsaModulus().equals(BigInteger.ZERO)) {
            LOGGER.warn("RSA Modulus is Zero, returning new byte[0] as decryptedPremasterSecret");
            return new byte[0];
        }
        BigInteger decrypted = bigIntegerEncryptedPremasterSecret.modPow(serverPrivateKey.abs(), this.chooser.getServerRsaModulus().abs());
        return decrypted.toByteArray();
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        ((RSAClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        int keyByteLength = this.chooser.getServerRsaModulus().bitLength() / 8;
        if (clientMode && (((ClientKeyExchangeMessage)this.msg).getPublicKey() == null || ((ClientKeyExchangeMessage)this.msg).getPublicKey().getValue() == null)) {
            int randomByteLength = keyByteLength - 48 - 3;
            if (randomByteLength > 0) {
                this.padding = new byte[randomByteLength];
                this.chooser.getContext().getRandom().nextBytes(this.padding);
                ArrayConverter.makeArrayNonZero((byte[])this.padding);
            } else {
                this.padding = new byte[0];
            }
            this.preparePadding(this.msg);
            this.premasterSecret = this.generatePremasterSecret();
            this.preparePremasterSecret(this.msg);
            this.preparePlainPaddedPremasterSecret(this.msg);
            byte[] paddedPremasterSecret = (byte[])((RSAClientKeyExchangeMessage)this.msg).getComputations().getPlainPaddedPremasterSecret().getValue();
            if (paddedPremasterSecret.length == 0) {
                LOGGER.warn("paddedPremasterSecret length is zero length!");
                paddedPremasterSecret = new byte[]{0};
            }
            BigInteger biPaddedPremasterSecret = new BigInteger(1, paddedPremasterSecret);
            BigInteger biEncrypted = biPaddedPremasterSecret.modPow(this.chooser.getServerRSAPublicKey().abs(), this.chooser.getServerRsaModulus().abs());
            this.encrypted = ArrayConverter.bigIntegerToByteArray((BigInteger)biEncrypted, (int)(this.chooser.getServerRsaModulus().bitLength() / 8), (boolean)true);
            this.prepareSerializedPublicKey(this.msg);
            this.premasterSecret = this.manipulatePremasterSecret(this.premasterSecret);
            this.preparePremasterSecret(this.msg);
        } else {
            LOGGER.debug("Decrypting premasterSecret");
            int randomByteLength = keyByteLength - 48 - 1;
            byte[] paddedPremasterSecret = this.decryptPremasterSecret();
            LOGGER.debug("PaddedPremaster:" + ArrayConverter.bytesToHexString((byte[])paddedPremasterSecret));
            if (randomByteLength < paddedPremasterSecret.length && randomByteLength > 0) {
                this.premasterSecret = Arrays.copyOfRange(paddedPremasterSecret, randomByteLength, paddedPremasterSecret.length);
                this.premasterSecret = this.manipulatePremasterSecret(this.premasterSecret);
                this.preparePremasterSecret(this.msg);
                if (this.premasterSecret.length > 2) {
                    ((RSAClientKeyExchangeMessage)this.msg).getComputations().setPremasterSecretProtocolVersion(Arrays.copyOfRange(this.premasterSecret, 0, 2));
                } else {
                    LOGGER.warn("Decrypted PMS is not long enough to contain protocol version bytes");
                }
            } else {
                LOGGER.warn("RandomByteLength too short! Using empty premasterSecret!");
                this.premasterSecret = new byte[0];
            }
        }
    }

    protected byte[] manipulatePremasterSecret(byte[] premasterSecret) {
        return premasterSecret;
    }
}

