/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.tokenbinding;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.tokenbinding.TokenBindingMessage;

public class TokenBindingMessageSerializer
extends ProtocolMessageSerializer<TokenBindingMessage> {
    private final TokenBindingMessage message;

    public TokenBindingMessageSerializer(TokenBindingMessage message, ProtocolVersion version) {
        super(message, version);
        this.message = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        this.appendInt((Integer)this.message.getTokenbindingsLength().getValue(), 2);
        this.serializeBinding();
        return this.getAlreadySerialized();
    }

    public byte[] serializeKey() {
        if (this.message.getPoint() != null && this.message.getPoint().getValue() != null) {
            this.appendInt((Integer)this.message.getPointLength().getValue(), 1);
            this.appendBytes((byte[])this.message.getPoint().getValue());
        } else {
            this.appendInt((Integer)this.message.getModulusLength().getValue(), 2);
            this.appendBytes((byte[])this.message.getModulus().getValue());
            this.appendInt((Integer)this.message.getPublicExponentLength().getValue(), 1);
            this.appendBytes((byte[])this.message.getPublicExponent().getValue());
        }
        return this.getAlreadySerialized();
    }

    public byte[] serializeBinding() {
        this.appendByte((Byte)this.message.getTokenbindingType().getValue());
        this.appendByte((Byte)this.message.getKeyParameter().getValue());
        this.appendInt((Integer)this.message.getKeyLength().getValue(), 2);
        this.serializeKey();
        this.appendInt((Integer)this.message.getSignatureLength().getValue(), 2);
        this.appendBytes((byte[])this.message.getSignature().getValue());
        this.appendInt((Integer)this.message.getExtensionLength().getValue(), 2);
        this.appendBytes((byte[])this.message.getExtensionBytes().getValue());
        return this.getAlreadySerialized();
    }
}

