/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenericReceiveAction
extends MessageAction
implements ReceivingAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public GenericReceiveAction() {
    }

    public GenericReceiveAction(List<ProtocolMessage> messages) {
        super(messages);
    }

    public GenericReceiveAction(ProtocolMessage ... messages) {
        this(new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public GenericReceiveAction(String connectionAlias) {
        super(connectionAlias);
    }

    public GenericReceiveAction(String connectionAlias, List<ProtocolMessage> messages) {
        super(connectionAlias, messages);
    }

    public GenericReceiveAction(String connectionAlias, ProtocolMessage ... messages) {
        super(connectionAlias, new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    @Override
    public void execute(State state) {
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        LOGGER.debug("Receiving Messages...");
        TlsContext ctx = state.getTlsContext(this.getConnectionAlias());
        MessageActionResult result = this.receiveMessageHelper.receiveMessages(ctx);
        this.records.addAll(result.getRecordList());
        this.messages.addAll(result.getMessageList());
        this.setExecuted(true);
        String received = this.getReadableString(this.messages);
        LOGGER.info("Received Messages (" + ctx + "): " + received);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Receive Action:\n");
        sb.append("\tActual:");
        for (ProtocolMessage message : this.messages) {
            sb.append(message.toCompactString());
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.messages = new LinkedList();
        this.records = new LinkedList();
        this.setExecuted(Boolean.FALSE);
    }

    @Override
    public List<ProtocolMessage> getReceivedMessages() {
        return this.messages;
    }

    @Override
    public List<AbstractRecord> getReceivedRecords() {
        return this.records;
    }
}

