/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.ByteArrayAdapter;
import java.util.Arrays;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlType(propOrder={"bytesToInsert", "startPosition", "modificationFilter", "postModification"})
public class ByteArrayInsertModification
extends VariableModification<byte[]> {
    private static final int MAX_EXPLICIT_VALUE = 256;
    private static final int MAX_INSERT_MODIFIER = 32;
    private byte[] bytesToInsert;
    private int startPosition;

    public ByteArrayInsertModification() {
    }

    public ByteArrayInsertModification(byte[] bytesToInsert, int startPosition) {
        this.bytesToInsert = bytesToInsert;
        this.startPosition = startPosition;
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        if (input == null) {
            input = new byte[]{};
        }
        byte[] result = (byte[])input.clone();
        int start = this.startPosition;
        if (start < 0 && (start += input.length) < 0) {
            LOGGER.debug("Trying to insert from too negative Startposition. start = " + this.startPosition);
            return input;
        }
        if (this.startPosition > input.length) {
            LOGGER.debug("Trying to insert behind the Array. ArraySize:" + input.length + " Insert Position:" + this.startPosition);
            return input;
        }
        byte[] ret1 = Arrays.copyOf(input, start);
        byte[] ret3 = null;
        if (start < input.length) {
            ret3 = Arrays.copyOfRange(input, start, input.length);
        }
        return ArrayConverter.concatenate(ret1, this.bytesToInsert, ret3);
    }

    @XmlJavaTypeAdapter(value=ByteArrayAdapter.class)
    public byte[] getBytesToInsert() {
        return this.bytesToInsert;
    }

    public void setBytesToInsert(byte[] bytesToInsert) {
        this.bytesToInsert = bytesToInsert;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    @Override
    public VariableModification<byte[]> getModifiedCopy() {
        Random r = new Random();
        if (r.nextBoolean()) {
            int index = r.nextInt(this.bytesToInsert.length);
            byte[] newValue = Arrays.copyOf(this.bytesToInsert, this.bytesToInsert.length);
            newValue[index] = (byte)r.nextInt(256);
            return new ByteArrayInsertModification(newValue, this.startPosition);
        }
        byte[] newValue = Arrays.copyOf(this.bytesToInsert, this.bytesToInsert.length);
        int modifier = r.nextInt(32);
        if (r.nextBoolean()) {
            modifier *= -1;
        }
        if ((modifier = this.startPosition + modifier) <= 0) {
            modifier = 1;
        }
        return new ByteArrayInsertModification(newValue, modifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Arrays.hashCode(this.bytesToInsert);
        hash = 59 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayInsertModification other = (ByteArrayInsertModification)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return Arrays.equals(this.bytesToInsert, other.bytesToInsert);
    }

    public String toString() {
        return "ByteArrayInsertModification{bytesToInsert=" + ArrayConverter.bytesToHexString(this.bytesToInsert) + ", startPosition=" + this.startPosition + '}';
    }
}

