/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.FileConfigurationException;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayDeleteModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayDuplicateModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayExplicitValueModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayInsertModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayPayloadModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayShuffleModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayXorModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ByteArrayModificationFactory {
    private static final int BYTE_ARRAY_SHUFFLE_MODIFICATION = 6;
    private static final int BYTE_ARRAY_EXPLICIT_VALUE_MODIFICATION_FROM_FILE = 5;
    private static final int BYTE_ARRAY_DUPLICATE_MODIFICATION = 4;
    private static final int BYTE_ARRAY_EXPLICIT_VALUE_MODIFICATION = 3;
    private static final int BYTE_ARRAY_DELETE_MODIFICATION = 2;
    private static final int BYTE_ARRAY_INSERT_MODIFICATION = 1;
    private static final int BYTE_ARRAY_XOR_MODIFICATION = 0;
    private static final int MODIFICATION_COUNT = 7;
    private static final int MAX_CONFIG_PARAMETER = 200;
    private static final int EXPLICIT_VALUE_RANDOM = 1000;
    private static final int MODIFIED_ARRAY_LENGTH_ESTIMATION = 50;
    private static List<VariableModification<byte[]>> modificationsFromFile;
    public static final String FILE_NAME = "de/rub/nds/modifiablevariable/explicit/array.vec";

    public static VariableModification<byte[]> xor(byte[] xor, int startPosition) {
        return new ByteArrayXorModification(xor, startPosition);
    }

    public static VariableModification<byte[]> payload(byte[] payload) {
        return new ByteArrayPayloadModification(payload);
    }

    public static VariableModification<byte[]> insert(byte[] bytesToInsert, int startPosition) {
        return new ByteArrayInsertModification(bytesToInsert, startPosition);
    }

    public static VariableModification<byte[]> delete(int startPosition, int count) {
        return new ByteArrayDeleteModification(startPosition, count);
    }

    public static VariableModification<byte[]> duplicate() {
        return new ByteArrayDuplicateModification();
    }

    public static VariableModification<byte[]> explicitValue(byte[] explicitValue) {
        return new ByteArrayExplicitValueModification(explicitValue);
    }

    public static VariableModification<byte[]> explicitValueFromFile(int value) {
        List<VariableModification<byte[]>> modifications = ByteArrayModificationFactory.modificationsFromFile();
        int pos = value % modifications.size();
        return modifications.get(pos);
    }

    public static VariableModification<byte[]> shuffle(byte[] shuffle) {
        return new ByteArrayShuffleModification(shuffle);
    }

    public static synchronized List<VariableModification<byte[]>> modificationsFromFile() {
        try {
            if (modificationsFromFile == null) {
                String line;
                modificationsFromFile = new LinkedList<VariableModification<byte[]>>();
                ClassLoader classLoader = ByteArrayModificationFactory.class.getClassLoader();
                InputStream is = classLoader.getResourceAsStream(FILE_NAME);
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    line = line.replaceAll("\\s+", "");
                    byte[] value = ArrayConverter.hexStringToByteArray(line);
                    modificationsFromFile.add(ByteArrayModificationFactory.explicitValue(value));
                }
            }
            return modificationsFromFile;
        }
        catch (IOException ex) {
            throw new FileConfigurationException("Modifiable variable file name could not have been found.", ex);
        }
    }

    public static VariableModification<byte[]> createRandomModification(byte[] originalValue) {
        int modifiedArrayLength;
        Random random = RandomHelper.getRandom();
        int r = random.nextInt(7);
        VariableModification vm = null;
        if (originalValue == null) {
            modifiedArrayLength = 50;
        } else {
            modifiedArrayLength = originalValue.length;
            if (originalValue.length == 0 || originalValue.length == 1) {
                r = 3;
            }
        }
        switch (r) {
            case 0: {
                int modificationArrayLength = random.nextInt(modifiedArrayLength);
                if (modificationArrayLength == 0) {
                    ++modificationArrayLength;
                }
                byte[] xor = new byte[modificationArrayLength];
                random.nextBytes(xor);
                int startPosition = random.nextInt(modifiedArrayLength - modificationArrayLength);
                vm = new ByteArrayXorModification(xor, startPosition);
                return vm;
            }
            case 1: {
                int modificationArrayLength = random.nextInt(200);
                if (modificationArrayLength == 0) {
                    ++modificationArrayLength;
                }
                byte[] bytesToInsert = new byte[modificationArrayLength];
                random.nextBytes(bytesToInsert);
                int insertPosition = random.nextInt(modifiedArrayLength);
                vm = new ByteArrayInsertModification(bytesToInsert, insertPosition);
                return vm;
            }
            case 2: {
                int startPosition = random.nextInt(modifiedArrayLength - 1);
                int count = random.nextInt(modifiedArrayLength - startPosition);
                vm = new ByteArrayDeleteModification(startPosition, ++count);
                return vm;
            }
            case 3: {
                int modificationArrayLength = random.nextInt(200);
                if (modificationArrayLength == 0) {
                    ++modificationArrayLength;
                }
                byte[] explicitValue = new byte[modificationArrayLength];
                random.nextBytes(explicitValue);
                vm = new ByteArrayExplicitValueModification(explicitValue);
                return vm;
            }
            case 4: {
                vm = new ByteArrayDuplicateModification();
                return vm;
            }
            case 5: {
                vm = ByteArrayModificationFactory.explicitValueFromFile(random.nextInt(1000));
                return vm;
            }
            case 6: {
                int shuffleSize = random.nextInt(200);
                byte[] shuffle = new byte[shuffleSize];
                random.nextBytes(shuffle);
                vm = ByteArrayModificationFactory.shuffle(shuffle);
                return vm;
            }
        }
        return vm;
    }

    private ByteArrayModificationFactory() {
    }
}

