/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.padding;

import de.rub.nds.tlsattacker.attacks.config.PaddingOracleCommandConfig;
import de.rub.nds.tlsattacker.attacks.padding.ClassicCloseNotifyTraceGenerator;
import de.rub.nds.tlsattacker.attacks.padding.ClassicDynamicPaddingTraceGenerator;
import de.rub.nds.tlsattacker.attacks.padding.ClassicPaddingTraceGenerator;
import de.rub.nds.tlsattacker.attacks.padding.FinishedPaddingTraceGenerator;
import de.rub.nds.tlsattacker.attacks.padding.FinishedResumptionPaddingTraceGenerator;
import de.rub.nds.tlsattacker.attacks.padding.PaddingTraceGenerator;

public class PaddingTraceGeneratorFactory {
    public static PaddingTraceGenerator getPaddingTraceGenerator(PaddingOracleCommandConfig config) {
        switch (config.getVectorGeneratorType()) {
            case CLASSIC: {
                return new ClassicPaddingTraceGenerator(config.getRecordGeneratorType());
            }
            case FINISHED: {
                return new FinishedPaddingTraceGenerator(config.getRecordGeneratorType());
            }
            case FINISHED_RESUMPTION: {
                return new FinishedResumptionPaddingTraceGenerator(config.getRecordGeneratorType());
            }
            case CLOSE_NOTIFY: {
                return new ClassicCloseNotifyTraceGenerator(config.getRecordGeneratorType());
            }
            case CLASSIC_DYNAMIC: {
                return new ClassicDynamicPaddingTraceGenerator(config.getRecordGeneratorType());
            }
        }
        throw new IllegalArgumentException("Unknown PaddingTraceGenerator: " + (Object)((Object)config.getVectorGeneratorType()));
    }

    private PaddingTraceGeneratorFactory() {
    }
}

