/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

final class DisplayNameUtils {
    private static final Logger logger = LoggerFactory.getLogger(DisplayNameUtils.class);
    private static final DisplayNameGenerator standardGenerator = new DisplayNameGenerator.Standard();
    private static final DisplayNameGenerator replaceUnderscoresGenerator = new DisplayNameGenerator.ReplaceUnderscores();

    DisplayNameUtils() {
    }

    static String determineDisplayName(AnnotatedElement element, Supplier<String> displayNameSupplier) {
        Preconditions.notNull((Object)element, (String)"Annotated element must not be null");
        Optional displayNameAnnotation = AnnotationUtils.findAnnotation((AnnotatedElement)element, DisplayName.class);
        if (displayNameAnnotation.isPresent()) {
            String displayName = ((DisplayName)displayNameAnnotation.get()).value().trim();
            if (StringUtils.isBlank((String)displayName)) {
                logger.warn(() -> String.format("Configuration error: @DisplayName on [%s] must be declared with a non-empty value.", element));
            } else {
                return displayName;
            }
        }
        return displayNameSupplier.get();
    }

    static String determineDisplayNameForMethod(Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        DisplayNameGenerator generator = DisplayNameUtils.getDisplayNameGenerator(testClass, configuration);
        return DisplayNameUtils.determineDisplayName(testMethod, () -> generator.generateDisplayNameForMethod(testClass, testMethod));
    }

    static Supplier<String> createDisplayNameSupplierForClass(Class<?> testClass, JupiterConfiguration configuration) {
        return () -> DisplayNameUtils.getDisplayNameGenerator(testClass, configuration).generateDisplayNameForClass(testClass);
    }

    static Supplier<String> createDisplayNameSupplierForNestedClass(Class<?> testClass, JupiterConfiguration configuration) {
        return () -> DisplayNameUtils.getDisplayNameGenerator(testClass, configuration).generateDisplayNameForNestedClass(testClass);
    }

    private static DisplayNameGenerator getDisplayNameGenerator(Class<?> testClass, JupiterConfiguration configuration) {
        Preconditions.notNull(testClass, (String)"Test class must not be null");
        return DisplayNameUtils.getDisplayNameGeneration(testClass).map(DisplayNameGeneration::value).map(displayNameGeneratorClass -> {
            if (displayNameGeneratorClass == DisplayNameGenerator.Standard.class) {
                return standardGenerator;
            }
            if (displayNameGeneratorClass == DisplayNameGenerator.ReplaceUnderscores.class) {
                return replaceUnderscoresGenerator;
            }
            return (DisplayNameGenerator)ReflectionUtils.newInstance((Class)displayNameGeneratorClass, (Object[])new Object[0]);
        }).orElseGet(configuration::getDefaultDisplayNameGenerator);
    }

    private static Optional<DisplayNameGeneration> getDisplayNameGeneration(Class<?> testClass) {
        Class<?> candidate = testClass;
        do {
            Optional generation;
            if (!(generation = AnnotationUtils.findAnnotation(candidate, DisplayNameGeneration.class)).isPresent()) continue;
            return generation;
        } while ((candidate = candidate.getEnclosingClass()) != null);
        return Optional.empty();
    }
}

