// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package main

import (
	"golang.org/x/text/language"
	"golang.org/x/text/message"
	"golang.org/x/text/message/catalog"
)

type dictionary struct {
	index []uint32
	data  string
}

func (d *dictionary) Lookup(key string) (data string, ok bool) {
	p, ok := messageKeyToIndex[key]
	if !ok {
		return "", false
	}
	start, end := d.index[p], d.index[p+1]
	if start == end {
		return "", false
	}
	return d.data[start:end], true
}

func init() {
	dict := map[string]catalog.Dictionary{
		"ca":    &dictionary{index: caIndex, data: caData},
		"cs":    &dictionary{index: csIndex, data: csData},
		"de":    &dictionary{index: deIndex, data: deData},
		"en":    &dictionary{index: enIndex, data: enData},
		"es_ES": &dictionary{index: es_ESIndex, data: es_ESData},
		"fa":    &dictionary{index: faIndex, data: faData},
		"fi":    &dictionary{index: fiIndex, data: fiData},
		"fr":    &dictionary{index: frIndex, data: frData},
		"id":    &dictionary{index: idIndex, data: idData},
		"it":    &dictionary{index: itIndex, data: itData},
		"ja":    &dictionary{index: jaIndex, data: jaData},
		"ko":    &dictionary{index: koIndex, data: koData},
		"pa_IN": &dictionary{index: pa_INIndex, data: pa_INData},
		"pl":    &dictionary{index: plIndex, data: plData},
		"ro":    &dictionary{index: roIndex, data: roData},
		"ru":    &dictionary{index: ruIndex, data: ruData},
		"si_LK": &dictionary{index: si_LKIndex, data: si_LKData},
		"sk":    &dictionary{index: skIndex, data: skData},
		"sl":    &dictionary{index: slIndex, data: slData},
		"tr":    &dictionary{index: trIndex, data: trData},
		"uk":    &dictionary{index: ukIndex, data: ukData},
		"vi":    &dictionary{index: viIndex, data: viData},
		"zh_CN": &dictionary{index: zh_CNIndex, data: zh_CNData},
		"zh_TW": &dictionary{index: zh_TWIndex, data: zh_TWData},
	}
	fallback := language.MustParse("en")
	cat, err := catalog.NewFromMap(dict, catalog.Fallback(fallback))
	if err != nil {
		panic(err)
	}
	message.DefaultCatalog = cat
}

var messageKeyToIndex = map[string]int{
	"%.2f\u00a0GiB":                         20,
	"%.2f\u00a0KiB":                         18,
	"%.2f\u00a0MiB":                         19,
	"%.2f\u00a0TiB":                         21,
	"%d day(s)":                             12,
	"%d hour(s)":                            13,
	"%d minute(s)":                          14,
	"%d second(s)":                          15,
	"%d tunnels were unable to be removed.": 169,
	"%d year(s)":                            11,
	"%d\u00a0B":                             17,
	"%s\n\nPlease consult the log for more information.": 68,
	"%s (out of date)":                69,
	"%s (unsigned build, no updates)": 174,
	"%s - Handshake did not complete after %d attempts, giving up":              234,
	"%s - Handshake did not complete after %d seconds, retrying (try %d)":       235,
	"%s - Removing all keys, since we haven't received a new one in %d seconds": 237,
	"%s - Retrying handshake because we stopped hearing back after %d seconds":  236,
	"%s You cannot undo this action.":                                           165,
	"%s ago":                                                                    16,
	"%s received, %s sent":                                                      95,
	"%s: %q":                                                                    22,
	"%v":                                                                        255,
	"%v - ConsumeMessageInitiation: handshake flood":                            188,
	"%v - ConsumeMessageInitiation: handshake replay @ %v":                      187,
	"%v - Failed to create initiation message: %v":                              220,
	"%v - Failed to create response message: %v":                                223,
	"%v - Failed to derive keypair: %v":                                         209,
	"%v - Failed to send data packet: %v":                                       233,
	"%v - Failed to send handshake initiation: %v":                              221,
	"%v - Failed to send handshake response: %v":                                224,
	"%v - Received handshake initiation":                                        205,
	"%v - Received handshake response":                                          208,
	"%v - Receiving keepalive packet":                                           212,
	"%v - Routine: sequential receiver - started":                               211,
	"%v - Routine: sequential receiver - stopped":                               210,
	"%v - Routine: sequential sender - started":                                 232,
	"%v - Sending handshake initiation":                                         219,
	"%v - Sending handshake response":                                           222,
	"%v - Sending keepalive packet":                                             218,
	"%v - Starting":                                                             189,
	"%v - Stopping":                                                             190,
	"%v - UAPI: Adding allowedip":                                               266,
	"%v - UAPI: Created":                                                        260,
	"%v - UAPI: Removing":                                                       261,
	"%v - UAPI: Removing all allowedips":                                        265,
	"%v - UAPI: Updating endpoint":                                              263,
	"%v - UAPI: Updating persistent keepalive interval":                         264,
	"%v - UAPI: Updating preshared key":                                         262,
	"&About WireGuard…":                                                         66,
	"&Activate":                                                                 45,
	"&Block untunneled traffic (kill-switch)":                                   106,
	"&Configuration:":                                                           109,
	"&Copy":                                                                     60,
	"&Deactivate":                                                               44,
	"&Edit":                                                                     143,
	"&Import tunnel(s) from file…":                                              128,
	"&Manage tunnels…":                                                          127,
	"&Name:":                                                                    103,
	"&Public key:":                                                              104,
	"&Remove selected tunnel(s)":                                                151,
	"&Save":                                                                     107,
	"&Save to file…":                                                            62,
	"&Test experimental kernel driver":                                          269,
	"&Toggle":                                                                   148,
	"&Tunnels":                                                                  130,
	"(no argument): elevate and install manager service":                        1,
	"(unknown)":                                                                 105,
	"A name is required.":                                                       111,
	"A tunnel was unable to be removed: %s":                                     167,
	"About WireGuard":                                                           39,
	"Activating":                                                                120,
	"Active":                                                                    119,
	"Add &empty tunnel…":                                                        144,
	"Add Tunnel":                                                                145,
	"Addresses:":                                                                49,
	"Addresses: %s":                                                             138,
	"Addresses: None":                                                           126,
	"All peers must have public keys":                                           35,
	"Allowed IPs:":                                                              52,
	"An Update is Available!":                                                   139,
	"An interface must have a private key":                                      83,
	"An update to WireGuard is available. It is highly advisable to update without delay.":               71,
	"An update to WireGuard is now available. You are advised to update as soon as possible.":            141,
	"Another tunnel already exists with the name ‘%s’":                                                   155,
	"Another tunnel already exists with the name ‘%s’.":                                                  115,
	"App version: %s\nGo backend version: %s\nGo version: %s-%s\nOperating system: %s\nArchitecture: %s": 268,
	"Are you sure you would like to delete %d tunnels?":                                                  162,
	"Are you sure you would like to delete tunnel ‘%s’?":                                                 164,
	"Bind close failed: %v":                 182,
	"Brackets must contain an IPv6 address": 76,
	"Cancel":                                108,
	"Close":                                 41,
	"Command Line Options":                  3,
	"Config key is missing an equals separator":                            79,
	"Configuration Files (*.zip, *.conf)|*.zip;*.conf|All Files (*.*)|*.*": 170,
	"Configuration ZIP Files (*.zip)|*.zip":                                172,
	"Could not decrypt invalid cookie response":                            200,
	"Could not enumerate existing tunnels: %v":                             154,
	"Could not import selected configuration: %v":                          153,
	"Create new tunnel":                                                    101,
	"DNS servers:":                                                         50,
	"Deactivating":                                                         57,
	"Delete %d tunnels":                                                    161,
	"Delete tunnel ‘%s’":                                                   163,
	"Device closed":                                                        185,
	"Device closing":                                                       184,
	"E&xit":                                                                129,
	"Edit &selected tunnel…":                                               150,
	"Edit tunnel":                                                          102,
	"Enable experimental kernel driver?":                                   270,
	"Endpoint:":                                                            53,
	"Error":                                                                0,
	"Error Exiting WireGuard":                                              70,
	"Error in getting configuration":                                       36,
	"Error: ":                                                              178,
	"Error: %v. Please try again.":                                         73,
	"Export all tunnels to &zip…":                                          149,
	"Export all tunnels to zip":                                            147,
	"Export log to file":                                                   65,
	"Export tunnels to zip":                                                173,
	"Failed to activate tunnel":                                            97,
	"Failed to create cookie reply: %v":                                    226,
	"Failed to deactivate tunnel":                                          98,
	"Failed to decode cookie reply":                                        198,
	"Failed to decode initiation message":                                  203,
	"Failed to decode response message":                                    206,
	"Failed to determine tunnel state":                                     96,
	"Failed to load updated MTU of device: %v":                             239,
	"Failed to read packet from TUN device: %v":                            229,
	"Failed to receive %s packet: %v":                                      193,
	"Failed to write packet to TUN device: %v":                             216,
	"File ‘%s’ already exists.\n\nDo you want to overwrite it?":            118,
	"IPv4 packet with disallowed source address from %v":                   213,
	"IPv6 packet with disallowed source address from %v":                   214,
	"Import tunnel(s) from file":                                           171,
	"Imported %d of %d tunnels":                                            159,
	"Imported %d tunnels":                                                  158,
	"Imported tunnels":                                                     157,
	"Inactive":                                                             56,
	"Interface closed, ignored requested state %s":                         179,
	"Interface down requested":                                             243,
	"Interface state was %s, requested %s, now %s":                         180,
	"Interface up requested":                                               242,
	"Interface: %s":                                                        99,
	"Invalid IP address":                                                   23,
	"Invalid MTU":                                                          27,
	"Invalid endpoint host":                                                26,
	"Invalid key for [Interface] section":                                  81,
	"Invalid key for [Peer] section":                                       82,
	"Invalid key for interface section":                                    84,
	"Invalid key for peer section":                                         86,
	"Invalid key: %v":                                                      30,
	"Invalid name":                                                         110,
	"Invalid network prefix length":                                        24,
	"Invalid packet ended up in the handshake queue":                       202,
	"Invalid persistent keepalive":                                         29,
	"Invalid port":                                                         28,
	"Key must have a value":                                                80,
	"Keys must decode to exactly 32 bytes":                                 77,
	"Latest handshake:":                                                    55,
	"Line must occur in a section":                                         78,
	"Listen port:":                                                         47,
	"Log":                                                                  59,
	"Log message":                                                          64,
	"MTU not updated to negative value: %v":                                240,
	"MTU updated: %v%s":                                                    241,
	"MTU:":                                                                 48,
	"Missing port from endpoint":                                           25,
	"Now":                                                                  9,
	"Number must be a number between 0 and 2^64-1: %v":                     31,
	"Packet with invalid IP version from %v":                               215,
	"Peer":                                                                 100,
	"Persistent keepalive:":                                                54,
	"Please ask the system administrator to update.":                       275,
	"Preshared key:":                                                       51,
	"Protocol version must be 1":                                           85,
	"Public key:":                                                          46,
	"Received invalid initiation message from %s":                          204,
	"Received invalid response message from %s":                            207,
	"Received message with unknown type":                                   194,
	"Received packet with invalid mac1":                                    201,
	"Received packet with unknown IP version":                              230,
	"Receiving cookie response from %s":                                    199,
	"Remove selected tunnel(s)":                                            146,
	"Routine: TUN reader - started":                                        228,
	"Routine: TUN reader - stopped":                                        227,
	"Routine: decryption worker %d - started":                              195,
	"Routine: encryption worker %d - started":                              231,
	"Routine: event worker - started":                                      238,
	"Routine: event worker - stopped":                                      244,
	"Routine: handshake worker %d - started":                               197,
	"Routine: handshake worker %d - stopped":                               196,
	"Routine: receive incoming %s - started":                               192,
	"Routine: receive incoming %s - stopped":                               191,
	"Scripts:":                                                             87,
	"Select &all":                                                          61,
	"Sending cookie response for denied handshake message for %v":          225,
	"Status:":                                      43,
	"Status: %s":                                   137,
	"Status: Complete!":                            74,
	"Status: Unknown":                              125,
	"Status: Waiting for administrator":            276,
	"Status: Waiting for updater service":          177,
	"Status: Waiting for user":                     176,
	"System clock wound backward!":                 10,
	"Table:":                                       272,
	"Text Files (*.txt)|*.txt|All Files (*.*)|*.*": 121,
	"The %s tunnel has been activated.":            132,
	"The %s tunnel has been deactivated.":          134,
	"The WireGuard project is currently testing a high performance kernel driver called WireGuardNT. It will eventually be enabled by default, but for now the project needs testers to try it out. Whether you encounter problems or you find that it works well, please do email team@wireguard.com about your experience.\n\nWould you like to enable the experimental kernel driver?": 271,
	"Time":      63,
	"Transfer:": 88,
	"Trouble determining MTU, assuming default: %v": 183,
	"Tunnel Error":                       67,
	"Tunnel already exists":              114,
	"Tunnel name is not valid":           33,
	"Tunnel name ‘%s’ is invalid.":       112,
	"Tunnels":                            142,
	"Two commas in a row":                32,
	"UAPI: Removing all peers":           259,
	"UAPI: Updating fwmark":              258,
	"UAPI: Updating listen port":         257,
	"UAPI: Updating private key":         256,
	"UDP bind has been updated":          186,
	"Unable to create new configuration": 116,
	"Unable to create tunnel":            160,
	"Unable to delete tunnel":            166,
	"Unable to delete tunnels":           168,
	"Unable to determine whether the process is running under WOW64: %v":                          4,
	"Unable to exit service due to: %v. You may want to stop WireGuard from the service manager.": 175,
	"Unable to flush packets: %v":                       217,
	"Unable to import configuration: %v":                156,
	"Unable to list existing tunnels":                   113,
	"Unable to open current process token: %v":          6,
	"Unable to update bind: %v":                         181,
	"Unable to wait for WireGuard window to appear: %v": 123,
	"Unknown state":                                     58,
	"Update Now":                                        72,
	"Usage: %s [\n%s]":                                  2,
	"When a configuration has exactly one peer, and that peer has an allowed IPs containing at least one of 0.0.0.0/0 or ::/0, and the interface does not have table off, then the tunnel service engages a firewall ruleset to block all traffic that is neither to nor from the tunnel interface or is to the wrong DNS server, with special exceptions for DHCP and NDP.": 274,
	"WireGuard Activated":        131,
	"WireGuard Deactivated":      133,
	"WireGuard Detection Error":  122,
	"WireGuard Tunnel Error":     135,
	"WireGuard Update Available": 140,
	"WireGuard is running, but the UI is only accessible from desktops of the Builtin %s group.": 8,
	"WireGuard logo image": 40,
	"WireGuard may only be used by users who are a member of the Builtin %s group.": 7,
	"WireGuard system tray icon did not appear after 30 seconds.":                   75,
	"WireGuard: %s":          136,
	"WireGuard: Deactivated": 124,
	"Writing file failed":    117,
	"You must use the native version of WireGuard on this computer.": 5,
	"[EnumerationSeparator]":            37,
	"[UnitSeparator]":                   38,
	"[none specified]":                  34,
	"allowed_ip=%s/%d":                  254,
	"disabled, per policy":              93,
	"enabled":                           94,
	"endpoint=%s":                       248,
	"fwmark=%d":                         246,
	"invalid UAPI operation: %v":        267,
	"last_handshake_time_nsec=%d":       250,
	"last_handshake_time_sec=%d":        249,
	"listen_port=%d":                    245,
	"no configuration files were found": 152,
	"off":                               273,
	"persistent_keepalive_interval=%d":  253,
	"post-down":                         92,
	"post-up":                           90,
	"pre-down":                          91,
	"pre-up":                            89,
	"protocol_version=1":                247,
	"rx_bytes=%d":                       252,
	"tx_bytes=%d":                       251,
	"♥ &Donate!":                        42,
}

var caIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000042, 0x00000056,
	0x00000071, 0x000000b0, 0x000000f5, 0x0000012c,
	0x0000018c, 0x00000215, 0x00000219, 0x00000240,
	0x0000025e, 0x0000027c, 0x0000029c, 0x000002be,
	0x000002e0, 0x000002e9, 0x000002f2, 0x000002ff,
	0x0000030c, 0x00000319, 0x00000326, 0x00000333,
	0x00000348, 0x0000036c, 0x00000386, 0x000003a9,
	0x000003b7, 0x000003c5, 0x000003f1, 0x00000407,
	// Entry 20 - 3F
	0x00000435, 0x00000448, 0x00000468, 0x00000479,
	0x000004a8, 0x000004c5, 0x000004c8, 0x000004cb,
	0x000004db, 0x000004ed, 0x000004f3, 0x000004ff,
	0x00000506, 0x00000511, 0x00000519, 0x00000528,
	0x00000538, 0x0000053d, 0x00000546, 0x00000555,
	0x00000569, 0x00000577, 0x0000057f, 0x0000059a,
	0x000005ac, 0x000005b4, 0x000005c0, 0x000005d1,
	0x000005da, 0x000005e1, 0x000005f3, 0x00000607,
	// Entry 40 - 5F
	0x0000060d, 0x00000622, 0x0000063c, 0x00000650,
	0x00000660, 0x0000069f, 0x000006b6, 0x000006d3,
	0x0000072d, 0x0000073c, 0x0000076a, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	// Entry 60 - 7F
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	// Entry 80 - 9F
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	// Entry A0 - BF
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	// Entry C0 - DF
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	// Entry E0 - FF
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	// Entry 100 - 11F
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c, 0x0000077c, 0x0000077c,
	0x0000077c, 0x0000077c,
} // Size: 1136 bytes

const caData string = "" + // Size: 1916 bytes
	"\x02Error\x02(sense argument): eleva i instala el servei d'administrador" +
	"\x02Ús: %[1]s [\x0a%[2]s]\x02Opcions de línia d'ordres\x02No s'ha pogut " +
	"determinar si el procés corre sota WOW64: %[1]v\x02Heu de fer servir la " +
	"versio nativa de WireGuard en aquest ordinador.\x02No s'ha pogut obrir e" +
	"l token del procés actual: %[1]v\x02WireGuard només es pot fer servir pe" +
	"r els usuaris que són membres del grup del sistema %[1]s.\x02WireGuard s" +
	"'està executsnt, pero la interfície gràfica només és accessible als usua" +
	"ris que són membres del grup del sistema %[1]s.\x02Ara\x02El rellotge de" +
	"l sistema s'ha atraçat!\x14\x01\x81\x01\x00\x02\x0a\x02%[1]d any\x00\x0b" +
	"\x02%[1]d anys\x14\x01\x81\x01\x00\x02\x0a\x02%[1]d dia\x00\x0b\x02%[1]d" +
	" dies\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d hora\x00\x0c\x02%[1]d hores" +
	"\x14\x01\x81\x01\x00\x02\x0c\x02%[1]d minut\x00\x0d\x02%[1]d minuts\x14" +
	"\x01\x81\x01\x00\x02\x0c\x02%[1]d segon\x00\x0d\x02%[1]d segons\x02Fa %[" +
	"1]s\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f" +
	"\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Adreça IP invàlida\x02T" +
	"amany del prefix de xarxa invàlid\x02Falta el port de l'extrem\x02El for" +
	"mat de l'extrem no és valid\x02MTU invàlida\x02Port invàlid\x02Temps de " +
	"missatge de persistència invàlid\x02Clau invàlida: %[1]v\x02El nombre ha" +
	" de estar entre 0 i 2^64-1: %[1]v\x02Dos comes seguides\x02El nom del tú" +
	"nel no és vàlid\x02[no especificat]\x02Tots els parells han de tenir cla" +
	"us públiques\x02Error obtenint configuració\x02, \x02, \x02Sobre WireGua" +
	"rd\x02Logo de WireGuard\x02Tanca\x02♥ & Dona!\x02Estat:\x02&Desactiva" +
	"\x02&Activa\x02Clau pública:\x02Port d'escolta:\x02MTU:\x02Adreces:\x02S" +
	"ervidors DNS:\x02Clau precompartida:\x02IPs permeses:\x02Extrem:\x02Miss" +
	"atge de persistència:\x02Últim handshake:\x02Inactiu\x02Desactivant\x02E" +
	"stat desconegut\x02Registre\x02&Copia\x02Selecciona-ho tot\x02Desa en un" +
	" arxiu…\x02Temps\x02Missatge de registre\x02Exporta registre a fitxer" +
	"\x02&Sobre WireGuard…\x02Error de túnel\x02%[1]s\x0a\x0aSi us plau, cons" +
	"ulteu el registre per més informació.\x02%[1]s (desactualitzat)\x02Error" +
	" al sortir de WireGuard\x02Una actualització per WireGuard està disponib" +
	"le. Es recomana actualitzar immediatament.\x02Actualitza ara\x02Error: %" +
	"[1]v. Si us plau, torneu-ho a provar.\x02Estat: Completat!"

var csIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x0000004f, 0x00000069,
	0x0000008a, 0x000000bd, 0x00000106, 0x00000138,
	0x00000193, 0x00000201, 0x00000206, 0x0000022f,
	0x00000265, 0x0000029b, 0x000002da, 0x00000319,
	0x0000035c, 0x00000368, 0x00000371, 0x0000037e,
	0x0000038b, 0x00000398, 0x000003a5, 0x000003b2,
	0x000003c6, 0x000003eb, 0x00000401, 0x00000414,
	0x00000422, 0x00000431, 0x00000453, 0x0000046b,
	// Entry 20 - 3F
	0x0000049d, 0x000004b3, 0x000004ce, 0x000004e5,
	0x00000512, 0x00000536, 0x00000539, 0x0000053c,
	0x00000551, 0x00000569, 0x00000572, 0x00000580,
	0x00000586, 0x00000593, 0x0000059e, 0x000005b0,
	0x000005c8, 0x000005cd, 0x000005d5, 0x000005e2,
	0x000005f9, 0x00000607, 0x00000611, 0x00000627,
	0x0000063c, 0x00000647, 0x00000652, 0x00000661,
	0x0000066a, 0x00000676, 0x00000683, 0x0000069a,
	// Entry 40 - 5F
	0x0000069f, 0x000006ac, 0x000006ca, 0x000006e3,
	0x000006f0, 0x0000072b, 0x00000740, 0x0000076c,
	0x000007d5, 0x000007e8, 0x00000807, 0x00000819,
	0x00000865, 0x0000088a, 0x000008c0, 0x000008e5,
	0x00000925, 0x0000093f, 0x00000966, 0x00000988,
	0x000009b3, 0x000009d8, 0x000009f5, 0x00000a13,
	0x00000a1c, 0x00000a25, 0x00000a35, 0x00000a41,
	0x00000a51, 0x00000a5d, 0x00000a73, 0x00000a7b,
	// Entry 60 - 7F
	0x00000a9b, 0x00000abe, 0x00000add, 0x00000afe,
	0x00000b0f, 0x00000b14, 0x00000b2a, 0x00000b38,
	0x00000b41, 0x00000b54, 0x00000b60, 0x00000b8d,
	0x00000b96, 0x00000b9e, 0x00000bab, 0x00000bbc,
	0x00000bd0, 0x00000bf4, 0x00000c20, 0x00000c34,
	0x00000c5b, 0x00000c86, 0x00000ca2, 0x00000cd6,
	0x00000cdf, 0x00000ce8, 0x00000d22, 0x00000d3f,
	0x00000d70, 0x00000d88, 0x00000d98, 0x00000da9,
	// Entry 80 - 9F
	0x00000dbd, 0x00000de0, 0x00000dea, 0x00000df2,
	0x00000e07, 0x00000e23, 0x00000e3a, 0x00000e58,
	0x00000e6f, 0x00000e80, 0x00000e8c, 0x00000e9a,
	0x00000eb6, 0x00000edb, 0x00000f3d, 0x00000f44,
	0x00000f4d, 0x00000f69, 0x00000f77, 0x00000f91,
	0x00000fb3, 0x00000fbe, 0x00000fe4, 0x00000fff,
	0x0000101a, 0x0000104a, 0x00001077, 0x000010ac,
	0x000010d2, 0x000010f6, 0x0000110a, 0x0000117f,
	// Entry A0 - BF
	0x00001214, 0x0000122a, 0x00001294, 0x0000133e,
	0x00001356, 0x0000137e, 0x000013a3, 0x000013b9,
	0x000013df, 0x000013f6, 0x000014a0, 0x000014ee,
	0x0000150d, 0x00001534, 0x0000154d, 0x0000157e,
	0x000015d8, 0x000015f6, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	// Entry C0 - DF
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	// Entry E0 - FF
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	// Entry 100 - 11F
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e, 0x0000161e, 0x0000161e,
	0x0000161e, 0x0000161e,
} // Size: 1136 bytes

const csData string = "" + // Size: 5662 bytes
	"\x02Chyba\x02(žádný argument): Zvýšit oprávnění a instalovat službu sprá" +
	"vce\x02Použití: %[1]s [\x0a%[2]s]\x02Možnosti příkazového řádku\x02Nelze" +
	" zjistit, zda proces běží pod WOW64: %[1]v\x02Musíte použít nativní verz" +
	"i aplikace WireGuard na tomto počítači.\x02Nelze otevřít token aktuálníh" +
	"o procesu: %[1]v\x02WireGuard můžou používat pouze uživatelé, kteří jsou" +
	" členy Builtin skupiny %[1]s.\x02WireGuard je spuštěn, ale uživatelské r" +
	"ozhraní je přístupné pouze uživatelům Builtin skupiny %[1]s.\x02Teď\x02S" +
	"ystémové hodiny byly posunuty dozadu!\x14\x01\x81\x01\x00\x04\x0b\x02%[1" +
	"]d roky\x05\x0a\x02%[1]d let\x02\x0a\x02%[1]d rok\x00\x0a\x02%[1]d let" +
	"\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d dny\x05\x0b\x02%[1]d dnů\x02\x0a" +
	"\x02%[1]d den\x00\x0a\x02%[1]d dny\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d " +
	"hodiny\x05\x0c\x02%[1]d hodin\x02\x0d\x02%[1]d hodina\x00\x0c\x02%[1]d h" +
	"odin\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d minuty\x05\x0c\x02%[1]d minut" +
	"\x02\x0d\x02%[1]d minuta\x00\x0c\x02%[1]d minut\x14\x01\x81\x01\x00\x04" +
	"\x0e\x02%[1]d sekundy\x05\x0d\x02%[1]d sekund\x02\x0e\x02%[1]d sekunda" +
	"\x00\x0d\x02%[1]d sekund\x02před %[1]s\x02%[1]d\u00a0B\x02%.2[1]f\u00a0K" +
	"iB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s:" +
	" %[2]q\x02Neplatná IP adresa\x02Neplatná délka síťového prefixu\x02Endpo" +
	"intu chybí port\x02Neplatný endpoint\x02Neplatné MTU\x02Neplatný port" +
	"\x02Neplatný persistentní keepalive\x02Neplatný klíč: %[1]v\x02Číslo mus" +
	"í mít hodnotu mezi 0 a 2^64-1: %[1]v\x02Dvě čárky za sebou\x02Název tun" +
	"elu je neplatný\x02[není specifikováno]\x02Všichni peeři musí mít veřejn" +
	"é klíče\x02Chyba při načítání konfigurace\x02, \x02, \x02O aplikaci Wir" +
	"eGuard\x02Obrázek loga WireGuard\x02Zavřít\x02♥ &Darovat!\x02Stav:\x02&D" +
	"eaktivovat\x02&Aktivovat\x02Veřejný klíč:\x02Port pro naslouchání:\x02MT" +
	"U:\x02Adresy:\x02DNS servery:\x02Předsdílený klíč:\x02Povolené IP:\x02En" +
	"dpoint:\x02Persistent keepalive:\x02Poslední handshake:\x02Neaktivní\x02" +
	"Deaktivuji\x02Neznámý stav\x02Záznamy\x02&Kopírovat\x02Vybr&at vše\x02&U" +
	"ložit do souboru…\x02Čas\x02Zpráva logu\x02Exportovat záznam do souboru" +
	"\x02&O aplikaci WireGuard…\x02Chyba tunelu\x02%[1]s\x0a\x0aPro více info" +
	"rmací se prosím podívejte do logu.\x02%[1]s (neaktuální)\x02Chyba při uk" +
	"ončování aplikace WireGuard\x02Aktualizace aplikace WireGuard je nyní k " +
	"dispozici. Silně doporučujeme ji aktualizovat co nejdříve.\x02Aktualizov" +
	"at nyní\x02Chyba: %[1]v. Zkuste to znovu.\x02Stav: Dokončeno!\x02Ikona W" +
	"ireGuard se ani po 30 sekundách nezobrazila na systémové liště.\x02Závor" +
	"ky musí obsahovat IPv6 adresu\x02Klíče musí být dekódovány přesně na 32 " +
	"bajtů\x02Řádek musí být v některé sekci\x02Konfigurační klíč neobsahuje " +
	"oddělovač (znak 'rovná se')\x02Klíč musí mít hodnotu\x02Neplatný klíč pr" +
	"o sekci [Interface]\x02Neplatný klíč pro sekci [Peer]\x02Rozhraní musí o" +
	"bsahovat soukromý klíč\x02Neplatný klíč pro sekci rozhraní\x02Verze prot" +
	"okolu musí být 1\x02Neplatný klíč v sekci peer\x02Skripty:\x02Přenos:" +
	"\x02před-zapnutím\x02po-zapnutí\x02před-vypnutím\x02po-vypnutí\x02vypnut" +
	"o, podle zásad\x02zapnuto\x02%[1]s přijato, %[2]s odesláno\x02Nepodařilo" +
	" se zjistit stav tunelu\x02Nepodařilo se aktivovat tunel\x02Nepodařilo s" +
	"e deaktivovat tunel\x02Rozhraní: %[1]s\x02Peer\x02Vytvořit nový tunel" +
	"\x02Upravit tunel\x02&Název:\x02&Veřejný klíč:\x02(neznámý)\x02&Blokovat" +
	" netunelovaný provoz (kill-switch)\x02&Uložit\x02Zrušit\x02&Nastavení:" +
	"\x02Neplatný název\x02Název je povinný.\x02Název tunelu '%[1]s' je nepla" +
	"tný.\x02Nepodařilo se zobrazit existující tunely\x02Tunel již existuje" +
	"\x02Tunel s názvem '%[1]s' již existuje.\x02Nepodařilo se vytvořit novou" +
	" konfiguraci\x02Zápis souboru se nezdařil\x02Soubor \x22%[1]s\x22 již ex" +
	"istuje.\x0a\x0aChcete jej přepsat?\x02Aktivní\x02Aktivuji\x02Textové sou" +
	"bory (*.txt)|*.txt|Všechny soubory (*.*)|*.*\x02Chyba při detekci WireGu" +
	"ard\x02Nelze čekat na zobrazení okna WireGuard: %[1]v\x02WireGuard: Deak" +
	"tivován\x02Stav: Neznámý\x02Adresy: žádné\x02Spravovat tunely…\x02&Impor" +
	"tovat tunel(y) ze souboru…\x02U&končit\x02&Tunely\x02WireGuard aktivován" +
	"\x02Tunel %[1]s byl aktivován.\x02WireGuard deaktivován\x02Tunel %[1]s b" +
	"yl deaktivován.\x02WireGuard Chyba Tunelu\x02WireGuard: %[1]s\x02Stav: %" +
	"[1]s\x02Adresy: %[1]s\x02Aktualizace je k dispozici!\x02Aktualizace Wire" +
	"Guard je k dispozici\x02Aktualizace aplikace WireGuard je nyní k dispozi" +
	"ci. Doporučujeme ji aktualizovat co nejdříve.\x02Tunely\x02&Upravit\x02P" +
	"řidat &prázdný tunel…\x02Přidat tunel\x02Odstranit vybrané tunely\x02Ex" +
	"portovat všechny tunely do zip\x02&Přepnout\x02Exportovat všechny tunely" +
	" do &zip…\x02Upravit &vybraný tunel…\x02&Odstranit vybrané tunely\x02neb" +
	"yly nalezeny žádné konfigurační soubory\x02Nelze importovat vybranou kon" +
	"figuraci: %[1]v\x02Nepodařilo se vyjmenovat existující tunely: %[1]v\x02" +
	"Tunel s názvem '%[1]s' již existuje\x02Nelze importovat konfiguraci: %[1" +
	"]v\x02Importované tunely\x14\x01\x81\x01\x00\x04\x1a\x02Importovány %[1]" +
	"d tunely\x05\x1b\x02Importováno %[1]d tunelů\x02\x18\x02Importován %[1]d" +
	" tunel\x00\x1b\x02Importováno %[1]d tunelů\x14\x02\x80\x01\x04#\x02Impor" +
	"továno %[1]d z %[2]d tunelů\x05#\x02Importováno %[1]d z %[2]d tunelů\x02" +
	" \x02Importován %[1]d z %[2]d tunel\x00#\x02Importováno %[1]d z %[2]d tu" +
	"nelů\x02Nelze vytvořit tunel\x14\x01\x81\x01\x00\x04\x17\x02Odstranit %[" +
	"1]d tunely\x05\x18\x02Odstranit %[1]d tunelů\x02\x16\x02Odstranit %[1]d " +
	"tunel\x00\x18\x02Odstranit %[1]d tunelů\x14\x01\x81\x01\x00\x04'\x02Opra" +
	"vdu chcete odstranit %[1]d tunely?\x05(\x02Opravdu chcete odstranit %[1]" +
	"d tunelů?\x02&\x02Opravdu chcete odstranit %[1]d tunel?\x00(\x02Opravdu " +
	"chcete odstranit %[1]d tunelů?\x02Odstranit tunel \x22%[1]s\x22\x02Oprav" +
	"du chcete odstranit tunel \x22%[1]s\x22?\x02%[1]s Tuto akci nelze vrátit" +
	" zpět.\x02Nelze odstranit tunel\x02Tunel nebylo možné odstranit: %[1]s" +
	"\x02Nelze odstranit tunely\x14\x01\x81\x01\x00\x04'\x02%[1]d tunely neby" +
	"lo možné odstranit.\x05(\x02%[1]d tunelů nebylo možné odstranit.\x02&" +
	"\x02%[1]d tunel nebylo možné odstranit.\x00(\x02%[1]d tunelů nebylo možn" +
	"é odstranit.\x02Konfigurace souborů (*.zip, *.conf)|*.zip; *.conf|Všech" +
	"ny soubory (*.*)|*.*\x02Importovat tunel(y) ze souboru\x02Konfigurace so" +
	"uborů ZIP (*.zip)|*.zip\x02Exportovat tunely do zip\x02%[1]s (nepodepsan" +
	"á verze, žádné aktualizace)\x02Nelze ukončit službu z důvodu: %[1]v. Wi" +
	"reGuard můžete zastavit ve správci služeb.\x02Stav: Čekání na uživatele" +
	"\x02Stav: Čeká se na službu aktualizací"

var deIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000059, 0x00000074,
	0x0000008b, 0x000000e1, 0x00000137, 0x0000016b,
	0x000001c2, 0x0000023a, 0x00000240, 0x00000266,
	0x00000286, 0x000002a4, 0x000002c8, 0x000002ec,
	0x00000312, 0x0000031c, 0x00000325, 0x00000332,
	0x0000033f, 0x0000034c, 0x00000359, 0x00000366,
	0x0000037c, 0x000003a4, 0x000003c2, 0x000003dc,
	0x000003eb, 0x000003fc, 0x0000041c, 0x0000043a,
	// Entry 20 - 3F
	0x00000466, 0x00000482, 0x0000049f, 0x000004b4,
	0x000004f2, 0x00000518, 0x0000051b, 0x0000051e,
	0x0000052e, 0x0000053d, 0x00000548, 0x00000556,
	0x0000055e, 0x0000056c, 0x00000578, 0x00000592,
	0x000005a0, 0x000005a5, 0x000005af, 0x000005bb,
	0x000005d1, 0x000005df, 0x000005e9, 0x000005fe,
	0x00000618, 0x00000620, 0x0000062c, 0x00000640,
	0x0000064a, 0x00000654, 0x00000665, 0x0000067c,
	// Entry 40 - 5F
	0x00000681, 0x00000692, 0x000006b0, 0x000006c4,
	0x000006d2, 0x00000713, 0x00000724, 0x00000746,
	0x000007b4, 0x000007c8, 0x000007f6, 0x00000806,
	0x00000856, 0x0000088a, 0x000008c1, 0x000008f2,
	0x0000092d, 0x0000094b, 0x00000979, 0x000009a1,
	0x000009db, 0x00000a08, 0x00000a29, 0x00000a51,
	0x00000a5a, 0x00000a67, 0x00000a7a, 0x00000a91,
	0x00000aa6, 0x00000abc, 0x00000ad8, 0x00000ae2,
	// Entry 60 - 7F
	0x00000b02, 0x00000b2d, 0x00000b52, 0x00000b79,
	0x00000b8e, 0x00000b99, 0x00000bb6, 0x00000bc8,
	0x00000bcf, 0x00000bea, 0x00000bf6, 0x00000c2a,
	0x00000c35, 0x00000c3f, 0x00000c4f, 0x00000c60,
	0x00000c78, 0x00000c9c, 0x00000ccf, 0x00000ce8,
	0x00000d20, 0x00000d4e, 0x00000d6e, 0x00000db3,
	0x00000db9, 0x00000dc3, 0x00000df4, 0x00000e0f,
	0x00000e57, 0x00000e6e, 0x00000e80, 0x00000e90,
	// Entry 80 - 9F
	0x00000ea5, 0x00000ec6, 0x00000ecf, 0x00000ed7,
	0x00000eeb, 0x00000f0d, 0x00000f23, 0x00000f47,
	0x00000f5f, 0x00000f70, 0x00000f7e, 0x00000f8e,
	0x00000fb2, 0x00000fd6, 0x00001049, 0x00001050,
	0x0000105c, 0x00001080, 0x00001093, 0x000010b1,
	0x000010db, 0x000010e7, 0x0000110c, 0x00001130,
	0x00001151, 0x00001176, 0x000011b7, 0x000011e9,
	0x00001223, 0x00001257, 0x00001269, 0x000012a2,
	// Entry A0 - BF
	0x000012ee, 0x0000130e, 0x00001343, 0x000013b3,
	0x000013cf, 0x00001406, 0x00001443, 0x00001462,
	0x00001492, 0x000014b8, 0x00001519, 0x00001563,
	0x0000157f, 0x000015a8, 0x000015c7, 0x000015f2,
	0x0000165e, 0x00001678, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	// Entry C0 - DF
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	// Entry E0 - FF
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	// Entry 100 - 11F
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1, 0x000016a1, 0x000016a1,
	0x000016a1, 0x000016a1,
} // Size: 1136 bytes

const deData string = "" + // Size: 5793 bytes
	"\x02Fehler\x02(kein Argument): Als Administrator ausführen und den Manag" +
	"er-Dienst installieren\x02Verwendung: %[1]s [\x0a%[2]s]\x02Kommandozeile" +
	"noptionen\x02Es kann nicht festgestellt werden, ob der Prozess unter WOW" +
	"64 ausgeführt wird: %[1]v\x02Sie müssen die Version von Wireguard benutz" +
	"en, die für ihren Computer bestimmt ist.\x02Konnte aktuellen Prozess-Tok" +
	"en nicht öffnen: %[1]v\x02WireGuard kann nur von Benutzern verwendet wer" +
	"den, die Mitglied der Gruppe %[1]s sind.\x02WireGuard wird ausgeführt, a" +
	"ber auf die Benutzeroberfläche kann nur von Desktops der Gruppe %[1]s zu" +
	"gegriffen werden.\x02Jetzt\x02Die Systemuhr wurde zurück gestellt!\x14" +
	"\x01\x81\x01\x00\x02\x0b\x02%[1]d Jahr\x00\x0c\x02%[1]d Jahre\x14\x01" +
	"\x81\x01\x00\x02\x0a\x02%[1]d Tag\x00\x0b\x02%[1]d Tage\x14\x01\x81\x01" +
	"\x00\x02\x0d\x02%[1]d Stunde\x00\x0e\x02%[1]d Stunden\x14\x01\x81\x01" +
	"\x00\x02\x0d\x02%[1]d Minute\x00\x0e\x02%[1]d Minuten\x14\x01\x81\x01" +
	"\x00\x02\x0e\x02%[1]d Sekunde\x00\x0f\x02%[1]d Sekunden\x02vor %[1]s\x02" +
	"%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB" +
	"\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Ungültige IP-Adresse\x02Ungültig" +
	"e Länge des Netzwerkpräfixes\x02Fehlender Port des Endpunktes\x02Ungülti" +
	"ger Endpunkt-Host\x02Ungültige MTU\x02Ungültiger Port\x02Ungültiges Erha" +
	"ltungsintervall\x02Ungültiger Schlüssel: %[1]v\x02Zahl muss zwischen 0 u" +
	"nd 2^64-1 sein: %[1]v\x02Zwei Kommata in einer Zeile\x02Der Tunnelname i" +
	"st ungültig\x02[nicht spezifiziert]\x02Alle Teilnehmer (peers) müssen öf" +
	"fentliche Schlüssel haben\x02Fehler beim Abrufen der Konfiguration\x02, " +
	"\x02, \x02Über WireGuard\x02WireGuard Logo\x02Schließen\x02♥ &Spenden!" +
	"\x02Status:\x02&Deaktivieren\x02&Aktivieren\x02Öffentlicher Schlüssel:" +
	"\x02Eingangsport:\x02MTU:\x02Adressen:\x02DNS-Server:\x02Geteilter Schlü" +
	"ssel:\x02Erlaubte IPs:\x02Endpunkt:\x02Erhaltungsintervall:\x02Letzter S" +
	"chlüsseltausch:\x02Inaktiv\x02Deaktiviere\x02Unbekannter Zustand\x02Prot" +
	"okoll\x02&Kopieren\x02&Alles markieren\x02&In Datei Speichern…\x02Zeit" +
	"\x02Protokolleintrag\x02Exportiere Protokoll in Datei\x02&Über WireGuard" +
	"…\x02Tunnel Fehler\x02%[1]s\x0a\x0aBitte lesen Sie das Protokoll für w" +
	"eitere Informationen.\x02%[1]s (veraltet)\x02Fehler beim Beenden von Wir" +
	"eGuard\x02Eine Aktualisierung für WireGuard ist verfügbar. Es ist höchst" +
	" empfehlenswert diese sofort durchzuführen.\x02Jetzt aktualisieren\x02Fe" +
	"hler: %[1]v. Bitte versuchen Sie es erneut.\x02Status: Fertig!\x02Das Wi" +
	"reGuard-Taskleistensymbol ist nicht innerhalb von 30 Sekunden erschienen" +
	".\x02Eckige Klammern müssen eine IPv6 Adresse enthalten\x02Schlüssel müs" +
	"sen auf exakt 32 Bytes dekodiert werden\x02Die Zeile muss innerhalb eine" +
	"s Abschnitts stehen\x02Konfigurationsschlüssel fehlt ein Gleichheitstren" +
	"nzeichen\x02Eintrag muss einen Wert haben\x02Ungültiger Eintrage im [Int" +
	"erface] Abschnitt\x02Ungültiger Eintrag im [Peer] Abschnitt\x02Eine Schn" +
	"ittstelle muss einen privaten Schlssel enthalten\x02Ungültiger Eintrag i" +
	"m Abschnitt [interface]\x02Die Protokollversion muss 1 sein\x02Ungültige" +
	"r Eintrag im Abschnitt [peer]\x02Skripte:\x02Übertragen:\x02vor Verbinds" +
	"aufbau\x02nach Verbindungsaufbau\x02vor Verbindungsabbau\x02nach Verbind" +
	"ungsabbau\x02deaktiviert, per Richtlinie\x02aktiviert\x02%[1]s empfangen" +
	", %[2]s gesendet\x02Tunnelstatus konnte nicht ermittelt werden\x02Tunnel" +
	" aktivieren ist fehlgeschlagen\x02Tunnel deaktivieren ist fehlgeschlagen" +
	"\x02Schnittstelle: %[1]s\x02Teilnehmer\x02Einen neuen Tunnel erstellen" +
	"\x02Tunnel bearbeiten\x02&Name:\x02&Öffentlicher Schlüssel:\x02(unbekann" +
	"t)\x02&Blockiere Verkehr außerhalb des Tunnels (Not-Aus)\x02&Speichern" +
	"\x02Abbrechen\x02&Konfiguration:\x02Ungültiger Name\x02Ein Name ist notw" +
	"endig.\x02Der Name „%[1]s“ ist ungültig.\x02Vorhandene Tunnel können nic" +
	"ht aufgelistet werden\x02Tunnel existiert bereits\x02Ein Tunnel mit dem " +
	"Namen „%[1]s“ existiert bereits.\x02Neue Konfiguration kann nicht erstel" +
	"lt werden\x02Schreiben der Datei schlug fehl\x02Die Datei „%[1]s“ existi" +
	"ert bereits.\x0a\x0aMöchten Sie sie ersetzen?\x02Aktiv\x02Aktiviere\x02T" +
	"extdateien (*.txt)|*.txt|Alle Dateien (*.*)|*.*\x02WireGuard Erkennungsf" +
	"ehler\x02Warten auf das Erscheinen des WireGuard Fensters nicht möglich:" +
	" %[1]v \x02WireGuard: Deaktiviert\x02Status: Unbekannt\x02Adressen: Kein" +
	"e\x02Tunnel &verwalten…\x02Tunnel aus Datei &importieren…\x02&Beenden" +
	"\x02&Tunnel\x02WireGuard aktiviert\x02Der Tunnel %[1]s wurde aktiviert." +
	"\x02WireGuard deaktiviert\x02Der Tunnel %[1]s wurde deaktiviert.\x02Wire" +
	"Guard Tunnel Fehler\x02WireGuard: %[1]s\x02Status: %[1]s\x02Adressen: %[" +
	"1]s\x02Eine Aktualisierung ist verfügbar!\x02WireGuard Aktualisierung ve" +
	"rfügbar\x02Eine Aktualisierung für WireGuard ist jetzt verfügbar. Es wir" +
	"d empfohlen diese schnellstmöglich durchzuführen.\x02Tunnel\x02&Bearbeit" +
	"en\x02Einen &leeren Tunnel hinzufügen…\x02Tunnel hinzufügen\x02Markierte" +
	"(n) Tunnel entfernen\x02Alle Tunnel in eine Zip-Datei exportieren\x02&Um" +
	"schalten\x02Exportiere alle Tunnel in &Zip-Datei\x02Ausgewählten Tunnel " +
	"&bearbeiten…\x02Ausgewählte(n) Tunnel &löschen\x02keine Konfigurationsda" +
	"teien gefunden\x02Ausgewählte Konfiguration konnte nicht importiert werd" +
	"en: %[1]v\x02Konnte existierende Tunnel nicht auflisten: %[1]v\x02Es exi" +
	"stiert bereits ein Tunnel mit dem Namen „%[1]s“\x02Importieren der Konfi" +
	"guration nicht möglich: %[1]v\x02Tunnel importiert\x14\x01\x81\x01\x00" +
	"\x02\x18\x02%[1]d Tunnel importiert\x00\x18\x02%[1]d Tunnel importiert" +
	"\x14\x02\x80\x01\x02\x22\x02%[1]d von %[2]d Tunnel importiert\x00\x22" +
	"\x02%[1]d von %[2]d Tunnel importiert\x02Tunnel erstellen nicht möglich" +
	"\x14\x01\x81\x01\x00\x02\x16\x02%[1]d Tunnel löschen\x00\x16\x02%[1]d Tu" +
	"nnel löschen\x14\x01\x81\x01\x00\x024\x02Möchten Sie diesen %[1]d Tunnel" +
	" wirklich löschen?\x003\x02Möchten Sie diese %[1]d Tunnel wirklich lösch" +
	"en?\x02Tunnel „%[1]s“ löschen\x02Möchten Sie den Tunnel „%[1]s“ wirklich" +
	" löschen?\x02%[1]s Dieser Schritt kann nicht rückgängig gemacht werden." +
	"\x02Tunnel löschen nicht möglich\x02Ein Tunnel konnte nicht gelöscht wer" +
	"den: %[1]s\x02Tunnel konnten nicht gelöscht werden\x14\x01\x81\x01\x00" +
	"\x02+\x02%[1]d Tunnel konnte nicht entfernt werden.\x00-\x02%[1]d Tunnel" +
	" konnten nicht gelöscht werden.\x02Konfigurationsdateien (*.zip, *.conf)" +
	"|*.zip;*.conf|Alle Dateien (*.*)|*.*\x02Importiere Tunnel aus Datei\x02K" +
	"onfigurations-ZIP-Dateien (*.zip)|*.zip\x02Exportiere Tunnel in Zip-Date" +
	"i\x02%[1]s (unsigniert, keine Aktualisierungen)\x02Der Dienst konnte nic" +
	"ht gestoppt werden: %[1]v. Versuchen Sie WireGuard in der Dienstverwaltu" +
	"ng zu beenden.\x02Status: Auf Nutzer warten\x02Status: Auf Aktualisierun" +
	"gsdienst warten"

var enIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000039, 0x0000004f,
	0x00000064, 0x000000aa, 0x000000e9, 0x00000115,
	0x00000166, 0x000001c4, 0x000001c8, 0x000001e5,
	0x00000205, 0x00000223, 0x00000243, 0x00000267,
	0x0000028b, 0x00000295, 0x0000029e, 0x000002ab,
	0x000002b8, 0x000002c5, 0x000002d2, 0x000002df,
	0x000002f2, 0x00000310, 0x0000032b, 0x00000341,
	0x0000034d, 0x0000035a, 0x00000377, 0x0000038a,
	// Entry 20 - 3F
	0x000003be, 0x000003d2, 0x000003eb, 0x000003fc,
	0x0000041c, 0x0000043b, 0x0000043e, 0x00000441,
	0x00000451, 0x00000466, 0x0000046c, 0x00000479,
	0x00000481, 0x0000048d, 0x00000497, 0x000004a3,
	0x000004b0, 0x000004b5, 0x000004c0, 0x000004cd,
	0x000004dc, 0x000004e9, 0x000004f3, 0x00000509,
	0x0000051b, 0x00000524, 0x00000531, 0x0000053f,
	0x00000543, 0x00000549, 0x00000555, 0x00000566,
	// Entry 40 - 5F
	0x0000056b, 0x00000577, 0x0000058a, 0x0000059e,
	0x000005ab, 0x000005df, 0x000005f3, 0x0000060b,
	0x00000660, 0x0000066b, 0x0000068b, 0x0000069d,
	0x000006d9, 0x000006ff, 0x00000724, 0x00000741,
	0x0000076b, 0x00000781, 0x000007a5, 0x000007c4,
	0x000007e9, 0x0000080b, 0x00000826, 0x00000843,
	0x0000084c, 0x00000856, 0x0000085d, 0x00000865,
	0x0000086e, 0x00000878, 0x0000088d, 0x00000895,
	// Entry 60 - 7F
	0x000008b0, 0x000008d1, 0x000008eb, 0x00000907,
	0x00000918, 0x0000091d, 0x0000092f, 0x0000093b,
	0x00000942, 0x0000094f, 0x00000959, 0x00000981,
	0x00000987, 0x0000098e, 0x0000099e, 0x000009ab,
	0x000009bf, 0x000009e3, 0x00000a03, 0x00000a19,
	0x00000a52, 0x00000a75, 0x00000a89, 0x00000ac8,
	0x00000acf, 0x00000ada, 0x00000b07, 0x00000b21,
	0x00000b56, 0x00000b6d, 0x00000b7d, 0x00000b8d,
	// Entry 80 - 9F
	0x00000ba0, 0x00000bbf, 0x00000bc5, 0x00000bce,
	0x00000be2, 0x00000c07, 0x00000c1d, 0x00000c44,
	0x00000c5b, 0x00000c6c, 0x00000c7a, 0x00000c8b,
	0x00000ca3, 0x00000cbe, 0x00000d16, 0x00000d1e,
	0x00000d24, 0x00000d39, 0x00000d44, 0x00000d5e,
	0x00000d78, 0x00000d80, 0x00000d9e, 0x00000db7,
	0x00000dd2, 0x00000df4, 0x00000e23, 0x00000e4f,
	0x00000e87, 0x00000ead, 0x00000ebe, 0x00000ef4,
	// Entry A0 - BF
	0x00000f3b, 0x00000f53, 0x00000f85, 0x00000ff7,
	0x00001011, 0x0000104b, 0x0000106e, 0x00001086,
	0x000010af, 0x000010c8, 0x00001121, 0x00001166,
	0x00001181, 0x000011a7, 0x000011bd, 0x000011e0,
	0x0000123f, 0x00001258, 0x0000127c, 0x00001288,
	0x000012b8, 0x000012ee, 0x0000130b, 0x00001324,
	0x00001355, 0x00001364, 0x00001372, 0x0000138c,
	0x000013c7, 0x000013f9, 0x0000140a, 0x0000141b,
	// Entry C0 - DF
	0x00001445, 0x0000146f, 0x00001495, 0x000014b8,
	0x000014e3, 0x0000150d, 0x00001537, 0x00001555,
	0x0000157a, 0x000015a4, 0x000015c6, 0x000015f5,
	0x00001619, 0x00001648, 0x0000166e, 0x00001690,
	0x000016bd, 0x000016e1, 0x00001709, 0x00001738,
	0x00001767, 0x0000178a, 0x000017c0, 0x000017f6,
	0x00001820, 0x0000184c, 0x0000186b, 0x0000188c,
	0x000018b1, 0x000018e4, 0x00001917, 0x0000193a,
	// Entry E0 - FF
	0x0000196b, 0x0000199c, 0x000019db, 0x00001a00,
	0x00001a1e, 0x00001a3c, 0x00001a69, 0x00001a91,
	0x00001abc, 0x00001ae9, 0x00001b13, 0x00001b56,
	0x00001ba3, 0x00001bf2, 0x00001c42, 0x00001c62,
	0x00001c8e, 0x00001cb7, 0x00001ccf, 0x00001ce6,
	0x00001cff, 0x00001d1f, 0x00001d31, 0x00001d3e,
	0x00001d51, 0x00001d60, 0x00001d7e, 0x00001d9d,
	0x00001dac, 0x00001dbb, 0x00001ddf, 0x00001df6,
	// Entry 100 - 11F
	0x00001dfc, 0x00001e17, 0x00001e32, 0x00001e48,
	0x00001e61, 0x00001e77, 0x00001e8e, 0x00001eb3,
	0x00001ed3, 0x00001f08, 0x00001f2e, 0x00001f4d,
	0x00001f6b, 0x00001fdc, 0x00001ffd, 0x00002020,
	0x00002192, 0x00002199, 0x0000219d, 0x00002304,
	0x00002333, 0x00002355,
} // Size: 1136 bytes

const enData string = "" + // Size: 9045 bytes
	"\x02Error\x02(no argument): elevate and install manager service\x02Usage" +
	": %[1]s [\x0a%[2]s]\x02Command Line Options\x02Unable to determine wheth" +
	"er the process is running under WOW64: %[1]v\x02You must use the native " +
	"version of WireGuard on this computer.\x02Unable to open current process" +
	" token: %[1]v\x02WireGuard may only be used by users who are a member of" +
	" the Builtin %[1]s group.\x02WireGuard is running, but the UI is only ac" +
	"cessible from desktops of the Builtin %[1]s group.\x02Now\x02System cloc" +
	"k wound backward!\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d year\x00\x0c\x02%" +
	"[1]d years\x14\x01\x81\x01\x00\x02\x0a\x02%[1]d day\x00\x0b\x02%[1]d day" +
	"s\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d hour\x00\x0c\x02%[1]d hours\x14" +
	"\x01\x81\x01\x00\x02\x0d\x02%[1]d minute\x00\x0e\x02%[1]d minutes\x14" +
	"\x01\x81\x01\x00\x02\x0d\x02%[1]d second\x00\x0e\x02%[1]d seconds\x02%[1" +
	"]s ago\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]" +
	"f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Invalid IP address\x02" +
	"Invalid network prefix length\x02Missing port from endpoint\x02Invalid e" +
	"ndpoint host\x02Invalid MTU\x02Invalid port\x02Invalid persistent keepal" +
	"ive\x02Invalid key: %[1]v\x02Number must be a number between 0 and 2^64-" +
	"1: %[1]v\x02Two commas in a row\x02Tunnel name is not valid\x02[none spe" +
	"cified]\x02All peers must have public keys\x02Error in getting configura" +
	"tion\x02, \x02, \x02About WireGuard\x02WireGuard logo image\x02Close\x02" +
	"♥ &Donate!\x02Status:\x02&Deactivate\x02&Activate\x02Public key:\x02Li" +
	"sten port:\x02MTU:\x02Addresses:\x02DNS servers:\x02Preshared key:\x02Al" +
	"lowed IPs:\x02Endpoint:\x02Persistent keepalive:\x02Latest handshake:" +
	"\x02Inactive\x02Deactivating\x02Unknown state\x02Log\x02&Copy\x02Select " +
	"&all\x02&Save to file…\x02Time\x02Log message\x02Export log to file\x02&" +
	"About WireGuard…\x02Tunnel Error\x02%[1]s\x0a\x0aPlease consult the log " +
	"for more information.\x02%[1]s (out of date)\x02Error Exiting WireGuard" +
	"\x02An update to WireGuard is available. It is highly advisable to updat" +
	"e without delay.\x02Update Now\x02Error: %[1]v. Please try again.\x02Sta" +
	"tus: Complete!\x02WireGuard system tray icon did not appear after 30 sec" +
	"onds.\x02Brackets must contain an IPv6 address\x02Keys must decode to ex" +
	"actly 32 bytes\x02Line must occur in a section\x02Config key is missing " +
	"an equals separator\x02Key must have a value\x02Invalid key for [Interfa" +
	"ce] section\x02Invalid key for [Peer] section\x02An interface must have " +
	"a private key\x02Invalid key for interface section\x02Protocol version m" +
	"ust be 1\x02Invalid key for peer section\x02Scripts:\x02Transfer:\x02pre" +
	"-up\x02post-up\x02pre-down\x02post-down\x02disabled, per policy\x02enabl" +
	"ed\x02%[1]s received, %[2]s sent\x02Failed to determine tunnel state\x02" +
	"Failed to activate tunnel\x02Failed to deactivate tunnel\x02Interface: %" +
	"[1]s\x02Peer\x02Create new tunnel\x02Edit tunnel\x02&Name:\x02&Public ke" +
	"y:\x02(unknown)\x02&Block untunneled traffic (kill-switch)\x02&Save\x02C" +
	"ancel\x02&Configuration:\x02Invalid name\x02A name is required.\x02Tunne" +
	"l name ‘%[1]s’ is invalid.\x02Unable to list existing tunnels\x02Tunnel " +
	"already exists\x02Another tunnel already exists with the name ‘%[1]s’." +
	"\x02Unable to create new configuration\x02Writing file failed\x02File ‘%" +
	"[1]s’ already exists.\x0a\x0aDo you want to overwrite it?\x02Active\x02A" +
	"ctivating\x02Text Files (*.txt)|*.txt|All Files (*.*)|*.*\x02WireGuard D" +
	"etection Error\x02Unable to wait for WireGuard window to appear: %[1]v" +
	"\x02WireGuard: Deactivated\x02Status: Unknown\x02Addresses: None\x02&Man" +
	"age tunnels…\x02&Import tunnel(s) from file…\x02E&xit\x02&Tunnels\x02Wir" +
	"eGuard Activated\x02The %[1]s tunnel has been activated.\x02WireGuard De" +
	"activated\x02The %[1]s tunnel has been deactivated.\x02WireGuard Tunnel " +
	"Error\x02WireGuard: %[1]s\x02Status: %[1]s\x02Addresses: %[1]s\x02An Upd" +
	"ate is Available!\x02WireGuard Update Available\x02An update to WireGuar" +
	"d is now available. You are advised to update as soon as possible.\x02Tu" +
	"nnels\x02&Edit\x02Add &empty tunnel…\x02Add Tunnel\x02Remove selected tu" +
	"nnel(s)\x02Export all tunnels to zip\x02&Toggle\x02Export all tunnels to" +
	" &zip…\x02Edit &selected tunnel…\x02&Remove selected tunnel(s)\x02no con" +
	"figuration files were found\x02Could not import selected configuration: " +
	"%[1]v\x02Could not enumerate existing tunnels: %[1]v\x02Another tunnel a" +
	"lready exists with the name ‘%[1]s’\x02Unable to import configuration: %" +
	"[1]v\x02Imported tunnels\x14\x01\x81\x01\x00\x02\x16\x02Imported %[1]d t" +
	"unnel\x00\x17\x02Imported %[1]d tunnels\x14\x02\x80\x01\x02\x1f\x02Impor" +
	"ted %[1]d of %[2]d tunnel\x00 \x02Imported %[1]d of %[2]d tunnels\x02Una" +
	"ble to create tunnel\x14\x01\x81\x01\x00\x02\x14\x02Delete %[1]d tunnel" +
	"\x00\x15\x02Delete %[1]d tunnels\x14\x01\x81\x01\x00\x024\x02Are you sur" +
	"e you would like to delete %[1]d tunnel?\x005\x02Are you sure you would " +
	"like to delete %[1]d tunnels?\x02Delete tunnel ‘%[1]s’\x02Are you sure y" +
	"ou would like to delete tunnel ‘%[1]s’?\x02%[1]s You cannot undo this ac" +
	"tion.\x02Unable to delete tunnel\x02A tunnel was unable to be removed: %" +
	"[1]s\x02Unable to delete tunnels\x14\x01\x81\x01\x00\x02'\x02%[1]d tunne" +
	"l was unable to be removed.\x00)\x02%[1]d tunnels were unable to be remo" +
	"ved.\x02Configuration Files (*.zip, *.conf)|*.zip;*.conf|All Files (*.*)" +
	"|*.*\x02Import tunnel(s) from file\x02Configuration ZIP Files (*.zip)|*." +
	"zip\x02Export tunnels to zip\x02%[1]s (unsigned build, no updates)\x02Un" +
	"able to exit service due to: %[1]v. You may want to stop WireGuard from " +
	"the service manager.\x02Status: Waiting for user\x02Status: Waiting for " +
	"updater service\x04\x00\x01 \x07\x02Error:\x02Interface closed, ignored " +
	"requested state %[1]s\x02Interface state was %[1]s, requested %[2]s, now" +
	" %[3]s\x02Unable to update bind: %[1]v\x02Bind close failed: %[1]v\x02Tr" +
	"ouble determining MTU, assuming default: %[1]v\x02Device closing\x02Devi" +
	"ce closed\x02UDP bind has been updated\x02%[1]v - ConsumeMessageInitiati" +
	"on: handshake replay @ %[2]v\x02%[1]v - ConsumeMessageInitiation: handsh" +
	"ake flood\x02%[1]v - Starting\x02%[1]v - Stopping\x02Routine: receive in" +
	"coming %[1]s - stopped\x02Routine: receive incoming %[1]s - started\x02F" +
	"ailed to receive %[1]s packet: %[2]v\x02Received message with unknown ty" +
	"pe\x02Routine: decryption worker %[1]d - started\x02Routine: handshake w" +
	"orker %[1]d - stopped\x02Routine: handshake worker %[1]d - started\x02Fa" +
	"iled to decode cookie reply\x02Receiving cookie response from %[1]s\x02C" +
	"ould not decrypt invalid cookie response\x02Received packet with invalid" +
	" mac1\x02Invalid packet ended up in the handshake queue\x02Failed to dec" +
	"ode initiation message\x02Received invalid initiation message from %[1]s" +
	"\x02%[1]v - Received handshake initiation\x02Failed to decode response m" +
	"essage\x02Received invalid response message from %[1]s\x02%[1]v - Receiv" +
	"ed handshake response\x02%[1]v - Failed to derive keypair: %[2]v\x02%[1]" +
	"v - Routine: sequential receiver - stopped\x02%[1]v - Routine: sequentia" +
	"l receiver - started\x02%[1]v - Receiving keepalive packet\x02IPv4 packe" +
	"t with disallowed source address from %[1]v\x02IPv6 packet with disallow" +
	"ed source address from %[1]v\x02Packet with invalid IP version from %[1]" +
	"v\x02Failed to write packet to TUN device: %[1]v\x02Unable to flush pack" +
	"ets: %[1]v\x02%[1]v - Sending keepalive packet\x02%[1]v - Sending handsh" +
	"ake initiation\x02%[1]v - Failed to create initiation message: %[2]v\x02" +
	"%[1]v - Failed to send handshake initiation: %[2]v\x02%[1]v - Sending ha" +
	"ndshake response\x02%[1]v - Failed to create response message: %[2]v\x02" +
	"%[1]v - Failed to send handshake response: %[2]v\x02Sending cookie respo" +
	"nse for denied handshake message for %[1]v\x02Failed to create cookie re" +
	"ply: %[1]v\x02Routine: TUN reader - stopped\x02Routine: TUN reader - sta" +
	"rted\x02Failed to read packet from TUN device: %[1]v\x02Received packet " +
	"with unknown IP version\x02Routine: encryption worker %[1]d - started" +
	"\x02%[1]v - Routine: sequential sender - started\x02%[1]v - Failed to se" +
	"nd data packet: %[2]v\x02%[1]s - Handshake did not complete after %[2]d " +
	"attempts, giving up\x02%[1]s - Handshake did not complete after %[2]d se" +
	"conds, retrying (try %[3]d)\x02%[1]s - Retrying handshake because we sto" +
	"pped hearing back after %[2]d seconds\x02%[1]s - Removing all keys, sinc" +
	"e we haven't received a new one in %[2]d seconds\x02Routine: event worke" +
	"r - started\x02Failed to load updated MTU of device: %[1]v\x02MTU not up" +
	"dated to negative value: %[1]v\x02MTU updated: %[1]v%[2]s\x02Interface u" +
	"p requested\x02Interface down requested\x02Routine: event worker - stopp" +
	"ed\x02listen_port=%[1]d\x02fwmark=%[1]d\x02protocol_version=1\x02endpoin" +
	"t=%[1]s\x02last_handshake_time_sec=%[1]d\x02last_handshake_time_nsec=%[1" +
	"]d\x02tx_bytes=%[1]d\x02rx_bytes=%[1]d\x02persistent_keepalive_interval=" +
	"%[1]d\x02allowed_ip=%[1]s/%[2]d\x02%[1]v\x02UAPI: Updating private key" +
	"\x02UAPI: Updating listen port\x02UAPI: Updating fwmark\x02UAPI: Removin" +
	"g all peers\x02%[1]v - UAPI: Created\x02%[1]v - UAPI: Removing\x02%[1]v " +
	"- UAPI: Updating preshared key\x02%[1]v - UAPI: Updating endpoint\x02%[1" +
	"]v - UAPI: Updating persistent keepalive interval\x02%[1]v - UAPI: Remov" +
	"ing all allowedips\x02%[1]v - UAPI: Adding allowedip\x02invalid UAPI ope" +
	"ration: %[1]v\x02App version: %[1]s\x0aGo backend version: %[2]s\x0aGo v" +
	"ersion: %[3]s-%[4]s\x0aOperating system: %[5]s\x0aArchitecture: %[6]s" +
	"\x02&Test experimental kernel driver\x02Enable experimental kernel drive" +
	"r?\x02The WireGuard project is currently testing a high performance kern" +
	"el driver called WireGuardNT. It will eventually be enabled by default, " +
	"but for now the project needs testers to try it out. Whether you encount" +
	"er problems or you find that it works well, please do email team@wiregua" +
	"rd.com about your experience.\x0a\x0aWould you like to enable the experi" +
	"mental kernel driver?\x02Table:\x02off\x02When a configuration has exact" +
	"ly one peer, and that peer has an allowed IPs containing at least one of" +
	" 0.0.0.0/0 or ::/0, and the interface does not have table off, then the " +
	"tunnel service engages a firewall ruleset to block all traffic that is n" +
	"either to nor from the tunnel interface or is to the wrong DNS server, w" +
	"ith special exceptions for DHCP and NDP.\x02Please ask the system admini" +
	"strator to update.\x02Status: Waiting for administrator"

var es_ESIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000044, 0x00000058,
	0x00000077, 0x00000077, 0x00000077, 0x00000077,
	0x00000077, 0x00000077, 0x0000007d, 0x0000007d,
	0x0000009d, 0x000000bc, 0x000000dc, 0x00000100,
	0x00000126, 0x00000131, 0x00000139, 0x00000145,
	0x00000151, 0x0000015d, 0x00000169, 0x00000169,
	0x00000181, 0x000001a7, 0x000001c3, 0x000001df,
	0x000001ed, 0x000001ff, 0x000001ff, 0x00000217,
	// Entry 20 - 3F
	0x00000217, 0x00000217, 0x00000217, 0x00000217,
	0x00000217, 0x00000217, 0x00000217, 0x00000217,
	0x0000022b, 0x00000248, 0x0000024f, 0x0000025b,
	0x00000263, 0x0000026f, 0x00000278, 0x00000288,
	0x0000029b, 0x000002a0, 0x000002ad, 0x000002bd,
	0x000002cf, 0x000002df, 0x000002df, 0x000002df,
	0x000002ef, 0x000002f8, 0x00000305, 0x00000318,
	0x00000321, 0x00000329, 0x0000033b, 0x00000352,
	// Entry 40 - 5F
	0x00000359, 0x0000036e, 0x0000038b, 0x000003a3,
	0x000003b6, 0x000003f5, 0x000003f5, 0x000003f5,
	0x000003f5, 0x00000400, 0x00000423, 0x00000435,
	0x00000435, 0x00000435, 0x00000435, 0x00000435,
	0x00000435, 0x00000435, 0x00000435, 0x00000435,
	0x00000435, 0x00000435, 0x00000435, 0x00000435,
	0x00000435, 0x00000441, 0x00000441, 0x00000441,
	0x00000441, 0x00000441, 0x00000441, 0x0000044a,
	// Entry 60 - 7F
	0x0000044a, 0x0000044a, 0x00000465, 0x00000483,
	0x00000493, 0x00000499, 0x000004af, 0x000004bd,
	0x000004c6, 0x000004d6, 0x000004e4, 0x000004e4,
	0x000004ed, 0x000004f6, 0x00000507, 0x00000519,
	0x00000530, 0x00000560, 0x00000560, 0x00000560,
	0x00000560, 0x00000560, 0x00000560, 0x00000560,
	0x00000567, 0x00000571, 0x000005ae, 0x000005ae,
	0x000005ae, 0x000005c5, 0x000005d9, 0x000005ee,
	// Entry 80 - 9F
	0x000005ee, 0x000005ee, 0x000005f5, 0x000005ff,
	0x00000612, 0x00000612, 0x00000629, 0x00000629,
	0x00000649, 0x0000065a, 0x00000668, 0x0000067b,
	0x0000069e, 0x000006c5, 0x00000725, 0x0000072e,
	0x00000736, 0x00000750, 0x0000075f, 0x0000077f,
	0x000007a1, 0x000007ab, 0x000007ab, 0x000007ab,
	0x000007ab, 0x000007ab, 0x000007ab, 0x000007e0,
	0x0000080c, 0x00000838, 0x0000084c, 0x00000886,
	// Entry A0 - BF
	0x000008d1, 0x000008ec, 0x00000923, 0x00000923,
	0x0000093f, 0x0000097b, 0x000009a2, 0x000009bf,
	0x000009e9, 0x00000a05, 0x00000a05, 0x00000a05,
	0x00000a05, 0x00000a05, 0x00000a05, 0x00000a05,
	0x00000a05, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	// Entry C0 - DF
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	// Entry E0 - FF
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	// Entry 100 - 11F
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22, 0x00000a22, 0x00000a22,
	0x00000a22, 0x00000a22,
} // Size: 1136 bytes

const es_ESData string = "" + // Size: 2594 bytes
	"\x02Error\x02(sin argumento): eleva e instala el servicio de administrad" +
	"or\x02Uso: %[1]s [\x0a%[2]s]\x02Opciones de línea de comandos\x02Ahora" +
	"\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d año\x00\x0c\x02%[1]d años\x14\x01" +
	"\x81\x01\x00\x02\x0b\x02%[1]d día\x00\x0b\x02%[1]d dias\x14\x01\x81\x01" +
	"\x00\x02\x0b\x02%[1]d hora\x00\x0c\x02%[1]d horas\x14\x01\x81\x01\x00" +
	"\x02\x0d\x02%[1]d minuto\x00\x0e\x02%[1]d minutos\x14\x01\x81\x01\x00" +
	"\x02\x0e\x02%[1]d segundo\x00\x0f\x02%[1]d segundos\x02hace %[1]s\x02%[1" +
	"]d B\x02%.2[1]f KiB\x02%.2[1]f MiB\x02%.2[1]f GiB\x02%.2[1]f TiB\x02Dire" +
	"cción IP inválida\x02Longitud de prefijo de red no válida\x02Falta el pu" +
	"erto del extremo\x02Host de endpoint no válido\x02MTU no valido\x02Puert" +
	"o no válido\x02Clave no válida: %[1]v\x02Acerca de WireGuard\x02Imagen d" +
	"el logo de WireGuard\x02Cerrar\x02♥ &Donar!\x02Estado:\x02&Desactivar" +
	"\x02&Activar\x02Clave pública:\x02Puerto de escucha:\x02MTU:\x02Direccio" +
	"nes:\x02Servidores DNS:\x02Clave compartida:\x02IPs permitidas:\x02Últim" +
	"o saludo:\x02Inactivo\x02Desactivando\x02Estado desconocido\x02Registro" +
	"\x02&Copiar\x02Seleccionar &todo\x02&Guardar en archivo…\x02Tiempo\x02Re" +
	"gistro de mensajes\x02Exportar archivo de registro\x02&Acerca de WireGua" +
	"rd…\x02Error en el túnel\x02%[1]s\x0a\x0aPor favor, consulte el registro" +
	" para más información.\x02Actualizar\x02Error: %[1]v. Inténtalo de nuevo" +
	".\x02Estado: Completo!\x02Transferir:\x02activado\x02Error al activar el" +
	" túnel\x02Error al desactivar el túnel\x02Interfaz: %[1]s\x02Pares\x02Cr" +
	"ear un túnel nuevo\x02Editar túnel\x02&Nombre:\x02Clave pública:\x02(des" +
	"conocido)\x02&Guardar\x02Cancelar\x02&Configuración:\x02Nombre no válido" +
	"\x02Se requiere un nombre.\x02El nombre del túnel ‘%[1]s’ no es válido." +
	"\x02Activo\x02Activando\x02Archivos de texto (*.txt)|*.txt|Todos los arc" +
	"hivos (*.*)|*.*\x02WireGuard: Desactivado\x02Estado: Desconocido\x02Dire" +
	"cciones: Ninguna\x02&Salir\x02&Túneles\x02WireGuard Activado\x02WireGuar" +
	"d: Desactivado\x02Error en el túnel de WireGuard\x02WireGuard: %[1]s\x02" +
	"Estado: %[1]s\x02Direcciones: %[1]s\x02Hay una actualización disponible!" +
	"\x02Actualización de WireGuard disponible\x02Ya está disponible una actu" +
	"alización de WireGuard. Se recomienda actualizar lo antes posible.\x02Tú" +
	"neles\x02&Editar\x02Añadir &túnel vacío…\x02Añadir túnel\x02Eliminar tún" +
	"eles seleccionados\x02Exportar todos los túneles a zip\x02&Alternar\x02N" +
	"o se pueden enumerar los túneles existentes: %[1]v\x02Ya existe otro tún" +
	"el con el nombre '%[1]s'\x02Imposible importar la configuración: %[1]v" +
	"\x02Túneles importados\x14\x01\x81\x01\x00\x02\x17\x02%[1]d túnel import" +
	"ado\x00\x1a\x02%[1]d túneles importados\x14\x02\x80\x01\x02 \x02Importad" +
	"o %[1]d de %[2]d túnel\x00#\x02Importados %[1]d de %[2]d túneles\x02No s" +
	"e pudo crear el túnel\x14\x01\x81\x01\x00\x02\x16\x02Eliminar %[1]d túne" +
	"l\x00\x18\x02Eliminar %[1]d túneles\x02Eliminar túnel ‘%[1]s’\x02¿Está s" +
	"eguro de que desea eliminar el túnel ‘%[1]s’?\x02%[1]s No puedes deshace" +
	"r esta acción.\x02No se pudo eliminar el tunel\x02No se ha podido elimin" +
	"ar un túnel: %[1]s\x02Imposible eliminar túneles\x02Estado: Esperando al" +
	" usuario"

var faIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000007, 0x00000007,
	0x0000002b, 0x0000002b, 0x0000002b, 0x0000002b,
	0x0000002b, 0x0000002b, 0x0000003b, 0x0000003b,
	0x0000005e, 0x00000081, 0x000000a8, 0x000000d3,
	0x000000fe, 0x0000010b, 0x0000011b, 0x0000011b,
	0x0000011b, 0x0000011b, 0x0000011b, 0x0000011b,
	0x00000148, 0x00000148, 0x00000148, 0x00000148,
	0x00000162, 0x0000017a, 0x0000017a, 0x0000017a,
	// Entry 20 - 3F
	0x0000017a, 0x0000017a, 0x0000017a, 0x0000018e,
	0x000001de, 0x00000208, 0x0000020c, 0x00000210,
	0x00000227, 0x00000227, 0x00000230, 0x00000247,
	0x00000253, 0x0000026e, 0x00000283, 0x00000298,
	0x000002ab, 0x000002b0, 0x000002c3, 0x000002d7,
	0x000002ff, 0x00000312, 0x00000327, 0x00000352,
	0x00000352, 0x00000361, 0x00000387, 0x000003a3,
	0x000003b9, 0x000003c7, 0x000003c7, 0x000003e8,
	// Entry 40 - 5F
	0x000003f1, 0x00000412, 0x0000044e, 0x00000469,
	0x0000047d, 0x0000047d, 0x0000047d, 0x000004b3,
	0x000004b3, 0x000004dc, 0x00000514, 0x0000052f,
	0x0000052f, 0x0000052f, 0x0000052f, 0x0000052f,
	0x0000052f, 0x00000565, 0x00000565, 0x00000565,
	0x00000565, 0x00000565, 0x00000565, 0x00000565,
	0x00000565, 0x00000573, 0x00000573, 0x00000573,
	0x00000573, 0x00000573, 0x00000573, 0x00000583,
	// Entry 60 - 7F
	0x00000583, 0x00000583, 0x00000583, 0x00000583,
	0x00000593, 0x0000059c, 0x000005b9, 0x000005cf,
	0x000005d8, 0x000005ee, 0x00000601, 0x00000601,
	0x0000060d, 0x00000614, 0x00000627, 0x0000063d,
	0x0000065e, 0x0000065e, 0x000006a4, 0x000006d1,
	0x000006d1, 0x000006d1, 0x000006d1, 0x000006d1,
	0x000006da, 0x000006fa, 0x000006fa, 0x000006fa,
	0x000006fa, 0x000006fa, 0x00000717, 0x00000731,
	// Entry 80 - 9F
	0x00000752, 0x00000752, 0x00000752, 0x00000752,
	0x0000076c, 0x0000078e, 0x000007ac, 0x000007ac,
	0x000007c8, 0x000007c8, 0x000007da, 0x000007da,
	0x0000080f, 0x00000848, 0x00000848, 0x00000858,
	0x00000866, 0x00000894, 0x000008aa, 0x000008cf,
	0x00000904, 0x00000904, 0x0000093d, 0x0000093d,
	0x0000093d, 0x0000093d, 0x0000093d, 0x0000093d,
	0x0000093d, 0x0000093d, 0x0000095f, 0x000009a2,
	// Entry A0 - BF
	0x000009fa, 0x00000a27, 0x00000a5c, 0x00000a5c,
	0x00000a78, 0x00000a78, 0x00000a78, 0x00000aaa,
	0x00000aaa, 0x00000adf, 0x00000adf, 0x00000adf,
	0x00000b12, 0x00000b4e, 0x00000b7c, 0x00000b7c,
	0x00000b7c, 0x00000bad, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	// Entry C0 - DF
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	// Entry E0 - FF
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	// Entry 100 - 11F
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6, 0x00000bf6, 0x00000bf6,
	0x00000bf6, 0x00000bf6,
} // Size: 1136 bytes

const faData string = "" + // Size: 3062 bytes
	"\x02خطا\x02گزینه\u200cهای خط فرمان\x02هم اکنون\x14\x01\x81\x01\x00\x02" +
	"\x0d\x02%[1]d سال\x00\x0d\x02%[1]d سال\x14\x01\x81\x01\x00\x02\x0d\x02%[" +
	"1]d روز\x00\x0d\x02%[1]d روز\x14\x01\x81\x01\x00\x02\x0f\x02%[1]d ساعت" +
	"\x00\x0f\x02%[1]d ساعت\x14\x01\x81\x01\x00\x02\x11\x02%[1]d دقیقه\x00" +
	"\x11\x02%[1]d دقیقه\x14\x01\x81\x01\x00\x02\x11\x02%[1]d ثانیه\x00\x11" +
	"\x02%[1]d ثانیه\x02%[1]s پیش\x02%[1]d\u00a0بایت\x02نشانی آی\u200cپی نامع" +
	"تبر است\x02MTU نامعتبر است\x02پورت نامعتبر\x02[مشخص نشده]\x02همه همتاها" +
	" باید کلید\u200cهای عمومی داشته باشند\x02خطا در دریافت پیکربندی\x02، " +
	"\x02، \x02درباره WireGuard\x02بستن\x02♥&کمک\u200cمالی!\x02وضعیت:\x02&غیر" +
	"فعال\u200cسازی\x02&فعال\u200cسازی\x02کلید عمومی:\x02پورت شنود:\x02MTU:" +
	"\x02نشانی\u200cها:\x02سرورهای DNS:\x02کلید از پیش تقسیم شده:\x02IPهای مج" +
	"از:\x02نقطه پایان:\x02زنده نگه\u200cداشتن پیوسته:\x02غیرفعال\x02در حال " +
	"غیرفعال\u200cسازی\x02وضعیت ناشناخته\x02گزارش وقایع\x02&روگرفت\x02&ذخیره" +
	" در پرونده…\x02زمان\x02پیام گزارش رویداد\x02برون\u200cبرد گزارش رویداد ب" +
	"ه پرونده\x02&درباره WireGuard…\x02خطالی تونل\x02خطا در هنگام خارج شدن ا" +
	"ز WireGuard\x02اکنون به\u200cروز رسانی کن\x02خطا: %[1]v. لطفا دوباره تل" +
	"اش کنید.\x02وضعیت: کامل شد!\x02کلید باید یک مقدار داشته باشد\x02انتقال:" +
	"\x02فعال شده\x02رابط: %[1]s\x02همتا\x02ایجاد تونل جدید\x02ویرایش تونل" +
	"\x02&نام:\x02&کلید عمومی:\x02(ناشناخته)\x02&ذخیره\x02لغو\x02&پیکربندی:" +
	"\x02نام نامعتبر\x02یک نام الزامی است.\x02نمی\u200cتوان تونل\u200cهای موج" +
	"ود را فهرست کرد\x02تونل هم\u200cاکنون موجود است\x02فعال\x02در حال فعال" +
	"\u200cسازی\x02وضعیت: ناشناخته\x02نشانی\u200cها: هیچ\x02&مدیریت تونل" +
	"\u200cها…\x02WireGuard فعال\u200cشد\x02تونل %[1]s فعال\u200cشده.\x02Wire" +
	"Guard غیرفعال شد\x02خطای تونل WireGuard\x02وضعیت: %[1]s\x02یک به\u200cرو" +
	"زرسانی در دسترس است!\x02به\u200cروزرسانی WireGuard در دسترس است\x02تونل" +
	"\u200cها\x02&ویرایش\x02افزودن &خالی\u200cکردن تونل…\x02افزودن تونل\x02حذ" +
	"ف تونل(ها) انتخابی\x02برون\u200cبری همه تونل\u200cها به زیپ\x02برون" +
	"\u200cبری همه تونل\u200cها به &زیپ…\x02تونل\u200cهای وارد شده\x14\x01" +
	"\x81\x01\x00\x02\x1d\x02%[1]d تونل وارد شد\x00\x1d\x02%[1]d تونل وارد شد" +
	"\x14\x02\x80\x01\x02(\x02%[1]d از %[2]d تونل وارد شد\x00(\x02%[1]d از %[" +
	"2]d تونل وارد شد\x02نمی\u200cتوان تونل ایجاد کرد\x14\x01\x81\x01\x00\x02" +
	"\x16\x02حذف %[1]d تونل\x00\x16\x02حذف %[1]d تونل\x02حذف تونل ‘%[1]s’\x02" +
	"حذف تونل\u200c امکان\u200cپذیر نیست\x02نمی\u200cتوان تونل\u200cها را حذ" +
	"ف کرد\x02وارد کردن تونل(ها) از پرونده\x02پرونده\u200cهای پیکربندی زیپ (" +
	"*.zip)|*.zip\x02برون\u200cبری تونل\u200cها به زیپ\x02وضعیت: درانتظار برا" +
	"ی کاربر\x02وضعیت: درانتظار برای سرویس به\u200cروزرسانی"

var fiIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x0000000a, 0x0000002a,
	0x0000002a, 0x0000002a, 0x0000002a, 0x0000002a,
	0x0000002a, 0x00000037, 0x0000003f, 0x0000003f,
	0x0000003f, 0x0000003f, 0x0000003f, 0x0000003f,
	0x0000003f, 0x0000003f, 0x0000003f, 0x0000003f,
	0x00000050, 0x00000064, 0x00000083, 0x0000009d,
	// Entry 20 - 3F
	0x0000009d, 0x0000009d, 0x0000009d, 0x0000009d,
	0x0000009d, 0x0000009d, 0x000000a0, 0x000000a3,
	0x000000b8, 0x000000cd, 0x000000d3, 0x000000e2,
	0x000000e8, 0x000000e8, 0x000000e8, 0x000000f8,
	0x0000010a, 0x0000010f, 0x0000011a, 0x0000012a,
	0x00000138, 0x0000014f, 0x0000015d, 0x00000170,
	0x00000184, 0x00000184, 0x00000184, 0x00000184,
	0x00000189, 0x00000191, 0x00000191, 0x00000191,
	// Entry 40 - 5F
	0x00000191, 0x00000191, 0x00000191, 0x00000191,
	0x00000191, 0x00000191, 0x00000191, 0x00000191,
	0x00000191, 0x0000019f, 0x0000019f, 0x000001ad,
	0x000001ad, 0x000001ad, 0x000001ad, 0x000001ad,
	0x000001ad, 0x000001ad, 0x000001ad, 0x000001ad,
	0x000001ad, 0x000001ad, 0x000001ad, 0x000001ad,
	0x000001bc, 0x000001c5, 0x000001c5, 0x000001c5,
	0x000001c5, 0x000001c5, 0x000001c5, 0x000001d1,
	// Entry 60 - 7F
	0x000001f7, 0x000001f7, 0x000001f7, 0x000001f7,
	0x0000020b, 0x00000214, 0x00000225, 0x00000236,
	0x0000023d, 0x0000024e, 0x0000025b, 0x0000028b,
	0x00000295, 0x00000295, 0x000002a5, 0x000002b7,
	0x000002cb, 0x000002cb, 0x000002cb, 0x000002e2,
	0x000002e2, 0x000002e2, 0x000002e2, 0x000002e2,
	0x000002e2, 0x000002e2, 0x000002e2, 0x000002e2,
	0x000002e2, 0x000002e2, 0x000002e2, 0x000002e2,
	// Entry 80 - 9F
	0x000002e2, 0x00000301, 0x00000301, 0x00000301,
	0x00000301, 0x00000301, 0x00000301, 0x00000301,
	0x00000301, 0x00000301, 0x00000301, 0x00000301,
	0x0000031a, 0x00000339, 0x00000399, 0x000003a1,
	0x000003aa, 0x000003c5, 0x000003d5, 0x000003d5,
	0x000003d5, 0x000003d5, 0x000003d5, 0x000003d5,
	0x000003d5, 0x000003d5, 0x000003d5, 0x000003d5,
	0x000003d5, 0x000003d5, 0x000003e5, 0x00000417,
	// Entry A0 - BF
	0x00000417, 0x00000417, 0x00000417, 0x00000417,
	0x00000417, 0x00000417, 0x00000417, 0x00000417,
	0x00000417, 0x00000431, 0x00000431, 0x00000431,
	0x0000044c, 0x0000044c, 0x0000044c, 0x0000044c,
	0x0000044c, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	// Entry C0 - DF
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	// Entry E0 - FF
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	// Entry 100 - 11F
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a, 0x0000046a, 0x0000046a,
	0x0000046a, 0x0000046a,
} // Size: 1136 bytes

const fiData string = "" + // Size: 1130 bytes
	"\x02Virhe\x02Nyt\x02Järjestelmän kello jättää!\x02%[1]s sitten\x02%[1]d " +
	"B\x02Virheellinen MTU\x02Virheellinen portti\x02Virheellinen jatkuva kee" +
	"palive\x02Virheellinen avain: %[1]v\x02, \x02, \x02Tietoa WireGuardista" +
	"\x02WireGuard logon kuva\x02Sulje\x02♥ &Lahjoita!\x02Tila:\x02Julkinen a" +
	"vain:\x02Kuuntele porttia:\x02MTU:\x02Osoitteet:\x02DNS palvelimet:\x02J" +
	"aettu avain:\x02Sallitut IP-osoitteet:\x02Päätepiste:\x02Jatkuva keepali" +
	"ve:\x02Viimeisin kättely:\x02Loki\x02&Kopioi\x02Päivitä nyt\x02Tila: Val" +
	"mis!\x02Komentosarjat:\x02Siirrot:\x02käytössä\x02%[1]s vastaanotettu, %" +
	"[2]s lähetetty\x02Verkkoyhteys: %[1]s\x02Osapuoli\x02Luo uusi tunneli" +
	"\x02Muokkaa tunnelia\x02&Nimi:\x02&Julkinen avain:\x02(tuntematon)\x02&E" +
	"stä tunneloimaton liikenne (pääkatkaisija)\x02&Tallenna\x02&Konfiguraati" +
	"o:\x02Virheellinen nimi\x02Nimi on pakollinen.\x02Tunneli on jo olemassa" +
	"\x02Tuo tunnele&ita tiedostosta…\x02Päivitys on saatavilla!\x02WireGuard" +
	" päivitys saatavilla\x02WireGuardin päivitys on nyt saatavilla. Sinua ke" +
	"hotetaan päivittämään mahdollisimman pian.\x02Tunneli\x02&Muokkaa\x02Lis" +
	"ää tyhjä tunn&eli…\x02Lisää tunneli\x02Tuodut tunnelit\x14\x01\x81\x01" +
	"\x00\x02\x14\x02Tuotu %[1]d tunneli\x00\x15\x02Tuotu %[1]d tunnelia\x02T" +
	"unnelia ei voitu poistaa\x02Tuo tunneli(t) tiedostosta\x02Tila: Odotetaa" +
	"n käyttäjää"

var frIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000046, 0x00000063,
	0x00000083, 0x000000cb, 0x00000112, 0x0000014b,
	0x000001ad, 0x00000225, 0x00000230, 0x00000253,
	0x0000026f, 0x0000028f, 0x000002b1, 0x000002d5,
	0x000002fb, 0x00000308, 0x00000311, 0x0000031e,
	0x0000032b, 0x00000338, 0x00000345, 0x00000353,
	0x00000369, 0x00000391, 0x000003b7, 0x000003e0,
	0x000003ef, 0x000003ff, 0x00000414, 0x0000042c,
	// Entry 20 - 3F
	0x00000464, 0x00000480, 0x00000499, 0x000004b1,
	0x000004e5, 0x0000050c, 0x0000050f, 0x00000511,
	0x00000528, 0x00000543, 0x0000054a, 0x0000055e,
	0x00000566, 0x00000573, 0x0000057c, 0x0000058c,
	0x0000059d, 0x000005a3, 0x000005ae, 0x000005bd,
	0x000005d3, 0x000005ed, 0x00000604, 0x00000632,
	0x00000659, 0x00000662, 0x0000067a, 0x00000688,
	0x00000690, 0x00000698, 0x000006ac, 0x000006cc,
	// Entry 40 - 5F
	0x000006d2, 0x000006e5, 0x00000709, 0x00000721,
	0x00000732, 0x0000077c, 0x0000078e, 0x000007ac,
	0x00000825, 0x0000083f, 0x00000864, 0x00000875,
	0x000008d2, 0x0000090a, 0x00000937, 0x00000963,
	0x0000099e, 0x000009b9, 0x000009e5, 0x00000a0c,
	0x00000a34, 0x00000a60, 0x00000a82, 0x00000aae,
	0x00000ab8, 0x00000ac4, 0x00000ad4, 0x00000ae4,
	0x00000af8, 0x00000b0c, 0x00000b2a, 0x00000b35,
	// Entry 60 - 7F
	0x00000b56, 0x00000b82, 0x00000ba1, 0x00000bc5,
	0x00000bd7, 0x00000be1, 0x00000bfa, 0x00000c0d,
	0x00000c14, 0x00000c25, 0x00000c32, 0x00000c65,
	0x00000c72, 0x00000c7a, 0x00000c8b, 0x00000c9a,
	0x00000cb2, 0x00000cdc, 0x00000d11, 0x00000d27,
	0x00000d5b, 0x00000d8b, 0x00000da9, 0x00000de8,
	0x00000df1, 0x00000e05, 0x00000e3e, 0x00000e60,
	0x00000ea2, 0x00000eb9, 0x00000ec9, 0x00000edb,
	// Entry 80 - 9F
	0x00000ef3, 0x00000f25, 0x00000f2e, 0x00000f38,
	0x00000f4a, 0x00000f68, 0x00000f7e, 0x00000fa0,
	0x00000fbb, 0x00000fcd, 0x00000fdb, 0x00000fec,
	0x00001005, 0x0000102b, 0x000010a0, 0x000010a8,
	0x000010b2, 0x000010cd, 0x000010df, 0x0000110a,
	0x0000112d, 0x00001137, 0x0000115e, 0x00001183,
	0x000011af, 0x000011d6, 0x00001214, 0x0000124b,
	0x00001277, 0x000012a6, 0x000012b8, 0x000012ef,
	// Entry A0 - BF
	0x00001338, 0x00001357, 0x0000138f, 0x000013f3,
	0x00001413, 0x00001449, 0x00001478, 0x0000149a,
	0x000014cf, 0x000014f3, 0x0000155f, 0x000015b2,
	0x000015e0, 0x0000160c, 0x0000162a, 0x0000165b,
	0x000016d6, 0x000016fb, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	// Entry C0 - DF
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	// Entry E0 - FF
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	// Entry 100 - 11F
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a, 0x0000172a, 0x0000172a,
	0x0000172a, 0x0000172a,
} // Size: 1136 bytes

const frData string = "" + // Size: 5930 bytes
	"\x02Erreur\x02(sans argument) : élever et installer service du gestionna" +
	"ire\x02Utilisation : %[1]s [\x0a%[2]s]\x02Options de la ligne de command" +
	"e\x02Impossible de détecter si le processus s’exécute sous WOW64 : %[1]v" +
	"\x02Vous devez utiliser la version native de WireGuard sur cet ordinateu" +
	"r.\x02Impossible d'ouvrir le jeton du processus actuel : %[1]v\x02Seulem" +
	"ent les utilisateurs qui sont membres du groupe intégré %[1]s peuvent ut" +
	"iliser WireGuard.\x02WireGuard est en cours d'exécution, mais l'IU est a" +
	"ccessible seulement à partir des bureaux du group intégré %[1]s.\x02Main" +
	"tenant\x02L’horloge système est inversé!\x14\x01\x81\x01\x00\x02\x09\x02" +
	"%[1]d an\x00\x0a\x02%[1]d ans\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d jour" +
	"\x00\x0c\x02%[1]d jours\x14\x01\x81\x01\x00\x02\x0c\x02%[1]d heure\x00" +
	"\x0d\x02%[1]d heures\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d minute\x00\x0e" +
	"\x02%[1]d minutes\x14\x01\x81\x01\x00\x02\x0e\x02%[1]d seconde\x00\x0f" +
	"\x02%[1]d secondes\x02Il y a %[1]s\x02%[1]d\u00a0o\x02%.2[1]f\u00a0Kio" +
	"\x02%.2[1]f\u00a0Mio\x02%.2[1]f\u00a0Gio\x02%.2[1]f\u00a0Tio\x02%[1]s : " +
	"%[2]q\x02Adresse IP non valide\x02Longueur du préfixe réseau non valide" +
	"\x02Port manquant au point de terminaison\x02Hôte du point de terminaiso" +
	"n non valide\x02MTU non valide\x02Port non valide\x02Keepalive non valid" +
	"e\x02Clé non valide : %[1]v\x02Le numéro doit être compris entre 0 et 2^" +
	"64-1 : %[1]v\x02Deux virgules consécutives\x02Nom du tunnel non valide" +
	"\x02[aucune spécification]\x02Toutes les pairs doivent contenir une clé " +
	"publique\x02Erreur d'obtention de la configuration\x02, \x02 \x02À propo" +
	"s du WireGuard\x02Image du logo du WireGuard\x02Fermer\x02♥ &Faites un d" +
	"on!\x02État :\x02&Désactiver\x02&Activer\x02Clé publique :\x02Port d'éco" +
	"ute :\x02MTU :\x02Adresses :\x02Serveurs DNS :\x02Clé pré-partagée :\x02" +
	"Adresses IP autorisées :\x02Point de terminaison :\x02Conservation de co" +
	"nnexion active permanente :\x02Dernier établissement d'une liaison :\x02" +
	"Éteinte\x02Désactivation en cours\x02État inconnu\x02Journal\x02&Copier" +
	"\x02Sélectionner &tout\x02&Enregistrer dans le fichier…\x02Temps\x02Mess" +
	"age du journal\x02Exporter le journal vers le fichier\x02&À propos WireG" +
	"uard…\x02Erreur du tunnel\x02%[1]s\x0a\x0aConsultez le journal pour plus" +
	" d’informations, s'il vous plaît.\x02%[1]s (obsolète)\x02Erreur de sorti" +
	"e du WireGuard\x02Une mise à jour du WireGuard est disponible. Il est fo" +
	"rtement conseillé de metter votre WireGuard à jour sans délai.\x02Mettre" +
	" à jour maintenant\x02Erreur : %[1]v. Veuillez réessayer.\x02État: Termi" +
	"né!\x02L’icône de la barre d’état système du WireGuard n'est pas apparue" +
	" après 30 secondes.\x02L’adresse IPv6 doit être contenue entre des croch" +
	"ets\x02Clés doivent être décodées sur 32 octets\x02Une ligne doit appara" +
	"ître dans une section\x02Il manque le séparateur égal à la clé de confi" +
	"guration\x02Clé doit avoir une valeur\x02Clé non valide pour la section " +
	"[Interface]\x02Clé non valide pour la section [Peer]\x02L'interface doit" +
	" avoir une clé privée\x02Clé non valide pour la section d'interface\x02V" +
	"ersion du protocole doit être 1\x02Clé non valide pour la section d'homo" +
	"logue\x02Scripts :\x02Transfert :\x02pré-activation\x02post-activation" +
	"\x02pré-désactivation\x02post-désactivation\x02désactivé, par préférence" +
	"\x02activé(e)\x02%[1]s reçu(e), %[2]s envoyé(e)\x02Impossible de détermi" +
	"ner l'état du tunnel\x02Impossible d'activer le tunnel\x02Impossible de " +
	"désactiver le tunnel\x02Interface : %[1]s\x02Homologue\x02Créer un nouve" +
	"au tunnel\x02Modifier le tunnel\x02&Nom :\x02&Clé publique :\x02(inconnu" +
	"(e))\x02&Bloquer tous le trafic hors tunnel (interrupteur)\x02&Enregistr" +
	"er\x02Annuler\x02&Configuration :\x02Nom non valide\x02Le nom est obliga" +
	"toire.\x02Nom de tunnel « %[1]s » est non valide.\x02Impossible de créer" +
	" une liste des tunnels existants\x02Tunnel existe déjà.\x02Nom « %[1]s »" +
	" est déjà utilisé pour un tunnel.\x02Impossible de créer une configurati" +
	"on nouvelle\x02Échec d'écriture du fichier\x02Fichier « %[1]s » existe d" +
	"éjà.\x0a\x0aVoulez-vous le remplacer ?\x02Activée\x02Activation en cour" +
	"s\x02Fichiers texte (*.txt)|*.txt|Tous les fichiers (*.*)|*.*\x02Erreur " +
	"de détection du WireGuard\x02Impossible d’attendre l'affichage du fenêtr" +
	"e WireGuard : %[1]v\x02WireGuard: Désactivé\x02État : Inconnu\x02Adresse" +
	"s : Aucune\x02&Gestion des tunnels…\x02&Importer le(s) tunnel(s) à parti" +
	"r du fichier…\x02Q&uitter\x02& Tunnels\x02WireGuard activé\x02Tunnel %[1" +
	"]s a été activé.\x02WireGuard désactivé\x02Tunnel %[1]s a été désactivé." +
	"\x02Erreur du tunnel WireGuard\x02WireGuard : %[1]s\x02État : %[1]s\x02A" +
	"dresses : %[1]s\x02Mise à jour disponible!\x02WireGuard mise à jour est " +
	"disponible\x02Une mise à jour du WireGuard est disponible. Il est consei" +
	"llé de mettre votre WireGuard à jour dès que possible.\x02Tunnels\x02&Mo" +
	"difier\x02Ajouter un &tunnel vide…\x02Ajouter le tunnel\x02Supprimer le(" +
	"s) tunnel(s) sélectionné(s)\x02Exporter tous les tunnels vers zip\x02&Ba" +
	"sculer\x02Exporter tous les tunnels vers &zip…\x02Modifier &le tunnel sé" +
	"lectionné…\x02&Supprimer le(s) tunnel(s) sélectionné(s)\x02aucun fichier" +
	" de configuration trouvé\x02Impossible d'importer la configuration sélec" +
	"tionnée : %[1]v\x02Impossible d'énumérer les tunnels existantes : %[1]v" +
	"\x02Un tunnel nommé « %[1]s » existe déjà.\x02Impossible d'importer la c" +
	"onfiguration : %[1]v\x02Tunnels importés\x14\x01\x81\x01\x00\x02\x16\x02" +
	"%[1]d tunnel importé\x00\x18\x02%[1]d tunnels importés\x14\x02\x80\x01" +
	"\x02 \x02%[1]d de %[2]d tunnels importé\x00!\x02%[1]d de %[2]d tunnels i" +
	"mportés\x02Impossible de créer le tunnel\x14\x01\x81\x01\x00\x02\x17\x02" +
	"Supprimer %[1]d tunnel\x00\x18\x02Supprimer %[1]d tunnels\x14\x01\x81" +
	"\x01\x00\x02-\x02Voulez-vous vraiment supprimer %[1]d tunnel?\x00.\x02Vo" +
	"ulez-vous vraiment supprimer %[1]d tunnels?\x02Supprimer le tunnel ‘%[1]" +
	"s’\x02Voulez-vous vraiment supprimer le tunnel « %[1]s »?\x02%[1]s Vous " +
	"ne pouvez pas annuler cette action.\x02Impossible de supprimer le tunnel" +
	"\x02Il a été impossible de supprimer un tunnel : %[1]s\x02Impossible de " +
	"supprimer les tunnels\x14\x01\x81\x01\x00\x021\x02Il a été impossible de" +
	" supprimer %[1]d tunnel.\x002\x02Il a été impossible de supprimer %[1]d " +
	"tunnels.\x02Fichiers de configuration (*.zip, *.conf)|*.zip;*.conf|Tous " +
	"les fichiers (*.*)|*.*\x02Importer le(s) tunnel(s) à partir du fichier" +
	"\x02Fichiers de configuration ZIP (*.zip)|*.zip\x02Exporter les tunnels " +
	"vers zip\x02%[1]s (version non signée, aucune mise à jour)\x02Impossible" +
	" de quitter le service en raison de : %[1]v. Essayez d'arrêter WireGuard" +
	" à partir du gestionnair des services.\x02État: En attente de l’utilisat" +
	"eur\x02État: En attente du programme de mise à jour"

var idIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000a, 0x00000047, 0x00000062,
	0x00000074, 0x000000bf, 0x000000bf, 0x000000f0,
	0x00000148, 0x000001a1, 0x000001aa, 0x000001bd,
	0x000001dc, 0x000001ee, 0x000001ff, 0x00000212,
	0x00000225, 0x00000235, 0x0000023d, 0x00000249,
	0x00000255, 0x00000261, 0x0000026d, 0x0000027a,
	0x00000290, 0x000002ab, 0x000002cb, 0x000002e5,
	0x000002f5, 0x00000306, 0x00000327, 0x0000033d,
	// Entry 20 - 3F
	0x0000036f, 0x00000389, 0x000003a1, 0x000003b2,
	0x000003da, 0x000003fe, 0x00000401, 0x00000401,
	0x00000413, 0x00000413, 0x00000419, 0x00000426,
	0x0000042e, 0x0000042e, 0x0000042e, 0x0000042e,
	0x0000042e, 0x0000042e, 0x0000042e, 0x0000042e,
	0x0000042e, 0x0000042e, 0x0000042e, 0x0000042e,
	0x0000042e, 0x00000437, 0x00000445, 0x0000045c,
	0x00000464, 0x0000046a, 0x00000476, 0x00000493,
	// Entry 40 - 5F
	0x00000499, 0x000004a3, 0x000004bb, 0x000004d1,
	0x000004dd, 0x00000513, 0x00000526, 0x00000526,
	0x00000526, 0x00000526, 0x00000526, 0x00000526,
	0x0000055b, 0x00000581, 0x000005a9, 0x000005c6,
	0x000005c6, 0x000005e1, 0x0000060b, 0x00000630,
	0x00000655, 0x0000067f, 0x00000696, 0x000006bb,
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	// Entry 60 - 7F
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	0x000006bb, 0x000006bb, 0x000006bb, 0x000006bb,
	0x000006c1, 0x000006ce, 0x000006fe, 0x00000715,
	0x0000074a, 0x00000763, 0x0000077b, 0x0000078a,
	// Entry 80 - 9F
	0x0000079d, 0x000007b8, 0x000007c0, 0x000007c0,
	0x000007c0, 0x000007c0, 0x000007c0, 0x000007c0,
	0x000007d6, 0x000007e7, 0x000007f5, 0x000007f5,
	0x000007f5, 0x000007f5, 0x000007f5, 0x000007f5,
	0x000007f5, 0x000007f5, 0x000007f5, 0x000007f5,
	0x000007f5, 0x000007f5, 0x00000814, 0x0000082d,
	0x00000844, 0x00000844, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	// Entry A0 - BF
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	// Entry C0 - DF
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	// Entry E0 - FF
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	// Entry 100 - 11F
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a, 0x0000087a, 0x0000087a,
	0x0000087a, 0x0000087a,
} // Size: 1136 bytes

const idData string = "" + // Size: 2170 bytes
	"\x02Kesalahan\x02(tidak ada argumen): naikkan akses dan instal servis ma" +
	"najer\x02Penggunaan: %[1]s [\x0a%[2]s]\x02Opsi Command Line\x02Tidak dap" +
	"at menentukan apakah proses sedang berjalan di bawah WOW64: %[1]v\x02Tid" +
	"ak dapat membuka token proses saat ini: %[1]v\x02WireGuard hanya dapat d" +
	"igunakan oleh pengguna yang merupakan anggota grup Bawaan %[1]s.\x02Wire" +
	"Guard sedang berjalan, tetapi UI hanya dapat diakses dari desktop grup B" +
	"awaan %[1]s.\x02Sekarang\x02Jam sistem mundur!\x14\x01\x81\x01\x00\x00" +
	"\x18\x02%[1]d tahun\x0a%[1]d tahun\x14\x01\x81\x01\x00\x00\x0b\x02%[1]d " +
	"Hari\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d jam\x14\x01\x81\x01\x00\x00" +
	"\x0c\x02%[1]d menit\x14\x01\x81\x01\x00\x00\x0c\x02%[1]d detik\x02%[1]s " +
	"yang lalu\x02%[1]d B\x02%.2[1]f KiB\x02%.2[1]f MiB\x02%.2[1]f GiB\x02%.2" +
	"[1]f TiB\x02%[1]s: %[2]q\x02Alamat IP tidak valid\x02Network prefix tida" +
	"k valid\x02Port belum terisi dari endpoint\x02Host endpoint tidak valid" +
	"\x02MTU tidak valid\x02Port tidak valid\x02Persistent keepalive tidak va" +
	"lid\x02Kunci tidak sah:%[1]v\x02Nomor harus diantara 0 sampai dengan 2^6" +
	"4-1:%[1]v\x02Dua koma dalam satu baris\x02Nama Tunnel tidak valid\x02Tid" +
	"ak Ditetapkan\x02Semua peers harus memiliki kunci publik\x02Eror ketika " +
	"mendapatkan konfigurasi\x02, \x02Tentang WireGuard\x02Tutup\x02♥ &Donasi" +
	"!\x02Status:\x02Nonaktif\x02Menonaktifkan\x02Status tidak diketahui\x02C" +
	"atatan\x02Salin\x02Pilih semua\x02Menyimpan ke dalam berkas…\x02Waktu" +
	"\x02Pesan log\x02Ekspor log kedalam file\x02&Tentang WireGuard…\x02Tunne" +
	"l eror\x02%[1]s\x0a\x0aSilakan baca log untuk informasi lebih lanjut." +
	"\x02%[1]s (kadaluarsa)\x02Ikon sistem WireGuard tidak muncul setelah 30 " +
	"detik.\x02Dalam Kurung harus berisi alamat IPv6\x02Kunci harus diterjema" +
	"hkan tepat 32 byte\x02Garis harus muncul perbagian\x02Kunci harus memili" +
	"ki value\x02Kunci tidak valid pada bagian [Interface]\x02Kunci tidak val" +
	"id pada bagian [Peer]\x02Interface harus memiliki Private Key\x02Kunci t" +
	"idak valid pada bagian [Interface]\x02Versi protokol harus 1\x02Kunci ti" +
	"dak valid pada bagian [Peer]\x02Aktif\x02Mengaktifkan\x02Berkas Txt (*.T" +
	"xt)|*.Txt|Semua berkas (*.*)|*.*\x02Deteksi eror WireGuard\x02Tidak dapa" +
	"t menunggu jendela WireGuard muncul: %[1]v\x02WireGuard: Dinonaktifkan" +
	"\x02Status: Tidak diketahui\x02Alamat: Kosong\x02&Manajer Tunnel…\x02&Im" +
	"por tunnel dari file…\x02&Keluar\x02Wireguard Tunnel Eror\x02WireGuard: " +
	"%[1]s\x02Status: %[1]s\x02Ekspor semua tunnel ke &zip…\x02Ubah tunnel &t" +
	"erpilih…\x02&Hapus tunnel terpilih\x02Tidak dapat mengimpor konfigurasi " +
	"yang dipilih: %[1]v"

var itIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000044, 0x0000005d,
	0x00000075, 0x000000bd, 0x00000101, 0x0000013a,
	0x00000191, 0x00000202, 0x00000206, 0x0000022d,
	0x0000024c, 0x0000026f, 0x0000028c, 0x000002af,
	0x000002d4, 0x000002dd, 0x000002e6, 0x000002f3,
	0x00000300, 0x0000030d, 0x0000031a, 0x00000327,
	0x0000033f, 0x00000369, 0x00000386, 0x000003a4,
	0x000003b3, 0x000003c4, 0x000003e4, 0x000003fd,
	// Entry 20 - 3F
	0x0000043c, 0x00000454, 0x00000475, 0x00000487,
	0x000004b5, 0x000004e5, 0x000004e8, 0x000004ea,
	0x00000504, 0x00000523, 0x0000052a, 0x00000542,
	0x00000549, 0x00000554, 0x0000055c, 0x0000056d,
	0x0000057f, 0x00000584, 0x0000058f, 0x0000059b,
	0x000005b1, 0x000005c0, 0x000005ca, 0x000005e0,
	0x000005f5, 0x000005fe, 0x0000060d, 0x0000061f,
	0x00000623, 0x0000062a, 0x0000063b, 0x0000064d,
	// Entry 40 - 5F
	0x00000653, 0x00000664, 0x00000678, 0x00000696,
	0x000006a8, 0x000006db, 0x000006ec, 0x00000714,
	0x00000779, 0x00000786, 0x000007a3, 0x000007b4,
	0x00000808, 0x00000838, 0x0000086a, 0x00000897,
	0x000008da, 0x000008f9, 0x00000926, 0x0000094e,
	0x0000097b, 0x000009ad, 0x000009d6, 0x000009fc,
	0x00000a04, 0x00000a13, 0x00000a1a, 0x00000a22,
	0x00000a2b, 0x00000a35, 0x00000a4f, 0x00000a59,
	// Entry 60 - 7F
	0x00000a77, 0x00000aaa, 0x00000ace, 0x00000af5,
	0x00000b08, 0x00000b0d, 0x00000b19, 0x00000b29,
	0x00000b30, 0x00000b42, 0x00000b50, 0x00000b80,
	0x00000b87, 0x00000b8f, 0x00000ba0, 0x00000bb0,
	0x00000bc6, 0x00000bf4, 0x00000c1c, 0x00000c32,
	0x00000c67, 0x00000c92, 0x00000cb2, 0x00000ce9,
	0x00000cf0, 0x00000cfc, 0x00000d2f, 0x00000d52,
	0x00000d97, 0x00000dae, 0x00000dc1, 0x00000dd4,
	// Entry 80 - 9F
	0x00000dea, 0x00000e05, 0x00000e0b, 0x00000e13,
	0x00000e26, 0x00000e49, 0x00000e5f, 0x00000e85,
	0x00000ea0, 0x00000eb1, 0x00000ebe, 0x00000ecf,
	0x00000ef0, 0x00000f17, 0x00000f76, 0x00000f7d,
	0x00000f87, 0x00000fa1, 0x00000fb1, 0x00000fcc,
	0x00000fea, 0x00000ff3, 0x00001015, 0x00001038,
	0x00001056, 0x0000107c, 0x000010b7, 0x000010e7,
	0x0000111b, 0x0000114a, 0x0000115b, 0x00001192,
	// Entry A0 - BF
	0x000011da, 0x000011f7, 0x0000122a, 0x0000128b,
	0x000012a6, 0x000012db, 0x0000130b, 0x0000132b,
	0x0000135d, 0x0000137c, 0x000013e3, 0x0000142e,
	0x00001445, 0x0000146e, 0x00001484, 0x000014b7,
	0x00001529, 0x00001546, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	// Entry C0 - DF
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	// Entry E0 - FF
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	// Entry 100 - 11F
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575, 0x00001575, 0x00001575,
	0x00001575, 0x00001575,
} // Size: 1136 bytes

const itData string = "" + // Size: 5493 bytes
	"\x02Errore\x02(nessun argomento): eleva e installa il servizio di gestio" +
	"ne\x02Utilizzo: %[1]s [\x0a%[2]s]\x02Opzioni riga di comando\x02Impossib" +
	"ile determinare se il processo è in esecuzione in WOW64: %[1]v\x02Devi u" +
	"tilizzare la versione nativa di WireGuard su questo computer.\x02Impossi" +
	"bile aprire il token del processo corrente: %[1]v\x02WireGuard può esser" +
	"e utilizzato solo dagli utenti membri del gruppo %[1]s di sistema.\x02Wi" +
	"reGuard è in esecuzione, ma l'interfaccia utente è accessibile solo dai " +
	"desktop del gruppo %[1]s di sistema.\x02Ora\x02L'orologio di sistema va " +
	"all'indietro!\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d anno\x00\x0b\x02%[1]d" +
	" anni\x14\x01\x81\x01\x00\x02\x0d\x02%[1]d giorno\x00\x0d\x02%[1]d giorn" +
	"i\x14\x01\x81\x01\x00\x02\x0a\x02%[1]d ora\x00\x0a\x02%[1]d ore\x14\x01" +
	"\x81\x01\x00\x02\x0d\x02%[1]d minuto\x00\x0d\x02%[1]d minuti\x14\x01\x81" +
	"\x01\x00\x02\x0e\x02%[1]d secondo\x00\x0e\x02%[1]d secondi\x02%[1]s fa" +
	"\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f" +
	"\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Indirizzo IP non valido" +
	"\x02Lunghezza del prefisso di rete non valida\x02Manca la porta dall'end" +
	"point\x02Host dell'endpoint non valido\x02MTU non valido\x02Porta non va" +
	"lida\x02Keepalive permanente non valido\x02Chiave non valida: %[1]v\x02I" +
	"l numero deve essere un numero compreso tra 0 e 2^64-1: %[1]v\x02Due vir" +
	"gole in una riga\x02Il nome del tunnel non è valido\x02[non specificato]" +
	"\x02Tutti i peer devono avere una chiave pubblica\x02Errore durante il r" +
	"ecupero della configurazione\x02, \x02 \x02Informazioni su WireGuard\x02" +
	"Immagine del logo di WireGuard\x02Chiudi\x02♥ Fai una &donazione!\x02Sta" +
	"to:\x02&Disattiva\x02&Attiva\x02Chiave pubblica:\x02Porta in ascolto:" +
	"\x02MTU:\x02Indirizzi:\x02Server DNS:\x02Chiave pre-condivisa:\x02IP con" +
	"sentiti:\x02Endpoint:\x02Keepalive permanente:\x02Ultima negoziazione:" +
	"\x02Inattivo\x02Disattivazione\x02Stato sconosciuto\x02Log\x02&Copia\x02" +
	"Selezion&a tutto\x02&Salva su file…\x02Tempo\x02Messaggio di log\x02Espo" +
	"rta log su file\x02Inform&azioni su WireGuard…\x02Errore del tunnel\x02%" +
	"[1]s\x0a\x0aConsulta il log per ulteriori Informazioni.\x02%[1]s (obsole" +
	"to)\x02Errore durante la chiusura di WireGuard\x02Un aggiornamento di Wi" +
	"reGuard è disponibile. Ti consigliamo vivamente di aggiornare immediatam" +
	"ente.\x02Aggiorna ora\x02Errore: %[1]v. Prova ancora.\x02Stato: Completo" +
	"!\x02L'icona della barra delle applicazioni di WireGuard non è apparsa d" +
	"opo 30 secondi.\x02Le parentesi devono contenere un indirizzo IPv6\x02Le" +
	" chiavi devono decodificare esattamente 32 byte\x02Una riga deve essere " +
	"presente in una sezione\x02Manca un separatore di uguaglianza per la chi" +
	"ave di configurazione\x02La chiave deve avere un valore\x02Chiave non va" +
	"lida per la sezione [Interface]\x02Chiave non valida per la sezione [Pee" +
	"r]\x02Un'interfaccia deve avere una chiave privata\x02Chiave non valida " +
	"per la sezione dell'interfaccia\x02La versione del protocollo deve esser" +
	"e 1\x02Chiave non valida per la sezione peer\x02Script:\x02Trasferimento" +
	":\x02pre-up\x02post-up\x02pre-down\x02post-down\x02disattivato, per crit" +
	"erio\x02abilitato\x02%[1]s ricevuti, %[2]s inviati\x02Determinazione del" +
	"lo stato del tunnel non riuscita\x02Attivazione del tunnel non riuscita" +
	"\x02Disattivazione del tunnel non riuscita\x02Interfaccia: %[1]s\x02Peer" +
	"\x02Crea tunnel\x02Modifica tunnel\x02&Nome:\x02Chiave &pubblica:\x02(sc" +
	"onosciuto)\x02&Blocca traffico fuori dal tunnel (kill-switch)\x02&Salva" +
	"\x02Annulla\x02&Configurazione:\x02Nome non valido\x02Un nome è richiest" +
	"o.\x02Il nome del tunnel ‘%[1]s’ non è valido.\x02Impossibile elencare i" +
	" tunnel esistenti\x02Il tunnel esiste già\x02Un altro tunnel con il nome" +
	" ‘%[1]s’ esiste già.\x02Impossibile creare la nuova configurazione\x02Sc" +
	"rittura del file non riuscita\x02Il file ‘%[1]s’ esiste già.\x0a\x0aVuoi" +
	" sovrascriverlo?\x02Attivo\x02Attivazione\x02File di testo (*.txt)|*.txt" +
	"|Tutti i file (*.*)|*.*\x02Errore di rilevamento di WireGuard\x02Impossi" +
	"bile attendere la comparsa della finestra di WireGuard: %[1]v\x02WireGua" +
	"rd: disattivato\x02Stato: sconosciuto\x02Indirizzi: nessuno\x02&Gestisci" +
	" i tunnel…\x02&Importa tunnel da file…\x02E&sci\x02&Tunnel\x02WireGuard " +
	"attivato\x02Il tunnel %[1]s è stato attivato.\x02WireGuard disattivato" +
	"\x02Il tunnel %[1]s è stato disattivato.\x02Errore tunnel di WireGuard" +
	"\x02WireGuard: %[1]s\x02Stato: %[1]s\x02Indirizzi: %[1]s\x02Un aggiornam" +
	"ento è disponibile!\x02Aggiornamento di WireGuard disponibile\x02Un aggi" +
	"ornamento di WireGuard è disponibile. Ti consigliamo di aggiornare il pr" +
	"ima possibile.\x02Tunnel\x02&Modifica\x02Aggiungi tunn&el vuoto...\x02Ag" +
	"giungi tunnel\x02Rimuovi tunnel selezionati\x02Esporta tutti i tunnel in" +
	" zip\x02Commu&ta\x02Esporta tutti i tunnel in &zip...\x02Modifica il tun" +
	"nel &selezionato…\x02&Rimuovi i tunnel selezionati\x02nessun file di con" +
	"figurazione trovato\x02Impossibile importare la configurazione seleziona" +
	"ta: %[1]v\x02Impossibile enumerare i tunnel esistenti: %[1]v\x02Un altro" +
	" tunnel esiste già con il nome ‘%[1]s‘\x02Impossibile importare la confi" +
	"gurazione: %[1]v\x02Tunnel importati\x14\x01\x81\x01\x00\x02\x17\x02%[1]" +
	"d tunnel importato\x00\x17\x02%[1]d tunnel importati\x14\x02\x80\x01\x02" +
	" \x02%[1]d de %[2]d tunnel importato\x00 \x02%[1]d di %[2]d tunnel impor" +
	"tati\x02Impossibile creare il tunnel\x14\x01\x81\x01\x00\x02\x15\x02Elim" +
	"ina %[1]d tunnel\x00\x15\x02Elimina %[1]d tunnel\x14\x01\x81\x01\x00\x02" +
	",\x02Sei sicuro di voler eliminare %[1]d tunnel?\x00,\x02Sei sicuro di v" +
	"oler eliminare %[1]d tunnel?\x02Elimina tunnel ‘%[1]s‘\x02Sei sicuro di " +
	"voler eliminare il tunnel ‘%[1]s‘?\x02%[1]s Non è possibile annullare qu" +
	"esta azione.\x02Impossibile eliminare il tunnel\x02Non è stato possibile" +
	" rimuovere un tunnel: %[1]s\x02Impossibile eliminare i tunnel\x14\x01" +
	"\x81\x01\x00\x02/\x02Non è stato possibile eliminare %[1]d tunnel.\x00/" +
	"\x02Non è stato possibile eliminare %[1]d tunnel.\x02File di configurazi" +
	"one (*.zip, *.conf)|*.zip;*.conf|Tutti i file (*.*)|*.*\x02Importa tunne" +
	"l da file\x02File di configurazione ZIP (*.zip)|*.zip\x02Esporta tunnel " +
	"in zip\x02%[1]s (versione non firmata, nessun aggiornamento)\x02Impossib" +
	"ile uscire dal servizio a causa di: %[1]v. Potresti voler interrompere W" +
	"ireGuard dal gestore dei servizi.\x02Stato: in attesa dell'utente\x02Sta" +
	"to: in attesa del servizio di aggiornamento"

var jaIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000a, 0x0000005b, 0x00000075,
	0x0000009a, 0x000000e6, 0x00000140, 0x0000017e,
	0x000001d5, 0x00000258, 0x0000025c, 0x00000284,
	0x00000295, 0x000002a6, 0x000002ba, 0x000002cb,
	0x000002dc, 0x000002e6, 0x000002ee, 0x000002fb,
	0x00000308, 0x00000315, 0x00000322, 0x0000032f,
	0x00000349, 0x0000037d, 0x000003ab, 0x000003d3,
	0x000003e1, 0x000003fa, 0x00000425, 0x00000439,
	// Entry 20 - 3F
	0x0000048c, 0x000004b0, 0x000004cf, 0x000004de,
	0x0000050f, 0x00000543, 0x00000546, 0x00000548,
	0x0000055f, 0x00000576, 0x00000580, 0x0000059c,
	0x000005a4, 0x000005b2, 0x000005c0, 0x000005cb,
	0x000005e2, 0x000005e7, 0x000005f5, 0x00000604,
	0x00000615, 0x00000622, 0x00000639, 0x00000659,
	0x00000679, 0x00000680, 0x0000068d, 0x0000069d,
	0x000006a4, 0x000006b2, 0x000006c6, 0x000006e3,
	// Entry 40 - 5F
	0x000006ea, 0x00000701, 0x0000072c, 0x00000749,
	0x0000075f, 0x00000794, 0x000007a9, 0x000007c3,
	0x00000828, 0x00000838, 0x0000086d, 0x0000087f,
	0x000008d4, 0x00000905, 0x00000937, 0x00000962,
	0x00000999, 0x000009ca, 0x000009ff, 0x00000a2f,
	0x00000a66, 0x00000a99, 0x00000adc, 0x00000b0a,
	0x00000b1b, 0x00000b23, 0x00000b2a, 0x00000b32,
	0x00000b3b, 0x00000b45, 0x00000b67, 0x00000b6e,
	// Entry 60 - 7F
	0x00000b96, 0x00000bc7, 0x00000bf5, 0x00000c23,
	0x00000c43, 0x00000c4a, 0x00000c66, 0x00000c7c,
	0x00000c88, 0x00000c97, 0x00000ca0, 0x00000cf9,
	0x00000d04, 0x00000d14, 0x00000d20, 0x00000d30,
	0x00000d49, 0x00000d78, 0x00000da6, 0x00000dce,
	0x00000e1d, 0x00000e4e, 0x00000e73, 0x00000ec5,
	0x00000ecc, 0x00000ed9, 0x00000f23, 0x00000f3d,
	0x00000f7f, 0x00000f9a, 0x00000fa9, 0x00000fbe,
	// Entry 80 - 9F
	0x00000fdb, 0x00001013, 0x0000101e, 0x0000102d,
	0x00001047, 0x00001079, 0x00001093, 0x000010c5,
	0x000010e5, 0x000010f6, 0x00001104, 0x00001118,
	0x00001137, 0x00001160, 0x000011c8, 0x000011d5,
	0x000011e0, 0x00001203, 0x00001219, 0x0000123b,
	0x0000126f, 0x00001280, 0x000012bb, 0x000012e4,
	0x0000130a, 0x00001335, 0x00001382, 0x000013c0,
	0x0000140c, 0x00001444, 0x00001469, 0x000014a1,
	// Entry A0 - BF
	0x000014e5, 0x0000150a, 0x0000152d, 0x00001569,
	0x0000158c, 0x000015c7, 0x000015f8, 0x0000161d,
	0x00001652, 0x00001677, 0x000016b2, 0x00001705,
	0x00001736, 0x00001760, 0x00001788, 0x000017be,
	0x00001842, 0x0000186c, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	// Entry C0 - DF
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	// Entry E0 - FF
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	// Entry 100 - 11F
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f, 0x0000189f, 0x0000189f,
	0x0000189f, 0x0000189f,
} // Size: 1136 bytes

const jaData string = "" + // Size: 6303 bytes
	"\x02エラー\x02(引数なし): 管理者権限でmanagerサービスをインストールする\x02使い方: %[1]s [\x0a%[2]s]" +
	"\x02コマンドラインオプション\x02プロセスがWOW64下で動作しているか確認できません: %[1]v\x02このコンピュータではネイティブ" +
	"版の WireGuard を使ってください。\x02現在のプロセスのトークンを開けません: %[1]v\x02WireGuard は組み込み" +
	"の %[1]s グループのメンバーだけが使えます。\x02WireGuard は実行中ですが、UI画面は組み込みの %[1]s グループのデ" +
	"スクトップからしか開けません。\x02今\x02システム時刻が巻き戻った！\x14\x01\x81\x01\x00\x00\x0a\x02%" +
	"[1]d 年\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 日\x14\x01\x81\x01\x00\x00" +
	"\x0d\x02%[1]d 時間\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 分\x14\x01\x81\x01" +
	"\x00\x00\x0a\x02%[1]d 秒\x02%[1]s 前\x02%[1]d B\x02%.2[1]f\u00a0KiB\x02%.2" +
	"[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q" +
	"\x02無効な IP アドレス\x02無効なネットワークプレフィックス長\x02エンドポイントのポート指定なし\x02無効なエンドポイントホスト" +
	"\x02無効な MTU\x02無効なポート番号\x02無効な持続的キープアライブ値\x02不正な鍵: %[1]v\x02数値は0から2の64乗-" +
	"1の範囲内の値でなければなりません: %[1]v\x021行にカンマが2つあります\x02トンネル名が不正です\x02[指定なし]\x02すべて" +
	"のピアには公開鍵が必須です\x02設定の読込中にエラーが発生しました\x02, \x02 \x02WireGuard について\x02Wir" +
	"eGuard ロゴ画像\x02閉じる\x02♥ 寄付のお願い!(&D)\x02状態:\x02無効化(&D)\x02有効化(&A)\x02公開鍵:" +
	"\x02待受ポート番号:\x02MTU:\x02アドレス:\x02DNS サーバ:\x02事前共有鍵:\x02Allowed IPs:\x02エ" +
	"ンドポイント:\x02持続的キープアライブ:\x02直近のハンドシェイク:\x02無効\x02無効化中\x02不明な状態\x02ログ\x02" +
	"コピー(&C)\x02すべて選択(&A)\x02ファイルに保存…(&S)\x02時刻\x02ログ メッセージ\x02ログをファイルにエクスポ" +
	"ート\x02WireGuardについて…(&A)\x02トンネルエラー\x02%[1]s\x0a\x0a詳細はログを参照してください。" +
	"\x02%[1]s (更新あり)\x02WireGuard 終了エラー\x02WireGuard の更新が利用可能です。速やかに更新することを強" +
	"く推奨します。\x02今すぐ更新\x02エラー: %[1]v。再度実行してください。\x02状態: 完了！\x02WireGuard システ" +
	"ムトレイアイコンは30秒後に非表示になります。\x02カッコ内は IPv6 アドレスが入ります\x02鍵は 32 バイトでなければなりません" +
	"\x02行がセクション内にありません\x02設定項目にイコール(=)セパレータがない\x02キー項目に対応する値がありません\x02無効な [I" +
	"nterface] セクションのキー項目\x02無効な [Peer] セクションのキー項目\x02インターフェースには秘密鍵が必須です\x02無" +
	"効な Interface セクションのキー項目\x02プロトコルバージョンは 1 でなければなりません\x02無効な Peer セクションの" +
	"キー項目\x02スクリプト:\x02転送:\x02pre-up\x02post-up\x02pre-down\x02post-down" +
	"\x02ポリシーにより無効です\x02有効\x02%[1]s 受信済み、%[2]s 送信済み\x02トンネルの状態取得に失敗しました\x02トン" +
	"ネルの有効化に失敗しました\x02トンネルの無効化に失敗しました\x02インターフェース: %[1]s\x02ピア\x02トンネルの新規作成" +
	"\x02トンネルの編集\x02名前(&N):\x02公開鍵(&P):\x02(不明)\x02トンネルを通らないトラフィックのブロック（キルスイッ" +
	"チ）(&B)\x02保存(&S)\x02キャンセル\x02設定(&C):\x02無効な名前\x02名前は必須です。\x02トンネル名 ‘%[" +
	"1]s’ は不正です。\x02既存のトンネルを表示できません\x02トンネルはすでに存在します\x02‘%[1]s’ という名前の別のトンネルが" +
	"すでに存在します。\x02新しい設定を作成できませんでした\x02ファイルの書き込みに失敗\x02ファイル ‘%[1]s’ はすでに存在しま" +
	"す。\x0a\x0a上書きしますか？\x02有効\x02有効化中\x02テキストファイル (*.txt)|*.txt|すべてのファイル (*" +
	".*)|*.*\x02WireGuard 検出エラー\x02WireGuard ウィンドウが表示できませんでした: %[1]v\x02WireG" +
	"uard: 無効化済み\x02状態: 不明\x02アドレス: なし\x02トンネルの管理…(&M)\x02トンネルをファイルからインポート…(&" +
	"I)\x02終了(&X)\x02& トンネル\x02WireGuard 有効化済み\x02トンネル %[1]s は有効になりました。\x02Wi" +
	"reGuard 無効化済み\x02トンネル %[1]s は無効になりました。\x02WireGuard トンネルエラー\x02WireGuard" +
	": %[1]s\x02状態: %[1]s\x02アドレス: %[1]s\x02更新が利用できます！\x02WireGuard の更新が利用可能で" +
	"す\x02WireGuard の更新が利用可能になりました。できるだけ早く更新してください。\x02トンネル\x02編集(&E)\x02空の" +
	"トンネルを追加…(&E)\x02トンネルの追加\x02選択したトンネルの削除\x02すべてのトンネルをzipにエクスポート\x02切り替え(" +
	"&T)\x02すべてのトンネルをzipにエクスポート…(&Z)\x02選択したトンネルの編集…(&S)\x02選択したトンネルの削除(&R)" +
	"\x02設定ファイルが見つかりません\x02選択したファイルからインポートできませんでした: %[1]v\x02既存のトンネルを表示できませんで" +
	"した: %[1]v\x02‘%[1]s’ という名前の別のトンネルがすでに存在します\x02設定をインポートできませんでした: %[1]v" +
	"\x02トンネルのインポート結果\x14\x01\x81\x01\x00\x001\x02%[1]d トンネルをインポートしました\x14" +
	"\x02\x80\x01\x00>\x02%[2]d 中の %[1]d トンネルをインポートしました\x02トンネルを作成できません\x14" +
	"\x01\x81\x01\x00\x00\x1c\x02%[1]d トンネルを削除\x14\x01\x81\x01\x00\x005\x02本当" +
	"に %[1]d トンネルを削除しますか？\x02トンネル ‘%[1]s’ を削除\x02本当にトンネル ‘%[1]s’ を削除しますか？" +
	"\x02%[1]s この操作はもとに戻せません。\x02トンネルを削除できません\x02トンネルを削除できませんでした: %[1]s\x02トン" +
	"ネルを削除できません\x14\x01\x81\x01\x00\x004\x02%[1]d トンネルを削除できませんでした\x02設定ファイル" +
	" (*.zip, *.conf)|*.zip;*.conf|すべてのファイル (*.*)|*.*\x02ファイルからトンネルをインポート\x02" +
	"ZIP形式設定ファイル (*.zip)|*.zip\x02トンネルをZIPにエクスポート\x02%[1]s (未署名のビルド、更新の提供なし)" +
	"\x02%[1]v のためサービスを終了できませんでした。サービスマネージャから WireGuard を停止できます。\x02状態: ユーザーか" +
	"らの応答待ち\x02状態: アップデータサービスを待機中"

var koIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 20 - 3F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 40 - 5F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 60 - 7F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 80 - 9F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry A0 - BF
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry C0 - DF
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry E0 - FF
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	// Entry 100 - 11F
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007, 0x00000007, 0x00000007,
	0x00000007, 0x00000007,
} // Size: 1136 bytes

const koData string = "\x02오류"

var pa_INIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000010, 0x00000010, 0x00000030,
	0x0000005d, 0x000000ea, 0x0000017f, 0x000001e6,
	0x000002b4, 0x0000039c, 0x000003a6, 0x000003e8,
	0x00000411, 0x0000043a, 0x00000469, 0x00000498,
	0x000004cd, 0x000004e6, 0x000004ef, 0x000004fc,
	0x00000509, 0x00000516, 0x00000523, 0x00000530,
	0x00000559, 0x00000599, 0x000005e0, 0x000005e0,
	0x000005fe, 0x00000625, 0x00000654, 0x00000685,
	// Entry 20 - 3F
	0x000006ed, 0x0000072c, 0x00000765, 0x00000765,
	0x00000765, 0x00000765, 0x00000768, 0x0000076b,
	0x00000791, 0x00000791, 0x000007a5, 0x000007c2,
	0x000007d3, 0x000007f8, 0x00000816, 0x00000837,
	0x0000085f, 0x00000864, 0x0000087b, 0x0000088d,
	0x0000088d, 0x000008ae, 0x000008cc, 0x000008cc,
	0x000008cc, 0x000008e3, 0x00000922, 0x00000948,
	0x00000955, 0x00000970, 0x0000098e, 0x000009c5,
	// Entry 40 - 5F
	0x000009d2, 0x000009ef, 0x00000a30, 0x00000a5d,
	0x00000a74, 0x00000aa8, 0x00000abc, 0x00000afe,
	0x00000bda, 0x00000c04, 0x00000c45, 0x00000c64,
	0x00000cf5, 0x00000cf5, 0x00000d6f, 0x00000dba,
	0x00000dba, 0x00000dba, 0x00000dba, 0x00000dba,
	0x00000dba, 0x00000dba, 0x00000dba, 0x00000dba,
	0x00000dd7, 0x00000dee, 0x00000dee, 0x00000dee,
	0x00000dee, 0x00000dee, 0x00000dee, 0x00000e05,
	// Entry 60 - 7F
	0x00000e2c, 0x00000e77, 0x00000eb9, 0x00000f02,
	0x00000f1f, 0x00000f2c, 0x00000f50, 0x00000f71,
	0x00000f80, 0x00000fa5, 0x00000fbd, 0x00001034,
	0x0000104b, 0x0000105f, 0x00001077, 0x0000108e,
	0x000010b5, 0x000010b5, 0x000010b5, 0x000010f0,
	0x0000114e, 0x0000119f, 0x000011dd, 0x00001287,
	0x00001297, 0x000012cf, 0x00001333, 0x00001357,
	0x00001357, 0x00001395, 0x000013bc, 0x000013ed,
	// Entry 80 - 9F
	0x00001428, 0x00001473, 0x00001484, 0x00001492,
	0x000014c8, 0x00001506, 0x00001543, 0x00001588,
	0x000015b8, 0x000015d8, 0x000015ef, 0x0000160f,
	0x0000163a, 0x0000167d, 0x00001773, 0x00001783,
	0x00001794, 0x000017bf, 0x000017d6, 0x00001810,
	0x00001871, 0x00001882, 0x000018e6, 0x00001911,
	0x0000194f, 0x000019a2, 0x000019a2, 0x000019a2,
	0x00001a07, 0x00001a58, 0x00001a8e, 0x00001b03,
	// Entry A0 - BF
	0x00001b03, 0x00001b37, 0x00001b80, 0x00001c53,
	0x00001c80, 0x00001ce8, 0x00001d50, 0x00001d84,
	0x00001dc6, 0x00001e00, 0x00001e00, 0x00001e79,
	0x00001ebd, 0x00001efe, 0x00001efe, 0x00001efe,
	0x00001fd2, 0x00002032, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	// Entry C0 - DF
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	// Entry E0 - FF
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	// Entry 100 - 11F
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c, 0x0000209c, 0x0000209c,
	0x0000209c, 0x0000209c,
} // Size: 1136 bytes

const pa_INData string = "" + // Size: 8348 bytes
	"\x02ਗ਼ਲਤੀ\x02ਵਰਤੋਂ: %[1]s [\x0a%[2]s]\x02ਕਮਾਂਡ ਲਾਈਨ ਚੋਣਾਂ\x02ਪਤਾ ਲਗਾਉਣ ਲ" +
	"ਈ ਅਸਮਰੱਥ ਹੈ ਕਿ ਪਰੋਸੈਸ WOW64 ਅਧੀਨ ਚੱਲ ਰਿਹਾ ਹੈ: %[1]v\x02ਤੁਹਾਨੂੰ ਇਸ ਕੰਪਿ" +
	"ਊਟਰ ਉੱਤੇ WireGuard ਦਾ ਮੂਲ ਵਰਜ਼ਨ ਵਰਤਣਾ ਚਾਹੀਦਾ ਹੈ।\x02ਮੌਜੂਦਾ ਪਰੋਸੈਸ ਟੋਕਨ " +
	"ਖੋਲ੍ਹਣ ਲਈ ਅਸਮਰੱਥ: %[1]v\x02WireGuard ਨੂੰ ਸਿਰਫ਼ ਉਹੀ ਵਰਤੋਂਕਾਰ ਵਰਤ ਸਕਦੇ ਹ" +
	"ਨ, ਜੋ ਕਿ ਪਹਿਲਾਂ ਮੌਜੂਦ %[1]s ਗਰੁੱਪ ਦੇ ਮੈਂਬਰ ਹਨ।\x02WireGuard ਚੱਲ ਰਿਹਾ ਹ" +
	"ੈ, ਪਰ UI ਨੂੰ ਸਿਰਫ਼ ਪਹਿਲਾਂ ਮੌਜੂਦ %[1]s ਗਰੁੱਪ ਦੇ ਡੈਸਕਟਾਪ ਰਾਹੀਂ ਹੀ ਵਰਤਿਆ " +
	"ਜਾ ਸਕਦਾ ਹੈ।\x02ਹੁਣ\x02ਸਿਸਟਮ ਘੜੀ ਪੁ਼ੱਠੀ ਮੋੜੀ ਗਈ!\x14\x01\x81\x01\x00" +
	"\x02\x10\x02%[1]d ਸਾਲ\x00\x10\x02%[1]d ਸਾਲ\x14\x01\x81\x01\x00\x02\x10" +
	"\x02%[1]d ਦਿਨ\x00\x10\x02%[1]d ਦਿਨ\x14\x01\x81\x01\x00\x02\x13\x02%[1]d " +
	"ਘੰਟਾ\x00\x13\x02%[1]d ਘੰਟੇ\x14\x01\x81\x01\x00\x02\x13\x02%[1]d ਮਿੰਟ" +
	"\x00\x13\x02%[1]d ਮਿੰਟ\x14\x01\x81\x01\x00\x02\x16\x02%[1]d ਸਕਿੰਟ\x00" +
	"\x16\x02%[1]d ਸਕਿੰਟ\x02%[1]s ਪਹਿਲਾਂ\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB" +
	"\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %" +
	"[2]q\x02ਅਵੈਧ IP ਸਿਰਨਾਵਾਂ\x02ਗਲਤ ਨੈੱਟਵਰਕ ਅਗੇਤਰ ਲੰਬਾਈ\x02ਐਂਡਪੁਆਇੰਟ ਤੋਂ ਪੋਰ" +
	"ਟ ਗੁੰਮ ਹੈ\x02ਗ਼ੈਰ-ਵਾਜਬ MTU\x02ਗ਼ੈਰ-ਵਾਜਬ ਪੋਰਟ\x02ਗ਼ੈਰ-ਵਾਜਬ persistent k" +
	"eepalive\x02ਗ਼ੈਰ-ਵਾਜਬ ਕੁੰਜੀ: %[1]v\x02ਨੰਬਰ 0 ਅਤੇ 2^64-1 ਦੇ ਵਿਚਾਲੇ ਹੋਣਾ ਚ" +
	"ਾਹੀਦਾ ਹੈ: %[1]v\x02ਇੱਕ ਕਤਾਰ ਵਿੱਚ ਦੋ ਕੌਮੇ ਹਨ\x02ਟਨਲ ਦਾ ਨਾਂ ਠੀਕ ਨਹੀਂ ਹੈ" +
	"\x02, \x02, \x02ਵਾਇਰਗਾਰਡ ਬਾਰੇ\x02ਬੰਦ ਕਰੋ\x02♥ ਦਾਨ ਦਿਓ(&D)!\x02ਸਥਿਤੀ:\x02" +
	"ਨਾ-ਸਰਗਰਮ ਕਰੋ(&D)\x02ਸਰਗਰਮ ਕਰੋ(&A)\x02ਪਬਲਿਕ ਕੁੰਜੀ:\x02ਸੁਣਨ ਵਾਲੀ ਪੋਰਟ:" +
	"\x02MTU:\x02ਸਿਰਨਾਵੇ:\x02DNS ਸਰਵਰ:\x02ਮਨਜ਼ੂਰ ਕੀਤੇ IP:\x02ਐਂਡ-ਪੁਆਇੰਟ:\x02ਨਾ" +
	"-ਸਰਗਰਮ\x02ਨਾ-ਸਰਗਰਮ ਕੀਤਾ ਜਾ ਰਿਹਾ ਹੈ\x02ਅਣਪਛਾਤੀ ਸਥਿਤੀ\x02ਲਾਗੂ\x02ਕਾਪੀ ਕਰੋ(" +
	"&C)\x02ਸਾਰੇ ਚੁਣੋ(&a)\x02ਫ਼ਾਇਲ ਵਿੱਚ ਸੰਭਾਲੋ(&S)…\x02ਸਮਾਂ\x02ਲਾਗ ਸੁਨੇਹਾ\x02" +
	"ਲਾਗ ਫ਼ਾਇਲ ਵਿੱਚ ਬਰਾਮਦ ਕਰੋ\x02ਵਾਇਰਗਾਰਡ ਬਾਰੇ(&A)…\x02ਟਨਲ ਗਲਤੀ\x02%[1]s" +
	"\x0a\x0aPlease consult the log for more information.\x02%[1]s (out of da" +
	"te)\x02WireGuard ਤੋਂ ਬਾਹਰ ਜਾਣ ਲਈ ਗ਼ਲਤੀ\x02WireGuard ਲਈ ਅੱਪਡੇਟ ਮੌਜੂਦ ਹੈ। " +
	"ਤੁਹਾਨੂੰ ਬਿਨਾਂ ਦੇਰ ਕੀਤਿਆਂ ਅੱਪਡੇਟ ਕਰਨ ਦੀ ਸਲਾਹ ਦਿੱਤੀ ਜਾਂਦੀ ਹੈ।\x02ਹੁਣੇ ਅੱ" +
	"ਪਡੇਟ ਕਰੋ\x02ਗ਼ਲਤੀ: %[1]v। ਫੇਰ ਕੋਸ਼ਿਸ਼ ਕਰੋ।\x02ਸਥਿਤੀ: ਪੂਰਾ!\x02WireGuard " +
	"ਸਿਸਟਮ ਟਰੇ ਆਈਕਾਨ 30 ਸਕਿੰਟਾਂ ਬਾਅਦ ਦਿਖਾਈ ਨਹੀਂ ਦਿੱਤਾ ਹੈ।\x02ਕੁੰਜੀਆਂ ਠੀਕ 32" +
	" ਬਾਈਟ ਲਈ ਡੀਕੋਡ ਹੋਣੀਆਂ ਚਾਹੀਦੀਆਂ ਹਨ\x02ਭਾਗ ਵਿੱਚ ਲਾਈਨ ਹੋਣੀ ਚਾਹੀਦੀ ਹੈ\x02ਸਕ੍" +
	"ਰਿਪਟਾਂ:\x02ਟਰਾਂਸਫਰ:\x02ਸਮਰੱਥ ਹੈ\x02%[1]s ਮਿਲੇ, %[2]s ਭੇਜੇ\x02ਟਨਲ ਸਥਿਤੀ" +
	" ਪਤਾ ਲਗਾਉਣ ਲਈ ਅਸਫ਼ਲ\x02ਟਨਲ ਸਰਗਰਮ ਕਰਨ ਲਈ ਅਸਫ਼ਲ ਹੈ\x02ਟਨਲ ਨਾ-ਸਰਗਰਮ ਕਰਨ ਲਈ " +
	"ਅਸਫ਼ਲ ਹੈ\x02ਇੰਟਰਫੇਸ: %[1]s\x02ਪੀਅਰ\x02ਨਵੀਂ ਟਨਲ ਬਣਾਓ\x02ਟਨਲ ਨੂੰ ਸੋਧੋ" +
	"\x02ਨਾਂ(&N):\x02ਪਬਲਿਕ ਕੁੰਜੀ(&P):\x02(ਅਣਪਛਾਤਾ)\x02ਬਿਨਾਂ-ਟਨਲ ਵਾਲੇ ਟਰੈਫਿਕ ਉ" +
	"ੱਤੇ ਪਾਬੰਦੀ ਲਾਓ (&B) (kill-switch)\x02ਸੰਭਾਲੋ(&S)\x02ਰੱਦ ਕਰੋ\x02ਸੰਰਚਨਾ(&" +
	"C):\x02ਅਯੋਗ ਨਾਂ\x02ਨਾਂ ਚਾਹੀਦਾ ਹੈ।\x02ਟਨਲ ਪਹਿਲਾਂ ਹੀ ਮੌਜੂਦ ਹੈ\x02ਨਾਂ ‘%[1]" +
	"s’ ਨਾਲ ਟਨਲ ਪਹਿਲਾਂ ਹੀ ਮੌਜੂਦ ਹੈ।\x02ਨਵੀਂ ਸੰਰਚਨਾ ਬਣਾਉਣ ਲਈ ਅਸਮਰੱਥ ਹੈ\x02ਫ਼ਾਇ" +
	"ਲ ਬਣਾਉਣ ਲਈ ਅਸਫ਼ਲ ਹੈ\x02‘%[1]s’ ਫ਼ਾਇਲ ਪਹਿਲਾਂ ਹੀ ਮੌਜੂਦ ਹੈ।\x0a\x0aਕੀ ਤੁਸ" +
	"ੀਂ ਇਸ ਉੱਤੇ ਲਿਖਣਾ ਚਾਹੁੰਦੇ ਹੋ?\x02ਸਰਗਰਮ\x02ਸਰਗਰਮ ਕੀਤਾ ਜਾ ਰਿਹਾ ਹੈ\x02ਲਿਖਤ" +
	" ਫ਼ਾਇਲਾਂ (*.txt)|*.txt|ਸਾਰੀਆਂ ਫ਼ਾਇਲਾਂ (*.*)|*.*\x02WireGuard ਖੋਜ ਗ਼ਲਤੀ" +
	"\x02ਵਾਇਰਗਾਰਡ: ਨਾ-ਸਰਗਰਮ ਕੀਤਾ\x02ਸਥਿਤੀ: ਅਣਪਛਾਤੀ\x02ਸਿਰਨਾਵੇਂ: ਕੋਈ ਨਹੀਂ\x02ਟ" +
	"ਨਲਾਂ ਦਾ ਇੰਤਜ਼ਾਮ ਕਰੋ(&M)…\x02ਫ਼ਾਇਲ ਤੋਂ ਟਨਲਾਂ ਦਰਾਮਦ ਕਰੋ(&I)…\x02ਬਾਹਰ(&x)" +
	"\x02ਟਨਲ(&T)\x02ਵਾਇਰਗਾਰਡ ਸਰਗਰਮ ਕੀਤਾ\x02%[1]s ਟਨਲ ਸਰਗਰਮ ਕੀਤੀ ਗਈ ਹੈ।\x02ਵਾਇ" +
	"ਰਗਾਰਡ ਨਾ-ਸਰਗਰਮ ਕੀਤਾ\x02%[1]s ਟਨਲ ਨਾ-ਸਰਗਰਮ ਕੀਤੀ ਗਈ ਹੈ।\x02ਵਾਇਰਗਾਰਡ ਟਨਲ " +
	"ਗਲਤੀ\x02ਵਾਇਰਗਾਰਡ: %[1]s\x02ਸਥਿਤੀ: %[1]s\x02ਸਿਰਨਾਵੇਂ: %[1]s\x02ਅੱਪਡੇਟ ਮ" +
	"ੌਜੂਦ ਹੈ!\x02ਵਾਇਰਗਾਰਡ ਅੱਪਡੇਟ ਮੌਜੂਦ ਹੈ\x02ਵਾਇਰਗਾਰਡ ਲਈ ਅੱਪਡੇਟ ਹੁਣ ਮੌਜੂਦ ਹ" +
	"ੈ। ਜਿੰਨਾ ਛੇਤੀ ਹੋ ਸਕੇ ਤੁਹਾਨੂੰ ਅੱਪਡੇਟ ਕਰਨ ਦੀ ਸਲਾਹ ਦਿੱਤੀ ਜਾਂਦੀ ਹੈ।\x02ਟਨਲ" +
	"ਾਂ\x02ਸੋਧੋ(&E)\x02…ਖਾਲੀ ਟਨਲ ਜੋੜੋ(&e)\x02ਟਨਲ ਜੋੜੋ\x02ਚੁਣੀਆਂ ਟਨਲਾਂ ਨੂੰ ਹ" +
	"ਟਾਓ\x02ਸਾਰੀਆਂ ਟਨਲਾਂ ਨੂੰ ਜ਼ਿੱਪ ਵਜੋਂ ਬਰਾਮਦ ਕਰੋ\x02ਪਲਟੋ(&T)\x02ਸਾਰੀਆਂ ਟਨਲਾ" +
	"ਂ ਨੂੰ ਜ਼ਿੱਪ ਵਜੋਂ ਬਰਾਮਦ ਕਰੋ…\x02ਚੁਣੀ ਟਨਲ ਸੋਧੋ(&s)…\x02ਚੁਣੀਆਂ ਟਨਲਾਂ ਨੂੰ ਹ" +
	"ਟਾਓ(&R)\x02ਕੋਈ ਸੰਰਚਨਾ ਫ਼ਾਇਲਾਂ ਨਹੀਂ ਲੱਭੀਆਂ\x02‘%[1]s’ ਨਾਂ ਨਾਲ ਹੋਰ ਟਨਲ ਪ" +
	"ਹਿਲਾਂ ਹੀ ਮੌਜੂਦ ਹੈ\x02ਸੰਰਚਨਾ ਇੰਪੋਰਟ ਕਰਨ ਲਈ ਅਸਮਰੱਥ: %[1]v\x02ਇੰਪੋਰਟ ਕੀਤੀ" +
	"ਆਂ ਟਨਲਾਂ\x14\x01\x81\x01\x00\x020\x02%[1]d ਟਨਲ ਇੰਪੋਰਟ ਕੀਤੀ\x00<\x02%[1" +
	"]d ਟਨਲਾਂ ਇੰਪੋਰਟ ਕੀਤੀਆਂ\x02ਟਨਲ ਬਣਾਉਣ ਲਈ ਅਸਮਰੱਥ\x14\x01\x81\x01\x00\x02" +
	"\x1d\x02%[1]d ਟਨਲ ਹਟਾਓ\x00#\x02%[1]d ਟਨਲਾਂ ਹਟਾਓ\x14\x01\x81\x01\x00\x02b" +
	"\x02ਕੀ ਤੁਸੀਂ %[1]d ਟਨਲ ਨੂੰ ਹਟਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ?\x00h\x02ਕੀ ਤੁਸੀਂ %[1]d ਟਨਲ" +
	"ਾਂ ਨੂੰ ਹਟਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ?\x02‘%[1]s’ ਟਨਲ ਨੂੰ ਹਟਾਓ\x02ਕੀ ਤੁਸੀਂ ‘%[1]s‘ " +
	"ਟਨਲ ਨੂੰ ਹਟਾਉਣਾ ਚਾਹੁੰਦੇ ਹੋ?\x02%[1]s ਤੁਸੀਂ ਇਹ ਕਾਰਵਾਈ ਵਾਪਸ ਨਹੀਂ ਲੈ ਸਕਦੇ " +
	"ਹੋ।\x02ਟਨਲ ਹਟਾਉਣ ਲਈ ਅਸਮਰੱਥ\x02ਟਨਲ ਹਟਾਉਣ ਲਈ ਅਸਮਰੱਥ ਹੈ: %[1]s\x02ਟਨਲਾਂ ਹ" +
	"ਟਾਉਣ ਲਈ ਅਸਮਰੱਥ\x02ਸੰਰਚਨਾ ਫ਼ਾਇਲਾਂ (*.zip, *.conf)|*.zip;*.conf|ਸਾਰੀਆਂ ਫ" +
	"਼ਾਇਲਾਂ (*.*)|*.*\x02ਫ਼ਾਇਲ ਤੋਂ ਟਨਲਾਂ ਦਰਾਮਦ ਕਰੋ\x02ਸੰਰਚਨਾ ਜ਼ਿੱਪ ਫਾਇਲਾਂ (*" +
	".zip)|*.zip\x02ਸੇਵਾ ਤੋਂ ਬਾਹਰ ਜਾਣ ਲਈ ਅਸਮਰੱਥ, ਕਾਰਨ: %[1]v। ਤੁਸੀਂ ਸੇਵਾ ਮੈਨੇ" +
	"ਜਰ ਤੋਂ WireGuard ਨੂੰ ਰੋਕਣਾ ਚਾਹੋਗੇ।\x02ਹਾਲਤ: ਵਰਤੋਂਕਾਰ ਲਈ ਉਡੀਕ ਕੀਤੀ ਜਾ ਰ" +
	"ਹੀ ਹੈ\x02ਹਾਲਤ: ਅੱਪਡੇਟਰ ਸੇਵਾ ਦੀ ਉਡੀਕ ਕੀਤੀ ਜਾ ਰਹੀ ਹੈ"

var plIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x0000004f, 0x00000067,
	0x0000007e, 0x000000cc, 0x00000108, 0x0000013f,
	0x000001a8, 0x00000228, 0x0000022e, 0x00000251,
	0x00000287, 0x000002bf, 0x00000302, 0x00000341,
	0x00000384, 0x0000038f, 0x00000398, 0x000003a5,
	0x000003b2, 0x000003bf, 0x000003cc, 0x000003d9,
	0x000003f1, 0x0000041a, 0x0000043c, 0x00000467,
	0x0000047a, 0x0000048e, 0x000004be, 0x000004da,
	// Entry 20 - 3F
	0x00000514, 0x0000052b, 0x0000054c, 0x0000055d,
	0x0000058e, 0x000005b5, 0x000005b8, 0x000005bb,
	0x000005d2, 0x000005e1, 0x000005e9, 0x000005f7,
	0x000005ff, 0x0000060b, 0x00000614, 0x00000625,
	0x00000635, 0x0000063a, 0x00000642, 0x0000064f,
	0x00000654, 0x00000669, 0x0000067f, 0x00000698,
	0x000006bc, 0x000006c7, 0x000006d6, 0x000006e4,
	0x000006ed, 0x000006f5, 0x00000707, 0x0000071b,
	// Entry 40 - 5F
	0x00000720, 0x00000736, 0x00000752, 0x0000076d,
	0x0000077b, 0x000007bb, 0x000007cf, 0x000007f2,
	0x00000844, 0x00000855, 0x00000877, 0x0000088b,
	0x000008d6, 0x000008fa, 0x00000935, 0x00000956,
	0x00000992, 0x000009ad, 0x000009d9, 0x00000a00,
	0x00000a24, 0x00000a4e, 0x00000a6c, 0x00000a91,
	0x00000a9a, 0x00000aa4, 0x00000ab7, 0x00000ac6,
	0x00000ada, 0x00000aea, 0x00000b0b, 0x00000b16,
	// Entry 60 - 7F
	0x00000b35, 0x00000b5d, 0x00000b7f, 0x00000b9f,
	0x00000bb0, 0x00000bb5, 0x00000bc8, 0x00000bd5,
	0x00000bdd, 0x00000bef, 0x00000bfa, 0x00000c30,
	0x00000c38, 0x00000c3f, 0x00000c4e, 0x00000c63,
	0x00000c78, 0x00000ca3, 0x00000ccf, 0x00000ce3,
	0x00000d1c, 0x00000d44, 0x00000d63, 0x00000d9c,
	0x00000da4, 0x00000db0, 0x00000de7, 0x00000e01,
	0x00000e3f, 0x00000e58, 0x00000e69, 0x00000e76,
	// Entry 80 - 9F
	0x00000e8e, 0x00000eb2, 0x00000ebc, 0x00000ec4,
	0x00000ed6, 0x00000ef6, 0x00000f0e, 0x00000f31,
	0x00000f49, 0x00000f5a, 0x00000f68, 0x00000f76,
	0x00000f93, 0x00000fb9, 0x00001010, 0x00001017,
	0x0000101f, 0x00001035, 0x00001041, 0x0000105e,
	0x00001089, 0x00001095, 0x000010c4, 0x000010dd,
	0x000010fb, 0x00001119, 0x0000114f, 0x0000117f,
	0x000011b7, 0x000011e4, 0x000011f9, 0x00001271,
	// Entry A0 - BF
	0x00001308, 0x00001324, 0x0000137c, 0x00001434,
	0x0000144c, 0x0000147c, 0x000014a1, 0x000014bc,
	0x000014e6, 0x00001501, 0x000015ac, 0x000015f6,
	0x00001616, 0x0000163b, 0x0000165c, 0x0000168b,
	0x00001715, 0x00001734, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	// Entry C0 - DF
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	// Entry E0 - FF
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	// Entry 100 - 11F
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c, 0x0000175c, 0x0000175c,
	0x0000175c, 0x0000175c,
} // Size: 1136 bytes

const plData string = "" + // Size: 5980 bytes
	"\x02Błąd\x02(brak argumentu): Podnieś uprawnienia i zainstaluj usługę me" +
	"nedżera\x02Użycie: %[1]s [\x0a%[2]s]\x02Opcje wiersza poleceń\x02Nie moż" +
	"na określić, czy proces jest uruchomiony w środowisku WOW64: %[1]v\x02Na" +
	"leży użyć natywnej wersji WireGuard na tym komputerze.\x02Nie można otwo" +
	"rzyć bieżącego tokenu procesu: %[1]v\x02WireGuard może być używany tylko" +
	" przez użytkowników, którzy są członkami wbudowanej grupy %[1]s.\x02Wire" +
	"Guard jest uruchomiony, ale interfejs jest dostępny tylko z poziomu użyt" +
	"kowników należących do wbudowanej grupy %[1]s.\x02Teraz\x02Zegar systemo" +
	"wy został cofnięty!\x14\x01\x81\x01\x00\x04\x0b\x02%[1]d lata\x05\x0a" +
	"\x02%[1]d lat\x02\x0a\x02%[1]d rok\x00\x0a\x02%[1]d lat\x14\x01\x81\x01" +
	"\x00\x04\x0a\x02%[1]d dni\x05\x0a\x02%[1]d dni\x02\x0d\x02%[1]d dzień" +
	"\x00\x0a\x02%[1]d dni\x14\x01\x81\x01\x00\x04\x0e\x02%[1]d godziny\x05" +
	"\x0d\x02%[1]d godzin\x02\x0e\x02%[1]d godzina\x00\x0d\x02%[1]d godzin" +
	"\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d minuty\x05\x0c\x02%[1]d minut\x02" +
	"\x0d\x02%[1]d minuta\x00\x0c\x02%[1]d minut\x14\x01\x81\x01\x00\x04\x0e" +
	"\x02%[1]d sekundy\x05\x0d\x02%[1]d sekund\x02\x0e\x02%[1]d sekunda\x00" +
	"\x0d\x02%[1]d sekund\x02%[1]s temu\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB" +
	"\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %" +
	"[2]q\x02Nieprawidłowy adres IP\x02Nieprawidłowa długość prefiksu sieci" +
	"\x02Brak portu urządzenia końcowego\x02Nieprawidłowy host (urządzenie ko" +
	"ńcowe)\x02Nieprawidłowe MTU\x02Nieprawidłowy port\x02Nieprawidłowy para" +
	"metr utrzymania połączenia\x02Nieprawidłowy klucz: %[1]v\x02Liczba musi " +
	"zawierać się w przedziale 0 - 2^64-1: %[1]v\x02Dwa przecinki z rzędu\x02" +
	"Nazwa tunelu jest nieprawidłowa\x02[nie określono]\x02Wszyscy uczestnicy" +
	" muszą mieć klucze publiczne\x02Błąd podczas pobierania konfiguracji\x02" +
	", \x02, \x02Informacje o WireGuard\x02Logo WireGuard\x02Zamknij\x02♥ &Wp" +
	"łać!\x02Status:\x02&Dezaktywuj\x02&Aktywuj\x02Klucz publiczny:\x02Port " +
	"nasłuchu:\x02MTU:\x02Adresy:\x02Serwery DNS:\x02PSK:\x02Dozwolone adresy" +
	" IP:\x02Urządzenie końcowe:\x02Utrzymanie połączenia:\x02Ostatni uścisk " +
	"dłoni (handshake):\x02Nieaktywny\x02Dezaktywowanie\x02Stan nieznany\x02D" +
	"ziennik\x02&Kopiuj\x02Wybierz &wszystko\x02&Zapisz do pliku…\x02Czas\x02" +
	"Wiadomości dziennika\x02Eksportuj dziennik do pliku\x02&Informacje o Wir" +
	"eGuard…\x02Błąd tunelu\x02%[1]s\x0a\x0aAby uzyskać więcej informacji, za" +
	"poznaj się z logiem.\x02%[1]s (nieaktualny)\x02Błąd podczas zamykania Wi" +
	"reGuard\x02Aktualizacja WireGuard jest dostępna. Zaleca się natychmiasto" +
	"wą aktualizację.\x02Uaktualnij teraz\x02Błąd: %[1]v. Spróbuj ponownie." +
	"\x02Status: Ukończone!\x02Ikona WireGuard nie pojawiła się po 30 sekunda" +
	"ch w zasobniku systemowym.\x02Nawiasy muszą zawierać adres IPv6\x02Klucz" +
	"e muszą zostać zdekodowane do dokładnie 32 bajtów\x02Linia musi występow" +
	"ać w sekcji\x02Klucz konfiguracyjny nie zawiera separatora równorzędnego" +
	"\x02Klucz musi mieć wartość\x02Nieprawidłowy klucz dla sekcji [Interface" +
	"]\x02Nieprawidłowy klucz dla sekcji [Peer]\x02Interfejs musi mieć klucz " +
	"prywatny\x02Nieprawidłowy klucz dla sekcji interface\x02Wersja protokołu" +
	" musi być 1\x02Nieprawidłowy klucz dla sekcji peer\x02Skrypty:\x02Transf" +
	"er:\x02przed włączeniem\x02po włączeniu\x02przed wyłączeniem\x02po wyłąc" +
	"zeniu\x02wyłączone, według zasad grupy\x02włączyć\x02%[1]s odebrano, %[2" +
	"]s wysłano\x02Nie udało się określić stanu tunelu\x02Nie udało się aktyw" +
	"ować tunelu\x02Nie można dezaktywować tunelu\x02Interfejs: %[1]s\x02Peer" +
	"\x02Utwórz nowy tunel\x02Edytuj tunel\x02&Nazwa:\x02&Klucz publiczny:" +
	"\x02(nieznany)\x02Zablokuj niezabezpieczony ruch (wyłącznik awaryjny)" +
	"\x02&Zapisz\x02Anuluj\x02&Konfiguracja:\x02Nieprawidłowa nazwa\x02Nazwa " +
	"jest wymagana.\x02Nazwa tunelu ‘%[1]s’ jest niepoprawna.\x02Nie można wy" +
	"listować istniejących tuneli\x02Tunel już istnieje\x02Inny tunel już ist" +
	"nieje z tą samą nazwą ‘%[1]s’.\x02Nie można utworzyć nowej konfiguracji" +
	"\x02Zapis pliku się nie powiódł\x02Plik ‘%[1]s’ już istnieje. Czy chcesz" +
	" go nadpisać?\x02Aktywny\x02Aktywowanie\x02Pliki tekstowe (*.txt)|*.txt|" +
	"Wszystkie pliki (*.*)|*.*\x02Błąd detekcji WireGuard\x02Nie można poczek" +
	"ać na pojawienie się okna WireGuard: %[1]v\x02WireGuard: Dezaktywowany" +
	"\x02Status: Nieznany\x02Adresy: Brak\x02&Zarządzaj tunelami…\x02&Importu" +
	"j tunel (tunele) z pliku…\x02W&yjście\x02&Tunele\x02WireGuard Aktywny" +
	"\x02Tunel %[1]s został aktywowany.\x02WireGuard Dezaktywowany\x02Tunel %" +
	"[1]s został dezaktywowany.\x02Błąd tunelu WireGuard\x02WireGuard: %[1]s" +
	"\x02Status: %[1]s\x02Adresy: %[1]s\x02Dostępna nowa aktualizacja!\x02Akt" +
	"ualizacja WireGuard jest dostępna\x02Aktualizacja WireGuard jest już dos" +
	"tępna. Zaleca się jak najszybszą aktualizację.\x02Tunele\x02&Edytuj\x02D" +
	"odaj &pusty tunel…\x02Dodaj Tunel\x02Usuń wybrany tunel (tunele)\x02Eksp" +
	"ortuj wszystkie tunele do archiwum ZIP\x02&Przełącz\x02Eksportuj wszystk" +
	"ie tunele do archiwum &zip…\x02Edytuj &wybrany tunel…\x02&Usuń wybrany t" +
	"unel (tunele)\x02brak plików konfiguracyjnych\x02Nie można zaimportować " +
	"wybranej konfiguracji: %[1]v\x02Nie można wskazać istniejących tuneli: %" +
	"[1]v\x02Inny tunel już istnieje z tą samą nazwą ‘%[1]s’\x02Nie można zai" +
	"mportować konfiguracji: %[1]v\x02Zaimportowane tunele\x14\x01\x81\x01" +
	"\x00\x04\x1b\x02Zaimportowano %[1]d tunele\x05\x1b\x02Zaimportowano %[1]" +
	"d tuneli\x02\x1a\x02Zaimportowano %[1]d tunel\x00\x1b\x02Zaimportowano %" +
	"[1]d tuneli\x14\x02\x80\x01\x04#\x02Zaimportowano %[1]d z %[2]d tunele" +
	"\x05#\x02Zaimportowano %[1]d z %[2]d tuneli\x02\x22\x02Zaimportowano %[1" +
	"]d z %[2]d tunel\x00#\x02Zaimportowano %[1]d z %[2]d tuneli\x02Nie można" +
	" utworzyć tunelu\x14\x01\x81\x01\x00\x04\x13\x02Usuń %[1]d tunele\x05" +
	"\x13\x02Usuń %[1]d tuneli\x02\x12\x02Usuń %[1]d tunel\x00\x13\x02Usuń %[" +
	"1]d tuneli\x14\x01\x81\x01\x00\x04+\x02Czy na pewno chcesz usunąć %[1]d " +
	"tunele?\x05+\x02Czy na pewno chcesz usunąć %[1]d tuneli?\x02*\x02Czy na " +
	"pewno chcesz usunąć %[1]d tunel?\x00+\x02Czy na pewno chcesz usunąć %[1]" +
	"d tuneli?\x02Usuń tunel ‘%[1]s’\x02Czy na pewno chcesz usunąć tunel ‘%[1" +
	"]s’?\x02%[1]s Tej akcji nie można cofnąć.\x02Nie można usunąć tunelu\x02" +
	"Tunel nie mógł zostać usunięty: %[1]s\x02Nie można usunąć tuneli\x14\x01" +
	"\x81\x01\x00\x04'\x02%[1]d tunele nie mogą być usunięte.\x05'\x02%[1]d t" +
	"unele nie mogą być usunięte.\x02)\x02%[1]d tunel nie może zostać usunięt" +
	"y.\x00'\x02%[1]d tunele nie mogą być usunięte.\x02Pliki konfiguracji (*." +
	"zip, *.conf)|*.zip;*.conf|Wszystkie pliki (*.*)|*.*\x02Importuj tunel (t" +
	"unele) z pliku\x02Pliki ZIP konfiguracji (*.zip)|*.zip\x02Eksportuj tune" +
	"le do archiwum ZIP\x02%[1]s (wersja niepodpisana, brak aktualizacji)\x02" +
	"Nie można wyłączyć usługi ze względu na: %[1]v. Jeśli chcesz wyłączyć Wi" +
	"reGuard możesz to zrobić z poziomu menedżera usług.\x02Status: Czekam na" +
	" użytkownika\x02Status: Czekam na usługę aktualizacji"

var roIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x0000005d, 0x00000077,
	0x00000092, 0x000000d1, 0x0000011a, 0x0000014e,
	0x000001b2, 0x0000022e, 0x00000233, 0x0000025a,
	0x00000285, 0x000002b2, 0x000002df, 0x00000313,
	0x0000034c, 0x00000357, 0x00000360, 0x0000036d,
	0x0000037a, 0x00000387, 0x00000394, 0x000003a1,
	0x000003b6, 0x000003e3, 0x00000408, 0x0000042b,
	0x00000439, 0x00000446, 0x00000469, 0x00000480,
	// Entry 20 - 3F
	0x000004bc, 0x000004de, 0x000004fd, 0x00000514,
	0x00000543, 0x00000567, 0x0000056a, 0x0000056d,
	0x0000057e, 0x00000597, 0x000005a2, 0x000005b1,
	0x000005b8, 0x000005c5, 0x000005cf, 0x000005df,
	0x000005f2, 0x000005f7, 0x000005ff, 0x0000060c,
	0x00000623, 0x00000633, 0x00000640, 0x0000065c,
	0x00000679, 0x00000681, 0x00000692, 0x000006a5,
	0x000006ac, 0x000006b5, 0x000006c8, 0x000006e0,
	// Entry 40 - 5F
	0x000006e5, 0x000006f5, 0x00000712, 0x00000727,
	0x00000737, 0x0000076f, 0x00000784, 0x000007a5,
	0x00000802, 0x00000815, 0x00000838, 0x0000084c,
	0x00000896, 0x000008c7, 0x0000090c, 0x00000937,
	0x0000097e, 0x000009a4, 0x000009d2, 0x000009fb,
	0x00000a2c, 0x00000a5a, 0x00000a82, 0x00000aad,
	0x00000ab8, 0x00000ac5, 0x00000ad1, 0x00000ade,
	0x00000ae9, 0x00000af5, 0x00000b13, 0x00000b1d,
	// Entry 60 - 7F
	0x00000b38, 0x00000b64, 0x00000b82, 0x00000ba3,
	0x00000bb6, 0x00000bbe, 0x00000bcf, 0x00000bdd,
	0x00000be4, 0x00000bf5, 0x00000c04, 0x00000c51,
	0x00000c5a, 0x00000c62, 0x00000c72, 0x00000c7f,
	0x00000c95, 0x00000cc0, 0x00000ce7, 0x00000cfc,
	0x00000d2d, 0x00000d52, 0x00000d70, 0x00000db6,
	0x00000dbc, 0x00000dca, 0x00000e01, 0x00000e1f,
	0x00000e5d, 0x00000e73, 0x00000e87, 0x00000e97,
	// Entry 80 - 9F
	0x00000eaf, 0x00000ed4, 0x00000edd, 0x00000ee7,
	0x00000ef9, 0x00000f17, 0x00000f2c, 0x00000f4d,
	0x00000f67, 0x00000f78, 0x00000f85, 0x00000f93,
	0x00000fb4, 0x00000fde, 0x00001054, 0x0000105d,
	0x00001066, 0x0000107e, 0x0000108e, 0x000010af,
	0x000010d1, 0x000010db, 0x00001101, 0x0000111c,
	0x0000113e, 0x00001169, 0x000011a2, 0x000011d7,
	0x00001207, 0x00001233, 0x00001246, 0x00001299,
	// Entry A0 - BF
	0x00001309, 0x00001323, 0x00001379, 0x00001423,
	0x0000143f, 0x00001479, 0x000014a7, 0x000014c2,
	0x000014e9, 0x00001506, 0x0000158a, 0x000015da,
	0x000015fb, 0x00001625, 0x00001640, 0x00001671,
	0x000016d2, 0x000016f4, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	// Entry C0 - DF
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	// Entry E0 - FF
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	// Entry 100 - 11F
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722, 0x00001722, 0x00001722,
	0x00001722, 0x00001722,
} // Size: 1136 bytes

const roData string = "" + // Size: 5922 bytes
	"\x02Eroare\x02(fără argument): obținere drept administrativ și instalare" +
	" serviciu de gestionare\x02Utilizare: %[1]s [\x0a%[2]s]\x02Opțiuni linie" +
	" de comandă\x02Nu se poate determina dacă procesul rulează sub WOW64: %[" +
	"1]v\x02Trebuie să utilizezi versiunea nativă a WireGuard pe acest calcul" +
	"ator.\x02Nu poate fi deschis tokenul actual de proces: %[1]v\x02WireGuar" +
	"d poate fi utilizat doar de către utilizatorii care sunt membri ai grupu" +
	"lui Builtin %[1]s.\x02WireGuard rulează, dar interfața cu utilizatorul e" +
	"ste accesibilă doar din spațiile de lucru ale grupului Builtin %[1]s." +
	"\x02Acum\x02Ceasul de sistem a fost dat în spate!\x14\x01\x81\x01\x00" +
	"\x04\x0a\x02%[1]d ani\x02\x09\x02%[1]d an\x00\x0d\x02%[1]d de ani\x14" +
	"\x01\x81\x01\x00\x04\x0b\x02%[1]d zile\x02\x09\x02%[1]d zi\x00\x0e\x02%[" +
	"1]d de zile\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d ore\x02\x0b\x02%[1]d or" +
	"ă\x00\x0d\x02%[1]d de ore\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d minute" +
	"\x02\x0c\x02%[1]d minut\x00\x10\x02%[1]d de minute\x14\x01\x81\x01\x00" +
	"\x04\x0e\x02%[1]d secunde\x02\x0f\x02%[1]d secundă\x00\x11\x02%[1]d de s" +
	"ecunde\x02acum %[1]s\x02%[1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f" +
	"\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Adr" +
	"esă IP invalidă\x02Lungimea prefixului de rețea este invalidă\x02Lipseșt" +
	"e portul de la punctul final\x02Gazdă invalidă a punctului final\x02MTU " +
	"invalidă\x02Port invalid\x02Mesaj keepalive persistent invalid\x02Cheie " +
	"invalidă: %[1]v\x02Numărul trebuie să fie cuprins între 0 și 2^64-1: %[1" +
	"]v\x02Două virgule una după cealaltă\x02Numele tunelului nu este valid" +
	"\x02[niciuna specificată]\x02Toate perechile trebuie să aibă chei public" +
	"e\x02Eroare la obținerea configurației\x02, \x02, \x02Despre WireGuard" +
	"\x02Imagine siglă WireGuard\x02Închidere\x02♥ &Donează!\x02Stare:\x02&De" +
	"zactivare\x02&Activare\x02Cheie publică:\x02Port de ascultare:\x02MTU:" +
	"\x02Adrese:\x02Servere DNS:\x02Cheie predistribuită:\x02IP-uri permise:" +
	"\x02Punct final:\x02Mesaj keepalive persistent:\x02Ultimul acord de inte" +
	"rogare:\x02Inactiv\x02Se dezactivează\x02Stare necunoscută\x02Jurnal\x02" +
	"&Copiere\x02Selectare &totală\x02&Salvare în fișier…\x02Timp\x02Mesaj de" +
	" jurnal\x02Exportare jurnal în fișier\x02&Despre WireGuard…\x02Eroare de" +
	" tunel\x02%[1]s\x0a\x0aConsultă jurnalul pentru mai multe informații." +
	"\x02%[1]s (neactualizat)\x02Eroare la ieșirea din WireGuard\x02Este disp" +
	"onibilă o actualizare pentru WireGuard. Se recomandă ferm actualizarea i" +
	"mediată.\x02Actualizează acum\x02Eroare: %[1]v. Încearcă din nou.\x02Sta" +
	"re: finalizată!\x02Pictograma WireGuard din bara de sistem nu a apărut d" +
	"upă 30 de secunde.\x02Parantezele trebuie să conțină o adresă IPv6\x02Re" +
	"zultatul decodificat de chei trebuie să aibă exact 32 de octeți\x02Linia" +
	" trebuie să apară într-o secțiune\x02Cheii de configurare îi lipsește un" +
	" separator de forma semnului egal\x02Cheia trebuie să conțină o valoare" +
	"\x02Cheie invalidă pentru secțiunea [Interface]\x02Cheie invalidă pentru" +
	" secțiunea [Peer]\x02O interfață trebuie să aibă o cheie privată\x02Chei" +
	"e invalidă pentru secțiunea interfeței\x02Versiunea de protocol trebuie " +
	"să fie 1\x02Cheie invalidă pentru secțiunea perechii\x02Scripturi:\x02Tr" +
	"ansferare:\x02pre-pornire\x02post-pornire\x02pre-oprire\x02post-oprire" +
	"\x02dezactivat, conform politicii\x02activată\x02%[1]s primit, %[2]s tri" +
	"mis\x02Nu a putut fi determinată starea tunelului\x02Tunelul nu a putut " +
	"fi activat\x02Tunelul nu a putut fi dezactivat\x02Interfață: %[1]s\x02Pe" +
	"reche\x02Creare tunel nou\x02Editare tunel\x02&Nume:\x02Cheie &publică:" +
	"\x02(necunoscută)\x02&Blochează traficul care nu trece prin tunel (între" +
	"rupător de activitate)\x02&Salvare\x02Anulare\x02&Configurație:\x02Nume " +
	"invalid\x02Este necesar un nume.\x02Numele tunelului „%[1]s” este invali" +
	"d.\x02Tunelurile existente nu pot fi listate\x02Tunelul există deja\x02E" +
	"xistă deja un alt tunel cu numele „%[1]s”.\x02Nu se poate crea configura" +
	"ția nouă\x02Scrierea fișierului a eșuat\x02Fișierul „%[1]s” există deja" +
	".\x0a\x0aDorești suprascrierea acestuia?\x02Activ\x02Se activează\x02Fiș" +
	"iere text (*.txt)|*.txt|Toate fișierele (*.*)|*.*\x02Eroare de detectare" +
	" WireGuard\x02Nu se poate aștepta ca fereastra WireGuard să apară: %[1]v" +
	"\x02WireGuard: dezactivat\x02Stare: necunoscută\x02Adrese: niciuna\x02&G" +
	"estionare tuneluri…\x02&Importare tunel(uri) din fișier…\x02Ie&șire\x02&" +
	"Tuneluri\x02WireGuard activat\x02Tunelul %[1]s a fost activat.\x02WireGu" +
	"ard dezactivat\x02Tunelul %[1]s a fost dezactivat.\x02Eroare de tunel Wi" +
	"reGuard\x02WireGuard: %[1]s\x02Stare: %[1]s\x02Adrese: %[1]s\x02Este dis" +
	"ponibilă o actualizare!\x02Actualizare disponibilă pentru WireGuard\x02O" +
	" actualizare pentru WireGuard este acum disponibilă. Se recomandă efectu" +
	"area actualizării cât mai rapid posibil.\x02Tuneluri\x02&Editare\x02Adău" +
	"gare tunel &gol…\x02Adăugare tunel\x02Eliminare tunel(uri) selectat(e)" +
	"\x02Exportă toate tunelurile în zip\x02&Comutare\x02Exportă toate tunelu" +
	"rile în &zip…\x02Editare tunel &selectat…\x02&Eliminare tunel(uri) selec" +
	"tat(e)\x02nu au fost găsite fișiere de configurare\x02Configurația selec" +
	"tată nu a putut fi importată: %[1]v\x02Tunelurile existente nu au putut " +
	"fi enumerate: %[1]v\x02Există deja un alt tunel cu numele „%[1]s”\x02Con" +
	"figurația nu poate fi importată: %[1]v\x02Tuneluri importate\x14\x01\x81" +
	"\x01\x00\x04\x18\x02Importat %[1]d tuneluri\x02\x15\x02Importat %[1]d tu" +
	"nel\x00\x1b\x02Importat %[1]d de tuneluri\x14\x02\x80\x01\x04\x22\x02Imp" +
	"ortat %[1]d din %[2]d tuneluri\x02\x1f\x02Importat %[1]d din %[2]d tunel" +
	"\x00%\x02Importat %[1]d din %[2]d de tuneluri\x02Tunelul nu poate fi cre" +
	"at\x14\x01\x81\x01\x00\x04\x19\x02Ștergere %[1]d tuneluri\x02\x16\x02Ște" +
	"rgere %[1]d tunel\x00\x1c\x02Ștergere %[1]d de tuneluri\x14\x01\x81\x01" +
	"\x00\x045\x02Ești sigur că dorești să ștergi %[1]d tuneluri?\x022\x02Eșt" +
	"i sigur că dorești să ștergi %[1]d tunel?\x008\x02Ești sigur că dorești " +
	"să ștergi %[1]d de tuneluri?\x02Ștergere tunel „%[1]s”\x02Ești sigur că " +
	"dorești să ștergi tunelul „%[1]s”?\x02%[1]s Această acțiune nu poate fi " +
	"anulată.\x02Tunelul nu poate fi șters\x02Un tunel nu a putut fi eliminat" +
	": %[1]s\x02Nu se pot șterge tunelurile\x14\x01\x81\x01\x00\x04)\x02%[1]d" +
	" tuneluri nu au putut fi eliminate.\x02$\x02%[1]d tunel nu a putut fi el" +
	"iminat.\x00,\x02%[1]d de tuneluri nu au putut fi eliminate.\x02Fișiere d" +
	"e configurare (*.zip, *.conf)|*.zip;*.conf|Toate fișierele (*.*)|*.*\x02" +
	"Importare tunel(uri) din fișier\x02Fișiere ZIP de configurare (*.zip)|*." +
	"zip\x02Exportare tuneluri în zip\x02%[1]s (versiune nesemnată, fără actu" +
	"alizări)\x02Nu se poate ieși din serviciu din cauza: %[1]v. Poți opri Wi" +
	"reGuard din managerul de servicii.\x02Stare: se așteaptă utilizatorul" +
	"\x02Stare: se așteaptă serviciul de actualizare"

var ruIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000d, 0x000000a9, 0x000000d4,
	0x00000107, 0x00000166, 0x000001c9, 0x00000220,
	0x000002a7, 0x0000034b, 0x00000358, 0x00000395,
	0x000003c2, 0x000003ef, 0x0000041c, 0x00000459,
	0x00000496, 0x000004a7, 0x000004b0, 0x000004bd,
	0x000004ca, 0x000004d7, 0x000004e4, 0x000004f1,
	0x00000518, 0x00000556, 0x00000595, 0x000005c3,
	0x000005e0, 0x00000602, 0x00000658, 0x00000681,
	// Entry 20 - 3F
	0x000006c0, 0x000006e3, 0x00000722, 0x00000738,
	0x0000077e, 0x000007be, 0x000007c1, 0x000007c4,
	0x000007d1, 0x000007ea, 0x000007f9, 0x00000818,
	0x00000826, 0x0000083a, 0x00000850, 0x0000086d,
	0x00000877, 0x0000087c, 0x0000088d, 0x000008a1,
	0x000008b6, 0x000008de, 0x000008fc, 0x0000092d,
	0x00000958, 0x00000969, 0x0000097e, 0x000009a8,
	0x000009b5, 0x000009cd, 0x000009e4, 0x00000a07,
	// Entry 40 - 5F
	0x00000a12, 0x00000a34, 0x00000a5e, 0x00000a6f,
	0x00000a8b, 0x00000b06, 0x00000b1d, 0x00000b46,
	0x00000bce, 0x00000bec, 0x00000c25, 0x00000c47,
	0x00000caf, 0x00000ce7, 0x00000d3c, 0x00000d6f,
	0x00000dc4, 0x00000df6, 0x00000e30, 0x00000e65,
	0x00000eaf, 0x00000ef2, 0x00000f2a, 0x00000f71,
	0x00000f81, 0x00000f93, 0x00000fb7, 0x00000fd9,
	0x00000ffb, 0x0000101b, 0x00001045, 0x00001056,
	// Entry 60 - 7F
	0x00001089, 0x000010d4, 0x0000110c, 0x00001142,
	0x0000115c, 0x00001163, 0x00001181, 0x000011ab,
	0x000011be, 0x000011dc, 0x000011f3, 0x0000123b,
	0x0000124f, 0x0000125c, 0x00001277, 0x000012a1,
	0x000012c8, 0x0000130c, 0x00001344, 0x0000136f,
	0x000013b7, 0x000013fe, 0x00001423, 0x00001485,
	0x00001498, 0x000014af, 0x000014f7, 0x00001525,
	0x00001579, 0x0000159f, 0x000015c2, 0x000015d7,
	// Entry 80 - 9F
	0x00001603, 0x00001635, 0x00001641, 0x00001651,
	0x0000166a, 0x00001693, 0x000016ae, 0x000016d5,
	0x000016fb, 0x0000170c, 0x00001720, 0x00001734,
	0x0000175b, 0x0000178b, 0x00001816, 0x00001825,
	0x00001841, 0x00001872, 0x00001892, 0x000018c3,
	0x000018fe, 0x00001916, 0x00001955, 0x00001996,
	0x000019c8, 0x00001a09, 0x00001a59, 0x00001ab3,
	0x00001afa, 0x00001b4a, 0x00001b78, 0x00001c4c,
	// Entry A0 - BF
	0x00001d48, 0x00001d7a, 0x00001e1a, 0x00001f62,
	0x00001f8c, 0x00001fdc, 0x00002027, 0x00002059,
	0x00002093, 0x000020c5, 0x000021bc, 0x00002219,
	0x00002247, 0x0000227f, 0x000022b1, 0x000022fe,
	0x00002398, 0x000023d0, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	// Entry C0 - DF
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	// Entry E0 - FF
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	// Entry 100 - 11F
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404, 0x00002404, 0x00002404,
	0x00002404, 0x00002404,
} // Size: 1136 bytes

const ruData string = "" + // Size: 9220 bytes
	"\x02Ошибка\x02(нет аргумента): получить права администратора и установит" +
	"ь административную службу\x02Использование: %[1]s [\x0a%[2]s]\x02Параме" +
	"тры командной строки\x02Ошибка определения или процесс работает как WOW" +
	"64: %[1]v\x02Используйте нативную версию WireGuard на этом компьютере." +
	"\x02Не удается открыть токен текущего процесса: %[1]v\x02WireGuard может" +
	" использоваться только пользователями, входящими в группу %[1]s.\x02Wire" +
	"Guard запущен, но пользовательский интерфейс доступен только с рабочих с" +
	"толов группы %[1]s.\x02Сейчас\x02Системные часы переведены назад!\x14" +
	"\x01\x81\x01\x00\x04\x08\x02%[1]dг\x05\x08\x02%[1]dг\x02\x08\x02%[1]dг" +
	"\x00\x08\x02%[1]dг\x14\x01\x81\x01\x00\x04\x08\x02%[1]dд\x05\x08\x02%[1]" +
	"dд\x02\x08\x02%[1]dд\x00\x08\x02%[1]dд\x14\x01\x81\x01\x00\x04\x08\x02%[" +
	"1]dч\x05\x08\x02%[1]dч\x02\x08\x02%[1]dч\x00\x08\x02%[1]dч\x14\x01\x81" +
	"\x01\x00\x04\x0c\x02%[1]dмин\x05\x0c\x02%[1]dмин\x02\x0c\x02%[1]dмин\x00" +
	"\x0c\x02%[1]dмин\x14\x01\x81\x01\x00\x04\x0c\x02%[1]dсек\x05\x0c\x02%[1]" +
	"dсек\x02\x0c\x02%[1]dсек\x00\x0c\x02%[1]dсек\x02%[1]s назад\x02%[1]d Б" +
	"\x02%.2[1]f Кб\x02%.2[1]f Мб\x02%.2[1]f Гб\x02%.2[1]f Тб\x02%[1]s: %[2]q" +
	"\x02Недопустимый IP-адрес\x02Недопустимая длина префикса сети\x02Отсутст" +
	"вует порт IP-адреса сервера\x02Неверный IP-адрес сервера\x02Недопустимы" +
	"й MTU\x02Недопустимый порт\x02Недопустимое значение поддержания соедине" +
	"ния\x02Недопустимый ключ: %[1]v\x02Число должно быть между 0 и 2^64-1: " +
	"%[1]v\x02Две запятые подряд\x02Название туннеля недействительно\x02[не у" +
	"казано]\x02Все пиры должны иметь публичные ключи\x02Ошибка при получени" +
	"и конфигурации\x02, \x02, \x02О WireGuard\x02Логотип WireGuard\x02Закры" +
	"ть\x02♥ &Пожертвовать!\x02Статус:\x02&Отключить\x02&Подключить\x02Публи" +
	"чный ключ:\x02Порт:\x02MTU:\x02IP-адреса:\x02DNS-серверы:\x02Общий ключ" +
	":\x02Разрешенные IP-адреса:\x02IP-адрес сервера:\x02Поддерживание соедин" +
	"ения:\x02Последнее рукопожатие:\x02Отключен\x02Отключение\x02Неизвестно" +
	"е состояние\x02Журнал\x02&Скопировать\x02Выбрать &все\x02&Сохранить в ф" +
	"айл…\x02Время\x02Сообщение журнала\x02Экспорт журнала в файл\x02&О Wire" +
	"Guard…\x02Ошибка туннеля\x02%[1]s\x0a\x0aОбратитесь к журналу для получе" +
	"ния дополнительной информации.\x02%[1]s (устарел)\x02Ошибка выхода из W" +
	"ireGuard\x02Доступно обновление WireGuard. Настоятельно рекомендуем обно" +
	"вить приложение.\x02Обновить Сейчас\x02Ошибка: %[1]v. Попробуйте еще ра" +
	"з.\x02Статус: Завершено!\x02Значок в системном трее WireGuard не появил" +
	"ся после 30 секунд.\x02В скобках должен быть IPv6 адрес\x02Ключи должны" +
	" декодироваться ровно с 32 байтами\x02Строка должна быть в секции\x02В к" +
	"люче конфигурации отсутствует разделитель\x02Ключ должен иметь значение" +
	"\x02Неверный ключ для секции [Interface]\x02Неверный ключ для секции [Pe" +
	"er]\x02В Интерфейсе должен быть приватный ключ\x02Неверный ключ для секц" +
	"ии Интерфейса\x02Версия протокола должна быть 1\x02Недействительный клю" +
	"ч для секции пира\x02Скрипты:\x02Передача:\x02перед подключением\x02пос" +
	"ле подключения\x02перед отключением\x02после отключения\x02отключено, п" +
	"о политике\x02включено\x02Получено %[1]s, отправлено %[2]s\x02Не удалос" +
	"ь определить состояние туннеля\x02Не удалось подключить туннель\x02Не у" +
	"далось отключить туннель\x02Интерфейс: %[1]s\x02Пир\x02Создать туннель" +
	"\x02Редактировать туннель\x02&Название:\x02&Публичный ключ:\x02(неизвест" +
	"но)\x02&Блокировать нетуннелированный трафик\x02&Сохранить\x02Отмена" +
	"\x02&Конфигурация:\x02Некорректное название\x02Необходимо название.\x02Н" +
	"азвание туннеля ‘%[1]s’ недопустимо.\x02Не удалось отобразить туннели" +
	"\x02Туннель уже существует\x02Туннель с именем ’%[1]s’ уже существует." +
	"\x02Не удалось создать новую конфигурацию\x02Ошибка записи файла\x02Файл" +
	" '%[1]s' уже существует!\x0a\x0aВы хотите перезаписать его?\x02Подключен" +
	"\x02Подключение\x02Текстовые файлы (*.txt)|*.txt|Все файлы (*.*)|*.*\x02" +
	"Ошибка обнаружения WireGuard\x02Не удалось дождаться появления окна Wir" +
	"eGuard: %[1]v\x02WireGuard: Деактивирован\x02Статус: Неизвестен\x02Адрес" +
	"а: нет\x02&Управление туннелями…\x02&Импорт туннелей из файла…\x02Вы&хо" +
	"д\x02&Туннели\x02WireGuard Включен\x02Туннель %[1]s подключен.\x02WireG" +
	"uard Выключен\x02Туннель %[1]s отключен.\x02Ошибка туннеля WireGuard\x02" +
	"WireGuard: %[1]s\x02Статус: %[1]s\x02Адреса: %[1]s\x02Доступно обновлени" +
	"е!\x02Доступно обновление WireGuard\x02Доступно обновление для WireGuar" +
	"d. Рекомендуется обновить его как можно скорее.\x02Туннели\x02&Редактиро" +
	"вать\x02Добавить &пустой туннель…\x02Добавить туннель\x02Удалить выбран" +
	"ные туннели\x02Экспорт всех туннелей в zip-архив\x02&Переключить\x02Экс" +
	"порт всех туннелей в &zip-архив…\x02Редактировать &выбранный туннель…" +
	"\x02&Удалить выбранные туннели\x02файлы конфигурации не были найдены\x02" +
	"Невозможно импортировать конфигурацию: %[1]v\x02Не удалось перечислить " +
	"существующие туннели: %[1]v\x02Туннель с именем ’%[1]s’ уже существует" +
	"\x02Невозможно импортировать конфигурацию: %[1]v\x02Импортированные тунн" +
	"ели\x14\x01\x81\x01\x00\x041\x02Импортированы туннели: %[1]d\x051\x02Им" +
	"портированы туннели: %[1]d\x024\x02Импортированный %[1]d туннель\x001" +
	"\x02Импортированы туннели: %[1]d\x14\x02\x80\x01\x04<\x02Импортированы т" +
	"уннели: %[1]d из %[2]d\x05<\x02Импортированы туннели: %[1]d из %[2]d" +
	"\x02<\x02Импортированы туннели: %[1]d из %[2]d\x00<\x02Импортированы тун" +
	"нели: %[1]d из %[2]d\x02Не удалось создать туннель\x14\x01\x81\x01\x00" +
	"\x04%\x02Удалить туннели: %[1]d\x05%\x02Удалить туннели: %[1]d\x02$\x02У" +
	"далить %[1]d туннель\x00%\x02Удалить туннели: %[1]d\x14\x01\x81\x01\x00" +
	"\x04O\x02Вы уверены, что хотите удалить туннели: %[1]d?\x05O\x02Вы увере" +
	"ны, что хотите удалить туннели: %[1]d?\x02N\x02Вы уверены, что хотите у" +
	"далить %[1]d туннель?\x00O\x02Вы уверены, что хотите удалить туннели: %" +
	"[1]d?\x02Удалить туннель ‘%[1]s’\x02Вы уверены, что хотите удалить '%[1]" +
	"s' туннель?\x02%[1]s Данное действие невозможно отменить.\x02Не удалось " +
	"удалить туннель\x02Невозможно удалить туннель: %[1]s\x02Не удалось удал" +
	"ить туннели\x14\x01\x81\x01\x00\x04;\x02туннелей не удалось удалить: %[" +
	"1]d\x05;\x02туннелей не удалось удалить: %[1]d\x029\x02%[1]d туннель не " +
	"удалось удалить.\x00;\x02туннелей не удалось удалить: %[1]d\x02Файлы ко" +
	"нфигурации (*.zip, *.conf)|*.zip;*.conf|Все файлы (*.*)|*.*\x02Импорт т" +
	"уннелей из файла\x02Конфигурация ZIP файлов (*.zip)|*.zip\x02Экспорт ту" +
	"ннелей в zip-архив\x02%[1]s (неподписанная сборка, нет обновлений)\x02Н" +
	"е удается выйти из сервиса из-за: %[1]v. Вы можете остановить WireGuard" +
	" из менеджера служб.\x02Статус: Ожидание пользователя\x02Статус: Ожидани" +
	"е обновления"

var si_LKIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000013, 0x00000013, 0x00000036,
	0x00000036, 0x00000036, 0x00000036, 0x00000036,
	0x00000036, 0x00000036, 0x00000043, 0x00000043,
	0x00000084, 0x000000b3, 0x000000dc, 0x00000117,
	0x0000014c, 0x00000160, 0x0000016c, 0x00000180,
	0x00000194, 0x000001a8, 0x000001bc, 0x000001c9,
	0x00000212, 0x00000212, 0x00000212, 0x00000212,
	0x00000212, 0x0000024b, 0x0000024b, 0x0000027c,
	// Entry 20 - 3F
	0x0000027c, 0x000002be, 0x000002be, 0x000002be,
	0x000002be, 0x000002be, 0x000002c1, 0x000002c4,
	0x000002f3, 0x000002f3, 0x00000303, 0x00000325,
	0x00000336, 0x00000336, 0x00000336, 0x00000336,
	0x00000366, 0x00000366, 0x00000377, 0x000003a1,
	0x000003a1, 0x000003c8, 0x000003c8, 0x000003c8,
	0x000003c8, 0x000003c8, 0x000003c8, 0x000003f4,
	0x000003f4, 0x00000408, 0x00000408, 0x0000043b,
	// Entry 40 - 5F
	0x0000044b, 0x0000044b, 0x0000044b, 0x0000047e,
	0x0000047e, 0x0000047e, 0x000004ae, 0x000004f6,
	0x000004f6, 0x0000051f, 0x00000562, 0x00000593,
	0x00000593, 0x00000593, 0x00000593, 0x00000593,
	0x00000593, 0x000005d3, 0x000005d3, 0x000005d3,
	0x00000644, 0x00000644, 0x00000698, 0x00000698,
	0x00000698, 0x00000698, 0x00000698, 0x00000698,
	0x00000698, 0x00000698, 0x00000698, 0x000006b0,
	// Entry 60 - 7F
	0x000006e3, 0x000006e3, 0x000006e3, 0x000006e3,
	0x0000070c, 0x0000070c, 0x0000070c, 0x0000070c,
	0x00000715, 0x00000715, 0x00000727, 0x00000727,
	0x00000741, 0x00000754, 0x00000772, 0x0000079c,
	0x000007c3, 0x000007c3, 0x000007c3, 0x000007c3,
	0x000007c3, 0x00000812, 0x0000084e, 0x0000084e,
	0x0000084e, 0x00000883, 0x00000883, 0x00000883,
	0x00000905, 0x00000905, 0x00000926, 0x00000926,
	// Entry 80 - 9F
	0x00000926, 0x00000926, 0x0000093d, 0x0000093d,
	0x0000097e, 0x0000097e, 0x0000097e, 0x0000097e,
	0x0000097e, 0x0000097e, 0x00000995, 0x000009ac,
	0x000009ac, 0x000009ac, 0x000009ac, 0x000009ac,
	0x000009c6, 0x000009c6, 0x000009c6, 0x000009c6,
	0x000009c6, 0x000009c6, 0x000009c6, 0x000009c6,
	0x000009c6, 0x000009c6, 0x000009c6, 0x000009c6,
	0x000009c6, 0x00000a13, 0x00000a13, 0x00000a13,
	// Entry A0 - BF
	0x00000a13, 0x00000a13, 0x00000a13, 0x00000a13,
	0x00000a13, 0x00000a13, 0x00000a82, 0x00000a82,
	0x00000a82, 0x00000a82, 0x00000a82, 0x00000a82,
	0x00000a82, 0x00000a82, 0x00000a82, 0x00000a82,
	0x00000a82, 0x00000acf, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	// Entry C0 - DF
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	// Entry E0 - FF
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	// Entry 100 - 11F
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f, 0x00000b2f, 0x00000b2f,
	0x00000b2f, 0x00000b2f,
} // Size: 1136 bytes

const si_LKData string = "" + // Size: 2863 bytes
	"\x02දෝෂයකි\x02භාවිතය: %[1]s [\x0a%[2]s]\x02දැන්\x14\x01\x81\x01\x00\x02" +
	"\x1c\x02අවුරුදු %[1]d\x00\x1c\x02අවුරුදු %[1]d\x14\x01\x81\x01\x00\x02" +
	"\x13\x02දවස් %[1]d\x00\x13\x02දවස් %[1]d\x14\x01\x81\x01\x00\x02\x10\x02" +
	"පැය %[1]d\x00\x10\x02පැය %[1]d\x14\x01\x81\x01\x00\x02\x19\x02විනාඩි %" +
	"[1]d\x00\x19\x02විනාඩි %[1]d\x14\x01\x81\x01\x00\x02\x16\x02තත්පර %[1]d" +
	"\x00\x16\x02තත්පර %[1]d\x02%[1]s ට පෙර\x02බ.\u00a0%[1]d\x02කි.බ. %.2[1]f" +
	"\x02මෙ.බ. %.2[1]f\x02ගි.බ. %.2[1]f\x02ටෙ.බ. %.2[1]f\x02%[1]s: %[2]q\x02ව" +
	"ලංගු නොවන අ.ජා.කෙ. ලිපිනයකි\x02වලංගු නොවන කෙවෙනියකි\x02වලංගු නොවන යතුර" +
	": %[1]v\x02පේළියකට අල්පවිරාම දෙකක්\x02, \x02, \x02වයර්ගාඩ් පිළිබඳව\x02වස" +
	"න්න\x02♥ &පරිත්\u200dයාග!\x02තත්වය:\x02සවන්දීමේ කෙවෙනිය:\x02ලිපින:\x02" +
	"ව.නා.ප. සේවාදායක:\x02ඉඩදුන් අ.ජා.කෙ.:\x02නොදන්නා තත්වයකි\x02&පිටපත්" +
	"\x02&ගොනුවකට සුරකින්න…\x02වේලාව\x02&වයර්ගාඩ් පිළිබඳව…\x02%[1]s (කල් ඉකුත" +
	"් වී ඇත)\x02වයර්ගාඩ් පිටවීමේදී දෝෂයකි\x02යාවත්කාල කරන්න\x02දෝෂය: %[1]v" +
	". යළි උත්සාහ කරන්න.\x02තත්වය: සම්පූර්ණයි!\x02යතුරට අගයක් තිබිය යුතුය\x02" +
	"අතුරුමුහුතකට පුද්ගලික යතුරක් තිබිය යුතුය\x02කෙටුම්පතෙහි අනුවාදය 1 විය " +
	"යුතුය\x02සබල කර ඇත\x02%[1]s ලැබුණී, %[2]s යැවිණි\x02අතුරුමුහුණත: %[1]s" +
	"\x02&නම:\x02(නොදනී)\x02&සුරකින්න\x02අවලංගු\x02&වින්\u200dයාසය:\x02වලංගු " +
	"නොවන නමකි\x02නමක් අවශ්\u200dයයි.\x02නව වින්\u200dයාසය සෑදීමට නොහැකියි" +
	"\x02ගොනුව ලිවීමට අසමත්විය\x02ක්\u200dරියාත්මක වෙමින්\x02වයර්ගාඩ් කවුළුව " +
	"පෙනෙන තෙක් රැඳීසිටිය නොහැකිය: %[1]v\x02තත්වය: නොදනී\x02පි&ටවන්න\x02වයර" +
	"්ගාඩ් ක්\u200dරියාත්මකයි\x02තත්වය: %[1]s\x02ලිපින: %[1]s\x02&සංස්කරණය" +
	"\x02වින්\u200dයාසය ආයාත කළ නොහැකිය: %[1]v\x02%[1]s මෙම ක්\u200dරියාමාර්ග" +
	"ය ආපසු හැරවිය නොහැකිය.\x02තත්වය: පරිශීලක සඳහා රැඳෙමින්\x02තත්වය: යාවත්" +
	"කාල සේවාව සඳහා රැඳෙමින්"

var skIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x0000005e, 0x00000078,
	0x00000097, 0x000000d1, 0x0000011e, 0x00000156,
	0x00000198, 0x00000202, 0x00000208, 0x00000230,
	0x0000026a, 0x000002a2, 0x000002e3, 0x00000326,
	0x0000036b, 0x00000376, 0x0000037f, 0x0000038c,
	0x00000399, 0x000003a6, 0x000003b3, 0x000003c0,
	0x000003d4, 0x000003fa, 0x0000041f, 0x00000443,
	0x00000451, 0x00000460, 0x00000482, 0x0000049b,
	// Entry 20 - 3F
	0x000004ce, 0x000004e4, 0x00000501, 0x00000515,
	0x0000054a, 0x0000056e, 0x00000571, 0x00000573,
	0x0000057f, 0x00000597, 0x000005a1, 0x000005b0,
	0x000005b6, 0x000005c5, 0x000005d2, 0x000005e4,
	0x000005f4, 0x000005f9, 0x00000601, 0x0000060e,
	0x00000629, 0x0000063e, 0x0000064c, 0x00000665,
	0x00000685, 0x00000690, 0x0000069e, 0x000006ac,
	0x000006be, 0x000006cb, 0x000006dc, 0x000006f4,
	// Entry 40 - 5F
	0x000006f9, 0x00000716, 0x0000073f, 0x0000074f,
	0x0000075c, 0x00000794, 0x000007a7, 0x000007c2,
	0x00000825, 0x00000839, 0x00000859, 0x0000086c,
	0x000008b6, 0x000008df, 0x00000914, 0x00000933,
	0x00000975, 0x00000996, 0x000009bb, 0x000009db,
	0x00000a0e, 0x00000a31, 0x00000a4f, 0x00000a6d,
	0x00000a76, 0x00000a7e, 0x00000a8d, 0x00000a99,
	0x00000aa8, 0x00000ab4, 0x00000ad5, 0x00000adf,
	// Entry 60 - 7F
	0x00000b03, 0x00000b25, 0x00000b44, 0x00000b65,
	0x00000b76, 0x00000b7b, 0x00000b91, 0x00000ba0,
	0x00000ba9, 0x00000bbc, 0x00000bc7, 0x00000bf5,
	0x00000bff, 0x00000c08, 0x00000c18, 0x00000c29,
	0x00000c3d, 0x00000c65, 0x00000c9b, 0x00000cae,
	0x00000cd8, 0x00000d05, 0x00000d28, 0x00000d65,
	0x00000d6e, 0x00000d7a, 0x00000db3, 0x00000dcc,
	0x00000e07, 0x00000e20, 0x00000e2e, 0x00000e3e,
	// Entry 80 - 9F
	0x00000e54, 0x00000e78, 0x00000e83, 0x00000e8b,
	0x00000ea4, 0x00000ec1, 0x00000edc, 0x00000efb,
	0x00000f12, 0x00000f23, 0x00000f2f, 0x00000f3d,
	0x00000f59, 0x00000f7f, 0x00000fe8, 0x00000fef,
	0x00000ff9, 0x00001014, 0x00001022, 0x00001046,
	0x0000106f, 0x0000107a, 0x000010a7, 0x000010c5,
	0x000010e4, 0x00001114, 0x0000114e, 0x00001181,
	0x000011a6, 0x000011d7, 0x000011ed, 0x0000126d,
	// Entry A0 - BF
	0x00001311, 0x0000132a, 0x000013a3, 0x00001491,
	0x000014b1, 0x000014ee, 0x0000151a, 0x00001535,
	0x0000155d, 0x0000157b, 0x0000162d, 0x0000167b,
	0x0000169b, 0x000016c3, 0x000016e1, 0x00001715,
	0x0000177b, 0x0000179b, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	// Entry C0 - DF
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	// Entry E0 - FF
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	// Entry 100 - 11F
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5, 0x000017c5, 0x000017c5,
	0x000017c5, 0x000017c5,
} // Size: 1136 bytes

const skData string = "" + // Size: 6085 bytes
	"\x02Chyba\x02(bez argumentu): získať administrátorské práva a nainštalov" +
	"ať službu manažéra\x02Použitie: %[1]s [\x0a%[2]s]\x02Možnosti príkazovéh" +
	"o riadku\x02Nepodarilo sa zistiť, či proces beží pod WOW64: %[1]v\x02V t" +
	"omto počítači musíte používať pôvodnú verziu programu WireGuard.\x02Nepo" +
	"darilo sa otvoriť token aktuálneho procesu: %[1]v\x02WireGuard môžu použ" +
	"ívať iba členovia Builtin skupiny %[1]s.\x02WireGuard je spustený, ale " +
	"používateľské rozhranie je prístupné iba členom Builtin skupiny %[1]s." +
	"\x02Teraz\x02Systémové hodiny sa vrátili v čase!\x14\x01\x81\x01\x00\x04" +
	"\x0b\x02%[1]d roky\x05\x0c\x02%[1]d rokov\x02\x0a\x02%[1]d rok\x00\x0c" +
	"\x02%[1]d rokov\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d dni\x05\x0b\x02%[1]" +
	"d dní\x02\x0b\x02%[1]d deň\x00\x0b\x02%[1]d dní\x14\x01\x81\x01\x00\x04" +
	"\x0d\x02%[1]d hodiny\x05\x0d\x02%[1]d hodín\x02\x0d\x02%[1]d hodina\x00" +
	"\x0d\x02%[1]d hodín\x14\x01\x81\x01\x00\x04\x0e\x02%[1]d minúty\x05\x0d" +
	"\x02%[1]d minút\x02\x0e\x02%[1]d minúta\x00\x0d\x02%[1]d minút\x14\x01" +
	"\x81\x01\x00\x04\x0e\x02%[1]d sekundy\x05\x0e\x02%[1]d sekúnd\x02\x0e" +
	"\x02%[1]d sekunda\x00\x0e\x02%[1]d sekúnd\x02Pred %[1]s\x02%[1]d\u00a0B" +
	"\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f" +
	"\u00a0TiB\x02%[1]s: %[2]q\x02Neplatná adresa IP\x02Neplatná dĺžka sieťov" +
	"ého prefixu\x02Koncovému bodu chýba číslo portu\x02Neplatný hostiteľ ko" +
	"ncového bodu\x02Neplatné MTU\x02Neplatný port\x02Neplatný perzistentný k" +
	"eepalive\x02Neplatný kľúč: %[1]v\x02Číslo musí mať hodnotu medzi 0 a 2^6" +
	"4-1: %[1]v\x02Dve čiarky v poradí\x02Názov tunela nie je platný\x02[nešp" +
	"ecifikované]\x02Všetci peeri musia mať priradený verejný kľúč\x02Chyba p" +
	"ri získavaní konfigurácie\x02, \x02 \x02O WireGuard\x02Obrázok WireGuard" +
	" loga\x02Zatvoriť\x02♥ a Darovat!\x02Stav:\x02a Deaktivovať\x02a Aktivov" +
	"ať\x02Verejný kľúč:\x02Otvorený port:\x02MTU:\x02Adresy:\x02Servery DNS:" +
	"\x02Vopred zdieľaný kľúč:\x02Povolené IP adresy:\x02Koncový bod:\x02Perz" +
	"istentný keepalive:\x02Posledné spojenie (handshake):\x02Neaktívny\x02De" +
	"aktivuje sa\x02Neznámy stav\x02Denník udalostí\x02&Kopírovať\x02Vybr&ať " +
	"všetko\x02Uložiť do &súboru…\x02Čas\x02Správa v denníku udalostí\x02Expo" +
	"rtovať denník udalostí do súboru\x02&O WireGuard…\x02Chyba tunela\x02%[1" +
	"]s\x0a\x0aViac informácií nájdete v denníku udalostí.\x02%[1]s (neaktuán" +
	"y)\x02Chyba ukončenia WireGuard\x02Je k dispozícii nová verzia programu " +
	"WireGuard. Odporúčame bezodkladne vykonať aktualizáciu.\x02Aktualizovať " +
	"teraz\x02Chyba: %[1]v. Skúste to znova.\x02Stav: Dokončené!\x02WireGuard" +
	" ikona sa ani po 30 sekundách neobjavila na systémovej lište.\x02Medzi z" +
	"átvorkami musí byť IPv6 adresa\x02Dekódované kľúče musia mať veľkosť 32" +
	" bajtov\x02Sekcia musí obsahovať čiaru\x02Konfiguračný kľúč neobsahuje s" +
	"eparátor (znamienko rovnosti)\x02Kľúč musí obsahovať hodnotu\x02Neplatný" +
	" kľúč sekcie [Interface]\x02Neplatný kľúč sekcie [Peer]\x02Rozhranie mus" +
	"í mať priradený súkromný kľúč\x02Neplatný kľúč sekcie rozhrania\x02Verz" +
	"ia protokolu musí byť 1\x02Neplatný kľúč peer sekcie\x02Skripty:\x02Pren" +
	"os:\x02pred-zapnutím\x02po-zapnutí\x02pred-vypnutím\x02po-vypnutí\x02zak" +
	"ázané, na základe pravidla\x02povolené\x02%[1]s prijatých, %[2]s odosla" +
	"ných\x02Nepodarilo sa zistiť stav tunela\x02Nepodarilo sa aktivovať tune" +
	"l\x02Nepodarilo sa deaktivovať tunel\x02Rozhranie: %[1]s\x02Peer\x02Vytv" +
	"oriť nový tunel\x02Upraviť tunel\x02&Názov:\x02&Verejný kľúč:\x02(neznám" +
	"y)\x02&Blokovať netunelovaný prenos (kill-switch)\x02&Uložiť\x02Zrušiť" +
	"\x02&Konfigurácia:\x02Neplatný názov\x02Názov je povinný.\x02Názov tunel" +
	"a ‘%[1]s’ je neplatný.\x02Nepodarilo sa pripraviť zoznam existujúcich tu" +
	"nelov\x02Tunel už existuje\x02Tunel s názvom ‘%[1]s’ už existuje.\x02Nie" +
	" je možné vytvoriť novú konfiguráciu\x02Nepodarilo sa zapísať do súboru" +
	"\x02Súbor ‘%[1]s’ už existuje.\x0a\x0aŽeláte si ho prepísať?\x02Aktívny" +
	"\x02Aktivuje sa\x02Textové súbory (*.txt)|*.txt|Všetky súbory (*.*)|*.*" +
	"\x02Chyba detekcie WireGuard\x02Nie je možné čakať na zobrazenie WireGua" +
	"rd okna: %[1]v\x02WireGuard: deaktivovaný\x02Stav: Nezámy\x02Adresa: žia" +
	"dna\x02&Spravovať tunely…\x02&Importovať tunel(y) zo súboru…\x02U&končiť" +
	"\x02&Tunely\x02WireGuard je aktivovaný\x02Tunel %[1]s bol aktivovaný." +
	"\x02WireGuard je deaktivovaný\x02Tunel %[1]s bol deaktivovaný.\x02Chyba " +
	"WireGuard tunelu\x02WireGuard: %[1]s\x02Stav: %[1]s\x02Adresa: %[1]s\x02" +
	"Je dostupná aktualizácia!\x02Dostupná aktualizácia pre WireGuard\x02Je k" +
	" dispozícii aktualizácia programu WireGuard. Je odporúčané čo najskôr vy" +
	"konať aktualizáciu.\x02Tunely\x02&Upraviť\x02Pridať &prázdny tunel…\x02P" +
	"ridať tunel\x02Odstrániť označený(é) tunel(y)\x02Export všetkých tunelov" +
	" do zip súboru\x02P&repnúť\x02Export všetkých tunelov do &zip súboru…" +
	"\x02Upraviť &označený tunel…\x02&Odstrániť označené tunely\x02neboli náj" +
	"dené žiadne konfiguračné súbory\x02Nepodarilo sa naimportovať vybrané ko" +
	"nfigurácie: %[1]v\x02Nepodarilo sa načítať existujúce tunely: %[1]v\x02U" +
	"ž existuje tunel s názvom '%[1]s'\x02Nepodarilo sa naimportovať konfigu" +
	"ráciu: %[1]v\x02Naimportované tunely\x14\x01\x81\x01\x00\x04\x1c\x02Naim" +
	"portované %[1]d tunely\x05\x1f\x02Naimportovaných %[1]d tunelov\x02\x19" +
	"\x02Importovaný %[1]d tunel\x00\x1f\x02Naimportovaných %[1]d tunelov\x14" +
	"\x02\x80\x01\x04%\x02Naimportované %[1]d z %[2]d tunelov\x05'\x02Naimpor" +
	"tovaných %[1]d z %[2]d tunelov\x02%\x02Naimportovaný %[1]d z %[2]d tunel" +
	"ov\x00'\x02Naimportovaných %[1]d z %[2]d tunelov\x02Tunel sa nedá vytvor" +
	"iť\x14\x01\x81\x01\x00\x04\x19\x02Odstránene %[1]d tunely\x05\x1d\x02Ods" +
	"tránených %[1]d tunelov\x02\x19\x02Odstránený %[1]d tunel\x00\x1d\x02Ods" +
	"tránených %[1]d tunelov\x14\x01\x81\x01\x00\x048\x02Ste si istý, že si ž" +
	"eláte odstrániť %[1]d tunely?\x059\x02Ste si istý, že si želáte odstráni" +
	"ť %[1]d tunelov?\x027\x02Ste si istý, že si želáte odstrániť %[1]d tune" +
	"l?\x009\x02Ste si istý, že si želáte odstrániť %[1]d tunelov?\x02Odstrán" +
	"enie tunela ‘%[1]s’\x02Ste si istý, že si želáte odstrániť tunel ‘%[1]s’" +
	"?\x02%[1]s Túto akciu nemôže vrátiť späť.\x02Tunel sa nedá odstrániť\x02" +
	"Nebolo možné odstrániť tunel: %[1]s\x02Tunely sa nedajú odstrániť\x14" +
	"\x01\x81\x01\x00\x04)\x02%[1]d tunely nebolo možné odstrániť.\x05*\x02%[" +
	"1]d tunelov nebolo možné odstrániť.\x02(\x02%[1]d tunel nebolo možné ods" +
	"trániť.\x00*\x02%[1]d tunelov nebolo možné odstrániť.\x02Konfirugačné sú" +
	"bory (*.zip, *.conf)|*.zip;*.conf|Všetky súbory (*.*)|*.*\x02Importovať " +
	"tunel(y) zo súboru\x02Konfiguračné ZIP súbry (*.zip)|*.zip\x02Export tun" +
	"elov do zip súboru\x02%[1]s (nepodpísaná verzia, žiadne aktualizácie)" +
	"\x02Nie je možné ukončiť služby z dôvodu: %[1]v. Skúste zastaviť WireGua" +
	"rd v správcovi služieb.\x02Stav: Čaká sa na užívateľa\x02Stav: Čaká sa n" +
	"a aktualizačnú službu"

var slIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000058, 0x00000070,
	0x00000089, 0x000000c1, 0x00000111, 0x00000148,
	0x0000019a, 0x00000200, 0x00000205, 0x00000224,
	0x0000025c, 0x00000293, 0x000002c7, 0x00000307,
	0x0000034b, 0x00000357, 0x00000360, 0x0000036d,
	0x0000037a, 0x00000387, 0x00000394, 0x000003a1,
	0x000003b4, 0x000003d8, 0x000003fa, 0x00000423,
	0x00000430, 0x0000043f, 0x00000463, 0x0000047a,
	// Entry 20 - 3F
	0x000004ae, 0x000004c3, 0x000004da, 0x000004e8,
	0x0000050f, 0x0000052f, 0x00000532, 0x00000534,
	0x00000541, 0x0000055f, 0x00000565, 0x00000573,
	0x0000057b, 0x00000588, 0x00000593, 0x000005a1,
	0x000005b4, 0x000005b9, 0x000005c2, 0x000005d2,
	0x000005e8, 0x000005f9, 0x00000609, 0x00000625,
	0x00000637, 0x00000641, 0x0000064f, 0x0000065e,
	0x00000666, 0x0000066f, 0x0000067b, 0x00000693,
	// Entry 40 - 5F
	0x00000698, 0x000006ae, 0x000006c8, 0x000006db,
	0x000006e9, 0x00000718, 0x0000072e, 0x0000074e,
	0x000007a1, 0x000007af, 0x000007d1, 0x000007e3,
	0x00000827, 0x0000084d, 0x0000087e, 0x00000899,
	0x000008c8, 0x000008e3, 0x00000908, 0x00000928,
	0x0000094a, 0x0000096c, 0x0000098a, 0x000009ac,
	0x000009b5, 0x000009bd, 0x000009cd, 0x000009db,
	0x000009ed, 0x000009fd, 0x00000a1b, 0x00000a26,
	// Entry 60 - 7F
	0x00000a43, 0x00000a67, 0x00000a85, 0x00000aa5,
	0x00000ab4, 0x00000abc, 0x00000ace, 0x00000ada,
	0x00000ae0, 0x00000aef, 0x00000af9, 0x00000b23,
	0x00000b2b, 0x00000b35, 0x00000b45, 0x00000b52,
	0x00000b62, 0x00000b84, 0x00000bb4, 0x00000bc6,
	0x00000bf1, 0x00000c18, 0x00000c36, 0x00000c71,
	0x00000c79, 0x00000c85, 0x00000cbd, 0x00000cda,
	0x00000d15, 0x00000d2c, 0x00000d3b, 0x00000d49,
	// Entry 80 - 9F
	0x00000d60, 0x00000d7f, 0x00000d86, 0x00000d8e,
	0x00000da2, 0x00000dc0, 0x00000dd6, 0x00000df6,
	0x00000e0e, 0x00000e1f, 0x00000e2d, 0x00000e3c,
	0x00000e55, 0x00000e78, 0x00000ebd, 0x00000ec4,
	0x00000ecb, 0x00000ee4, 0x00000ef0, 0x00000f08,
	0x00000f20, 0x00000f2a, 0x00000f48, 0x00000f61,
	0x00000f7a, 0x00000f9f, 0x00000fcd, 0x00001000,
	0x00001025, 0x0000104b, 0x0000105b, 0x000010bf,
	// Entry A0 - BF
	0x0000114a, 0x0000116b, 0x000011d0, 0x000012bd,
	0x000012d8, 0x00001313, 0x0000133e, 0x00001358,
	0x00001380, 0x0000139b, 0x0000144f, 0x0000149c,
	0x000014b5, 0x000014e0, 0x000014fd, 0x0000152e,
	0x0000159b, 0x000015b7, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	// Entry C0 - DF
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	// Entry E0 - FF
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	// Entry 100 - 11F
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de, 0x000015de, 0x000015de,
	0x000015de, 0x000015de,
} // Size: 1136 bytes

const slData string = "" + // Size: 5598 bytes
	"\x02Napaka\x02(brez argumenta): povzdigni na skrbniške pravice in namest" +
	"i skrbniško storitev\x02Uporaba: %[1]s [\x0a%[2]s]\x02Možnosti ukazne vr" +
	"stice\x02Napaka pri določanju ali proces teče kot WOW64: %[1]v\x02Na tem" +
	"u računalniku morate uporabiti enako-arhitekturno različico WireGuarda." +
	"\x02Napaka pri odpiranju žetona trenutnega procesa: %[1]v\x02WireGuard l" +
	"ahko uporabljajo samo uporabniki, ki so člani vgrajene skupine %[1]s." +
	"\x02WireGuard je zagnan, vendar je up. vmesnik dostopen samo z namizij u" +
	"porabnikov članov skupine %[1]s.\x02Zdaj\x02Sistemska ura prevrtena naza" +
	"j!\x14\x01\x81\x01\x00\x04\x0b\x02%[1]d leta\x02\x0b\x02%[1]d leto\x03" +
	"\x0b\x02%[1]d leti\x00\x0a\x02%[1]d let\x14\x01\x81\x01\x00\x04\x0a\x02%" +
	"[1]d dni\x02\x0a\x02%[1]d dan\x03\x0c\x02%[1]d dneva\x00\x0a\x02%[1]d dn" +
	"i\x14\x01\x81\x01\x00\x04\x0a\x02%[1]d ure\x02\x0a\x02%[1]d uro\x03\x0a" +
	"\x02%[1]d uri\x00\x09\x02%[1]d ur\x14\x01\x81\x01\x00\x04\x0d\x02%[1]d m" +
	"inute\x02\x0d\x02%[1]d minuto\x03\x0d\x02%[1]d minuti\x00\x0c\x02%[1]d m" +
	"inut\x14\x01\x81\x01\x00\x04\x0e\x02%[1]d sekunde\x02\x0e\x02%[1]d sekun" +
	"do\x03\x0e\x02%[1]d sekundi\x00\x0d\x02%[1]d sekund\x02%[1]s nazaj\x02%[" +
	"1]d\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB" +
	"\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Napačen naslov IP\x02Napačna dol" +
	"žina predpone omrežja\x02Pri končni točki manjkajo vrata\x02Pri končni " +
	"točki je gostitelj napačen\x02Napačen MTU\x02Napačna vrata\x02Napačno tr" +
	"ajno ohranjanje povezave\x02Napačen ključ: %[1]v\x02Številka mora biti š" +
	"tevilo med 0 in 2^64-1: %[1]v\x02Dve zaporedni vejici\x02Ime tunela ni v" +
	"eljavno\x02[ni navedeno]\x02Vsi vrstniki morajo imeti javni ključ\x02Nap" +
	"aka pri branju konfiguracije\x02, \x02 \x02O WireGuardu\x02Slika WireGua" +
	"rdovega logotipa\x02Zapri\x02♥ &Doniraj!\x02Status:\x02&Deaktiviraj\x02&" +
	"Aktiviraj\x02Javni ključ:\x02Vrata poslušanja:\x02MTU:\x02Naslovi:\x02St" +
	"režniki DNS:\x02Ključ v skupni rabi:\x02Dovoljeni IP-ji:\x02Končna točka" +
	":\x02Trajno ohranjanje povezave:\x02Zadnje rokovanje:\x02Neaktivno\x02Se" +
	" deaktivira\x02Neznano stanje\x02Dnevnik\x02&Kopiraj\x02&Izberi vse\x02&" +
	"Shrani v datoteko\u00a0…\x02Čas\x02Sporočilo v dnevniku\x02Izvozi dnevni" +
	"k v datoteko\x02O WireGu&ardu\u00a0…\x02Napaka tunela\x02%[1]s\x0a\x0aDo" +
	"datne informacije najdete v dnevniku.\x02%[1]s (neposodobljen)\x02Napaka" +
	" pri izhodu iz WireGuarda\x02Posodobitev WireGuarda je na voljo. Zelo pr" +
	"iporočamo posodobitev brez odlašanja.\x02Posodobi zdaj\x02Napaka: %[1]v." +
	" Poskusite ponovno.\x02Status: Končano!\x02Ikona WireGuarda se po 30 sek" +
	"undah ni pojavila v sistemski vrstici.\x02Oklepaji morajo vsebovati nasl" +
	"ov IPv6\x02Dekodirani ključi morajo biti natanko 32 bajtov\x02Vrstica mo" +
	"ra biti v odseku\x02Ključu v konfiguraciji manjka ločilo enačaj\x02Ključ" +
	" mora imeti vrednost\x02Napačen ključ za odsek [Interface]\x02Napačen kl" +
	"juč za odsek [Peer]\x02Vmesnik mora imeti zasebni ključ\x02Napačen ključ" +
	" za odsek vmesnika\x02Verzija protokola mora biti 1\x02Napačen ključ za " +
	"odsek vrstnika\x02Skripta:\x02Prenos:\x02pred-aktivacijo\x02po-aktivacij" +
	"i\x02pred-deaktivacijo\x02po-deaktivaciji\x02onemogočeno, zaradi politik" +
	"e\x02omogočeno\x02%[1]s prejeto, %[2]s poslano\x02Napaka pri določanju s" +
	"tanja tunela\x02Napaka pri aktiviranju tunela\x02Napaka pri deaktiviranj" +
	"u tunela\x02Vmesnik: %[1]s\x02Vrstnik\x02Ustvari nov tunel\x02Uredi tune" +
	"l\x02&Ime:\x02&Javni ključ:\x02(neznano)\x02&Blokiraj promet izven tunel" +
	"a (varovalka)\x02&Shrani\x02Prekliči\x02&Konfiguracija:\x02Napačno ime" +
	"\x02Ime je obvezno.\x02Ime tunela »%[1]s« ni veljavno.\x02Napaka pri pri" +
	"pravi seznama obstoječih tunelov\x02Tunel že obstaja\x02Drug tunel z ime" +
	"nom »%[1]s« že obstaja.\x02Napaka pri izdelavi nove konfiguracije\x02Nap" +
	"aka pri pisanju v datoteko\x02Datoteka »%[1]s« že obstaja.\x0a\x0aAli jo" +
	" želite prepisati?\x02Aktivno\x02Se aktivira\x02Tekstovne datoteke (*.tx" +
	"t)|*.txt|Vse datoteke (*.*)|*.*\x02Napaka zaznavanja WireGuarda\x02Čakan" +
	"je, da se pojavi WireGuardovo okno, ni možno: %[1]v\x02WireGuard: Deakti" +
	"viran\x02Status: Neznan\x02Naslovi: Brez\x02&Upravljaj tunele\u00a0…\x02" +
	"&Uvozi tunel(e) iz datoteke…\x02I&zhod\x02&Tuneli\x02WireGuard aktiviran" +
	"\x02Tunel %[1]s je bil aktiviran.\x02WireGuard deaktiviran\x02Tunel %[1]" +
	"s je bil deaktiviran.\x02Napaka tunela WireGuard\x02WireGuard: %[1]s\x02" +
	"Status: %[1]s\x02Naslovi: %[1]s\x02Na voljo je posodobitev!\x02Posodobit" +
	"ev WireGuarda je na voljo\x02Posodobitev WireGuarda je na voljo. Svetuje" +
	"mo posodobitev čim prej.\x02Tuneli\x02&Uredi\x02Dodaj &prazen tunel" +
	"\u00a0…\x02Dodaj tunel\x02Odstrani izbrane tunele\x02Izvozi vse tunele v" +
	" zip\x02&Preklopi\x02Izvozi vse tunele v &zip\u00a0…\x02Uredi &izbran tu" +
	"nel\u00a0…\x02Odst&rani izbrane tunele\x02ni najdenih konfiguracijskih d" +
	"atotek\x02Napaka pri uvozu izbrane konfiguracije: %[1]v\x02Napaka pri pr" +
	"eštevanju obstoječih tunelov: %[1]v\x02Tunel z imenom »%[1]s« že obstaja" +
	"\x02Napaka pri uvozu konfiguracije: %[1]v\x02Uvoženi tuneli\x14\x01\x81" +
	"\x01\x00\x04\x16\x02Uvoženi %[1]d tuneli\x02\x14\x02Uvožen %[1]d tunel" +
	"\x03\x16\x02Uvožena %[1]d tunela\x00\x17\x02Uvoženo %[1]d tunelov\x14" +
	"\x02\x80\x01\x04 \x02Uvoženi %[1]d od %[2]d tunelov\x02\x1f\x02Uvožen %[" +
	"1]d od %[2]d tunelov\x03 \x02Uvožena %[1]d od %[2]d tunelov\x00 \x02Uvož" +
	"eno %[1]d od %[2]d tunelov\x02Tunela ni bilo mogoče ustvariti\x14\x01" +
	"\x81\x01\x00\x04\x16\x02Izbriši %[1]d tunele\x02\x15\x02Izbriši %[1]d tu" +
	"nel\x03\x16\x02Izbriši %[1]d tunela\x00\x17\x02Izbriši %[1]d tunelov\x14" +
	"\x01\x81\x01\x00\x048\x02Ali ste prepričani, da želite izbrisati %[1]d t" +
	"unele?\x027\x02Ali ste prepričani, da želite izbrisati %[1]d tunel?\x038" +
	"\x02Ali ste prepričani, da želite izbrisati %[1]d tunela?\x009\x02Ali st" +
	"e prepričani, da želite izbrisati %[1]d tunelov?\x02Izbriši tunel ‘%[1]s" +
	"’\x02Ali ste prepričani, da želite izbrisati tunel »%[1]s«?\x02%[1]s T" +
	"ega dejanja ne morete razveljaviti.\x02Napaka pri izbrisu tunela\x02Napa" +
	"ka pri odstranjevanju tunela: %[1]s\x02Napaka pri izbrisu tunelov\x14" +
	"\x01\x81\x01\x00\x04*\x02%[1]d tunelov ni bilo mogoče odstraniti.\x02)" +
	"\x02%[1]d tunela ni bilo mogoče odstraniti.\x03*\x02%[1]d tunelov ni bil" +
	"o mogoče odstraniti.\x00*\x02%[1]d tunelov ni bilo mogoče odstraniti." +
	"\x02Konfiguracijske datoteke (*.zip, *.conf)|*.zip;*.conf|Vse datoteke (" +
	"*.*)|*.*\x02Uvozi tunele iz datoteke\x02Konfiguracijske datoteke ZIP (*." +
	"zip)|*.zip\x02Izvozi tunele v datoteko zip\x02%[1]s (nepodpisane različi" +
	"ce, brez posodobitev)\x02Storitve ni bilo mogoče zaustaviti, ker: %[1]v." +
	" Poskusite zaustaviti WireGuard z uporabo programa Storitve.\x02Status: " +
	"Čaka na uporabnika\x02Status: Čaka na servis za posodobitev"

var trIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000005, 0x0000004c, 0x00000066,
	0x00000082, 0x000000c6, 0x0000010b, 0x00000136,
	0x0000018e, 0x0000022f, 0x00000236, 0x00000257,
	0x00000276, 0x00000295, 0x000002b4, 0x000002d7,
	0x000002fa, 0x00000306, 0x0000030f, 0x0000031c,
	0x00000329, 0x00000336, 0x00000343, 0x00000350,
	0x00000364, 0x00000383, 0x0000039f, 0x000003b3,
	0x000003c1, 0x000003d0, 0x000003f3, 0x0000040c,
	// Entry 20 - 3F
	0x00000441, 0x00000456, 0x00000472, 0x00000490,
	0x000004bd, 0x000004ed, 0x000004f0, 0x000004f3,
	0x00000507, 0x0000051c, 0x00000522, 0x00000535,
	0x0000053c, 0x00000552, 0x00000560, 0x00000570,
	0x0000057f, 0x00000584, 0x0000058e, 0x0000059f,
	0x000005c1, 0x000005d7, 0x000005e2, 0x000005f9,
	0x0000060f, 0x0000061c, 0x00000639, 0x0000064a,
	0x00000653, 0x00000660, 0x00000670, 0x00000687,
	// Entry 40 - 5F
	0x0000068d, 0x0000069e, 0x000006c0, 0x000006dc,
	0x000006eb, 0x00000728, 0x0000073d, 0x00000759,
	0x000007bb, 0x000007cc, 0x000007f2, 0x00000806,
	0x00000842, 0x0000086b, 0x0000089d, 0x000008ba,
	0x000008f1, 0x00000913, 0x00000941, 0x0000096a,
	0x00000998, 0x000009c0, 0x000009e3, 0x00000a06,
	0x00000a18, 0x00000a22, 0x00000a35, 0x00000a49,
	0x00000a62, 0x00000a7c, 0x00000a91, 0x00000a97,
	// Entry 60 - 7F
	0x00000ab9, 0x00000ad5, 0x00000af0, 0x00000b15,
	0x00000b25, 0x00000b29, 0x00000b3e, 0x00000b4f,
	0x00000b57, 0x00000b68, 0x00000b75, 0x00000ba8,
	0x00000bb0, 0x00000bb7, 0x00000bc8, 0x00000bd7,
	0x00000be9, 0x00000c0c, 0x00000c2c, 0x00000c40,
	0x00000c6e, 0x00000c94, 0x00000ca7, 0x00000ce6,
	0x00000cec, 0x00000cff, 0x00000d36, 0x00000d4f,
	0x00000d83, 0x00000d9c, 0x00000dae, 0x00000dbc,
	// Entry 80 - 9F
	0x00000dd6, 0x00000dfd, 0x00000e08, 0x00000e17,
	0x00000e27, 0x00000e47, 0x00000e6c, 0x00000e96,
	0x00000eaf, 0x00000ec0, 0x00000ecd, 0x00000edd,
	0x00000ef1, 0x00000f10, 0x00000f6d, 0x00000f77,
	0x00000f7d, 0x00000f96, 0x00000fa2, 0x00000fbe,
	0x00000fe6, 0x00000ff2, 0x0000101e, 0x0000103c,
	0x00001059, 0x0000107d, 0x000010b0, 0x000010df,
	0x0000110c, 0x00001137, 0x00001152, 0x00001197,
	// Entry A0 - BF
	0x000011e7, 0x00001200, 0x0000122d, 0x0000129c,
	0x000012b6, 0x000012f1, 0x00001316, 0x00001329,
	0x0000134c, 0x00001362, 0x000013a9, 0x000013f8,
	0x00001417, 0x00001441, 0x00001464, 0x0000148e,
	0x000014f9, 0x00001517, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	// Entry C0 - DF
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	// Entry E0 - FF
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	// Entry 100 - 11F
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542, 0x00001542, 0x00001542,
	0x00001542, 0x00001542,
} // Size: 1136 bytes

const trData string = "" + // Size: 5442 bytes
	"\x02Hata\x02(argüman verilmediyse): gerekli izinleri al ve yönetim hizme" +
	"tini kur\x02Kullanım: %[1]s [\x0a%[2]s]\x02Komut Satırı Seçenekleri\x02İ" +
	"şlemin WOW64 altında çalıştığından emin olunamadı: %[1]v\x02Bu bilgisay" +
	"arda WireGuard'ın yerel sürümünü kullanmanız gerek.\x02Şu anki işlem jet" +
	"onu açılamadı: %[1]v\x02WireGuard sadece sisteme yerleşik %[1]s grubunun" +
	" üyeleri tarafından kullanılabilir.\x02WireGuard çalışıyor, fakat kullan" +
	"ıcı arayüzü sadece sisteme yerleşik %[1]s grubunun üyesi olan kullanıcı" +
	"lar tarafından masaüstünde erişilebilir.\x02Şimdi\x02Sistem saati geriye" +
	" sarılmış!\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d yıl\x00\x0b\x02%[1]d yıl" +
	"\x14\x01\x81\x01\x00\x02\x0b\x02%[1]d gün\x00\x0b\x02%[1]d gün\x14\x01" +
	"\x81\x01\x00\x02\x0b\x02%[1]d saat\x00\x0b\x02%[1]d saat\x14\x01\x81\x01" +
	"\x00\x02\x0d\x02%[1]d dakika\x00\x0d\x02%[1]d dakika\x14\x01\x81\x01\x00" +
	"\x02\x0d\x02%[1]d saniye\x00\x0d\x02%[1]d saniye\x02%[1]s önce\x02%[1]d" +
	"\u00a0B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%" +
	".2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02Geçersiz IP adresi\x02Ağ öneki uzunlu" +
	"ğu geçersiz\x02Uç nokta port ayarı eksik\x02Geçersiz uç nokta\x02Geçers" +
	"iz MTU\x02Geçersiz port\x02Geçersiz kalıcı açık bırakma\x02Geçersiz anah" +
	"tar: %[1]v\x02Sayı 0 ve 2^64-1 arasında bir sayı olmalı: %[1]v\x02Yan ya" +
	"na iki virgül\x02Tünel adı geçerli değil\x02[hiçbir şey belirtilmemiş}" +
	"\x02Tüm eşler açık anahtarlara sahip olmalı\x02Yapılandırma bilgisi alın" +
	"ırken hata oluştu\x02, \x02, \x02WireGuard Hakkında\x02WireGuard logo r" +
	"esmi\x02Kapat\x02♥ &Bağış yap!\x02Durum:\x02&Devre dışı bırak\x02&Etkinl" +
	"eştir\x02Açık anahtar:\x02Dinlenen port:\x02MTU:\x02Adresler:\x02DNS sun" +
	"ucuları:\x02Önceden paylaşılmış anahtar:\x02İzin verilen IP'ler:\x02Uç n" +
	"okta:\x02Kalıcı açık tutma:\x02En son el sıkışma:\x02Etkin değil\x02Devr" +
	"e dışı bırakılıyor\x02Durum bilinmiyor\x02Günlük\x02Kopyala (&c)\x02&tüm" +
	"ünü seç\x02Dosyaya kaydet (&s)…\x02Zaman\x02Günlük mesajı\x02Günlük dos" +
	"yasını dışa aktar\x02WireGuard Hakkında (&a)…\x02Tünel Hatası\x02%[1]s" +
	"\x0a\x0aLütfen daha fazla bilgi için günlüğe göz atın.\x02%[1]s (eski sü" +
	"rüm)\x02WireGuard Çıkış Hatası\x02WireGuard için bir güncelleme mevcut. " +
	"Bekletmeden güncelleme yapmanız önemle tavsiye edilir.\x02Şimdi Güncelle" +
	"\x02Hata: %[1]v. Lütfen yeniden deneyin.\x02Durum: Tamamlandı!\x02WireGu" +
	"ard sistem tepsisi ikonu 30 saniye sonunda belirmedi.\x02Parantezler bir" +
	" IPv6 adresi içermelidir\x02Anahtarlar çözüldüğünde tam 32 byte olmalı" +
	"\x02Satır bir bölümde olmalı\x02Yapılandırma anahtarında eşittir operatö" +
	"rü eksik\x02Anahtar bir değere sahip olmalı\x02[Interface] bölümü için g" +
	"eçersiz anahtar\x02[Peer] bölümü için geçersiz anahtar\x02Bir arabirim g" +
	"izli anahtara sahip olmalıdır\x02Arabirim bölümünde geçersiz anahtar\x02" +
	"Protokol sürümü 1 olmak zorunda\x02Eş bölümünde geçersiz anahtar\x02Komu" +
	"t dosyaları:\x02Aktarım:\x02bağlantı-öncesi\x02bağlantı-sonrası\x02bağla" +
	"ntı-kesme-öncesi\x02bağlantı-kesme-sonrası\x02ilke gereği kapalı\x02etki" +
	"n\x02%[1]s alındı, %[2]s gönderildi\x02Tünel durumu belirlenemedi\x02Tün" +
	"el etkinleştirilemedi\x02Tünel devre dışı bırakılamadı\x02Arabirim: %[1]" +
	"s\x02Eş\x02Yeni tünel oluştur\x02Tüneli düzenle\x02&İsim:\x02&Açık anaht" +
	"ar:\x02(bilinmiyor)\x02&Tünelden geçmeyen trafiği durdur (kill-switch)" +
	"\x02&Kaydet\x02İptal\x02&Yapılandırma:\x02Geçersiz isim\x02Bir isim gere" +
	"kli.\x02`%[1]s` geçersiz bir tünel ismi.\x02Mevcut tüneller listelenemiy" +
	"or\x02Tünel zaten mevcut\x02‘%[1]s’ adında başka bir tünel mevcut.\x02Ye" +
	"ni yapılandırma oluşturulamıyor\x02Dosya yazılamadı\x02`%[1]s` dosyası z" +
	"aten mevcut.\x0a\x0aÜzerine yazmak ister misiniz?\x02Etkin\x02Etkinleşti" +
	"riliyor\x02Metin Dosyaları (*.txt)|*.txt|Tüm Dosyalar (*.*)|*.*\x02WireG" +
	"uard Tespit Hatası\x02WireGuard penceresinin belirmesi beklenemedi: %[1]" +
	"v\x02WireGuard: Devre dışı\x02Durum: Bilinmiyor\x02Adresler: Yok\x02Tüne" +
	"lleri yönet (&m)…\x02Dosyadan tünelleri içe aktar (&i)…\x02Çık (&x)\x02T" +
	"üneller (&t)\x02WireGuard Etkin\x02%[1]s tüneli etkinleştirildi.\x02Wir" +
	"eGuard Devre Dışı Bırakıldı\x02%[1]s tüneli devre dışı bırakıldı.\x02Wir" +
	"eGuard Tünel Hatası\x02WireGuard: %[1]s\x02Durum: %[1]s\x02Adresler: %[1" +
	"]s\x02Güncelleme Mevcut!\x02WireGuard Güncellemesi Mevcut\x02WireGuard i" +
	"çin bir güncelleme mevcut. İlk fırsatta güncelleme yapmanız tavsiye edi" +
	"lir.\x02Tüneller\x02&Edit\x02Boş tünel ekle (&e)…\x02Tünel Ekle\x02Seçil" +
	"en tünelleri kaldır\x02Tüm tünelleri zip olarak dışa aktar\x02&Değiştir" +
	"\x02Tüm tünelleri &zip olarak dışa aktar…\x02&Seçilen tüneli düzenle…" +
	"\x02S&eçilen tünelleri kaldır\x02yapılandırma dosyası bulunamadı\x02Seçi" +
	"len yapılandırma içe aktarılamadı: %[1]v\x02Mevcut tüneller numaralandır" +
	"ılamadı: %[1]v\x02‘%[1]s’ adında başka bir tünel mevcut\x02Yapılandırma" +
	" içe aktarılamıyor: %[1]v\x02Tüneller içe aktarıldı\x14\x01\x81\x01\x00" +
	"\x02\x1e\x02%[1]d tünel içe aktarıldı\x00\x1e\x02%[1]d tünel içe aktarıl" +
	"dı\x14\x02\x80\x01\x02$\x02%[2]d/%[1]d tünel içe aktarıldı\x00$\x02%[2]d" +
	"/%[1]d tünel içe aktarıldı\x02Tünel oluşturulamıyor\x14\x01\x81\x01\x00" +
	"\x02\x12\x02%[1]d tüneli sil\x00\x12\x02%[1]d tüneli sil\x14\x01\x81\x01" +
	"\x00\x023\x02%[1]d tüneli silmek istediğinizden emin misiniz?\x003\x02%[" +
	"1]d tüneli silmek istediğinizden emin misiniz?\x02‘%[1]s’ tünelini sil" +
	"\x02‘%[1]s’ tünelini silmek istediğinizden emin misiniz?\x02%[1]s Bu işl" +
	"emi geri alamazsınız.\x02Tünel silinemiyor\x02Bir tünel kaldırılamadı: %" +
	"[1]s\x02Tüneller silinemiyor\x14\x01\x81\x01\x00\x02\x1f\x02%[1]d tünel " +
	"kaldırılamadı.\x00\x1f\x02%[1]d tünel kaldırılamadı.\x02Yapılandırma Dos" +
	"yaları (*.zip, *.conf)|*.zip;*.conf|Tüm Dosyalar (*.*)|*.*\x02Tünelleri " +
	"dosyadan içe aktar\x02Yapılandırma ZIP Dosyası (*.zip)|*.zip\x02Tüneller" +
	"i zip olarak dışa aktar\x02%[1]s (imzasız derleme, güncelleme yok)\x02Hi" +
	"zmet şu nedenden dolayı kapatılamıyor: %[1]v. WireGuard'ı hizmet yönetic" +
	"isinden durdurabilirsiniz.\x02Durum: Kullanıcı bekleniyor\x02Durum: Günc" +
	"elleştirme hizmeti bekleniyor"

var ukIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x0000000f, 0x0000008e, 0x000000b7,
	0x000000ea, 0x00000144, 0x000001c2, 0x0000021b,
	0x000002b7, 0x00000339, 0x00000344, 0x00000397,
	0x00000397, 0x00000397, 0x00000397, 0x00000397,
	0x00000397, 0x000003a6, 0x000003af, 0x000003bc,
	0x000003c9, 0x000003d6, 0x000003e3, 0x000003f0,
	0x00000411, 0x0000044d, 0x00000488, 0x000004c0,
	0x000004d7, 0x000004f3, 0x00000523, 0x00000546,
	// Entry 20 - 3F
	0x00000592, 0x000005b1, 0x000005de, 0x00000603,
	0x0000064f, 0x00000691, 0x00000694, 0x00000697,
	0x000006a8, 0x000006d8, 0x000006e7, 0x00000706,
	0x00000714, 0x0000072e, 0x00000744, 0x00000761,
	0x0000076b, 0x00000770, 0x0000077e, 0x00000792,
	0x000007a6, 0x000007ca, 0x000007d4, 0x000007ea,
	0x00000815, 0x00000815, 0x00000815, 0x00000815,
	0x00000815, 0x00000815, 0x00000815, 0x00000815,
	// Entry 40 - 5F
	0x00000815, 0x00000815, 0x00000815, 0x00000815,
	0x00000815, 0x00000815, 0x00000815, 0x00000815,
	0x00000815, 0x00000815, 0x00000815, 0x00000815,
	0x0000086c, 0x000008a7, 0x000008e9, 0x0000092f,
	0x0000098a, 0x000009bc, 0x000009f4, 0x00000a27,
	0x00000a6e, 0x00000ab5, 0x00000aef, 0x00000b22,
	0x00000b32, 0x00000b44, 0x00000b60, 0x00000b7a,
	0x00000b96, 0x00000bb0, 0x00000bed, 0x00000c00,
	// Entry 60 - 7F
	0x00000c35, 0x00000c72, 0x00000ca8, 0x00000ce2,
	0x00000cfc, 0x00000d03, 0x00000d2c, 0x00000d4e,
	0x00000d5b, 0x00000d79, 0x00000d8e, 0x00000dc7,
	0x00000dd9, 0x00000dec, 0x00000e07, 0x00000e1a,
	0x00000e43, 0x00000e76, 0x00000ebd, 0x00000edc,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	// Entry 80 - 9F
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f15, 0x00000f15, 0x00000f15,
	0x00000f15, 0x00000f51, 0x00000fab, 0x00000ffb,
	0x00001033, 0x0000107e, 0x000010a2, 0x0000115b,
	// Entry A0 - BF
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	// Entry C0 - DF
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	// Entry E0 - FF
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	// Entry 100 - 11F
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b, 0x0000115b, 0x0000115b,
	0x0000115b, 0x0000115b,
} // Size: 1136 bytes

const ukData string = "" + // Size: 4443 bytes
	"\x02Помилка\x02(немає аргумента): отримати права аднімістратора і встано" +
	"вити службу\x02Використання: %[1]s [\x0a%[2]s]\x02Параметри командного " +
	"рядка\x02Неможливо визначити, чи працює процес під WOW64: %[1]v\x02Ви п" +
	"овинні використовувати нативну версію WireGuard на цьому комп'ютері." +
	"\x02Не вдалося відкрити токен поточного процесу: %[1]v\x02WireGuard може" +
	" бути використаний тільки користувачами, які є членами вбудованих %[1]s " +
	"груп.\x02WireGuard запущено, але UI доступний лише з комп\x22ютерів вбу" +
	"дованої %[1]s групи.\x02Зараз\x02Системний годинник налаштований некоре" +
	"ктно!\x02%[1]s тому\x02%[1]d Б\x02%.2[1]f КБ\x02%.2[1]f МБ\x02%.2[1]f Г" +
	"Б\x02%.2[1]f ТБ\x02%[1]s: %[2]q\x02Недійсна IP-адреса\x02Невірна довжин" +
	"а префіксу мережі\x02Відсутній порт з кінцевої точки\x02Недійсний хост " +
	"кінцевої точки\x02Недійсний MTU\x02Недійсний порт\x02Некоректне значенн" +
	"я keepalive\x02Недійсний ключ: %[1]v\x02Номер повинен бути числом від 0" +
	" до 2^64-1: %[1]v\x02Дві коми поспіль\x02Назва тунелю некоректна\x02[жод" +
	"ного не вказано]\x02Всі учасники повинні мати відкриті ключі\x02Помилка" +
	" при отриманні конфігурації\x02, \x02, \x02Про WireGuard\x02Зображення л" +
	"оготипу WireGuard\x02Закрити\x02♥ &Пожертвувати!\x02Статус:\x02&Деактив" +
	"увати\x02&Активувати\x02Відкритий ключ:\x02Порт:\x02MTU:\x02Адреси:\x02" +
	"DNS-сервери:\x02Preshared ключ:\x02Дозволені IP адреси:\x02Endpoint:\x02" +
	"Persistent keepalive:\x02Останнє рукостискання:\x02Значок системи WireGu" +
	"ard не з'явився через 30 секунд.\x02Дужки повинні містити адресу IPv6" +
	"\x02Ключ повинен декодуватись до 32 байт\x02Рядок повинен бути вказаним " +
	"у розділі\x02Ключ конфігурації відсутній роздільник рівності\x02Ключ по" +
	"винен мати значення\x02Хибний ключ для [Interface] розділу\x02Хибний кл" +
	"юч для [Peer] розділу\x02Інтерфейс повинен мати особистий ключ\x02Недій" +
	"сний ключ для розділу інтерфейсу\x02Версія протоколу повинна бути 1\x02" +
	"Хибний ключ для [Peer] розділу\x02Скрипти:\x02Передано:\x02перед-запуск" +
	"ом\x02після-запуску\x02перед-зупинкою\x02після-зупинки\x02вимкнено, від" +
	"повідно до політики\x02увімкнено\x02%[1]s отримано, %[2]s відправлено" +
	"\x02Не вдалося визначити стан тунелю\x02Не вдалося активувати тунель\x02" +
	"Не вдалося деактивувати тунель\x02Інтерфейс: %[1]s\x02Пір\x02Створити н" +
	"овий тунель\x02Редагувати тунель\x02&Назва:\x02&Публічний ключ:\x02(нев" +
	"ідомий)\x02&Блокувати трафік поза тунелем\x02&Зберегти\x02Скасувати\x02" +
	"&Налаштування:\x02Хибне ім'я\x02Необхідно ввести ім'я.\x02Ім'я тунелю '%" +
	"[1]s' некоректне.\x02Не вдалося відобразити існуючі тунелі\x02Тунель вже" +
	" існує\x02Тунель з ім'ям ‘%[1]s’ вже існує.\x02не знайдено файлів конфіг" +
	"урації\x02Не вдалося імпортувати вибрану конфігурацію: %[1]v\x02Не вдал" +
	"ося перерахувати існуючі тунелі: %[1]v\x02Тунель з ім'ям ‘%[1]s’ вже іс" +
	"нує\x02Не вдалося імпортувати конфігурацію: %[1]v\x02Імпортовано тунелі" +
	"\x14\x01\x81\x01\x00\x04*\x02Імпортовано %[1]d тунелі\x05,\x02Імпортован" +
	"о %[1]d тунелів\x02*\x02Імпортовано %[1]d тунель\x00,\x02Імпортовано %[" +
	"1]d тунелів"

var viIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x00000006, 0x00000006,
	0x00000006, 0x00000006, 0x00000011, 0x00000011,
	0x00000023, 0x00000036, 0x00000049, 0x0000005c,
	0x0000006f, 0x0000007e, 0x0000007e, 0x0000007e,
	0x0000007e, 0x0000007e, 0x0000007e, 0x0000007e,
	0x000000a0, 0x000000a0, 0x000000a0, 0x000000a0,
	0x000000a0, 0x000000c0, 0x000000c0, 0x000000c0,
	// Entry 20 - 3F
	0x000000c0, 0x000000c0, 0x000000db, 0x000000db,
	0x000000db, 0x000000db, 0x000000db, 0x000000db,
	0x000000f5, 0x00000104, 0x0000010b, 0x0000010b,
	0x0000011a, 0x0000011a, 0x0000011a, 0x0000011a,
	0x0000011a, 0x0000011a, 0x0000011a, 0x0000011a,
	0x0000011a, 0x0000011a, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	// Entry 40 - 5F
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x00000129,
	0x00000129, 0x00000129, 0x00000129, 0x0000013b,
	// Entry 60 - 7F
	0x00000155, 0x00000181, 0x0000019f, 0x000001c0,
	0x000001c0, 0x000001d3, 0x000001dd, 0x000001ef,
	0x000001ef, 0x000001ef, 0x000001ef, 0x000001ef,
	0x000001ef, 0x000001f5, 0x000001f5, 0x0000020c,
	0x00000224, 0x0000024a, 0x0000026b, 0x00000280,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	// Entry 80 - 9F
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	// Entry A0 - BF
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	// Entry C0 - DF
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	// Entry E0 - FF
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	// Entry 100 - 11F
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad, 0x000002ad, 0x000002ad,
	0x000002ad, 0x000002ad,
} // Size: 1136 bytes

const viData string = "" + // Size: 685 bytes
	"\x02Lỗi\x02Vừa xong\x14\x01\x81\x01\x00\x00\x0b\x02%[1]d năm\x14\x01\x81" +
	"\x01\x00\x00\x0c\x02%[1]d ngày\x14\x01\x81\x01\x00\x00\x0c\x02%[1]d giờ" +
	"\x14\x01\x81\x01\x00\x00\x0c\x02%[1]d phút\x14\x01\x81\x01\x00\x00\x0c" +
	"\x02%[1]d giây\x02%[1]s trước\x02Địa chỉ IP không hợp lệ\x02Cổng (port) " +
	"không hợp lệ\x02Tên VPN không hợp lệ\x02Thông tin về WireGuard\x02Logo W" +
	"ireGuard\x02Đóng\x02Trạng thái:\x02Đầu cuối:\x02đã kích hoạt\x02Nhận %[1" +
	"]s, gứi %[2]s\x02Không thể xác định tình trạng VPN\x02Không thể kích hoạ" +
	"t VPN\x02Không thể vô hiệu hóa VPN\x02Mạng ngang hàng\x02Tạo VPN\x02Chỉn" +
	"h sửa VPN\x02Huỷ\x02Tên không hợp lệ\x02Yêu cầu nhập tên.\x02Tên VPN ‘%[" +
	"1]s' không hợp lệ.\x02Không thể liệt kê các VPN\x02VPN đã tồn tại\x02Đã " +
	"tồn tại VPN với tên ‘%[1]s’."

var zh_CNIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000030, 0x00000047,
	0x00000057, 0x0000008b, 0x000000c9, 0x000000ef,
	0x00000134, 0x0000018e, 0x00000195, 0x000001ae,
	0x000001bf, 0x000001d0, 0x000001e4, 0x000001f8,
	0x00000209, 0x00000213, 0x0000021b, 0x00000228,
	0x00000235, 0x00000242, 0x0000024f, 0x0000025c,
	0x0000026b, 0x00000284, 0x000002a6, 0x000002cd,
	0x000002d8, 0x000002e5, 0x000002fe, 0x00000316,
	// Entry 20 - 3F
	0x00000344, 0x0000035d, 0x00000370, 0x0000037c,
	0x0000039e, 0x000003b4, 0x000003b8, 0x000003ba,
	0x000003cb, 0x000003e1, 0x000003e8, 0x000003f9,
	0x00000401, 0x0000040d, 0x00000419, 0x00000421,
	0x0000042f, 0x00000434, 0x0000043c, 0x0000044b,
	0x0000045c, 0x0000046a, 0x00000472, 0x00000486,
	0x0000049a, 0x000004a4, 0x000004b1, 0x000004b8,
	0x000004bf, 0x000004cb, 0x000004d7, 0x000004e6,
	// Entry 40 - 5F
	0x000004ed, 0x000004fa, 0x00000507, 0x00000520,
	0x0000052d, 0x00000553, 0x00000565, 0x00000580,
	0x000005b8, 0x000005c5, 0x000005e2, 0x000005f4,
	0x0000062b, 0x00000653, 0x0000067d, 0x00000699,
	0x000006be, 0x000006d1, 0x000006f6, 0x00000716,
	0x00000732, 0x0000074b, 0x00000763, 0x0000077c,
	0x00000784, 0x0000078c, 0x00000796, 0x000007a0,
	0x000007aa, 0x000007b4, 0x000007d3, 0x000007dd,
	// Entry 60 - 7F
	0x000007f8, 0x00000811, 0x00000824, 0x0000083d,
	0x0000084b, 0x00000852, 0x00000862, 0x0000086f,
	0x0000087c, 0x00000889, 0x00000892, 0x000008c1,
	0x000008cd, 0x000008d4, 0x000008e1, 0x000008ee,
	0x00000904, 0x00000922, 0x0000093b, 0x0000094b,
	0x0000096c, 0x00000985, 0x00000998, 0x000009d3,
	0x000009dd, 0x000009ea, 0x00000a1c, 0x00000a33,
	0x00000a5e, 0x00000a73, 0x00000a82, 0x00000a8e,
	// Entry 80 - 9F
	0x00000aa3, 0x00000ac1, 0x00000acd, 0x00000ad9,
	0x00000aed, 0x00000b0b, 0x00000b1f, 0x00000b43,
	0x00000b5a, 0x00000b6b, 0x00000b79, 0x00000b87,
	0x00000b97, 0x00000ba8, 0x00000bea, 0x00000bf1,
	0x00000bfd, 0x00000c15, 0x00000c22, 0x00000c35,
	0x00000c58, 0x00000c70, 0x00000c9b, 0x00000cb6,
	0x00000cce, 0x00000ce4, 0x00000cfe, 0x00000d1e,
	0x00000d4b, 0x00000d65, 0x00000d72, 0x00000d93,
	// Entry A0 - BF
	0x00000dc9, 0x00000ddc, 0x00000dfa, 0x00000e2d,
	0x00000e45, 0x00000e6f, 0x00000e8d, 0x00000ea0,
	0x00000eba, 0x00000ecd, 0x00000ef4, 0x00000f35,
	0x00000f4b, 0x00000f66, 0x00000f89, 0x00000fb6,
	0x00001017, 0x0000102c, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	// Entry C0 - DF
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	// Entry E0 - FF
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	// Entry 100 - 11F
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047, 0x00001047, 0x00001047,
	0x00001047, 0x00001047,
} // Size: 1136 bytes

const zh_CNData string = "" + // Size: 4167 bytes
	"\x02错误\x02(无参数): 提升并安装管理服务\x02用法: %[1]s [\x0a%[2]s]\x02命令行选项\x02无法确定该进程是" +
	"否在WOW64下运行: %[1]v\x02您必须在此计算机上使用原生版本的 WireGuard。\x02无法打开当前进程令牌: %[1]v" +
	"\x02WireGuard 可能只能被内建的 %[1]s 小组中的成员使用。\x02WireGuard 正在运行，但用户界面只能从内建的 %[1" +
	"]s 小组的桌面访问。\x02刚刚\x02系统时间倒退了！\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 年\x14" +
	"\x01\x81\x01\x00\x00\x0a\x02%[1]d 天\x14\x01\x81\x01\x00\x00\x0d\x02%[1]d" +
	" 小时\x14\x01\x81\x01\x00\x00\x0d\x02%[1]d 分钟\x14\x01\x81\x01\x00\x00\x0a" +
	"\x02%[1]d 秒\x02%[1]s 前\x02%[1]d B\x02%.2[1]f\u00a0KiB\x02%.2[1]f\u00a0Mi" +
	"B\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB\x02%[1]s: %[2]q\x02IP地址无效\x02网" +
	"络前缀长度无效\x02对端 (endpoint) 中缺少端口\x02对端主机名 (endpoint host) 无效\x02MTU 无效" +
	"\x02端口无效\x02连接保活间隔无效\x02无效的密钥：%[1]v\x02数值必须介于 0 至 2^64-1 之间: %[1]v\x02一行" +
	"中有两个逗号\x02隧道名称无效\x02[未指定]\x02每个节点都必须指定公钥\x02获取配置时出错\x02、\x02 \x02关于 Wi" +
	"reGuard\x02WireGuard logo 图片\x02关闭\x02♥ 捐助! (&D)\x02状态:\x02断开 (&D)\x02连接" +
	" (&A)\x02公钥:\x02监听端口:\x02MTU:\x02地址:\x02DNS 服务器:\x02预共享密钥:\x02允许的 IP:" +
	"\x02对端:\x02连接保活间隔:\x02上次握手时间:\x02已断开\x02正在断开\x02未知\x02日志\x02复制 (&C)\x02全" +
	"选 (&A)\x02导出… (&S)\x02时间\x02日志消息\x02导出日志\x02关于 WireGuard… (&A)\x02隧道错误" +
	"\x02%[1]s\x0a\x0a更多信息请查看日志。\x02%[1]s (已过时)\x02退出 WireGuard 时出错\x02发现新版 W" +
	"ireGuard。强烈建议您现在安装。\x02立即更新\x02错误: %[1]v。请重试。\x02状态: 完成！\x02WireGuard 系统" +
	"托盘图标在30秒后没有出现。\x02方括号中应包含一个 IPv6 地址\x02解码后的密钥长度必须为32字节\x02行必须出现在段落中" +
	"\x02配置项必须要有一个等于号\x02必须有一个值\x02[Interface] 段落中的该键无效\x02[Peer] 段落中的该键无效" +
	"\x02接口必须有一个私钥\x02接口段落的键无效\x02协议版本必须为 1\x02节点段落的键无效\x02脚本:\x02流量:\x02连接前" +
	"\x02连接后\x02断开前\x02断开后\x02已禁用（依管理策略）\x02已启用\x02接收 %[1]s, 发送 %[2]s\x02无法确认" +
	"隧道状态\x02无法连接隧道\x02无法断开隧道连接\x02接口: %[1]s\x02节点\x02创建新隧道\x02编辑隧道\x02名称 (" +
	"&N):\x02公钥 (&P):\x02(未知)\x02拦截未经隧道的流量 (kill-switch) (&B)\x02保存 (&S)\x02取" +
	"消\x02配置 (&C):\x02名称无效\x02必须输入名称。\x02隧道名「%[1]s」无效。\x02无法列出现有隧道\x02隧道已存在" +
	"\x02隧道名「%[1]s」已存在。\x02无法创建新的配置\x02写入文件失败\x02文件「%[1]s」已存在。\x0a\x0a您确定要覆盖它" +
	"吗？\x02已连接\x02正在连接\x02文本文件 (*.txt)|*.txt|所有文件 (*.*)|*.*\x02WireGuard 检测" +
	"错误\x02无法等待 WireGuard 窗口出现: %[1]v\x02WireGuard: 已断开\x02状态: 未知\x02地址: 无" +
	"\x02管理隧道… (&M)\x02从文件导入隧道… (&I)\x02退出 (&E)\x02隧道 (&T)\x02WireGuard 已连接" +
	"\x02隧道「%[1]s」已连接。\x02WireGuard 已断开\x02隧道「%[1]s」已断开连接。\x02WireGuard 隧道错误" +
	"\x02WireGuard: %[1]s\x02状态: %[1]s\x02地址: %[1]s\x02发现更新！\x02WireGuard 更新" +
	"\x02新的 WireGuard 版本发布了。强烈建议您现在安装。\x02隧道\x02编辑 (&E)\x02新建空隧道… (&E)\x02新建隧" +
	"道\x02删除所选隧道\x02导出所有隧道 (ZIP 压缩包)\x02切换连接状态 (&T)\x02导出所有隧道 (ZIP 压缩包)… (&" +
	"Z)\x02编辑所选隧道… (&E)\x02删除所选隧道 (&R)\x02未找到配置文件\x02无法导入配置: %[1]v\x02无法列出现有隧" +
	"道: %[1]v\x02另一个同名的隧道「%[1]s」已存在\x02无法导入配置: %[1]v\x02导入隧道\x14\x01\x81" +
	"\x01\x00\x00\x1a\x02导入了 %[1]d 个隧道\x14\x02\x80\x01\x000\x02导入了 %[2]d 个隧道中" +
	"的 %[1]d 个隧道\x02无法创建隧道\x14\x01\x81\x01\x00\x00\x17\x02删除 %[1]d 个隧道\x14" +
	"\x01\x81\x01\x00\x00,\x02您确定要删除这 %[1]d 个隧道吗？\x02删除隧道「%[1]s」\x02您确定要删除隧道「" +
	"%[1]s」吗？\x02%[1]s此操作无法撤销。\x02无法删除隧道\x02无法删除隧道: %[1]s\x02无法删除隧道\x14\x01" +
	"\x81\x01\x00\x00 \x02无法删除 %[1]d 个隧道。\x02配置文件 (*.zip, *.conf)|*.zip;*.con" +
	"f|所有文件 (*.*)|*.*\x02从文件导入隧道\x02配置文件 (*.zip)|*.zip\x02导出配置文件 (ZIP 压缩包)" +
	"\x02%[1]s (未签名版本，禁用自动更新)\x02无法停止服务: %[1]v。您可能需要在服务管理器中手动停止 WireGuard 服务。" +
	"\x02状态: 等待用户\x02状态: 等待更新服务"

var zh_TWIndex = []uint32{ // 278 elements
	// Entry 0 - 1F
	0x00000000, 0x00000007, 0x00000037, 0x00000056,
	0x00000066, 0x000000a4, 0x000000df, 0x00000110,
	0x00000153, 0x000001b8, 0x000001c5, 0x000001de,
	0x000001ef, 0x00000200, 0x00000214, 0x00000228,
	0x00000239, 0x00000243, 0x0000024c, 0x00000259,
	0x00000266, 0x00000273, 0x00000280, 0x0000028f,
	0x000002a3, 0x000002c5, 0x000002e4, 0x000002fe,
	0x0000030c, 0x0000031c, 0x00000342, 0x0000035b,
	// Entry 20 - 3F
	0x00000384, 0x0000039d, 0x000003b0, 0x000003bc,
	0x000003de, 0x000003fa, 0x000003fe, 0x00000400,
	0x00000411, 0x00000427, 0x0000042e, 0x00000441,
	0x00000448, 0x0000045a, 0x00000466, 0x0000046d,
	0x00000477, 0x0000047b, 0x00000482, 0x00000490,
	0x000004a0, 0x000004b0, 0x000004ba, 0x000004cb,
	0x000004de, 0x000004ee, 0x000004fe, 0x00000505,
	0x0000050c, 0x00000518, 0x00000524, 0x00000533,
	// Entry 40 - 5F
	0x0000053a, 0x00000547, 0x00000557, 0x0000056d,
	0x0000057a, 0x000005a9, 0x000005be, 0x000005d6,
	0x0000062b, 0x00000638, 0x0000065d, 0x00000673,
	0x000006af, 0x000006d7, 0x000006f6, 0x00000712,
	0x0000073a, 0x00000750, 0x0000076f, 0x00000789,
	0x000007af, 0x000007cc, 0x000007e4, 0x000007fc,
	0x00000809, 0x00000810, 0x0000081a, 0x00000824,
	0x0000082e, 0x00000838, 0x00000850, 0x0000085a,
	// Entry 60 - 7F
	0x0000087c, 0x00000895, 0x000008a8, 0x000008c1,
	0x000008d0, 0x000008d7, 0x000008e7, 0x000008fa,
	0x00000906, 0x00000912, 0x0000091b, 0x00000950,
	0x0000095c, 0x00000963, 0x0000096f, 0x0000097f,
	0x00000995, 0x000009b9, 0x000009d2, 0x000009e2,
	0x00000a03, 0x00000a22, 0x00000a35, 0x00000a68,
	0x00000a72, 0x00000a82, 0x00000ab1, 0x00000ac9,
	0x00000af6, 0x00000b0c, 0x00000b1c, 0x00000b29,
	// Entry 80 - 9F
	0x00000b3b, 0x00000b53, 0x00000b5f, 0x00000b5f,
	0x00000b73, 0x00000b8e, 0x00000ba8, 0x00000bcc,
	0x00000be3, 0x00000bf5, 0x00000c04, 0x00000c12,
	0x00000c19, 0x00000c2a, 0x00000c83, 0x00000c8a,
	0x00000c96, 0x00000cae, 0x00000cbb, 0x00000cce,
	0x00000cf1, 0x00000d09, 0x00000d2e, 0x00000d46,
	0x00000d61, 0x00000d74, 0x00000d90, 0x00000dac,
	0x00000dd6, 0x00000df2, 0x00000e02, 0x00000e23,
	// Entry A0 - BF
	0x00000e56, 0x00000e69, 0x00000e87, 0x00000eb7,
	0x00000ecc, 0x00000ef6, 0x00000f1c, 0x00000f2f,
	0x00000f4b, 0x00000f5e, 0x00000f82, 0x00000fc6,
	0x00000fe2, 0x00001000, 0x00001019, 0x0000104f,
	0x000010b0, 0x000010c9, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	// Entry C0 - DF
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	// Entry E0 - FF
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	// Entry 100 - 11F
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5, 0x000010e5, 0x000010e5,
	0x000010e5, 0x000010e5,
} // Size: 1136 bytes

const zh_TWData string = "" + // Size: 4325 bytes
	"\x02錯誤\x02(無參數)：提升權限並安裝管理服務\x02使用方法： %[1]s [\x0a%[2]s]\x02命令列選項\x02無法確定該" +
	"處理程序是否在 WOW64 下執行： %[1]v\x02您必須在此電腦上執行原生版本的 WireGuard。\x02無法開啓目前處理程序的權" +
	"杖： %[1]v\x02WireGuard 可能只能被內建的「%[1]s」群組成員使用。\x02WireGuard 正在執行，但 UI 只能" +
	"從內建的內建的「%[1]s」群組成員的桌面存取。\x02就是現在\x02系統時鐘倒退了！\x14\x01\x81\x01\x00\x00" +
	"\x0a\x02%[1]d 年\x14\x01\x81\x01\x00\x00\x0a\x02%[1]d 天\x14\x01\x81\x01" +
	"\x00\x00\x0d\x02%[1]d 小時\x14\x01\x81\x01\x00\x00\x0d\x02%[1]d 分鐘\x14\x01" +
	"\x81\x01\x00\x00\x0a\x02%[1]d 秒\x02%[1]s 前\x02%[1]d\u00a0B\x02%.2[1]f" +
	"\u00a0KiB\x02%.2[1]f\u00a0MiB\x02%.2[1]f\u00a0GiB\x02%.2[1]f\u00a0TiB" +
	"\x02%[1]s： %[2]q\x02無效的 IP 位址\x02無效的網路位址首碼長度\x02Endpoint 中沒有指定埠號\x02無效的 " +
	"Endpoint 位址\x02無效的 MTU\x02無效的埠號\x02無效的 Persistent Keepalive 設定\x02無效的金鑰：" +
	" %[1]v\x02數值必須介於 0 到 2^64-1： %[1]v\x02一行中有兩個逗號\x02隧道名稱無效\x02[未指定]\x02每個 " +
	"Peer 都必須要有公鑰\x02讀取設定時發生錯誤\x02、\x02 \x02關於 WireGuard\x02WireGuard logo 圖片" +
	"\x02關閉\x02♥ 捐贈！ (&D)\x02狀態\x02中斷連線 (&D)\x02連線 (&A)\x02公鑰\x02監聽埠\x02MTU" +
	"\x02位址\x02DNS 伺服器\x02預交換金鑰\x02允許的位址\x02連接點\x02Keepalive 間隔\x02最後交握時間\x02" +
	"已中斷連線\x02正在中斷…\x02未知\x02日誌\x02複製 (&C)\x02全選 (&A)\x02匯出… (&S)\x02時間\x02" +
	"日誌訊息\x02匯出日誌…\x02關於 WireGuard (&A)\x02隧道錯誤\x02%[1]s\x0a\x0a如需更多資訊，請查看日" +
	"誌。\x02%[1]s（已過時）\x02離開 WireGuard 失敗\x02更新的 WireGuard 已經為您準備好了。\x0a強烈建議" +
	"您立即進行更新。\x02立即更新\x02錯誤： %[1]v。請稍後再試。\x02狀態：已完成！\x02WireGuard 的工作列圖示在 3" +
	"0 秒後並沒有顯示。\x02括號中必須包含一個 IPv6 位址\x02金鑰必須剛好長 32 bytes\x02行必須出現在段落中\x02設定的項" +
	"目必須要有一個等號\x02必須要有一個值\x02[Interface] 中有無效選項\x02[Peer] 中有無效選項\x02Interfa" +
	"ce 中必須要有一把私鑰\x02Interface 中的金鑰無效\x02協定版本必須為 1\x02Peer 中的金鑰無效\x02指令碼：\x02" +
	"流量\x02連接前\x02連接後\x02斷線前\x02斷線後\x02已關閉, 隨著策略\x02已啓用\x02已收到 %[1]s；已傳送 %[" +
	"2]s\x02無法確認隧道狀態\x02無法連接隧道\x02無法斷開隧道連線\x02[隧道] %[1]s\x02節點\x02建立新隧道\x02編輯" +
	"隧道設定\x02名稱 (&N)\x02公鑰 (&P)\x02(未知)\x02阻斷未經過隧道的流量（kill-switch） (&B)\x02" +
	"儲存 (&S)\x02取消\x02設定 (&C)\x02無效的名稱\x02必須填寫名稱。\x02無效的隧道名稱「%[1]s」。\x02無法列" +
	"出現有隧道\x02隧道已存在\x02已有同名隧道「%[1]s」。\x02無法建立新的隧道設定\x02檔案寫入失敗\x02檔案已存在： %[1" +
	"]s\x0a\x0a您確定要覆蓋嗎？\x02已連線\x02正在連線…\x02純文字 (*.txt)|*.txt|所有檔案 (*.*)|*.*" +
	"\x02偵測 WireGuard 錯誤\x02無法等待 WireGuard 視窗開啓： %[1]v\x02WireGuard - 未連線\x02" +
	"[狀態] 未知\x02[位址] 無\x02管理隧道 (&M)\x02從檔案匯入… (&I)\x02離開 (&X)\x02WireGuard 已連" +
	"線\x02已連線至隧道 - %[1]s\x02WireGuard 已中斷連線\x02已中斷與隧道的連線 - %[1]s\x02WireGua" +
	"rd 隧道錯誤\x02WireGuard - %[1]s\x02[狀態] %[1]s\x02位址: %[1]s\x02更新\x02WireGua" +
	"rd 更新\x02更新的 WireGuard 已經為您準備好了。\x0a強烈建議您立即更新 WireGuard。\x02隧道\x02編輯 (&E" +
	")\x02新增隧道精靈 (&E)\x02新增隧道\x02刪除選取隧道\x02匯出所有隧道（ZIP 格式）\x02切換連線狀態 (&T)\x02匯" +
	"出所有隧道至 &ZIP 壓縮檔\x02編輯選取隧道 (&S)\x02刪除已選取隧道 (&R)\x02找不到設定檔\x02無法匯入設定： %[" +
	"1]v\x02無法列出隧道： %[1]v\x02已有另一個同名的隧道「%[1]s」\x02無法匯入設定： %[1]v\x02已匯入隧道\x14" +
	"\x01\x81\x01\x00\x00\x1a\x02已匯入 %[1]d 個隧道\x14\x02\x80\x01\x00-\x02已匯入 %[" +
	"1]d 個隧道（共 %[2]d 個）\x02無法建立隧道\x14\x01\x81\x01\x00\x00\x17\x02刪除 %[1]d 個隧道" +
	"\x14\x01\x81\x01\x00\x00)\x02您確定要刪除 %[1]d 個隧道嗎？\x02刪除隧道 - %[1]s\x02您確定要刪" +
	"除隧道「%[1]s」嗎？\x02%[1]s\x0a\x0a您將無法復原此操作。\x02無法刪除隧道\x02無法刪除隧道： %[1]s\x02" +
	"無法刪除隧道\x14\x01\x81\x01\x00\x00\x1d\x02無法刪除 %[1]d 個隧道\x02隧道設定檔 (*.zip, " +
	"*.conf)|*.zip;*.conf|所有檔案 (*.*)|*.*\x02從檔案中匯入隧道…\x02隧道設定檔 (*.zip)|*.zip" +
	"\x02匯出隧道設定至…\x02%[1]s（未簽署發行版本，無法自動更新）\x02無法結束服務： %[1]v。\x0a您可能需要手動從服務管理中" +
	"結束 WireGuard 服務。\x02狀態：等待使用者\x02狀態：等待更新服務"

	// Total table size 139447 bytes (136KiB); checksum: 43780019
