package autofill

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/cdp"
)

// CreditCard [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Autofill#type-CreditCard
type CreditCard struct {
	Number      string `json:"number"`      // 16-digit credit card number.
	Name        string `json:"name"`        // Name of the credit card owner.
	ExpiryMonth string `json:"expiryMonth"` // 2-digit expiry month.
	ExpiryYear  string `json:"expiryYear"`  // 4-digit expiry year.
	Cvc         string `json:"cvc"`         // 3-digit card verification code.
}

// AddressField [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Autofill#type-AddressField
type AddressField struct {
	Name  string `json:"name"`  // address field name, for example GIVEN_NAME.
	Value string `json:"value"` // address field value, for example Jon Doe.
}

// AddressFields a list of address fields.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Autofill#type-AddressFields
type AddressFields struct {
	Fields []*AddressField `json:"fields"`
}

// Address [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Autofill#type-Address
type Address struct {
	Fields []*AddressField `json:"fields"` // fields and values defining an address.
}

// AddressUI defines how an address can be displayed like in
// chrome://settings/addresses. Address UI is a two dimensional array, each
// inner array is an "address information line", and when rendered in a UI
// surface should be displayed as such. The following address UI for instance:
// [[{name: "GIVE_NAME", value: "Jon"}, {name: "FAMILY_NAME", value: "Doe"}],
// [{name: "CITY", value: "Munich"}, {name: "ZIP", value: "81456"}]] should
// allow the receiver to render: Jon Doe Munich 81456.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Autofill#type-AddressUI
type AddressUI struct {
	AddressFields []*AddressFields `json:"addressFields"` // A two dimension array containing the representation of values from an address profile.
}

// FillingStrategy specified whether a filled field was done so by using the
// html autocomplete attribute or autofill heuristics.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Autofill#type-FillingStrategy
type FillingStrategy string

// String returns the FillingStrategy as string value.
func (t FillingStrategy) String() string {
	return string(t)
}

// FillingStrategy values.
const (
	FillingStrategyAutocompleteAttribute FillingStrategy = "autocompleteAttribute"
	FillingStrategyAutofillInferred      FillingStrategy = "autofillInferred"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *FillingStrategy) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch FillingStrategy(s) {
	case FillingStrategyAutocompleteAttribute:
		*t = FillingStrategyAutocompleteAttribute
	case FillingStrategyAutofillInferred:
		*t = FillingStrategyAutofillInferred
	default:
		return fmt.Errorf("unknown FillingStrategy value: %v", s)
	}
	return nil
}

// FilledField [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Autofill#type-FilledField
type FilledField struct {
	HTMLType        string            `json:"htmlType"`        // The type of the field, e.g text, password etc.
	ID              string            `json:"id"`              // the html id
	Name            string            `json:"name"`            // the html name
	Value           string            `json:"value"`           // the field value
	AutofillType    string            `json:"autofillType"`    // The actual field type, e.g FAMILY_NAME
	FillingStrategy FillingStrategy   `json:"fillingStrategy"` // The filling strategy
	FrameID         cdp.FrameID       `json:"frameId"`         // The frame the field belongs to
	FieldID         cdp.BackendNodeID `json:"fieldId"`         // The form field's DOM node
}
