// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/gkemulticloud/v1/attached_service.proto

package gkemulticloudpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for `AttachedClusters.GenerateAttachedClusterInstallManifest`
// method.
type GenerateAttachedClusterInstallManifestRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// will be created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A client provided ID of the resource. Must be unique within the
	// parent resource.
	//
	// The provided ID will be part of the
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// name formatted as
	// `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
	//
	// When generating an install manifest for importing an existing Membership
	// resource, the attached_cluster_id field must be the Membership id.
	//
	// Membership names are formatted as
	// `projects/<project-id>/locations/<region>/memberships/<membership-id>`.
	AttachedClusterId string `protobuf:"bytes,2,opt,name=attached_cluster_id,json=attachedClusterId,proto3" json:"attached_cluster_id,omitempty"`
	// Required. The platform version for the cluster (e.g. `1.19.0-gke.1000`).
	//
	// You can list all supported versions on a given Google Cloud region by
	// calling
	// [GetAttachedServerConfig][google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedServerConfig].
	PlatformVersion string `protobuf:"bytes,3,opt,name=platform_version,json=platformVersion,proto3" json:"platform_version,omitempty"`
	// Optional. Proxy configuration for outbound HTTP(S) traffic.
	ProxyConfig *AttachedProxyConfig `protobuf:"bytes,4,opt,name=proxy_config,json=proxyConfig,proto3" json:"proxy_config,omitempty"`
}

func (x *GenerateAttachedClusterInstallManifestRequest) Reset() {
	*x = GenerateAttachedClusterInstallManifestRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAttachedClusterInstallManifestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAttachedClusterInstallManifestRequest) ProtoMessage() {}

func (x *GenerateAttachedClusterInstallManifestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAttachedClusterInstallManifestRequest.ProtoReflect.Descriptor instead.
func (*GenerateAttachedClusterInstallManifestRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{0}
}

func (x *GenerateAttachedClusterInstallManifestRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GenerateAttachedClusterInstallManifestRequest) GetAttachedClusterId() string {
	if x != nil {
		return x.AttachedClusterId
	}
	return ""
}

func (x *GenerateAttachedClusterInstallManifestRequest) GetPlatformVersion() string {
	if x != nil {
		return x.PlatformVersion
	}
	return ""
}

func (x *GenerateAttachedClusterInstallManifestRequest) GetProxyConfig() *AttachedProxyConfig {
	if x != nil {
		return x.ProxyConfig
	}
	return nil
}

// Response message for
// `AttachedClusters.GenerateAttachedClusterInstallManifest` method.
type GenerateAttachedClusterInstallManifestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of Kubernetes resources (in YAML format) to be applied
	// to the cluster to be attached.
	Manifest string `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
}

func (x *GenerateAttachedClusterInstallManifestResponse) Reset() {
	*x = GenerateAttachedClusterInstallManifestResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAttachedClusterInstallManifestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAttachedClusterInstallManifestResponse) ProtoMessage() {}

func (x *GenerateAttachedClusterInstallManifestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAttachedClusterInstallManifestResponse.ProtoReflect.Descriptor instead.
func (*GenerateAttachedClusterInstallManifestResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{1}
}

func (x *GenerateAttachedClusterInstallManifestResponse) GetManifest() string {
	if x != nil {
		return x.Manifest
	}
	return ""
}

// Request message for `AttachedClusters.CreateAttachedCluster` method.
type CreateAttachedClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// will be created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] to create.
	AttachedCluster *AttachedCluster `protobuf:"bytes,2,opt,name=attached_cluster,json=attachedCluster,proto3" json:"attached_cluster,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the
	// parent resource.
	//
	// The provided ID will be part of the
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// name formatted as
	// `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
	AttachedClusterId string `protobuf:"bytes,3,opt,name=attached_cluster_id,json=attachedClusterId,proto3" json:"attached_cluster_id,omitempty"`
	// If set, only validate the request, but do not actually create the cluster.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAttachedClusterRequest) Reset() {
	*x = CreateAttachedClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAttachedClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAttachedClusterRequest) ProtoMessage() {}

func (x *CreateAttachedClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAttachedClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateAttachedClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateAttachedClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAttachedClusterRequest) GetAttachedCluster() *AttachedCluster {
	if x != nil {
		return x.AttachedCluster
	}
	return nil
}

func (x *CreateAttachedClusterRequest) GetAttachedClusterId() string {
	if x != nil {
		return x.AttachedClusterId
	}
	return ""
}

func (x *CreateAttachedClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AttachedClusters.ImportAttachedCluster` method.
type ImportAttachedClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// will be created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// If set, only validate the request, but do not actually import the cluster.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. The name of the fleet membership resource to import.
	FleetMembership string `protobuf:"bytes,3,opt,name=fleet_membership,json=fleetMembership,proto3" json:"fleet_membership,omitempty"`
	// Required. The platform version for the cluster (e.g. `1.19.0-gke.1000`).
	//
	// You can list all supported versions on a given Google Cloud region by
	// calling
	// [GetAttachedServerConfig][google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedServerConfig].
	PlatformVersion string `protobuf:"bytes,4,opt,name=platform_version,json=platformVersion,proto3" json:"platform_version,omitempty"`
	// Required. The Kubernetes distribution of the underlying attached cluster.
	//
	// Supported values: ["eks", "aks"].
	Distribution string `protobuf:"bytes,5,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// Optional. Proxy configuration for outbound HTTP(S) traffic.
	ProxyConfig *AttachedProxyConfig `protobuf:"bytes,6,opt,name=proxy_config,json=proxyConfig,proto3" json:"proxy_config,omitempty"`
}

func (x *ImportAttachedClusterRequest) Reset() {
	*x = ImportAttachedClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAttachedClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAttachedClusterRequest) ProtoMessage() {}

func (x *ImportAttachedClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAttachedClusterRequest.ProtoReflect.Descriptor instead.
func (*ImportAttachedClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{3}
}

func (x *ImportAttachedClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportAttachedClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *ImportAttachedClusterRequest) GetFleetMembership() string {
	if x != nil {
		return x.FleetMembership
	}
	return ""
}

func (x *ImportAttachedClusterRequest) GetPlatformVersion() string {
	if x != nil {
		return x.PlatformVersion
	}
	return ""
}

func (x *ImportAttachedClusterRequest) GetDistribution() string {
	if x != nil {
		return x.Distribution
	}
	return ""
}

func (x *ImportAttachedClusterRequest) GetProxyConfig() *AttachedProxyConfig {
	if x != nil {
		return x.ProxyConfig
	}
	return nil
}

// Request message for `AttachedClusters.UpdateAttachedCluster` method.
type UpdateAttachedClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// to update.
	AttachedCluster *AttachedCluster `protobuf:"bytes,1,opt,name=attached_cluster,json=attachedCluster,proto3" json:"attached_cluster,omitempty"`
	// If set, only validate the request, but do not actually update the cluster.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field can only include these
	// fields from
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]:
	//
	//   - `annotations`.
	//   - `authorization.admin_groups`.
	//   - `authorization.admin_users`.
	//   - `binary_authorization.evaluation_mode`.
	//   - `description`.
	//   - `logging_config.component_config.enable_components`.
	//   - `monitoring_config.managed_prometheus_config.enabled`.
	//   - `platform_version`.
	//   - `proxy_config.kubernetes_secret.name`.
	//   - `proxy_config.kubernetes_secret.namespace`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAttachedClusterRequest) Reset() {
	*x = UpdateAttachedClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAttachedClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAttachedClusterRequest) ProtoMessage() {}

func (x *UpdateAttachedClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAttachedClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateAttachedClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAttachedClusterRequest) GetAttachedCluster() *AttachedCluster {
	if x != nil {
		return x.AttachedCluster
	}
	return nil
}

func (x *UpdateAttachedClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAttachedClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `AttachedClusters.GetAttachedCluster` method.
type GetAttachedClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// to describe.
	//
	// `AttachedCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAttachedClusterRequest) Reset() {
	*x = GetAttachedClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAttachedClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAttachedClusterRequest) ProtoMessage() {}

func (x *GetAttachedClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAttachedClusterRequest.ProtoReflect.Descriptor instead.
func (*GetAttachedClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetAttachedClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AttachedClusters.ListAttachedClusters` method.
type ListAttachedClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location which owns this collection of
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resources.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAttachedClustersResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [attachedClusters.list][google.cloud.gkemulticloud.v1.AttachedClusters.ListAttachedClusters]
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAttachedClustersRequest) Reset() {
	*x = ListAttachedClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttachedClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttachedClustersRequest) ProtoMessage() {}

func (x *ListAttachedClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttachedClustersRequest.ProtoReflect.Descriptor instead.
func (*ListAttachedClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListAttachedClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAttachedClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAttachedClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AttachedClusters.ListAttachedClusters` method.
type ListAttachedClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]
	// resources in the specified Google Cloud Platform project and region region.
	AttachedClusters []*AttachedCluster `protobuf:"bytes,1,rep,name=attached_clusters,json=attachedClusters,proto3" json:"attached_clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAttachedClustersResponse) Reset() {
	*x = ListAttachedClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAttachedClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAttachedClustersResponse) ProtoMessage() {}

func (x *ListAttachedClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAttachedClustersResponse.ProtoReflect.Descriptor instead.
func (*ListAttachedClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListAttachedClustersResponse) GetAttachedClusters() []*AttachedCluster {
	if x != nil {
		return x.AttachedClusters
	}
	return nil
}

func (x *ListAttachedClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `AttachedClusters.DeleteAttachedCluster` method.
type DeleteAttachedClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] to delete.
	//
	// `AttachedCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, only validate the request, but do not actually delete the resource.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// is not found, the request will succeed but no action will be taken on the
	// server and a completed [Operation][google.longrunning.Operation] will be
	// returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// If set to true, the deletion of
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// will succeed even if errors occur during deleting in cluster resources.
	// Using this parameter may result in orphaned resources in the cluster.
	IgnoreErrors bool `protobuf:"varint,5,opt,name=ignore_errors,json=ignoreErrors,proto3" json:"ignore_errors,omitempty"`
	// The current etag of the
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster].
	//
	// Allows clients to perform deletions through optimistic concurrency control.
	//
	// If the provided etag does not match the current etag of the cluster,
	// the request will fail and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAttachedClusterRequest) Reset() {
	*x = DeleteAttachedClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAttachedClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAttachedClusterRequest) ProtoMessage() {}

func (x *DeleteAttachedClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAttachedClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteAttachedClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteAttachedClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAttachedClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAttachedClusterRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAttachedClusterRequest) GetIgnoreErrors() bool {
	if x != nil {
		return x.IgnoreErrors
	}
	return false
}

func (x *DeleteAttachedClusterRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// GetAttachedServerConfigRequest gets the server config for attached
// clusters.
type GetAttachedServerConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AttachedServerConfig][google.cloud.gkemulticloud.v1.AttachedServerConfig]
	// resource to describe.
	//
	// `AttachedServerConfig` names are formatted as
	// `projects/<project-id>/locations/<region>/attachedServerConfig`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAttachedServerConfigRequest) Reset() {
	*x = GetAttachedServerConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAttachedServerConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAttachedServerConfigRequest) ProtoMessage() {}

func (x *GetAttachedServerConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAttachedServerConfigRequest.ProtoReflect.Descriptor instead.
func (*GetAttachedServerConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetAttachedServerConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GenerateAttachedClusterAgentTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	AttachedCluster string `protobuf:"bytes,1,opt,name=attached_cluster,json=attachedCluster,proto3" json:"attached_cluster,omitempty"`
	// Required.
	SubjectToken string `protobuf:"bytes,2,opt,name=subject_token,json=subjectToken,proto3" json:"subject_token,omitempty"`
	// Required.
	SubjectTokenType string `protobuf:"bytes,3,opt,name=subject_token_type,json=subjectTokenType,proto3" json:"subject_token_type,omitempty"`
	// Required.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Optional.
	GrantType string `protobuf:"bytes,6,opt,name=grant_type,json=grantType,proto3" json:"grant_type,omitempty"`
	// Optional.
	Audience string `protobuf:"bytes,7,opt,name=audience,proto3" json:"audience,omitempty"`
	// Optional.
	Scope string `protobuf:"bytes,8,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional.
	RequestedTokenType string `protobuf:"bytes,9,opt,name=requested_token_type,json=requestedTokenType,proto3" json:"requested_token_type,omitempty"`
	// Optional.
	Options string `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *GenerateAttachedClusterAgentTokenRequest) Reset() {
	*x = GenerateAttachedClusterAgentTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAttachedClusterAgentTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAttachedClusterAgentTokenRequest) ProtoMessage() {}

func (x *GenerateAttachedClusterAgentTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAttachedClusterAgentTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateAttachedClusterAgentTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{10}
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetAttachedCluster() string {
	if x != nil {
		return x.AttachedCluster
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetSubjectToken() string {
	if x != nil {
		return x.SubjectToken
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetSubjectTokenType() string {
	if x != nil {
		return x.SubjectTokenType
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetGrantType() string {
	if x != nil {
		return x.GrantType
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetRequestedTokenType() string {
	if x != nil {
		return x.RequestedTokenType
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenRequest) GetOptions() string {
	if x != nil {
		return x.Options
	}
	return ""
}

type GenerateAttachedClusterAgentTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	ExpiresIn   int32  `protobuf:"varint,2,opt,name=expires_in,json=expiresIn,proto3" json:"expires_in,omitempty"`
	TokenType   string `protobuf:"bytes,3,opt,name=token_type,json=tokenType,proto3" json:"token_type,omitempty"`
}

func (x *GenerateAttachedClusterAgentTokenResponse) Reset() {
	*x = GenerateAttachedClusterAgentTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateAttachedClusterAgentTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAttachedClusterAgentTokenResponse) ProtoMessage() {}

func (x *GenerateAttachedClusterAgentTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAttachedClusterAgentTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateAttachedClusterAgentTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP(), []int{11}
}

func (x *GenerateAttachedClusterAgentTokenResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateAttachedClusterAgentTokenResponse) GetExpiresIn() int32 {
	if x != nil {
		return x.ExpiresIn
	}
	return 0
}

func (x *GenerateAttachedClusterAgentTokenResponse) GetTokenType() string {
	if x != nil {
		return x.TokenType
	}
	return ""
}

var File_google_cloud_gkemulticloud_v1_attached_service_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbe, 0x02, 0x0a, 0x2d, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x2e, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x5a, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4c, 0x0a, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x22, 0xa6, 0x02, 0x0a, 0x1c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2e, 0x12, 0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xf6, 0x02, 0x0a, 0x1c, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x2e, 0x0a, 0x10, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x5f,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5a, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe5, 0x01, 0x0a, 0x1c,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x10,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c,
	0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2e, 0x12, 0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x10, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xeb, 0x01, 0x0a, 0x1c, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2e, 0x0a, 0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12,
	0x23, 0x0a, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x6f, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33,
	0x0a, 0x31, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x03, 0x0a, 0x28, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a, 0x10, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x10, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x67, 0x72,
	0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8c, 0x01, 0x0a, 0x29, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x49, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x32, 0xdd, 0x12, 0x0a, 0x10, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x99, 0x02,
	0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xa3, 0x01, 0xca, 0x41, 0x24, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x3a, 0x10, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x9b, 0x02, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa5, 0x01, 0xca, 0x41, 0x24, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1c, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x3a, 0x10,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x32, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfd, 0x01, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01,
	0xca, 0x41, 0x24, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xc3, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd6, 0x01,
	0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36,
	0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xe5, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4,
	0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x45,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0xb6, 0x02, 0x0a, 0x26, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x12, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6f, 0xda,
	0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0xa5,
	0x02, 0x0a, 0x21, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x67, 0x3a,
	0x01, 0x2a, 0x22, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe7, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x14,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0x3b,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0xaa,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47,
	0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47,
	0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescData = file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_gkemulticloud_v1_attached_service_proto_goTypes = []interface{}{
	(*GenerateAttachedClusterInstallManifestRequest)(nil),  // 0: google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestRequest
	(*GenerateAttachedClusterInstallManifestResponse)(nil), // 1: google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestResponse
	(*CreateAttachedClusterRequest)(nil),                   // 2: google.cloud.gkemulticloud.v1.CreateAttachedClusterRequest
	(*ImportAttachedClusterRequest)(nil),                   // 3: google.cloud.gkemulticloud.v1.ImportAttachedClusterRequest
	(*UpdateAttachedClusterRequest)(nil),                   // 4: google.cloud.gkemulticloud.v1.UpdateAttachedClusterRequest
	(*GetAttachedClusterRequest)(nil),                      // 5: google.cloud.gkemulticloud.v1.GetAttachedClusterRequest
	(*ListAttachedClustersRequest)(nil),                    // 6: google.cloud.gkemulticloud.v1.ListAttachedClustersRequest
	(*ListAttachedClustersResponse)(nil),                   // 7: google.cloud.gkemulticloud.v1.ListAttachedClustersResponse
	(*DeleteAttachedClusterRequest)(nil),                   // 8: google.cloud.gkemulticloud.v1.DeleteAttachedClusterRequest
	(*GetAttachedServerConfigRequest)(nil),                 // 9: google.cloud.gkemulticloud.v1.GetAttachedServerConfigRequest
	(*GenerateAttachedClusterAgentTokenRequest)(nil),       // 10: google.cloud.gkemulticloud.v1.GenerateAttachedClusterAgentTokenRequest
	(*GenerateAttachedClusterAgentTokenResponse)(nil),      // 11: google.cloud.gkemulticloud.v1.GenerateAttachedClusterAgentTokenResponse
	(*AttachedProxyConfig)(nil),                            // 12: google.cloud.gkemulticloud.v1.AttachedProxyConfig
	(*AttachedCluster)(nil),                                // 13: google.cloud.gkemulticloud.v1.AttachedCluster
	(*fieldmaskpb.FieldMask)(nil),                          // 14: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),                        // 15: google.longrunning.Operation
	(*AttachedServerConfig)(nil),                           // 16: google.cloud.gkemulticloud.v1.AttachedServerConfig
}
var file_google_cloud_gkemulticloud_v1_attached_service_proto_depIdxs = []int32{
	12, // 0: google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestRequest.proxy_config:type_name -> google.cloud.gkemulticloud.v1.AttachedProxyConfig
	13, // 1: google.cloud.gkemulticloud.v1.CreateAttachedClusterRequest.attached_cluster:type_name -> google.cloud.gkemulticloud.v1.AttachedCluster
	12, // 2: google.cloud.gkemulticloud.v1.ImportAttachedClusterRequest.proxy_config:type_name -> google.cloud.gkemulticloud.v1.AttachedProxyConfig
	13, // 3: google.cloud.gkemulticloud.v1.UpdateAttachedClusterRequest.attached_cluster:type_name -> google.cloud.gkemulticloud.v1.AttachedCluster
	14, // 4: google.cloud.gkemulticloud.v1.UpdateAttachedClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 5: google.cloud.gkemulticloud.v1.ListAttachedClustersResponse.attached_clusters:type_name -> google.cloud.gkemulticloud.v1.AttachedCluster
	2,  // 6: google.cloud.gkemulticloud.v1.AttachedClusters.CreateAttachedCluster:input_type -> google.cloud.gkemulticloud.v1.CreateAttachedClusterRequest
	4,  // 7: google.cloud.gkemulticloud.v1.AttachedClusters.UpdateAttachedCluster:input_type -> google.cloud.gkemulticloud.v1.UpdateAttachedClusterRequest
	3,  // 8: google.cloud.gkemulticloud.v1.AttachedClusters.ImportAttachedCluster:input_type -> google.cloud.gkemulticloud.v1.ImportAttachedClusterRequest
	5,  // 9: google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedCluster:input_type -> google.cloud.gkemulticloud.v1.GetAttachedClusterRequest
	6,  // 10: google.cloud.gkemulticloud.v1.AttachedClusters.ListAttachedClusters:input_type -> google.cloud.gkemulticloud.v1.ListAttachedClustersRequest
	8,  // 11: google.cloud.gkemulticloud.v1.AttachedClusters.DeleteAttachedCluster:input_type -> google.cloud.gkemulticloud.v1.DeleteAttachedClusterRequest
	9,  // 12: google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedServerConfig:input_type -> google.cloud.gkemulticloud.v1.GetAttachedServerConfigRequest
	0,  // 13: google.cloud.gkemulticloud.v1.AttachedClusters.GenerateAttachedClusterInstallManifest:input_type -> google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestRequest
	10, // 14: google.cloud.gkemulticloud.v1.AttachedClusters.GenerateAttachedClusterAgentToken:input_type -> google.cloud.gkemulticloud.v1.GenerateAttachedClusterAgentTokenRequest
	15, // 15: google.cloud.gkemulticloud.v1.AttachedClusters.CreateAttachedCluster:output_type -> google.longrunning.Operation
	15, // 16: google.cloud.gkemulticloud.v1.AttachedClusters.UpdateAttachedCluster:output_type -> google.longrunning.Operation
	15, // 17: google.cloud.gkemulticloud.v1.AttachedClusters.ImportAttachedCluster:output_type -> google.longrunning.Operation
	13, // 18: google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedCluster:output_type -> google.cloud.gkemulticloud.v1.AttachedCluster
	7,  // 19: google.cloud.gkemulticloud.v1.AttachedClusters.ListAttachedClusters:output_type -> google.cloud.gkemulticloud.v1.ListAttachedClustersResponse
	15, // 20: google.cloud.gkemulticloud.v1.AttachedClusters.DeleteAttachedCluster:output_type -> google.longrunning.Operation
	16, // 21: google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedServerConfig:output_type -> google.cloud.gkemulticloud.v1.AttachedServerConfig
	1,  // 22: google.cloud.gkemulticloud.v1.AttachedClusters.GenerateAttachedClusterInstallManifest:output_type -> google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestResponse
	11, // 23: google.cloud.gkemulticloud.v1.AttachedClusters.GenerateAttachedClusterAgentToken:output_type -> google.cloud.gkemulticloud.v1.GenerateAttachedClusterAgentTokenResponse
	15, // [15:24] is the sub-list for method output_type
	6,  // [6:15] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_attached_service_proto_init() }
func file_google_cloud_gkemulticloud_v1_attached_service_proto_init() {
	if File_google_cloud_gkemulticloud_v1_attached_service_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_attached_resources_proto_init()
	file_google_cloud_gkemulticloud_v1_common_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAttachedClusterInstallManifestRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAttachedClusterInstallManifestResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAttachedClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAttachedClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAttachedClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAttachedClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAttachedClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAttachedClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAttachedClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAttachedServerConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAttachedClusterAgentTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateAttachedClusterAgentTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_attached_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_attached_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_attached_service_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_attached_service_proto = out.File
	file_google_cloud_gkemulticloud_v1_attached_service_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_attached_service_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_attached_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AttachedClustersClient is the client API for AttachedClusters service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AttachedClustersClient interface {
	// Creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAttachedCluster(ctx context.Context, in *CreateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster].
	UpdateAttachedCluster(ctx context.Context, in *UpdateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// by importing an existing Fleet Membership resource.
	//
	// Attached Clusters created before the introduction of the Anthos Multi-Cloud
	// API can be imported through this method.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	ImportAttachedCluster(ctx context.Context, in *ImportAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	GetAttachedCluster(ctx context.Context, in *GetAttachedClusterRequest, opts ...grpc.CallOption) (*AttachedCluster, error)
	// Lists all [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]
	// resources on a given Google Cloud project and region.
	ListAttachedClusters(ctx context.Context, in *ListAttachedClustersRequest, opts ...grpc.CallOption) (*ListAttachedClustersResponse, error)
	// Deletes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAttachedCluster(ctx context.Context, in *DeleteAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns information, such as supported Kubernetes versions, on a given
	// Google Cloud location.
	GetAttachedServerConfig(ctx context.Context, in *GetAttachedServerConfigRequest, opts ...grpc.CallOption) (*AttachedServerConfig, error)
	// Generates the install manifest to be installed on the target cluster.
	GenerateAttachedClusterInstallManifest(ctx context.Context, in *GenerateAttachedClusterInstallManifestRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterInstallManifestResponse, error)
	// Generates an access token for a cluster agent.
	GenerateAttachedClusterAgentToken(ctx context.Context, in *GenerateAttachedClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterAgentTokenResponse, error)
}

type attachedClustersClient struct {
	cc grpc.ClientConnInterface
}

func NewAttachedClustersClient(cc grpc.ClientConnInterface) AttachedClustersClient {
	return &attachedClustersClient{cc}
}

func (c *attachedClustersClient) CreateAttachedCluster(ctx context.Context, in *CreateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/CreateAttachedCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) UpdateAttachedCluster(ctx context.Context, in *UpdateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/UpdateAttachedCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) ImportAttachedCluster(ctx context.Context, in *ImportAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/ImportAttachedCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GetAttachedCluster(ctx context.Context, in *GetAttachedClusterRequest, opts ...grpc.CallOption) (*AttachedCluster, error) {
	out := new(AttachedCluster)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/GetAttachedCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) ListAttachedClusters(ctx context.Context, in *ListAttachedClustersRequest, opts ...grpc.CallOption) (*ListAttachedClustersResponse, error) {
	out := new(ListAttachedClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/ListAttachedClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) DeleteAttachedCluster(ctx context.Context, in *DeleteAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/DeleteAttachedCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GetAttachedServerConfig(ctx context.Context, in *GetAttachedServerConfigRequest, opts ...grpc.CallOption) (*AttachedServerConfig, error) {
	out := new(AttachedServerConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/GetAttachedServerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GenerateAttachedClusterInstallManifest(ctx context.Context, in *GenerateAttachedClusterInstallManifestRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterInstallManifestResponse, error) {
	out := new(GenerateAttachedClusterInstallManifestResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/GenerateAttachedClusterInstallManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GenerateAttachedClusterAgentToken(ctx context.Context, in *GenerateAttachedClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterAgentTokenResponse, error) {
	out := new(GenerateAttachedClusterAgentTokenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkemulticloud.v1.AttachedClusters/GenerateAttachedClusterAgentToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AttachedClustersServer is the server API for AttachedClusters service.
type AttachedClustersServer interface {
	// Creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAttachedCluster(context.Context, *CreateAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Updates an
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster].
	UpdateAttachedCluster(context.Context, *UpdateAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Imports creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// by importing an existing Fleet Membership resource.
	//
	// Attached Clusters created before the introduction of the Anthos Multi-Cloud
	// API can be imported through this method.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	ImportAttachedCluster(context.Context, *ImportAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	GetAttachedCluster(context.Context, *GetAttachedClusterRequest) (*AttachedCluster, error)
	// Lists all [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]
	// resources on a given Google Cloud project and region.
	ListAttachedClusters(context.Context, *ListAttachedClustersRequest) (*ListAttachedClustersResponse, error)
	// Deletes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAttachedCluster(context.Context, *DeleteAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Returns information, such as supported Kubernetes versions, on a given
	// Google Cloud location.
	GetAttachedServerConfig(context.Context, *GetAttachedServerConfigRequest) (*AttachedServerConfig, error)
	// Generates the install manifest to be installed on the target cluster.
	GenerateAttachedClusterInstallManifest(context.Context, *GenerateAttachedClusterInstallManifestRequest) (*GenerateAttachedClusterInstallManifestResponse, error)
	// Generates an access token for a cluster agent.
	GenerateAttachedClusterAgentToken(context.Context, *GenerateAttachedClusterAgentTokenRequest) (*GenerateAttachedClusterAgentTokenResponse, error)
}

// UnimplementedAttachedClustersServer can be embedded to have forward compatible implementations.
type UnimplementedAttachedClustersServer struct {
}

func (*UnimplementedAttachedClustersServer) CreateAttachedCluster(context.Context, *CreateAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAttachedCluster not implemented")
}
func (*UnimplementedAttachedClustersServer) UpdateAttachedCluster(context.Context, *UpdateAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttachedCluster not implemented")
}
func (*UnimplementedAttachedClustersServer) ImportAttachedCluster(context.Context, *ImportAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAttachedCluster not implemented")
}
func (*UnimplementedAttachedClustersServer) GetAttachedCluster(context.Context, *GetAttachedClusterRequest) (*AttachedCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttachedCluster not implemented")
}
func (*UnimplementedAttachedClustersServer) ListAttachedClusters(context.Context, *ListAttachedClustersRequest) (*ListAttachedClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttachedClusters not implemented")
}
func (*UnimplementedAttachedClustersServer) DeleteAttachedCluster(context.Context, *DeleteAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAttachedCluster not implemented")
}
func (*UnimplementedAttachedClustersServer) GetAttachedServerConfig(context.Context, *GetAttachedServerConfigRequest) (*AttachedServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttachedServerConfig not implemented")
}
func (*UnimplementedAttachedClustersServer) GenerateAttachedClusterInstallManifest(context.Context, *GenerateAttachedClusterInstallManifestRequest) (*GenerateAttachedClusterInstallManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAttachedClusterInstallManifest not implemented")
}
func (*UnimplementedAttachedClustersServer) GenerateAttachedClusterAgentToken(context.Context, *GenerateAttachedClusterAgentTokenRequest) (*GenerateAttachedClusterAgentTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAttachedClusterAgentToken not implemented")
}

func RegisterAttachedClustersServer(s *grpc.Server, srv AttachedClustersServer) {
	s.RegisterService(&_AttachedClusters_serviceDesc, srv)
}

func _AttachedClusters_CreateAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).CreateAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/CreateAttachedCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).CreateAttachedCluster(ctx, req.(*CreateAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_UpdateAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).UpdateAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/UpdateAttachedCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).UpdateAttachedCluster(ctx, req.(*UpdateAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_ImportAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).ImportAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/ImportAttachedCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).ImportAttachedCluster(ctx, req.(*ImportAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GetAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GetAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/GetAttachedCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GetAttachedCluster(ctx, req.(*GetAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_ListAttachedClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttachedClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).ListAttachedClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/ListAttachedClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).ListAttachedClusters(ctx, req.(*ListAttachedClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_DeleteAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).DeleteAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/DeleteAttachedCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).DeleteAttachedCluster(ctx, req.(*DeleteAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GetAttachedServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttachedServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GetAttachedServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/GetAttachedServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GetAttachedServerConfig(ctx, req.(*GetAttachedServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GenerateAttachedClusterInstallManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAttachedClusterInstallManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GenerateAttachedClusterInstallManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/GenerateAttachedClusterInstallManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GenerateAttachedClusterInstallManifest(ctx, req.(*GenerateAttachedClusterInstallManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GenerateAttachedClusterAgentToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAttachedClusterAgentTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GenerateAttachedClusterAgentToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkemulticloud.v1.AttachedClusters/GenerateAttachedClusterAgentToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GenerateAttachedClusterAgentToken(ctx, req.(*GenerateAttachedClusterAgentTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AttachedClusters_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkemulticloud.v1.AttachedClusters",
	HandlerType: (*AttachedClustersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAttachedCluster",
			Handler:    _AttachedClusters_CreateAttachedCluster_Handler,
		},
		{
			MethodName: "UpdateAttachedCluster",
			Handler:    _AttachedClusters_UpdateAttachedCluster_Handler,
		},
		{
			MethodName: "ImportAttachedCluster",
			Handler:    _AttachedClusters_ImportAttachedCluster_Handler,
		},
		{
			MethodName: "GetAttachedCluster",
			Handler:    _AttachedClusters_GetAttachedCluster_Handler,
		},
		{
			MethodName: "ListAttachedClusters",
			Handler:    _AttachedClusters_ListAttachedClusters_Handler,
		},
		{
			MethodName: "DeleteAttachedCluster",
			Handler:    _AttachedClusters_DeleteAttachedCluster_Handler,
		},
		{
			MethodName: "GetAttachedServerConfig",
			Handler:    _AttachedClusters_GetAttachedServerConfig_Handler,
		},
		{
			MethodName: "GenerateAttachedClusterInstallManifest",
			Handler:    _AttachedClusters_GenerateAttachedClusterInstallManifest_Handler,
		},
		{
			MethodName: "GenerateAttachedClusterAgentToken",
			Handler:    _AttachedClusters_GenerateAttachedClusterAgentToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkemulticloud/v1/attached_service.proto",
}
