// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/logging/v2/logging_config.proto

package loggingpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ConfigServiceV2_ListBuckets_FullMethodName        = "/google.logging.v2.ConfigServiceV2/ListBuckets"
	ConfigServiceV2_GetBucket_FullMethodName          = "/google.logging.v2.ConfigServiceV2/GetBucket"
	ConfigServiceV2_CreateBucketAsync_FullMethodName  = "/google.logging.v2.ConfigServiceV2/CreateBucketAsync"
	ConfigServiceV2_UpdateBucketAsync_FullMethodName  = "/google.logging.v2.ConfigServiceV2/UpdateBucketAsync"
	ConfigServiceV2_CreateBucket_FullMethodName       = "/google.logging.v2.ConfigServiceV2/CreateBucket"
	ConfigServiceV2_UpdateBucket_FullMethodName       = "/google.logging.v2.ConfigServiceV2/UpdateBucket"
	ConfigServiceV2_DeleteBucket_FullMethodName       = "/google.logging.v2.ConfigServiceV2/DeleteBucket"
	ConfigServiceV2_UndeleteBucket_FullMethodName     = "/google.logging.v2.ConfigServiceV2/UndeleteBucket"
	ConfigServiceV2_ListViews_FullMethodName          = "/google.logging.v2.ConfigServiceV2/ListViews"
	ConfigServiceV2_GetView_FullMethodName            = "/google.logging.v2.ConfigServiceV2/GetView"
	ConfigServiceV2_CreateView_FullMethodName         = "/google.logging.v2.ConfigServiceV2/CreateView"
	ConfigServiceV2_UpdateView_FullMethodName         = "/google.logging.v2.ConfigServiceV2/UpdateView"
	ConfigServiceV2_DeleteView_FullMethodName         = "/google.logging.v2.ConfigServiceV2/DeleteView"
	ConfigServiceV2_ListSinks_FullMethodName          = "/google.logging.v2.ConfigServiceV2/ListSinks"
	ConfigServiceV2_GetSink_FullMethodName            = "/google.logging.v2.ConfigServiceV2/GetSink"
	ConfigServiceV2_CreateSink_FullMethodName         = "/google.logging.v2.ConfigServiceV2/CreateSink"
	ConfigServiceV2_UpdateSink_FullMethodName         = "/google.logging.v2.ConfigServiceV2/UpdateSink"
	ConfigServiceV2_DeleteSink_FullMethodName         = "/google.logging.v2.ConfigServiceV2/DeleteSink"
	ConfigServiceV2_CreateLink_FullMethodName         = "/google.logging.v2.ConfigServiceV2/CreateLink"
	ConfigServiceV2_DeleteLink_FullMethodName         = "/google.logging.v2.ConfigServiceV2/DeleteLink"
	ConfigServiceV2_ListLinks_FullMethodName          = "/google.logging.v2.ConfigServiceV2/ListLinks"
	ConfigServiceV2_GetLink_FullMethodName            = "/google.logging.v2.ConfigServiceV2/GetLink"
	ConfigServiceV2_ListExclusions_FullMethodName     = "/google.logging.v2.ConfigServiceV2/ListExclusions"
	ConfigServiceV2_GetExclusion_FullMethodName       = "/google.logging.v2.ConfigServiceV2/GetExclusion"
	ConfigServiceV2_CreateExclusion_FullMethodName    = "/google.logging.v2.ConfigServiceV2/CreateExclusion"
	ConfigServiceV2_UpdateExclusion_FullMethodName    = "/google.logging.v2.ConfigServiceV2/UpdateExclusion"
	ConfigServiceV2_DeleteExclusion_FullMethodName    = "/google.logging.v2.ConfigServiceV2/DeleteExclusion"
	ConfigServiceV2_GetCmekSettings_FullMethodName    = "/google.logging.v2.ConfigServiceV2/GetCmekSettings"
	ConfigServiceV2_UpdateCmekSettings_FullMethodName = "/google.logging.v2.ConfigServiceV2/UpdateCmekSettings"
	ConfigServiceV2_GetSettings_FullMethodName        = "/google.logging.v2.ConfigServiceV2/GetSettings"
	ConfigServiceV2_UpdateSettings_FullMethodName     = "/google.logging.v2.ConfigServiceV2/UpdateSettings"
	ConfigServiceV2_CopyLogEntries_FullMethodName     = "/google.logging.v2.ConfigServiceV2/CopyLogEntries"
)

// ConfigServiceV2Client is the client API for ConfigServiceV2 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConfigServiceV2Client interface {
	// Lists log buckets.
	ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error)
	// Gets a log bucket.
	GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*LogBucket, error)
	// Creates a log bucket asynchronously that can be used to store log entries.
	//
	// After a bucket has been created, the bucket's location cannot be changed.
	CreateBucketAsync(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a log bucket asynchronously.
	//
	// If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
	// `FAILED_PRECONDITION` will be returned.
	//
	// After a bucket has been created, the bucket's location cannot be changed.
	UpdateBucketAsync(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a log bucket that can be used to store log entries. After a bucket
	// has been created, the bucket's location cannot be changed.
	CreateBucket(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*LogBucket, error)
	// Updates a log bucket.
	//
	// If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
	// `FAILED_PRECONDITION` will be returned.
	//
	// After a bucket has been created, the bucket's location cannot be changed.
	UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*LogBucket, error)
	// Deletes a log bucket.
	//
	// Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
	// After 7 days, the bucket will be purged and all log entries in the bucket
	// will be permanently deleted.
	DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Undeletes a log bucket. A bucket that has been deleted can be undeleted
	// within the grace period of 7 days.
	UndeleteBucket(ctx context.Context, in *UndeleteBucketRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists views on a log bucket.
	ListViews(ctx context.Context, in *ListViewsRequest, opts ...grpc.CallOption) (*ListViewsResponse, error)
	// Gets a view on a log bucket..
	GetView(ctx context.Context, in *GetViewRequest, opts ...grpc.CallOption) (*LogView, error)
	// Creates a view over log entries in a log bucket. A bucket may contain a
	// maximum of 30 views.
	CreateView(ctx context.Context, in *CreateViewRequest, opts ...grpc.CallOption) (*LogView, error)
	// Updates a view on a log bucket. This method replaces the following fields
	// in the existing view with values from the new view: `filter`.
	// If an `UNAVAILABLE` error is returned, this indicates that system is not in
	// a state where it can update the view. If this occurs, please try again in a
	// few minutes.
	UpdateView(ctx context.Context, in *UpdateViewRequest, opts ...grpc.CallOption) (*LogView, error)
	// Deletes a view on a log bucket.
	// If an `UNAVAILABLE` error is returned, this indicates that system is not in
	// a state where it can delete the view. If this occurs, please try again in a
	// few minutes.
	DeleteView(ctx context.Context, in *DeleteViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists sinks.
	ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Creates a sink that exports specified log entries to a destination. The
	// export of newly-ingested log entries begins immediately, unless the sink's
	// `writer_identity` is not permitted to write to the destination. A sink can
	// export log entries only from the resource owning the sink.
	CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Updates a sink. This method replaces the following fields in the existing
	// sink with values from the new sink: `destination`, and `filter`.
	//
	// The updated sink might also have a new `writer_identity`; see the
	// `unique_writer_identity` field.
	UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Deletes a sink. If the sink has a unique `writer_identity`, then that
	// service account is also deleted.
	DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Asynchronously creates a linked dataset in BigQuery which makes it possible
	// to use BigQuery to read the logs stored in the log bucket. A log bucket may
	// currently only contain one link.
	CreateLink(ctx context.Context, in *CreateLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a link. This will also delete the corresponding BigQuery linked
	// dataset.
	DeleteLink(ctx context.Context, in *DeleteLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists links.
	ListLinks(ctx context.Context, in *ListLinksRequest, opts ...grpc.CallOption) (*ListLinksResponse, error)
	// Gets a link.
	GetLink(ctx context.Context, in *GetLinkRequest, opts ...grpc.CallOption) (*Link, error)
	// Lists all the exclusions on the _Default sink in a parent resource.
	ListExclusions(ctx context.Context, in *ListExclusionsRequest, opts ...grpc.CallOption) (*ListExclusionsResponse, error)
	// Gets the description of an exclusion in the _Default sink.
	GetExclusion(ctx context.Context, in *GetExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Creates a new exclusion in the _Default sink in a specified parent
	// resource. Only log entries belonging to that resource can be excluded. You
	// can have up to 10 exclusions in a resource.
	CreateExclusion(ctx context.Context, in *CreateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Changes one or more properties of an existing exclusion in the _Default
	// sink.
	UpdateExclusion(ctx context.Context, in *UpdateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error)
	// Deletes an exclusion in the _Default sink.
	DeleteExclusion(ctx context.Context, in *DeleteExclusionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the Logging CMEK settings for the given resource.
	//
	// Note: CMEK for the Log Router can be configured for Google Cloud projects,
	// folders, organizations and billing accounts. Once configured for an
	// organization, it applies to all projects and folders in the Google Cloud
	// organization.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	GetCmekSettings(ctx context.Context, in *GetCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error)
	// Updates the Log Router CMEK settings for the given resource.
	//
	// Note: CMEK for the Log Router can currently only be configured for Google
	// Cloud organizations. Once configured, it applies to all projects and
	// folders in the Google Cloud organization.
	//
	// [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
	// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
	// account does not have the required
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
	// 3) access to the key is disabled.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	UpdateCmekSettings(ctx context.Context, in *UpdateCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error)
	// Gets the Log Router settings for the given resource.
	//
	// Note: Settings for the Log Router can be get for Google Cloud projects,
	// folders, organizations and billing accounts. Currently it can only be
	// configured for organizations. Once configured for an organization, it
	// applies to all projects and folders in the Google Cloud organization.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates the Log Router settings for the given resource.
	//
	// Note: Settings for the Log Router can currently only be configured for
	// Google Cloud organizations. Once configured, it applies to all projects and
	// folders in the Google Cloud organization.
	//
	// [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
	// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
	// account does not have the required
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
	// 3) access to the key is disabled. 4) `location_id` is not supported by
	// Logging. 5) `location_id` violate OrgPolicy.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Copies a set of log entries from a log bucket to a Cloud Storage bucket.
	CopyLogEntries(ctx context.Context, in *CopyLogEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type configServiceV2Client struct {
	cc grpc.ClientConnInterface
}

func NewConfigServiceV2Client(cc grpc.ClientConnInterface) ConfigServiceV2Client {
	return &configServiceV2Client{cc}
}

func (c *configServiceV2Client) ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error) {
	out := new(ListBucketsResponse)
	err := c.cc.Invoke(ctx, ConfigServiceV2_ListBuckets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*LogBucket, error) {
	out := new(LogBucket)
	err := c.cc.Invoke(ctx, ConfigServiceV2_GetBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateBucketAsync(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConfigServiceV2_CreateBucketAsync_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateBucketAsync(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UpdateBucketAsync_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateBucket(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*LogBucket, error) {
	out := new(LogBucket)
	err := c.cc.Invoke(ctx, ConfigServiceV2_CreateBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*LogBucket, error) {
	out := new(LogBucket)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UpdateBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ConfigServiceV2_DeleteBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UndeleteBucket(ctx context.Context, in *UndeleteBucketRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UndeleteBucket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) ListViews(ctx context.Context, in *ListViewsRequest, opts ...grpc.CallOption) (*ListViewsResponse, error) {
	out := new(ListViewsResponse)
	err := c.cc.Invoke(ctx, ConfigServiceV2_ListViews_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetView(ctx context.Context, in *GetViewRequest, opts ...grpc.CallOption) (*LogView, error) {
	out := new(LogView)
	err := c.cc.Invoke(ctx, ConfigServiceV2_GetView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateView(ctx context.Context, in *CreateViewRequest, opts ...grpc.CallOption) (*LogView, error) {
	out := new(LogView)
	err := c.cc.Invoke(ctx, ConfigServiceV2_CreateView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateView(ctx context.Context, in *UpdateViewRequest, opts ...grpc.CallOption) (*LogView, error) {
	out := new(LogView)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UpdateView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteView(ctx context.Context, in *DeleteViewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ConfigServiceV2_DeleteView_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error) {
	out := new(ListSinksResponse)
	err := c.cc.Invoke(ctx, ConfigServiceV2_ListSinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := c.cc.Invoke(ctx, ConfigServiceV2_GetSink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := c.cc.Invoke(ctx, ConfigServiceV2_CreateSink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UpdateSink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ConfigServiceV2_DeleteSink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateLink(ctx context.Context, in *CreateLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConfigServiceV2_CreateLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteLink(ctx context.Context, in *DeleteLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConfigServiceV2_DeleteLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) ListLinks(ctx context.Context, in *ListLinksRequest, opts ...grpc.CallOption) (*ListLinksResponse, error) {
	out := new(ListLinksResponse)
	err := c.cc.Invoke(ctx, ConfigServiceV2_ListLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetLink(ctx context.Context, in *GetLinkRequest, opts ...grpc.CallOption) (*Link, error) {
	out := new(Link)
	err := c.cc.Invoke(ctx, ConfigServiceV2_GetLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) ListExclusions(ctx context.Context, in *ListExclusionsRequest, opts ...grpc.CallOption) (*ListExclusionsResponse, error) {
	out := new(ListExclusionsResponse)
	err := c.cc.Invoke(ctx, ConfigServiceV2_ListExclusions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetExclusion(ctx context.Context, in *GetExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := c.cc.Invoke(ctx, ConfigServiceV2_GetExclusion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateExclusion(ctx context.Context, in *CreateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := c.cc.Invoke(ctx, ConfigServiceV2_CreateExclusion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateExclusion(ctx context.Context, in *UpdateExclusionRequest, opts ...grpc.CallOption) (*LogExclusion, error) {
	out := new(LogExclusion)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UpdateExclusion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteExclusion(ctx context.Context, in *DeleteExclusionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ConfigServiceV2_DeleteExclusion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetCmekSettings(ctx context.Context, in *GetCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error) {
	out := new(CmekSettings)
	err := c.cc.Invoke(ctx, ConfigServiceV2_GetCmekSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateCmekSettings(ctx context.Context, in *UpdateCmekSettingsRequest, opts ...grpc.CallOption) (*CmekSettings, error) {
	out := new(CmekSettings)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UpdateCmekSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, ConfigServiceV2_GetSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, ConfigServiceV2_UpdateSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CopyLogEntries(ctx context.Context, in *CopyLogEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConfigServiceV2_CopyLogEntries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConfigServiceV2Server is the server API for ConfigServiceV2 service.
// All implementations should embed UnimplementedConfigServiceV2Server
// for forward compatibility
type ConfigServiceV2Server interface {
	// Lists log buckets.
	ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error)
	// Gets a log bucket.
	GetBucket(context.Context, *GetBucketRequest) (*LogBucket, error)
	// Creates a log bucket asynchronously that can be used to store log entries.
	//
	// After a bucket has been created, the bucket's location cannot be changed.
	CreateBucketAsync(context.Context, *CreateBucketRequest) (*longrunningpb.Operation, error)
	// Updates a log bucket asynchronously.
	//
	// If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
	// `FAILED_PRECONDITION` will be returned.
	//
	// After a bucket has been created, the bucket's location cannot be changed.
	UpdateBucketAsync(context.Context, *UpdateBucketRequest) (*longrunningpb.Operation, error)
	// Creates a log bucket that can be used to store log entries. After a bucket
	// has been created, the bucket's location cannot be changed.
	CreateBucket(context.Context, *CreateBucketRequest) (*LogBucket, error)
	// Updates a log bucket.
	//
	// If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
	// `FAILED_PRECONDITION` will be returned.
	//
	// After a bucket has been created, the bucket's location cannot be changed.
	UpdateBucket(context.Context, *UpdateBucketRequest) (*LogBucket, error)
	// Deletes a log bucket.
	//
	// Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
	// After 7 days, the bucket will be purged and all log entries in the bucket
	// will be permanently deleted.
	DeleteBucket(context.Context, *DeleteBucketRequest) (*emptypb.Empty, error)
	// Undeletes a log bucket. A bucket that has been deleted can be undeleted
	// within the grace period of 7 days.
	UndeleteBucket(context.Context, *UndeleteBucketRequest) (*emptypb.Empty, error)
	// Lists views on a log bucket.
	ListViews(context.Context, *ListViewsRequest) (*ListViewsResponse, error)
	// Gets a view on a log bucket..
	GetView(context.Context, *GetViewRequest) (*LogView, error)
	// Creates a view over log entries in a log bucket. A bucket may contain a
	// maximum of 30 views.
	CreateView(context.Context, *CreateViewRequest) (*LogView, error)
	// Updates a view on a log bucket. This method replaces the following fields
	// in the existing view with values from the new view: `filter`.
	// If an `UNAVAILABLE` error is returned, this indicates that system is not in
	// a state where it can update the view. If this occurs, please try again in a
	// few minutes.
	UpdateView(context.Context, *UpdateViewRequest) (*LogView, error)
	// Deletes a view on a log bucket.
	// If an `UNAVAILABLE` error is returned, this indicates that system is not in
	// a state where it can delete the view. If this occurs, please try again in a
	// few minutes.
	DeleteView(context.Context, *DeleteViewRequest) (*emptypb.Empty, error)
	// Lists sinks.
	ListSinks(context.Context, *ListSinksRequest) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(context.Context, *GetSinkRequest) (*LogSink, error)
	// Creates a sink that exports specified log entries to a destination. The
	// export of newly-ingested log entries begins immediately, unless the sink's
	// `writer_identity` is not permitted to write to the destination. A sink can
	// export log entries only from the resource owning the sink.
	CreateSink(context.Context, *CreateSinkRequest) (*LogSink, error)
	// Updates a sink. This method replaces the following fields in the existing
	// sink with values from the new sink: `destination`, and `filter`.
	//
	// The updated sink might also have a new `writer_identity`; see the
	// `unique_writer_identity` field.
	UpdateSink(context.Context, *UpdateSinkRequest) (*LogSink, error)
	// Deletes a sink. If the sink has a unique `writer_identity`, then that
	// service account is also deleted.
	DeleteSink(context.Context, *DeleteSinkRequest) (*emptypb.Empty, error)
	// Asynchronously creates a linked dataset in BigQuery which makes it possible
	// to use BigQuery to read the logs stored in the log bucket. A log bucket may
	// currently only contain one link.
	CreateLink(context.Context, *CreateLinkRequest) (*longrunningpb.Operation, error)
	// Deletes a link. This will also delete the corresponding BigQuery linked
	// dataset.
	DeleteLink(context.Context, *DeleteLinkRequest) (*longrunningpb.Operation, error)
	// Lists links.
	ListLinks(context.Context, *ListLinksRequest) (*ListLinksResponse, error)
	// Gets a link.
	GetLink(context.Context, *GetLinkRequest) (*Link, error)
	// Lists all the exclusions on the _Default sink in a parent resource.
	ListExclusions(context.Context, *ListExclusionsRequest) (*ListExclusionsResponse, error)
	// Gets the description of an exclusion in the _Default sink.
	GetExclusion(context.Context, *GetExclusionRequest) (*LogExclusion, error)
	// Creates a new exclusion in the _Default sink in a specified parent
	// resource. Only log entries belonging to that resource can be excluded. You
	// can have up to 10 exclusions in a resource.
	CreateExclusion(context.Context, *CreateExclusionRequest) (*LogExclusion, error)
	// Changes one or more properties of an existing exclusion in the _Default
	// sink.
	UpdateExclusion(context.Context, *UpdateExclusionRequest) (*LogExclusion, error)
	// Deletes an exclusion in the _Default sink.
	DeleteExclusion(context.Context, *DeleteExclusionRequest) (*emptypb.Empty, error)
	// Gets the Logging CMEK settings for the given resource.
	//
	// Note: CMEK for the Log Router can be configured for Google Cloud projects,
	// folders, organizations and billing accounts. Once configured for an
	// organization, it applies to all projects and folders in the Google Cloud
	// organization.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	GetCmekSettings(context.Context, *GetCmekSettingsRequest) (*CmekSettings, error)
	// Updates the Log Router CMEK settings for the given resource.
	//
	// Note: CMEK for the Log Router can currently only be configured for Google
	// Cloud organizations. Once configured, it applies to all projects and
	// folders in the Google Cloud organization.
	//
	// [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
	// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
	// account does not have the required
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
	// 3) access to the key is disabled.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	UpdateCmekSettings(context.Context, *UpdateCmekSettingsRequest) (*CmekSettings, error)
	// Gets the Log Router settings for the given resource.
	//
	// Note: Settings for the Log Router can be get for Google Cloud projects,
	// folders, organizations and billing accounts. Currently it can only be
	// configured for organizations. Once configured for an organization, it
	// applies to all projects and folders in the Google Cloud organization.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates the Log Router settings for the given resource.
	//
	// Note: Settings for the Log Router can currently only be configured for
	// Google Cloud organizations. Once configured, it applies to all projects and
	// folders in the Google Cloud organization.
	//
	// [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
	// will fail if 1) `kms_key_name` is invalid, or 2) the associated service
	// account does not have the required
	// `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
	// 3) access to the key is disabled. 4) `location_id` is not supported by
	// Logging. 5) `location_id` violate OrgPolicy.
	//
	// See [Enabling CMEK for Log
	// Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error)
	// Copies a set of log entries from a log bucket to a Cloud Storage bucket.
	CopyLogEntries(context.Context, *CopyLogEntriesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConfigServiceV2Server should be embedded to have forward compatible implementations.
type UnimplementedConfigServiceV2Server struct {
}

func (UnimplementedConfigServiceV2Server) ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuckets not implemented")
}
func (UnimplementedConfigServiceV2Server) GetBucket(context.Context, *GetBucketRequest) (*LogBucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucket not implemented")
}
func (UnimplementedConfigServiceV2Server) CreateBucketAsync(context.Context, *CreateBucketRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBucketAsync not implemented")
}
func (UnimplementedConfigServiceV2Server) UpdateBucketAsync(context.Context, *UpdateBucketRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucketAsync not implemented")
}
func (UnimplementedConfigServiceV2Server) CreateBucket(context.Context, *CreateBucketRequest) (*LogBucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBucket not implemented")
}
func (UnimplementedConfigServiceV2Server) UpdateBucket(context.Context, *UpdateBucketRequest) (*LogBucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucket not implemented")
}
func (UnimplementedConfigServiceV2Server) DeleteBucket(context.Context, *DeleteBucketRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBucket not implemented")
}
func (UnimplementedConfigServiceV2Server) UndeleteBucket(context.Context, *UndeleteBucketRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteBucket not implemented")
}
func (UnimplementedConfigServiceV2Server) ListViews(context.Context, *ListViewsRequest) (*ListViewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListViews not implemented")
}
func (UnimplementedConfigServiceV2Server) GetView(context.Context, *GetViewRequest) (*LogView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetView not implemented")
}
func (UnimplementedConfigServiceV2Server) CreateView(context.Context, *CreateViewRequest) (*LogView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateView not implemented")
}
func (UnimplementedConfigServiceV2Server) UpdateView(context.Context, *UpdateViewRequest) (*LogView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateView not implemented")
}
func (UnimplementedConfigServiceV2Server) DeleteView(context.Context, *DeleteViewRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteView not implemented")
}
func (UnimplementedConfigServiceV2Server) ListSinks(context.Context, *ListSinksRequest) (*ListSinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSinks not implemented")
}
func (UnimplementedConfigServiceV2Server) GetSink(context.Context, *GetSinkRequest) (*LogSink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSink not implemented")
}
func (UnimplementedConfigServiceV2Server) CreateSink(context.Context, *CreateSinkRequest) (*LogSink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSink not implemented")
}
func (UnimplementedConfigServiceV2Server) UpdateSink(context.Context, *UpdateSinkRequest) (*LogSink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSink not implemented")
}
func (UnimplementedConfigServiceV2Server) DeleteSink(context.Context, *DeleteSinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSink not implemented")
}
func (UnimplementedConfigServiceV2Server) CreateLink(context.Context, *CreateLinkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLink not implemented")
}
func (UnimplementedConfigServiceV2Server) DeleteLink(context.Context, *DeleteLinkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLink not implemented")
}
func (UnimplementedConfigServiceV2Server) ListLinks(context.Context, *ListLinksRequest) (*ListLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLinks not implemented")
}
func (UnimplementedConfigServiceV2Server) GetLink(context.Context, *GetLinkRequest) (*Link, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLink not implemented")
}
func (UnimplementedConfigServiceV2Server) ListExclusions(context.Context, *ListExclusionsRequest) (*ListExclusionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExclusions not implemented")
}
func (UnimplementedConfigServiceV2Server) GetExclusion(context.Context, *GetExclusionRequest) (*LogExclusion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExclusion not implemented")
}
func (UnimplementedConfigServiceV2Server) CreateExclusion(context.Context, *CreateExclusionRequest) (*LogExclusion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExclusion not implemented")
}
func (UnimplementedConfigServiceV2Server) UpdateExclusion(context.Context, *UpdateExclusionRequest) (*LogExclusion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExclusion not implemented")
}
func (UnimplementedConfigServiceV2Server) DeleteExclusion(context.Context, *DeleteExclusionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExclusion not implemented")
}
func (UnimplementedConfigServiceV2Server) GetCmekSettings(context.Context, *GetCmekSettingsRequest) (*CmekSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCmekSettings not implemented")
}
func (UnimplementedConfigServiceV2Server) UpdateCmekSettings(context.Context, *UpdateCmekSettingsRequest) (*CmekSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCmekSettings not implemented")
}
func (UnimplementedConfigServiceV2Server) GetSettings(context.Context, *GetSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (UnimplementedConfigServiceV2Server) UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}
func (UnimplementedConfigServiceV2Server) CopyLogEntries(context.Context, *CopyLogEntriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CopyLogEntries not implemented")
}

// UnsafeConfigServiceV2Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConfigServiceV2Server will
// result in compilation errors.
type UnsafeConfigServiceV2Server interface {
	mustEmbedUnimplementedConfigServiceV2Server()
}

func RegisterConfigServiceV2Server(s grpc.ServiceRegistrar, srv ConfigServiceV2Server) {
	s.RegisterService(&ConfigServiceV2_ServiceDesc, srv)
}

func _ConfigServiceV2_ListBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_ListBuckets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListBuckets(ctx, req.(*ListBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_GetBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetBucket(ctx, req.(*GetBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateBucketAsync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateBucketAsync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_CreateBucketAsync_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateBucketAsync(ctx, req.(*CreateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateBucketAsync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateBucketAsync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UpdateBucketAsync_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateBucketAsync(ctx, req.(*UpdateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_CreateBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateBucket(ctx, req.(*CreateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UpdateBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateBucket(ctx, req.(*UpdateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_DeleteBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteBucket(ctx, req.(*DeleteBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UndeleteBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UndeleteBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UndeleteBucket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UndeleteBucket(ctx, req.(*UndeleteBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_ListViews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListViewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListViews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_ListViews_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListViews(ctx, req.(*ListViewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_GetView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetView(ctx, req.(*GetViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_CreateView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateView(ctx, req.(*CreateViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UpdateView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateView(ctx, req.(*UpdateViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteView_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteView(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_DeleteView_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteView(ctx, req.(*DeleteViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_ListSinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_ListSinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, req.(*ListSinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_GetSink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetSink(ctx, req.(*GetSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_CreateSink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, req.(*CreateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UpdateSink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, req.(*UpdateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_DeleteSink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, req.(*DeleteSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_CreateLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateLink(ctx, req.(*CreateLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_DeleteLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteLink(ctx, req.(*DeleteLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_ListLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_ListLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListLinks(ctx, req.(*ListLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_GetLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetLink(ctx, req.(*GetLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_ListExclusions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExclusionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListExclusions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_ListExclusions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListExclusions(ctx, req.(*ListExclusionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_GetExclusion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetExclusion(ctx, req.(*GetExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_CreateExclusion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateExclusion(ctx, req.(*CreateExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UpdateExclusion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateExclusion(ctx, req.(*UpdateExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteExclusion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExclusionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteExclusion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_DeleteExclusion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteExclusion(ctx, req.(*DeleteExclusionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetCmekSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCmekSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetCmekSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_GetCmekSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetCmekSettings(ctx, req.(*GetCmekSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateCmekSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCmekSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateCmekSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UpdateCmekSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateCmekSettings(ctx, req.(*UpdateCmekSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_GetSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetSettings(ctx, req.(*GetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_UpdateSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateSettings(ctx, req.(*UpdateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CopyLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CopyLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CopyLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConfigServiceV2_CopyLogEntries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CopyLogEntries(ctx, req.(*CopyLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ConfigServiceV2_ServiceDesc is the grpc.ServiceDesc for ConfigServiceV2 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConfigServiceV2_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.ConfigServiceV2",
	HandlerType: (*ConfigServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBuckets",
			Handler:    _ConfigServiceV2_ListBuckets_Handler,
		},
		{
			MethodName: "GetBucket",
			Handler:    _ConfigServiceV2_GetBucket_Handler,
		},
		{
			MethodName: "CreateBucketAsync",
			Handler:    _ConfigServiceV2_CreateBucketAsync_Handler,
		},
		{
			MethodName: "UpdateBucketAsync",
			Handler:    _ConfigServiceV2_UpdateBucketAsync_Handler,
		},
		{
			MethodName: "CreateBucket",
			Handler:    _ConfigServiceV2_CreateBucket_Handler,
		},
		{
			MethodName: "UpdateBucket",
			Handler:    _ConfigServiceV2_UpdateBucket_Handler,
		},
		{
			MethodName: "DeleteBucket",
			Handler:    _ConfigServiceV2_DeleteBucket_Handler,
		},
		{
			MethodName: "UndeleteBucket",
			Handler:    _ConfigServiceV2_UndeleteBucket_Handler,
		},
		{
			MethodName: "ListViews",
			Handler:    _ConfigServiceV2_ListViews_Handler,
		},
		{
			MethodName: "GetView",
			Handler:    _ConfigServiceV2_GetView_Handler,
		},
		{
			MethodName: "CreateView",
			Handler:    _ConfigServiceV2_CreateView_Handler,
		},
		{
			MethodName: "UpdateView",
			Handler:    _ConfigServiceV2_UpdateView_Handler,
		},
		{
			MethodName: "DeleteView",
			Handler:    _ConfigServiceV2_DeleteView_Handler,
		},
		{
			MethodName: "ListSinks",
			Handler:    _ConfigServiceV2_ListSinks_Handler,
		},
		{
			MethodName: "GetSink",
			Handler:    _ConfigServiceV2_GetSink_Handler,
		},
		{
			MethodName: "CreateSink",
			Handler:    _ConfigServiceV2_CreateSink_Handler,
		},
		{
			MethodName: "UpdateSink",
			Handler:    _ConfigServiceV2_UpdateSink_Handler,
		},
		{
			MethodName: "DeleteSink",
			Handler:    _ConfigServiceV2_DeleteSink_Handler,
		},
		{
			MethodName: "CreateLink",
			Handler:    _ConfigServiceV2_CreateLink_Handler,
		},
		{
			MethodName: "DeleteLink",
			Handler:    _ConfigServiceV2_DeleteLink_Handler,
		},
		{
			MethodName: "ListLinks",
			Handler:    _ConfigServiceV2_ListLinks_Handler,
		},
		{
			MethodName: "GetLink",
			Handler:    _ConfigServiceV2_GetLink_Handler,
		},
		{
			MethodName: "ListExclusions",
			Handler:    _ConfigServiceV2_ListExclusions_Handler,
		},
		{
			MethodName: "GetExclusion",
			Handler:    _ConfigServiceV2_GetExclusion_Handler,
		},
		{
			MethodName: "CreateExclusion",
			Handler:    _ConfigServiceV2_CreateExclusion_Handler,
		},
		{
			MethodName: "UpdateExclusion",
			Handler:    _ConfigServiceV2_UpdateExclusion_Handler,
		},
		{
			MethodName: "DeleteExclusion",
			Handler:    _ConfigServiceV2_DeleteExclusion_Handler,
		},
		{
			MethodName: "GetCmekSettings",
			Handler:    _ConfigServiceV2_GetCmekSettings_Handler,
		},
		{
			MethodName: "UpdateCmekSettings",
			Handler:    _ConfigServiceV2_UpdateCmekSettings_Handler,
		},
		{
			MethodName: "GetSettings",
			Handler:    _ConfigServiceV2_GetSettings_Handler,
		},
		{
			MethodName: "UpdateSettings",
			Handler:    _ConfigServiceV2_UpdateSettings_Handler,
		},
		{
			MethodName: "CopyLogEntries",
			Handler:    _ConfigServiceV2_CopyLogEntries_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/logging/v2/logging_config.proto",
}
