//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"time"
)

// AccessPolicy - An Access policy.
type AccessPolicy struct {
	// The date-time the policy expires.
	Expiry *time.Time `xml:"Expiry"`

	// The permissions for the ACL policy.
	Permission *string `xml:"Permission"`

	// The date-time the policy is active.
	Start *time.Time `xml:"Start"`
}

type ClearRange struct {
	// REQUIRED
	End *int64 `xml:"End"`

	// REQUIRED
	Start *int64 `xml:"Start"`
}

// CORSRule - CORS is an HTTP feature that enables a web application running under one domain to access resources in another
// domain. Web browsers implement a security restriction known as same-origin policy that
// prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin
// domain) to call APIs in another domain.
type CORSRule struct {
	// REQUIRED; The request headers that the origin domain may specify on the CORS request.
	AllowedHeaders *string `xml:"AllowedHeaders"`

	// REQUIRED; The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods *string `xml:"AllowedMethods"`

	// REQUIRED; The origin domains that are permitted to make a request against the storage service via CORS. The origin domain
	// is the domain from which the request originates. Note that the origin must be an exact
	// case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*'
	// to allow all origin domains to make requests via CORS.
	AllowedOrigins *string `xml:"AllowedOrigins"`

	// REQUIRED; The response headers that may be sent in the response to the CORS request and exposed by the browser to the request
	// issuer.
	ExposedHeaders *string `xml:"ExposedHeaders"`

	// REQUIRED; The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds *int32 `xml:"MaxAgeInSeconds"`
}

// Directory - A listed directory item.
type Directory struct {
	// REQUIRED
	Name          *string `xml:"Name"`
	Attributes    *string `xml:"Attributes"`
	ID            *string `xml:"FileId"`
	PermissionKey *string `xml:"PermissionKey"`

	// File properties.
	Properties *FileProperty `xml:"Properties"`
}

// File - A listed file item.
type File struct {
	// REQUIRED
	Name *string `xml:"Name"`

	// REQUIRED; File properties.
	Properties    *FileProperty `xml:"Properties"`
	Attributes    *string       `xml:"Attributes"`
	ID            *string       `xml:"FileId"`
	PermissionKey *string       `xml:"PermissionKey"`
}

// FileProperty - File properties.
type FileProperty struct {
	// REQUIRED; Content length of the file. This value may not be up-to-date since an SMB client may have modified the file locally.
	// The value of Content-Length may not reflect that fact until the handle is closed or
	// the op-lock is broken. To retrieve current property values, call Get File Properties.
	ContentLength  *int64       `xml:"Content-Length"`
	ChangeTime     *time.Time   `xml:"ChangeTime"`
	CreationTime   *time.Time   `xml:"CreationTime"`
	ETag           *azcore.ETag `xml:"Etag"`
	LastAccessTime *time.Time   `xml:"LastAccessTime"`
	LastModified   *time.Time   `xml:"Last-Modified"`
	LastWriteTime  *time.Time   `xml:"LastWriteTime"`
}

// FileRange - An Azure Storage file range.
type FileRange struct {
	// REQUIRED; End of the range.
	End *int64 `xml:"End"`

	// REQUIRED; Start of the range.
	Start *int64 `xml:"Start"`
}

// FilesAndDirectoriesListSegment - Abstract for entries that can be listed from Directory.
type FilesAndDirectoriesListSegment struct {
	// REQUIRED
	Directories []*Directory `xml:"Directory"`

	// REQUIRED
	Files []*File `xml:"File"`
}

// Handle - A listed Azure Storage handle item.
type Handle struct {
	// REQUIRED; Client IP that opened the handle
	ClientIP *string `xml:"ClientIp"`

	// REQUIRED; Name of the client machine where the share is being mounted
	ClientName *string `xml:"ClientName"`

	// REQUIRED; FileId uniquely identifies the file or directory.
	FileID *string `xml:"FileId"`

	// REQUIRED; XSMB service handle ID
	ID *string `xml:"HandleId"`

	// REQUIRED; Time when the session that previously opened the handle has last been reconnected. (UTC)
	OpenTime *time.Time `xml:"OpenTime"`

	// REQUIRED
	Path *string `xml:"Path"`

	// REQUIRED; SMB session ID in context of which the file handle was opened
	SessionID       *string        `xml:"SessionId"`
	AccessRightList []*AccessRight `xml:"AccessRightList>AccessRight"`

	// Time handle was last connected to (UTC)
	LastReconnectTime *time.Time `xml:"LastReconnectTime"`

	// ParentId uniquely identifies the parent directory of the object.
	ParentID *string `xml:"ParentId"`
}

// ListFilesAndDirectoriesSegmentResponse - An enumeration of directories and files.
type ListFilesAndDirectoriesSegmentResponse struct {
	// REQUIRED
	DirectoryPath *string `xml:"DirectoryPath,attr"`

	// REQUIRED
	NextMarker *string `xml:"NextMarker"`

	// REQUIRED
	Prefix *string `xml:"Prefix"`

	// REQUIRED; Abstract for entries that can be listed from Directory.
	Segment *FilesAndDirectoriesListSegment `xml:"Entries"`

	// REQUIRED
	ServiceEndpoint *string `xml:"ServiceEndpoint,attr"`

	// REQUIRED
	ShareName     *string `xml:"ShareName,attr"`
	DirectoryID   *string `xml:"DirectoryId"`
	Encoded       *bool   `xml:"Encoded,attr"`
	Marker        *string `xml:"Marker"`
	MaxResults    *int32  `xml:"MaxResults"`
	ShareSnapshot *string `xml:"ShareSnapshot,attr"`
}

// ListHandlesResponse - An enumeration of handles.
type ListHandlesResponse struct {
	// REQUIRED
	NextMarker *string   `xml:"NextMarker"`
	Handles    []*Handle `xml:"Entries>Handle"`
}

// ListSharesResponse - An enumeration of shares.
type ListSharesResponse struct {
	// REQUIRED
	NextMarker *string `xml:"NextMarker"`

	// REQUIRED
	ServiceEndpoint *string  `xml:"ServiceEndpoint,attr"`
	Marker          *string  `xml:"Marker"`
	MaxResults      *int32   `xml:"MaxResults"`
	Prefix          *string  `xml:"Prefix"`
	Shares          []*Share `xml:"Shares>Share"`
}

// Metrics - Storage Analytics metrics for file service.
type Metrics struct {
	// REQUIRED; Indicates whether metrics are enabled for the File service.
	Enabled *bool `xml:"Enabled"`

	// REQUIRED; The version of Storage Analytics to configure.
	Version *string `xml:"Version"`

	// Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs *bool `xml:"IncludeAPIs"`

	// The retention policy.
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`
}

// ProtocolSettings - Protocol settings
type ProtocolSettings struct {
	// Settings for SMB protocol.
	Smb *SMBSettings `xml:"SMB"`
}

// RetentionPolicy - The retention policy.
type RetentionPolicy struct {
	// REQUIRED; Indicates whether a retention policy is enabled for the File service. If false, metrics data is retained, and
	// the user is responsible for deleting it.
	Enabled *bool `xml:"Enabled"`

	// Indicates the number of days that metrics data should be retained. All data older than this value will be deleted. Metrics
	// data is deleted on a best-effort basis after the retention period expires.
	Days *int32 `xml:"Days"`
}

// SMBSettings - Settings for SMB protocol.
type SMBSettings struct {
	// Settings for SMB Multichannel.
	Multichannel *SMBMultichannel `xml:"Multichannel"`
}

// Share - A listed Azure Storage share item.
type Share struct {
	// REQUIRED
	Name *string `xml:"Name"`

	// REQUIRED; Properties of a share.
	Properties *ShareProperties `xml:"Properties"`
	Deleted    *bool            `xml:"Deleted"`

	// Dictionary of
	Metadata map[string]*string `xml:"Metadata"`
	Snapshot *string            `xml:"Snapshot"`
	Version  *string            `xml:"Version"`
}

// ShareFileRangeList - The list of file ranges
type ShareFileRangeList struct {
	ClearRanges []*ClearRange `xml:"ClearRange"`
	Ranges      []*FileRange  `xml:"Range"`
}

// SharePermission - A permission (a security descriptor) at the share level.
type SharePermission struct {
	// REQUIRED; The permission in the Security Descriptor Definition Language (SDDL).
	Permission *string
	Format     *FilePermissionFormat
}

// ShareProperties - Properties of a share.
type ShareProperties struct {
	// REQUIRED
	ETag *azcore.ETag `xml:"Etag"`

	// REQUIRED
	LastModified *time.Time `xml:"Last-Modified"`

	// REQUIRED
	Quota                                *int32     `xml:"Quota"`
	AccessTier                           *string    `xml:"AccessTier"`
	AccessTierChangeTime                 *time.Time `xml:"AccessTierChangeTime"`
	AccessTierTransitionState            *string    `xml:"AccessTierTransitionState"`
	DeletedTime                          *time.Time `xml:"DeletedTime"`
	EnableSnapshotVirtualDirectoryAccess *bool      `xml:"EnableSnapshotVirtualDirectoryAccess"`
	EnabledProtocols                     *string    `xml:"EnabledProtocols"`

	// When a share is leased, specifies whether the lease is of infinite or fixed duration.
	LeaseDuration *LeaseDurationType `xml:"LeaseDuration"`

	// Lease state of the share.
	LeaseState *LeaseStateType `xml:"LeaseState"`

	// The current lease status of the share.
	LeaseStatus                   *LeaseStatusType `xml:"LeaseStatus"`
	NextAllowedQuotaDowngradeTime *time.Time       `xml:"NextAllowedQuotaDowngradeTime"`
	PaidBurstingEnabled           *bool            `xml:"PaidBurstingEnabled"`
	PaidBurstingMaxBandwidthMibps *int64           `xml:"PaidBurstingMaxBandwidthMibps"`
	PaidBurstingMaxIops           *int64           `xml:"PaidBurstingMaxIops"`
	ProvisionedBandwidthMiBps     *int32           `xml:"ProvisionedBandwidthMiBps"`
	ProvisionedEgressMBps         *int32           `xml:"ProvisionedEgressMBps"`
	ProvisionedIngressMBps        *int32           `xml:"ProvisionedIngressMBps"`
	ProvisionedIops               *int32           `xml:"ProvisionedIops"`
	RemainingRetentionDays        *int32           `xml:"RemainingRetentionDays"`
	RootSquash                    *ShareRootSquash `xml:"RootSquash"`
}

// ShareStats - Stats for the share.
type ShareStats struct {
	// REQUIRED; The approximate size of the data stored in bytes. Note that this value may not include all recently created or
	// recently resized files.
	ShareUsageBytes *int64 `xml:"ShareUsageBytes"`
}

// SignedIdentifier - Signed identifier.
type SignedIdentifier struct {
	// REQUIRED; A unique id.
	ID *string `xml:"Id"`

	// The access policy.
	AccessPolicy *AccessPolicy `xml:"AccessPolicy"`
}

// SMBMultichannel - Settings for SMB multichannel
type SMBMultichannel struct {
	// If SMB multichannel is enabled.
	Enabled *bool `xml:"Enabled"`
}

type StorageError struct {
	AuthenticationErrorDetail *string
	Message                   *string
}

// StorageServiceProperties - Storage service properties.
type StorageServiceProperties struct {
	// The set of CORS rules.
	CORS []*CORSRule `xml:"Cors>CorsRule"`

	// A summary of request statistics grouped by API in hourly aggregates for files.
	HourMetrics *Metrics `xml:"HourMetrics"`

	// A summary of request statistics grouped by API in minute aggregates for files.
	MinuteMetrics *Metrics `xml:"MinuteMetrics"`

	// Protocol settings
	Protocol *ProtocolSettings `xml:"ProtocolSettings"`
}

type StringEncoded struct {
	Content *string `xml:",chardata"`
	Encoded *bool   `xml:"Encoded,attr"`
}
