package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessScope enumerates the values for access scope.
type AccessScope string

const (
	// Job ...
	Job AccessScope = "job"
)

// PossibleAccessScopeValues returns an array of possible values for the AccessScope const type.
func PossibleAccessScopeValues() []AccessScope {
	return []AccessScope{Job}
}

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "resizing"
	// Steady ...
	Steady AllocationState = "steady"
	// Stopping ...
	Stopping AllocationState = "stopping"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady, Stopping}
}

// AutoUserScope enumerates the values for auto user scope.
type AutoUserScope string

const (
	// Pool ...
	Pool AutoUserScope = "pool"
	// Task ...
	Task AutoUserScope = "task"
)

// PossibleAutoUserScopeValues returns an array of possible values for the AutoUserScope const type.
func PossibleAutoUserScopeValues() []AutoUserScope {
	return []AutoUserScope{Pool, Task}
}

// CachingType enumerates the values for caching type.
type CachingType string

const (
	// None ...
	None CachingType = "none"
	// ReadOnly ...
	ReadOnly CachingType = "readOnly"
	// ReadWrite ...
	ReadWrite CachingType = "readWrite"
)

// PossibleCachingTypeValues returns an array of possible values for the CachingType const type.
func PossibleCachingTypeValues() []CachingType {
	return []CachingType{None, ReadOnly, ReadWrite}
}

// CertificateFormat enumerates the values for certificate format.
type CertificateFormat string

const (
	// Cer ...
	Cer CertificateFormat = "cer"
	// Pfx ...
	Pfx CertificateFormat = "pfx"
)

// PossibleCertificateFormatValues returns an array of possible values for the CertificateFormat const type.
func PossibleCertificateFormatValues() []CertificateFormat {
	return []CertificateFormat{Cer, Pfx}
}

// CertificateState enumerates the values for certificate state.
type CertificateState string

const (
	// Active ...
	Active CertificateState = "active"
	// DeleteFailed ...
	DeleteFailed CertificateState = "deleteFailed"
	// Deleting ...
	Deleting CertificateState = "deleting"
)

// PossibleCertificateStateValues returns an array of possible values for the CertificateState const type.
func PossibleCertificateStateValues() []CertificateState {
	return []CertificateState{Active, DeleteFailed, Deleting}
}

// CertificateStoreLocation enumerates the values for certificate store location.
type CertificateStoreLocation string

const (
	// CurrentUser ...
	CurrentUser CertificateStoreLocation = "currentUser"
	// LocalMachine ...
	LocalMachine CertificateStoreLocation = "localMachine"
)

// PossibleCertificateStoreLocationValues returns an array of possible values for the CertificateStoreLocation const type.
func PossibleCertificateStoreLocationValues() []CertificateStoreLocation {
	return []CertificateStoreLocation{CurrentUser, LocalMachine}
}

// CertificateVisibility enumerates the values for certificate visibility.
type CertificateVisibility string

const (
	// CertificateVisibilityRemoteUser ...
	CertificateVisibilityRemoteUser CertificateVisibility = "remoteUser"
	// CertificateVisibilityStartTask ...
	CertificateVisibilityStartTask CertificateVisibility = "startTask"
	// CertificateVisibilityTask ...
	CertificateVisibilityTask CertificateVisibility = "task"
)

// PossibleCertificateVisibilityValues returns an array of possible values for the CertificateVisibility const type.
func PossibleCertificateVisibilityValues() []CertificateVisibility {
	return []CertificateVisibility{CertificateVisibilityRemoteUser, CertificateVisibilityStartTask, CertificateVisibilityTask}
}

// ComputeNodeDeallocationOption enumerates the values for compute node deallocation option.
type ComputeNodeDeallocationOption string

const (
	// Requeue ...
	Requeue ComputeNodeDeallocationOption = "requeue"
	// RetainedData ...
	RetainedData ComputeNodeDeallocationOption = "retainedData"
	// TaskCompletion ...
	TaskCompletion ComputeNodeDeallocationOption = "taskCompletion"
	// Terminate ...
	Terminate ComputeNodeDeallocationOption = "terminate"
)

// PossibleComputeNodeDeallocationOptionValues returns an array of possible values for the ComputeNodeDeallocationOption const type.
func PossibleComputeNodeDeallocationOptionValues() []ComputeNodeDeallocationOption {
	return []ComputeNodeDeallocationOption{Requeue, RetainedData, TaskCompletion, Terminate}
}

// ComputeNodeFillType enumerates the values for compute node fill type.
type ComputeNodeFillType string

const (
	// Pack ...
	Pack ComputeNodeFillType = "pack"
	// Spread ...
	Spread ComputeNodeFillType = "spread"
)

// PossibleComputeNodeFillTypeValues returns an array of possible values for the ComputeNodeFillType const type.
func PossibleComputeNodeFillTypeValues() []ComputeNodeFillType {
	return []ComputeNodeFillType{Pack, Spread}
}

// ComputeNodeRebootOption enumerates the values for compute node reboot option.
type ComputeNodeRebootOption string

const (
	// ComputeNodeRebootOptionRequeue ...
	ComputeNodeRebootOptionRequeue ComputeNodeRebootOption = "requeue"
	// ComputeNodeRebootOptionRetainedData ...
	ComputeNodeRebootOptionRetainedData ComputeNodeRebootOption = "retainedData"
	// ComputeNodeRebootOptionTaskCompletion ...
	ComputeNodeRebootOptionTaskCompletion ComputeNodeRebootOption = "taskCompletion"
	// ComputeNodeRebootOptionTerminate ...
	ComputeNodeRebootOptionTerminate ComputeNodeRebootOption = "terminate"
)

// PossibleComputeNodeRebootOptionValues returns an array of possible values for the ComputeNodeRebootOption const type.
func PossibleComputeNodeRebootOptionValues() []ComputeNodeRebootOption {
	return []ComputeNodeRebootOption{ComputeNodeRebootOptionRequeue, ComputeNodeRebootOptionRetainedData, ComputeNodeRebootOptionTaskCompletion, ComputeNodeRebootOptionTerminate}
}

// ComputeNodeReimageOption enumerates the values for compute node reimage option.
type ComputeNodeReimageOption string

const (
	// ComputeNodeReimageOptionRequeue ...
	ComputeNodeReimageOptionRequeue ComputeNodeReimageOption = "requeue"
	// ComputeNodeReimageOptionRetainedData ...
	ComputeNodeReimageOptionRetainedData ComputeNodeReimageOption = "retainedData"
	// ComputeNodeReimageOptionTaskCompletion ...
	ComputeNodeReimageOptionTaskCompletion ComputeNodeReimageOption = "taskCompletion"
	// ComputeNodeReimageOptionTerminate ...
	ComputeNodeReimageOptionTerminate ComputeNodeReimageOption = "terminate"
)

// PossibleComputeNodeReimageOptionValues returns an array of possible values for the ComputeNodeReimageOption const type.
func PossibleComputeNodeReimageOptionValues() []ComputeNodeReimageOption {
	return []ComputeNodeReimageOption{ComputeNodeReimageOptionRequeue, ComputeNodeReimageOptionRetainedData, ComputeNodeReimageOptionTaskCompletion, ComputeNodeReimageOptionTerminate}
}

// ComputeNodeState enumerates the values for compute node state.
type ComputeNodeState string

const (
	// Creating ...
	Creating ComputeNodeState = "creating"
	// Idle ...
	Idle ComputeNodeState = "idle"
	// LeavingPool ...
	LeavingPool ComputeNodeState = "leavingPool"
	// Offline ...
	Offline ComputeNodeState = "offline"
	// Preempted ...
	Preempted ComputeNodeState = "preempted"
	// Rebooting ...
	Rebooting ComputeNodeState = "rebooting"
	// Reimaging ...
	Reimaging ComputeNodeState = "reimaging"
	// Running ...
	Running ComputeNodeState = "running"
	// Starting ...
	Starting ComputeNodeState = "starting"
	// StartTaskFailed ...
	StartTaskFailed ComputeNodeState = "startTaskFailed"
	// Unknown ...
	Unknown ComputeNodeState = "unknown"
	// Unusable ...
	Unusable ComputeNodeState = "unusable"
	// WaitingForStartTask ...
	WaitingForStartTask ComputeNodeState = "waitingForStartTask"
)

// PossibleComputeNodeStateValues returns an array of possible values for the ComputeNodeState const type.
func PossibleComputeNodeStateValues() []ComputeNodeState {
	return []ComputeNodeState{Creating, Idle, LeavingPool, Offline, Preempted, Rebooting, Reimaging, Running, Starting, StartTaskFailed, Unknown, Unusable, WaitingForStartTask}
}

// DependencyAction enumerates the values for dependency action.
type DependencyAction string

const (
	// Block ...
	Block DependencyAction = "block"
	// Satisfy ...
	Satisfy DependencyAction = "satisfy"
)

// PossibleDependencyActionValues returns an array of possible values for the DependencyAction const type.
func PossibleDependencyActionValues() []DependencyAction {
	return []DependencyAction{Block, Satisfy}
}

// DisableComputeNodeSchedulingOption enumerates the values for disable compute node scheduling option.
type DisableComputeNodeSchedulingOption string

const (
	// DisableComputeNodeSchedulingOptionRequeue ...
	DisableComputeNodeSchedulingOptionRequeue DisableComputeNodeSchedulingOption = "requeue"
	// DisableComputeNodeSchedulingOptionTaskCompletion ...
	DisableComputeNodeSchedulingOptionTaskCompletion DisableComputeNodeSchedulingOption = "taskCompletion"
	// DisableComputeNodeSchedulingOptionTerminate ...
	DisableComputeNodeSchedulingOptionTerminate DisableComputeNodeSchedulingOption = "terminate"
)

// PossibleDisableComputeNodeSchedulingOptionValues returns an array of possible values for the DisableComputeNodeSchedulingOption const type.
func PossibleDisableComputeNodeSchedulingOptionValues() []DisableComputeNodeSchedulingOption {
	return []DisableComputeNodeSchedulingOption{DisableComputeNodeSchedulingOptionRequeue, DisableComputeNodeSchedulingOptionTaskCompletion, DisableComputeNodeSchedulingOptionTerminate}
}

// DisableJobOption enumerates the values for disable job option.
type DisableJobOption string

const (
	// DisableJobOptionRequeue ...
	DisableJobOptionRequeue DisableJobOption = "requeue"
	// DisableJobOptionTerminate ...
	DisableJobOptionTerminate DisableJobOption = "terminate"
	// DisableJobOptionWait ...
	DisableJobOptionWait DisableJobOption = "wait"
)

// PossibleDisableJobOptionValues returns an array of possible values for the DisableJobOption const type.
func PossibleDisableJobOptionValues() []DisableJobOption {
	return []DisableJobOption{DisableJobOptionRequeue, DisableJobOptionTerminate, DisableJobOptionWait}
}

// ElevationLevel enumerates the values for elevation level.
type ElevationLevel string

const (
	// Admin ...
	Admin ElevationLevel = "admin"
	// NonAdmin ...
	NonAdmin ElevationLevel = "nonAdmin"
)

// PossibleElevationLevelValues returns an array of possible values for the ElevationLevel const type.
func PossibleElevationLevelValues() []ElevationLevel {
	return []ElevationLevel{Admin, NonAdmin}
}

// ErrorCategory enumerates the values for error category.
type ErrorCategory string

const (
	// ServerError ...
	ServerError ErrorCategory = "serverError"
	// UserError ...
	UserError ErrorCategory = "userError"
)

// PossibleErrorCategoryValues returns an array of possible values for the ErrorCategory const type.
func PossibleErrorCategoryValues() []ErrorCategory {
	return []ErrorCategory{ServerError, UserError}
}

// JobAction enumerates the values for job action.
type JobAction string

const (
	// JobActionDisable ...
	JobActionDisable JobAction = "disable"
	// JobActionNone ...
	JobActionNone JobAction = "none"
	// JobActionTerminate ...
	JobActionTerminate JobAction = "terminate"
)

// PossibleJobActionValues returns an array of possible values for the JobAction const type.
func PossibleJobActionValues() []JobAction {
	return []JobAction{JobActionDisable, JobActionNone, JobActionTerminate}
}

// JobPreparationTaskState enumerates the values for job preparation task state.
type JobPreparationTaskState string

const (
	// JobPreparationTaskStateCompleted ...
	JobPreparationTaskStateCompleted JobPreparationTaskState = "completed"
	// JobPreparationTaskStateRunning ...
	JobPreparationTaskStateRunning JobPreparationTaskState = "running"
)

// PossibleJobPreparationTaskStateValues returns an array of possible values for the JobPreparationTaskState const type.
func PossibleJobPreparationTaskStateValues() []JobPreparationTaskState {
	return []JobPreparationTaskState{JobPreparationTaskStateCompleted, JobPreparationTaskStateRunning}
}

// JobReleaseTaskState enumerates the values for job release task state.
type JobReleaseTaskState string

const (
	// JobReleaseTaskStateCompleted ...
	JobReleaseTaskStateCompleted JobReleaseTaskState = "completed"
	// JobReleaseTaskStateRunning ...
	JobReleaseTaskStateRunning JobReleaseTaskState = "running"
)

// PossibleJobReleaseTaskStateValues returns an array of possible values for the JobReleaseTaskState const type.
func PossibleJobReleaseTaskStateValues() []JobReleaseTaskState {
	return []JobReleaseTaskState{JobReleaseTaskStateCompleted, JobReleaseTaskStateRunning}
}

// JobScheduleState enumerates the values for job schedule state.
type JobScheduleState string

const (
	// JobScheduleStateActive ...
	JobScheduleStateActive JobScheduleState = "active"
	// JobScheduleStateCompleted ...
	JobScheduleStateCompleted JobScheduleState = "completed"
	// JobScheduleStateDeleting ...
	JobScheduleStateDeleting JobScheduleState = "deleting"
	// JobScheduleStateDisabled ...
	JobScheduleStateDisabled JobScheduleState = "disabled"
	// JobScheduleStateTerminating ...
	JobScheduleStateTerminating JobScheduleState = "terminating"
)

// PossibleJobScheduleStateValues returns an array of possible values for the JobScheduleState const type.
func PossibleJobScheduleStateValues() []JobScheduleState {
	return []JobScheduleState{JobScheduleStateActive, JobScheduleStateCompleted, JobScheduleStateDeleting, JobScheduleStateDisabled, JobScheduleStateTerminating}
}

// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateActive ...
	JobStateActive JobState = "active"
	// JobStateCompleted ...
	JobStateCompleted JobState = "completed"
	// JobStateDeleting ...
	JobStateDeleting JobState = "deleting"
	// JobStateDisabled ...
	JobStateDisabled JobState = "disabled"
	// JobStateDisabling ...
	JobStateDisabling JobState = "disabling"
	// JobStateEnabling ...
	JobStateEnabling JobState = "enabling"
	// JobStateTerminating ...
	JobStateTerminating JobState = "terminating"
)

// PossibleJobStateValues returns an array of possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{JobStateActive, JobStateCompleted, JobStateDeleting, JobStateDisabled, JobStateDisabling, JobStateEnabling, JobStateTerminating}
}

// OnAllTasksComplete enumerates the values for on all tasks complete.
type OnAllTasksComplete string

const (
	// NoAction ...
	NoAction OnAllTasksComplete = "noAction"
	// TerminateJob ...
	TerminateJob OnAllTasksComplete = "terminateJob"
)

// PossibleOnAllTasksCompleteValues returns an array of possible values for the OnAllTasksComplete const type.
func PossibleOnAllTasksCompleteValues() []OnAllTasksComplete {
	return []OnAllTasksComplete{NoAction, TerminateJob}
}

// OnTaskFailure enumerates the values for on task failure.
type OnTaskFailure string

const (
	// OnTaskFailureNoAction ...
	OnTaskFailureNoAction OnTaskFailure = "noAction"
	// OnTaskFailurePerformExitOptionsJobAction ...
	OnTaskFailurePerformExitOptionsJobAction OnTaskFailure = "performExitOptionsJobAction"
)

// PossibleOnTaskFailureValues returns an array of possible values for the OnTaskFailure const type.
func PossibleOnTaskFailureValues() []OnTaskFailure {
	return []OnTaskFailure{OnTaskFailureNoAction, OnTaskFailurePerformExitOptionsJobAction}
}

// OSType enumerates the values for os type.
type OSType string

const (
	// Linux ...
	Linux OSType = "linux"
	// Windows ...
	Windows OSType = "windows"
)

// PossibleOSTypeValues returns an array of possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{Linux, Windows}
}

// OutputFileUploadCondition enumerates the values for output file upload condition.
type OutputFileUploadCondition string

const (
	// OutputFileUploadConditionTaskCompletion ...
	OutputFileUploadConditionTaskCompletion OutputFileUploadCondition = "taskCompletion"
	// OutputFileUploadConditionTaskFailure ...
	OutputFileUploadConditionTaskFailure OutputFileUploadCondition = "taskFailure"
	// OutputFileUploadConditionTaskSuccess ...
	OutputFileUploadConditionTaskSuccess OutputFileUploadCondition = "taskSuccess"
)

// PossibleOutputFileUploadConditionValues returns an array of possible values for the OutputFileUploadCondition const type.
func PossibleOutputFileUploadConditionValues() []OutputFileUploadCondition {
	return []OutputFileUploadCondition{OutputFileUploadConditionTaskCompletion, OutputFileUploadConditionTaskFailure, OutputFileUploadConditionTaskSuccess}
}

// PoolLifetimeOption enumerates the values for pool lifetime option.
type PoolLifetimeOption string

const (
	// PoolLifetimeOptionJob ...
	PoolLifetimeOptionJob PoolLifetimeOption = "job"
	// PoolLifetimeOptionJobSchedule ...
	PoolLifetimeOptionJobSchedule PoolLifetimeOption = "jobSchedule"
)

// PossiblePoolLifetimeOptionValues returns an array of possible values for the PoolLifetimeOption const type.
func PossiblePoolLifetimeOptionValues() []PoolLifetimeOption {
	return []PoolLifetimeOption{PoolLifetimeOptionJob, PoolLifetimeOptionJobSchedule}
}

// PoolState enumerates the values for pool state.
type PoolState string

const (
	// PoolStateActive ...
	PoolStateActive PoolState = "active"
	// PoolStateDeleting ...
	PoolStateDeleting PoolState = "deleting"
	// PoolStateUpgrading ...
	PoolStateUpgrading PoolState = "upgrading"
)

// PossiblePoolStateValues returns an array of possible values for the PoolState const type.
func PossiblePoolStateValues() []PoolState {
	return []PoolState{PoolStateActive, PoolStateDeleting, PoolStateUpgrading}
}

// SchedulingState enumerates the values for scheduling state.
type SchedulingState string

const (
	// Disabled ...
	Disabled SchedulingState = "disabled"
	// Enabled ...
	Enabled SchedulingState = "enabled"
)

// PossibleSchedulingStateValues returns an array of possible values for the SchedulingState const type.
func PossibleSchedulingStateValues() []SchedulingState {
	return []SchedulingState{Disabled, Enabled}
}

// StartTaskState enumerates the values for start task state.
type StartTaskState string

const (
	// StartTaskStateCompleted ...
	StartTaskStateCompleted StartTaskState = "completed"
	// StartTaskStateRunning ...
	StartTaskStateRunning StartTaskState = "running"
)

// PossibleStartTaskStateValues returns an array of possible values for the StartTaskState const type.
func PossibleStartTaskStateValues() []StartTaskState {
	return []StartTaskState{StartTaskStateCompleted, StartTaskStateRunning}
}

// SubtaskState enumerates the values for subtask state.
type SubtaskState string

const (
	// SubtaskStateCompleted ...
	SubtaskStateCompleted SubtaskState = "completed"
	// SubtaskStatePreparing ...
	SubtaskStatePreparing SubtaskState = "preparing"
	// SubtaskStateRunning ...
	SubtaskStateRunning SubtaskState = "running"
)

// PossibleSubtaskStateValues returns an array of possible values for the SubtaskState const type.
func PossibleSubtaskStateValues() []SubtaskState {
	return []SubtaskState{SubtaskStateCompleted, SubtaskStatePreparing, SubtaskStateRunning}
}

// TaskAddStatus enumerates the values for task add status.
type TaskAddStatus string

const (
	// TaskAddStatusClientError ...
	TaskAddStatusClientError TaskAddStatus = "clientError"
	// TaskAddStatusServerError ...
	TaskAddStatusServerError TaskAddStatus = "serverError"
	// TaskAddStatusSuccess ...
	TaskAddStatusSuccess TaskAddStatus = "success"
)

// PossibleTaskAddStatusValues returns an array of possible values for the TaskAddStatus const type.
func PossibleTaskAddStatusValues() []TaskAddStatus {
	return []TaskAddStatus{TaskAddStatusClientError, TaskAddStatusServerError, TaskAddStatusSuccess}
}

// TaskExecutionResult enumerates the values for task execution result.
type TaskExecutionResult string

const (
	// Failure ...
	Failure TaskExecutionResult = "failure"
	// Success ...
	Success TaskExecutionResult = "success"
)

// PossibleTaskExecutionResultValues returns an array of possible values for the TaskExecutionResult const type.
func PossibleTaskExecutionResultValues() []TaskExecutionResult {
	return []TaskExecutionResult{Failure, Success}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateActive ...
	TaskStateActive TaskState = "active"
	// TaskStateCompleted ...
	TaskStateCompleted TaskState = "completed"
	// TaskStatePreparing ...
	TaskStatePreparing TaskState = "preparing"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "running"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateActive, TaskStateCompleted, TaskStatePreparing, TaskStateRunning}
}
