package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/monitor/mgmt/2020-10-01/insights"

// ActionGroup a pointer to an Azure Action Group.
type ActionGroup struct {
	// ActionGroupID - The resource ID of the Action Group. This cannot be null or empty.
	ActionGroupID *string `json:"actionGroupId,omitempty"`
	// WebhookProperties - the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	WebhookProperties map[string]*string `json:"webhookProperties"`
}

// MarshalJSON is the custom marshaler for ActionGroup.
func (ag ActionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ActionGroupID != nil {
		objectMap["actionGroupId"] = ag.ActionGroupID
	}
	if ag.WebhookProperties != nil {
		objectMap["webhookProperties"] = ag.WebhookProperties
	}
	return json.Marshal(objectMap)
}

// ActionList a list of Activity Log Alert rule actions.
type ActionList struct {
	// ActionGroups - The list of the Action Groups.
	ActionGroups *[]ActionGroup `json:"actionGroups,omitempty"`
}

// ActivityLogAlertResource an Activity Log Alert rule resource.
type ActivityLogAlertResource struct {
	autorest.Response `json:"-"`
	// AlertRuleProperties - The Activity Log Alert rule properties of the resource.
	*AlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ActivityLogAlertResource.
func (alar ActivityLogAlertResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if alar.AlertRuleProperties != nil {
		objectMap["properties"] = alar.AlertRuleProperties
	}
	if alar.Location != nil {
		objectMap["location"] = alar.Location
	}
	if alar.Tags != nil {
		objectMap["tags"] = alar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityLogAlertResource struct.
func (alar *ActivityLogAlertResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertRuleProperties AlertRuleProperties
				err = json.Unmarshal(*v, &alertRuleProperties)
				if err != nil {
					return err
				}
				alar.AlertRuleProperties = &alertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				alar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				alar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				alar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				alar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				alar.Tags = tags
			}
		}
	}

	return nil
}

// AlertRuleAllOfCondition an Activity Log Alert rule condition that is met when all its member conditions
// are met.
type AlertRuleAllOfCondition struct {
	// AllOf - The list of Activity Log Alert rule conditions.
	AllOf *[]AlertRuleAnyOfOrLeafCondition `json:"allOf,omitempty"`
}

// AlertRuleAnyOfOrLeafCondition an Activity Log Alert rule condition that is met when all its member
// conditions are met.
// Each condition can be of one of the following types:
// __Important__: Each type has its unique subset of properties. Properties from different types CANNOT
// exist in one condition.
// * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
// _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
// * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
// _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._
type AlertRuleAnyOfOrLeafCondition struct {
	// AnyOf - An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
	AnyOf *[]AlertRuleLeafCondition `json:"anyOf,omitempty"`
	// Field - The name of the Activity Log event's field that this condition will examine.
	// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
	// Equals - The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`
	// ContainsAny - The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
	ContainsAny *[]string `json:"containsAny,omitempty"`
}

// AlertRuleLeafCondition an Activity Log Alert rule condition that is met by comparing the field and value
// of an Activity Log event.
// This condition must contain 'field' and either 'equals' or 'containsAny'.
type AlertRuleLeafCondition struct {
	// Field - The name of the Activity Log event's field that this condition will examine.
	// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
	Field *string `json:"field,omitempty"`
	// Equals - The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`
	// ContainsAny - The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
	ContainsAny *[]string `json:"containsAny,omitempty"`
}

// AlertRuleList a list of Activity Log Alert rules.
type AlertRuleList struct {
	autorest.Response `json:"-"`
	// Value - The list of Activity Log Alert rules.
	Value *[]ActivityLogAlertResource `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertRuleListIterator provides access to a complete listing of ActivityLogAlertResource values.
type AlertRuleListIterator struct {
	i    int
	page AlertRuleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRuleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRuleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRuleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRuleListIterator) Response() AlertRuleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRuleListIterator) Value() ActivityLogAlertResource {
	if !iter.page.NotDone() {
		return ActivityLogAlertResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRuleListIterator type.
func NewAlertRuleListIterator(page AlertRuleListPage) AlertRuleListIterator {
	return AlertRuleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AlertRuleList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AlertRuleList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// alertRuleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AlertRuleList) alertRuleListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AlertRuleListPage contains a page of ActivityLogAlertResource values.
type AlertRuleListPage struct {
	fn  func(context.Context, AlertRuleList) (AlertRuleList, error)
	arl AlertRuleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRuleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRuleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRuleListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRuleListPage) Response() AlertRuleList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRuleListPage) Values() []ActivityLogAlertResource {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AlertRuleListPage type.
func NewAlertRuleListPage(cur AlertRuleList, getNextPage func(context.Context, AlertRuleList) (AlertRuleList, error)) AlertRuleListPage {
	return AlertRuleListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// AlertRulePatchObject an Activity Log Alert rule object for the body of patch operations.
type AlertRulePatchObject struct {
	// Tags - The resource tags
	Tags map[string]*string `json:"tags"`
	// AlertRulePatchProperties - The activity log alert settings for an update operation.
	*AlertRulePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRulePatchObject.
func (arpo AlertRulePatchObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arpo.Tags != nil {
		objectMap["tags"] = arpo.Tags
	}
	if arpo.AlertRulePatchProperties != nil {
		objectMap["properties"] = arpo.AlertRulePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRulePatchObject struct.
func (arpo *AlertRulePatchObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arpo.Tags = tags
			}
		case "properties":
			if v != nil {
				var alertRulePatchProperties AlertRulePatchProperties
				err = json.Unmarshal(*v, &alertRulePatchProperties)
				if err != nil {
					return err
				}
				arpo.AlertRulePatchProperties = &alertRulePatchProperties
			}
		}
	}

	return nil
}

// AlertRulePatchProperties an Activity Log Alert rule properties for patch operations.
type AlertRulePatchProperties struct {
	// Enabled - Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertRuleProperties an Azure Activity Log Alert rule.
type AlertRuleProperties struct {
	// Scopes - A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
	Scopes *[]string `json:"scopes,omitempty"`
	// Condition - The condition that will cause this alert to activate.
	Condition *AlertRuleAllOfCondition `json:"condition,omitempty"`
	// Actions - The actions that will activate when the condition is met.
	Actions *ActionList `json:"actions,omitempty"`
	// Enabled - Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
	// Description - A description of this Activity Log Alert rule.
	Description *string `json:"description,omitempty"`
}

// AzureResource an Azure resource object.
type AzureResource struct {
	// ID - READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AzureResource.
func (ar AzureResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	return json.Marshal(objectMap)
}

// ErrorResponse the error response.
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}
