package netapp

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/netapp/mgmt/2020-05-01/netapp"

// Account netApp account resource
type Account struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AccountProperties - NetApp Account properties
	*AccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		}
	}

	return nil
}

// AccountBackupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountBackupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountBackupsClient) (autorest.Response, error)
}

// AccountList list of NetApp account resources
type AccountList struct {
	autorest.Response `json:"-"`
	// Value - Multiple NetApp accounts
	Value *[]Account `json:"value,omitempty"`
}

// AccountPatch netApp account patch resource
type AccountPatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AccountProperties - NetApp Account properties
	*AccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountPatch.
func (ap AccountPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Location != nil {
		objectMap["location"] = ap.Location
	}
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	if ap.AccountProperties != nil {
		objectMap["properties"] = ap.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountPatch struct.
func (ap *AccountPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ap.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				ap.AccountProperties = &accountProperties
			}
		}
	}

	return nil
}

// AccountProperties netApp account properties
type AccountProperties struct {
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ActiveDirectories - Active Directories
	ActiveDirectories *[]ActiveDirectory `json:"activeDirectories,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ActiveDirectories != nil {
		objectMap["activeDirectories"] = ap.ActiveDirectories
	}
	return json.Marshal(objectMap)
}

// AccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// AccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (autorest.Response, error)
}

// AccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountsClient) (Account, error)
}

// ActiveDirectory active Directory
type ActiveDirectory struct {
	// ActiveDirectoryID - Id of the Active Directory
	ActiveDirectoryID *string `json:"activeDirectoryId,omitempty"`
	// Username - Username of Active Directory domain administrator
	Username *string `json:"username,omitempty"`
	// Password - Plain text password of Active Directory domain administrator, value is masked in the response
	Password *string `json:"password,omitempty"`
	// Domain - Name of the Active Directory domain
	Domain *string `json:"domain,omitempty"`
	// DNS - Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
	DNS *string `json:"dns,omitempty"`
	// Status - Status of the Active Directory
	Status *string `json:"status,omitempty"`
	// SmbServerName - NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
	SmbServerName *string `json:"smbServerName,omitempty"`
	// OrganizationalUnit - The Organizational Unit (OU) within the Windows Active Directory
	OrganizationalUnit *string `json:"organizationalUnit,omitempty"`
	// Site - The Active Directory site the service will limit Domain Controller discovery to
	Site *string `json:"site,omitempty"`
	// BackupOperators - Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
	BackupOperators *[]string `json:"backupOperators,omitempty"`
	// KdcIP - kdc server IP addresses for the active directory machine. This optional parameter is used only while creating kerberos volume.
	KdcIP *string `json:"kdcIP,omitempty"`
	// AdName - Name of the active directory machine. This optional parameter is used only while creating kerberos volume
	AdName *string `json:"adName,omitempty"`
}

// AuthorizeRequest authorize request
type AuthorizeRequest struct {
	// RemoteVolumeResourceID - Resource id of the remote volume
	RemoteVolumeResourceID *string `json:"remoteVolumeResourceId,omitempty"`
}

// Backup backup of a Volume
type Backup struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// BackupProperties - Backup Properties
	*BackupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Backup.
func (b Backup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.Location != nil {
		objectMap["location"] = b.Location
	}
	if b.BackupProperties != nil {
		objectMap["properties"] = b.BackupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Backup struct.
func (b *Backup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				b.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var backupProperties BackupProperties
				err = json.Unmarshal(*v, &backupProperties)
				if err != nil {
					return err
				}
				b.BackupProperties = &backupProperties
			}
		}
	}

	return nil
}

// BackupPatch backup patch
type BackupPatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// BackupProperties - Backup Properties
	*BackupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPatch.
func (bp BackupPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.Tags != nil {
		objectMap["tags"] = bp.Tags
	}
	if bp.BackupProperties != nil {
		objectMap["properties"] = bp.BackupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupPatch struct.
func (bp *BackupPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bp.Tags = tags
			}
		case "properties":
			if v != nil {
				var backupProperties BackupProperties
				err = json.Unmarshal(*v, &backupProperties)
				if err != nil {
					return err
				}
				bp.BackupProperties = &backupProperties
			}
		}
	}

	return nil
}

// BackupPoliciesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupPoliciesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupPoliciesClient) (BackupPolicy, error)
}

// BackupPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupPoliciesClient) (autorest.Response, error)
}

// BackupPoliciesList list of Backup Policies
type BackupPoliciesList struct {
	autorest.Response `json:"-"`
	// Value - A list of backup policies
	Value *[]BackupPolicy `json:"value,omitempty"`
}

// BackupPolicy backup policy information
type BackupPolicy struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// BackupPolicyProperties - Backup policy Properties
	*BackupPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPolicy.
func (bp BackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.Location != nil {
		objectMap["location"] = bp.Location
	}
	if bp.Tags != nil {
		objectMap["tags"] = bp.Tags
	}
	if bp.BackupPolicyProperties != nil {
		objectMap["properties"] = bp.BackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupPolicy struct.
func (bp *BackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bp.Tags = tags
			}
		case "properties":
			if v != nil {
				var backupPolicyProperties BackupPolicyProperties
				err = json.Unmarshal(*v, &backupPolicyProperties)
				if err != nil {
					return err
				}
				bp.BackupPolicyProperties = &backupPolicyProperties
			}
		}
	}

	return nil
}

// BackupPolicyDetails backup policy properties
type BackupPolicyDetails struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// BackupPolicyProperties - Backup policy Properties
	*BackupPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPolicyDetails.
func (bpd BackupPolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bpd.Location != nil {
		objectMap["location"] = bpd.Location
	}
	if bpd.Tags != nil {
		objectMap["tags"] = bpd.Tags
	}
	if bpd.BackupPolicyProperties != nil {
		objectMap["properties"] = bpd.BackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupPolicyDetails struct.
func (bpd *BackupPolicyDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bpd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bpd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bpd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bpd.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				bpd.Tags = tags
			}
		case "properties":
			if v != nil {
				var backupPolicyProperties BackupPolicyProperties
				err = json.Unmarshal(*v, &backupPolicyProperties)
				if err != nil {
					return err
				}
				bpd.BackupPolicyProperties = &backupPolicyProperties
			}
		}
	}

	return nil
}

// BackupPolicyPatch backup policy Details for create and update
type BackupPolicyPatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// BackupPolicyProperties - Backup policy Properties
	*BackupPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPolicyPatch.
func (bpp BackupPolicyPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bpp.Location != nil {
		objectMap["location"] = bpp.Location
	}
	if bpp.BackupPolicyProperties != nil {
		objectMap["properties"] = bpp.BackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupPolicyPatch struct.
func (bpp *BackupPolicyPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bpp.Location = &location
			}
		case "properties":
			if v != nil {
				var backupPolicyProperties BackupPolicyProperties
				err = json.Unmarshal(*v, &backupPolicyProperties)
				if err != nil {
					return err
				}
				bpp.BackupPolicyProperties = &backupPolicyProperties
			}
		}
	}

	return nil
}

// BackupPolicyProperties backup policy properties
type BackupPolicyProperties struct {
	// Name - READ-ONLY; Name of backup policy
	Name *string `json:"name,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// DailyBackupsToKeep - Daily backups count to keep
	DailyBackupsToKeep *int32 `json:"dailyBackupsToKeep,omitempty"`
	// WeeklyBackupsToKeep - Weekly backups count to keep
	WeeklyBackupsToKeep *int32 `json:"weeklyBackupsToKeep,omitempty"`
	// MonthlyBackupsToKeep - Monthly backups count to keep
	MonthlyBackupsToKeep *int32 `json:"monthlyBackupsToKeep,omitempty"`
	// YearlyBackupsToKeep - Yearly backups count to keep
	YearlyBackupsToKeep *int32 `json:"yearlyBackupsToKeep,omitempty"`
	// VolumesAssigned - Volumes using current backup policy
	VolumesAssigned *int32 `json:"volumesAssigned,omitempty"`
	// Enabled - The property to decide policy is enabled or not
	Enabled *bool `json:"enabled,omitempty"`
	// VolumeBackups - A list of volumes assigned to this policy
	VolumeBackups *[]VolumeBackups `json:"volumeBackups,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupPolicyProperties.
func (bpp BackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bpp.DailyBackupsToKeep != nil {
		objectMap["dailyBackupsToKeep"] = bpp.DailyBackupsToKeep
	}
	if bpp.WeeklyBackupsToKeep != nil {
		objectMap["weeklyBackupsToKeep"] = bpp.WeeklyBackupsToKeep
	}
	if bpp.MonthlyBackupsToKeep != nil {
		objectMap["monthlyBackupsToKeep"] = bpp.MonthlyBackupsToKeep
	}
	if bpp.YearlyBackupsToKeep != nil {
		objectMap["yearlyBackupsToKeep"] = bpp.YearlyBackupsToKeep
	}
	if bpp.VolumesAssigned != nil {
		objectMap["volumesAssigned"] = bpp.VolumesAssigned
	}
	if bpp.Enabled != nil {
		objectMap["enabled"] = bpp.Enabled
	}
	if bpp.VolumeBackups != nil {
		objectMap["volumeBackups"] = bpp.VolumeBackups
	}
	return json.Marshal(objectMap)
}

// BackupProperties backup properties
type BackupProperties struct {
	// CreationDate - READ-ONLY; The creation date of the backup
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Size - READ-ONLY; Size of backup
	Size *int64 `json:"size,omitempty"`
	// Label - Label for backup
	Label *string `json:"label,omitempty"`
	// BackupType - READ-ONLY; Type of backup adhoc or scheduled
	BackupType *string `json:"backupType,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupProperties.
func (bp BackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.Label != nil {
		objectMap["label"] = bp.Label
	}
	return json.Marshal(objectMap)
}

// BackupsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupsClient) (Backup, error)
}

// BackupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type BackupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupsClient) (autorest.Response, error)
}

// BackupsList list of Backups
type BackupsList struct {
	autorest.Response `json:"-"`
	// Value - A list of Backups
	Value *[]Backup `json:"value,omitempty"`
}

// BreakReplicationRequest break replication request
type BreakReplicationRequest struct {
	// ForceBreakReplication - If replication is in status transferring and you want to force break the replication, set to true
	ForceBreakReplication *bool `json:"forceBreakReplication,omitempty"`
}

// CapacityPool capacity pool resource
type CapacityPool struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// PoolProperties - Capacity pool properties
	*PoolProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityPool.
func (cp CapacityPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Location != nil {
		objectMap["location"] = cp.Location
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	if cp.PoolProperties != nil {
		objectMap["properties"] = cp.PoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityPool struct.
func (cp *CapacityPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		case "properties":
			if v != nil {
				var poolProperties PoolProperties
				err = json.Unmarshal(*v, &poolProperties)
				if err != nil {
					return err
				}
				cp.PoolProperties = &poolProperties
			}
		}
	}

	return nil
}

// CapacityPoolList list of capacity pool resources
type CapacityPoolList struct {
	autorest.Response `json:"-"`
	// Value - List of Capacity pools
	Value *[]CapacityPool `json:"value,omitempty"`
}

// CapacityPoolPatch capacity pool patch resource
type CapacityPoolPatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// PoolPatchProperties - Capacity pool properties
	*PoolPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityPoolPatch.
func (cpp CapacityPoolPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.Location != nil {
		objectMap["location"] = cpp.Location
	}
	if cpp.Tags != nil {
		objectMap["tags"] = cpp.Tags
	}
	if cpp.PoolPatchProperties != nil {
		objectMap["properties"] = cpp.PoolPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityPoolPatch struct.
func (cpp *CapacityPoolPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cpp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cpp.Tags = tags
			}
		case "properties":
			if v != nil {
				var poolPatchProperties PoolPatchProperties
				err = json.Unmarshal(*v, &poolPatchProperties)
				if err != nil {
					return err
				}
				cpp.PoolPatchProperties = &poolPatchProperties
			}
		}
	}

	return nil
}

// CheckAvailabilityResponse information regarding availability of a resource.
type CheckAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// IsAvailable - <code>true</code> indicates name is valid and available. <code>false</code> indicates the name is invalid, unavailable, or both.
	IsAvailable *bool `json:"isAvailable,omitempty"`
	// Reason - <code>Invalid</code> indicates the name provided does not match Azure App Service naming requirements. <code>AlreadyExists</code> indicates that the name is already in use and is therefore unavailable. Possible values include: 'Invalid', 'AlreadyExists'
	Reason InAvailabilityReasonType `json:"reason,omitempty"`
	// Message - If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that resource name is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
}

// DailySchedule daily Schedule properties
type DailySchedule struct {
	// SnapshotsToKeep - Daily snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`
	// Hour - Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32 `json:"hour,omitempty"`
	// Minute - Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`
	// UsedBytes - Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}

// Dimension dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Name - Display name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
}

// ExportPolicyRule volume Export Policy Rule
type ExportPolicyRule struct {
	// RuleIndex - Order index
	RuleIndex *int32 `json:"ruleIndex,omitempty"`
	// UnixReadOnly - Read only access
	UnixReadOnly *bool `json:"unixReadOnly,omitempty"`
	// UnixReadWrite - Read and write access
	UnixReadWrite *bool `json:"unixReadWrite,omitempty"`
	// Kerberos5ReadOnly - Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5ReadOnly *bool `json:"kerberos5ReadOnly,omitempty"`
	// Kerberos5ReadWrite - Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5ReadWrite *bool `json:"kerberos5ReadWrite,omitempty"`
	// Kerberos5iReadOnly - Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5iReadOnly *bool `json:"kerberos5iReadOnly,omitempty"`
	// Kerberos5iReadWrite - Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5iReadWrite *bool `json:"kerberos5iReadWrite,omitempty"`
	// Kerberos5pReadOnly - Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5pReadOnly *bool `json:"kerberos5pReadOnly,omitempty"`
	// Kerberos5pReadWrite - Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5pReadWrite *bool `json:"kerberos5pReadWrite,omitempty"`
	// Cifs - Allows CIFS protocol
	Cifs *bool `json:"cifs,omitempty"`
	// Nfsv3 - Allows NFSv3 protocol. Enable only for NFSv3 type volumes
	Nfsv3 *bool `json:"nfsv3,omitempty"`
	// Nfsv41 - Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
	Nfsv41 *bool `json:"nfsv41,omitempty"`
	// AllowedClients - Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
	AllowedClients *string `json:"allowedClients,omitempty"`
	// HasRootAccess - Has root access to volume
	HasRootAccess *bool `json:"hasRootAccess,omitempty"`
}

// HourlySchedule hourly Schedule properties
type HourlySchedule struct {
	// SnapshotsToKeep - Hourly snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`
	// Minute - Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`
	// UsedBytes - Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Dimensions of blobs, including blob type and access tier.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// AggregationType - Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`
	// FillGapWithZero - The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
}

// MonthlySchedule monthly Schedule properties
type MonthlySchedule struct {
	// SnapshotsToKeep - Monthly snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`
	// DaysOfMonth - Indicates which days of the month snapshot should be taken. A comma delimited string.
	DaysOfMonth *string `json:"daysOfMonth,omitempty"`
	// Hour - Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32 `json:"hour,omitempty"`
	// Minute - Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`
	// UsedBytes - Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}

// MountTarget mount Target
type MountTarget struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// MountTargetProperties - Mount Target Properties
	*MountTargetProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MountTarget.
func (mt MountTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mt.Location != nil {
		objectMap["location"] = mt.Location
	}
	if mt.Tags != nil {
		objectMap["tags"] = mt.Tags
	}
	if mt.MountTargetProperties != nil {
		objectMap["properties"] = mt.MountTargetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MountTarget struct.
func (mt *MountTarget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mt.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mt.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mt.Tags = tags
			}
		case "properties":
			if v != nil {
				var mountTargetProperties MountTargetProperties
				err = json.Unmarshal(*v, &mountTargetProperties)
				if err != nil {
					return err
				}
				mt.MountTargetProperties = &mountTargetProperties
			}
		}
	}

	return nil
}

// MountTargetProperties mount target properties
type MountTargetProperties struct {
	// MountTargetID - READ-ONLY; UUID v4 used to identify the MountTarget
	MountTargetID *string `json:"mountTargetId,omitempty"`
	// FileSystemID - UUID v4 used to identify the MountTarget
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// IPAddress - READ-ONLY; The mount target's IPv4 address
	IPAddress *string `json:"ipAddress,omitempty"`
	// SmbServerFqdn - The SMB server's Fully Qualified Domain Name, FQDN
	SmbServerFqdn *string `json:"smbServerFqdn,omitempty"`
}

// MarshalJSON is the custom marshaler for MountTargetProperties.
func (mtp MountTargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mtp.FileSystemID != nil {
		objectMap["fileSystemId"] = mtp.FileSystemID
	}
	if mtp.SmbServerFqdn != nil {
		objectMap["smbServerFqdn"] = mtp.SmbServerFqdn
	}
	return json.Marshal(objectMap)
}

// Operation microsoft.NetApp REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft NetApp.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Cloud Volume operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PoolChangeRequest pool change request
type PoolChangeRequest struct {
	// NewPoolResourceID - Resource id of the pool to move volume to
	NewPoolResourceID *string `json:"newPoolResourceId,omitempty"`
}

// PoolPatchProperties patchable pool properties
type PoolPatchProperties struct {
	// Size - Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value must be multiply of 4398046511104).
	Size *int64 `json:"size,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Ultra'
	ServiceLevel PatchServiceLevel `json:"serviceLevel,omitempty"`
}

// PoolProperties pool properties
type PoolProperties struct {
	// PoolID - READ-ONLY; UUID v4 used to identify the Pool
	PoolID *string `json:"poolId,omitempty"`
	// Size - Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value must be multiply of 4398046511104).
	Size *int64 `json:"size,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'ServiceLevelStandard', 'ServiceLevelPremium', 'ServiceLevelUltra'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PoolProperties.
func (pp PoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Size != nil {
		objectMap["size"] = pp.Size
	}
	if pp.ServiceLevel != "" {
		objectMap["serviceLevel"] = pp.ServiceLevel
	}
	return json.Marshal(objectMap)
}

// PoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoolsClient) (CapacityPool, error)
}

// PoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoolsClient) (autorest.Response, error)
}

// PoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoolsClient) (CapacityPool, error)
}

// QuotaAvailabilityRequest quota availability request content.
type QuotaAvailabilityRequest struct {
	// Name - Name of the resource to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification. Possible values include: 'CheckQuotaNameResourceTypesMicrosoftNetAppnetAppAccounts', 'CheckQuotaNameResourceTypesMicrosoftNetAppnetAppAccountscapacityPools', 'CheckQuotaNameResourceTypesMicrosoftNetAppnetAppAccountscapacityPoolsvolumes', 'CheckQuotaNameResourceTypesMicrosoftNetAppnetAppAccountscapacityPoolsvolumessnapshots'
	Type CheckQuotaNameResourceTypes `json:"type,omitempty"`
	// ResourceGroup - Resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// ReplicationObject replication properties
type ReplicationObject struct {
	// ReplicationID - Id
	ReplicationID *string `json:"replicationId,omitempty"`
	// EndpointType - Indicates whether the local volume is the source or destination for the Volume Replication. Possible values include: 'Src', 'Dst'
	EndpointType EndpointType `json:"endpointType,omitempty"`
	// ReplicationSchedule - Schedule. Possible values include: '10minutely', 'Hourly', 'Daily'
	ReplicationSchedule ReplicationSchedule `json:"replicationSchedule,omitempty"`
	// RemoteVolumeResourceID - The resource ID of the remote volume.
	RemoteVolumeResourceID *string `json:"remoteVolumeResourceId,omitempty"`
	// RemoteVolumeRegion - The remote region for the other end of the Volume Replication.
	RemoteVolumeRegion *string `json:"remoteVolumeRegion,omitempty"`
}

// ReplicationStatus replication status
type ReplicationStatus struct {
	autorest.Response `json:"-"`
	// Healthy - Replication health check
	Healthy *bool `json:"healthy,omitempty"`
	// RelationshipStatus - Status of the mirror relationship. Possible values include: 'Idle', 'Transferring'
	RelationshipStatus RelationshipStatus `json:"relationshipStatus,omitempty"`
	// MirrorState - The status of the replication. Possible values include: 'Uninitialized', 'Mirrored', 'Broken'
	MirrorState MirrorState `json:"mirrorState,omitempty"`
	// TotalProgress - The progress of the replication
	TotalProgress *string `json:"totalProgress,omitempty"`
	// ErrorMessage - Displays error message if the replication is in an error state
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ResourceNameAvailabilityRequest resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification. Possible values include: 'MicrosoftNetAppnetAppAccounts', 'MicrosoftNetAppnetAppAccountscapacityPools', 'MicrosoftNetAppnetAppAccountscapacityPoolsvolumes', 'MicrosoftNetAppnetAppAccountscapacityPoolsvolumessnapshots'
	Type CheckNameResourceTypes `json:"type,omitempty"`
	// ResourceGroup - Resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// ServiceSpecification one property of operation, include metric specifications.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Snapshot snapshot of a Volume
type Snapshot struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// SnapshotProperties - Snapshot Properties
	*SnapshotProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.SnapshotProperties != nil {
		objectMap["properties"] = s.SnapshotProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Snapshot struct.
func (s *Snapshot) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var snapshotProperties SnapshotProperties
				err = json.Unmarshal(*v, &snapshotProperties)
				if err != nil {
					return err
				}
				s.SnapshotProperties = &snapshotProperties
			}
		}
	}

	return nil
}

// SnapshotPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotPoliciesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotPoliciesClient) (autorest.Response, error)
}

// SnapshotPoliciesList list of Snapshot Policies
type SnapshotPoliciesList struct {
	autorest.Response `json:"-"`
	// Value - A list of snapshot policies
	Value *[]SnapshotPolicy `json:"value,omitempty"`
}

// SnapshotPolicy snapshot policy information
type SnapshotPolicy struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// SnapshotPolicyProperties - Snapshot policy Properties
	*SnapshotPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotPolicy.
func (sp SnapshotPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Location != nil {
		objectMap["location"] = sp.Location
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	if sp.SnapshotPolicyProperties != nil {
		objectMap["properties"] = sp.SnapshotPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SnapshotPolicy struct.
func (sp *SnapshotPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sp.Tags = tags
			}
		case "properties":
			if v != nil {
				var snapshotPolicyProperties SnapshotPolicyProperties
				err = json.Unmarshal(*v, &snapshotPolicyProperties)
				if err != nil {
					return err
				}
				sp.SnapshotPolicyProperties = &snapshotPolicyProperties
			}
		}
	}

	return nil
}

// SnapshotPolicyDetails snapshot policy properties
type SnapshotPolicyDetails struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// SnapshotPolicyProperties - Snapshot policy Properties
	*SnapshotPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotPolicyDetails.
func (spd SnapshotPolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spd.Location != nil {
		objectMap["location"] = spd.Location
	}
	if spd.Tags != nil {
		objectMap["tags"] = spd.Tags
	}
	if spd.SnapshotPolicyProperties != nil {
		objectMap["properties"] = spd.SnapshotPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SnapshotPolicyDetails struct.
func (spd *SnapshotPolicyDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				spd.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spd.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				spd.Tags = tags
			}
		case "properties":
			if v != nil {
				var snapshotPolicyProperties SnapshotPolicyProperties
				err = json.Unmarshal(*v, &snapshotPolicyProperties)
				if err != nil {
					return err
				}
				spd.SnapshotPolicyProperties = &snapshotPolicyProperties
			}
		}
	}

	return nil
}

// SnapshotPolicyPatch snapshot policy Details for create and update
type SnapshotPolicyPatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// SnapshotPolicyProperties - Snapshot Policy properties
	*SnapshotPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotPolicyPatch.
func (spp SnapshotPolicyPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.Location != nil {
		objectMap["location"] = spp.Location
	}
	if spp.Tags != nil {
		objectMap["tags"] = spp.Tags
	}
	if spp.SnapshotPolicyProperties != nil {
		objectMap["properties"] = spp.SnapshotPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SnapshotPolicyPatch struct.
func (spp *SnapshotPolicyPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				spp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				spp.Tags = tags
			}
		case "properties":
			if v != nil {
				var snapshotPolicyProperties SnapshotPolicyProperties
				err = json.Unmarshal(*v, &snapshotPolicyProperties)
				if err != nil {
					return err
				}
				spp.SnapshotPolicyProperties = &snapshotPolicyProperties
			}
		}
	}

	return nil
}

// SnapshotPolicyProperties snapshot policy properties
type SnapshotPolicyProperties struct {
	// Name - READ-ONLY; Snapshot policy name
	Name *string `json:"name,omitempty"`
	// HourlySchedule - Schedule for hourly snapshots
	HourlySchedule *HourlySchedule `json:"hourlySchedule,omitempty"`
	// DailySchedule - Schedule for daily snapshots
	DailySchedule *DailySchedule `json:"dailySchedule,omitempty"`
	// WeeklySchedule - Schedule for weekly snapshots
	WeeklySchedule *WeeklySchedule `json:"weeklySchedule,omitempty"`
	// MonthlySchedule - Schedule for monthly snapshots
	MonthlySchedule *MonthlySchedule `json:"monthlySchedule,omitempty"`
	// Enabled - The property to decide policy is enabled or not
	Enabled *bool `json:"enabled,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotPolicyProperties.
func (spp SnapshotPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.HourlySchedule != nil {
		objectMap["hourlySchedule"] = spp.HourlySchedule
	}
	if spp.DailySchedule != nil {
		objectMap["dailySchedule"] = spp.DailySchedule
	}
	if spp.WeeklySchedule != nil {
		objectMap["weeklySchedule"] = spp.WeeklySchedule
	}
	if spp.MonthlySchedule != nil {
		objectMap["monthlySchedule"] = spp.MonthlySchedule
	}
	if spp.Enabled != nil {
		objectMap["enabled"] = spp.Enabled
	}
	return json.Marshal(objectMap)
}

// SnapshotPolicyVolumeList volumes associated with snapshot policy
type SnapshotPolicyVolumeList struct {
	autorest.Response `json:"-"`
	// Value - List of volumes
	Value *[]interface{} `json:"value,omitempty"`
}

// SnapshotProperties snapshot properties
type SnapshotProperties struct {
	// SnapshotID - READ-ONLY; UUID v4 used to identify the Snapshot
	SnapshotID *string `json:"snapshotId,omitempty"`
	// Created - READ-ONLY; The creation date of the snapshot
	Created *date.Time `json:"created,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SnapshotsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (Snapshot, error)
}

// SnapshotsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (autorest.Response, error)
}

// SnapshotsList list of Snapshots
type SnapshotsList struct {
	autorest.Response `json:"-"`
	// Value - A list of Snapshots
	Value *[]Snapshot `json:"value,omitempty"`
}

// SnapshotsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SnapshotsClient) (Snapshot, error)
}

// Vault vault information
type Vault struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// VaultProperties - Vault Properties
	*VaultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Vault.
func (vVar Vault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.VaultProperties != nil {
		objectMap["properties"] = vVar.VaultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Vault struct.
func (vVar *Vault) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var vaultProperties VaultProperties
				err = json.Unmarshal(*v, &vaultProperties)
				if err != nil {
					return err
				}
				vVar.VaultProperties = &vaultProperties
			}
		}
	}

	return nil
}

// VaultList list of Vaults
type VaultList struct {
	autorest.Response `json:"-"`
	// Value - A list of vaults
	Value *[]Vault `json:"value,omitempty"`
}

// VaultProperties vault properties
type VaultProperties struct {
	// VaultName - Vault Name
	VaultName *string `json:"vaultName,omitempty"`
}

// Volume volume resource
type Volume struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// VolumeProperties - Volume properties
	*VolumeProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Volume.
func (vVar Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	if vVar.VolumeProperties != nil {
		objectMap["properties"] = vVar.VolumeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Volume struct.
func (vVar *Volume) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vVar.Tags = tags
			}
		case "properties":
			if v != nil {
				var volumeProperties VolumeProperties
				err = json.Unmarshal(*v, &volumeProperties)
				if err != nil {
					return err
				}
				vVar.VolumeProperties = &volumeProperties
			}
		}
	}

	return nil
}

// VolumeBackupProperties volume Backup Properties
type VolumeBackupProperties struct {
	// BackupPolicyID - Backup Policy Resource ID
	BackupPolicyID *string `json:"backupPolicyId,omitempty"`
	// PolicyEnforced - Policy Enforced
	PolicyEnforced *bool `json:"policyEnforced,omitempty"`
	// VaultID - Vault Resource ID
	VaultID *string `json:"vaultId,omitempty"`
	// BackupEnabled - Backup Enabled
	BackupEnabled *bool `json:"backupEnabled,omitempty"`
}

// VolumeBackups volume details using the backup policy
type VolumeBackups struct {
	// VolumeName - Volume name
	VolumeName *string `json:"volumeName,omitempty"`
	// BackupsCount - Total count of backups for volume
	BackupsCount *int32 `json:"backupsCount,omitempty"`
	// PolicyEnabled - Policy enabled
	PolicyEnabled *bool `json:"policyEnabled,omitempty"`
}

// VolumeList list of volume resources
type VolumeList struct {
	autorest.Response `json:"-"`
	// Value - List of volumes
	Value *[]Volume `json:"value,omitempty"`
}

// VolumePatch volume patch resource
type VolumePatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// VolumePatchProperties - Patchable volume properties
	*VolumePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumePatch.
func (vp VolumePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.Location != nil {
		objectMap["location"] = vp.Location
	}
	if vp.Tags != nil {
		objectMap["tags"] = vp.Tags
	}
	if vp.VolumePatchProperties != nil {
		objectMap["properties"] = vp.VolumePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VolumePatch struct.
func (vp *VolumePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vp.Tags = tags
			}
		case "properties":
			if v != nil {
				var volumePatchProperties VolumePatchProperties
				err = json.Unmarshal(*v, &volumePatchProperties)
				if err != nil {
					return err
				}
				vp.VolumePatchProperties = &volumePatchProperties
			}
		}
	}

	return nil
}

// VolumePatchProperties patchable volume properties
type VolumePatchProperties struct {
	// ServiceLevel - The service level of the file system. Possible values include: 'ServiceLevelStandard', 'ServiceLevelPremium', 'ServiceLevelUltra'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// UsageThreshold - Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`
	// ExportPolicy - Set of export policy rules
	ExportPolicy *VolumePatchPropertiesExportPolicy `json:"exportPolicy,omitempty"`
	// DataProtection - DataProtection type volumes include an object containing details of the replication
	DataProtection *VolumePatchPropertiesDataProtection `json:"dataProtection,omitempty"`
}

// VolumePatchPropertiesDataProtection dataProtection type volumes include an object containing details of
// the replication
type VolumePatchPropertiesDataProtection struct {
	// Backup - Backup Properties
	Backup *VolumeBackupProperties `json:"backup,omitempty"`
}

// VolumePatchPropertiesExportPolicy set of export policy rules
type VolumePatchPropertiesExportPolicy struct {
	// Rules - Export policy rule
	Rules *[]ExportPolicyRule `json:"rules,omitempty"`
}

// VolumeProperties volume properties
type VolumeProperties struct {
	// FileSystemID - READ-ONLY; Unique FileSystem Identifier.
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// CreationToken - A unique file path for the volume. Used when creating mount targets
	CreationToken *string `json:"creationToken,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'ServiceLevelStandard', 'ServiceLevelPremium', 'ServiceLevelUltra'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// UsageThreshold - Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in bytes.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`
	// ExportPolicy - Set of export policy rules
	ExportPolicy *VolumePropertiesExportPolicy `json:"exportPolicy,omitempty"`
	// ProtocolTypes - Set of protocol types
	ProtocolTypes *[]string `json:"protocolTypes,omitempty"`
	// ProvisioningState - READ-ONLY; Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SnapshotID - UUID v4 or resource identifier used to identify the Snapshot.
	SnapshotID *string `json:"snapshotId,omitempty"`
	// BackupID - UUID v4 or resource identifier used to identify the Backup.
	BackupID *string `json:"backupId,omitempty"`
	// BaremetalTenantID - READ-ONLY; Unique Baremetal Tenant Identifier.
	BaremetalTenantID *string `json:"baremetalTenantId,omitempty"`
	// SubnetID - The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
	SubnetID *string `json:"subnetId,omitempty"`
	// MountTargets - List of mount targets
	MountTargets *[]MountTargetProperties `json:"mountTargets,omitempty"`
	// VolumeType - What type of volume is this
	VolumeType *string `json:"volumeType,omitempty"`
	// DataProtection - DataProtection type volumes include an object containing details of the replication
	DataProtection *VolumePropertiesDataProtection `json:"dataProtection,omitempty"`
	// IsRestoring - Restoring
	IsRestoring *bool `json:"isRestoring,omitempty"`
	// SnapshotDirectoryVisible - If enabled (true) the volume will contain a read-only .snapshot directory which provides access to each of the volume's snapshots (default to true).
	SnapshotDirectoryVisible *bool `json:"snapshotDirectoryVisible,omitempty"`
	// KerberosEnabled - Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
	KerberosEnabled *bool `json:"kerberosEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumeProperties.
func (vp VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.CreationToken != nil {
		objectMap["creationToken"] = vp.CreationToken
	}
	if vp.ServiceLevel != "" {
		objectMap["serviceLevel"] = vp.ServiceLevel
	}
	if vp.UsageThreshold != nil {
		objectMap["usageThreshold"] = vp.UsageThreshold
	}
	if vp.ExportPolicy != nil {
		objectMap["exportPolicy"] = vp.ExportPolicy
	}
	if vp.ProtocolTypes != nil {
		objectMap["protocolTypes"] = vp.ProtocolTypes
	}
	if vp.SnapshotID != nil {
		objectMap["snapshotId"] = vp.SnapshotID
	}
	if vp.BackupID != nil {
		objectMap["backupId"] = vp.BackupID
	}
	if vp.SubnetID != nil {
		objectMap["subnetId"] = vp.SubnetID
	}
	if vp.MountTargets != nil {
		objectMap["mountTargets"] = vp.MountTargets
	}
	if vp.VolumeType != nil {
		objectMap["volumeType"] = vp.VolumeType
	}
	if vp.DataProtection != nil {
		objectMap["dataProtection"] = vp.DataProtection
	}
	if vp.IsRestoring != nil {
		objectMap["isRestoring"] = vp.IsRestoring
	}
	if vp.SnapshotDirectoryVisible != nil {
		objectMap["snapshotDirectoryVisible"] = vp.SnapshotDirectoryVisible
	}
	if vp.KerberosEnabled != nil {
		objectMap["kerberosEnabled"] = vp.KerberosEnabled
	}
	return json.Marshal(objectMap)
}

// VolumePropertiesDataProtection dataProtection type volumes include an object containing details of the
// replication
type VolumePropertiesDataProtection struct {
	// Backup - Backup Properties
	Backup *VolumeBackupProperties `json:"backup,omitempty"`
	// Replication - Replication properties
	Replication *ReplicationObject `json:"replication,omitempty"`
	// Snapshot - Snapshot properties.
	Snapshot *VolumeSnapshotProperties `json:"snapshot,omitempty"`
}

// VolumePropertiesExportPolicy set of export policy rules
type VolumePropertiesExportPolicy struct {
	// Rules - Export policy rule
	Rules *[]ExportPolicyRule `json:"rules,omitempty"`
}

// VolumeRevert revert a volume to the snapshot
type VolumeRevert struct {
	// SnapshotID - Resource id of the snapshot
	SnapshotID *string `json:"snapshotId,omitempty"`
}

// VolumesAuthorizeReplicationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VolumesAuthorizeReplicationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumesBreakReplicationFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesBreakReplicationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (Volume, error)
}

// VolumesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumesDeleteReplicationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VolumesDeleteReplicationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumeSnapshotProperties volume Snapshot Properties
type VolumeSnapshotProperties struct {
	// SnapshotPolicyID - Snapshot Policy ResourceId
	SnapshotPolicyID *string `json:"snapshotPolicyId,omitempty"`
}

// VolumesPoolChangeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesPoolChangeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumesReInitializeReplicationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VolumesReInitializeReplicationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumesResyncReplicationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VolumesResyncReplicationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumesRevertFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesRevertFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (autorest.Response, error)
}

// VolumesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VolumesClient) (Volume, error)
}

// WeeklySchedule weekly Schedule properties, make a snapshot every week at a specific day or days
type WeeklySchedule struct {
	// SnapshotsToKeep - Weekly snapshot count to keep
	SnapshotsToKeep *int32 `json:"snapshotsToKeep,omitempty"`
	// Day - Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
	Day *string `json:"day,omitempty"`
	// Hour - Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32 `json:"hour,omitempty"`
	// Minute - Indicates which minute snapshot should be taken
	Minute *int32 `json:"minute,omitempty"`
	// UsedBytes - Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64 `json:"usedBytes,omitempty"`
}
